// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use glib_sys as glib;
use gstreamer_base_sys as gst_base;
use gstreamer_sys as gst;
use gstreamer_video_sys as gst_video;

mod manual;

pub use manual::*;

#[allow(unused_imports)]
use libc::{FILE, intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t};
#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};
#[allow(unused_imports)]
use std::ffi::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
};

#[allow(unused_imports)]
use glib::{GType, gboolean, gconstpointer, gpointer};

// Aliases
pub type GstVulkanHandleTypedef = u64;

// Enums
pub type GstVulkanBarrierFlags = c_int;
pub const GST_VULKAN_BARRIER_FLAG_NONE: GstVulkanBarrierFlags = 0;

pub type GstVulkanBarrierType = c_int;
pub const GST_VULKAN_BARRIER_NONE: GstVulkanBarrierType = 0;
pub const GST_VULKAN_BARRIER_TYPE_MEMORY: GstVulkanBarrierType = 1;
pub const GST_VULKAN_BARRIER_TYPE_BUFFER: GstVulkanBarrierType = 2;
pub const GST_VULKAN_BARRIER_TYPE_IMAGE: GstVulkanBarrierType = 3;

pub type GstVulkanError = c_int;
pub const GST_VULKAN_FAILED: GstVulkanError = 0;

pub type GstVulkanFormatScaling = c_int;
pub const GST_VULKAN_FORMAT_SCALING_UNORM: GstVulkanFormatScaling = 1;
pub const GST_VULKAN_FORMAT_SCALING_SNORM: GstVulkanFormatScaling = 2;
pub const GST_VULKAN_FORMAT_SCALING_USCALED: GstVulkanFormatScaling = 3;
pub const GST_VULKAN_FORMAT_SCALING_SSCALED: GstVulkanFormatScaling = 4;
pub const GST_VULKAN_FORMAT_SCALING_UINT: GstVulkanFormatScaling = 5;
pub const GST_VULKAN_FORMAT_SCALING_SINT: GstVulkanFormatScaling = 6;
pub const GST_VULKAN_FORMAT_SCALING_SRGB: GstVulkanFormatScaling = 7;

pub type GstVulkanHandleType = c_int;
pub const GST_VULKAN_HANDLE_TYPE_DESCRIPTOR_SET_LAYOUT: GstVulkanHandleType = 1;
pub const GST_VULKAN_HANDLE_TYPE_PIPELINE_LAYOUT: GstVulkanHandleType = 2;
pub const GST_VULKAN_HANDLE_TYPE_PIPELINE: GstVulkanHandleType = 3;
pub const GST_VULKAN_HANDLE_TYPE_RENDER_PASS: GstVulkanHandleType = 4;
pub const GST_VULKAN_HANDLE_TYPE_SAMPLER: GstVulkanHandleType = 5;
pub const GST_VULKAN_HANDLE_TYPE_FRAMEBUFFER: GstVulkanHandleType = 6;
pub const GST_VULKAN_HANDLE_TYPE_SHADER: GstVulkanHandleType = 7;
#[cfg(feature = "v1_24")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
pub const GST_VULKAN_HANDLE_TYPE_VIDEO_SESSION: GstVulkanHandleType = 8;
#[cfg(feature = "v1_24")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
pub const GST_VULKAN_HANDLE_TYPE_VIDEO_SESSION_PARAMETERS: GstVulkanHandleType = 9;
#[cfg(feature = "v1_24")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
pub const GST_VULKAN_HANDLE_TYPE_SAMPLER_YCBCR_CONVERSION: GstVulkanHandleType = 10;

pub type GstVulkanWindowError = c_int;
pub const GST_VULKAN_WINDOW_ERROR_FAILED: GstVulkanWindowError = 0;
pub const GST_VULKAN_WINDOW_ERROR_OLD_LIBS: GstVulkanWindowError = 1;
pub const GST_VULKAN_WINDOW_ERROR_RESOURCE_UNAVAILABLE: GstVulkanWindowError = 2;

// Constants
pub const GST_CAPS_FEATURE_MEMORY_VULKAN_BUFFER: &[u8] = b"memory:VulkanBuffer\0";
pub const GST_CAPS_FEATURE_MEMORY_VULKAN_IMAGE: &[u8] = b"memory:VulkanImage\0";
pub const GST_VULKAN_BUFFER_MEMORY_ALLOCATOR_NAME: &[u8] = b"VulkanBuffer\0";
pub const GST_VULKAN_DEVICE_CONTEXT_TYPE_STR: &[u8] = b"gst.vulkan.device\0";
pub const GST_VULKAN_DISPLAY_CONTEXT_TYPE_STR: &[u8] = b"gst.vulkan.display\0";
pub const GST_VULKAN_IMAGE_MEMORY_ALLOCATOR_NAME: &[u8] = b"VulkanImage\0";
pub const GST_VULKAN_INSTANCE_CONTEXT_TYPE_STR: &[u8] = b"gst.vulkan.instance\0";
pub const GST_VULKAN_MAX_COMPONENTS: c_int = 4;
pub const GST_VULKAN_MEMORY_ALLOCATOR_NAME: &[u8] = b"Vulkan\0";
pub const GST_VULKAN_QUEUE_CONTEXT_TYPE_STR: &[u8] = b"gst.vulkan.queue\0";
pub const GST_VULKAN_SWAPPER_VIDEO_FORMATS: &[u8] = b" { RGBA, BGRA, RGB, BGR } \0";

// Flags
pub type GstVulkanDisplayType = c_uint;
pub const GST_VULKAN_DISPLAY_TYPE_NONE: GstVulkanDisplayType = 0;
pub const GST_VULKAN_DISPLAY_TYPE_XCB: GstVulkanDisplayType = 1;
pub const GST_VULKAN_DISPLAY_TYPE_WAYLAND: GstVulkanDisplayType = 2;
pub const GST_VULKAN_DISPLAY_TYPE_COCOA: GstVulkanDisplayType = 4;
pub const GST_VULKAN_DISPLAY_TYPE_IOS: GstVulkanDisplayType = 8;
pub const GST_VULKAN_DISPLAY_TYPE_WIN32: GstVulkanDisplayType = 16;
pub const GST_VULKAN_DISPLAY_TYPE_ANDROID: GstVulkanDisplayType = 32;
pub const GST_VULKAN_DISPLAY_TYPE_ANY: GstVulkanDisplayType = 4294967295;

pub type GstVulkanFormatFlags = c_uint;
pub const GST_VULKAN_FORMAT_FLAG_YUV: GstVulkanFormatFlags = 1;
pub const GST_VULKAN_FORMAT_FLAG_RGB: GstVulkanFormatFlags = 2;
pub const GST_VULKAN_FORMAT_FLAG_ALPHA: GstVulkanFormatFlags = 4;
pub const GST_VULKAN_FORMAT_FLAG_LE: GstVulkanFormatFlags = 8;
pub const GST_VULKAN_FORMAT_FLAG_COMPLEX: GstVulkanFormatFlags = 16;

// Callbacks
pub type GstVulkanDeviceForEachQueueFunc =
    Option<unsafe extern "C" fn(*mut GstVulkanDevice, *mut GstVulkanQueue, gpointer) -> gboolean>;
pub type GstVulkanHandleDestroyNotify =
    Option<unsafe extern "C" fn(*mut GstVulkanHandle, gpointer)>;
pub type GstVulkanImageMemoryFindViewFunc =
    Option<unsafe extern "C" fn(*mut GstVulkanImageView, gpointer) -> gboolean>;
pub type GstVulkanTrashListAdd =
    Option<unsafe extern "C" fn(*mut GstVulkanTrashList, *mut GstVulkanTrash) -> gboolean>;
pub type GstVulkanTrashListGC = Option<unsafe extern "C" fn(*mut GstVulkanTrashList)>;
pub type GstVulkanTrashListWait =
    Option<unsafe extern "C" fn(*mut GstVulkanTrashList, u64) -> gboolean>;
pub type GstVulkanTrashNotify = Option<unsafe extern "C" fn(*mut GstVulkanDevice, gpointer)>;

// Records
#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanBarrierBufferInfo {
    _truncated_record_marker: c_void,
    // /*Ignored*/field parent has incomplete type
}

impl ::std::fmt::Debug for GstVulkanBarrierBufferInfo {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanBarrierBufferInfo @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanBarrierImageInfo {
    _truncated_record_marker: c_void,
    // /*Ignored*/field parent has incomplete type
}

impl ::std::fmt::Debug for GstVulkanBarrierImageInfo {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanBarrierImageInfo @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanBarrierMemoryInfo {
    pub type_: GstVulkanBarrierType,
    pub flags: GstVulkanBarrierFlags,
    pub queue: *mut GstVulkanQueue,
    pub pipeline_stages: u64,
    pub access_flags: u64,
    _truncated_record_marker: c_void,
    // /*Ignored*/field semaphore has incomplete type
}

impl ::std::fmt::Debug for GstVulkanBarrierMemoryInfo {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanBarrierMemoryInfo @ {self:p}"))
            .field("type_", &self.type_)
            .field("flags", &self.flags)
            .field("queue", &self.queue)
            .field("pipeline_stages", &self.pipeline_stages)
            .field("access_flags", &self.access_flags)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanBufferMemory {
    pub parent: gst::GstMemory,
    pub device: *mut GstVulkanDevice,
    _truncated_record_marker: c_void,
    // /*Ignored*/field buffer has incomplete type
}

impl ::std::fmt::Debug for GstVulkanBufferMemory {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanBufferMemory @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanBufferMemoryAllocatorClass {
    pub parent_class: gst::GstAllocatorClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanBufferMemoryAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanBufferMemoryAllocatorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanBufferPoolClass {
    pub parent_class: gst::GstBufferPoolClass,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanBufferPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanBufferPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanBufferPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanBufferPoolPrivate = _GstVulkanBufferPoolPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanCommandBuffer {
    pub parent: gst::GstMiniObject,
    _truncated_record_marker: c_void,
    // /*Ignored*/field cmd has incomplete type
}

impl ::std::fmt::Debug for GstVulkanCommandBuffer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanCommandBuffer @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanCommandPoolClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanCommandPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanCommandPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanCommandPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanCommandPoolPrivate = _GstVulkanCommandPoolPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanDescriptorCacheClass {
    pub parent_class: GstVulkanHandlePoolClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanDescriptorCacheClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDescriptorCacheClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanDescriptorCachePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanDescriptorCachePrivate = _GstVulkanDescriptorCachePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanDescriptorPoolClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanDescriptorPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDescriptorPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanDescriptorPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanDescriptorPoolPrivate = _GstVulkanDescriptorPoolPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanDescriptorSet {
    pub parent: gst::GstMiniObject,
    _truncated_record_marker: c_void,
    // /*Ignored*/field set has incomplete type
}

impl ::std::fmt::Debug for GstVulkanDescriptorSet {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDescriptorSet @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanDeviceClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanDeviceClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDeviceClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanDevicePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanDevicePrivate = _GstVulkanDevicePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanDisplayClass {
    pub object_class: gst::GstObjectClass,
    pub get_handle: Option<unsafe extern "C" fn(*mut GstVulkanDisplay) -> gpointer>,
    pub create_window: Option<unsafe extern "C" fn(*mut GstVulkanDisplay) -> *mut GstVulkanWindow>,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanDisplayClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDisplayClass @ {self:p}"))
            .field("object_class", &self.object_class)
            .field("get_handle", &self.get_handle)
            .field("create_window", &self.create_window)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanDisplayPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanDisplayPrivate = _GstVulkanDisplayPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanEncodeQueryResult {
    pub offset: u32,
    pub data_size: u32,
    pub status: u32,
}

impl ::std::fmt::Debug for GstVulkanEncodeQueryResult {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanEncodeQueryResult @ {self:p}"))
            .field("offset", &self.offset)
            .field("data_size", &self.data_size)
            .field("status", &self.status)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanFence {
    pub parent: gst::GstMiniObject,
    pub device: *mut GstVulkanDevice,
    pub cache: *mut GstVulkanFenceCache,
    _truncated_record_marker: c_void,
    // /*Ignored*/field fence has incomplete type
}

impl ::std::fmt::Debug for GstVulkanFence {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanFence @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .field("cache", &self.cache)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanFenceCacheClass {
    pub parent_class: GstVulkanHandlePoolClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanFenceCacheClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanFenceCacheClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanFormatInfo {
    _truncated_record_marker: c_void,
    // /*Ignored*/field format has incomplete type
}

impl ::std::fmt::Debug for GstVulkanFormatInfo {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanFormatInfo @ {self:p}"))
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanFormatMap {
    pub format: gst_video::GstVideoFormat,
    _truncated_record_marker: c_void,
    // /*Ignored*/field vkfrmt has incomplete type
}

impl ::std::fmt::Debug for GstVulkanFormatMap {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanFormatMap @ {self:p}"))
            .field("format", &self.format)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanFullScreenQuadClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanFullScreenQuadClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanFullScreenQuadClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanFullScreenQuadPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanFullScreenQuadPrivate = _GstVulkanFullScreenQuadPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanHandle {
    pub parent: gst::GstMiniObject,
    pub device: *mut GstVulkanDevice,
    pub type_: GstVulkanHandleType,
    pub handle: GstVulkanHandleTypedef,
    pub notify: GstVulkanHandleDestroyNotify,
    pub user_data: gpointer,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanHandle {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanHandle @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .field("type_", &self.type_)
            .field("handle", &self.handle)
            .field("notify", &self.notify)
            .field("user_data", &self.user_data)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanHandlePoolClass {
    pub parent: gst::GstObjectClass,
    pub alloc:
        Option<unsafe extern "C" fn(*mut GstVulkanHandlePool, *mut *mut glib::GError) -> gpointer>,
    pub acquire:
        Option<unsafe extern "C" fn(*mut GstVulkanHandlePool, *mut *mut glib::GError) -> gpointer>,
    pub release: Option<unsafe extern "C" fn(*mut GstVulkanHandlePool, gpointer)>,
    pub free: Option<unsafe extern "C" fn(*mut GstVulkanHandlePool, gpointer)>,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanHandlePoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanHandlePoolClass @ {self:p}"))
            .field("parent", &self.parent)
            .field("alloc", &self.alloc)
            .field("acquire", &self.acquire)
            .field("release", &self.release)
            .field("free", &self.free)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanImageBufferPoolClass {
    pub parent_class: gst::GstBufferPoolClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanImageBufferPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanImageBufferPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanImageBufferPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanImageBufferPoolPrivate = _GstVulkanImageBufferPoolPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanImageMemory {
    pub parent: gst::GstMemory,
    pub device: *mut GstVulkanDevice,
    _truncated_record_marker: c_void,
    // /*Ignored*/field image has incomplete type
}

impl ::std::fmt::Debug for GstVulkanImageMemory {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanImageMemory @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanImageMemoryAllocatorClass {
    pub parent_class: gst::GstAllocatorClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanImageMemoryAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanImageMemoryAllocatorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanImageView {
    pub parent: gst::GstMiniObject,
    pub device: *mut GstVulkanDevice,
    pub image: *mut GstVulkanImageMemory,
    _truncated_record_marker: c_void,
    // /*Ignored*/field view has incomplete type
}

impl ::std::fmt::Debug for GstVulkanImageView {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanImageView @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .field("image", &self.image)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanInstanceClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanInstanceClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanInstanceClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanInstancePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanInstancePrivate = _GstVulkanInstancePrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanMemory {
    pub mem: gst::GstMemory,
    pub device: *mut GstVulkanDevice,
    _truncated_record_marker: c_void,
    // /*Ignored*/field mem_ptr has incomplete type
}

impl ::std::fmt::Debug for GstVulkanMemory {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanMemory @ {self:p}"))
            .field("mem", &self.mem)
            .field("device", &self.device)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanMemoryAllocatorClass {
    pub parent_class: gst::GstAllocatorClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanMemoryAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanMemoryAllocatorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanOperationClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanOperationClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanOperationClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanOperationPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanOperationPrivate = _GstVulkanOperationPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanPhysicalDeviceClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanPhysicalDeviceClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanPhysicalDeviceClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanPhysicalDevicePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanPhysicalDevicePrivate = _GstVulkanPhysicalDevicePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanQueueClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanQueueClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanQueueClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanQueueFamilyOps {
    pub video: u32,
    pub query_result_status: gboolean,
}

impl ::std::fmt::Debug for GstVulkanQueueFamilyOps {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanQueueFamilyOps @ {self:p}"))
            .field("video", &self.video)
            .field("query_result_status", &self.query_result_status)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanQueuePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanQueuePrivate = _GstVulkanQueuePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanSwapperClass {
    pub parent_class: gst::GstObjectClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanSwapperClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanSwapperClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanSwapperPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanSwapperPrivate = _GstVulkanSwapperPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanTrash {
    pub parent: gst::GstMiniObject,
    pub cache: *mut GstVulkanTrashList,
    pub fence: *mut GstVulkanFence,
    pub notify: GstVulkanTrashNotify,
    pub user_data: gpointer,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanTrash {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanTrash @ {self:p}"))
            .field("parent", &self.parent)
            .field("cache", &self.cache)
            .field("fence", &self.fence)
            .field("notify", &self.notify)
            .field("user_data", &self.user_data)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanTrashFenceListClass {
    pub parent_class: GstVulkanTrashListClass,
}

impl ::std::fmt::Debug for GstVulkanTrashFenceListClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanTrashFenceListClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanTrashListClass {
    pub parent_class: GstVulkanHandlePoolClass,
    pub add_func: GstVulkanTrashListAdd,
    pub gc_func: GstVulkanTrashListGC,
    pub wait_func: GstVulkanTrashListWait,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanTrashListClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanTrashListClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("add_func", &self.add_func)
            .field("gc_func", &self.gc_func)
            .field("wait_func", &self.wait_func)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanVideoFilterClass {
    pub parent_class: gst_base::GstBaseTransformClass,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanVideoFilterClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanVideoFilterClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanWindowClass {
    pub parent_class: gst::GstObjectClass,
    pub open:
        Option<unsafe extern "C" fn(*mut GstVulkanWindow, *mut *mut glib::GError) -> gboolean>,
    pub close: Option<unsafe extern "C" fn(*mut GstVulkanWindow)>,
    pub get_surface: Option<
        unsafe extern "C" fn(*mut GstVulkanWindow, *mut *mut glib::GError) -> vulkan::VkSurfaceKHR,
    >,
    pub get_presentation_support:
        Option<unsafe extern "C" fn(*mut GstVulkanWindow, *mut GstVulkanDevice, u32) -> gboolean>,
    pub set_window_handle: Option<unsafe extern "C" fn(*mut GstVulkanWindow, uintptr_t)>,
    pub get_surface_dimensions:
        Option<unsafe extern "C" fn(*mut GstVulkanWindow, *mut c_uint, *mut c_uint)>,
    pub handle_events: Option<unsafe extern "C" fn(*mut GstVulkanWindow, gboolean)>,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanWindowClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanWindowClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("open", &self.open)
            .field("close", &self.close)
            .field("get_surface", &self.get_surface)
            .field("get_presentation_support", &self.get_presentation_support)
            .field("set_window_handle", &self.set_window_handle)
            .field("get_surface_dimensions", &self.get_surface_dimensions)
            .field("handle_events", &self.handle_events)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstVulkanWindowPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstVulkanWindowPrivate = _GstVulkanWindowPrivate;

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanBufferMemoryAllocator {
    pub parent: gst::GstAllocator,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanBufferMemoryAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanBufferMemoryAllocator @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanBufferPool {
    pub bufferpool: gst::GstBufferPool,
    pub device: *mut GstVulkanDevice,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanBufferPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanBufferPool @ {self:p}"))
            .field("bufferpool", &self.bufferpool)
            .field("device", &self.device)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanCommandPool {
    pub parent: gst::GstObject,
    pub queue: *mut GstVulkanQueue,
    _truncated_record_marker: c_void,
    // /*Ignored*/field pool has incomplete type
}

impl ::std::fmt::Debug for GstVulkanCommandPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanCommandPool @ {self:p}"))
            .field("parent", &self.parent)
            .field("queue", &self.queue)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanDescriptorCache {
    pub parent: GstVulkanHandlePool,
    pub pool: *mut GstVulkanDescriptorPool,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanDescriptorCache {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDescriptorCache @ {self:p}"))
            .field("parent", &self.parent)
            .field("pool", &self.pool)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanDescriptorPool {
    pub parent: gst::GstObject,
    pub device: *mut GstVulkanDevice,
    _truncated_record_marker: c_void,
    // /*Ignored*/field pool has incomplete type
}

impl ::std::fmt::Debug for GstVulkanDescriptorPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDescriptorPool @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanDevice {
    pub parent: gst::GstObject,
    pub instance: *mut GstVulkanInstance,
    pub physical_device: *mut GstVulkanPhysicalDevice,
    _truncated_record_marker: c_void,
    // /*Ignored*/field device has incomplete type
}

impl ::std::fmt::Debug for GstVulkanDevice {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDevice @ {self:p}"))
            .field("parent", &self.parent)
            .field("instance", &self.instance)
            .field("physical_device", &self.physical_device)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanDisplay {
    pub object: gst::GstObject,
    pub type_: GstVulkanDisplayType,
    pub instance: *mut GstVulkanInstance,
    pub windows: *mut glib::GList,
    pub main_context: *mut glib::GMainContext,
    pub main_loop: *mut glib::GMainLoop,
    pub event_source: *mut glib::GSource,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanDisplay {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanDisplay @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanFenceCache {
    pub parent: GstVulkanHandlePool,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanFenceCache {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanFenceCache @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanFullScreenQuad {
    pub parent: gst::GstObject,
    pub out_info: gst_video::GstVideoInfo,
    pub in_info: gst_video::GstVideoInfo,
    pub queue: *mut GstVulkanQueue,
    pub render_pass: *mut GstVulkanHandle,
    pub pipeline_layout: *mut GstVulkanHandle,
    pub graphics_pipeline: *mut GstVulkanHandle,
    pub descriptor_set_layout: *mut GstVulkanHandle,
    pub descriptor_cache: *mut GstVulkanDescriptorCache,
    pub descriptor_set: *mut GstVulkanDescriptorSet,
    pub framebuffer: *mut GstVulkanHandle,
    pub sampler: *mut GstVulkanHandle,
    pub cmd_pool: *mut GstVulkanCommandPool,
    pub trash_list: *mut GstVulkanTrashList,
    pub last_fence: *mut GstVulkanFence,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanFullScreenQuad {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanFullScreenQuad @ {self:p}"))
            .field("parent", &self.parent)
            .field("out_info", &self.out_info)
            .field("in_info", &self.in_info)
            .field("queue", &self.queue)
            .field("render_pass", &self.render_pass)
            .field("pipeline_layout", &self.pipeline_layout)
            .field("graphics_pipeline", &self.graphics_pipeline)
            .field("descriptor_set_layout", &self.descriptor_set_layout)
            .field("descriptor_cache", &self.descriptor_cache)
            .field("descriptor_set", &self.descriptor_set)
            .field("framebuffer", &self.framebuffer)
            .field("sampler", &self.sampler)
            .field("cmd_pool", &self.cmd_pool)
            .field("trash_list", &self.trash_list)
            .field("last_fence", &self.last_fence)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanHandlePool {
    pub parent: gst::GstObject,
    pub device: *mut GstVulkanDevice,
    pub outstanding: *mut glib::GPtrArray,
    pub available: *mut glib::GPtrArray,
    pub _padding: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanHandlePool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanHandlePool @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .field("outstanding", &self.outstanding)
            .field("available", &self.available)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanImageBufferPool {
    pub bufferpool: gst::GstBufferPool,
    pub device: *mut GstVulkanDevice,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanImageBufferPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanImageBufferPool @ {self:p}"))
            .field("bufferpool", &self.bufferpool)
            .field("device", &self.device)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanImageMemoryAllocator {
    pub parent: gst::GstAllocator,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanImageMemoryAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanImageMemoryAllocator @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanInstance {
    pub parent: gst::GstObject,
    _truncated_record_marker: c_void,
    // /*Ignored*/field instance has incomplete type
}

impl ::std::fmt::Debug for GstVulkanInstance {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanInstance @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanMemoryAllocator {
    pub parent: gst::GstAllocator,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanMemoryAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanMemoryAllocator @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanOperation {
    pub parent: gst::GstObject,
    pub cmd_buf: *mut GstVulkanCommandBuffer,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanOperation {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanOperation @ {self:p}"))
            .field("parent", &self.parent)
            .field("cmd_buf", &self.cmd_buf)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanPhysicalDevice {
    pub parent: gst::GstObject,
    pub instance: *mut GstVulkanInstance,
    pub device_index: c_uint,
    _truncated_record_marker: c_void,
    // /*Ignored*/field device has incomplete type
}

impl ::std::fmt::Debug for GstVulkanPhysicalDevice {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanPhysicalDevice @ {self:p}"))
            .field("parent", &self.parent)
            .field("instance", &self.instance)
            .field("device_index", &self.device_index)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanQueue {
    pub parent: gst::GstObject,
    pub device: *mut GstVulkanDevice,
    _truncated_record_marker: c_void,
    // /*Ignored*/field queue has incomplete type
}

impl ::std::fmt::Debug for GstVulkanQueue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanQueue @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanSwapper {
    pub parent: gst::GstObject,
    pub device: *mut GstVulkanDevice,
    pub window: *mut GstVulkanWindow,
    pub queue: *mut GstVulkanQueue,
    pub cmd_pool: *mut GstVulkanCommandPool,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanSwapper {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanSwapper @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .field("window", &self.window)
            .field("queue", &self.queue)
            .field("cmd_pool", &self.cmd_pool)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct GstVulkanTrashFenceList {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstVulkanTrashFenceList {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanTrashFenceList @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanTrashList {
    pub parent: GstVulkanHandlePool,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanTrashList {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanTrashList @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanVideoFilter {
    pub parent: gst_base::GstBaseTransform,
    pub instance: *mut GstVulkanInstance,
    pub device: *mut GstVulkanDevice,
    pub queue: *mut GstVulkanQueue,
    pub in_caps: *mut gst::GstCaps,
    pub in_info: gst_video::GstVideoInfo,
    pub out_caps: *mut gst::GstCaps,
    pub out_info: gst_video::GstVideoInfo,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanVideoFilter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanVideoFilter @ {self:p}"))
            .field("parent", &self.parent)
            .field("instance", &self.instance)
            .field("device", &self.device)
            .field("queue", &self.queue)
            .field("in_caps", &self.in_caps)
            .field("in_info", &self.in_info)
            .field("out_caps", &self.out_caps)
            .field("out_info", &self.out_info)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstVulkanWindow {
    pub parent: gst::GstObject,
    pub display: *mut GstVulkanDisplay,
    pub _reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstVulkanWindow {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstVulkanWindow @ {self:p}"))
            .finish()
    }
}

unsafe extern "C" {

    //=========================================================================
    // GstVulkanBarrierFlags
    //=========================================================================
    pub fn gst_vulkan_barrier_flags_get_type() -> GType;

    //=========================================================================
    // GstVulkanBarrierType
    //=========================================================================
    pub fn gst_vulkan_barrier_type_get_type() -> GType;

    //=========================================================================
    // GstVulkanError
    //=========================================================================
    pub fn gst_vulkan_error_get_type() -> GType;
    pub fn gst_vulkan_error_quark() -> glib::GQuark;
    pub fn gst_vulkan_error_to_g_error(
        result: vulkan::VkResult,
        error: *mut *mut glib::GError,
        format: *const c_char,
        ...
    ) -> vulkan::VkResult;

    //=========================================================================
    // GstVulkanFormatScaling
    //=========================================================================
    pub fn gst_vulkan_format_scaling_get_type() -> GType;

    //=========================================================================
    // GstVulkanHandleType
    //=========================================================================
    pub fn gst_vulkan_handle_type_get_type() -> GType;

    //=========================================================================
    // GstVulkanWindowError
    //=========================================================================
    pub fn gst_vulkan_window_error_get_type() -> GType;
    pub fn gst_vulkan_window_error_quark() -> glib::GQuark;

    //=========================================================================
    // GstVulkanDisplayType
    //=========================================================================
    pub fn gst_vulkan_display_type_get_type() -> GType;
    pub fn gst_vulkan_display_type_to_extension_string(
        type_: GstVulkanDisplayType,
    ) -> *const c_char;

    //=========================================================================
    // GstVulkanFormatFlags
    //=========================================================================
    pub fn gst_vulkan_format_flags_get_type() -> GType;

    //=========================================================================
    // GstVulkanBufferMemory
    //=========================================================================
    pub fn gst_vulkan_buffer_memory_alloc(
        device: *mut GstVulkanDevice,
        size: size_t,
        usage: vulkan::VkBufferUsageFlags,
        mem_prop_flags: vulkan::VkMemoryPropertyFlags,
    ) -> *mut gst::GstMemory;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_buffer_memory_alloc_with_buffer_info(
        device: *mut GstVulkanDevice,
        buffer_info: *const vulkan::VkBufferCreateInfo,
        mem_prop_flags: vulkan::VkMemoryPropertyFlags,
    ) -> *mut gst::GstMemory;
    pub fn gst_vulkan_buffer_memory_init_once();
    pub fn gst_vulkan_buffer_memory_wrapped(
        device: *mut GstVulkanDevice,
        buffer: vulkan::VkBuffer,
        usage: vulkan::VkBufferUsageFlags,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> *mut gst::GstMemory;

    //=========================================================================
    // GstVulkanCommandBuffer
    //=========================================================================
    pub fn gst_vulkan_command_buffer_get_type() -> GType;
    pub fn gst_vulkan_command_buffer_new_wrapped(
        cmd: vulkan::VkCommandBuffer,
        level: vulkan::VkCommandBufferLevel,
    ) -> *mut GstVulkanCommandBuffer;
    pub fn gst_vulkan_command_buffer_ref(
        cmd: *mut GstVulkanCommandBuffer,
    ) -> *mut GstVulkanCommandBuffer;

    //=========================================================================
    // GstVulkanDescriptorSet
    //=========================================================================
    pub fn gst_vulkan_descriptor_set_get_type() -> GType;
    pub fn gst_vulkan_descriptor_set_new_wrapped(
        pool: *mut GstVulkanDescriptorPool,
        set: vulkan::VkDescriptorSet,
        n_layouts: c_uint,
        layouts: *mut *mut GstVulkanHandle,
    ) -> *mut GstVulkanDescriptorSet;
    pub fn gst_vulkan_descriptor_set_ref(
        set: *mut GstVulkanDescriptorSet,
    ) -> *mut GstVulkanDescriptorSet;

    //=========================================================================
    // GstVulkanFence
    //=========================================================================
    pub fn gst_vulkan_fence_get_type() -> GType;
    pub fn gst_vulkan_fence_new(
        device: *mut GstVulkanDevice,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanFence;
    pub fn gst_vulkan_fence_new_always_signalled(
        device: *mut GstVulkanDevice,
    ) -> *mut GstVulkanFence;
    pub fn gst_vulkan_fence_is_signaled(fence: *mut GstVulkanFence) -> gboolean;
    pub fn gst_vulkan_fence_reset(fence: *mut GstVulkanFence);

    //=========================================================================
    // GstVulkanHandle
    //=========================================================================
    pub fn gst_vulkan_handle_get_type() -> GType;
    pub fn gst_vulkan_handle_new_wrapped(
        device: *mut GstVulkanDevice,
        type_: GstVulkanHandleType,
        handle: GstVulkanHandleTypedef,
        notify: GstVulkanHandleDestroyNotify,
        user_data: gpointer,
    ) -> *mut GstVulkanHandle;
    pub fn gst_vulkan_handle_free_descriptor_set_layout(
        handle: *mut GstVulkanHandle,
        user_data: gpointer,
    );
    pub fn gst_vulkan_handle_free_framebuffer(handle: *mut GstVulkanHandle, user_data: gpointer);
    pub fn gst_vulkan_handle_free_pipeline(handle: *mut GstVulkanHandle, user_data: gpointer);
    pub fn gst_vulkan_handle_free_pipeline_layout(
        handle: *mut GstVulkanHandle,
        user_data: gpointer,
    );
    pub fn gst_vulkan_handle_free_render_pass(handle: *mut GstVulkanHandle, user_data: gpointer);
    pub fn gst_vulkan_handle_free_sampler(handle: *mut GstVulkanHandle, user_data: gpointer);
    pub fn gst_vulkan_handle_free_shader(handle: *mut GstVulkanHandle, user_data: gpointer);
    pub fn gst_vulkan_handle_ref(handle: *mut GstVulkanHandle) -> *mut GstVulkanHandle;
    pub fn gst_vulkan_handle_context_query(
        element: *mut gst::GstElement,
        query: *mut gst::GstQuery,
        display: *mut GstVulkanDisplay,
        instance: *mut GstVulkanInstance,
        device: *mut GstVulkanDevice,
    ) -> gboolean;
    pub fn gst_vulkan_handle_set_context(
        element: *mut gst::GstElement,
        context: *mut gst::GstContext,
        display: *mut *mut GstVulkanDisplay,
        instance: *mut *mut GstVulkanInstance,
    ) -> gboolean;

    //=========================================================================
    // GstVulkanImageMemory
    //=========================================================================
    pub fn gst_vulkan_image_memory_add_view(
        image: *mut GstVulkanImageMemory,
        view: *mut GstVulkanImageView,
    );
    pub fn gst_vulkan_image_memory_find_view(
        image: *mut GstVulkanImageMemory,
        find_func: GstVulkanImageMemoryFindViewFunc,
        user_data: gpointer,
    ) -> *mut GstVulkanImageView;
    pub fn gst_vulkan_image_memory_get_height(image: *mut GstVulkanImageMemory) -> u32;
    pub fn gst_vulkan_image_memory_get_width(image: *mut GstVulkanImageMemory) -> u32;
    pub fn gst_vulkan_image_memory_init(
        mem: *mut GstVulkanImageMemory,
        allocator: *mut gst::GstAllocator,
        parent: *mut gst::GstMemory,
        device: *mut GstVulkanDevice,
        format: vulkan::VkFormat,
        usage: vulkan::VkImageUsageFlags,
        initial_layout: vulkan::VkImageLayout,
        params: *mut gst::GstAllocationParams,
        size: size_t,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> gboolean;
    pub fn gst_vulkan_image_memory_alloc(
        device: *mut GstVulkanDevice,
        format: vulkan::VkFormat,
        width: size_t,
        height: size_t,
        tiling: vulkan::VkImageTiling,
        usage: vulkan::VkImageUsageFlags,
        mem_prop_flags: vulkan::VkMemoryPropertyFlags,
    ) -> *mut gst::GstMemory;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_image_memory_alloc_with_image_info(
        device: *mut GstVulkanDevice,
        image_info: *mut vulkan::VkImageCreateInfo,
        mem_prop_flags: vulkan::VkMemoryPropertyFlags,
    ) -> *mut gst::GstMemory;
    pub fn gst_vulkan_image_memory_init_once();
    pub fn gst_vulkan_image_memory_wrapped(
        device: *mut GstVulkanDevice,
        image: vulkan::VkImage,
        format: vulkan::VkFormat,
        width: size_t,
        height: size_t,
        tiling: vulkan::VkImageTiling,
        usage: vulkan::VkImageUsageFlags,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> *mut gst::GstMemory;

    //=========================================================================
    // GstVulkanImageView
    //=========================================================================
    pub fn gst_vulkan_image_view_get_type() -> GType;
    pub fn gst_vulkan_image_view_new(
        image: *mut GstVulkanImageMemory,
        create_info: *const vulkan::VkImageViewCreateInfo,
    ) -> *mut GstVulkanImageView;
    pub fn gst_vulkan_image_view_ref(trash: *mut GstVulkanImageView) -> *mut GstVulkanImageView;

    //=========================================================================
    // GstVulkanMemory
    //=========================================================================
    pub fn gst_vulkan_memory_alloc(
        device: *mut GstVulkanDevice,
        memory_type_index: u32,
        params: *mut gst::GstAllocationParams,
        size: size_t,
        mem_prop_flags: vulkan::VkMemoryPropertyFlags,
    ) -> *mut gst::GstMemory;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_memory_find_memory_type_index_with_requirements(
        device: *mut GstVulkanDevice,
        req: *const vulkan::VkMemoryRequirements,
        properties: vulkan::VkMemoryPropertyFlags,
        type_index: *mut u32,
    ) -> gboolean;
    pub fn gst_vulkan_memory_heap_flags_to_string(
        prop_bits: vulkan::VkMemoryHeapFlags,
    ) -> *mut c_char;
    pub fn gst_vulkan_memory_init_once();
    pub fn gst_vulkan_memory_property_flags_to_string(
        prop_bits: vulkan::VkMemoryPropertyFlags,
    ) -> *mut c_char;

    //=========================================================================
    // GstVulkanTrash
    //=========================================================================
    pub fn gst_vulkan_trash_get_type() -> GType;
    pub fn gst_vulkan_trash_new(
        fence: *mut GstVulkanFence,
        notify: GstVulkanTrashNotify,
        user_data: gpointer,
    ) -> *mut GstVulkanTrash;
    pub fn gst_vulkan_trash_new_free_semaphore(
        fence: *mut GstVulkanFence,
        semaphore: vulkan::VkSemaphore,
    ) -> *mut GstVulkanTrash;
    pub fn gst_vulkan_trash_ref(trash: *mut GstVulkanTrash) -> *mut GstVulkanTrash;
    pub fn gst_vulkan_trash_mini_object_unref(device: *mut GstVulkanDevice, user_data: gpointer);
    pub fn gst_vulkan_trash_object_unref(device: *mut GstVulkanDevice, user_data: gpointer);

    //=========================================================================
    // GstVulkanBufferMemoryAllocator
    //=========================================================================
    pub fn gst_vulkan_buffer_memory_allocator_get_type() -> GType;

    //=========================================================================
    // GstVulkanBufferPool
    //=========================================================================
    pub fn gst_vulkan_buffer_pool_get_type() -> GType;
    pub fn gst_vulkan_buffer_pool_new(device: *mut GstVulkanDevice) -> *mut gst::GstBufferPool;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_buffer_pool_config_set_allocation_params(
        config: *mut gst::GstStructure,
        usage: vulkan::VkBufferUsageFlags,
        mem_properties: vulkan::VkMemoryPropertyFlags,
    );

    //=========================================================================
    // GstVulkanCommandPool
    //=========================================================================
    pub fn gst_vulkan_command_pool_get_type() -> GType;
    pub fn gst_vulkan_command_pool_create(
        pool: *mut GstVulkanCommandPool,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanCommandBuffer;
    pub fn gst_vulkan_command_pool_get_queue(
        pool: *mut GstVulkanCommandPool,
    ) -> *mut GstVulkanQueue;
    pub fn gst_vulkan_command_pool_lock(pool: *mut GstVulkanCommandPool);
    pub fn gst_vulkan_command_pool_unlock(pool: *mut GstVulkanCommandPool);

    //=========================================================================
    // GstVulkanDescriptorCache
    //=========================================================================
    pub fn gst_vulkan_descriptor_cache_get_type() -> GType;
    pub fn gst_vulkan_descriptor_cache_new(
        pool: *mut GstVulkanDescriptorPool,
        n_layouts: c_uint,
        layouts: *mut *mut GstVulkanHandle,
    ) -> *mut GstVulkanDescriptorCache;
    pub fn gst_vulkan_descriptor_cache_acquire(
        cache: *mut GstVulkanDescriptorCache,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanDescriptorSet;

    //=========================================================================
    // GstVulkanDescriptorPool
    //=========================================================================
    pub fn gst_vulkan_descriptor_pool_get_type() -> GType;
    pub fn gst_vulkan_descriptor_pool_new_wrapped(
        device: *mut GstVulkanDevice,
        pool: vulkan::VkDescriptorPool,
        max_sets: size_t,
    ) -> *mut GstVulkanDescriptorPool;
    pub fn gst_vulkan_descriptor_pool_create(
        pool: *mut GstVulkanDescriptorPool,
        n_layouts: c_uint,
        layouts: *mut *mut GstVulkanHandle,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanDescriptorSet;
    pub fn gst_vulkan_descriptor_pool_get_device(
        pool: *mut GstVulkanDescriptorPool,
    ) -> *mut GstVulkanDevice;
    pub fn gst_vulkan_descriptor_pool_get_max_sets(pool: *mut GstVulkanDescriptorPool) -> size_t;

    //=========================================================================
    // GstVulkanDevice
    //=========================================================================
    pub fn gst_vulkan_device_get_type() -> GType;
    pub fn gst_vulkan_device_new(
        physical_device: *mut GstVulkanPhysicalDevice,
    ) -> *mut GstVulkanDevice;
    pub fn gst_vulkan_device_new_with_index(
        instance: *mut GstVulkanInstance,
        device_index: c_uint,
    ) -> *mut GstVulkanDevice;
    pub fn gst_vulkan_device_handle_context_query(
        element: *mut gst::GstElement,
        query: *mut gst::GstQuery,
        device: *mut GstVulkanDevice,
    ) -> gboolean;
    pub fn gst_vulkan_device_run_context_query(
        element: *mut gst::GstElement,
        device: *mut *mut GstVulkanDevice,
    ) -> gboolean;
    pub fn gst_vulkan_device_create_fence(
        device: *mut GstVulkanDevice,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanFence;
    pub fn gst_vulkan_device_disable_extension(
        device: *mut GstVulkanDevice,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_device_enable_extension(
        device: *mut GstVulkanDevice,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_device_enable_layer(
        device: *mut GstVulkanDevice,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_device_foreach_queue(
        device: *mut GstVulkanDevice,
        func: GstVulkanDeviceForEachQueueFunc,
        user_data: gpointer,
    );
    pub fn gst_vulkan_device_get_instance(device: *mut GstVulkanDevice) -> *mut GstVulkanInstance;
    pub fn gst_vulkan_device_get_physical_device(
        device: *mut GstVulkanDevice,
    ) -> vulkan::VkPhysicalDevice;
    pub fn gst_vulkan_device_get_proc_address(
        device: *mut GstVulkanDevice,
        name: *const c_char,
    ) -> gpointer;
    pub fn gst_vulkan_device_get_queue(
        device: *mut GstVulkanDevice,
        queue_family: u32,
        queue_i: u32,
    ) -> *mut GstVulkanQueue;
    pub fn gst_vulkan_device_is_extension_enabled(
        device: *mut GstVulkanDevice,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_device_is_layer_enabled(
        device: *mut GstVulkanDevice,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_device_open(
        device: *mut GstVulkanDevice,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_device_queue_family_indices(
        device: *mut GstVulkanDevice,
    ) -> *mut glib::GArray;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_device_select_queue(
        device: *mut GstVulkanDevice,
        expected_flags: vulkan::VkQueueFlagBits,
    ) -> *mut GstVulkanQueue;

    //=========================================================================
    // GstVulkanDisplay
    //=========================================================================
    pub fn gst_vulkan_display_get_type() -> GType;
    pub fn gst_vulkan_display_new(instance: *mut GstVulkanInstance) -> *mut GstVulkanDisplay;
    pub fn gst_vulkan_display_new_with_type(
        instance: *mut GstVulkanInstance,
        type_: GstVulkanDisplayType,
    ) -> *mut GstVulkanDisplay;
    pub fn gst_vulkan_display_choose_type(instance: *mut GstVulkanInstance)
    -> GstVulkanDisplayType;
    pub fn gst_vulkan_display_handle_context_query(
        element: *mut gst::GstElement,
        query: *mut gst::GstQuery,
        display: *mut GstVulkanDisplay,
    ) -> gboolean;
    pub fn gst_vulkan_display_run_context_query(
        element: *mut gst::GstElement,
        display: *mut *mut GstVulkanDisplay,
    ) -> gboolean;
    pub fn gst_vulkan_display_create_window(display: *mut GstVulkanDisplay)
    -> *mut GstVulkanWindow;
    pub fn gst_vulkan_display_find_window(
        display: *mut GstVulkanDisplay,
        data: gpointer,
        compare_func: glib::GCompareFunc,
    ) -> *mut GstVulkanWindow;
    pub fn gst_vulkan_display_get_handle(display: *mut GstVulkanDisplay) -> gpointer;
    pub fn gst_vulkan_display_get_handle_type(
        display: *mut GstVulkanDisplay,
    ) -> GstVulkanDisplayType;
    pub fn gst_vulkan_display_remove_window(
        display: *mut GstVulkanDisplay,
        window: *mut GstVulkanWindow,
    ) -> gboolean;

    //=========================================================================
    // GstVulkanFenceCache
    //=========================================================================
    pub fn gst_vulkan_fence_cache_get_type() -> GType;
    pub fn gst_vulkan_fence_cache_new(device: *mut GstVulkanDevice) -> *mut GstVulkanFenceCache;

    //=========================================================================
    // GstVulkanFullScreenQuad
    //=========================================================================
    pub fn gst_vulkan_full_screen_quad_get_type() -> GType;
    pub fn gst_vulkan_full_screen_quad_new(
        queue: *mut GstVulkanQueue,
    ) -> *mut GstVulkanFullScreenQuad;
    pub fn gst_vulkan_full_screen_quad_draw(
        self_: *mut GstVulkanFullScreenQuad,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_vulkan_full_screen_quad_enable_blend(
        self_: *mut GstVulkanFullScreenQuad,
        enable_blend: gboolean,
    );
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_vulkan_full_screen_quad_enable_clear(
        self_: *mut GstVulkanFullScreenQuad,
        enable_clear: gboolean,
    );
    pub fn gst_vulkan_full_screen_quad_fill_command_buffer(
        self_: *mut GstVulkanFullScreenQuad,
        cmd: *mut GstVulkanCommandBuffer,
        fence: *mut GstVulkanFence,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_full_screen_quad_get_last_fence(
        self_: *mut GstVulkanFullScreenQuad,
    ) -> *mut GstVulkanFence;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_full_screen_quad_get_queue(
        self_: *mut GstVulkanFullScreenQuad,
    ) -> *mut GstVulkanQueue;
    pub fn gst_vulkan_full_screen_quad_prepare_draw(
        self_: *mut GstVulkanFullScreenQuad,
        fence: *mut GstVulkanFence,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_vulkan_full_screen_quad_set_blend_factors(
        self_: *mut GstVulkanFullScreenQuad,
        src_blend_factor: vulkan::VkBlendFactor,
        dst_blend_factor: vulkan::VkBlendFactor,
        src_alpha_blend_factor: vulkan::VkBlendFactor,
        dst_alpha_blend_factor: vulkan::VkBlendFactor,
    );
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_vulkan_full_screen_quad_set_blend_operation(
        self_: *mut GstVulkanFullScreenQuad,
        colour_blend_op: vulkan::VkBlendOp,
        alpha_blend_op: vulkan::VkBlendOp,
    );
    pub fn gst_vulkan_full_screen_quad_set_index_buffer(
        self_: *mut GstVulkanFullScreenQuad,
        indices: *mut gst::GstMemory,
        n_indices: size_t,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_full_screen_quad_set_info(
        self_: *mut GstVulkanFullScreenQuad,
        in_info: *const gst_video::GstVideoInfo,
        out_info: *const gst_video::GstVideoInfo,
    ) -> gboolean;
    pub fn gst_vulkan_full_screen_quad_set_input_buffer(
        self_: *mut GstVulkanFullScreenQuad,
        buffer: *mut gst::GstBuffer,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_full_screen_quad_set_output_buffer(
        self_: *mut GstVulkanFullScreenQuad,
        buffer: *mut gst::GstBuffer,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_full_screen_quad_set_shaders(
        self_: *mut GstVulkanFullScreenQuad,
        vert: *mut GstVulkanHandle,
        frag: *mut GstVulkanHandle,
    ) -> gboolean;
    pub fn gst_vulkan_full_screen_quad_set_uniform_buffer(
        self_: *mut GstVulkanFullScreenQuad,
        uniforms: *mut gst::GstMemory,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_full_screen_quad_set_vertex_buffer(
        self_: *mut GstVulkanFullScreenQuad,
        vertices: *mut gst::GstMemory,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_full_screen_quad_submit(
        self_: *mut GstVulkanFullScreenQuad,
        cmd: *mut GstVulkanCommandBuffer,
        fence: *mut GstVulkanFence,
        error: *mut *mut glib::GError,
    ) -> gboolean;

    //=========================================================================
    // GstVulkanHandlePool
    //=========================================================================
    pub fn gst_vulkan_handle_pool_get_type() -> GType;
    pub fn gst_vulkan_handle_pool_acquire(
        pool: *mut GstVulkanHandlePool,
        error: *mut *mut glib::GError,
    ) -> gpointer;
    pub fn gst_vulkan_handle_pool_alloc(
        pool: *mut GstVulkanHandlePool,
        error: *mut *mut glib::GError,
    ) -> gpointer;
    pub fn gst_vulkan_handle_pool_release(pool: *mut GstVulkanHandlePool, handle: gpointer);

    //=========================================================================
    // GstVulkanImageBufferPool
    //=========================================================================
    pub fn gst_vulkan_image_buffer_pool_get_type() -> GType;
    pub fn gst_vulkan_image_buffer_pool_new(
        device: *mut GstVulkanDevice,
    ) -> *mut gst::GstBufferPool;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_image_buffer_pool_config_get_allocation_params(
        config: *mut gst::GstStructure,
        usage: *mut vulkan::VkImageUsageFlags,
        mem_props: *mut vulkan::VkMemoryPropertyFlags,
        initial_layout: *mut vulkan::VkImageLayout,
        initial_access: *mut u64,
    );
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_image_buffer_pool_config_set_allocation_params(
        config: *mut gst::GstStructure,
        usage: vulkan::VkImageUsageFlags,
        mem_properties: vulkan::VkMemoryPropertyFlags,
        initial_layout: vulkan::VkImageLayout,
        initial_access: u64,
    );
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_image_buffer_pool_config_set_decode_caps(
        config: *mut gst::GstStructure,
        caps: *mut gst::GstCaps,
    );
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_image_buffer_pool_config_set_encode_caps(
        config: *mut gst::GstStructure,
        caps: *mut gst::GstCaps,
    );

    //=========================================================================
    // GstVulkanImageMemoryAllocator
    //=========================================================================
    pub fn gst_vulkan_image_memory_allocator_get_type() -> GType;

    //=========================================================================
    // GstVulkanInstance
    //=========================================================================
    pub fn gst_vulkan_instance_get_type() -> GType;
    pub fn gst_vulkan_instance_new() -> *mut GstVulkanInstance;
    pub fn gst_vulkan_instance_handle_context_query(
        element: *mut gst::GstElement,
        query: *mut gst::GstQuery,
        instance: *mut GstVulkanInstance,
    ) -> gboolean;
    pub fn gst_vulkan_instance_run_context_query(
        element: *mut gst::GstElement,
        instance: *mut *mut GstVulkanInstance,
    ) -> gboolean;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_instance_check_api_version(
        instance: *mut GstVulkanInstance,
        major: c_uint,
        minor: c_uint,
        patch: c_uint,
    ) -> gboolean;
    pub fn gst_vulkan_instance_check_version(
        instance: *mut GstVulkanInstance,
        major: c_uint,
        minor: c_uint,
        patch: c_uint,
    ) -> gboolean;
    pub fn gst_vulkan_instance_create_device(
        instance: *mut GstVulkanInstance,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanDevice;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_instance_create_device_with_index(
        instance: *mut GstVulkanInstance,
        device_index: c_uint,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanDevice;
    pub fn gst_vulkan_instance_disable_extension(
        instance: *mut GstVulkanInstance,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_instance_enable_extension(
        instance: *mut GstVulkanInstance,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_instance_enable_layer(
        instance: *mut GstVulkanInstance,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_instance_fill_info(
        instance: *mut GstVulkanInstance,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_instance_get_api_version(
        instance: *mut GstVulkanInstance,
        major: *mut c_uint,
        minor: *mut c_uint,
        patch: *mut c_uint,
    );
    pub fn gst_vulkan_instance_get_extension_info(
        instance: *mut GstVulkanInstance,
        name: *const c_char,
        spec_version: *mut u32,
    ) -> gboolean;
    pub fn gst_vulkan_instance_get_layer_info(
        instance: *mut GstVulkanInstance,
        name: *const c_char,
        description: *mut *mut c_char,
        spec_version: *mut u32,
        implementation_version: *mut u32,
    ) -> gboolean;
    pub fn gst_vulkan_instance_get_proc_address(
        instance: *mut GstVulkanInstance,
        name: *const c_char,
    ) -> gpointer;
    pub fn gst_vulkan_instance_get_version(
        instance: *mut GstVulkanInstance,
        major: *mut c_uint,
        minor: *mut c_uint,
        patch: *mut c_uint,
    );
    pub fn gst_vulkan_instance_is_extension_enabled(
        instance: *mut GstVulkanInstance,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_instance_is_layer_enabled(
        instance: *mut GstVulkanInstance,
        name: *const c_char,
    ) -> gboolean;
    pub fn gst_vulkan_instance_open(
        instance: *mut GstVulkanInstance,
        error: *mut *mut glib::GError,
    ) -> gboolean;

    //=========================================================================
    // GstVulkanMemoryAllocator
    //=========================================================================
    pub fn gst_vulkan_memory_allocator_get_type() -> GType;

    //=========================================================================
    // GstVulkanOperation
    //=========================================================================
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_get_type() -> GType;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_new(cmd_pool: *mut GstVulkanCommandPool)
    -> *mut GstVulkanOperation;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_add_dependency_frame(
        self_: *mut GstVulkanOperation,
        frame: *mut gst::GstBuffer,
        wait_stage: u64,
        signal_stage: u64,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_add_extra_image_barriers(
        self_: *mut GstVulkanOperation,
        extra_barriers: *mut glib::GArray,
    );
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_add_frame_barrier(
        self_: *mut GstVulkanOperation,
        frame: *mut gst::GstBuffer,
        src_stage: u64,
        dst_stage: u64,
        new_access: u64,
        new_layout: vulkan::VkImageLayout,
        new_queue: *mut GstVulkanQueue,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_begin(
        self_: *mut GstVulkanOperation,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_operation_begin_query(
        self_: *mut GstVulkanOperation,
        base: *mut vulkan::VkBaseInStructure,
        id: u32,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_discard_dependencies(self_: *mut GstVulkanOperation);
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_enable_query(
        self_: *mut GstVulkanOperation,
        query_type: u32,
        n_queries: c_uint,
        pnext: gpointer,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_end(
        self_: *mut GstVulkanOperation,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_end_query(self_: *mut GstVulkanOperation, id: u32) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_get_query(
        self_: *mut GstVulkanOperation,
        data: *mut gpointer,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_new_extra_image_barriers(
        self_: *mut GstVulkanOperation,
    ) -> *mut glib::GArray;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_pipeline_barrier2(
        self_: *mut GstVulkanOperation,
        dependency_info: gpointer,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_reset(self_: *mut GstVulkanOperation);
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_retrieve_image_barriers(
        self_: *mut GstVulkanOperation,
    ) -> *mut glib::GArray;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_update_frame(
        self_: *mut GstVulkanOperation,
        frame: *mut gst::GstBuffer,
        dst_stage: u64,
        new_access: u64,
        new_layout: vulkan::VkImageLayout,
        new_queue: *mut GstVulkanQueue,
    );
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_use_sync2(self_: *mut GstVulkanOperation) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_operation_wait(self_: *mut GstVulkanOperation) -> gboolean;

    //=========================================================================
    // GstVulkanPhysicalDevice
    //=========================================================================
    pub fn gst_vulkan_physical_device_get_type() -> GType;
    pub fn gst_vulkan_physical_device_new(
        instance: *mut GstVulkanInstance,
        device_index: c_uint,
    ) -> *mut GstVulkanPhysicalDevice;
    pub fn gst_vulkan_physical_device_type_to_string(
        type_: vulkan::VkPhysicalDeviceType,
    ) -> *const c_char;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_physical_device_check_api_version(
        device: *mut GstVulkanPhysicalDevice,
        major: c_uint,
        minor: c_uint,
        patch: c_uint,
    ) -> gboolean;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_physical_device_get_api_version(
        device: *mut GstVulkanPhysicalDevice,
        major: *mut c_uint,
        minor: *mut c_uint,
        patch: *mut c_uint,
    );
    pub fn gst_vulkan_physical_device_get_extension_info(
        device: *mut GstVulkanPhysicalDevice,
        name: *const c_char,
        spec_version: *mut u32,
    ) -> gboolean;
    pub fn gst_vulkan_physical_device_get_handle(
        device: *mut GstVulkanPhysicalDevice,
    ) -> vulkan::VkPhysicalDevice;
    pub fn gst_vulkan_physical_device_get_instance(
        device: *mut GstVulkanPhysicalDevice,
    ) -> *mut GstVulkanInstance;
    pub fn gst_vulkan_physical_device_get_layer_info(
        device: *mut GstVulkanPhysicalDevice,
        name: *const c_char,
        description: *mut *mut c_char,
        spec_version: *mut u32,
        implementation_version: *mut u32,
    ) -> gboolean;

    //=========================================================================
    // GstVulkanQueue
    //=========================================================================
    pub fn gst_vulkan_queue_get_type() -> GType;
    pub fn gst_vulkan_queue_flags_to_string(queue_bits: vulkan::VkQueueFlags) -> *mut c_char;
    pub fn gst_vulkan_queue_handle_context_query(
        element: *mut gst::GstElement,
        query: *mut gst::GstQuery,
        queue: *mut GstVulkanQueue,
    ) -> gboolean;
    pub fn gst_vulkan_queue_run_context_query(
        element: *mut gst::GstElement,
        queue: *mut *mut GstVulkanQueue,
    ) -> gboolean;
    pub fn gst_vulkan_queue_create_command_pool(
        queue: *mut GstVulkanQueue,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanCommandPool;
    pub fn gst_vulkan_queue_get_device(queue: *mut GstVulkanQueue) -> *mut GstVulkanDevice;
    pub fn gst_vulkan_queue_submit_lock(queue: *mut GstVulkanQueue);
    pub fn gst_vulkan_queue_submit_unlock(queue: *mut GstVulkanQueue);

    //=========================================================================
    // GstVulkanSwapper
    //=========================================================================
    pub fn gst_vulkan_swapper_get_type() -> GType;
    pub fn gst_vulkan_swapper_new(
        device: *mut GstVulkanDevice,
        window: *mut GstVulkanWindow,
    ) -> *mut GstVulkanSwapper;
    pub fn gst_vulkan_swapper_choose_queue(
        swapper: *mut GstVulkanSwapper,
        available_queue: *mut GstVulkanQueue,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_swapper_get_supported_caps(
        swapper: *mut GstVulkanSwapper,
        error: *mut *mut glib::GError,
    ) -> *mut gst::GstCaps;
    pub fn gst_vulkan_swapper_get_surface_rectangles(
        swapper: *mut GstVulkanSwapper,
        input_image: *mut gst_video::GstVideoRectangle,
        surface_location: *mut gst_video::GstVideoRectangle,
        display_rect: *mut gst_video::GstVideoRectangle,
    );
    pub fn gst_vulkan_swapper_render_buffer(
        swapper: *mut GstVulkanSwapper,
        buffer: *mut gst::GstBuffer,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_swapper_set_caps(
        swapper: *mut GstVulkanSwapper,
        caps: *mut gst::GstCaps,
        error: *mut *mut glib::GError,
    ) -> gboolean;

    //=========================================================================
    // GstVulkanTrashFenceList
    //=========================================================================
    pub fn gst_vulkan_trash_fence_list_get_type() -> GType;
    pub fn gst_vulkan_trash_fence_list_new() -> *mut GstVulkanTrashList;

    //=========================================================================
    // GstVulkanTrashList
    //=========================================================================
    pub fn gst_vulkan_trash_list_get_type() -> GType;
    pub fn gst_vulkan_trash_list_acquire(
        trash_list: *mut GstVulkanTrashList,
        fence: *mut GstVulkanFence,
        notify: GstVulkanTrashNotify,
        user_data: gpointer,
    ) -> *mut GstVulkanTrash;
    pub fn gst_vulkan_trash_list_add(
        trash_list: *mut GstVulkanTrashList,
        trash: *mut GstVulkanTrash,
    ) -> gboolean;
    pub fn gst_vulkan_trash_list_gc(trash_list: *mut GstVulkanTrashList);
    pub fn gst_vulkan_trash_list_wait(
        trash_list: *mut GstVulkanTrashList,
        timeout: u64,
    ) -> gboolean;

    //=========================================================================
    // GstVulkanVideoFilter
    //=========================================================================
    pub fn gst_vulkan_video_filter_get_type() -> GType;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_video_filter_get_device(
        filter: *mut GstVulkanVideoFilter,
    ) -> *mut GstVulkanDevice;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_video_filter_get_instance(
        filter: *mut GstVulkanVideoFilter,
    ) -> *mut GstVulkanInstance;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_video_filter_get_queue(
        filter: *mut GstVulkanVideoFilter,
    ) -> *mut GstVulkanQueue;

    //=========================================================================
    // GstVulkanWindow
    //=========================================================================
    pub fn gst_vulkan_window_get_type() -> GType;
    pub fn gst_vulkan_window_new(display: *mut GstVulkanDisplay) -> *mut GstVulkanWindow;
    pub fn gst_vulkan_window_close(window: *mut GstVulkanWindow);
    pub fn gst_vulkan_window_get_display(window: *mut GstVulkanWindow) -> *mut GstVulkanDisplay;
    pub fn gst_vulkan_window_get_presentation_support(
        window: *mut GstVulkanWindow,
        device: *mut GstVulkanDevice,
        queue_family_idx: u32,
    ) -> gboolean;
    pub fn gst_vulkan_window_get_surface(
        window: *mut GstVulkanWindow,
        error: *mut *mut glib::GError,
    ) -> vulkan::VkSurfaceKHR;
    pub fn gst_vulkan_window_get_surface_dimensions(
        window: *mut GstVulkanWindow,
        width: *mut c_uint,
        height: *mut c_uint,
    );
    pub fn gst_vulkan_window_handle_events(window: *mut GstVulkanWindow, handle_events: gboolean);
    pub fn gst_vulkan_window_open(
        window: *mut GstVulkanWindow,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_vulkan_window_redraw(window: *mut GstVulkanWindow);
    pub fn gst_vulkan_window_resize(window: *mut GstVulkanWindow, width: c_int, height: c_int);
    pub fn gst_vulkan_window_send_key_event(
        window: *mut GstVulkanWindow,
        event_type: *const c_char,
        key_str: *const c_char,
    );
    pub fn gst_vulkan_window_send_mouse_event(
        window: *mut GstVulkanWindow,
        event_type: *const c_char,
        button: c_int,
        posx: c_double,
        posy: c_double,
    );
    pub fn gst_vulkan_window_set_window_handle(window: *mut GstVulkanWindow, handle: uintptr_t);

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_context_get_vulkan_device(
        context: *mut gst::GstContext,
        device: *mut *mut GstVulkanDevice,
    ) -> gboolean;
    pub fn gst_context_get_vulkan_display(
        context: *mut gst::GstContext,
        display: *mut *mut GstVulkanDisplay,
    ) -> gboolean;
    pub fn gst_context_get_vulkan_instance(
        context: *mut gst::GstContext,
        instance: *mut *mut GstVulkanInstance,
    ) -> gboolean;
    pub fn gst_context_get_vulkan_queue(
        context: *mut gst::GstContext,
        queue: *mut *mut GstVulkanQueue,
    ) -> gboolean;
    pub fn gst_context_set_vulkan_device(
        context: *mut gst::GstContext,
        device: *mut GstVulkanDevice,
    );
    pub fn gst_context_set_vulkan_display(
        context: *mut gst::GstContext,
        display: *mut GstVulkanDisplay,
    );
    pub fn gst_context_set_vulkan_instance(
        context: *mut gst::GstContext,
        instance: *mut GstVulkanInstance,
    );
    pub fn gst_context_set_vulkan_queue(context: *mut gst::GstContext, queue: *mut GstVulkanQueue);
    pub fn gst_is_vulkan_buffer_memory(mem: *mut gst::GstMemory) -> gboolean;
    pub fn gst_is_vulkan_image_memory(mem: *mut gst::GstMemory) -> gboolean;
    pub fn gst_is_vulkan_memory(mem: *mut gst::GstMemory) -> gboolean;
    pub fn gst_vulkan_create_shader(
        device: *mut GstVulkanDevice,
        code: *const c_char,
        size: size_t,
        error: *mut *mut glib::GError,
    ) -> *mut GstVulkanHandle;
    pub fn gst_vulkan_ensure_element_data(
        element: *mut gst::GstElement,
        display_ptr: *mut *mut GstVulkanDisplay,
        instance_ptr: *mut *mut GstVulkanInstance,
    ) -> gboolean;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_ensure_element_device(
        element: *mut gst::GstElement,
        instance: *mut GstVulkanInstance,
        device_ptr: *mut *mut GstVulkanDevice,
        device_id: c_uint,
    ) -> gboolean;
    pub fn gst_vulkan_format_from_video_info(
        v_info: *mut gst_video::GstVideoInfo,
        plane: c_uint,
    ) -> vulkan::VkFormat;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_format_from_video_info_2(
        device: *mut GstVulkanDevice,
        info: *mut gst_video::GstVideoInfo,
        tiling: vulkan::VkImageTiling,
        no_multiplane: gboolean,
        requested_usage: vulkan::VkImageUsageFlags,
        fmts: *mut [vulkan::VkFormat; 4],
        n_imgs: *mut c_int,
        usage: *mut vulkan::VkImageUsageFlags,
    ) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_format_get_aspect(format: vulkan::VkFormat) -> c_uint;
    pub fn gst_vulkan_format_get_info(format: vulkan::VkFormat) -> *const GstVulkanFormatInfo;
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    pub fn gst_vulkan_format_get_map(
        format: gst_video::GstVideoFormat,
    ) -> *const GstVulkanFormatMap;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_format_to_video_format(
        vk_format: vulkan::VkFormat,
    ) -> gst_video::GstVideoFormat;
    pub fn gst_vulkan_get_or_create_image_view(
        image: *mut GstVulkanImageMemory,
    ) -> *mut GstVulkanImageView;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_vulkan_get_or_create_image_view_with_info(
        image: *mut GstVulkanImageMemory,
        create_info: *const vulkan::VkImageViewCreateInfo,
    ) -> *mut GstVulkanImageView;
    pub fn gst_vulkan_global_context_query(
        element: *mut gst::GstElement,
        context_type: *const c_char,
    );
    pub fn gst_vulkan_local_context_query(
        element: *mut gst::GstElement,
        context_type: *const c_char,
    ) -> *mut gst::GstQuery;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_vulkan_present_mode_to_string(
        present_mode: vulkan::VkPresentModeKHR,
    ) -> *const c_char;
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    pub fn gst_vulkan_result_to_string(result: vulkan::VkResult) -> *const c_char;
    pub fn gst_vulkan_run_query(
        element: *mut gst::GstElement,
        query: *mut gst::GstQuery,
        direction: gst::GstPadDirection,
    ) -> gboolean;
    pub fn gst_vulkan_sample_count_flags_to_string(
        sample_count_bits: vulkan::VkSampleCountFlags,
    ) -> *mut c_char;

}
