// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{VulkanDevice, VulkanDisplay, ffi};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstVulkanWindow")]
    pub struct VulkanWindow(Object<ffi::GstVulkanWindow, ffi::GstVulkanWindowClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_vulkan_window_get_type(),
    }
}

impl VulkanWindow {
    pub const NONE: Option<&'static VulkanWindow> = None;

    #[doc(alias = "gst_vulkan_window_new")]
    pub fn new(display: &impl IsA<VulkanDisplay>) -> VulkanWindow {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gst_vulkan_window_new(
                display.as_ref().to_glib_none().0,
            ))
        }
    }
}

unsafe impl Send for VulkanWindow {}
unsafe impl Sync for VulkanWindow {}

pub trait VulkanWindowExt: IsA<VulkanWindow> + 'static {
    #[doc(alias = "gst_vulkan_window_close")]
    fn close(&self) {
        unsafe {
            ffi::gst_vulkan_window_close(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gst_vulkan_window_get_display")]
    #[doc(alias = "get_display")]
    fn display(&self) -> VulkanDisplay {
        unsafe {
            from_glib_full(ffi::gst_vulkan_window_get_display(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_window_get_presentation_support")]
    #[doc(alias = "get_presentation_support")]
    fn is_presentation_support(
        &self,
        device: &impl IsA<VulkanDevice>,
        queue_family_idx: u32,
    ) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_window_get_presentation_support(
                self.as_ref().to_glib_none().0,
                device.as_ref().to_glib_none().0,
                queue_family_idx,
            ))
        }
    }

    //#[doc(alias = "gst_vulkan_window_get_surface")]
    //#[doc(alias = "get_surface")]
    //fn surface(&self) -> Result</*Ignored*/vulkan::SurfaceKHR, glib::Error> {
    //    unsafe { TODO: call ffi:gst_vulkan_window_get_surface() }
    //}

    #[doc(alias = "gst_vulkan_window_get_surface_dimensions")]
    #[doc(alias = "get_surface_dimensions")]
    fn surface_dimensions(&self) -> (u32, u32) {
        unsafe {
            let mut width = std::mem::MaybeUninit::uninit();
            let mut height = std::mem::MaybeUninit::uninit();
            ffi::gst_vulkan_window_get_surface_dimensions(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (width.assume_init(), height.assume_init())
        }
    }

    #[doc(alias = "gst_vulkan_window_handle_events")]
    fn handle_events(&self, handle_events: bool) {
        unsafe {
            ffi::gst_vulkan_window_handle_events(
                self.as_ref().to_glib_none().0,
                handle_events.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_vulkan_window_open")]
    fn open(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_vulkan_window_open(self.as_ref().to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_vulkan_window_redraw")]
    fn redraw(&self) {
        unsafe {
            ffi::gst_vulkan_window_redraw(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gst_vulkan_window_resize")]
    fn resize(&self, width: i32, height: i32) {
        unsafe {
            ffi::gst_vulkan_window_resize(self.as_ref().to_glib_none().0, width, height);
        }
    }

    #[doc(alias = "gst_vulkan_window_send_key_event")]
    fn send_key_event(&self, event_type: &str, key_str: &str) {
        unsafe {
            ffi::gst_vulkan_window_send_key_event(
                self.as_ref().to_glib_none().0,
                event_type.to_glib_none().0,
                key_str.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gst_vulkan_window_send_mouse_event")]
    fn send_mouse_event(&self, event_type: &str, button: i32, posx: f64, posy: f64) {
        unsafe {
            ffi::gst_vulkan_window_send_mouse_event(
                self.as_ref().to_glib_none().0,
                event_type.to_glib_none().0,
                button,
                posx,
                posy,
            );
        }
    }

    //#[doc(alias = "gst_vulkan_window_set_window_handle")]
    //fn set_window_handle(&self, handle: /*Unimplemented*/Basic: UIntPtr) {
    //    unsafe { TODO: call ffi:gst_vulkan_window_set_window_handle() }
    //}

    #[doc(alias = "close")]
    fn connect_close<F: Fn(&Self) -> bool + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn close_trampoline<
            P: IsA<VulkanWindow>,
            F: Fn(&P) -> bool + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanWindow,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(VulkanWindow::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"close".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    close_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "draw")]
    fn connect_draw<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn draw_trampoline<
            P: IsA<VulkanWindow>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanWindow,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(VulkanWindow::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"draw".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    draw_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "key-event")]
    fn connect_key_event<F: Fn(&Self, &str, &str) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn key_event_trampoline<
            P: IsA<VulkanWindow>,
            F: Fn(&P, &str, &str) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanWindow,
            id: *mut std::ffi::c_char,
            key: *mut std::ffi::c_char,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    VulkanWindow::from_glib_borrow(this).unsafe_cast_ref(),
                    &glib::GString::from_glib_borrow(id),
                    &glib::GString::from_glib_borrow(key),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"key-event".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    key_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mouse-event")]
    fn connect_mouse_event<F: Fn(&Self, &str, i32, f64, f64) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn mouse_event_trampoline<
            P: IsA<VulkanWindow>,
            F: Fn(&P, &str, i32, f64, f64) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanWindow,
            id: *mut std::ffi::c_char,
            button: std::ffi::c_int,
            x: std::ffi::c_double,
            y: std::ffi::c_double,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    VulkanWindow::from_glib_borrow(this).unsafe_cast_ref(),
                    &glib::GString::from_glib_borrow(id),
                    button,
                    x,
                    y,
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"mouse-event".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    mouse_event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "resize")]
    fn connect_resize<F: Fn(&Self, u32, u32) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn resize_trampoline<
            P: IsA<VulkanWindow>,
            F: Fn(&P, u32, u32) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanWindow,
            object: std::ffi::c_uint,
            p0: std::ffi::c_uint,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    VulkanWindow::from_glib_borrow(this).unsafe_cast_ref(),
                    object,
                    p0,
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"resize".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    resize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "display")]
    fn connect_display_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_display_trampoline<
            P: IsA<VulkanWindow>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(VulkanWindow::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::display".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_display_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<VulkanWindow>> VulkanWindowExt for O {}
