// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{VulkanInstance, ffi};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GstVulkanPhysicalDevice")]
    pub struct VulkanPhysicalDevice(Object<ffi::GstVulkanPhysicalDevice, ffi::GstVulkanPhysicalDeviceClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_vulkan_physical_device_get_type(),
    }
}

impl VulkanPhysicalDevice {
    pub const NONE: Option<&'static VulkanPhysicalDevice> = None;

    #[doc(alias = "gst_vulkan_physical_device_new")]
    pub fn new(instance: &impl IsA<VulkanInstance>, device_index: u32) -> VulkanPhysicalDevice {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gst_vulkan_physical_device_new(
                instance.as_ref().to_glib_none().0,
                device_index,
            ))
        }
    }

    //#[doc(alias = "gst_vulkan_physical_device_type_to_string")]
    //pub fn type_to_string(type_: /*Ignored*/&vulkan::PhysicalDeviceType) -> glib::GString {
    //    unsafe { TODO: call ffi:gst_vulkan_physical_device_type_to_string() }
    //}
}

unsafe impl Send for VulkanPhysicalDevice {}
unsafe impl Sync for VulkanPhysicalDevice {}

pub trait VulkanPhysicalDeviceExt: IsA<VulkanPhysicalDevice> + 'static {
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    #[doc(alias = "gst_vulkan_physical_device_check_api_version")]
    fn check_api_version(&self, major: u32, minor: u32, patch: u32) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_physical_device_check_api_version(
                self.as_ref().to_glib_none().0,
                major,
                minor,
                patch,
            ))
        }
    }

    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    #[doc(alias = "gst_vulkan_physical_device_get_api_version")]
    #[doc(alias = "get_api_version")]
    fn api_version(&self) -> (u32, u32, u32) {
        unsafe {
            let mut major = std::mem::MaybeUninit::uninit();
            let mut minor = std::mem::MaybeUninit::uninit();
            let mut patch = std::mem::MaybeUninit::uninit();
            ffi::gst_vulkan_physical_device_get_api_version(
                self.as_ref().to_glib_none().0,
                major.as_mut_ptr(),
                minor.as_mut_ptr(),
                patch.as_mut_ptr(),
            );
            (
                major.assume_init(),
                minor.assume_init(),
                patch.assume_init(),
            )
        }
    }

    #[doc(alias = "gst_vulkan_physical_device_get_extension_info")]
    #[doc(alias = "get_extension_info")]
    fn extension_info(&self, name: &str) -> Option<u32> {
        unsafe {
            let mut spec_version = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gst_vulkan_physical_device_get_extension_info(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                spec_version.as_mut_ptr(),
            ));
            if ret {
                Some(spec_version.assume_init())
            } else {
                None
            }
        }
    }

    //#[doc(alias = "gst_vulkan_physical_device_get_handle")]
    //#[doc(alias = "get_handle")]
    //fn handle(&self) -> /*Ignored*/vulkan::PhysicalDevice {
    //    unsafe { TODO: call ffi:gst_vulkan_physical_device_get_handle() }
    //}

    #[doc(alias = "gst_vulkan_physical_device_get_instance")]
    #[doc(alias = "get_instance")]
    fn instance(&self) -> VulkanInstance {
        unsafe {
            from_glib_full(ffi::gst_vulkan_physical_device_get_instance(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_physical_device_get_layer_info")]
    #[doc(alias = "get_layer_info")]
    fn layer_info(&self, name: &str) -> Option<(Option<glib::GString>, u32, u32)> {
        unsafe {
            let mut description = std::ptr::null_mut();
            let mut spec_version = std::mem::MaybeUninit::uninit();
            let mut implementation_version = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gst_vulkan_physical_device_get_layer_info(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                &mut description,
                spec_version.as_mut_ptr(),
                implementation_version.as_mut_ptr(),
            ));
            if ret {
                Some((
                    from_glib_full(description),
                    spec_version.assume_init(),
                    implementation_version.assume_init(),
                ))
            } else {
                None
            }
        }
    }

    #[doc(alias = "device-index")]
    fn device_index(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "device-index")
    }
}

impl<O: IsA<VulkanPhysicalDevice>> VulkanPhysicalDeviceExt for O {}
