// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{VulkanDevice, ffi};
#[cfg(feature = "v1_26")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
use glib::object::ObjectType as _;
use glib::{
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstVulkanInstance")]
    pub struct VulkanInstance(Object<ffi::GstVulkanInstance, ffi::GstVulkanInstanceClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_vulkan_instance_get_type(),
    }
}

impl VulkanInstance {
    pub const NONE: Option<&'static VulkanInstance> = None;

    #[doc(alias = "gst_vulkan_instance_new")]
    pub fn new() -> VulkanInstance {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_vulkan_instance_new()) }
    }

    #[doc(alias = "gst_vulkan_instance_handle_context_query")]
    pub fn handle_context_query(
        element: &impl IsA<gst::Element>,
        query: &gst::Query,
        instance: Option<&impl IsA<VulkanInstance>>,
    ) -> bool {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gst_vulkan_instance_handle_context_query(
                element.as_ref().to_glib_none().0,
                query.to_glib_none().0,
                instance.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gst_vulkan_instance_run_context_query")]
    //pub fn run_context_query(element: &impl IsA<gst::Element>, instance: impl IsA<VulkanInstance>) -> bool {
    //    unsafe { TODO: call ffi:gst_vulkan_instance_run_context_query() }
    //}
}

impl Default for VulkanInstance {
    fn default() -> Self {
        Self::new()
    }
}

unsafe impl Send for VulkanInstance {}
unsafe impl Sync for VulkanInstance {}

pub trait VulkanInstanceExt: IsA<VulkanInstance> + 'static {
    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    #[doc(alias = "gst_vulkan_instance_check_api_version")]
    fn check_api_version(&self, major: u32, minor: u32, patch: u32) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_instance_check_api_version(
                self.as_ref().to_glib_none().0,
                major,
                minor,
                patch,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_instance_check_version")]
    fn check_version(&self, major: u32, minor: u32, patch: u32) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_instance_check_version(
                self.as_ref().to_glib_none().0,
                major,
                minor,
                patch,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_instance_create_device")]
    fn create_device(&self) -> Result<VulkanDevice, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret =
                ffi::gst_vulkan_instance_create_device(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    #[doc(alias = "gst_vulkan_instance_create_device_with_index")]
    fn create_device_with_index(&self, device_index: u32) -> Result<VulkanDevice, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gst_vulkan_instance_create_device_with_index(
                self.as_ref().to_glib_none().0,
                device_index,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_vulkan_instance_disable_extension")]
    fn disable_extension(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_instance_disable_extension(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_instance_enable_extension")]
    fn enable_extension(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_instance_enable_extension(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_instance_enable_layer")]
    fn enable_layer(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_instance_enable_layer(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_instance_fill_info")]
    fn fill_info(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok =
                ffi::gst_vulkan_instance_fill_info(self.as_ref().to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    #[doc(alias = "gst_vulkan_instance_get_api_version")]
    #[doc(alias = "get_api_version")]
    fn api_version(&self) -> (u32, u32, u32) {
        unsafe {
            let mut major = std::mem::MaybeUninit::uninit();
            let mut minor = std::mem::MaybeUninit::uninit();
            let mut patch = std::mem::MaybeUninit::uninit();
            ffi::gst_vulkan_instance_get_api_version(
                self.as_ref().to_glib_none().0,
                major.as_mut_ptr(),
                minor.as_mut_ptr(),
                patch.as_mut_ptr(),
            );
            (
                major.assume_init(),
                minor.assume_init(),
                patch.assume_init(),
            )
        }
    }

    #[doc(alias = "gst_vulkan_instance_get_extension_info")]
    #[doc(alias = "get_extension_info")]
    fn extension_info(&self, name: &str) -> Option<u32> {
        unsafe {
            let mut spec_version = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gst_vulkan_instance_get_extension_info(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                spec_version.as_mut_ptr(),
            ));
            if ret {
                Some(spec_version.assume_init())
            } else {
                None
            }
        }
    }

    #[doc(alias = "gst_vulkan_instance_get_layer_info")]
    #[doc(alias = "get_layer_info")]
    fn layer_info(&self, name: &str) -> Option<(Option<glib::GString>, u32, u32)> {
        unsafe {
            let mut description = std::ptr::null_mut();
            let mut spec_version = std::mem::MaybeUninit::uninit();
            let mut implementation_version = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gst_vulkan_instance_get_layer_info(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                &mut description,
                spec_version.as_mut_ptr(),
                implementation_version.as_mut_ptr(),
            ));
            if ret {
                Some((
                    from_glib_full(description),
                    spec_version.assume_init(),
                    implementation_version.assume_init(),
                ))
            } else {
                None
            }
        }
    }

    //#[doc(alias = "gst_vulkan_instance_get_proc_address")]
    //#[doc(alias = "get_proc_address")]
    //fn proc_address(&self, name: &str) -> /*Unimplemented*/Option<Basic: Pointer> {
    //    unsafe { TODO: call ffi:gst_vulkan_instance_get_proc_address() }
    //}

    #[doc(alias = "gst_vulkan_instance_get_version")]
    #[doc(alias = "get_version")]
    fn version(&self) -> (u32, u32, u32) {
        unsafe {
            let mut major = std::mem::MaybeUninit::uninit();
            let mut minor = std::mem::MaybeUninit::uninit();
            let mut patch = std::mem::MaybeUninit::uninit();
            ffi::gst_vulkan_instance_get_version(
                self.as_ref().to_glib_none().0,
                major.as_mut_ptr(),
                minor.as_mut_ptr(),
                patch.as_mut_ptr(),
            );
            (
                major.assume_init(),
                minor.assume_init(),
                patch.assume_init(),
            )
        }
    }

    #[doc(alias = "gst_vulkan_instance_is_extension_enabled")]
    fn is_extension_enabled(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_instance_is_extension_enabled(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_instance_is_layer_enabled")]
    fn is_layer_enabled(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_instance_is_layer_enabled(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_instance_open")]
    fn open(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_vulkan_instance_open(self.as_ref().to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "requested-api-major")]
    fn requested_api_major(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "requested-api-major")
    }

    #[doc(alias = "requested-api-major")]
    fn set_requested_api_major(&self, requested_api_major: u32) {
        ObjectExt::set_property(self.as_ref(), "requested-api-major", requested_api_major)
    }

    #[doc(alias = "requested-api-minor")]
    fn requested_api_minor(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "requested-api-minor")
    }

    #[doc(alias = "requested-api-minor")]
    fn set_requested_api_minor(&self, requested_api_minor: u32) {
        ObjectExt::set_property(self.as_ref(), "requested-api-minor", requested_api_minor)
    }

    #[cfg(feature = "v1_26")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_26")))]
    #[doc(alias = "create-device")]
    fn connect_create_device<F: Fn(&Self, u32) -> VulkanDevice + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn create_device_trampoline<
            P: IsA<VulkanInstance>,
            F: Fn(&P, u32) -> VulkanDevice + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanInstance,
            device_index: std::ffi::c_uint,
            f: glib::ffi::gpointer,
        ) -> *mut ffi::GstVulkanDevice {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    VulkanInstance::from_glib_borrow(this).unsafe_cast_ref(),
                    device_index,
                )
                .to_glib_full()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"create-device".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    create_device_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "requested-api-major")]
    fn connect_requested_api_major_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_requested_api_major_trampoline<
            P: IsA<VulkanInstance>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanInstance,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(VulkanInstance::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::requested-api-major".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_requested_api_major_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "requested-api-minor")]
    fn connect_requested_api_minor_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_requested_api_minor_trampoline<
            P: IsA<VulkanInstance>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanInstance,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(VulkanInstance::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::requested-api-minor".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_requested_api_minor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<VulkanInstance>> VulkanInstanceExt for O {}
