// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{VulkanFence, VulkanInstance, VulkanPhysicalDevice, VulkanQueue, ffi};
use glib::{
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstVulkanDevice")]
    pub struct VulkanDevice(Object<ffi::GstVulkanDevice, ffi::GstVulkanDeviceClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_vulkan_device_get_type(),
    }
}

impl VulkanDevice {
    pub const NONE: Option<&'static VulkanDevice> = None;

    #[doc(alias = "gst_vulkan_device_new")]
    pub fn new(physical_device: &impl IsA<VulkanPhysicalDevice>) -> VulkanDevice {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gst_vulkan_device_new(
                physical_device.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_device_new_with_index")]
    #[doc(alias = "new_with_index")]
    pub fn with_index(instance: &impl IsA<VulkanInstance>, device_index: u32) -> VulkanDevice {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gst_vulkan_device_new_with_index(
                instance.as_ref().to_glib_none().0,
                device_index,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_device_handle_context_query")]
    pub fn handle_context_query(
        element: &impl IsA<gst::Element>,
        query: &gst::Query,
        device: &impl IsA<VulkanDevice>,
    ) -> bool {
        skip_assert_initialized!();
        unsafe {
            from_glib(ffi::gst_vulkan_device_handle_context_query(
                element.as_ref().to_glib_none().0,
                query.to_glib_none().0,
                device.as_ref().to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gst_vulkan_device_run_context_query")]
    //pub fn run_context_query(element: &impl IsA<gst::Element>, device: impl IsA<VulkanDevice>) -> bool {
    //    unsafe { TODO: call ffi:gst_vulkan_device_run_context_query() }
    //}
}

unsafe impl Send for VulkanDevice {}
unsafe impl Sync for VulkanDevice {}

pub trait VulkanDeviceExt: IsA<VulkanDevice> + 'static {
    #[doc(alias = "gst_vulkan_device_create_fence")]
    fn create_fence(&self) -> Result<Option<VulkanFence>, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret =
                ffi::gst_vulkan_device_create_fence(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_vulkan_device_disable_extension")]
    fn disable_extension(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_device_disable_extension(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_device_enable_extension")]
    fn enable_extension(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_device_enable_extension(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_device_enable_layer")]
    fn enable_layer(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_device_enable_layer(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_device_foreach_queue")]
    fn foreach_queue<P: FnMut(&VulkanDevice, &VulkanQueue) -> bool>(&self, func: P) {
        let mut func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&VulkanDevice, &VulkanQueue) -> bool>(
            device: *mut ffi::GstVulkanDevice,
            queue: *mut ffi::GstVulkanQueue,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let device = from_glib_borrow(device);
                let queue = from_glib_borrow(queue);
                let callback = user_data as *mut P;
                (*callback)(&device, &queue).into_glib()
            }
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &mut P = &mut func_data;
        unsafe {
            ffi::gst_vulkan_device_foreach_queue(
                self.as_ref().to_glib_none().0,
                func,
                super_callback0 as *mut _ as *mut _,
            );
        }
    }

    #[doc(alias = "gst_vulkan_device_get_instance")]
    #[doc(alias = "get_instance")]
    fn instance(&self) -> Option<VulkanInstance> {
        unsafe {
            from_glib_full(ffi::gst_vulkan_device_get_instance(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gst_vulkan_device_get_physical_device")]
    //#[doc(alias = "get_physical_device")]
    //#[doc(alias = "physical-device")]
    //fn physical_device(&self) -> /*Ignored*/vulkan::PhysicalDevice {
    //    unsafe { TODO: call ffi:gst_vulkan_device_get_physical_device() }
    //}

    //#[doc(alias = "gst_vulkan_device_get_proc_address")]
    //#[doc(alias = "get_proc_address")]
    //fn proc_address(&self, name: &str) -> /*Unimplemented*/Option<Basic: Pointer> {
    //    unsafe { TODO: call ffi:gst_vulkan_device_get_proc_address() }
    //}

    #[doc(alias = "gst_vulkan_device_get_queue")]
    #[doc(alias = "get_queue")]
    fn queue(&self, queue_family: u32, queue_i: u32) -> VulkanQueue {
        unsafe {
            from_glib_full(ffi::gst_vulkan_device_get_queue(
                self.as_ref().to_glib_none().0,
                queue_family,
                queue_i,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_device_is_extension_enabled")]
    fn is_extension_enabled(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_device_is_extension_enabled(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_device_is_layer_enabled")]
    fn is_layer_enabled(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::gst_vulkan_device_is_layer_enabled(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_vulkan_device_open")]
    fn open(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_vulkan_device_open(self.as_ref().to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //#[cfg(feature = "v1_24")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    //#[doc(alias = "gst_vulkan_device_queue_family_indices")]
    //fn queue_family_indices(&self) -> /*Unknown conversion*//*Unimplemented*/Array TypeId { ns_id: 0, id: 7 } {
    //    unsafe { TODO: call ffi:gst_vulkan_device_queue_family_indices() }
    //}

    //#[cfg(feature = "v1_24")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    //#[doc(alias = "gst_vulkan_device_select_queue")]
    //fn select_queue(&self, expected_flags: /*Ignored*/&vulkan::QueueFlagBits) -> Option<VulkanQueue> {
    //    unsafe { TODO: call ffi:gst_vulkan_device_select_queue() }
    //}

    #[doc(alias = "instance")]
    fn connect_instance_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_instance_trampoline<
            P: IsA<VulkanDevice>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstVulkanDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(VulkanDevice::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::instance".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_instance_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<VulkanDevice>> VulkanDeviceExt for O {}
