// Take a look at the license at the top of the repository in the LICENSE file.

use glib::{prelude::*, subclass::prelude::*, translate::*};
use gst_rtsp::ffi::GstRTSPUrl;

use crate::{RTSPMountPoints, ffi};

pub trait RTSPMountPointsImpl:
    ObjectImpl + ObjectSubclass<Type: IsA<RTSPMountPoints>> + Send + Sync
{
    fn make_path(&self, url: &gst_rtsp::RTSPUrl) -> Option<glib::GString> {
        self.parent_make_path(url)
    }
}

pub trait RTSPMountPointsImplExt: RTSPMountPointsImpl {
    fn parent_make_path(&self, url: &gst_rtsp::RTSPUrl) -> Option<glib::GString> {
        unsafe {
            let data = Self::type_data();
            let parent_class = data.as_ref().parent_class() as *mut ffi::GstRTSPMountPointsClass;
            let f = (*parent_class)
                .make_path
                .expect("No `make_path` virtual method implementation in parent class");
            from_glib_full(f(
                self.obj()
                    .unsafe_cast_ref::<RTSPMountPoints>()
                    .to_glib_none()
                    .0,
                url.to_glib_none().0,
            ))
        }
    }
}

impl<T: RTSPMountPointsImpl> RTSPMountPointsImplExt for T {}

unsafe impl<T: RTSPMountPointsImpl> IsSubclassable<T> for RTSPMountPoints {
    fn class_init(klass: &mut glib::Class<Self>) {
        Self::parent_class_init::<T>(klass);
        let klass = klass.as_mut();
        klass.make_path = Some(mount_points_make_path::<T>);
    }
}

unsafe extern "C" fn mount_points_make_path<T: RTSPMountPointsImpl>(
    ptr: *mut ffi::GstRTSPMountPoints,
    url: *const GstRTSPUrl,
) -> *mut std::os::raw::c_char {
    unsafe {
        let instance = &*(ptr as *mut T::Instance);
        let imp = instance.imp();

        imp.make_path(&from_glib_borrow(url)).into_glib_ptr()
    }
}
