// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{
    RTSPAddressPool, RTSPMediaStatus, RTSPPublishClockMode, RTSPStream, RTSPStreamTransport,
    RTSPSuspendMode, RTSPThread, RTSPTransportMode, ffi,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstRTSPMedia")]
    pub struct RTSPMedia(Object<ffi::GstRTSPMedia, ffi::GstRTSPMediaClass>);

    match fn {
        type_ => || ffi::gst_rtsp_media_get_type(),
    }
}

impl RTSPMedia {
    pub const NONE: Option<&'static RTSPMedia> = None;

    #[doc(alias = "gst_rtsp_media_new")]
    pub fn new(element: impl IsA<gst::Element>) -> RTSPMedia {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_rtsp_media_new(element.upcast().into_glib_ptr())) }
    }
}

unsafe impl Send for RTSPMedia {}
unsafe impl Sync for RTSPMedia {}

pub trait RTSPMediaExt: IsA<RTSPMedia> + 'static {
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_rtsp_media_can_be_shared")]
    fn can_be_shared(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_can_be_shared(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_collect_streams")]
    fn collect_streams(&self) {
        unsafe {
            ffi::gst_rtsp_media_collect_streams(self.as_ref().to_glib_none().0);
        }
    }

    //#[doc(alias = "gst_rtsp_media_complete_pipeline")]
    //fn complete_pipeline(&self, transports: /*Ignored*/&[gst_rtsp::RTSPTransport]) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_media_complete_pipeline() }
    //}

    #[doc(alias = "gst_rtsp_media_create_stream")]
    fn create_stream(
        &self,
        payloader: &impl IsA<gst::Element>,
        pad: &impl IsA<gst::Pad>,
    ) -> RTSPStream {
        unsafe {
            from_glib_none(ffi::gst_rtsp_media_create_stream(
                self.as_ref().to_glib_none().0,
                payloader.as_ref().to_glib_none().0,
                pad.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_find_stream")]
    fn find_stream(&self, control: &str) -> Option<RTSPStream> {
        unsafe {
            from_glib_none(ffi::gst_rtsp_media_find_stream(
                self.as_ref().to_glib_none().0,
                control.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_address_pool")]
    #[doc(alias = "get_address_pool")]
    fn address_pool(&self) -> Option<RTSPAddressPool> {
        unsafe {
            from_glib_full(ffi::gst_rtsp_media_get_address_pool(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_base_time")]
    #[doc(alias = "get_base_time")]
    fn base_time(&self) -> Option<gst::ClockTime> {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_base_time(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_buffer_size")]
    #[doc(alias = "get_buffer_size")]
    #[doc(alias = "buffer-size")]
    fn buffer_size(&self) -> u32 {
        unsafe { ffi::gst_rtsp_media_get_buffer_size(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gst_rtsp_media_get_clock")]
    #[doc(alias = "get_clock")]
    fn clock(&self) -> Option<gst::Clock> {
        unsafe {
            from_glib_full(ffi::gst_rtsp_media_get_clock(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_rtsp_media_get_do_retransmission")]
    #[doc(alias = "get_do_retransmission")]
    fn does_retransmission(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_do_retransmission(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_get_dscp_qos")]
    #[doc(alias = "get_dscp_qos")]
    #[doc(alias = "dscp-qos")]
    fn dscp_qos(&self) -> i32 {
        unsafe { ffi::gst_rtsp_media_get_dscp_qos(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gst_rtsp_media_get_element")]
    #[doc(alias = "get_element")]
    fn element(&self) -> gst::Element {
        unsafe {
            from_glib_full(ffi::gst_rtsp_media_get_element(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_rtsp_media_get_ensure_keyunit_on_start")]
    #[doc(alias = "get_ensure_keyunit_on_start")]
    #[doc(alias = "ensure-keyunit-on-start")]
    fn is_ensure_keyunit_on_start(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_ensure_keyunit_on_start(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_rtsp_media_get_ensure_keyunit_on_start_timeout")]
    #[doc(alias = "get_ensure_keyunit_on_start_timeout")]
    #[doc(alias = "ensure-keyunit-on-start-timeout")]
    fn ensure_keyunit_on_start_timeout(&self) -> u32 {
        unsafe {
            ffi::gst_rtsp_media_get_ensure_keyunit_on_start_timeout(self.as_ref().to_glib_none().0)
        }
    }

    #[doc(alias = "gst_rtsp_media_get_latency")]
    #[doc(alias = "get_latency")]
    fn latency(&self) -> u32 {
        unsafe { ffi::gst_rtsp_media_get_latency(self.as_ref().to_glib_none().0) }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_rtsp_media_get_max_mcast_ttl")]
    #[doc(alias = "get_max_mcast_ttl")]
    #[doc(alias = "max-mcast-ttl")]
    fn max_mcast_ttl(&self) -> u32 {
        unsafe { ffi::gst_rtsp_media_get_max_mcast_ttl(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gst_rtsp_media_get_multicast_iface")]
    #[doc(alias = "get_multicast_iface")]
    fn multicast_iface(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gst_rtsp_media_get_multicast_iface(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gst_rtsp_media_get_permissions")]
    //#[doc(alias = "get_permissions")]
    //fn permissions(&self) -> /*Ignored*/Option<RTSPPermissions> {
    //    unsafe { TODO: call ffi:gst_rtsp_media_get_permissions() }
    //}

    #[doc(alias = "gst_rtsp_media_get_profiles")]
    #[doc(alias = "get_profiles")]
    fn profiles(&self) -> gst_rtsp::RTSPProfile {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_profiles(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_protocols")]
    #[doc(alias = "get_protocols")]
    fn protocols(&self) -> gst_rtsp::RTSPLowerTrans {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_protocols(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_publish_clock_mode")]
    #[doc(alias = "get_publish_clock_mode")]
    fn publish_clock_mode(&self) -> RTSPPublishClockMode {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_publish_clock_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_range_string")]
    #[doc(alias = "get_range_string")]
    fn range_string(&self, play: bool, unit: gst_rtsp::RTSPRangeUnit) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gst_rtsp_media_get_range_string(
                self.as_ref().to_glib_none().0,
                play.into_glib(),
                unit.into_glib(),
            ))
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_get_rate_control")]
    #[doc(alias = "get_rate_control")]
    fn is_rate_control(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_rate_control(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_get_rates")]
    #[doc(alias = "get_rates")]
    fn rates(&self) -> Option<(f64, f64)> {
        unsafe {
            let mut rate = std::mem::MaybeUninit::uninit();
            let mut applied_rate = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gst_rtsp_media_get_rates(
                self.as_ref().to_glib_none().0,
                rate.as_mut_ptr(),
                applied_rate.as_mut_ptr(),
            ));
            if ret {
                Some((rate.assume_init(), applied_rate.assume_init()))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gst_rtsp_media_get_retransmission_time")]
    #[doc(alias = "get_retransmission_time")]
    fn retransmission_time(&self) -> Option<gst::ClockTime> {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_retransmission_time(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_status")]
    #[doc(alias = "get_status")]
    fn status(&self) -> RTSPMediaStatus {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_status(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_stream")]
    #[doc(alias = "get_stream")]
    fn stream(&self, idx: u32) -> Option<RTSPStream> {
        unsafe {
            from_glib_none(ffi::gst_rtsp_media_get_stream(
                self.as_ref().to_glib_none().0,
                idx,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_suspend_mode")]
    #[doc(alias = "get_suspend_mode")]
    #[doc(alias = "suspend-mode")]
    fn suspend_mode(&self) -> RTSPSuspendMode {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_suspend_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_time_provider")]
    #[doc(alias = "get_time_provider")]
    #[doc(alias = "time-provider")]
    fn time_provider(&self, address: Option<&str>, port: u16) -> Option<gst_net::NetTimeProvider> {
        unsafe {
            from_glib_full(ffi::gst_rtsp_media_get_time_provider(
                self.as_ref().to_glib_none().0,
                address.to_glib_none().0,
                port,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_get_transport_mode")]
    #[doc(alias = "get_transport_mode")]
    #[doc(alias = "transport-mode")]
    fn transport_mode(&self) -> RTSPTransportMode {
        unsafe {
            from_glib(ffi::gst_rtsp_media_get_transport_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gst_rtsp_media_handle_sdp")]
    //fn handle_sdp(&self, sdp: /*Ignored*/&mut gst_sdp::SDPMessage) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_media_handle_sdp() }
    //}

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_has_completed_sender")]
    fn has_completed_sender(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_has_completed_sender(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_rtsp_media_is_bind_mcast_address")]
    #[doc(alias = "bind-mcast-address")]
    fn is_bind_mcast_address(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_is_bind_mcast_address(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_is_eos_shutdown")]
    #[doc(alias = "eos-shutdown")]
    fn is_eos_shutdown(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_is_eos_shutdown(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_is_receive_only")]
    fn is_receive_only(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_is_receive_only(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_is_reusable")]
    #[doc(alias = "reusable")]
    fn is_reusable(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_is_reusable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_is_shared")]
    #[doc(alias = "shared")]
    fn is_shared(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_is_shared(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_is_stop_on_disconnect")]
    #[doc(alias = "stop-on-disconnect")]
    fn is_stop_on_disconnect(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_is_stop_on_disconnect(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_is_time_provider")]
    #[doc(alias = "time-provider")]
    fn is_time_provider(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_is_time_provider(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_lock")]
    fn lock(&self) {
        unsafe {
            ffi::gst_rtsp_media_lock(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gst_rtsp_media_n_streams")]
    fn n_streams(&self) -> u32 {
        unsafe { ffi::gst_rtsp_media_n_streams(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gst_rtsp_media_prepare")]
    fn prepare(&self, thread: Option<RTSPThread>) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_rtsp_media_prepare(self.as_ref().to_glib_none().0, thread.into_glib_ptr()),
                "Failed to prepare media"
            )
        }
    }

    //#[doc(alias = "gst_rtsp_media_seek")]
    //fn seek(&self, range: /*Ignored*/&mut gst_rtsp::RTSPTimeRange) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_media_seek() }
    //}

    //#[cfg(feature = "v1_18")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    //#[doc(alias = "gst_rtsp_media_seek_full")]
    //fn seek_full(&self, range: /*Ignored*/&mut gst_rtsp::RTSPTimeRange, flags: /*Ignored*/gst::SeekFlags) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_media_seek_full() }
    //}

    //#[cfg(feature = "v1_18")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    //#[doc(alias = "gst_rtsp_media_seek_trickmode")]
    //fn seek_trickmode(&self, range: /*Ignored*/&mut gst_rtsp::RTSPTimeRange, flags: /*Ignored*/gst::SeekFlags, rate: f64, trickmode_interval: impl Into<Option<gst::ClockTime>>) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_media_seek_trickmode() }
    //}

    //#[doc(alias = "gst_rtsp_media_seekable")]
    //fn seekable(&self) -> /*Ignored*/gst::ClockTimeDiff {
    //    unsafe { TODO: call ffi:gst_rtsp_media_seekable() }
    //}

    #[doc(alias = "gst_rtsp_media_set_address_pool")]
    fn set_address_pool(&self, pool: Option<&impl IsA<RTSPAddressPool>>) {
        unsafe {
            ffi::gst_rtsp_media_set_address_pool(
                self.as_ref().to_glib_none().0,
                pool.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_rtsp_media_set_bind_mcast_address")]
    #[doc(alias = "bind-mcast-address")]
    fn set_bind_mcast_address(&self, bind_mcast_addr: bool) {
        unsafe {
            ffi::gst_rtsp_media_set_bind_mcast_address(
                self.as_ref().to_glib_none().0,
                bind_mcast_addr.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_rtsp_media_set_buffer_size")]
    #[doc(alias = "buffer-size")]
    fn set_buffer_size(&self, size: u32) {
        unsafe {
            ffi::gst_rtsp_media_set_buffer_size(self.as_ref().to_glib_none().0, size);
        }
    }

    #[doc(alias = "gst_rtsp_media_set_clock")]
    #[doc(alias = "clock")]
    fn set_clock(&self, clock: Option<&impl IsA<gst::Clock>>) {
        unsafe {
            ffi::gst_rtsp_media_set_clock(
                self.as_ref().to_glib_none().0,
                clock.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_rtsp_media_set_do_retransmission")]
    fn set_do_retransmission(&self, do_retransmission: bool) {
        unsafe {
            ffi::gst_rtsp_media_set_do_retransmission(
                self.as_ref().to_glib_none().0,
                do_retransmission.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_set_dscp_qos")]
    #[doc(alias = "dscp-qos")]
    fn set_dscp_qos(&self, dscp_qos: i32) {
        unsafe {
            ffi::gst_rtsp_media_set_dscp_qos(self.as_ref().to_glib_none().0, dscp_qos);
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_rtsp_media_set_ensure_keyunit_on_start")]
    #[doc(alias = "ensure-keyunit-on-start")]
    fn set_ensure_keyunit_on_start(&self, ensure_keyunit_on_start: bool) {
        unsafe {
            ffi::gst_rtsp_media_set_ensure_keyunit_on_start(
                self.as_ref().to_glib_none().0,
                ensure_keyunit_on_start.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_rtsp_media_set_ensure_keyunit_on_start_timeout")]
    #[doc(alias = "ensure-keyunit-on-start-timeout")]
    fn set_ensure_keyunit_on_start_timeout(&self, timeout: u32) {
        unsafe {
            ffi::gst_rtsp_media_set_ensure_keyunit_on_start_timeout(
                self.as_ref().to_glib_none().0,
                timeout,
            );
        }
    }

    #[doc(alias = "gst_rtsp_media_set_eos_shutdown")]
    #[doc(alias = "eos-shutdown")]
    fn set_eos_shutdown(&self, eos_shutdown: bool) {
        unsafe {
            ffi::gst_rtsp_media_set_eos_shutdown(
                self.as_ref().to_glib_none().0,
                eos_shutdown.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_rtsp_media_set_latency")]
    #[doc(alias = "latency")]
    fn set_latency(&self, latency: u32) {
        unsafe {
            ffi::gst_rtsp_media_set_latency(self.as_ref().to_glib_none().0, latency);
        }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_rtsp_media_set_max_mcast_ttl")]
    #[doc(alias = "max-mcast-ttl")]
    fn set_max_mcast_ttl(&self, ttl: u32) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_set_max_mcast_ttl(
                self.as_ref().to_glib_none().0,
                ttl,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_set_multicast_iface")]
    fn set_multicast_iface(&self, multicast_iface: Option<&str>) {
        unsafe {
            ffi::gst_rtsp_media_set_multicast_iface(
                self.as_ref().to_glib_none().0,
                multicast_iface.to_glib_none().0,
            );
        }
    }

    //#[doc(alias = "gst_rtsp_media_set_permissions")]
    //fn set_permissions(&self, permissions: /*Ignored*/Option<&mut RTSPPermissions>) {
    //    unsafe { TODO: call ffi:gst_rtsp_media_set_permissions() }
    //}

    #[doc(alias = "gst_rtsp_media_set_pipeline_state")]
    fn set_pipeline_state(&self, state: gst::State) {
        unsafe {
            ffi::gst_rtsp_media_set_pipeline_state(
                self.as_ref().to_glib_none().0,
                state.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_rtsp_media_set_profiles")]
    #[doc(alias = "profiles")]
    fn set_profiles(&self, profiles: gst_rtsp::RTSPProfile) {
        unsafe {
            ffi::gst_rtsp_media_set_profiles(self.as_ref().to_glib_none().0, profiles.into_glib());
        }
    }

    #[doc(alias = "gst_rtsp_media_set_protocols")]
    #[doc(alias = "protocols")]
    fn set_protocols(&self, protocols: gst_rtsp::RTSPLowerTrans) {
        unsafe {
            ffi::gst_rtsp_media_set_protocols(
                self.as_ref().to_glib_none().0,
                protocols.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_rtsp_media_set_publish_clock_mode")]
    fn set_publish_clock_mode(&self, mode: RTSPPublishClockMode) {
        unsafe {
            ffi::gst_rtsp_media_set_publish_clock_mode(
                self.as_ref().to_glib_none().0,
                mode.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_set_rate_control")]
    fn set_rate_control(&self, enabled: bool) {
        unsafe {
            ffi::gst_rtsp_media_set_rate_control(
                self.as_ref().to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_rtsp_media_set_retransmission_time")]
    fn set_retransmission_time(&self, time: impl Into<Option<gst::ClockTime>>) {
        unsafe {
            ffi::gst_rtsp_media_set_retransmission_time(
                self.as_ref().to_glib_none().0,
                time.into().into_glib(),
            );
        }
    }

    #[doc(alias = "gst_rtsp_media_set_reusable")]
    #[doc(alias = "reusable")]
    fn set_reusable(&self, reusable: bool) {
        unsafe {
            ffi::gst_rtsp_media_set_reusable(self.as_ref().to_glib_none().0, reusable.into_glib());
        }
    }

    #[doc(alias = "gst_rtsp_media_set_shared")]
    #[doc(alias = "shared")]
    fn set_shared(&self, shared: bool) {
        unsafe {
            ffi::gst_rtsp_media_set_shared(self.as_ref().to_glib_none().0, shared.into_glib());
        }
    }

    #[doc(alias = "gst_rtsp_media_set_state")]
    fn set_state(&self, state: gst::State, transports: &[RTSPStreamTransport]) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_media_set_state(
                self.as_ref().to_glib_none().0,
                state.into_glib(),
                transports.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_media_set_stop_on_disconnect")]
    #[doc(alias = "stop-on-disconnect")]
    fn set_stop_on_disconnect(&self, stop_on_disconnect: bool) {
        unsafe {
            ffi::gst_rtsp_media_set_stop_on_disconnect(
                self.as_ref().to_glib_none().0,
                stop_on_disconnect.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_rtsp_media_set_suspend_mode")]
    #[doc(alias = "suspend-mode")]
    fn set_suspend_mode(&self, mode: RTSPSuspendMode) {
        unsafe {
            ffi::gst_rtsp_media_set_suspend_mode(self.as_ref().to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "gst_rtsp_media_set_transport_mode")]
    #[doc(alias = "transport-mode")]
    fn set_transport_mode(&self, mode: RTSPTransportMode) {
        unsafe {
            ffi::gst_rtsp_media_set_transport_mode(
                self.as_ref().to_glib_none().0,
                mode.into_glib(),
            );
        }
    }

    //#[doc(alias = "gst_rtsp_media_setup_sdp")]
    //fn setup_sdp(&self, sdp: /*Ignored*/&mut gst_sdp::SDPMessage, info: /*Ignored*/&mut SDPInfo) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_media_setup_sdp() }
    //}

    #[doc(alias = "gst_rtsp_media_suspend")]
    fn suspend(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_rtsp_media_suspend(self.as_ref().to_glib_none().0),
                "Failed to suspend media"
            )
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_media_unlock")]
    fn unlock(&self) {
        unsafe {
            ffi::gst_rtsp_media_unlock(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gst_rtsp_media_unprepare")]
    fn unprepare(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_rtsp_media_unprepare(self.as_ref().to_glib_none().0),
                "Failed to unprepare media"
            )
        }
    }

    #[doc(alias = "gst_rtsp_media_unsuspend")]
    fn unsuspend(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_rtsp_media_unsuspend(self.as_ref().to_glib_none().0),
                "Failed to unsuspend media"
            )
        }
    }

    #[doc(alias = "gst_rtsp_media_use_time_provider")]
    fn use_time_provider(&self, time_provider: bool) {
        unsafe {
            ffi::gst_rtsp_media_use_time_provider(
                self.as_ref().to_glib_none().0,
                time_provider.into_glib(),
            );
        }
    }

    #[cfg(not(feature = "v1_16"))]
    #[cfg_attr(docsrs, doc(cfg(not(feature = "v1_16"))))]
    #[doc(alias = "bind-mcast-address")]
    fn is_bind_mcast_address(&self) -> bool {
        ObjectExt::property(self.as_ref(), "bind-mcast-address")
    }

    #[cfg(not(feature = "v1_16"))]
    #[cfg_attr(docsrs, doc(cfg(not(feature = "v1_16"))))]
    #[doc(alias = "bind-mcast-address")]
    fn set_bind_mcast_address(&self, bind_mcast_address: bool) {
        ObjectExt::set_property(self.as_ref(), "bind-mcast-address", bind_mcast_address)
    }

    #[cfg(not(feature = "v1_18"))]
    #[cfg_attr(docsrs, doc(cfg(not(feature = "v1_18"))))]
    #[doc(alias = "dscp-qos")]
    fn dscp_qos(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "dscp-qos")
    }

    #[cfg(not(feature = "v1_18"))]
    #[cfg_attr(docsrs, doc(cfg(not(feature = "v1_18"))))]
    #[doc(alias = "dscp-qos")]
    fn set_dscp_qos(&self, dscp_qos: i32) {
        ObjectExt::set_property(self.as_ref(), "dscp-qos", dscp_qos)
    }

    #[cfg(not(feature = "v1_16"))]
    #[cfg_attr(docsrs, doc(cfg(not(feature = "v1_16"))))]
    #[doc(alias = "max-mcast-ttl")]
    fn max_mcast_ttl(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "max-mcast-ttl")
    }

    #[cfg(not(feature = "v1_16"))]
    #[cfg_attr(docsrs, doc(cfg(not(feature = "v1_16"))))]
    #[doc(alias = "max-mcast-ttl")]
    fn set_max_mcast_ttl(&self, max_mcast_ttl: u32) {
        ObjectExt::set_property(self.as_ref(), "max-mcast-ttl", max_mcast_ttl)
    }

    #[doc(alias = "time-provider")]
    fn set_time_provider(&self, time_provider: bool) {
        ObjectExt::set_property(self.as_ref(), "time-provider", time_provider)
    }

    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    #[doc(alias = "handle-message")]
    fn connect_handle_message<F: Fn(&Self, &gst::Message) -> bool + Send + Sync + 'static>(
        &self,
        detail: Option<&str>,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn handle_message_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P, &gst::Message) -> bool + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            message: *mut gst::ffi::GstMessage,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    RTSPMedia::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(message),
                )
                .into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            let detailed_signal_name = detail.map(|name| format!("handle-message::{name}\0"));
            let signal_name: &[u8] = detailed_signal_name
                .as_ref()
                .map_or(c"handle-message".to_bytes(), |n| n.as_bytes());
            connect_raw(
                self.as_ptr() as *mut _,
                signal_name.as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    handle_message_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "new-state")]
    fn connect_new_state<F: Fn(&Self, i32) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn new_state_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P, i32) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            object: std::ffi::c_int,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref(), object)
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"new-state".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    new_state_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "new-stream")]
    fn connect_new_stream<F: Fn(&Self, &RTSPStream) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn new_stream_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P, &RTSPStream) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            object: *mut ffi::GstRTSPStream,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    RTSPMedia::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(object),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"new-stream".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    new_stream_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "prepared")]
    fn connect_prepared<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn prepared_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"prepared".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    prepared_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "removed-stream")]
    fn connect_removed_stream<F: Fn(&Self, &RTSPStream) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn removed_stream_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P, &RTSPStream) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            object: *mut ffi::GstRTSPStream,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    RTSPMedia::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(object),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"removed-stream".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    removed_stream_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "target-state")]
    fn connect_target_state<F: Fn(&Self, i32) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn target_state_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P, i32) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            object: std::ffi::c_int,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref(), object)
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"target-state".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    target_state_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "unprepared")]
    fn connect_unprepared<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unprepared_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"unprepared".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    unprepared_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "bind-mcast-address")]
    fn connect_bind_mcast_address_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_bind_mcast_address_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::bind-mcast-address".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_bind_mcast_address_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "buffer-size")]
    fn connect_buffer_size_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_size_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::buffer-size".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_buffer_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "clock")]
    fn connect_clock_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_clock_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::clock".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_clock_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "dscp-qos")]
    fn connect_dscp_qos_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_dscp_qos_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::dscp-qos".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_dscp_qos_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "ensure-keyunit-on-start")]
    fn connect_ensure_keyunit_on_start_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_ensure_keyunit_on_start_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::ensure-keyunit-on-start".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_ensure_keyunit_on_start_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "ensure-keyunit-on-start-timeout")]
    fn connect_ensure_keyunit_on_start_timeout_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_ensure_keyunit_on_start_timeout_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::ensure-keyunit-on-start-timeout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_ensure_keyunit_on_start_timeout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "eos-shutdown")]
    fn connect_eos_shutdown_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_eos_shutdown_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::eos-shutdown".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_eos_shutdown_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "latency")]
    fn connect_latency_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_latency_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::latency".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_latency_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-mcast-ttl")]
    fn connect_max_mcast_ttl_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_mcast_ttl_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::max-mcast-ttl".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_max_mcast_ttl_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "profiles")]
    fn connect_profiles_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_profiles_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::profiles".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_profiles_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "protocols")]
    fn connect_protocols_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_protocols_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::protocols".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_protocols_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reusable")]
    fn connect_reusable_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_reusable_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::reusable".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_reusable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "shared")]
    fn connect_shared_notify<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_shared_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::shared".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_shared_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stop-on-disconnect")]
    fn connect_stop_on_disconnect_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_stop_on_disconnect_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::stop-on-disconnect".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_stop_on_disconnect_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "suspend-mode")]
    fn connect_suspend_mode_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_suspend_mode_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::suspend-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_suspend_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "time-provider")]
    fn connect_time_provider_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_time_provider_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::time-provider".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_time_provider_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "transport-mode")]
    fn connect_transport_mode_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_transport_mode_trampoline<
            P: IsA<RTSPMedia>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPMedia,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(RTSPMedia::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::transport-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_transport_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<RTSPMedia>> RTSPMediaExt for O {}
