// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{
    PlayerAudioInfo, PlayerColorBalanceType, PlayerMediaInfo, PlayerSignalDispatcher, PlayerState,
    PlayerSubtitleInfo, PlayerVideoInfo, PlayerVideoRenderer, PlayerVisualization, ffi,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstPlayer")]
    pub struct Player(Object<ffi::GstPlayer, ffi::GstPlayerClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_player_get_type(),
    }
}

impl Player {
    #[doc(alias = "gst_player_new")]
    pub fn new(
        video_renderer: Option<impl IsA<PlayerVideoRenderer>>,
        signal_dispatcher: Option<impl IsA<PlayerSignalDispatcher>>,
    ) -> Player {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gst_player_new(
                video_renderer.map(|p| p.upcast()).into_glib_ptr(),
                signal_dispatcher.map(|p| p.upcast()).into_glib_ptr(),
            ))
        }
    }

    #[doc(alias = "gst_player_get_audio_video_offset")]
    #[doc(alias = "get_audio_video_offset")]
    #[doc(alias = "audio-video-offset")]
    pub fn audio_video_offset(&self) -> i64 {
        unsafe { ffi::gst_player_get_audio_video_offset(self.to_glib_none().0) }
    }

    #[doc(alias = "gst_player_get_color_balance")]
    #[doc(alias = "get_color_balance")]
    pub fn color_balance(&self, type_: PlayerColorBalanceType) -> f64 {
        unsafe { ffi::gst_player_get_color_balance(self.to_glib_none().0, type_.into_glib()) }
    }

    #[doc(alias = "gst_player_get_current_audio_track")]
    #[doc(alias = "get_current_audio_track")]
    #[doc(alias = "current-audio-track")]
    pub fn current_audio_track(&self) -> Option<PlayerAudioInfo> {
        unsafe {
            from_glib_full(ffi::gst_player_get_current_audio_track(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_player_get_current_subtitle_track")]
    #[doc(alias = "get_current_subtitle_track")]
    #[doc(alias = "current-subtitle-track")]
    pub fn current_subtitle_track(&self) -> Option<PlayerSubtitleInfo> {
        unsafe {
            from_glib_full(ffi::gst_player_get_current_subtitle_track(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_player_get_current_video_track")]
    #[doc(alias = "get_current_video_track")]
    #[doc(alias = "current-video-track")]
    pub fn current_video_track(&self) -> Option<PlayerVideoInfo> {
        unsafe {
            from_glib_full(ffi::gst_player_get_current_video_track(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_player_get_current_visualization")]
    #[doc(alias = "get_current_visualization")]
    pub fn current_visualization(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gst_player_get_current_visualization(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_player_get_duration")]
    #[doc(alias = "get_duration")]
    pub fn duration(&self) -> Option<gst::ClockTime> {
        unsafe { from_glib(ffi::gst_player_get_duration(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_get_media_info")]
    #[doc(alias = "get_media_info")]
    #[doc(alias = "media-info")]
    pub fn media_info(&self) -> Option<PlayerMediaInfo> {
        unsafe { from_glib_full(ffi::gst_player_get_media_info(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_get_multiview_flags")]
    #[doc(alias = "get_multiview_flags")]
    pub fn multiview_flags(&self) -> gst_video::VideoMultiviewFlags {
        unsafe { from_glib(ffi::gst_player_get_multiview_flags(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_get_multiview_mode")]
    #[doc(alias = "get_multiview_mode")]
    pub fn multiview_mode(&self) -> gst_video::VideoMultiviewFramePacking {
        unsafe { from_glib(ffi::gst_player_get_multiview_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_get_mute")]
    #[doc(alias = "get_mute")]
    #[doc(alias = "mute")]
    pub fn is_muted(&self) -> bool {
        unsafe { from_glib(ffi::gst_player_get_mute(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_get_pipeline")]
    #[doc(alias = "get_pipeline")]
    pub fn pipeline(&self) -> gst::Element {
        unsafe { from_glib_full(ffi::gst_player_get_pipeline(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_get_position")]
    #[doc(alias = "get_position")]
    pub fn position(&self) -> Option<gst::ClockTime> {
        unsafe { from_glib(ffi::gst_player_get_position(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_get_rate")]
    #[doc(alias = "get_rate")]
    pub fn rate(&self) -> f64 {
        unsafe { ffi::gst_player_get_rate(self.to_glib_none().0) }
    }

    #[doc(alias = "gst_player_get_subtitle_uri")]
    #[doc(alias = "get_subtitle_uri")]
    pub fn subtitle_uri(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::gst_player_get_subtitle_uri(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_player_get_subtitle_video_offset")]
    #[doc(alias = "get_subtitle_video_offset")]
    #[doc(alias = "subtitle-video-offset")]
    pub fn subtitle_video_offset(&self) -> i64 {
        unsafe { ffi::gst_player_get_subtitle_video_offset(self.to_glib_none().0) }
    }

    #[doc(alias = "gst_player_get_uri")]
    #[doc(alias = "get_uri")]
    pub fn uri(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::gst_player_get_uri(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_get_volume")]
    #[doc(alias = "get_volume")]
    pub fn volume(&self) -> f64 {
        unsafe { ffi::gst_player_get_volume(self.to_glib_none().0) }
    }

    #[doc(alias = "gst_player_has_color_balance")]
    pub fn has_color_balance(&self) -> bool {
        unsafe { from_glib(ffi::gst_player_has_color_balance(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_player_pause")]
    pub fn pause(&self) {
        unsafe {
            ffi::gst_player_pause(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_player_play")]
    pub fn play(&self) {
        unsafe {
            ffi::gst_player_play(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_player_seek")]
    pub fn seek(&self, position: gst::ClockTime) {
        unsafe {
            ffi::gst_player_seek(self.to_glib_none().0, position.into_glib());
        }
    }

    #[doc(alias = "gst_player_set_audio_track")]
    pub fn set_audio_track(&self, stream_index: i32) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_player_set_audio_track(self.to_glib_none().0, stream_index),
                "Failed to set audio track"
            )
        }
    }

    #[doc(alias = "gst_player_set_audio_track_enabled")]
    pub fn set_audio_track_enabled(&self, enabled: bool) {
        unsafe {
            ffi::gst_player_set_audio_track_enabled(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "gst_player_set_audio_video_offset")]
    #[doc(alias = "audio-video-offset")]
    pub fn set_audio_video_offset(&self, offset: i64) {
        unsafe {
            ffi::gst_player_set_audio_video_offset(self.to_glib_none().0, offset);
        }
    }

    #[doc(alias = "gst_player_set_color_balance")]
    pub fn set_color_balance(&self, type_: PlayerColorBalanceType, value: f64) {
        unsafe {
            ffi::gst_player_set_color_balance(self.to_glib_none().0, type_.into_glib(), value);
        }
    }

    #[doc(alias = "gst_player_set_multiview_flags")]
    pub fn set_multiview_flags(&self, flags: gst_video::VideoMultiviewFlags) {
        unsafe {
            ffi::gst_player_set_multiview_flags(self.to_glib_none().0, flags.into_glib());
        }
    }

    #[doc(alias = "gst_player_set_multiview_mode")]
    pub fn set_multiview_mode(&self, mode: gst_video::VideoMultiviewFramePacking) {
        unsafe {
            ffi::gst_player_set_multiview_mode(self.to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "gst_player_set_mute")]
    #[doc(alias = "mute")]
    pub fn set_mute(&self, val: bool) {
        unsafe {
            ffi::gst_player_set_mute(self.to_glib_none().0, val.into_glib());
        }
    }

    #[doc(alias = "gst_player_set_rate")]
    #[doc(alias = "rate")]
    pub fn set_rate(&self, rate: f64) {
        unsafe {
            ffi::gst_player_set_rate(self.to_glib_none().0, rate);
        }
    }

    #[doc(alias = "gst_player_set_subtitle_track")]
    pub fn set_subtitle_track(&self, stream_index: i32) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_player_set_subtitle_track(self.to_glib_none().0, stream_index),
                "Failed to set subtitle track"
            )
        }
    }

    #[doc(alias = "gst_player_set_subtitle_track_enabled")]
    pub fn set_subtitle_track_enabled(&self, enabled: bool) {
        unsafe {
            ffi::gst_player_set_subtitle_track_enabled(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "gst_player_set_subtitle_uri")]
    pub fn set_subtitle_uri(&self, uri: Option<&str>) {
        unsafe {
            ffi::gst_player_set_subtitle_uri(self.to_glib_none().0, uri.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_player_set_subtitle_video_offset")]
    #[doc(alias = "subtitle-video-offset")]
    pub fn set_subtitle_video_offset(&self, offset: i64) {
        unsafe {
            ffi::gst_player_set_subtitle_video_offset(self.to_glib_none().0, offset);
        }
    }

    #[doc(alias = "gst_player_set_uri")]
    #[doc(alias = "uri")]
    pub fn set_uri(&self, uri: Option<&str>) {
        unsafe {
            ffi::gst_player_set_uri(self.to_glib_none().0, uri.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_player_set_video_track")]
    pub fn set_video_track(&self, stream_index: i32) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_player_set_video_track(self.to_glib_none().0, stream_index),
                "Failed to set video track"
            )
        }
    }

    #[doc(alias = "gst_player_set_video_track_enabled")]
    pub fn set_video_track_enabled(&self, enabled: bool) {
        unsafe {
            ffi::gst_player_set_video_track_enabled(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "gst_player_set_visualization")]
    pub fn set_visualization(&self, name: Option<&str>) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_player_set_visualization(self.to_glib_none().0, name.to_glib_none().0),
                "Failed to set visualization"
            )
        }
    }

    #[doc(alias = "gst_player_set_visualization_enabled")]
    pub fn set_visualization_enabled(&self, enabled: bool) {
        unsafe {
            ffi::gst_player_set_visualization_enabled(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "gst_player_set_volume")]
    #[doc(alias = "volume")]
    pub fn set_volume(&self, val: f64) {
        unsafe {
            ffi::gst_player_set_volume(self.to_glib_none().0, val);
        }
    }

    #[doc(alias = "gst_player_stop")]
    pub fn stop(&self) {
        unsafe {
            ffi::gst_player_stop(self.to_glib_none().0);
        }
    }

    pub fn suburi(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "suburi")
    }

    pub fn set_suburi(&self, suburi: Option<&str>) {
        ObjectExt::set_property(self, "suburi", suburi)
    }

    #[doc(alias = "video-multiview-flags")]
    pub fn video_multiview_flags(&self) -> gst_video::VideoMultiviewFlags {
        ObjectExt::property(self, "video-multiview-flags")
    }

    #[doc(alias = "video-multiview-flags")]
    pub fn set_video_multiview_flags(&self, video_multiview_flags: gst_video::VideoMultiviewFlags) {
        ObjectExt::set_property(self, "video-multiview-flags", video_multiview_flags)
    }

    #[doc(alias = "video-multiview-mode")]
    pub fn video_multiview_mode(&self) -> gst_video::VideoMultiviewFramePacking {
        ObjectExt::property(self, "video-multiview-mode")
    }

    #[doc(alias = "video-multiview-mode")]
    pub fn set_video_multiview_mode(
        &self,
        video_multiview_mode: gst_video::VideoMultiviewFramePacking,
    ) {
        ObjectExt::set_property(self, "video-multiview-mode", video_multiview_mode)
    }

    #[doc(alias = "video-renderer")]
    pub fn video_renderer(&self) -> Option<PlayerVideoRenderer> {
        ObjectExt::property(self, "video-renderer")
    }

    #[doc(alias = "gst_player_get_audio_streams")]
    #[doc(alias = "get_audio_streams")]
    pub fn audio_streams(info: &PlayerMediaInfo) -> Vec<PlayerAudioInfo> {
        skip_assert_initialized!();
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gst_player_get_audio_streams(
                info.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_player_get_subtitle_streams")]
    #[doc(alias = "get_subtitle_streams")]
    pub fn subtitle_streams(info: &PlayerMediaInfo) -> Vec<PlayerSubtitleInfo> {
        skip_assert_initialized!();
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gst_player_get_subtitle_streams(
                info.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_player_get_video_streams")]
    #[doc(alias = "get_video_streams")]
    pub fn video_streams(info: &PlayerMediaInfo) -> Vec<PlayerVideoInfo> {
        skip_assert_initialized!();
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gst_player_get_video_streams(
                info.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_player_visualizations_get")]
    pub fn visualizations_get() -> Vec<PlayerVisualization> {
        assert_initialized_main_thread!();
        unsafe { FromGlibPtrContainer::from_glib_full(ffi::gst_player_visualizations_get()) }
    }

    #[doc(alias = "buffering")]
    pub fn connect_buffering<F: Fn(&Self, i32) + Send + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn buffering_trampoline<F: Fn(&Player, i32) + Send + 'static>(
            this: *mut ffi::GstPlayer,
            object: std::ffi::c_int,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), object)
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"buffering".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    buffering_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "end-of-stream")]
    pub fn connect_end_of_stream<F: Fn(&Self) + Send + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn end_of_stream_trampoline<F: Fn(&Player) + Send + 'static>(
            this: *mut ffi::GstPlayer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"end-of-stream".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    end_of_stream_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "error")]
    pub fn connect_error<F: Fn(&Self, &glib::Error) + Send + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn error_trampoline<F: Fn(&Player, &glib::Error) + Send + 'static>(
            this: *mut ffi::GstPlayer,
            object: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), &from_glib_borrow(object))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"error".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "media-info-updated")]
    pub fn connect_media_info_updated<F: Fn(&Self, &PlayerMediaInfo) + Send + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn media_info_updated_trampoline<
            F: Fn(&Player, &PlayerMediaInfo) + Send + 'static,
        >(
            this: *mut ffi::GstPlayer,
            object: *mut ffi::GstPlayerMediaInfo,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), &from_glib_borrow(object))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"media-info-updated".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    media_info_updated_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mute-changed")]
    pub fn connect_mute_changed<F: Fn(&Self) + Send + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn mute_changed_trampoline<F: Fn(&Player) + Send + 'static>(
            this: *mut ffi::GstPlayer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"mute-changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    mute_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "state-changed")]
    pub fn connect_state_changed<F: Fn(&Self, PlayerState) + Send + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn state_changed_trampoline<
            F: Fn(&Player, PlayerState) + Send + 'static,
        >(
            this: *mut ffi::GstPlayer,
            object: ffi::GstPlayerState,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), from_glib(object))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"state-changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    state_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "uri-loaded")]
    pub fn connect_uri_loaded<F: Fn(&Self, &str) + Send + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn uri_loaded_trampoline<F: Fn(&Player, &str) + Send + 'static>(
            this: *mut ffi::GstPlayer,
            object: *mut std::ffi::c_char,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    &from_glib_borrow(this),
                    &glib::GString::from_glib_borrow(object),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"uri-loaded".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    uri_loaded_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "video-dimensions-changed")]
    pub fn connect_video_dimensions_changed<F: Fn(&Self, i32, i32) + Send + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn video_dimensions_changed_trampoline<
            F: Fn(&Player, i32, i32) + Send + 'static,
        >(
            this: *mut ffi::GstPlayer,
            object: std::ffi::c_int,
            p0: std::ffi::c_int,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), object, p0)
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"video-dimensions-changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    video_dimensions_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "volume-changed")]
    pub fn connect_volume_changed<F: Fn(&Self) + Send + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn volume_changed_trampoline<F: Fn(&Player) + Send + 'static>(
            this: *mut ffi::GstPlayer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"volume-changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    volume_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "warning")]
    pub fn connect_warning<F: Fn(&Self, &glib::Error) + Send + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn warning_trampoline<F: Fn(&Player, &glib::Error) + Send + 'static>(
            this: *mut ffi::GstPlayer,
            object: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), &from_glib_borrow(object))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"warning".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    warning_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "audio-video-offset")]
    pub fn connect_audio_video_offset_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_audio_video_offset_trampoline<
            F: Fn(&Player) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::audio-video-offset".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_audio_video_offset_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "current-audio-track")]
    pub fn connect_current_audio_track_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_audio_track_trampoline<
            F: Fn(&Player) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::current-audio-track".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_current_audio_track_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "current-subtitle-track")]
    pub fn connect_current_subtitle_track_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_subtitle_track_trampoline<
            F: Fn(&Player) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::current-subtitle-track".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_current_subtitle_track_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "current-video-track")]
    pub fn connect_current_video_track_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_video_track_trampoline<
            F: Fn(&Player) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::current-video-track".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_current_video_track_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "duration")]
    pub fn connect_duration_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_duration_trampoline<F: Fn(&Player) + Send + Sync + 'static>(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::duration".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "media-info")]
    pub fn connect_media_info_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_media_info_trampoline<
            F: Fn(&Player) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::media-info".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_media_info_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mute")]
    pub fn connect_mute_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_mute_trampoline<F: Fn(&Player) + Send + Sync + 'static>(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::mute".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_mute_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pipeline")]
    pub fn connect_pipeline_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pipeline_trampoline<F: Fn(&Player) + Send + Sync + 'static>(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::pipeline".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_pipeline_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "position")]
    pub fn connect_position_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_position_trampoline<F: Fn(&Player) + Send + Sync + 'static>(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::position".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_position_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "rate")]
    pub fn connect_rate_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_rate_trampoline<F: Fn(&Player) + Send + Sync + 'static>(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::rate".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_rate_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "subtitle-video-offset")]
    pub fn connect_subtitle_video_offset_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtitle_video_offset_trampoline<
            F: Fn(&Player) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::subtitle-video-offset".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_subtitle_video_offset_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "suburi")]
    pub fn connect_suburi_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_suburi_trampoline<F: Fn(&Player) + Send + Sync + 'static>(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::suburi".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_suburi_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "uri")]
    pub fn connect_uri_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_uri_trampoline<F: Fn(&Player) + Send + Sync + 'static>(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::uri".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_uri_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "video-multiview-flags")]
    pub fn connect_video_multiview_flags_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_video_multiview_flags_trampoline<
            F: Fn(&Player) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::video-multiview-flags".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_video_multiview_flags_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "video-multiview-mode")]
    pub fn connect_video_multiview_mode_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_video_multiview_mode_trampoline<
            F: Fn(&Player) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::video-multiview-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_video_multiview_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "volume")]
    pub fn connect_volume_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_volume_trampoline<F: Fn(&Player) + Send + Sync + 'static>(
            this: *mut ffi::GstPlayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::volume".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_volume_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

unsafe impl Send for Player {}
unsafe impl Sync for Player {}
