// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{
    MediaSourceEOSError, MediaSourceRange, MediaSourceReadyState, MseSrc, SourceBuffer,
    SourceBufferList, ffi,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstMediaSource")]
    pub struct MediaSource(Object<ffi::GstMediaSource, ffi::GstMediaSourceClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_media_source_get_type(),
    }
}

impl MediaSource {
    #[doc(alias = "gst_media_source_new")]
    pub fn new() -> MediaSource {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_media_source_new()) }
    }

    #[doc(alias = "gst_media_source_add_source_buffer")]
    pub fn add_source_buffer(&self, type_: &str) -> Result<SourceBuffer, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gst_media_source_add_source_buffer(
                self.to_glib_none().0,
                type_.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_media_source_attach")]
    pub fn attach(&self, element: &MseSrc) {
        unsafe {
            ffi::gst_media_source_attach(self.to_glib_none().0, element.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_media_source_clear_live_seekable_range")]
    pub fn clear_live_seekable_range(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok =
                ffi::gst_media_source_clear_live_seekable_range(self.to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_media_source_detach")]
    pub fn detach(&self) {
        unsafe {
            ffi::gst_media_source_detach(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_media_source_end_of_stream")]
    pub fn end_of_stream(&self, eos_error: MediaSourceEOSError) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_media_source_end_of_stream(
                self.to_glib_none().0,
                eos_error.into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_media_source_get_active_source_buffers")]
    #[doc(alias = "get_active_source_buffers")]
    #[doc(alias = "active-source-buffers")]
    pub fn active_source_buffers(&self) -> SourceBufferList {
        unsafe {
            from_glib_full(ffi::gst_media_source_get_active_source_buffers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_media_source_get_duration")]
    #[doc(alias = "get_duration")]
    pub fn duration(&self) -> Option<gst::ClockTime> {
        unsafe { from_glib(ffi::gst_media_source_get_duration(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_media_source_get_live_seekable_range")]
    #[doc(alias = "get_live_seekable_range")]
    pub fn live_seekable_range(&self) -> MediaSourceRange {
        unsafe {
            let mut range = MediaSourceRange::uninitialized();
            ffi::gst_media_source_get_live_seekable_range(
                self.to_glib_none().0,
                range.to_glib_none_mut().0,
            );
            range
        }
    }

    #[doc(alias = "gst_media_source_get_position")]
    #[doc(alias = "get_position")]
    pub fn position(&self) -> Option<gst::ClockTime> {
        unsafe { from_glib(ffi::gst_media_source_get_position(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_media_source_get_ready_state")]
    #[doc(alias = "get_ready_state")]
    #[doc(alias = "ready-state")]
    pub fn ready_state(&self) -> MediaSourceReadyState {
        unsafe { from_glib(ffi::gst_media_source_get_ready_state(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_media_source_get_source_buffers")]
    #[doc(alias = "get_source_buffers")]
    #[doc(alias = "source-buffers")]
    pub fn source_buffers(&self) -> SourceBufferList {
        unsafe {
            from_glib_full(ffi::gst_media_source_get_source_buffers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_media_source_remove_source_buffer")]
    pub fn remove_source_buffer(&self, buffer: &SourceBuffer) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_media_source_remove_source_buffer(
                self.to_glib_none().0,
                buffer.to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_media_source_set_duration")]
    #[doc(alias = "duration")]
    pub fn set_duration(
        &self,
        duration: impl Into<Option<gst::ClockTime>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_media_source_set_duration(
                self.to_glib_none().0,
                duration.into().into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_media_source_set_live_seekable_range")]
    pub fn set_live_seekable_range(
        &self,
        start: impl Into<Option<gst::ClockTime>>,
        end: impl Into<Option<gst::ClockTime>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_media_source_set_live_seekable_range(
                self.to_glib_none().0,
                start.into().into_glib(),
                end.into().into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_media_source_is_type_supported")]
    pub fn is_type_supported(type_: &str) -> bool {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gst_media_source_is_type_supported(
                type_.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "on-source-close")]
    pub fn connect_on_source_close<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn on_source_close_trampoline<
            F: Fn(&MediaSource) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstMediaSource,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"on-source-close".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    on_source_close_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "on-source-ended")]
    pub fn connect_on_source_ended<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn on_source_ended_trampoline<
            F: Fn(&MediaSource) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstMediaSource,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"on-source-ended".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    on_source_ended_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "on-source-open")]
    pub fn connect_on_source_open<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn on_source_open_trampoline<
            F: Fn(&MediaSource) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstMediaSource,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"on-source-open".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    on_source_open_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "active-source-buffers")]
    pub fn connect_active_source_buffers_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_active_source_buffers_trampoline<
            F: Fn(&MediaSource) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstMediaSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::active-source-buffers".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_active_source_buffers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "duration")]
    pub fn connect_duration_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_duration_trampoline<
            F: Fn(&MediaSource) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstMediaSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::duration".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "position")]
    pub fn connect_position_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_position_trampoline<
            F: Fn(&MediaSource) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstMediaSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::position".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_position_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "ready-state")]
    pub fn connect_ready_state_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_ready_state_trampoline<
            F: Fn(&MediaSource) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstMediaSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::ready-state".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_ready_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "source-buffers")]
    pub fn connect_source_buffers_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_source_buffers_trampoline<
            F: Fn(&MediaSource) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstMediaSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::source-buffers".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_source_buffers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for MediaSource {
    fn default() -> Self {
        Self::new()
    }
}

unsafe impl Send for MediaSource {}
unsafe impl Sync for MediaSource {}
