// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{GLContext, GLSLProfile, GLSLVersion, ffi};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GstGLSLStage")]
    pub struct GLSLStage(Object<ffi::GstGLSLStage, ffi::GstGLSLStageClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_glsl_stage_get_type(),
    }
}

impl GLSLStage {
    #[doc(alias = "gst_glsl_stage_new")]
    pub fn new(context: &impl IsA<GLContext>, type_: u32) -> GLSLStage {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(ffi::gst_glsl_stage_new(
                context.as_ref().to_glib_none().0,
                type_,
            ))
        }
    }

    #[doc(alias = "gst_glsl_stage_new_default_fragment")]
    pub fn new_default_fragment(context: &impl IsA<GLContext>) -> GLSLStage {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(ffi::gst_glsl_stage_new_default_fragment(
                context.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_glsl_stage_new_default_vertex")]
    pub fn new_default_vertex(context: &impl IsA<GLContext>) -> GLSLStage {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(ffi::gst_glsl_stage_new_default_vertex(
                context.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_glsl_stage_new_with_string")]
    #[doc(alias = "new_with_string")]
    pub fn with_string(
        context: &impl IsA<GLContext>,
        type_: u32,
        version: GLSLVersion,
        profile: GLSLProfile,
        str: &str,
    ) -> GLSLStage {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(ffi::gst_glsl_stage_new_with_string(
                context.as_ref().to_glib_none().0,
                type_,
                version.into_glib(),
                profile.into_glib(),
                str.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_glsl_stage_new_with_strings")]
    #[doc(alias = "new_with_strings")]
    pub fn with_strings(
        context: &impl IsA<GLContext>,
        type_: u32,
        version: GLSLVersion,
        profile: GLSLProfile,
        str: &[&str],
    ) -> GLSLStage {
        skip_assert_initialized!();
        let n_strings = str.len() as _;
        unsafe {
            from_glib_none(ffi::gst_glsl_stage_new_with_strings(
                context.as_ref().to_glib_none().0,
                type_,
                version.into_glib(),
                profile.into_glib(),
                n_strings,
                str.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_glsl_stage_compile")]
    pub fn compile(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_glsl_stage_compile(self.to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_glsl_stage_get_handle")]
    #[doc(alias = "get_handle")]
    pub fn handle(&self) -> u32 {
        unsafe { ffi::gst_glsl_stage_get_handle(self.to_glib_none().0) }
    }

    #[doc(alias = "gst_glsl_stage_get_profile")]
    #[doc(alias = "get_profile")]
    pub fn profile(&self) -> GLSLProfile {
        unsafe { from_glib(ffi::gst_glsl_stage_get_profile(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_glsl_stage_get_shader_type")]
    #[doc(alias = "get_shader_type")]
    pub fn shader_type(&self) -> u32 {
        unsafe { ffi::gst_glsl_stage_get_shader_type(self.to_glib_none().0) }
    }

    #[doc(alias = "gst_glsl_stage_get_version")]
    #[doc(alias = "get_version")]
    pub fn version(&self) -> GLSLVersion {
        unsafe { from_glib(ffi::gst_glsl_stage_get_version(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_glsl_stage_set_strings")]
    pub fn set_strings(
        &self,
        version: GLSLVersion,
        profile: GLSLProfile,
        str: &[&str],
    ) -> Result<(), glib::error::BoolError> {
        let n_strings = str.len() as _;
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_glsl_stage_set_strings(
                    self.to_glib_none().0,
                    version.into_glib(),
                    profile.into_glib(),
                    n_strings,
                    str.to_glib_none().0
                ),
                "Failed to attach stage to set strings"
            )
        }
    }
}

unsafe impl Send for GLSLStage {}
unsafe impl Sync for GLSLStage {}
