// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::ffi;
#[cfg(feature = "v1_16")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
use glib::GStr;
use glib::{prelude::*, translate::*};

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESAssetLoadingReturn")]
pub enum AssetLoadingReturn {
    #[doc(alias = "GES_ASSET_LOADING_ERROR")]
    Error,
    #[doc(alias = "GES_ASSET_LOADING_ASYNC")]
    Async,
    #[doc(alias = "GES_ASSET_LOADING_OK")]
    Ok,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for AssetLoadingReturn {
    type GlibType = ffi::GESAssetLoadingReturn;

    #[inline]
    fn into_glib(self) -> ffi::GESAssetLoadingReturn {
        match self {
            Self::Error => ffi::GES_ASSET_LOADING_ERROR,
            Self::Async => ffi::GES_ASSET_LOADING_ASYNC,
            Self::Ok => ffi::GES_ASSET_LOADING_OK,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESAssetLoadingReturn> for AssetLoadingReturn {
    #[inline]
    unsafe fn from_glib(value: ffi::GESAssetLoadingReturn) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_ASSET_LOADING_ERROR => Self::Error,
            ffi::GES_ASSET_LOADING_ASYNC => Self::Async,
            ffi::GES_ASSET_LOADING_OK => Self::Ok,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESChildrenControlMode")]
pub enum ChildrenControlMode {
    #[doc(alias = "GES_CHILDREN_UPDATE")]
    Update,
    #[doc(alias = "GES_CHILDREN_IGNORE_NOTIFIES")]
    IgnoreNotifies,
    #[doc(alias = "GES_CHILDREN_UPDATE_OFFSETS")]
    UpdateOffsets,
    #[doc(alias = "GES_CHILDREN_UPDATE_ALL_VALUES")]
    UpdateAllValues,
    #[doc(alias = "GES_CHILDREN_LAST")]
    Last,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ChildrenControlMode {
    type GlibType = ffi::GESChildrenControlMode;

    #[inline]
    fn into_glib(self) -> ffi::GESChildrenControlMode {
        match self {
            Self::Update => ffi::GES_CHILDREN_UPDATE,
            Self::IgnoreNotifies => ffi::GES_CHILDREN_IGNORE_NOTIFIES,
            Self::UpdateOffsets => ffi::GES_CHILDREN_UPDATE_OFFSETS,
            Self::UpdateAllValues => ffi::GES_CHILDREN_UPDATE_ALL_VALUES,
            Self::Last => ffi::GES_CHILDREN_LAST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESChildrenControlMode> for ChildrenControlMode {
    #[inline]
    unsafe fn from_glib(value: ffi::GESChildrenControlMode) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_CHILDREN_UPDATE => Self::Update,
            ffi::GES_CHILDREN_IGNORE_NOTIFIES => Self::IgnoreNotifies,
            ffi::GES_CHILDREN_UPDATE_OFFSETS => Self::UpdateOffsets,
            ffi::GES_CHILDREN_UPDATE_ALL_VALUES => Self::UpdateAllValues,
            ffi::GES_CHILDREN_LAST => Self::Last,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESEdge")]
pub enum Edge {
    #[doc(alias = "GES_EDGE_START")]
    Start,
    #[doc(alias = "GES_EDGE_END")]
    End,
    #[doc(alias = "GES_EDGE_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Edge {
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn name<'a>(self) -> &'a GStr {
        unsafe {
            GStr::from_ptr(
                ffi::ges_edge_name(self.into_glib())
                    .as_ref()
                    .expect("ges_edge_name returned NULL"),
            )
        }
    }
}

#[cfg(feature = "v1_16")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
impl std::fmt::Display for Edge {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for Edge {
    type GlibType = ffi::GESEdge;

    #[inline]
    fn into_glib(self) -> ffi::GESEdge {
        match self {
            Self::Start => ffi::GES_EDGE_START,
            Self::End => ffi::GES_EDGE_END,
            Self::None => ffi::GES_EDGE_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESEdge> for Edge {
    #[inline]
    unsafe fn from_glib(value: ffi::GESEdge) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_EDGE_START => Self::Start,
            ffi::GES_EDGE_END => Self::End,
            ffi::GES_EDGE_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Edge {
    #[inline]
    #[doc(alias = "ges_edge_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::ges_edge_get_type()) }
    }
}

impl glib::HasParamSpec for Edge {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for Edge {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for Edge {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        unsafe { from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0)) }
    }
}

impl ToValue for Edge {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<Edge> for glib::Value {
    #[inline]
    fn from(v: Edge) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESEditMode")]
pub enum EditMode {
    #[doc(alias = "GES_EDIT_MODE_NORMAL")]
    Normal,
    #[doc(alias = "GES_EDIT_MODE_RIPPLE")]
    Ripple,
    #[doc(alias = "GES_EDIT_MODE_ROLL")]
    Roll,
    #[doc(alias = "GES_EDIT_MODE_TRIM")]
    Trim,
    #[doc(alias = "GES_EDIT_MODE_SLIDE")]
    Slide,
    #[doc(hidden)]
    __Unknown(i32),
}

impl EditMode {
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn name<'a>(self) -> &'a GStr {
        unsafe {
            GStr::from_ptr(
                ffi::ges_edit_mode_name(self.into_glib())
                    .as_ref()
                    .expect("ges_edit_mode_name returned NULL"),
            )
        }
    }
}

#[cfg(feature = "v1_18")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
impl std::fmt::Display for EditMode {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for EditMode {
    type GlibType = ffi::GESEditMode;

    #[inline]
    fn into_glib(self) -> ffi::GESEditMode {
        match self {
            Self::Normal => ffi::GES_EDIT_MODE_NORMAL,
            Self::Ripple => ffi::GES_EDIT_MODE_RIPPLE,
            Self::Roll => ffi::GES_EDIT_MODE_ROLL,
            Self::Trim => ffi::GES_EDIT_MODE_TRIM,
            Self::Slide => ffi::GES_EDIT_MODE_SLIDE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESEditMode> for EditMode {
    #[inline]
    unsafe fn from_glib(value: ffi::GESEditMode) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_EDIT_MODE_NORMAL => Self::Normal,
            ffi::GES_EDIT_MODE_RIPPLE => Self::Ripple,
            ffi::GES_EDIT_MODE_ROLL => Self::Roll,
            ffi::GES_EDIT_MODE_TRIM => Self::Trim,
            ffi::GES_EDIT_MODE_SLIDE => Self::Slide,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for EditMode {
    #[inline]
    #[doc(alias = "ges_edit_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::ges_edit_mode_get_type()) }
    }
}

impl glib::HasParamSpec for EditMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for EditMode {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for EditMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        unsafe { from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0)) }
    }
}

impl ToValue for EditMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<EditMode> for glib::Value {
    #[inline]
    fn from(v: EditMode) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESError")]
pub enum Error {
    #[doc(alias = "GES_ERROR_ASSET_WRONG_ID")]
    AssetWrongId,
    #[doc(alias = "GES_ERROR_ASSET_LOADING")]
    AssetLoading,
    #[doc(alias = "GES_ERROR_FORMATTER_MALFORMED_INPUT_FILE")]
    FormatterMalformedInputFile,
    #[doc(alias = "GES_ERROR_INVALID_FRAME_NUMBER")]
    InvalidFrameNumber,
    #[doc(alias = "GES_ERROR_NEGATIVE_LAYER")]
    NegativeLayer,
    #[doc(alias = "GES_ERROR_NEGATIVE_TIME")]
    NegativeTime,
    #[doc(alias = "GES_ERROR_NOT_ENOUGH_INTERNAL_CONTENT")]
    NotEnoughInternalContent,
    #[doc(alias = "GES_ERROR_INVALID_OVERLAP_IN_TRACK")]
    InvalidOverlapInTrack,
    #[doc(alias = "GES_ERROR_INVALID_EFFECT_BIN_DESCRIPTION")]
    InvalidEffectBinDescription,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for Error {
    type GlibType = ffi::GESError;

    #[inline]
    fn into_glib(self) -> ffi::GESError {
        match self {
            Self::AssetWrongId => ffi::GES_ERROR_ASSET_WRONG_ID,
            Self::AssetLoading => ffi::GES_ERROR_ASSET_LOADING,
            Self::FormatterMalformedInputFile => ffi::GES_ERROR_FORMATTER_MALFORMED_INPUT_FILE,
            Self::InvalidFrameNumber => ffi::GES_ERROR_INVALID_FRAME_NUMBER,
            Self::NegativeLayer => ffi::GES_ERROR_NEGATIVE_LAYER,
            Self::NegativeTime => ffi::GES_ERROR_NEGATIVE_TIME,
            Self::NotEnoughInternalContent => ffi::GES_ERROR_NOT_ENOUGH_INTERNAL_CONTENT,
            Self::InvalidOverlapInTrack => ffi::GES_ERROR_INVALID_OVERLAP_IN_TRACK,
            Self::InvalidEffectBinDescription => ffi::GES_ERROR_INVALID_EFFECT_BIN_DESCRIPTION,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESError> for Error {
    #[inline]
    unsafe fn from_glib(value: ffi::GESError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_ERROR_ASSET_WRONG_ID => Self::AssetWrongId,
            ffi::GES_ERROR_ASSET_LOADING => Self::AssetLoading,
            ffi::GES_ERROR_FORMATTER_MALFORMED_INPUT_FILE => Self::FormatterMalformedInputFile,
            ffi::GES_ERROR_INVALID_FRAME_NUMBER => Self::InvalidFrameNumber,
            ffi::GES_ERROR_NEGATIVE_LAYER => Self::NegativeLayer,
            ffi::GES_ERROR_NEGATIVE_TIME => Self::NegativeTime,
            ffi::GES_ERROR_NOT_ENOUGH_INTERNAL_CONTENT => Self::NotEnoughInternalContent,
            ffi::GES_ERROR_INVALID_OVERLAP_IN_TRACK => Self::InvalidOverlapInTrack,
            ffi::GES_ERROR_INVALID_EFFECT_BIN_DESCRIPTION => Self::InvalidEffectBinDescription,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for Error {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"GES_ERROR\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESTextHAlign")]
pub enum TextHAlign {
    #[doc(alias = "GES_TEXT_HALIGN_LEFT")]
    Left,
    #[doc(alias = "GES_TEXT_HALIGN_CENTER")]
    Center,
    #[doc(alias = "GES_TEXT_HALIGN_RIGHT")]
    Right,
    #[doc(alias = "GES_TEXT_HALIGN_POSITION")]
    Position,
    #[doc(alias = "GES_TEXT_HALIGN_ABSOLUTE")]
    Absolute,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TextHAlign {
    type GlibType = ffi::GESTextHAlign;

    #[inline]
    fn into_glib(self) -> ffi::GESTextHAlign {
        match self {
            Self::Left => ffi::GES_TEXT_HALIGN_LEFT,
            Self::Center => ffi::GES_TEXT_HALIGN_CENTER,
            Self::Right => ffi::GES_TEXT_HALIGN_RIGHT,
            Self::Position => ffi::GES_TEXT_HALIGN_POSITION,
            Self::Absolute => ffi::GES_TEXT_HALIGN_ABSOLUTE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESTextHAlign> for TextHAlign {
    #[inline]
    unsafe fn from_glib(value: ffi::GESTextHAlign) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_TEXT_HALIGN_LEFT => Self::Left,
            ffi::GES_TEXT_HALIGN_CENTER => Self::Center,
            ffi::GES_TEXT_HALIGN_RIGHT => Self::Right,
            ffi::GES_TEXT_HALIGN_POSITION => Self::Position,
            ffi::GES_TEXT_HALIGN_ABSOLUTE => Self::Absolute,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextHAlign {
    #[inline]
    #[doc(alias = "ges_text_halign_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::ges_text_halign_get_type()) }
    }
}

impl glib::HasParamSpec for TextHAlign {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for TextHAlign {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TextHAlign {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        unsafe { from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0)) }
    }
}

impl ToValue for TextHAlign {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TextHAlign> for glib::Value {
    #[inline]
    fn from(v: TextHAlign) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESTextVAlign")]
pub enum TextVAlign {
    #[doc(alias = "GES_TEXT_VALIGN_BASELINE")]
    Baseline,
    #[doc(alias = "GES_TEXT_VALIGN_BOTTOM")]
    Bottom,
    #[doc(alias = "GES_TEXT_VALIGN_TOP")]
    Top,
    #[doc(alias = "GES_TEXT_VALIGN_POSITION")]
    Position,
    #[doc(alias = "GES_TEXT_VALIGN_CENTER")]
    Center,
    #[doc(alias = "GES_TEXT_VALIGN_ABSOLUTE")]
    Absolute,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TextVAlign {
    type GlibType = ffi::GESTextVAlign;

    #[inline]
    fn into_glib(self) -> ffi::GESTextVAlign {
        match self {
            Self::Baseline => ffi::GES_TEXT_VALIGN_BASELINE,
            Self::Bottom => ffi::GES_TEXT_VALIGN_BOTTOM,
            Self::Top => ffi::GES_TEXT_VALIGN_TOP,
            Self::Position => ffi::GES_TEXT_VALIGN_POSITION,
            Self::Center => ffi::GES_TEXT_VALIGN_CENTER,
            Self::Absolute => ffi::GES_TEXT_VALIGN_ABSOLUTE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESTextVAlign> for TextVAlign {
    #[inline]
    unsafe fn from_glib(value: ffi::GESTextVAlign) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_TEXT_VALIGN_BASELINE => Self::Baseline,
            ffi::GES_TEXT_VALIGN_BOTTOM => Self::Bottom,
            ffi::GES_TEXT_VALIGN_TOP => Self::Top,
            ffi::GES_TEXT_VALIGN_POSITION => Self::Position,
            ffi::GES_TEXT_VALIGN_CENTER => Self::Center,
            ffi::GES_TEXT_VALIGN_ABSOLUTE => Self::Absolute,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TextVAlign {
    #[inline]
    #[doc(alias = "ges_text_valign_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::ges_text_valign_get_type()) }
    }
}

impl glib::HasParamSpec for TextVAlign {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for TextVAlign {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TextVAlign {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        unsafe { from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0)) }
    }
}

impl ToValue for TextVAlign {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TextVAlign> for glib::Value {
    #[inline]
    fn from(v: TextVAlign) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESVideoStandardTransitionType")]
pub enum VideoStandardTransitionType {
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_NONE")]
    None,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_LR")]
    BarWipeLr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_TB")]
    BarWipeTb,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TL")]
    BoxWipeTl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TR")]
    BoxWipeTr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BR")]
    BoxWipeBr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BL")]
    BoxWipeBl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CI")]
    FourBoxWipeCi,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CO")]
    FourBoxWipeCo,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_V")]
    BarndoorV,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_H")]
    BarndoorH,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TC")]
    BoxWipeTc,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_RC")]
    BoxWipeRc,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BC")]
    BoxWipeBc,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_LC")]
    BoxWipeLc,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TL")]
    DiagonalTl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TR")]
    DiagonalTr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_V")]
    BowtieV,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_H")]
    BowtieH,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DBL")]
    BarndoorDbl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DTL")]
    BarndoorDtl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DBD")]
    MiscDiagonalDbd,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DD")]
    MiscDiagonalDd,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_D")]
    VeeD,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_L")]
    VeeL,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_U")]
    VeeU,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_R")]
    VeeR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_D")]
    BarnveeD,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_L")]
    BarnveeL,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_U")]
    BarnveeU,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_R")]
    BarnveeR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_IRIS_RECT")]
    IrisRect,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW12")]
    ClockCw12,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW3")]
    ClockCw3,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW6")]
    ClockCw6,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW9")]
    ClockCw9,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBV")]
    PinwheelTbv,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBH")]
    PinwheelTbh,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_FB")]
    PinwheelFb,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CT")]
    FanCt,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CR")]
    FanCr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOV")]
    DoublefanFov,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOH")]
    DoublefanFoh,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWT")]
    SinglesweepCwt,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWR")]
    SinglesweepCwr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWB")]
    SinglesweepCwb,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWL")]
    SinglesweepCwl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PV")]
    DoublesweepPv,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PD")]
    DoublesweepPd,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OV")]
    DoublesweepOv,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OH")]
    DoublesweepOh,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_T")]
    FanT,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_R")]
    FanR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_B")]
    FanB,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_L")]
    FanL,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIV")]
    DoublefanFiv,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIH")]
    DoublefanFih,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTL")]
    SinglesweepCwtl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBL")]
    SinglesweepCwbl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBR")]
    SinglesweepCwbr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTR")]
    SinglesweepCwtr,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDTL")]
    DoublesweepPdtl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDBL")]
    DoublesweepPdbl,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_T")]
    SaloondoorT,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_L")]
    SaloondoorL,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_B")]
    SaloondoorB,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_R")]
    SaloondoorR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_R")]
    WindshieldR,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_U")]
    WindshieldU,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_V")]
    WindshieldV,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_H")]
    WindshieldH,
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_CROSSFADE")]
    Crossfade,
    #[cfg(feature = "v1_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_22")))]
    #[doc(alias = "GES_VIDEO_STANDARD_TRANSITION_TYPE_FADE_IN")]
    FadeIn,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoStandardTransitionType {
    type GlibType = ffi::GESVideoStandardTransitionType;

    fn into_glib(self) -> ffi::GESVideoStandardTransitionType {
        match self {
            Self::None => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_NONE,
            Self::BarWipeLr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_LR,
            Self::BarWipeTb => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_TB,
            Self::BoxWipeTl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TL,
            Self::BoxWipeTr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TR,
            Self::BoxWipeBr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BR,
            Self::BoxWipeBl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BL,
            Self::FourBoxWipeCi => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CI,
            Self::FourBoxWipeCo => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CO,
            Self::BarndoorV => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_V,
            Self::BarndoorH => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_H,
            Self::BoxWipeTc => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TC,
            Self::BoxWipeRc => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_RC,
            Self::BoxWipeBc => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BC,
            Self::BoxWipeLc => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_LC,
            Self::DiagonalTl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TL,
            Self::DiagonalTr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TR,
            Self::BowtieV => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_V,
            Self::BowtieH => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_H,
            Self::BarndoorDbl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DBL,
            Self::BarndoorDtl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DTL,
            Self::MiscDiagonalDbd => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DBD,
            Self::MiscDiagonalDd => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DD,
            Self::VeeD => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_D,
            Self::VeeL => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_L,
            Self::VeeU => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_U,
            Self::VeeR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_R,
            Self::BarnveeD => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_D,
            Self::BarnveeL => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_L,
            Self::BarnveeU => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_U,
            Self::BarnveeR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_R,
            Self::IrisRect => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_IRIS_RECT,
            Self::ClockCw12 => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW12,
            Self::ClockCw3 => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW3,
            Self::ClockCw6 => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW6,
            Self::ClockCw9 => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW9,
            Self::PinwheelTbv => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBV,
            Self::PinwheelTbh => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBH,
            Self::PinwheelFb => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_FB,
            Self::FanCt => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CT,
            Self::FanCr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CR,
            Self::DoublefanFov => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOV,
            Self::DoublefanFoh => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOH,
            Self::SinglesweepCwt => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWT,
            Self::SinglesweepCwr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWR,
            Self::SinglesweepCwb => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWB,
            Self::SinglesweepCwl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWL,
            Self::DoublesweepPv => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PV,
            Self::DoublesweepPd => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PD,
            Self::DoublesweepOv => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OV,
            Self::DoublesweepOh => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OH,
            Self::FanT => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_T,
            Self::FanR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_R,
            Self::FanB => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_B,
            Self::FanL => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_L,
            Self::DoublefanFiv => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIV,
            Self::DoublefanFih => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIH,
            Self::SinglesweepCwtl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTL,
            Self::SinglesweepCwbl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBL,
            Self::SinglesweepCwbr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBR,
            Self::SinglesweepCwtr => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTR,
            Self::DoublesweepPdtl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDTL,
            Self::DoublesweepPdbl => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDBL,
            Self::SaloondoorT => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_T,
            Self::SaloondoorL => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_L,
            Self::SaloondoorB => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_B,
            Self::SaloondoorR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_R,
            Self::WindshieldR => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_R,
            Self::WindshieldU => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_U,
            Self::WindshieldV => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_V,
            Self::WindshieldH => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_H,
            Self::Crossfade => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CROSSFADE,
            #[cfg(feature = "v1_22")]
            Self::FadeIn => ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FADE_IN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESVideoStandardTransitionType> for VideoStandardTransitionType {
    unsafe fn from_glib(value: ffi::GESVideoStandardTransitionType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_NONE => Self::None,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_LR => Self::BarWipeLr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BAR_WIPE_TB => Self::BarWipeTb,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TL => Self::BoxWipeTl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TR => Self::BoxWipeTr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BR => Self::BoxWipeBr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BL => Self::BoxWipeBl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CI => Self::FourBoxWipeCi,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FOUR_BOX_WIPE_CO => Self::FourBoxWipeCo,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_V => Self::BarndoorV,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_H => Self::BarndoorH,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_TC => Self::BoxWipeTc,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_RC => Self::BoxWipeRc,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_BC => Self::BoxWipeBc,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOX_WIPE_LC => Self::BoxWipeLc,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TL => Self::DiagonalTl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DIAGONAL_TR => Self::DiagonalTr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_V => Self::BowtieV,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BOWTIE_H => Self::BowtieH,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DBL => Self::BarndoorDbl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNDOOR_DTL => Self::BarndoorDtl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DBD => Self::MiscDiagonalDbd,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_MISC_DIAGONAL_DD => Self::MiscDiagonalDd,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_D => Self::VeeD,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_L => Self::VeeL,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_U => Self::VeeU,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_VEE_R => Self::VeeR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_D => Self::BarnveeD,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_L => Self::BarnveeL,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_U => Self::BarnveeU,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_BARNVEE_R => Self::BarnveeR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_IRIS_RECT => Self::IrisRect,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW12 => Self::ClockCw12,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW3 => Self::ClockCw3,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW6 => Self::ClockCw6,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CLOCK_CW9 => Self::ClockCw9,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBV => Self::PinwheelTbv,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_TBH => Self::PinwheelTbh,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_PINWHEEL_FB => Self::PinwheelFb,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CT => Self::FanCt,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_CR => Self::FanCr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOV => Self::DoublefanFov,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FOH => Self::DoublefanFoh,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWT => Self::SinglesweepCwt,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWR => Self::SinglesweepCwr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWB => Self::SinglesweepCwb,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWL => Self::SinglesweepCwl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PV => Self::DoublesweepPv,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PD => Self::DoublesweepPd,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OV => Self::DoublesweepOv,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_OH => Self::DoublesweepOh,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_T => Self::FanT,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_R => Self::FanR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_B => Self::FanB,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FAN_L => Self::FanL,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIV => Self::DoublefanFiv,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLEFAN_FIH => Self::DoublefanFih,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTL => Self::SinglesweepCwtl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBL => Self::SinglesweepCwbl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWBR => Self::SinglesweepCwbr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SINGLESWEEP_CWTR => Self::SinglesweepCwtr,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDTL => Self::DoublesweepPdtl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_DOUBLESWEEP_PDBL => Self::DoublesweepPdbl,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_T => Self::SaloondoorT,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_L => Self::SaloondoorL,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_B => Self::SaloondoorB,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_SALOONDOOR_R => Self::SaloondoorR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_R => Self::WindshieldR,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_U => Self::WindshieldU,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_V => Self::WindshieldV,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_WINDSHIELD_H => Self::WindshieldH,
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_CROSSFADE => Self::Crossfade,
            #[cfg(feature = "v1_22")]
            ffi::GES_VIDEO_STANDARD_TRANSITION_TYPE_FADE_IN => Self::FadeIn,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoStandardTransitionType {
    #[inline]
    #[doc(alias = "ges_video_standard_transition_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::ges_video_standard_transition_type_get_type()) }
    }
}

impl glib::HasParamSpec for VideoStandardTransitionType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for VideoStandardTransitionType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for VideoStandardTransitionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        unsafe { from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0)) }
    }
}

impl ToValue for VideoStandardTransitionType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<VideoStandardTransitionType> for glib::Value {
    #[inline]
    fn from(v: VideoStandardTransitionType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GESVideoTestPattern")]
pub enum VideoTestPattern {
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_SMPTE")]
    Smpte,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_SNOW")]
    Snow,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_BLACK")]
    Black,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_WHITE")]
    White,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_RED")]
    Red,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_GREEN")]
    Green,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_BLUE")]
    Blue,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_CHECKERS1")]
    Checkers1,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_CHECKERS2")]
    Checkers2,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_CHECKERS4")]
    Checkers4,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_CHECKERS8")]
    Checkers8,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_CIRCULAR")]
    Circular,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_BLINK")]
    Blink,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_SMPTE75")]
    Smpte75,
    #[doc(alias = "GES_VIDEO_TEST_ZONE_PLATE")]
    ZonePlate,
    #[doc(alias = "GES_VIDEO_TEST_GAMUT")]
    Gamut,
    #[doc(alias = "GES_VIDEO_TEST_CHROMA_ZONE_PLATE")]
    ChromaZonePlate,
    #[doc(alias = "GES_VIDEO_TEST_PATTERN_SOLID")]
    SolidColor,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for VideoTestPattern {
    type GlibType = ffi::GESVideoTestPattern;

    fn into_glib(self) -> ffi::GESVideoTestPattern {
        match self {
            Self::Smpte => ffi::GES_VIDEO_TEST_PATTERN_SMPTE,
            Self::Snow => ffi::GES_VIDEO_TEST_PATTERN_SNOW,
            Self::Black => ffi::GES_VIDEO_TEST_PATTERN_BLACK,
            Self::White => ffi::GES_VIDEO_TEST_PATTERN_WHITE,
            Self::Red => ffi::GES_VIDEO_TEST_PATTERN_RED,
            Self::Green => ffi::GES_VIDEO_TEST_PATTERN_GREEN,
            Self::Blue => ffi::GES_VIDEO_TEST_PATTERN_BLUE,
            Self::Checkers1 => ffi::GES_VIDEO_TEST_PATTERN_CHECKERS1,
            Self::Checkers2 => ffi::GES_VIDEO_TEST_PATTERN_CHECKERS2,
            Self::Checkers4 => ffi::GES_VIDEO_TEST_PATTERN_CHECKERS4,
            Self::Checkers8 => ffi::GES_VIDEO_TEST_PATTERN_CHECKERS8,
            Self::Circular => ffi::GES_VIDEO_TEST_PATTERN_CIRCULAR,
            Self::Blink => ffi::GES_VIDEO_TEST_PATTERN_BLINK,
            Self::Smpte75 => ffi::GES_VIDEO_TEST_PATTERN_SMPTE75,
            Self::ZonePlate => ffi::GES_VIDEO_TEST_ZONE_PLATE,
            Self::Gamut => ffi::GES_VIDEO_TEST_GAMUT,
            Self::ChromaZonePlate => ffi::GES_VIDEO_TEST_CHROMA_ZONE_PLATE,
            Self::SolidColor => ffi::GES_VIDEO_TEST_PATTERN_SOLID,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GESVideoTestPattern> for VideoTestPattern {
    unsafe fn from_glib(value: ffi::GESVideoTestPattern) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GES_VIDEO_TEST_PATTERN_SMPTE => Self::Smpte,
            ffi::GES_VIDEO_TEST_PATTERN_SNOW => Self::Snow,
            ffi::GES_VIDEO_TEST_PATTERN_BLACK => Self::Black,
            ffi::GES_VIDEO_TEST_PATTERN_WHITE => Self::White,
            ffi::GES_VIDEO_TEST_PATTERN_RED => Self::Red,
            ffi::GES_VIDEO_TEST_PATTERN_GREEN => Self::Green,
            ffi::GES_VIDEO_TEST_PATTERN_BLUE => Self::Blue,
            ffi::GES_VIDEO_TEST_PATTERN_CHECKERS1 => Self::Checkers1,
            ffi::GES_VIDEO_TEST_PATTERN_CHECKERS2 => Self::Checkers2,
            ffi::GES_VIDEO_TEST_PATTERN_CHECKERS4 => Self::Checkers4,
            ffi::GES_VIDEO_TEST_PATTERN_CHECKERS8 => Self::Checkers8,
            ffi::GES_VIDEO_TEST_PATTERN_CIRCULAR => Self::Circular,
            ffi::GES_VIDEO_TEST_PATTERN_BLINK => Self::Blink,
            ffi::GES_VIDEO_TEST_PATTERN_SMPTE75 => Self::Smpte75,
            ffi::GES_VIDEO_TEST_ZONE_PLATE => Self::ZonePlate,
            ffi::GES_VIDEO_TEST_GAMUT => Self::Gamut,
            ffi::GES_VIDEO_TEST_CHROMA_ZONE_PLATE => Self::ChromaZonePlate,
            ffi::GES_VIDEO_TEST_PATTERN_SOLID => Self::SolidColor,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for VideoTestPattern {
    #[inline]
    #[doc(alias = "ges_video_test_pattern_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::ges_video_test_pattern_get_type()) }
    }
}

impl glib::HasParamSpec for VideoTestPattern {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for VideoTestPattern {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for VideoTestPattern {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        unsafe { from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0)) }
    }
}

impl ToValue for VideoTestPattern {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<VideoTestPattern> for glib::Value {
    #[inline]
    fn from(v: VideoTestPattern) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}
