// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use gio_sys as gio;
use glib_sys as glib;
use gobject_sys as gobject;
use gstreamer_sdp_sys as gst_sdp;
use gstreamer_sys as gst;

#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};
#[allow(unused_imports)]
use libc::{intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE};
#[allow(unused_imports)]
use std::ffi::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type GstRTSPAuthMethod = c_int;
pub const GST_RTSP_AUTH_NONE: GstRTSPAuthMethod = 0;
pub const GST_RTSP_AUTH_BASIC: GstRTSPAuthMethod = 1;
pub const GST_RTSP_AUTH_DIGEST: GstRTSPAuthMethod = 2;

pub type GstRTSPFamily = c_int;
pub const GST_RTSP_FAM_NONE: GstRTSPFamily = 0;
pub const GST_RTSP_FAM_INET: GstRTSPFamily = 1;
pub const GST_RTSP_FAM_INET6: GstRTSPFamily = 2;

pub type GstRTSPHeaderField = c_int;
pub const GST_RTSP_HDR_INVALID: GstRTSPHeaderField = 0;
pub const GST_RTSP_HDR_ACCEPT: GstRTSPHeaderField = 1;
pub const GST_RTSP_HDR_ACCEPT_ENCODING: GstRTSPHeaderField = 2;
pub const GST_RTSP_HDR_ACCEPT_LANGUAGE: GstRTSPHeaderField = 3;
pub const GST_RTSP_HDR_ALLOW: GstRTSPHeaderField = 4;
pub const GST_RTSP_HDR_AUTHORIZATION: GstRTSPHeaderField = 5;
pub const GST_RTSP_HDR_BANDWIDTH: GstRTSPHeaderField = 6;
pub const GST_RTSP_HDR_BLOCKSIZE: GstRTSPHeaderField = 7;
pub const GST_RTSP_HDR_CACHE_CONTROL: GstRTSPHeaderField = 8;
pub const GST_RTSP_HDR_CONFERENCE: GstRTSPHeaderField = 9;
pub const GST_RTSP_HDR_CONNECTION: GstRTSPHeaderField = 10;
pub const GST_RTSP_HDR_CONTENT_BASE: GstRTSPHeaderField = 11;
pub const GST_RTSP_HDR_CONTENT_ENCODING: GstRTSPHeaderField = 12;
pub const GST_RTSP_HDR_CONTENT_LANGUAGE: GstRTSPHeaderField = 13;
pub const GST_RTSP_HDR_CONTENT_LENGTH: GstRTSPHeaderField = 14;
pub const GST_RTSP_HDR_CONTENT_LOCATION: GstRTSPHeaderField = 15;
pub const GST_RTSP_HDR_CONTENT_TYPE: GstRTSPHeaderField = 16;
pub const GST_RTSP_HDR_CSEQ: GstRTSPHeaderField = 17;
pub const GST_RTSP_HDR_DATE: GstRTSPHeaderField = 18;
pub const GST_RTSP_HDR_EXPIRES: GstRTSPHeaderField = 19;
pub const GST_RTSP_HDR_FROM: GstRTSPHeaderField = 20;
pub const GST_RTSP_HDR_IF_MODIFIED_SINCE: GstRTSPHeaderField = 21;
pub const GST_RTSP_HDR_LAST_MODIFIED: GstRTSPHeaderField = 22;
pub const GST_RTSP_HDR_PROXY_AUTHENTICATE: GstRTSPHeaderField = 23;
pub const GST_RTSP_HDR_PROXY_REQUIRE: GstRTSPHeaderField = 24;
pub const GST_RTSP_HDR_PUBLIC: GstRTSPHeaderField = 25;
pub const GST_RTSP_HDR_RANGE: GstRTSPHeaderField = 26;
pub const GST_RTSP_HDR_REFERER: GstRTSPHeaderField = 27;
pub const GST_RTSP_HDR_REQUIRE: GstRTSPHeaderField = 28;
pub const GST_RTSP_HDR_RETRY_AFTER: GstRTSPHeaderField = 29;
pub const GST_RTSP_HDR_RTP_INFO: GstRTSPHeaderField = 30;
pub const GST_RTSP_HDR_SCALE: GstRTSPHeaderField = 31;
pub const GST_RTSP_HDR_SESSION: GstRTSPHeaderField = 32;
pub const GST_RTSP_HDR_SERVER: GstRTSPHeaderField = 33;
pub const GST_RTSP_HDR_SPEED: GstRTSPHeaderField = 34;
pub const GST_RTSP_HDR_TRANSPORT: GstRTSPHeaderField = 35;
pub const GST_RTSP_HDR_UNSUPPORTED: GstRTSPHeaderField = 36;
pub const GST_RTSP_HDR_USER_AGENT: GstRTSPHeaderField = 37;
pub const GST_RTSP_HDR_VIA: GstRTSPHeaderField = 38;
pub const GST_RTSP_HDR_WWW_AUTHENTICATE: GstRTSPHeaderField = 39;
pub const GST_RTSP_HDR_CLIENT_CHALLENGE: GstRTSPHeaderField = 40;
pub const GST_RTSP_HDR_REAL_CHALLENGE1: GstRTSPHeaderField = 41;
pub const GST_RTSP_HDR_REAL_CHALLENGE2: GstRTSPHeaderField = 42;
pub const GST_RTSP_HDR_REAL_CHALLENGE3: GstRTSPHeaderField = 43;
pub const GST_RTSP_HDR_SUBSCRIBE: GstRTSPHeaderField = 44;
pub const GST_RTSP_HDR_ALERT: GstRTSPHeaderField = 45;
pub const GST_RTSP_HDR_CLIENT_ID: GstRTSPHeaderField = 46;
pub const GST_RTSP_HDR_COMPANY_ID: GstRTSPHeaderField = 47;
pub const GST_RTSP_HDR_GUID: GstRTSPHeaderField = 48;
pub const GST_RTSP_HDR_REGION_DATA: GstRTSPHeaderField = 49;
pub const GST_RTSP_HDR_MAX_ASM_WIDTH: GstRTSPHeaderField = 50;
pub const GST_RTSP_HDR_LANGUAGE: GstRTSPHeaderField = 51;
pub const GST_RTSP_HDR_PLAYER_START_TIME: GstRTSPHeaderField = 52;
pub const GST_RTSP_HDR_LOCATION: GstRTSPHeaderField = 53;
pub const GST_RTSP_HDR_ETAG: GstRTSPHeaderField = 54;
pub const GST_RTSP_HDR_IF_MATCH: GstRTSPHeaderField = 55;
pub const GST_RTSP_HDR_ACCEPT_CHARSET: GstRTSPHeaderField = 56;
pub const GST_RTSP_HDR_SUPPORTED: GstRTSPHeaderField = 57;
pub const GST_RTSP_HDR_VARY: GstRTSPHeaderField = 58;
pub const GST_RTSP_HDR_X_ACCELERATE_STREAMING: GstRTSPHeaderField = 59;
pub const GST_RTSP_HDR_X_ACCEPT_AUTHENT: GstRTSPHeaderField = 60;
pub const GST_RTSP_HDR_X_ACCEPT_PROXY_AUTHENT: GstRTSPHeaderField = 61;
pub const GST_RTSP_HDR_X_BROADCAST_ID: GstRTSPHeaderField = 62;
pub const GST_RTSP_HDR_X_BURST_STREAMING: GstRTSPHeaderField = 63;
pub const GST_RTSP_HDR_X_NOTICE: GstRTSPHeaderField = 64;
pub const GST_RTSP_HDR_X_PLAYER_LAG_TIME: GstRTSPHeaderField = 65;
pub const GST_RTSP_HDR_X_PLAYLIST: GstRTSPHeaderField = 66;
pub const GST_RTSP_HDR_X_PLAYLIST_CHANGE_NOTICE: GstRTSPHeaderField = 67;
pub const GST_RTSP_HDR_X_PLAYLIST_GEN_ID: GstRTSPHeaderField = 68;
pub const GST_RTSP_HDR_X_PLAYLIST_SEEK_ID: GstRTSPHeaderField = 69;
pub const GST_RTSP_HDR_X_PROXY_CLIENT_AGENT: GstRTSPHeaderField = 70;
pub const GST_RTSP_HDR_X_PROXY_CLIENT_VERB: GstRTSPHeaderField = 71;
pub const GST_RTSP_HDR_X_RECEDING_PLAYLISTCHANGE: GstRTSPHeaderField = 72;
pub const GST_RTSP_HDR_X_RTP_INFO: GstRTSPHeaderField = 73;
pub const GST_RTSP_HDR_X_STARTUPPROFILE: GstRTSPHeaderField = 74;
pub const GST_RTSP_HDR_TIMESTAMP: GstRTSPHeaderField = 75;
pub const GST_RTSP_HDR_AUTHENTICATION_INFO: GstRTSPHeaderField = 76;
pub const GST_RTSP_HDR_HOST: GstRTSPHeaderField = 77;
pub const GST_RTSP_HDR_PRAGMA: GstRTSPHeaderField = 78;
pub const GST_RTSP_HDR_X_SERVER_IP_ADDRESS: GstRTSPHeaderField = 79;
pub const GST_RTSP_HDR_X_SESSIONCOOKIE: GstRTSPHeaderField = 80;
pub const GST_RTSP_HDR_RTCP_INTERVAL: GstRTSPHeaderField = 81;
pub const GST_RTSP_HDR_KEYMGMT: GstRTSPHeaderField = 82;
pub const GST_RTSP_HDR_PIPELINED_REQUESTS: GstRTSPHeaderField = 83;
pub const GST_RTSP_HDR_MEDIA_PROPERTIES: GstRTSPHeaderField = 84;
pub const GST_RTSP_HDR_SEEK_STYLE: GstRTSPHeaderField = 85;
pub const GST_RTSP_HDR_ACCEPT_RANGES: GstRTSPHeaderField = 86;
pub const GST_RTSP_HDR_FRAMES: GstRTSPHeaderField = 87;
pub const GST_RTSP_HDR_RATE_CONTROL: GstRTSPHeaderField = 88;
pub const GST_RTSP_HDR_LAST: GstRTSPHeaderField = 89;

pub type GstRTSPMsgType = c_int;
pub const GST_RTSP_MESSAGE_INVALID: GstRTSPMsgType = 0;
pub const GST_RTSP_MESSAGE_REQUEST: GstRTSPMsgType = 1;
pub const GST_RTSP_MESSAGE_RESPONSE: GstRTSPMsgType = 2;
pub const GST_RTSP_MESSAGE_HTTP_REQUEST: GstRTSPMsgType = 3;
pub const GST_RTSP_MESSAGE_HTTP_RESPONSE: GstRTSPMsgType = 4;
pub const GST_RTSP_MESSAGE_DATA: GstRTSPMsgType = 5;

pub type GstRTSPRangeUnit = c_int;
pub const GST_RTSP_RANGE_SMPTE: GstRTSPRangeUnit = 0;
pub const GST_RTSP_RANGE_SMPTE_30_DROP: GstRTSPRangeUnit = 1;
pub const GST_RTSP_RANGE_SMPTE_25: GstRTSPRangeUnit = 2;
pub const GST_RTSP_RANGE_NPT: GstRTSPRangeUnit = 3;
pub const GST_RTSP_RANGE_CLOCK: GstRTSPRangeUnit = 4;

pub type GstRTSPResult = c_int;
pub const GST_RTSP_OK: GstRTSPResult = 0;
#[cfg(feature = "v1_24")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
pub const GST_RTSP_OK_REDIRECT: GstRTSPResult = 1;
pub const GST_RTSP_ERROR: GstRTSPResult = -1;
pub const GST_RTSP_EINVAL: GstRTSPResult = -2;
pub const GST_RTSP_EINTR: GstRTSPResult = -3;
pub const GST_RTSP_ENOMEM: GstRTSPResult = -4;
pub const GST_RTSP_ERESOLV: GstRTSPResult = -5;
pub const GST_RTSP_ENOTIMPL: GstRTSPResult = -6;
pub const GST_RTSP_ESYS: GstRTSPResult = -7;
pub const GST_RTSP_EPARSE: GstRTSPResult = -8;
pub const GST_RTSP_EWSASTART: GstRTSPResult = -9;
pub const GST_RTSP_EWSAVERSION: GstRTSPResult = -10;
pub const GST_RTSP_EEOF: GstRTSPResult = -11;
pub const GST_RTSP_ENET: GstRTSPResult = -12;
pub const GST_RTSP_ENOTIP: GstRTSPResult = -13;
pub const GST_RTSP_ETIMEOUT: GstRTSPResult = -14;
pub const GST_RTSP_ETGET: GstRTSPResult = -15;
pub const GST_RTSP_ETPOST: GstRTSPResult = -16;
pub const GST_RTSP_ELAST: GstRTSPResult = -17;

pub type GstRTSPState = c_int;
pub const GST_RTSP_STATE_INVALID: GstRTSPState = 0;
pub const GST_RTSP_STATE_INIT: GstRTSPState = 1;
pub const GST_RTSP_STATE_READY: GstRTSPState = 2;
pub const GST_RTSP_STATE_SEEKING: GstRTSPState = 3;
pub const GST_RTSP_STATE_PLAYING: GstRTSPState = 4;
pub const GST_RTSP_STATE_RECORDING: GstRTSPState = 5;

pub type GstRTSPStatusCode = c_int;
pub const GST_RTSP_STS_INVALID: GstRTSPStatusCode = 0;
pub const GST_RTSP_STS_CONTINUE: GstRTSPStatusCode = 100;
pub const GST_RTSP_STS_OK: GstRTSPStatusCode = 200;
pub const GST_RTSP_STS_CREATED: GstRTSPStatusCode = 201;
pub const GST_RTSP_STS_LOW_ON_STORAGE: GstRTSPStatusCode = 250;
pub const GST_RTSP_STS_MULTIPLE_CHOICES: GstRTSPStatusCode = 300;
pub const GST_RTSP_STS_MOVED_PERMANENTLY: GstRTSPStatusCode = 301;
pub const GST_RTSP_STS_MOVE_TEMPORARILY: GstRTSPStatusCode = 302;
pub const GST_RTSP_STS_SEE_OTHER: GstRTSPStatusCode = 303;
pub const GST_RTSP_STS_NOT_MODIFIED: GstRTSPStatusCode = 304;
pub const GST_RTSP_STS_USE_PROXY: GstRTSPStatusCode = 305;
#[cfg(feature = "v1_24")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
pub const GST_RTSP_STS_REDIRECT_TEMPORARILY: GstRTSPStatusCode = 307;
#[cfg(feature = "v1_24")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
pub const GST_RTSP_STS_REDIRECT_PERMANENTLY: GstRTSPStatusCode = 308;
pub const GST_RTSP_STS_BAD_REQUEST: GstRTSPStatusCode = 400;
pub const GST_RTSP_STS_UNAUTHORIZED: GstRTSPStatusCode = 401;
pub const GST_RTSP_STS_PAYMENT_REQUIRED: GstRTSPStatusCode = 402;
pub const GST_RTSP_STS_FORBIDDEN: GstRTSPStatusCode = 403;
pub const GST_RTSP_STS_NOT_FOUND: GstRTSPStatusCode = 404;
pub const GST_RTSP_STS_METHOD_NOT_ALLOWED: GstRTSPStatusCode = 405;
pub const GST_RTSP_STS_NOT_ACCEPTABLE: GstRTSPStatusCode = 406;
pub const GST_RTSP_STS_PROXY_AUTH_REQUIRED: GstRTSPStatusCode = 407;
pub const GST_RTSP_STS_REQUEST_TIMEOUT: GstRTSPStatusCode = 408;
pub const GST_RTSP_STS_GONE: GstRTSPStatusCode = 410;
pub const GST_RTSP_STS_LENGTH_REQUIRED: GstRTSPStatusCode = 411;
pub const GST_RTSP_STS_PRECONDITION_FAILED: GstRTSPStatusCode = 412;
pub const GST_RTSP_STS_REQUEST_ENTITY_TOO_LARGE: GstRTSPStatusCode = 413;
pub const GST_RTSP_STS_REQUEST_URI_TOO_LARGE: GstRTSPStatusCode = 414;
pub const GST_RTSP_STS_UNSUPPORTED_MEDIA_TYPE: GstRTSPStatusCode = 415;
pub const GST_RTSP_STS_PARAMETER_NOT_UNDERSTOOD: GstRTSPStatusCode = 451;
pub const GST_RTSP_STS_CONFERENCE_NOT_FOUND: GstRTSPStatusCode = 452;
pub const GST_RTSP_STS_NOT_ENOUGH_BANDWIDTH: GstRTSPStatusCode = 453;
pub const GST_RTSP_STS_SESSION_NOT_FOUND: GstRTSPStatusCode = 454;
pub const GST_RTSP_STS_METHOD_NOT_VALID_IN_THIS_STATE: GstRTSPStatusCode = 455;
pub const GST_RTSP_STS_HEADER_FIELD_NOT_VALID_FOR_RESOURCE: GstRTSPStatusCode = 456;
pub const GST_RTSP_STS_INVALID_RANGE: GstRTSPStatusCode = 457;
pub const GST_RTSP_STS_PARAMETER_IS_READONLY: GstRTSPStatusCode = 458;
pub const GST_RTSP_STS_AGGREGATE_OPERATION_NOT_ALLOWED: GstRTSPStatusCode = 459;
pub const GST_RTSP_STS_ONLY_AGGREGATE_OPERATION_ALLOWED: GstRTSPStatusCode = 460;
pub const GST_RTSP_STS_UNSUPPORTED_TRANSPORT: GstRTSPStatusCode = 461;
pub const GST_RTSP_STS_DESTINATION_UNREACHABLE: GstRTSPStatusCode = 462;
pub const GST_RTSP_STS_KEY_MANAGEMENT_FAILURE: GstRTSPStatusCode = 463;
pub const GST_RTSP_STS_INTERNAL_SERVER_ERROR: GstRTSPStatusCode = 500;
pub const GST_RTSP_STS_NOT_IMPLEMENTED: GstRTSPStatusCode = 501;
pub const GST_RTSP_STS_BAD_GATEWAY: GstRTSPStatusCode = 502;
pub const GST_RTSP_STS_SERVICE_UNAVAILABLE: GstRTSPStatusCode = 503;
pub const GST_RTSP_STS_GATEWAY_TIMEOUT: GstRTSPStatusCode = 504;
pub const GST_RTSP_STS_RTSP_VERSION_NOT_SUPPORTED: GstRTSPStatusCode = 505;
pub const GST_RTSP_STS_OPTION_NOT_SUPPORTED: GstRTSPStatusCode = 551;

pub type GstRTSPTimeType = c_int;
pub const GST_RTSP_TIME_SECONDS: GstRTSPTimeType = 0;
pub const GST_RTSP_TIME_NOW: GstRTSPTimeType = 1;
pub const GST_RTSP_TIME_END: GstRTSPTimeType = 2;
pub const GST_RTSP_TIME_FRAMES: GstRTSPTimeType = 3;
pub const GST_RTSP_TIME_UTC: GstRTSPTimeType = 4;

pub type GstRTSPVersion = c_int;
pub const GST_RTSP_VERSION_INVALID: GstRTSPVersion = 0;
pub const GST_RTSP_VERSION_1_0: GstRTSPVersion = 16;
pub const GST_RTSP_VERSION_1_1: GstRTSPVersion = 17;
pub const GST_RTSP_VERSION_2_0: GstRTSPVersion = 32;

// Constants
pub const GST_RTSP_DEFAULT_PORT: c_int = 554;

// Flags
pub type GstRTSPEvent = c_uint;
pub const GST_RTSP_EV_READ: GstRTSPEvent = 1;
pub const GST_RTSP_EV_WRITE: GstRTSPEvent = 2;

pub type GstRTSPLowerTrans = c_uint;
pub const GST_RTSP_LOWER_TRANS_UNKNOWN: GstRTSPLowerTrans = 0;
pub const GST_RTSP_LOWER_TRANS_UDP: GstRTSPLowerTrans = 1;
pub const GST_RTSP_LOWER_TRANS_UDP_MCAST: GstRTSPLowerTrans = 2;
pub const GST_RTSP_LOWER_TRANS_TCP: GstRTSPLowerTrans = 4;
pub const GST_RTSP_LOWER_TRANS_HTTP: GstRTSPLowerTrans = 16;
pub const GST_RTSP_LOWER_TRANS_TLS: GstRTSPLowerTrans = 32;

pub type GstRTSPMethod = c_uint;
pub const GST_RTSP_INVALID: GstRTSPMethod = 0;
pub const GST_RTSP_DESCRIBE: GstRTSPMethod = 1;
pub const GST_RTSP_ANNOUNCE: GstRTSPMethod = 2;
pub const GST_RTSP_GET_PARAMETER: GstRTSPMethod = 4;
pub const GST_RTSP_OPTIONS: GstRTSPMethod = 8;
pub const GST_RTSP_PAUSE: GstRTSPMethod = 16;
pub const GST_RTSP_PLAY: GstRTSPMethod = 32;
pub const GST_RTSP_RECORD: GstRTSPMethod = 64;
pub const GST_RTSP_REDIRECT: GstRTSPMethod = 128;
pub const GST_RTSP_SETUP: GstRTSPMethod = 256;
pub const GST_RTSP_SET_PARAMETER: GstRTSPMethod = 512;
pub const GST_RTSP_TEARDOWN: GstRTSPMethod = 1024;
pub const GST_RTSP_GET: GstRTSPMethod = 2048;
pub const GST_RTSP_POST: GstRTSPMethod = 4096;

pub type GstRTSPProfile = c_uint;
pub const GST_RTSP_PROFILE_UNKNOWN: GstRTSPProfile = 0;
pub const GST_RTSP_PROFILE_AVP: GstRTSPProfile = 1;
pub const GST_RTSP_PROFILE_SAVP: GstRTSPProfile = 2;
pub const GST_RTSP_PROFILE_AVPF: GstRTSPProfile = 4;
pub const GST_RTSP_PROFILE_SAVPF: GstRTSPProfile = 8;

pub type GstRTSPTransMode = c_uint;
pub const GST_RTSP_TRANS_UNKNOWN: GstRTSPTransMode = 0;
pub const GST_RTSP_TRANS_RTP: GstRTSPTransMode = 1;
pub const GST_RTSP_TRANS_RDT: GstRTSPTransMode = 2;

// Unions
#[derive(Copy, Clone)]
#[repr(C)]
pub union GstRTSPMessage_type_data {
    pub request: GstRTSPMessage_type_data_request,
    pub response: GstRTSPMessage_type_data_response,
    pub data: GstRTSPMessage_type_data_data,
}

impl ::std::fmt::Debug for GstRTSPMessage_type_data {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPMessage_type_data @ {self:p}"))
            .field("request", unsafe { &self.request })
            .field("response", unsafe { &self.response })
            .field("data", unsafe { &self.data })
            .finish()
    }
}

// Callbacks
pub type GstRTSPConnectionAcceptCertificateFunc = Option<
    unsafe extern "C" fn(
        *mut gio::GTlsConnection,
        *mut gio::GTlsCertificate,
        gio::GTlsCertificateFlags,
        gpointer,
    ) -> gboolean,
>;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPAuthCredential {
    pub scheme: GstRTSPAuthMethod,
    pub params: *mut *mut GstRTSPAuthParam,
    pub authorization: *mut c_char,
}

impl ::std::fmt::Debug for GstRTSPAuthCredential {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPAuthCredential @ {self:p}"))
            .field("scheme", &self.scheme)
            .field("params", &self.params)
            .field("authorization", &self.authorization)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPAuthParam {
    pub name: *mut c_char,
    pub value: *mut c_char,
}

impl ::std::fmt::Debug for GstRTSPAuthParam {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPAuthParam @ {self:p}"))
            .field("name", &self.name)
            .field("value", &self.value)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstRTSPConnection {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstRTSPConnection = _GstRTSPConnection;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPExtensionInterface {
    pub parent: gobject::GTypeInterface,
    pub detect_server:
        Option<unsafe extern "C" fn(*mut GstRTSPExtension, *mut GstRTSPMessage) -> gboolean>,
    pub before_send:
        Option<unsafe extern "C" fn(*mut GstRTSPExtension, *mut GstRTSPMessage) -> GstRTSPResult>,
    pub after_send: Option<
        unsafe extern "C" fn(
            *mut GstRTSPExtension,
            *mut GstRTSPMessage,
            *mut GstRTSPMessage,
        ) -> GstRTSPResult,
    >,
    pub parse_sdp: Option<
        unsafe extern "C" fn(
            *mut GstRTSPExtension,
            *mut gst_sdp::GstSDPMessage,
            *mut gst::GstStructure,
        ) -> GstRTSPResult,
    >,
    pub setup_media: Option<
        unsafe extern "C" fn(*mut GstRTSPExtension, *mut gst_sdp::GstSDPMedia) -> GstRTSPResult,
    >,
    pub configure_stream:
        Option<unsafe extern "C" fn(*mut GstRTSPExtension, *mut gst::GstCaps) -> gboolean>,
    pub get_transports: Option<
        unsafe extern "C" fn(
            *mut GstRTSPExtension,
            GstRTSPLowerTrans,
            *mut *mut c_char,
        ) -> GstRTSPResult,
    >,
    pub stream_select:
        Option<unsafe extern "C" fn(*mut GstRTSPExtension, *mut GstRTSPUrl) -> GstRTSPResult>,
    pub send: Option<
        unsafe extern "C" fn(
            *mut GstRTSPExtension,
            *mut GstRTSPMessage,
            *mut GstRTSPMessage,
        ) -> GstRTSPResult,
    >,
    pub receive_request:
        Option<unsafe extern "C" fn(*mut GstRTSPExtension, *mut GstRTSPMessage) -> GstRTSPResult>,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTSPExtensionInterface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPExtensionInterface @ {self:p}"))
            .field("parent", &self.parent)
            .field("detect_server", &self.detect_server)
            .field("before_send", &self.before_send)
            .field("after_send", &self.after_send)
            .field("parse_sdp", &self.parse_sdp)
            .field("setup_media", &self.setup_media)
            .field("configure_stream", &self.configure_stream)
            .field("get_transports", &self.get_transports)
            .field("stream_select", &self.stream_select)
            .field("send", &self.send)
            .field("receive_request", &self.receive_request)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPMessage {
    pub type_: GstRTSPMsgType,
    pub type_data: GstRTSPMessage_type_data,
    pub hdr_fields: *mut glib::GArray,
    pub body: *mut u8,
    pub body_size: c_uint,
    pub body_buffer: *mut gst::GstBuffer,
    pub _gst_reserved: [gpointer; 3],
}

impl ::std::fmt::Debug for GstRTSPMessage {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPMessage @ {self:p}"))
            .field("type_", &self.type_)
            .field("type_data", &self.type_data)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPMessage_type_data_data {
    pub channel: u8,
}

impl ::std::fmt::Debug for GstRTSPMessage_type_data_data {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPMessage_type_data_data @ {self:p}"))
            .field("channel", &self.channel)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPMessage_type_data_request {
    pub method: GstRTSPMethod,
    pub uri: *mut c_char,
    pub version: GstRTSPVersion,
}

impl ::std::fmt::Debug for GstRTSPMessage_type_data_request {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPMessage_type_data_request @ {self:p}"))
            .field("method", &self.method)
            .field("uri", &self.uri)
            .field("version", &self.version)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPMessage_type_data_response {
    pub code: GstRTSPStatusCode,
    pub reason: *mut c_char,
    pub version: GstRTSPVersion,
}

impl ::std::fmt::Debug for GstRTSPMessage_type_data_response {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPMessage_type_data_response @ {self:p}"))
            .field("code", &self.code)
            .field("reason", &self.reason)
            .field("version", &self.version)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPRange {
    pub min: c_int,
    pub max: c_int,
}

impl ::std::fmt::Debug for GstRTSPRange {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPRange @ {self:p}"))
            .field("min", &self.min)
            .field("max", &self.max)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPTime {
    pub type_: GstRTSPTimeType,
    pub seconds: c_double,
}

impl ::std::fmt::Debug for GstRTSPTime {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPTime @ {self:p}"))
            .field("type_", &self.type_)
            .field("seconds", &self.seconds)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPTime2 {
    pub frames: c_double,
    pub year: c_uint,
    pub month: c_uint,
    pub day: c_uint,
}

impl ::std::fmt::Debug for GstRTSPTime2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPTime2 @ {self:p}"))
            .field("frames", &self.frames)
            .field("year", &self.year)
            .field("month", &self.month)
            .field("day", &self.day)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPTimeRange {
    pub unit: GstRTSPRangeUnit,
    pub min: GstRTSPTime,
    pub max: GstRTSPTime,
    pub min2: GstRTSPTime2,
    pub max2: GstRTSPTime2,
}

impl ::std::fmt::Debug for GstRTSPTimeRange {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPTimeRange @ {self:p}"))
            .field("unit", &self.unit)
            .field("min", &self.min)
            .field("max", &self.max)
            .field("min2", &self.min2)
            .field("max2", &self.max2)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPTransport {
    pub trans: GstRTSPTransMode,
    pub profile: GstRTSPProfile,
    pub lower_transport: GstRTSPLowerTrans,
    pub destination: *mut c_char,
    pub source: *mut c_char,
    pub layers: c_uint,
    pub mode_play: gboolean,
    pub mode_record: gboolean,
    pub append: gboolean,
    pub interleaved: GstRTSPRange,
    pub ttl: c_uint,
    pub port: GstRTSPRange,
    pub client_port: GstRTSPRange,
    pub server_port: GstRTSPRange,
    pub ssrc: c_uint,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTSPTransport {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPTransport @ {self:p}"))
            .field("trans", &self.trans)
            .field("profile", &self.profile)
            .field("lower_transport", &self.lower_transport)
            .field("destination", &self.destination)
            .field("source", &self.source)
            .field("layers", &self.layers)
            .field("mode_play", &self.mode_play)
            .field("mode_record", &self.mode_record)
            .field("append", &self.append)
            .field("interleaved", &self.interleaved)
            .field("ttl", &self.ttl)
            .field("port", &self.port)
            .field("client_port", &self.client_port)
            .field("server_port", &self.server_port)
            .field("ssrc", &self.ssrc)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPUrl {
    pub transports: GstRTSPLowerTrans,
    pub family: GstRTSPFamily,
    pub user: *mut c_char,
    pub passwd: *mut c_char,
    pub host: *mut c_char,
    pub port: u16,
    pub abspath: *mut c_char,
    pub query: *mut c_char,
}

impl ::std::fmt::Debug for GstRTSPUrl {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPUrl @ {self:p}"))
            .field("transports", &self.transports)
            .field("family", &self.family)
            .field("user", &self.user)
            .field("passwd", &self.passwd)
            .field("host", &self.host)
            .field("port", &self.port)
            .field("abspath", &self.abspath)
            .field("query", &self.query)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstRTSPWatch {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstRTSPWatch = _GstRTSPWatch;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTSPWatchFuncs {
    pub message_received: Option<
        unsafe extern "C" fn(*mut GstRTSPWatch, *mut GstRTSPMessage, gpointer) -> GstRTSPResult,
    >,
    pub message_sent:
        Option<unsafe extern "C" fn(*mut GstRTSPWatch, c_uint, gpointer) -> GstRTSPResult>,
    pub closed: Option<unsafe extern "C" fn(*mut GstRTSPWatch, gpointer) -> GstRTSPResult>,
    pub error:
        Option<unsafe extern "C" fn(*mut GstRTSPWatch, GstRTSPResult, gpointer) -> GstRTSPResult>,
    pub tunnel_start:
        Option<unsafe extern "C" fn(*mut GstRTSPWatch, gpointer) -> GstRTSPStatusCode>,
    pub tunnel_complete: Option<unsafe extern "C" fn(*mut GstRTSPWatch, gpointer) -> GstRTSPResult>,
    pub error_full: Option<
        unsafe extern "C" fn(
            *mut GstRTSPWatch,
            GstRTSPResult,
            *mut GstRTSPMessage,
            c_uint,
            gpointer,
        ) -> GstRTSPResult,
    >,
    pub tunnel_lost: Option<unsafe extern "C" fn(*mut GstRTSPWatch, gpointer) -> GstRTSPResult>,
    pub tunnel_http_response: Option<
        unsafe extern "C" fn(
            *mut GstRTSPWatch,
            *mut GstRTSPMessage,
            *mut GstRTSPMessage,
            gpointer,
        ) -> GstRTSPResult,
    >,
    pub _gst_reserved: [gpointer; 3],
}

impl ::std::fmt::Debug for GstRTSPWatchFuncs {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTSPWatchFuncs @ {self:p}"))
            .field("message_received", &self.message_received)
            .field("message_sent", &self.message_sent)
            .field("closed", &self.closed)
            .field("error", &self.error)
            .field("tunnel_start", &self.tunnel_start)
            .field("tunnel_complete", &self.tunnel_complete)
            .field("error_full", &self.error_full)
            .field("tunnel_lost", &self.tunnel_lost)
            .field("tunnel_http_response", &self.tunnel_http_response)
            .finish()
    }
}

// Interfaces
#[repr(C)]
#[allow(dead_code)]
pub struct GstRTSPExtension {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstRTSPExtension {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "GstRTSPExtension @ {self:p}")
    }
}

extern "C" {

    //=========================================================================
    // GstRTSPAuthMethod
    //=========================================================================
    pub fn gst_rtsp_auth_method_get_type() -> GType;

    //=========================================================================
    // GstRTSPFamily
    //=========================================================================
    pub fn gst_rtsp_family_get_type() -> GType;

    //=========================================================================
    // GstRTSPHeaderField
    //=========================================================================
    pub fn gst_rtsp_header_field_get_type() -> GType;

    //=========================================================================
    // GstRTSPMsgType
    //=========================================================================
    pub fn gst_rtsp_msg_type_get_type() -> GType;

    //=========================================================================
    // GstRTSPRangeUnit
    //=========================================================================
    pub fn gst_rtsp_range_unit_get_type() -> GType;

    //=========================================================================
    // GstRTSPResult
    //=========================================================================
    pub fn gst_rtsp_result_get_type() -> GType;

    //=========================================================================
    // GstRTSPState
    //=========================================================================
    pub fn gst_rtsp_state_get_type() -> GType;

    //=========================================================================
    // GstRTSPStatusCode
    //=========================================================================
    pub fn gst_rtsp_status_code_get_type() -> GType;

    //=========================================================================
    // GstRTSPTimeType
    //=========================================================================
    pub fn gst_rtsp_time_type_get_type() -> GType;

    //=========================================================================
    // GstRTSPVersion
    //=========================================================================
    pub fn gst_rtsp_version_get_type() -> GType;
    pub fn gst_rtsp_version_as_text(version: GstRTSPVersion) -> *const c_char;

    //=========================================================================
    // GstRTSPEvent
    //=========================================================================
    pub fn gst_rtsp_event_get_type() -> GType;

    //=========================================================================
    // GstRTSPLowerTrans
    //=========================================================================
    pub fn gst_rtsp_lower_trans_get_type() -> GType;

    //=========================================================================
    // GstRTSPMethod
    //=========================================================================
    pub fn gst_rtsp_method_get_type() -> GType;
    pub fn gst_rtsp_method_as_text(method: GstRTSPMethod) -> *const c_char;

    //=========================================================================
    // GstRTSPProfile
    //=========================================================================
    pub fn gst_rtsp_profile_get_type() -> GType;

    //=========================================================================
    // GstRTSPTransMode
    //=========================================================================
    pub fn gst_rtsp_trans_mode_get_type() -> GType;

    //=========================================================================
    // GstRTSPAuthCredential
    //=========================================================================
    pub fn gst_rtsp_auth_credential_get_type() -> GType;

    //=========================================================================
    // GstRTSPAuthParam
    //=========================================================================
    pub fn gst_rtsp_auth_param_get_type() -> GType;
    pub fn gst_rtsp_auth_param_copy(param: *mut GstRTSPAuthParam) -> *mut GstRTSPAuthParam;
    pub fn gst_rtsp_auth_param_free(param: *mut GstRTSPAuthParam);

    //=========================================================================
    // GstRTSPConnection
    //=========================================================================
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_rtsp_connection_add_extra_http_request_header(
        conn: *mut GstRTSPConnection,
        key: *const c_char,
        value: *const c_char,
    );
    pub fn gst_rtsp_connection_clear_auth_params(conn: *mut GstRTSPConnection);
    pub fn gst_rtsp_connection_close(conn: *mut GstRTSPConnection) -> GstRTSPResult;
    pub fn gst_rtsp_connection_connect(
        conn: *mut GstRTSPConnection,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_connect_usec(
        conn: *mut GstRTSPConnection,
        timeout: i64,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_connect_with_response(
        conn: *mut GstRTSPConnection,
        timeout: *mut glib::GTimeVal,
        response: *mut GstRTSPMessage,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_connect_with_response_usec(
        conn: *mut GstRTSPConnection,
        timeout: i64,
        response: *mut GstRTSPMessage,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_do_tunnel(
        conn: *mut GstRTSPConnection,
        conn2: *mut GstRTSPConnection,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_flush(
        conn: *mut GstRTSPConnection,
        flush: gboolean,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_free(conn: *mut GstRTSPConnection) -> GstRTSPResult;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtsp_connection_get_ignore_x_server_reply(
        conn: *const GstRTSPConnection,
    ) -> gboolean;
    pub fn gst_rtsp_connection_get_ip(conn: *const GstRTSPConnection) -> *const c_char;
    pub fn gst_rtsp_connection_get_read_socket(conn: *const GstRTSPConnection)
        -> *mut gio::GSocket;
    pub fn gst_rtsp_connection_get_remember_session_id(conn: *mut GstRTSPConnection) -> gboolean;
    pub fn gst_rtsp_connection_get_tls(
        conn: *mut GstRTSPConnection,
        error: *mut *mut glib::GError,
    ) -> *mut gio::GTlsConnection;
    pub fn gst_rtsp_connection_get_tls_database(
        conn: *mut GstRTSPConnection,
    ) -> *mut gio::GTlsDatabase;
    pub fn gst_rtsp_connection_get_tls_interaction(
        conn: *mut GstRTSPConnection,
    ) -> *mut gio::GTlsInteraction;
    pub fn gst_rtsp_connection_get_tls_validation_flags(
        conn: *mut GstRTSPConnection,
    ) -> gio::GTlsCertificateFlags;
    pub fn gst_rtsp_connection_get_tunnelid(conn: *const GstRTSPConnection) -> *const c_char;
    pub fn gst_rtsp_connection_get_url(conn: *const GstRTSPConnection) -> *mut GstRTSPUrl;
    pub fn gst_rtsp_connection_get_write_socket(
        conn: *const GstRTSPConnection,
    ) -> *mut gio::GSocket;
    pub fn gst_rtsp_connection_is_tunneled(conn: *const GstRTSPConnection) -> gboolean;
    pub fn gst_rtsp_connection_next_timeout(
        conn: *mut GstRTSPConnection,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_next_timeout_usec(conn: *mut GstRTSPConnection) -> i64;
    pub fn gst_rtsp_connection_poll(
        conn: *mut GstRTSPConnection,
        events: GstRTSPEvent,
        revents: *mut GstRTSPEvent,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_poll_usec(
        conn: *mut GstRTSPConnection,
        events: GstRTSPEvent,
        revents: *mut GstRTSPEvent,
        timeout: i64,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_read(
        conn: *mut GstRTSPConnection,
        data: *mut u8,
        size: c_uint,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_read_usec(
        conn: *mut GstRTSPConnection,
        data: *mut u8,
        size: c_uint,
        timeout: i64,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_receive(
        conn: *mut GstRTSPConnection,
        message: *mut GstRTSPMessage,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_receive_usec(
        conn: *mut GstRTSPConnection,
        message: *mut GstRTSPMessage,
        timeout: i64,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_reset_timeout(conn: *mut GstRTSPConnection) -> GstRTSPResult;
    pub fn gst_rtsp_connection_send(
        conn: *mut GstRTSPConnection,
        message: *mut GstRTSPMessage,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtsp_connection_send_messages(
        conn: *mut GstRTSPConnection,
        messages: *mut GstRTSPMessage,
        n_messages: c_uint,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_send_messages_usec(
        conn: *mut GstRTSPConnection,
        messages: *mut GstRTSPMessage,
        n_messages: c_uint,
        timeout: i64,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_send_usec(
        conn: *mut GstRTSPConnection,
        message: *mut GstRTSPMessage,
        timeout: i64,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_set_accept_certificate_func(
        conn: *mut GstRTSPConnection,
        func: GstRTSPConnectionAcceptCertificateFunc,
        user_data: gpointer,
        destroy_notify: glib::GDestroyNotify,
    );
    pub fn gst_rtsp_connection_set_auth(
        conn: *mut GstRTSPConnection,
        method: GstRTSPAuthMethod,
        user: *const c_char,
        pass: *const c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_set_auth_param(
        conn: *mut GstRTSPConnection,
        param: *const c_char,
        value: *const c_char,
    );
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_set_content_length_limit(
        conn: *mut GstRTSPConnection,
        limit: c_uint,
    );
    pub fn gst_rtsp_connection_set_http_mode(conn: *mut GstRTSPConnection, enable: gboolean);
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtsp_connection_set_ignore_x_server_reply(
        conn: *mut GstRTSPConnection,
        ignore: gboolean,
    );
    pub fn gst_rtsp_connection_set_ip(conn: *mut GstRTSPConnection, ip: *const c_char);
    pub fn gst_rtsp_connection_set_proxy(
        conn: *mut GstRTSPConnection,
        host: *const c_char,
        port: c_uint,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_set_qos_dscp(
        conn: *mut GstRTSPConnection,
        qos_dscp: c_uint,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_set_remember_session_id(
        conn: *mut GstRTSPConnection,
        remember: gboolean,
    );
    pub fn gst_rtsp_connection_set_tls_database(
        conn: *mut GstRTSPConnection,
        database: *mut gio::GTlsDatabase,
    );
    pub fn gst_rtsp_connection_set_tls_interaction(
        conn: *mut GstRTSPConnection,
        interaction: *mut gio::GTlsInteraction,
    );
    pub fn gst_rtsp_connection_set_tls_validation_flags(
        conn: *mut GstRTSPConnection,
        flags: gio::GTlsCertificateFlags,
    ) -> gboolean;
    pub fn gst_rtsp_connection_set_tunneled(conn: *mut GstRTSPConnection, tunneled: gboolean);
    pub fn gst_rtsp_connection_write(
        conn: *mut GstRTSPConnection,
        data: *const u8,
        size: c_uint,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_connection_write_usec(
        conn: *mut GstRTSPConnection,
        data: *const u8,
        size: c_uint,
        timeout: i64,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_accept(
        socket: *mut gio::GSocket,
        conn: *mut *mut GstRTSPConnection,
        cancellable: *mut gio::GCancellable,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_create(
        url: *const GstRTSPUrl,
        conn: *mut *mut GstRTSPConnection,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_connection_create_from_socket(
        socket: *mut gio::GSocket,
        ip: *const c_char,
        port: u16,
        initial_buffer: *const c_char,
        conn: *mut *mut GstRTSPConnection,
    ) -> GstRTSPResult;

    //=========================================================================
    // GstRTSPMessage
    //=========================================================================
    pub fn gst_rtsp_msg_get_type() -> GType;
    pub fn gst_rtsp_message_add_header(
        msg: *mut GstRTSPMessage,
        field: GstRTSPHeaderField,
        value: *const c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_add_header_by_name(
        msg: *mut GstRTSPMessage,
        header: *const c_char,
        value: *const c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_append_headers(
        msg: *const GstRTSPMessage,
        str: *mut glib::GString,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_copy(
        msg: *const GstRTSPMessage,
        copy: *mut *mut GstRTSPMessage,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_dump(msg: *mut GstRTSPMessage) -> GstRTSPResult;
    pub fn gst_rtsp_message_free(msg: *mut GstRTSPMessage) -> GstRTSPResult;
    pub fn gst_rtsp_message_get_body(
        msg: *const GstRTSPMessage,
        data: *mut *mut u8,
        size: *mut c_uint,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtsp_message_get_body_buffer(
        msg: *const GstRTSPMessage,
        buffer: *mut *mut gst::GstBuffer,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_get_header(
        msg: *const GstRTSPMessage,
        field: GstRTSPHeaderField,
        value: *mut *mut c_char,
        indx: c_int,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_get_header_by_name(
        msg: *mut GstRTSPMessage,
        header: *const c_char,
        value: *mut *mut c_char,
        index: c_int,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_get_type(msg: *mut GstRTSPMessage) -> GstRTSPMsgType;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtsp_message_has_body_buffer(msg: *const GstRTSPMessage) -> gboolean;
    pub fn gst_rtsp_message_init(msg: *mut GstRTSPMessage) -> GstRTSPResult;
    pub fn gst_rtsp_message_init_data(msg: *mut GstRTSPMessage, channel: u8) -> GstRTSPResult;
    pub fn gst_rtsp_message_init_request(
        msg: *mut GstRTSPMessage,
        method: GstRTSPMethod,
        uri: *const c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_init_response(
        msg: *mut GstRTSPMessage,
        code: GstRTSPStatusCode,
        reason: *const c_char,
        request: *const GstRTSPMessage,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_parse_auth_credentials(
        msg: *mut GstRTSPMessage,
        field: GstRTSPHeaderField,
    ) -> *mut *mut GstRTSPAuthCredential;
    pub fn gst_rtsp_message_parse_data(msg: *mut GstRTSPMessage, channel: *mut u8)
        -> GstRTSPResult;
    pub fn gst_rtsp_message_parse_request(
        msg: *mut GstRTSPMessage,
        method: *mut GstRTSPMethod,
        uri: *mut *const c_char,
        version: *mut GstRTSPVersion,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_parse_response(
        msg: *mut GstRTSPMessage,
        code: *mut GstRTSPStatusCode,
        reason: *mut *const c_char,
        version: *mut GstRTSPVersion,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_remove_header(
        msg: *mut GstRTSPMessage,
        field: GstRTSPHeaderField,
        indx: c_int,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_remove_header_by_name(
        msg: *mut GstRTSPMessage,
        header: *const c_char,
        index: c_int,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_set_body(
        msg: *mut GstRTSPMessage,
        data: *const u8,
        size: c_uint,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtsp_message_set_body_buffer(
        msg: *mut GstRTSPMessage,
        buffer: *mut gst::GstBuffer,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_steal_body(
        msg: *mut GstRTSPMessage,
        data: *mut *mut u8,
        size: *mut c_uint,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtsp_message_steal_body_buffer(
        msg: *mut GstRTSPMessage,
        buffer: *mut *mut gst::GstBuffer,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_take_body(
        msg: *mut GstRTSPMessage,
        data: *mut u8,
        size: c_uint,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtsp_message_take_body_buffer(
        msg: *mut GstRTSPMessage,
        buffer: *mut gst::GstBuffer,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_take_header(
        msg: *mut GstRTSPMessage,
        field: GstRTSPHeaderField,
        value: *mut c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_take_header_by_name(
        msg: *mut GstRTSPMessage,
        header: *const c_char,
        value: *mut c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_unset(msg: *mut GstRTSPMessage) -> GstRTSPResult;

    //=========================================================================
    // GstRTSPRange
    //=========================================================================
    pub fn gst_rtsp_range_convert_units(
        range: *mut GstRTSPTimeRange,
        unit: GstRTSPRangeUnit,
    ) -> gboolean;
    pub fn gst_rtsp_range_free(range: *mut GstRTSPTimeRange);
    pub fn gst_rtsp_range_get_times(
        range: *const GstRTSPTimeRange,
        min: *mut gst::GstClockTime,
        max: *mut gst::GstClockTime,
    ) -> gboolean;
    pub fn gst_rtsp_range_parse(
        rangestr: *const c_char,
        range: *mut *mut GstRTSPTimeRange,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_range_to_string(range: *const GstRTSPTimeRange) -> *mut c_char;

    //=========================================================================
    // GstRTSPTransport
    //=========================================================================
    pub fn gst_rtsp_transport_as_text(transport: *mut GstRTSPTransport) -> *mut c_char;
    pub fn gst_rtsp_transport_free(transport: *mut GstRTSPTransport) -> GstRTSPResult;
    pub fn gst_rtsp_transport_get_media_type(
        transport: *mut GstRTSPTransport,
        media_type: *mut *const c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_transport_get_manager(
        trans: GstRTSPTransMode,
        manager: *mut *const c_char,
        option: c_uint,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_transport_get_mime(
        trans: GstRTSPTransMode,
        mime: *mut *const c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_transport_init(transport: *mut GstRTSPTransport) -> GstRTSPResult;
    pub fn gst_rtsp_transport_new(transport: *mut *mut GstRTSPTransport) -> GstRTSPResult;
    pub fn gst_rtsp_transport_parse(
        str: *const c_char,
        transport: *mut GstRTSPTransport,
    ) -> GstRTSPResult;

    //=========================================================================
    // GstRTSPUrl
    //=========================================================================
    pub fn gst_rtsp_url_get_type() -> GType;
    pub fn gst_rtsp_url_copy(url: *const GstRTSPUrl) -> *mut GstRTSPUrl;
    pub fn gst_rtsp_url_decode_path_components(url: *const GstRTSPUrl) -> *mut *mut c_char;
    pub fn gst_rtsp_url_free(url: *mut GstRTSPUrl);
    pub fn gst_rtsp_url_get_port(url: *const GstRTSPUrl, port: *mut u16) -> GstRTSPResult;
    pub fn gst_rtsp_url_get_request_uri(url: *const GstRTSPUrl) -> *mut c_char;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_url_get_request_uri_with_control(
        url: *const GstRTSPUrl,
        control_path: *const c_char,
    ) -> *mut c_char;
    pub fn gst_rtsp_url_set_port(url: *mut GstRTSPUrl, port: u16) -> GstRTSPResult;
    pub fn gst_rtsp_url_parse(urlstr: *const c_char, url: *mut *mut GstRTSPUrl) -> GstRTSPResult;

    //=========================================================================
    // GstRTSPWatch
    //=========================================================================
    pub fn gst_rtsp_watch_attach(
        watch: *mut GstRTSPWatch,
        context: *mut glib::GMainContext,
    ) -> c_uint;
    pub fn gst_rtsp_watch_get_send_backlog(
        watch: *mut GstRTSPWatch,
        bytes: *mut size_t,
        messages: *mut c_uint,
    );
    pub fn gst_rtsp_watch_reset(watch: *mut GstRTSPWatch);
    pub fn gst_rtsp_watch_send_message(
        watch: *mut GstRTSPWatch,
        message: *mut GstRTSPMessage,
        id: *mut c_uint,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtsp_watch_send_messages(
        watch: *mut GstRTSPWatch,
        messages: *mut GstRTSPMessage,
        n_messages: c_uint,
        id: *mut c_uint,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_watch_set_flushing(watch: *mut GstRTSPWatch, flushing: gboolean);
    pub fn gst_rtsp_watch_set_send_backlog(
        watch: *mut GstRTSPWatch,
        bytes: size_t,
        messages: c_uint,
    );
    pub fn gst_rtsp_watch_unref(watch: *mut GstRTSPWatch);
    pub fn gst_rtsp_watch_wait_backlog(
        watch: *mut GstRTSPWatch,
        timeout: *mut glib::GTimeVal,
    ) -> GstRTSPResult;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtsp_watch_wait_backlog_usec(
        watch: *mut GstRTSPWatch,
        timeout: i64,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_watch_write_data(
        watch: *mut GstRTSPWatch,
        data: *const u8,
        size: c_uint,
        id: *mut c_uint,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_watch_new(
        conn: *mut GstRTSPConnection,
        funcs: *mut GstRTSPWatchFuncs,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> *mut GstRTSPWatch;

    //=========================================================================
    // GstRTSPExtension
    //=========================================================================
    pub fn gst_rtsp_extension_get_type() -> GType;
    pub fn gst_rtsp_extension_after_send(
        ext: *mut GstRTSPExtension,
        req: *mut GstRTSPMessage,
        resp: *mut GstRTSPMessage,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_extension_before_send(
        ext: *mut GstRTSPExtension,
        req: *mut GstRTSPMessage,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_extension_configure_stream(
        ext: *mut GstRTSPExtension,
        caps: *mut gst::GstCaps,
    ) -> gboolean;
    pub fn gst_rtsp_extension_detect_server(
        ext: *mut GstRTSPExtension,
        resp: *mut GstRTSPMessage,
    ) -> gboolean;
    pub fn gst_rtsp_extension_get_transports(
        ext: *mut GstRTSPExtension,
        protocols: GstRTSPLowerTrans,
        transport: *mut *mut c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_extension_parse_sdp(
        ext: *mut GstRTSPExtension,
        sdp: *mut gst_sdp::GstSDPMessage,
        s: *mut gst::GstStructure,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_extension_receive_request(
        ext: *mut GstRTSPExtension,
        req: *mut GstRTSPMessage,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_extension_send(
        ext: *mut GstRTSPExtension,
        req: *mut GstRTSPMessage,
        resp: *mut GstRTSPMessage,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_extension_setup_media(
        ext: *mut GstRTSPExtension,
        media: *mut gst_sdp::GstSDPMedia,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_extension_stream_select(
        ext: *mut GstRTSPExtension,
        url: *mut GstRTSPUrl,
    ) -> GstRTSPResult;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_rtsp_auth_credentials_free(credentials: *mut *mut GstRTSPAuthCredential);
    pub fn gst_rtsp_find_header_field(header: *const c_char) -> GstRTSPHeaderField;
    pub fn gst_rtsp_find_method(method: *const c_char) -> GstRTSPMethod;
    pub fn gst_rtsp_generate_digest_auth_response(
        algorithm: *const c_char,
        method: *const c_char,
        realm: *const c_char,
        username: *const c_char,
        password: *const c_char,
        uri: *const c_char,
        nonce: *const c_char,
    ) -> *mut c_char;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtsp_generate_digest_auth_response_from_md5(
        algorithm: *const c_char,
        method: *const c_char,
        md5: *const c_char,
        uri: *const c_char,
        nonce: *const c_char,
    ) -> *mut c_char;
    pub fn gst_rtsp_header_allow_multiple(field: GstRTSPHeaderField) -> gboolean;
    pub fn gst_rtsp_header_as_text(field: GstRTSPHeaderField) -> *const c_char;
    pub fn gst_rtsp_message_new(msg: *mut *mut GstRTSPMessage) -> GstRTSPResult;
    pub fn gst_rtsp_message_new_data(msg: *mut *mut GstRTSPMessage, channel: u8) -> GstRTSPResult;
    pub fn gst_rtsp_message_new_request(
        msg: *mut *mut GstRTSPMessage,
        method: GstRTSPMethod,
        uri: *const c_char,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_message_new_response(
        msg: *mut *mut GstRTSPMessage,
        code: GstRTSPStatusCode,
        reason: *const c_char,
        request: *const GstRTSPMessage,
    ) -> GstRTSPResult;
    pub fn gst_rtsp_options_as_text(options: GstRTSPMethod) -> *mut c_char;
    pub fn gst_rtsp_options_from_text(options: *const c_char) -> GstRTSPMethod;
    pub fn gst_rtsp_status_as_text(code: GstRTSPStatusCode) -> *const c_char;
    pub fn gst_rtsp_strresult(result: GstRTSPResult) -> *mut c_char;

}
