// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{ffi, RTSPFilterResult, RTSPMedia, RTSPSessionMedia};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstRTSPSession")]
    pub struct RTSPSession(Object<ffi::GstRTSPSession, ffi::GstRTSPSessionClass>);

    match fn {
        type_ => || ffi::gst_rtsp_session_get_type(),
    }
}

impl RTSPSession {
    pub const NONE: Option<&'static RTSPSession> = None;

    #[doc(alias = "gst_rtsp_session_new")]
    pub fn new(sessionid: &str) -> RTSPSession {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_rtsp_session_new(sessionid.to_glib_none().0)) }
    }
}

unsafe impl Send for RTSPSession {}
unsafe impl Sync for RTSPSession {}

pub trait RTSPSessionExt: IsA<RTSPSession> + 'static {
    #[doc(alias = "gst_rtsp_session_allow_expire")]
    fn allow_expire(&self) {
        unsafe {
            ffi::gst_rtsp_session_allow_expire(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gst_rtsp_session_filter")]
    fn filter(
        &self,
        func: Option<&mut dyn FnMut(&RTSPSession, &RTSPSessionMedia) -> RTSPFilterResult>,
    ) -> Vec<RTSPSessionMedia> {
        let mut func_data: Option<
            &mut dyn FnMut(&RTSPSession, &RTSPSessionMedia) -> RTSPFilterResult,
        > = func;
        unsafe extern "C" fn func_func(
            sess: *mut ffi::GstRTSPSession,
            media: *mut ffi::GstRTSPSessionMedia,
            user_data: glib::ffi::gpointer,
        ) -> ffi::GstRTSPFilterResult {
            let sess = from_glib_borrow(sess);
            let media = from_glib_borrow(media);
            let callback = user_data
                as *mut Option<&mut dyn FnMut(&RTSPSession, &RTSPSessionMedia) -> RTSPFilterResult>;
            if let Some(ref mut callback) = *callback {
                callback(&sess, &media)
            } else {
                panic!("cannot get closure...")
            }
            .into_glib()
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        let super_callback0: &mut Option<
            &mut dyn FnMut(&RTSPSession, &RTSPSessionMedia) -> RTSPFilterResult,
        > = &mut func_data;
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gst_rtsp_session_filter(
                self.as_ref().to_glib_none().0,
                func,
                super_callback0 as *mut _ as *mut _,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_session_get_header")]
    #[doc(alias = "get_header")]
    fn header(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gst_rtsp_session_get_header(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_session_get_sessionid")]
    #[doc(alias = "get_sessionid")]
    fn sessionid(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gst_rtsp_session_get_sessionid(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_session_get_timeout")]
    #[doc(alias = "get_timeout")]
    fn timeout(&self) -> u32 {
        unsafe { ffi::gst_rtsp_session_get_timeout(self.as_ref().to_glib_none().0) }
    }

    //#[doc(alias = "gst_rtsp_session_is_expired")]
    //fn is_expired(&self, now: /*Ignored*/&mut glib::TimeVal) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_session_is_expired() }
    //}

    #[doc(alias = "gst_rtsp_session_is_expired_usec")]
    fn is_expired_usec(&self, now: i64) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_session_is_expired_usec(
                self.as_ref().to_glib_none().0,
                now,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_session_manage_media")]
    fn manage_media(&self, path: &str, media: impl IsA<RTSPMedia>) -> RTSPSessionMedia {
        unsafe {
            from_glib_none(ffi::gst_rtsp_session_manage_media(
                self.as_ref().to_glib_none().0,
                path.to_glib_none().0,
                media.upcast().into_glib_ptr(),
            ))
        }
    }

    //#[doc(alias = "gst_rtsp_session_next_timeout")]
    //fn next_timeout(&self, now: /*Ignored*/&mut glib::TimeVal) -> i32 {
    //    unsafe { TODO: call ffi:gst_rtsp_session_next_timeout() }
    //}

    #[doc(alias = "gst_rtsp_session_next_timeout_usec")]
    fn next_timeout_usec(&self, now: i64) -> i32 {
        unsafe { ffi::gst_rtsp_session_next_timeout_usec(self.as_ref().to_glib_none().0, now) }
    }

    #[doc(alias = "gst_rtsp_session_prevent_expire")]
    fn prevent_expire(&self) {
        unsafe {
            ffi::gst_rtsp_session_prevent_expire(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gst_rtsp_session_release_media")]
    fn release_media(&self, media: &impl IsA<RTSPSessionMedia>) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_session_release_media(
                self.as_ref().to_glib_none().0,
                media.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_session_set_timeout")]
    #[doc(alias = "timeout")]
    fn set_timeout(&self, timeout: u32) {
        unsafe {
            ffi::gst_rtsp_session_set_timeout(self.as_ref().to_glib_none().0, timeout);
        }
    }

    #[doc(alias = "gst_rtsp_session_touch")]
    fn touch(&self) {
        unsafe {
            ffi::gst_rtsp_session_touch(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "extra-timeout")]
    fn extra_timeout(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "extra-timeout")
    }

    #[doc(alias = "extra-timeout")]
    fn set_extra_timeout(&self, extra_timeout: u32) {
        ObjectExt::set_property(self.as_ref(), "extra-timeout", extra_timeout)
    }

    #[doc(alias = "timeout-always-visible")]
    fn is_timeout_always_visible(&self) -> bool {
        ObjectExt::property(self.as_ref(), "timeout-always-visible")
    }

    #[doc(alias = "timeout-always-visible")]
    fn set_timeout_always_visible(&self, timeout_always_visible: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "timeout-always-visible",
            timeout_always_visible,
        )
    }

    #[doc(alias = "extra-timeout")]
    fn connect_extra_timeout_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_timeout_trampoline<
            P: IsA<RTSPSession>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(RTSPSession::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::extra-timeout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_extra_timeout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "timeout")]
    fn connect_timeout_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_timeout_trampoline<
            P: IsA<RTSPSession>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(RTSPSession::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::timeout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_timeout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "timeout-always-visible")]
    fn connect_timeout_always_visible_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_timeout_always_visible_trampoline<
            P: IsA<RTSPSession>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstRTSPSession,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(RTSPSession::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::timeout-always-visible".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_timeout_always_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<RTSPSession>> RTSPSessionExt for O {}
