// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![cfg(unix)]

use gstreamer_d3d12_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gstreamer-d3d12-1.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GstD3D12AllocationFlags",
        Layout {
            size: size_of::<GstD3D12AllocationFlags>(),
            alignment: align_of::<GstD3D12AllocationFlags>(),
        },
    ),
    (
        "GstD3D12Allocator",
        Layout {
            size: size_of::<GstD3D12Allocator>(),
            alignment: align_of::<GstD3D12Allocator>(),
        },
    ),
    (
        "GstD3D12AllocatorClass",
        Layout {
            size: size_of::<GstD3D12AllocatorClass>(),
            alignment: align_of::<GstD3D12AllocatorClass>(),
        },
    ),
    (
        "GstD3D12BufferPool",
        Layout {
            size: size_of::<GstD3D12BufferPool>(),
            alignment: align_of::<GstD3D12BufferPool>(),
        },
    ),
    (
        "GstD3D12BufferPoolClass",
        Layout {
            size: size_of::<GstD3D12BufferPoolClass>(),
            alignment: align_of::<GstD3D12BufferPoolClass>(),
        },
    ),
    (
        "GstD3D12CmdAllocPool",
        Layout {
            size: size_of::<GstD3D12CmdAllocPool>(),
            alignment: align_of::<GstD3D12CmdAllocPool>(),
        },
    ),
    (
        "GstD3D12CmdAllocPoolClass",
        Layout {
            size: size_of::<GstD3D12CmdAllocPoolClass>(),
            alignment: align_of::<GstD3D12CmdAllocPoolClass>(),
        },
    ),
    (
        "GstD3D12CmdQueue",
        Layout {
            size: size_of::<GstD3D12CmdQueue>(),
            alignment: align_of::<GstD3D12CmdQueue>(),
        },
    ),
    (
        "GstD3D12CmdQueueClass",
        Layout {
            size: size_of::<GstD3D12CmdQueueClass>(),
            alignment: align_of::<GstD3D12CmdQueueClass>(),
        },
    ),
    (
        "GstD3D12Converter",
        Layout {
            size: size_of::<GstD3D12Converter>(),
            alignment: align_of::<GstD3D12Converter>(),
        },
    ),
    (
        "GstD3D12ConverterAlphaMode",
        Layout {
            size: size_of::<GstD3D12ConverterAlphaMode>(),
            alignment: align_of::<GstD3D12ConverterAlphaMode>(),
        },
    ),
    (
        "GstD3D12ConverterClass",
        Layout {
            size: size_of::<GstD3D12ConverterClass>(),
            alignment: align_of::<GstD3D12ConverterClass>(),
        },
    ),
    (
        "GstD3D12ConverterColorBalance",
        Layout {
            size: size_of::<GstD3D12ConverterColorBalance>(),
            alignment: align_of::<GstD3D12ConverterColorBalance>(),
        },
    ),
    (
        "GstD3D12ConverterMipGen",
        Layout {
            size: size_of::<GstD3D12ConverterMipGen>(),
            alignment: align_of::<GstD3D12ConverterMipGen>(),
        },
    ),
    (
        "GstD3D12ConverterSamplerFilter",
        Layout {
            size: size_of::<GstD3D12ConverterSamplerFilter>(),
            alignment: align_of::<GstD3D12ConverterSamplerFilter>(),
        },
    ),
    (
        "GstD3D12DescHeapPool",
        Layout {
            size: size_of::<GstD3D12DescHeapPool>(),
            alignment: align_of::<GstD3D12DescHeapPool>(),
        },
    ),
    (
        "GstD3D12DescHeapPoolClass",
        Layout {
            size: size_of::<GstD3D12DescHeapPoolClass>(),
            alignment: align_of::<GstD3D12DescHeapPoolClass>(),
        },
    ),
    (
        "GstD3D12Device",
        Layout {
            size: size_of::<GstD3D12Device>(),
            alignment: align_of::<GstD3D12Device>(),
        },
    ),
    (
        "GstD3D12DeviceClass",
        Layout {
            size: size_of::<GstD3D12DeviceClass>(),
            alignment: align_of::<GstD3D12DeviceClass>(),
        },
    ),
    (
        "GstD3D12FenceDataPool",
        Layout {
            size: size_of::<GstD3D12FenceDataPool>(),
            alignment: align_of::<GstD3D12FenceDataPool>(),
        },
    ),
    (
        "GstD3D12FenceDataPoolClass",
        Layout {
            size: size_of::<GstD3D12FenceDataPoolClass>(),
            alignment: align_of::<GstD3D12FenceDataPoolClass>(),
        },
    ),
    (
        "GstD3D12Format",
        Layout {
            size: size_of::<GstD3D12Format>(),
            alignment: align_of::<GstD3D12Format>(),
        },
    ),
    (
        "GstD3D12FormatFlags",
        Layout {
            size: size_of::<GstD3D12FormatFlags>(),
            alignment: align_of::<GstD3D12FormatFlags>(),
        },
    ),
    (
        "GstD3D12FrameFence",
        Layout {
            size: size_of::<GstD3D12FrameFence>(),
            alignment: align_of::<GstD3D12FrameFence>(),
        },
    ),
    (
        "GstD3D12FrameMapFlags",
        Layout {
            size: size_of::<GstD3D12FrameMapFlags>(),
            alignment: align_of::<GstD3D12FrameMapFlags>(),
        },
    ),
    (
        "GstD3D12Memory",
        Layout {
            size: size_of::<GstD3D12Memory>(),
            alignment: align_of::<GstD3D12Memory>(),
        },
    ),
    (
        "GstD3D12MemoryTransfer",
        Layout {
            size: size_of::<GstD3D12MemoryTransfer>(),
            alignment: align_of::<GstD3D12MemoryTransfer>(),
        },
    ),
    (
        "GstD3D12PoolAllocator",
        Layout {
            size: size_of::<GstD3D12PoolAllocator>(),
            alignment: align_of::<GstD3D12PoolAllocator>(),
        },
    ),
    (
        "GstD3D12PoolAllocatorClass",
        Layout {
            size: size_of::<GstD3D12PoolAllocatorClass>(),
            alignment: align_of::<GstD3D12PoolAllocatorClass>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) D3D12_FILTER_ANISOTROPIC", "85"),
    ("(gint) D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT", "16"),
    ("(gint) D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT", "20"),
    ("(gint) D3D12_FILTER_MIN_MAG_MIP_LINEAR", "21"),
    ("(gint) D3D12_FILTER_MIN_MAG_MIP_POINT", "0"),
    ("GST_CAPS_FEATURE_MEMORY_D3D12_MEMORY", "memory:D3D12Memory"),
    ("(gint) GST_D3D12_ALLOCATION_FLAG_DEFAULT", "0"),
    ("(gint) GST_D3D12_CONVERTER_ALPHA_MODE_PREMULTIPLIED", "1"),
    ("(gint) GST_D3D12_CONVERTER_ALPHA_MODE_STRAIGHT", "2"),
    ("(gint) GST_D3D12_CONVERTER_ALPHA_MODE_UNSPECIFIED", "0"),
    ("(gint) GST_D3D12_CONVERTER_COLOR_BALANCE_DISABLED", "0"),
    ("(gint) GST_D3D12_CONVERTER_COLOR_BALANCE_ENABLED", "1"),
    ("(gint) GST_D3D12_CONVERTER_MIP_GEN_DISABLED", "0"),
    ("(gint) GST_D3D12_CONVERTER_MIP_GEN_ENABLED", "1"),
    (
        "GST_D3D12_CONVERTER_OPT_COLOR_BALANCE",
        "GstD3D12Converter.color-balance",
    ),
    (
        "GST_D3D12_CONVERTER_OPT_DEST_ALPHA_MODE",
        "GstD3D12Converter.dest-alpha-mode",
    ),
    (
        "GST_D3D12_CONVERTER_OPT_GAMMA_MODE",
        "GstD3D12Converter.gamma-mode",
    ),
    (
        "GST_D3D12_CONVERTER_OPT_MIP_GEN",
        "GstD3D12Converter.mip-gen",
    ),
    (
        "GST_D3D12_CONVERTER_OPT_PRIMARIES_MODE",
        "GstD3D12Converter.primaries-mode",
    ),
    (
        "GST_D3D12_CONVERTER_OPT_PSO_SAMPLE_DESC_COUNT",
        "GstD3D12Converter.pso-sample-desc-count",
    ),
    (
        "GST_D3D12_CONVERTER_OPT_PSO_SAMPLE_DESC_QUALITY",
        "GstD3D12Converter.pso-sample-desc-quality",
    ),
    (
        "GST_D3D12_CONVERTER_OPT_SAMPLER_FILTER",
        "GstD3D12Converter.sampler-filter",
    ),
    (
        "GST_D3D12_CONVERTER_OPT_SRC_ALPHA_MODE",
        "GstD3D12Converter.src-alpha-mode",
    ),
    (
        "GST_D3D12_DEVICE_HANDLE_CONTEXT_TYPE",
        "gst.d3d12.device.handle",
    ),
    ("(guint) GST_D3D12_FORMAT_FLAG_NONE", "0"),
    ("(guint) GST_D3D12_FORMAT_FLAG_OUTPUT_UAV", "1"),
    ("(guint) GST_D3D12_FRAME_MAP_FLAG_NONE", "0"),
    ("(guint) GST_D3D12_FRAME_MAP_FLAG_RTV", "4"),
    ("(guint) GST_D3D12_FRAME_MAP_FLAG_SRV", "1"),
    ("(guint) GST_D3D12_FRAME_MAP_FLAG_UAV", "2"),
    ("GST_D3D12_MEMORY_NAME", "D3D12Memory"),
    ("(guint) GST_D3D12_MEMORY_TRANSFER_NEED_DOWNLOAD", "1048576"),
    ("(guint) GST_D3D12_MEMORY_TRANSFER_NEED_UPLOAD", "2097152"),
    ("GST_MAP_D3D12", "131072"),
    ("GST_MAP_READ_D3D12", "131073"),
    ("GST_MAP_WRITE_D3D12", "131074"),
];
