// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use glib_sys as glib;
use gstreamer_sys as gst;
use gstreamer_video_sys as gst_video;

#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};
#[allow(unused_imports)]
use libc::{intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE};
#[allow(unused_imports)]
use std::ffi::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type GstD3D12AllocationFlags = c_int;
pub const GST_D3D12_ALLOCATION_FLAG_DEFAULT: GstD3D12AllocationFlags = 0;

pub type GstD3D12ConverterAlphaMode = c_int;
pub const GST_D3D12_CONVERTER_ALPHA_MODE_UNSPECIFIED: GstD3D12ConverterAlphaMode = 0;
pub const GST_D3D12_CONVERTER_ALPHA_MODE_PREMULTIPLIED: GstD3D12ConverterAlphaMode = 1;
pub const GST_D3D12_CONVERTER_ALPHA_MODE_STRAIGHT: GstD3D12ConverterAlphaMode = 2;

pub type GstD3D12ConverterColorBalance = c_int;
pub const GST_D3D12_CONVERTER_COLOR_BALANCE_DISABLED: GstD3D12ConverterColorBalance = 0;
pub const GST_D3D12_CONVERTER_COLOR_BALANCE_ENABLED: GstD3D12ConverterColorBalance = 1;

pub type GstD3D12ConverterMipGen = c_int;
pub const GST_D3D12_CONVERTER_MIP_GEN_DISABLED: GstD3D12ConverterMipGen = 0;
pub const GST_D3D12_CONVERTER_MIP_GEN_ENABLED: GstD3D12ConverterMipGen = 1;

pub type GstD3D12ConverterSamplerFilter = c_int;
pub const D3D12_FILTER_MIN_MAG_MIP_POINT: GstD3D12ConverterSamplerFilter = 0;
pub const D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT: GstD3D12ConverterSamplerFilter = 16;
pub const D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT: GstD3D12ConverterSamplerFilter = 20;
pub const D3D12_FILTER_MIN_MAG_MIP_LINEAR: GstD3D12ConverterSamplerFilter = 21;
pub const D3D12_FILTER_ANISOTROPIC: GstD3D12ConverterSamplerFilter = 85;

// Constants
pub const GST_CAPS_FEATURE_MEMORY_D3D12_MEMORY: &[u8] = b"memory:D3D12Memory\0";
pub const GST_D3D12_CONVERTER_OPT_COLOR_BALANCE: &[u8] = b"GstD3D12Converter.color-balance\0";
pub const GST_D3D12_CONVERTER_OPT_DEST_ALPHA_MODE: &[u8] = b"GstD3D12Converter.dest-alpha-mode\0";
pub const GST_D3D12_CONVERTER_OPT_GAMMA_MODE: &[u8] = b"GstD3D12Converter.gamma-mode\0";
pub const GST_D3D12_CONVERTER_OPT_MIP_GEN: &[u8] = b"GstD3D12Converter.mip-gen\0";
pub const GST_D3D12_CONVERTER_OPT_PRIMARIES_MODE: &[u8] = b"GstD3D12Converter.primaries-mode\0";
pub const GST_D3D12_CONVERTER_OPT_PSO_SAMPLE_DESC_COUNT: &[u8] =
    b"GstD3D12Converter.pso-sample-desc-count\0";
pub const GST_D3D12_CONVERTER_OPT_PSO_SAMPLE_DESC_QUALITY: &[u8] =
    b"GstD3D12Converter.pso-sample-desc-quality\0";
pub const GST_D3D12_CONVERTER_OPT_SAMPLER_FILTER: &[u8] = b"GstD3D12Converter.sampler-filter\0";
pub const GST_D3D12_CONVERTER_OPT_SRC_ALPHA_MODE: &[u8] = b"GstD3D12Converter.src-alpha-mode\0";
pub const GST_D3D12_DEVICE_HANDLE_CONTEXT_TYPE: &[u8] = b"gst.d3d12.device.handle\0";
pub const GST_D3D12_MEMORY_NAME: &[u8] = b"D3D12Memory\0";
pub const GST_MAP_D3D12: gst::GstMapFlags = 131072;
pub const GST_MAP_READ_D3D12: gst::GstMapFlags = 131073;
pub const GST_MAP_WRITE_D3D12: gst::GstMapFlags = 131074;

// Flags
pub type GstD3D12FormatFlags = c_uint;
pub const GST_D3D12_FORMAT_FLAG_NONE: GstD3D12FormatFlags = 0;
pub const GST_D3D12_FORMAT_FLAG_OUTPUT_UAV: GstD3D12FormatFlags = 1;

pub type GstD3D12FrameMapFlags = c_uint;
pub const GST_D3D12_FRAME_MAP_FLAG_NONE: GstD3D12FrameMapFlags = 0;
pub const GST_D3D12_FRAME_MAP_FLAG_SRV: GstD3D12FrameMapFlags = 1;
pub const GST_D3D12_FRAME_MAP_FLAG_UAV: GstD3D12FrameMapFlags = 2;
pub const GST_D3D12_FRAME_MAP_FLAG_RTV: GstD3D12FrameMapFlags = 4;

pub type GstD3D12MemoryTransfer = c_uint;
pub const GST_D3D12_MEMORY_TRANSFER_NEED_DOWNLOAD: GstD3D12MemoryTransfer = 1048576;
pub const GST_D3D12_MEMORY_TRANSFER_NEED_UPLOAD: GstD3D12MemoryTransfer = 2097152;

// Records
#[repr(C)]
#[allow(dead_code)]
pub struct GstD3D12AllocationParams {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstD3D12AllocationParams {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12AllocationParams @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12AllocatorClass {
    pub allocator_class: gst::GstAllocatorClass,
    pub set_actvie: Option<unsafe extern "C" fn(*mut GstD3D12Allocator, gboolean) -> gboolean>,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstD3D12AllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12AllocatorClass @ {self:p}"))
            .field("allocator_class", &self.allocator_class)
            .field("set_actvie", &self.set_actvie)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12AllocatorPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12AllocatorPrivate = _GstD3D12AllocatorPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12BufferPoolClass {
    pub parent_class: gst::GstBufferPoolClass,
}

impl ::std::fmt::Debug for GstD3D12BufferPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12BufferPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12BufferPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12BufferPoolPrivate = _GstD3D12BufferPoolPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct GstD3D12CmdAlloc {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstD3D12CmdAlloc {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12CmdAlloc @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12CmdAllocPoolClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12CmdAllocPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12CmdAllocPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12CmdAllocPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12CmdAllocPoolPrivate = _GstD3D12CmdAllocPoolPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12CmdQueueClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12CmdQueueClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12CmdQueueClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12CmdQueuePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12CmdQueuePrivate = _GstD3D12CmdQueuePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12ConverterClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12ConverterClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12ConverterClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12ConverterPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12ConverterPrivate = _GstD3D12ConverterPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct GstD3D12DescHeap {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstD3D12DescHeap {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12DescHeap @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12DescHeapPoolClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12DescHeapPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12DescHeapPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12DescHeapPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12DescHeapPoolPrivate = _GstD3D12DescHeapPoolPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12DeviceClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12DeviceClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12DeviceClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12DevicePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12DevicePrivate = _GstD3D12DevicePrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct GstD3D12FenceData {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstD3D12FenceData {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12FenceData @ {self:p}"))
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12FenceDataPoolClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12FenceDataPoolClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12FenceDataPoolClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12FenceDataPoolPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12FenceDataPoolPrivate = _GstD3D12FenceDataPoolPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12Format {
    pub format: gst_video::GstVideoFormat,
    pub format_flags: GstD3D12FormatFlags,
    pub dimension: c_int,
    pub dxgi_format: c_int,
    pub resource_format: [c_int; 4],
    pub uav_format: [c_int; 4],
    pub support1: c_int,
    pub support2: c_int,
    pub padding: [c_uint; 20],
}

impl ::std::fmt::Debug for GstD3D12Format {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12Format @ {self:p}"))
            .field("format", &self.format)
            .field("format_flags", &self.format_flags)
            .field("dimension", &self.dimension)
            .field("dxgi_format", &self.dxgi_format)
            .field("resource_format", &self.resource_format)
            .field("uav_format", &self.uav_format)
            .field("support1", &self.support1)
            .field("support2", &self.support2)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12FrameFence {
    pub fence: gpointer,
    pub fence_value: u64,
}

impl ::std::fmt::Debug for GstD3D12FrameFence {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12FrameFence @ {self:p}"))
            .field("fence", &self.fence)
            .field("fence_value", &self.fence_value)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12Memory {
    pub mem: gst::GstMemory,
    pub device: *mut GstD3D12Device,
    pub priv_: *mut GstD3D12MemoryPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12Memory {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12Memory @ {self:p}"))
            .field("mem", &self.mem)
            .field("device", &self.device)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12MemoryPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12MemoryPrivate = _GstD3D12MemoryPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12PoolAllocatorClass {
    pub allocator_class: GstD3D12AllocatorClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12PoolAllocatorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12PoolAllocatorClass @ {self:p}"))
            .field("allocator_class", &self.allocator_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstD3D12PoolAllocatorPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstD3D12PoolAllocatorPrivate = _GstD3D12PoolAllocatorPrivate;

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12Allocator {
    pub allocator: gst::GstAllocator,
    pub priv_: *mut GstD3D12AllocatorPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12Allocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12Allocator @ {self:p}"))
            .field("allocator", &self.allocator)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12BufferPool {
    pub parent: gst::GstBufferPool,
    pub device: *mut GstD3D12Device,
    pub priv_: *mut GstD3D12BufferPoolPrivate,
}

impl ::std::fmt::Debug for GstD3D12BufferPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12BufferPool @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12CmdAllocPool {
    pub parent: gst::GstObject,
    pub priv_: *mut GstD3D12CmdAllocPoolPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12CmdAllocPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12CmdAllocPool @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12CmdQueue {
    pub parent: gst::GstObject,
    pub priv_: *mut GstD3D12CmdQueuePrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12CmdQueue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12CmdQueue @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12Converter {
    pub parent: gst::GstObject,
    pub device: *mut GstD3D12Device,
    pub priv_: *mut GstD3D12ConverterPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12Converter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12Converter @ {self:p}"))
            .field("parent", &self.parent)
            .field("device", &self.device)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12DescHeapPool {
    pub parent: gst::GstObject,
    pub priv_: *mut GstD3D12DescHeapPoolPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12DescHeapPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12DescHeapPool @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12Device {
    pub parent: gst::GstObject,
    pub priv_: *mut GstD3D12DevicePrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12Device {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12Device @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12FenceDataPool {
    pub parent: gst::GstObject,
    pub priv_: *mut GstD3D12FenceDataPoolPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12FenceDataPool {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12FenceDataPool @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstD3D12PoolAllocator {
    pub allocator: GstD3D12Allocator,
    pub device: *mut GstD3D12Device,
    pub priv_: *mut GstD3D12PoolAllocatorPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstD3D12PoolAllocator {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstD3D12PoolAllocator @ {self:p}"))
            .field("allocator", &self.allocator)
            .field("device", &self.device)
            .finish()
    }
}

extern "C" {

    //=========================================================================
    // GstD3D12ConverterAlphaMode
    //=========================================================================
    pub fn gst_d3d12_converter_alpha_mode_get_type() -> GType;

    //=========================================================================
    // GstD3D12ConverterColorBalance
    //=========================================================================
    pub fn gst_d3d12_converter_color_balance_get_type() -> GType;

    //=========================================================================
    // GstD3D12ConverterMipGen
    //=========================================================================
    pub fn gst_d3d12_converter_mip_gen_get_type() -> GType;

    //=========================================================================
    // GstD3D12ConverterSamplerFilter
    //=========================================================================
    pub fn gst_d3d12_converter_sampler_filter_get_type() -> GType;

    //=========================================================================
    // GstD3D12AllocationParams
    //=========================================================================
    pub fn gst_d3d12_allocation_params_get_type() -> GType;
    pub fn gst_d3d12_allocation_params_new(
        device: *mut GstD3D12Device,
        info: *const gst_video::GstVideoInfo,
        flags: GstD3D12AllocationFlags,
        resource_flags: c_int,
        heap_flags: c_int,
    ) -> *mut GstD3D12AllocationParams;
    pub fn gst_d3d12_allocation_params_alignment(
        parms: *mut GstD3D12AllocationParams,
        align: *const gst_video::GstVideoAlignment,
    ) -> gboolean;
    pub fn gst_d3d12_allocation_params_copy(
        src: *mut GstD3D12AllocationParams,
    ) -> *mut GstD3D12AllocationParams;
    pub fn gst_d3d12_allocation_params_free(params: *mut GstD3D12AllocationParams);
    pub fn gst_d3d12_allocation_params_set_array_size(
        params: *mut GstD3D12AllocationParams,
        size: c_uint,
    ) -> gboolean;
    pub fn gst_d3d12_allocation_params_set_heap_flags(
        params: *mut GstD3D12AllocationParams,
        heap_flags: c_int,
    ) -> gboolean;
    pub fn gst_d3d12_allocation_params_set_mip_levels(
        params: *mut GstD3D12AllocationParams,
        mip_levels: c_uint,
    ) -> gboolean;
    pub fn gst_d3d12_allocation_params_set_resource_flags(
        params: *mut GstD3D12AllocationParams,
        resource_flags: c_int,
    ) -> gboolean;
    pub fn gst_d3d12_allocation_params_unset_resource_flags(
        params: *mut GstD3D12AllocationParams,
        resource_flags: c_int,
    ) -> gboolean;

    //=========================================================================
    // GstD3D12CmdAlloc
    //=========================================================================
    pub fn gst_d3d12_cmd_alloc_get_type() -> GType;
    pub fn gst_d3d12_cmd_alloc_get_handle(ca: *mut GstD3D12CmdAlloc) -> gpointer;
    pub fn gst_d3d12_cmd_alloc_ref(ca: *mut GstD3D12CmdAlloc) -> *mut GstD3D12CmdAlloc;
    pub fn gst_d3d12_cmd_alloc_unref(ca: *mut GstD3D12CmdAlloc);

    //=========================================================================
    // GstD3D12DescHeap
    //=========================================================================
    pub fn gst_d3d12_desc_heap_get_type() -> GType;
    pub fn gst_d3d12_desc_heap_get_handle(heap: *mut GstD3D12DescHeap) -> gpointer;
    pub fn gst_d3d12_desc_heap_ref(heap: *mut GstD3D12DescHeap) -> *mut GstD3D12DescHeap;
    pub fn gst_d3d12_desc_heap_unref(heap: *mut GstD3D12DescHeap);

    //=========================================================================
    // GstD3D12FenceData
    //=========================================================================
    pub fn gst_d3d12_fence_data_get_type() -> GType;
    pub fn gst_d3d12_fence_data_push(
        data: *mut GstD3D12FenceData,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    );
    pub fn gst_d3d12_fence_data_ref(data: *mut GstD3D12FenceData) -> *mut GstD3D12FenceData;
    pub fn gst_d3d12_fence_data_unref(data: *mut GstD3D12FenceData);

    //=========================================================================
    // GstD3D12Memory
    //=========================================================================
    pub fn gst_d3d12_memory_get_type() -> GType;
    pub fn gst_d3d12_memory_get_d3d11_texture(
        mem: *mut GstD3D12Memory,
        device11: gpointer,
    ) -> gpointer;
    pub fn gst_d3d12_memory_get_fence(
        mem: *mut GstD3D12Memory,
        fence: *mut gpointer,
        fence_value: *mut u64,
    ) -> gboolean;
    pub fn gst_d3d12_memory_get_nt_handle(
        mem: *mut GstD3D12Memory,
        handle: *mut gpointer,
    ) -> gboolean;
    pub fn gst_d3d12_memory_get_plane_count(mem: *mut GstD3D12Memory) -> c_uint;
    pub fn gst_d3d12_memory_get_plane_rectangle(
        mem: *mut GstD3D12Memory,
        plane: c_uint,
        rect: gpointer,
    ) -> gboolean;
    pub fn gst_d3d12_memory_get_render_target_view_heap(mem: *mut GstD3D12Memory) -> gpointer;
    pub fn gst_d3d12_memory_get_resource_handle(mem: *mut GstD3D12Memory) -> gpointer;
    pub fn gst_d3d12_memory_get_shader_resource_view_heap(mem: *mut GstD3D12Memory) -> gpointer;
    pub fn gst_d3d12_memory_get_subresource_index(
        mem: *mut GstD3D12Memory,
        plane: c_uint,
        index: *mut c_uint,
    ) -> gboolean;
    pub fn gst_d3d12_memory_get_token_data(mem: *mut GstD3D12Memory, token: i64) -> gpointer;
    pub fn gst_d3d12_memory_get_unordered_access_view_heap(mem: *mut GstD3D12Memory) -> gpointer;
    pub fn gst_d3d12_memory_set_fence(
        mem: *mut GstD3D12Memory,
        fence: gpointer,
        fence_value: u64,
        wait: gboolean,
    );
    pub fn gst_d3d12_memory_set_token_data(
        mem: *mut GstD3D12Memory,
        token: i64,
        data: gpointer,
        notify: glib::GDestroyNotify,
    );
    pub fn gst_d3d12_memory_sync(mem: *mut GstD3D12Memory) -> gboolean;
    pub fn gst_d3d12_memory_init_once();

    //=========================================================================
    // GstD3D12Allocator
    //=========================================================================
    pub fn gst_d3d12_allocator_get_type() -> GType;
    pub fn gst_d3d12_allocator_alloc(
        allocator: *mut GstD3D12Allocator,
        device: *mut GstD3D12Device,
        heap_props: gconstpointer,
        heap_flags: c_int,
        desc: gconstpointer,
        initial_state: c_int,
        optimized_clear_value: gconstpointer,
    ) -> *mut gst::GstMemory;
    pub fn gst_d3d12_allocator_alloc_wrapped(
        allocator: *mut GstD3D12Allocator,
        device: *mut GstD3D12Device,
        resource: gpointer,
        array_slice: c_uint,
        user_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> *mut gst::GstMemory;
    pub fn gst_d3d12_allocator_set_active(
        allocator: *mut GstD3D12Allocator,
        active: gboolean,
    ) -> gboolean;

    //=========================================================================
    // GstD3D12BufferPool
    //=========================================================================
    pub fn gst_d3d12_buffer_pool_get_type() -> GType;
    pub fn gst_d3d12_buffer_pool_new(device: *mut GstD3D12Device) -> *mut gst::GstBufferPool;

    //=========================================================================
    // GstD3D12CmdAllocPool
    //=========================================================================
    pub fn gst_d3d12_cmd_alloc_pool_get_type() -> GType;
    pub fn gst_d3d12_cmd_alloc_pool_new(
        device: gpointer,
        type_: c_int,
    ) -> *mut GstD3D12CmdAllocPool;
    pub fn gst_d3d12_cmd_alloc_pool_acquire(
        pool: *mut GstD3D12CmdAllocPool,
        ca: *mut *mut GstD3D12CmdAlloc,
    ) -> gboolean;

    //=========================================================================
    // GstD3D12CmdQueue
    //=========================================================================
    pub fn gst_d3d12_cmd_queue_get_type() -> GType;
    pub fn gst_d3d12_cmd_queue_new(
        device: gpointer,
        desc: gconstpointer,
        fence_flags: c_int,
        queue_size: c_uint,
    ) -> *mut GstD3D12CmdQueue;
    pub fn gst_d3d12_cmd_queue_drain(queue: *mut GstD3D12CmdQueue) -> c_int;
    pub fn gst_d3d12_cmd_queue_execute_command_lists(
        queue: *mut GstD3D12CmdQueue,
        num_command_lists: c_uint,
        command_lists: *mut gpointer,
        fence_value: *mut u64,
    ) -> c_int;
    pub fn gst_d3d12_cmd_queue_execute_command_lists_full(
        queue: *mut GstD3D12CmdQueue,
        num_fences_to_wait: c_uint,
        fences_to_wait: *mut gpointer,
        fence_values_to_wait: *const u64,
        num_command_lists: c_uint,
        command_lists: *mut gpointer,
        fence_value: *mut u64,
    ) -> c_int;
    pub fn gst_d3d12_cmd_queue_execute_wait(
        queue: *mut GstD3D12CmdQueue,
        fence: gpointer,
        fence_value: u64,
    ) -> c_int;
    pub fn gst_d3d12_cmd_queue_fence_wait(queue: *mut GstD3D12CmdQueue, fence_value: u64) -> c_int;
    pub fn gst_d3d12_cmd_queue_get_completed_value(queue: *mut GstD3D12CmdQueue) -> u64;
    pub fn gst_d3d12_cmd_queue_get_fence_handle(queue: *mut GstD3D12CmdQueue) -> gpointer;
    pub fn gst_d3d12_cmd_queue_get_handle(queue: *mut GstD3D12CmdQueue) -> gpointer;
    pub fn gst_d3d12_cmd_queue_set_notify(
        queue: *mut GstD3D12CmdQueue,
        fence_value: u64,
        fence_data: gpointer,
        notify: glib::GDestroyNotify,
    );

    //=========================================================================
    // GstD3D12Converter
    //=========================================================================
    pub fn gst_d3d12_converter_get_type() -> GType;
    pub fn gst_d3d12_converter_new(
        device: *mut GstD3D12Device,
        queue: *mut GstD3D12CmdQueue,
        in_info: *const gst_video::GstVideoInfo,
        out_info: *const gst_video::GstVideoInfo,
        blend_desc: gconstpointer,
        blend_factor: *const c_float,
        config: *mut gst::GstStructure,
    ) -> *mut GstD3D12Converter;
    pub fn gst_d3d12_converter_convert_buffer(
        converter: *mut GstD3D12Converter,
        in_buf: *mut gst::GstBuffer,
        out_buf: *mut gst::GstBuffer,
        fence_data: *mut GstD3D12FenceData,
        command_list: gpointer,
        execute_gpu_wait: gboolean,
    ) -> gboolean;
    pub fn gst_d3d12_converter_update_blend_state(
        converter: *mut GstD3D12Converter,
        blend_desc: gconstpointer,
        blend_factor: *const c_float,
    ) -> gboolean;

    //=========================================================================
    // GstD3D12DescHeapPool
    //=========================================================================
    pub fn gst_d3d12_desc_heap_pool_get_type() -> GType;
    pub fn gst_d3d12_desc_heap_pool_new(
        device: gpointer,
        desc: gconstpointer,
    ) -> *mut GstD3D12DescHeapPool;
    pub fn gst_d3d12_desc_heap_pool_acquire(
        pool: *mut GstD3D12DescHeapPool,
        heap: *mut *mut GstD3D12DescHeap,
    ) -> gboolean;

    //=========================================================================
    // GstD3D12Device
    //=========================================================================
    pub fn gst_d3d12_device_get_type() -> GType;
    pub fn gst_d3d12_device_new(adapter_index: c_uint) -> *mut GstD3D12Device;
    pub fn gst_d3d12_device_new_for_adapter_luid(adapter_luid: i64) -> *mut GstD3D12Device;
    pub fn gst_d3d12_device_execute_command_lists(
        device: *mut GstD3D12Device,
        queue_type: c_int,
        num_command_lists: c_uint,
        command_lists: *mut gpointer,
        fence_value: *mut u64,
    ) -> c_int;
    pub fn gst_d3d12_device_fence_wait(
        device: *mut GstD3D12Device,
        queue_type: c_int,
        fence_value: u64,
    ) -> c_int;
    pub fn gst_d3d12_device_get_adapter_handle(device: *mut GstD3D12Device) -> gpointer;
    pub fn gst_d3d12_device_get_cmd_queue(
        device: *mut GstD3D12Device,
        queue_type: c_int,
    ) -> *mut GstD3D12CmdQueue;
    pub fn gst_d3d12_device_get_completed_value(
        device: *mut GstD3D12Device,
        queue_type: c_int,
    ) -> u64;
    pub fn gst_d3d12_device_get_device_handle(device: *mut GstD3D12Device) -> gpointer;
    pub fn gst_d3d12_device_get_factory_handle(device: *mut GstD3D12Device) -> gpointer;
    pub fn gst_d3d12_device_get_fence_handle(
        device: *mut GstD3D12Device,
        queue_type: c_int,
    ) -> gpointer;
    pub fn gst_d3d12_device_get_format(
        device: *mut GstD3D12Device,
        format: gst_video::GstVideoFormat,
        device_format: *mut GstD3D12Format,
    ) -> gboolean;
    pub fn gst_d3d12_device_is_equal(
        device1: *mut GstD3D12Device,
        device2: *mut GstD3D12Device,
    ) -> gboolean;
    pub fn gst_d3d12_device_set_fence_notify(
        device: *mut GstD3D12Device,
        queue_type: c_int,
        fence_value: u64,
        fence_data: gpointer,
        notify: glib::GDestroyNotify,
    ) -> gboolean;

    //=========================================================================
    // GstD3D12FenceDataPool
    //=========================================================================
    pub fn gst_d3d12_fence_data_pool_get_type() -> GType;
    pub fn gst_d3d12_fence_data_pool_new() -> *mut GstD3D12FenceDataPool;
    pub fn gst_d3d12_fence_data_pool_acquire(
        pool: *mut GstD3D12FenceDataPool,
        data: *mut *mut GstD3D12FenceData,
    ) -> gboolean;

    //=========================================================================
    // GstD3D12PoolAllocator
    //=========================================================================
    pub fn gst_d3d12_pool_allocator_get_type() -> GType;
    pub fn gst_d3d12_pool_allocator_new(
        device: *mut GstD3D12Device,
        heap_props: gconstpointer,
        heap_flags: c_int,
        desc: gconstpointer,
        initial_state: c_int,
        optimized_clear_value: gconstpointer,
    ) -> *mut GstD3D12PoolAllocator;
    pub fn gst_d3d12_pool_allocator_acquire_memory(
        allocator: *mut GstD3D12PoolAllocator,
        memory: *mut *mut gst::GstMemory,
    ) -> gst::GstFlowReturn;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_buffer_pool_config_get_d3d12_allocation_params(
        config: *mut gst::GstStructure,
    ) -> *mut GstD3D12AllocationParams;
    pub fn gst_buffer_pool_config_set_d3d12_allocation_params(
        config: *mut gst::GstStructure,
        params: *mut GstD3D12AllocationParams,
    );
    pub fn gst_clear_d3d12_cmd_alloc(ca: *mut *mut GstD3D12CmdAlloc);
    pub fn gst_clear_d3d12_desc_heap(heap: *mut *mut GstD3D12DescHeap);
    pub fn gst_clear_d3d12_fence_data(data: *mut *mut GstD3D12FenceData);
    pub fn gst_d3d12_buffer_copy_into(
        dest: *mut gst::GstBuffer,
        src: *mut gst::GstBuffer,
        info: *const gst_video::GstVideoInfo,
    ) -> gboolean;
    pub fn gst_d3d12_buffer_set_fence(
        buffer: *mut gst::GstBuffer,
        fence: gpointer,
        fence_value: u64,
        wait: gboolean,
    );
    pub fn gst_d3d12_context_new(device: *mut GstD3D12Device) -> *mut gst::GstContext;
    pub fn gst_d3d12_create_user_token() -> i64;
    pub fn gst_d3d12_dxgi_format_to_gst(format: c_int) -> gst_video::GstVideoFormat;
    pub fn gst_d3d12_ensure_element_data(
        element: *mut gst::GstElement,
        adapter_index: c_int,
        device: *mut *mut GstD3D12Device,
    ) -> gboolean;
    pub fn gst_d3d12_ensure_element_data_for_adapter_luid(
        element: *mut gst::GstElement,
        adapter_luid: i64,
        device: *mut *mut GstD3D12Device,
    ) -> gboolean;
    pub fn gst_d3d12_flush_all_devices();
    pub fn gst_d3d12_get_copyable_footprints(
        device: *mut GstD3D12Device,
        info: *const gst_video::GstVideoInfo,
        layout: gpointer,
        size: *mut u64,
    ) -> gboolean;
    pub fn gst_d3d12_handle_context_query(
        element: *mut gst::GstElement,
        query: *mut gst::GstQuery,
        device: *mut GstD3D12Device,
    ) -> gboolean;
    pub fn gst_d3d12_handle_set_context(
        element: *mut gst::GstElement,
        context: *mut gst::GstContext,
        adapter_index: c_int,
        device: *mut *mut GstD3D12Device,
    ) -> gboolean;
    pub fn gst_d3d12_handle_set_context_for_adapter_luid(
        element: *mut gst::GstElement,
        context: *mut gst::GstContext,
        adapter_luid: i64,
        device: *mut *mut GstD3D12Device,
    ) -> gboolean;
    pub fn gst_d3d12_luid_to_int64(luid: gconstpointer) -> i64;
    pub fn gst_is_d3d12_memory(mem: *mut gst::GstMemory) -> gboolean;

}
