// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::ffi;
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstD3D12Device")]
    pub struct D3D12Device(Object<ffi::GstD3D12Device, ffi::GstD3D12DeviceClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_d3d12_device_get_type(),
    }
}

impl D3D12Device {
    pub const NONE: Option<&'static D3D12Device> = None;

    #[doc(alias = "gst_d3d12_device_new")]
    pub fn new(adapter_index: u32) -> Option<D3D12Device> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_d3d12_device_new(adapter_index)) }
    }

    #[doc(alias = "gst_d3d12_device_new_for_adapter_luid")]
    #[doc(alias = "new_for_adapter_luid")]
    pub fn for_adapter_luid(adapter_luid: i64) -> Option<D3D12Device> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_d3d12_device_new_for_adapter_luid(adapter_luid)) }
    }
}

unsafe impl Send for D3D12Device {}
unsafe impl Sync for D3D12Device {}

pub trait D3D12DeviceExt: IsA<D3D12Device> + 'static {
    #[doc(alias = "gst_d3d12_device_is_equal")]
    fn is_equal(&self, device2: Option<&impl IsA<D3D12Device>>) -> bool {
        unsafe {
            from_glib(ffi::gst_d3d12_device_is_equal(
                self.as_ref().to_glib_none().0,
                device2.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adapter-index")]
    fn adapter_index(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "adapter-index")
    }

    #[doc(alias = "adapter-luid")]
    fn adapter_luid(&self) -> i64 {
        ObjectExt::property(self.as_ref(), "adapter-luid")
    }

    fn description(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "description")
    }

    #[doc(alias = "device-id")]
    fn device_id(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "device-id")
    }

    #[doc(alias = "device-removed-reason")]
    fn device_removed_reason(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "device-removed-reason")
    }

    #[doc(alias = "vendor-id")]
    fn vendor_id(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "vendor-id")
    }

    #[doc(alias = "adapter-index")]
    fn connect_adapter_index_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_adapter_index_trampoline<
            P: IsA<D3D12Device>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstD3D12Device,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(D3D12Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::adapter-index".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_adapter_index_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "adapter-luid")]
    fn connect_adapter_luid_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_adapter_luid_trampoline<
            P: IsA<D3D12Device>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstD3D12Device,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(D3D12Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::adapter-luid".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_adapter_luid_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "description")]
    fn connect_description_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_description_trampoline<
            P: IsA<D3D12Device>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstD3D12Device,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(D3D12Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::description".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_description_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "device-id")]
    fn connect_device_id_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_device_id_trampoline<
            P: IsA<D3D12Device>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstD3D12Device,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(D3D12Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::device-id".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_device_id_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "device-removed-reason")]
    fn connect_device_removed_reason_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_device_removed_reason_trampoline<
            P: IsA<D3D12Device>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstD3D12Device,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(D3D12Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::device-removed-reason".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_device_removed_reason_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vendor-id")]
    fn connect_vendor_id_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_vendor_id_trampoline<
            P: IsA<D3D12Device>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstD3D12Device,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(D3D12Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::vendor-id".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_vendor_id_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<D3D12Device>> D3D12DeviceExt for O {}
