// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: querier/v1/querier.proto

package querierv1connect

import (
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	v12 "github.com/grafana/pyroscope/api/gen/proto/go/google/v1"
	v1 "github.com/grafana/pyroscope/api/gen/proto/go/querier/v1"
	v11 "github.com/grafana/pyroscope/api/gen/proto/go/types/v1"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// QuerierServiceName is the fully-qualified name of the QuerierService service.
	QuerierServiceName = "querier.v1.QuerierService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// QuerierServiceProfileTypesProcedure is the fully-qualified name of the QuerierService's
	// ProfileTypes RPC.
	QuerierServiceProfileTypesProcedure = "/querier.v1.QuerierService/ProfileTypes"
	// QuerierServiceLabelValuesProcedure is the fully-qualified name of the QuerierService's
	// LabelValues RPC.
	QuerierServiceLabelValuesProcedure = "/querier.v1.QuerierService/LabelValues"
	// QuerierServiceLabelNamesProcedure is the fully-qualified name of the QuerierService's LabelNames
	// RPC.
	QuerierServiceLabelNamesProcedure = "/querier.v1.QuerierService/LabelNames"
	// QuerierServiceSeriesProcedure is the fully-qualified name of the QuerierService's Series RPC.
	QuerierServiceSeriesProcedure = "/querier.v1.QuerierService/Series"
	// QuerierServiceSelectMergeStacktracesProcedure is the fully-qualified name of the QuerierService's
	// SelectMergeStacktraces RPC.
	QuerierServiceSelectMergeStacktracesProcedure = "/querier.v1.QuerierService/SelectMergeStacktraces"
	// QuerierServiceSelectMergeSpanProfileProcedure is the fully-qualified name of the QuerierService's
	// SelectMergeSpanProfile RPC.
	QuerierServiceSelectMergeSpanProfileProcedure = "/querier.v1.QuerierService/SelectMergeSpanProfile"
	// QuerierServiceSelectMergeProfileProcedure is the fully-qualified name of the QuerierService's
	// SelectMergeProfile RPC.
	QuerierServiceSelectMergeProfileProcedure = "/querier.v1.QuerierService/SelectMergeProfile"
	// QuerierServiceSelectSeriesProcedure is the fully-qualified name of the QuerierService's
	// SelectSeries RPC.
	QuerierServiceSelectSeriesProcedure = "/querier.v1.QuerierService/SelectSeries"
	// QuerierServiceDiffProcedure is the fully-qualified name of the QuerierService's Diff RPC.
	QuerierServiceDiffProcedure = "/querier.v1.QuerierService/Diff"
	// QuerierServiceGetProfileStatsProcedure is the fully-qualified name of the QuerierService's
	// GetProfileStats RPC.
	QuerierServiceGetProfileStatsProcedure = "/querier.v1.QuerierService/GetProfileStats"
	// QuerierServiceAnalyzeQueryProcedure is the fully-qualified name of the QuerierService's
	// AnalyzeQuery RPC.
	QuerierServiceAnalyzeQueryProcedure = "/querier.v1.QuerierService/AnalyzeQuery"
)

// QuerierServiceClient is a client for the querier.v1.QuerierService service.
type QuerierServiceClient interface {
	// ProfileType returns a list of the existing profile types.
	ProfileTypes(context.Context, *connect.Request[v1.ProfileTypesRequest]) (*connect.Response[v1.ProfileTypesResponse], error)
	// LabelValues returns the existing label values for the provided label names.
	LabelValues(context.Context, *connect.Request[v11.LabelValuesRequest]) (*connect.Response[v11.LabelValuesResponse], error)
	// LabelNames returns a list of the existing label names.
	LabelNames(context.Context, *connect.Request[v11.LabelNamesRequest]) (*connect.Response[v11.LabelNamesResponse], error)
	// Series returns profiles series matching the request. A series is a unique label set.
	Series(context.Context, *connect.Request[v1.SeriesRequest]) (*connect.Response[v1.SeriesResponse], error)
	// SelectMergeStacktraces returns matching profiles aggregated in a flamegraph format. It will combine samples from within the same callstack, with each element being grouped by its function name.
	SelectMergeStacktraces(context.Context, *connect.Request[v1.SelectMergeStacktracesRequest]) (*connect.Response[v1.SelectMergeStacktracesResponse], error)
	// SelectMergeSpanProfile returns matching profiles aggregated in a flamegraph format. It will combine samples from within the same callstack, with each element being grouped by its function name.
	SelectMergeSpanProfile(context.Context, *connect.Request[v1.SelectMergeSpanProfileRequest]) (*connect.Response[v1.SelectMergeSpanProfileResponse], error)
	// SelectMergeProfile returns matching profiles aggregated in pprof format. It will contain all information stored (so including filenames and line number, if ingested).
	SelectMergeProfile(context.Context, *connect.Request[v1.SelectMergeProfileRequest]) (*connect.Response[v12.Profile], error)
	// SelectSeries returns a time series for the total sum of the requested profiles.
	SelectSeries(context.Context, *connect.Request[v1.SelectSeriesRequest]) (*connect.Response[v1.SelectSeriesResponse], error)
	// Diff returns a diff of two profiles
	Diff(context.Context, *connect.Request[v1.DiffRequest]) (*connect.Response[v1.DiffResponse], error)
	// GetProfileStats returns profile stats for the current tenant.
	GetProfileStats(context.Context, *connect.Request[v11.GetProfileStatsRequest]) (*connect.Response[v11.GetProfileStatsResponse], error)
	AnalyzeQuery(context.Context, *connect.Request[v1.AnalyzeQueryRequest]) (*connect.Response[v1.AnalyzeQueryResponse], error)
}

// NewQuerierServiceClient constructs a client for the querier.v1.QuerierService service. By
// default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses,
// and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewQuerierServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) QuerierServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	querierServiceMethods := v1.File_querier_v1_querier_proto.Services().ByName("QuerierService").Methods()
	return &querierServiceClient{
		profileTypes: connect.NewClient[v1.ProfileTypesRequest, v1.ProfileTypesResponse](
			httpClient,
			baseURL+QuerierServiceProfileTypesProcedure,
			connect.WithSchema(querierServiceMethods.ByName("ProfileTypes")),
			connect.WithClientOptions(opts...),
		),
		labelValues: connect.NewClient[v11.LabelValuesRequest, v11.LabelValuesResponse](
			httpClient,
			baseURL+QuerierServiceLabelValuesProcedure,
			connect.WithSchema(querierServiceMethods.ByName("LabelValues")),
			connect.WithClientOptions(opts...),
		),
		labelNames: connect.NewClient[v11.LabelNamesRequest, v11.LabelNamesResponse](
			httpClient,
			baseURL+QuerierServiceLabelNamesProcedure,
			connect.WithSchema(querierServiceMethods.ByName("LabelNames")),
			connect.WithClientOptions(opts...),
		),
		series: connect.NewClient[v1.SeriesRequest, v1.SeriesResponse](
			httpClient,
			baseURL+QuerierServiceSeriesProcedure,
			connect.WithSchema(querierServiceMethods.ByName("Series")),
			connect.WithClientOptions(opts...),
		),
		selectMergeStacktraces: connect.NewClient[v1.SelectMergeStacktracesRequest, v1.SelectMergeStacktracesResponse](
			httpClient,
			baseURL+QuerierServiceSelectMergeStacktracesProcedure,
			connect.WithSchema(querierServiceMethods.ByName("SelectMergeStacktraces")),
			connect.WithClientOptions(opts...),
		),
		selectMergeSpanProfile: connect.NewClient[v1.SelectMergeSpanProfileRequest, v1.SelectMergeSpanProfileResponse](
			httpClient,
			baseURL+QuerierServiceSelectMergeSpanProfileProcedure,
			connect.WithSchema(querierServiceMethods.ByName("SelectMergeSpanProfile")),
			connect.WithClientOptions(opts...),
		),
		selectMergeProfile: connect.NewClient[v1.SelectMergeProfileRequest, v12.Profile](
			httpClient,
			baseURL+QuerierServiceSelectMergeProfileProcedure,
			connect.WithSchema(querierServiceMethods.ByName("SelectMergeProfile")),
			connect.WithClientOptions(opts...),
		),
		selectSeries: connect.NewClient[v1.SelectSeriesRequest, v1.SelectSeriesResponse](
			httpClient,
			baseURL+QuerierServiceSelectSeriesProcedure,
			connect.WithSchema(querierServiceMethods.ByName("SelectSeries")),
			connect.WithClientOptions(opts...),
		),
		diff: connect.NewClient[v1.DiffRequest, v1.DiffResponse](
			httpClient,
			baseURL+QuerierServiceDiffProcedure,
			connect.WithSchema(querierServiceMethods.ByName("Diff")),
			connect.WithClientOptions(opts...),
		),
		getProfileStats: connect.NewClient[v11.GetProfileStatsRequest, v11.GetProfileStatsResponse](
			httpClient,
			baseURL+QuerierServiceGetProfileStatsProcedure,
			connect.WithSchema(querierServiceMethods.ByName("GetProfileStats")),
			connect.WithClientOptions(opts...),
		),
		analyzeQuery: connect.NewClient[v1.AnalyzeQueryRequest, v1.AnalyzeQueryResponse](
			httpClient,
			baseURL+QuerierServiceAnalyzeQueryProcedure,
			connect.WithSchema(querierServiceMethods.ByName("AnalyzeQuery")),
			connect.WithClientOptions(opts...),
		),
	}
}

// querierServiceClient implements QuerierServiceClient.
type querierServiceClient struct {
	profileTypes           *connect.Client[v1.ProfileTypesRequest, v1.ProfileTypesResponse]
	labelValues            *connect.Client[v11.LabelValuesRequest, v11.LabelValuesResponse]
	labelNames             *connect.Client[v11.LabelNamesRequest, v11.LabelNamesResponse]
	series                 *connect.Client[v1.SeriesRequest, v1.SeriesResponse]
	selectMergeStacktraces *connect.Client[v1.SelectMergeStacktracesRequest, v1.SelectMergeStacktracesResponse]
	selectMergeSpanProfile *connect.Client[v1.SelectMergeSpanProfileRequest, v1.SelectMergeSpanProfileResponse]
	selectMergeProfile     *connect.Client[v1.SelectMergeProfileRequest, v12.Profile]
	selectSeries           *connect.Client[v1.SelectSeriesRequest, v1.SelectSeriesResponse]
	diff                   *connect.Client[v1.DiffRequest, v1.DiffResponse]
	getProfileStats        *connect.Client[v11.GetProfileStatsRequest, v11.GetProfileStatsResponse]
	analyzeQuery           *connect.Client[v1.AnalyzeQueryRequest, v1.AnalyzeQueryResponse]
}

// ProfileTypes calls querier.v1.QuerierService.ProfileTypes.
func (c *querierServiceClient) ProfileTypes(ctx context.Context, req *connect.Request[v1.ProfileTypesRequest]) (*connect.Response[v1.ProfileTypesResponse], error) {
	return c.profileTypes.CallUnary(ctx, req)
}

// LabelValues calls querier.v1.QuerierService.LabelValues.
func (c *querierServiceClient) LabelValues(ctx context.Context, req *connect.Request[v11.LabelValuesRequest]) (*connect.Response[v11.LabelValuesResponse], error) {
	return c.labelValues.CallUnary(ctx, req)
}

// LabelNames calls querier.v1.QuerierService.LabelNames.
func (c *querierServiceClient) LabelNames(ctx context.Context, req *connect.Request[v11.LabelNamesRequest]) (*connect.Response[v11.LabelNamesResponse], error) {
	return c.labelNames.CallUnary(ctx, req)
}

// Series calls querier.v1.QuerierService.Series.
func (c *querierServiceClient) Series(ctx context.Context, req *connect.Request[v1.SeriesRequest]) (*connect.Response[v1.SeriesResponse], error) {
	return c.series.CallUnary(ctx, req)
}

// SelectMergeStacktraces calls querier.v1.QuerierService.SelectMergeStacktraces.
func (c *querierServiceClient) SelectMergeStacktraces(ctx context.Context, req *connect.Request[v1.SelectMergeStacktracesRequest]) (*connect.Response[v1.SelectMergeStacktracesResponse], error) {
	return c.selectMergeStacktraces.CallUnary(ctx, req)
}

// SelectMergeSpanProfile calls querier.v1.QuerierService.SelectMergeSpanProfile.
func (c *querierServiceClient) SelectMergeSpanProfile(ctx context.Context, req *connect.Request[v1.SelectMergeSpanProfileRequest]) (*connect.Response[v1.SelectMergeSpanProfileResponse], error) {
	return c.selectMergeSpanProfile.CallUnary(ctx, req)
}

// SelectMergeProfile calls querier.v1.QuerierService.SelectMergeProfile.
func (c *querierServiceClient) SelectMergeProfile(ctx context.Context, req *connect.Request[v1.SelectMergeProfileRequest]) (*connect.Response[v12.Profile], error) {
	return c.selectMergeProfile.CallUnary(ctx, req)
}

// SelectSeries calls querier.v1.QuerierService.SelectSeries.
func (c *querierServiceClient) SelectSeries(ctx context.Context, req *connect.Request[v1.SelectSeriesRequest]) (*connect.Response[v1.SelectSeriesResponse], error) {
	return c.selectSeries.CallUnary(ctx, req)
}

// Diff calls querier.v1.QuerierService.Diff.
func (c *querierServiceClient) Diff(ctx context.Context, req *connect.Request[v1.DiffRequest]) (*connect.Response[v1.DiffResponse], error) {
	return c.diff.CallUnary(ctx, req)
}

// GetProfileStats calls querier.v1.QuerierService.GetProfileStats.
func (c *querierServiceClient) GetProfileStats(ctx context.Context, req *connect.Request[v11.GetProfileStatsRequest]) (*connect.Response[v11.GetProfileStatsResponse], error) {
	return c.getProfileStats.CallUnary(ctx, req)
}

// AnalyzeQuery calls querier.v1.QuerierService.AnalyzeQuery.
func (c *querierServiceClient) AnalyzeQuery(ctx context.Context, req *connect.Request[v1.AnalyzeQueryRequest]) (*connect.Response[v1.AnalyzeQueryResponse], error) {
	return c.analyzeQuery.CallUnary(ctx, req)
}

// QuerierServiceHandler is an implementation of the querier.v1.QuerierService service.
type QuerierServiceHandler interface {
	// ProfileType returns a list of the existing profile types.
	ProfileTypes(context.Context, *connect.Request[v1.ProfileTypesRequest]) (*connect.Response[v1.ProfileTypesResponse], error)
	// LabelValues returns the existing label values for the provided label names.
	LabelValues(context.Context, *connect.Request[v11.LabelValuesRequest]) (*connect.Response[v11.LabelValuesResponse], error)
	// LabelNames returns a list of the existing label names.
	LabelNames(context.Context, *connect.Request[v11.LabelNamesRequest]) (*connect.Response[v11.LabelNamesResponse], error)
	// Series returns profiles series matching the request. A series is a unique label set.
	Series(context.Context, *connect.Request[v1.SeriesRequest]) (*connect.Response[v1.SeriesResponse], error)
	// SelectMergeStacktraces returns matching profiles aggregated in a flamegraph format. It will combine samples from within the same callstack, with each element being grouped by its function name.
	SelectMergeStacktraces(context.Context, *connect.Request[v1.SelectMergeStacktracesRequest]) (*connect.Response[v1.SelectMergeStacktracesResponse], error)
	// SelectMergeSpanProfile returns matching profiles aggregated in a flamegraph format. It will combine samples from within the same callstack, with each element being grouped by its function name.
	SelectMergeSpanProfile(context.Context, *connect.Request[v1.SelectMergeSpanProfileRequest]) (*connect.Response[v1.SelectMergeSpanProfileResponse], error)
	// SelectMergeProfile returns matching profiles aggregated in pprof format. It will contain all information stored (so including filenames and line number, if ingested).
	SelectMergeProfile(context.Context, *connect.Request[v1.SelectMergeProfileRequest]) (*connect.Response[v12.Profile], error)
	// SelectSeries returns a time series for the total sum of the requested profiles.
	SelectSeries(context.Context, *connect.Request[v1.SelectSeriesRequest]) (*connect.Response[v1.SelectSeriesResponse], error)
	// Diff returns a diff of two profiles
	Diff(context.Context, *connect.Request[v1.DiffRequest]) (*connect.Response[v1.DiffResponse], error)
	// GetProfileStats returns profile stats for the current tenant.
	GetProfileStats(context.Context, *connect.Request[v11.GetProfileStatsRequest]) (*connect.Response[v11.GetProfileStatsResponse], error)
	AnalyzeQuery(context.Context, *connect.Request[v1.AnalyzeQueryRequest]) (*connect.Response[v1.AnalyzeQueryResponse], error)
}

// NewQuerierServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewQuerierServiceHandler(svc QuerierServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	querierServiceMethods := v1.File_querier_v1_querier_proto.Services().ByName("QuerierService").Methods()
	querierServiceProfileTypesHandler := connect.NewUnaryHandler(
		QuerierServiceProfileTypesProcedure,
		svc.ProfileTypes,
		connect.WithSchema(querierServiceMethods.ByName("ProfileTypes")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceLabelValuesHandler := connect.NewUnaryHandler(
		QuerierServiceLabelValuesProcedure,
		svc.LabelValues,
		connect.WithSchema(querierServiceMethods.ByName("LabelValues")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceLabelNamesHandler := connect.NewUnaryHandler(
		QuerierServiceLabelNamesProcedure,
		svc.LabelNames,
		connect.WithSchema(querierServiceMethods.ByName("LabelNames")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceSeriesHandler := connect.NewUnaryHandler(
		QuerierServiceSeriesProcedure,
		svc.Series,
		connect.WithSchema(querierServiceMethods.ByName("Series")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceSelectMergeStacktracesHandler := connect.NewUnaryHandler(
		QuerierServiceSelectMergeStacktracesProcedure,
		svc.SelectMergeStacktraces,
		connect.WithSchema(querierServiceMethods.ByName("SelectMergeStacktraces")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceSelectMergeSpanProfileHandler := connect.NewUnaryHandler(
		QuerierServiceSelectMergeSpanProfileProcedure,
		svc.SelectMergeSpanProfile,
		connect.WithSchema(querierServiceMethods.ByName("SelectMergeSpanProfile")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceSelectMergeProfileHandler := connect.NewUnaryHandler(
		QuerierServiceSelectMergeProfileProcedure,
		svc.SelectMergeProfile,
		connect.WithSchema(querierServiceMethods.ByName("SelectMergeProfile")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceSelectSeriesHandler := connect.NewUnaryHandler(
		QuerierServiceSelectSeriesProcedure,
		svc.SelectSeries,
		connect.WithSchema(querierServiceMethods.ByName("SelectSeries")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceDiffHandler := connect.NewUnaryHandler(
		QuerierServiceDiffProcedure,
		svc.Diff,
		connect.WithSchema(querierServiceMethods.ByName("Diff")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceGetProfileStatsHandler := connect.NewUnaryHandler(
		QuerierServiceGetProfileStatsProcedure,
		svc.GetProfileStats,
		connect.WithSchema(querierServiceMethods.ByName("GetProfileStats")),
		connect.WithHandlerOptions(opts...),
	)
	querierServiceAnalyzeQueryHandler := connect.NewUnaryHandler(
		QuerierServiceAnalyzeQueryProcedure,
		svc.AnalyzeQuery,
		connect.WithSchema(querierServiceMethods.ByName("AnalyzeQuery")),
		connect.WithHandlerOptions(opts...),
	)
	return "/querier.v1.QuerierService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case QuerierServiceProfileTypesProcedure:
			querierServiceProfileTypesHandler.ServeHTTP(w, r)
		case QuerierServiceLabelValuesProcedure:
			querierServiceLabelValuesHandler.ServeHTTP(w, r)
		case QuerierServiceLabelNamesProcedure:
			querierServiceLabelNamesHandler.ServeHTTP(w, r)
		case QuerierServiceSeriesProcedure:
			querierServiceSeriesHandler.ServeHTTP(w, r)
		case QuerierServiceSelectMergeStacktracesProcedure:
			querierServiceSelectMergeStacktracesHandler.ServeHTTP(w, r)
		case QuerierServiceSelectMergeSpanProfileProcedure:
			querierServiceSelectMergeSpanProfileHandler.ServeHTTP(w, r)
		case QuerierServiceSelectMergeProfileProcedure:
			querierServiceSelectMergeProfileHandler.ServeHTTP(w, r)
		case QuerierServiceSelectSeriesProcedure:
			querierServiceSelectSeriesHandler.ServeHTTP(w, r)
		case QuerierServiceDiffProcedure:
			querierServiceDiffHandler.ServeHTTP(w, r)
		case QuerierServiceGetProfileStatsProcedure:
			querierServiceGetProfileStatsHandler.ServeHTTP(w, r)
		case QuerierServiceAnalyzeQueryProcedure:
			querierServiceAnalyzeQueryHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedQuerierServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedQuerierServiceHandler struct{}

func (UnimplementedQuerierServiceHandler) ProfileTypes(context.Context, *connect.Request[v1.ProfileTypesRequest]) (*connect.Response[v1.ProfileTypesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.ProfileTypes is not implemented"))
}

func (UnimplementedQuerierServiceHandler) LabelValues(context.Context, *connect.Request[v11.LabelValuesRequest]) (*connect.Response[v11.LabelValuesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.LabelValues is not implemented"))
}

func (UnimplementedQuerierServiceHandler) LabelNames(context.Context, *connect.Request[v11.LabelNamesRequest]) (*connect.Response[v11.LabelNamesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.LabelNames is not implemented"))
}

func (UnimplementedQuerierServiceHandler) Series(context.Context, *connect.Request[v1.SeriesRequest]) (*connect.Response[v1.SeriesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.Series is not implemented"))
}

func (UnimplementedQuerierServiceHandler) SelectMergeStacktraces(context.Context, *connect.Request[v1.SelectMergeStacktracesRequest]) (*connect.Response[v1.SelectMergeStacktracesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.SelectMergeStacktraces is not implemented"))
}

func (UnimplementedQuerierServiceHandler) SelectMergeSpanProfile(context.Context, *connect.Request[v1.SelectMergeSpanProfileRequest]) (*connect.Response[v1.SelectMergeSpanProfileResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.SelectMergeSpanProfile is not implemented"))
}

func (UnimplementedQuerierServiceHandler) SelectMergeProfile(context.Context, *connect.Request[v1.SelectMergeProfileRequest]) (*connect.Response[v12.Profile], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.SelectMergeProfile is not implemented"))
}

func (UnimplementedQuerierServiceHandler) SelectSeries(context.Context, *connect.Request[v1.SelectSeriesRequest]) (*connect.Response[v1.SelectSeriesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.SelectSeries is not implemented"))
}

func (UnimplementedQuerierServiceHandler) Diff(context.Context, *connect.Request[v1.DiffRequest]) (*connect.Response[v1.DiffResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.Diff is not implemented"))
}

func (UnimplementedQuerierServiceHandler) GetProfileStats(context.Context, *connect.Request[v11.GetProfileStatsRequest]) (*connect.Response[v11.GetProfileStatsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.GetProfileStats is not implemented"))
}

func (UnimplementedQuerierServiceHandler) AnalyzeQuery(context.Context, *connect.Request[v1.AnalyzeQueryRequest]) (*connect.Response[v1.AnalyzeQueryResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("querier.v1.QuerierService.AnalyzeQuery is not implemented"))
}
