// Code generated by go-swagger; DO NOT EDIT.

package service_accounts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSearchOrgServiceAccountsWithPagingParams creates a new SearchOrgServiceAccountsWithPagingParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSearchOrgServiceAccountsWithPagingParams() *SearchOrgServiceAccountsWithPagingParams {
	return &SearchOrgServiceAccountsWithPagingParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSearchOrgServiceAccountsWithPagingParamsWithTimeout creates a new SearchOrgServiceAccountsWithPagingParams object
// with the ability to set a timeout on a request.
func NewSearchOrgServiceAccountsWithPagingParamsWithTimeout(timeout time.Duration) *SearchOrgServiceAccountsWithPagingParams {
	return &SearchOrgServiceAccountsWithPagingParams{
		timeout: timeout,
	}
}

// NewSearchOrgServiceAccountsWithPagingParamsWithContext creates a new SearchOrgServiceAccountsWithPagingParams object
// with the ability to set a context for a request.
func NewSearchOrgServiceAccountsWithPagingParamsWithContext(ctx context.Context) *SearchOrgServiceAccountsWithPagingParams {
	return &SearchOrgServiceAccountsWithPagingParams{
		Context: ctx,
	}
}

// NewSearchOrgServiceAccountsWithPagingParamsWithHTTPClient creates a new SearchOrgServiceAccountsWithPagingParams object
// with the ability to set a custom HTTPClient for a request.
func NewSearchOrgServiceAccountsWithPagingParamsWithHTTPClient(client *http.Client) *SearchOrgServiceAccountsWithPagingParams {
	return &SearchOrgServiceAccountsWithPagingParams{
		HTTPClient: client,
	}
}

/*
SearchOrgServiceAccountsWithPagingParams contains all the parameters to send to the API endpoint

	for the search org service accounts with paging operation.

	Typically these are written to a http.Request.
*/
type SearchOrgServiceAccountsWithPagingParams struct {

	// Disabled.
	Disabled *bool

	// ExpiredTokens.
	ExpiredTokens *bool

	/* Page.

	   The default value is 1.

	   Format: int64
	*/
	Page *int64

	/* Perpage.

	   The default value is 1000.

	   Format: int64
	*/
	Perpage *int64

	/* Query.

	     It will return results where the query value is contained in one of the name.
	Query values with spaces need to be URL encoded.
	*/
	Query *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the search org service accounts with paging params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SearchOrgServiceAccountsWithPagingParams) WithDefaults() *SearchOrgServiceAccountsWithPagingParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the search org service accounts with paging params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SearchOrgServiceAccountsWithPagingParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) WithTimeout(timeout time.Duration) *SearchOrgServiceAccountsWithPagingParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) WithContext(ctx context.Context) *SearchOrgServiceAccountsWithPagingParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) WithHTTPClient(client *http.Client) *SearchOrgServiceAccountsWithPagingParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDisabled adds the disabled to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) WithDisabled(disabled *bool) *SearchOrgServiceAccountsWithPagingParams {
	o.SetDisabled(disabled)
	return o
}

// SetDisabled adds the disabled to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) SetDisabled(disabled *bool) {
	o.Disabled = disabled
}

// WithExpiredTokens adds the expiredTokens to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) WithExpiredTokens(expiredTokens *bool) *SearchOrgServiceAccountsWithPagingParams {
	o.SetExpiredTokens(expiredTokens)
	return o
}

// SetExpiredTokens adds the expiredTokens to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) SetExpiredTokens(expiredTokens *bool) {
	o.ExpiredTokens = expiredTokens
}

// WithPage adds the page to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) WithPage(page *int64) *SearchOrgServiceAccountsWithPagingParams {
	o.SetPage(page)
	return o
}

// SetPage adds the page to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) SetPage(page *int64) {
	o.Page = page
}

// WithPerpage adds the perpage to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) WithPerpage(perpage *int64) *SearchOrgServiceAccountsWithPagingParams {
	o.SetPerpage(perpage)
	return o
}

// SetPerpage adds the perpage to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) SetPerpage(perpage *int64) {
	o.Perpage = perpage
}

// WithQuery adds the query to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) WithQuery(query *string) *SearchOrgServiceAccountsWithPagingParams {
	o.SetQuery(query)
	return o
}

// SetQuery adds the query to the search org service accounts with paging params
func (o *SearchOrgServiceAccountsWithPagingParams) SetQuery(query *string) {
	o.Query = query
}

// WriteToRequest writes these params to a swagger request
func (o *SearchOrgServiceAccountsWithPagingParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Disabled != nil {

		// query param Disabled
		var qrDisabled bool

		if o.Disabled != nil {
			qrDisabled = *o.Disabled
		}
		qDisabled := swag.FormatBool(qrDisabled)
		if qDisabled != "" {

			if err := r.SetQueryParam("Disabled", qDisabled); err != nil {
				return err
			}
		}
	}

	if o.ExpiredTokens != nil {

		// query param expiredTokens
		var qrExpiredTokens bool

		if o.ExpiredTokens != nil {
			qrExpiredTokens = *o.ExpiredTokens
		}
		qExpiredTokens := swag.FormatBool(qrExpiredTokens)
		if qExpiredTokens != "" {

			if err := r.SetQueryParam("expiredTokens", qExpiredTokens); err != nil {
				return err
			}
		}
	}

	if o.Page != nil {

		// query param page
		var qrPage int64

		if o.Page != nil {
			qrPage = *o.Page
		}
		qPage := swag.FormatInt64(qrPage)
		if qPage != "" {

			if err := r.SetQueryParam("page", qPage); err != nil {
				return err
			}
		}
	}

	if o.Perpage != nil {

		// query param perpage
		var qrPerpage int64

		if o.Perpage != nil {
			qrPerpage = *o.Perpage
		}
		qPerpage := swag.FormatInt64(qrPerpage)
		if qPerpage != "" {

			if err := r.SetQueryParam("perpage", qPerpage); err != nil {
				return err
			}
		}
	}

	if o.Query != nil {

		// query param query
		var qrQuery string

		if o.Query != nil {
			qrQuery = *o.Query
		}
		qQuery := qrQuery
		if qQuery != "" {

			if err := r.SetQueryParam("query", qQuery); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
