// Code generated by go-swagger; DO NOT EDIT.

package playlists

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreatePlaylistReader is a Reader for the CreatePlaylist structure.
type CreatePlaylistReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreatePlaylistReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreatePlaylistOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewCreatePlaylistUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreatePlaylistForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreatePlaylistNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreatePlaylistInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /playlists] createPlaylist", response, response.Code())
	}
}

// NewCreatePlaylistOK creates a CreatePlaylistOK with default headers values
func NewCreatePlaylistOK() *CreatePlaylistOK {
	return &CreatePlaylistOK{}
}

/*
CreatePlaylistOK describes a response with status code 200, with default header values.

(empty)
*/
type CreatePlaylistOK struct {
	Payload *models.Playlist
}

// IsSuccess returns true when this create playlist Ok response has a 2xx status code
func (o *CreatePlaylistOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create playlist Ok response has a 3xx status code
func (o *CreatePlaylistOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create playlist Ok response has a 4xx status code
func (o *CreatePlaylistOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create playlist Ok response has a 5xx status code
func (o *CreatePlaylistOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create playlist Ok response a status code equal to that given
func (o *CreatePlaylistOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create playlist Ok response
func (o *CreatePlaylistOK) Code() int {
	return 200
}

func (o *CreatePlaylistOK) Error() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistOk  %+v", 200, o.Payload)
}

func (o *CreatePlaylistOK) String() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistOk  %+v", 200, o.Payload)
}

func (o *CreatePlaylistOK) GetPayload() *models.Playlist {
	return o.Payload
}

func (o *CreatePlaylistOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Playlist)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePlaylistUnauthorized creates a CreatePlaylistUnauthorized with default headers values
func NewCreatePlaylistUnauthorized() *CreatePlaylistUnauthorized {
	return &CreatePlaylistUnauthorized{}
}

/*
CreatePlaylistUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreatePlaylistUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create playlist unauthorized response has a 2xx status code
func (o *CreatePlaylistUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create playlist unauthorized response has a 3xx status code
func (o *CreatePlaylistUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create playlist unauthorized response has a 4xx status code
func (o *CreatePlaylistUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create playlist unauthorized response has a 5xx status code
func (o *CreatePlaylistUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create playlist unauthorized response a status code equal to that given
func (o *CreatePlaylistUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create playlist unauthorized response
func (o *CreatePlaylistUnauthorized) Code() int {
	return 401
}

func (o *CreatePlaylistUnauthorized) Error() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistUnauthorized  %+v", 401, o.Payload)
}

func (o *CreatePlaylistUnauthorized) String() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistUnauthorized  %+v", 401, o.Payload)
}

func (o *CreatePlaylistUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreatePlaylistUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePlaylistForbidden creates a CreatePlaylistForbidden with default headers values
func NewCreatePlaylistForbidden() *CreatePlaylistForbidden {
	return &CreatePlaylistForbidden{}
}

/*
CreatePlaylistForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreatePlaylistForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create playlist forbidden response has a 2xx status code
func (o *CreatePlaylistForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create playlist forbidden response has a 3xx status code
func (o *CreatePlaylistForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create playlist forbidden response has a 4xx status code
func (o *CreatePlaylistForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create playlist forbidden response has a 5xx status code
func (o *CreatePlaylistForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create playlist forbidden response a status code equal to that given
func (o *CreatePlaylistForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create playlist forbidden response
func (o *CreatePlaylistForbidden) Code() int {
	return 403
}

func (o *CreatePlaylistForbidden) Error() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistForbidden  %+v", 403, o.Payload)
}

func (o *CreatePlaylistForbidden) String() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistForbidden  %+v", 403, o.Payload)
}

func (o *CreatePlaylistForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreatePlaylistForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePlaylistNotFound creates a CreatePlaylistNotFound with default headers values
func NewCreatePlaylistNotFound() *CreatePlaylistNotFound {
	return &CreatePlaylistNotFound{}
}

/*
CreatePlaylistNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type CreatePlaylistNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create playlist not found response has a 2xx status code
func (o *CreatePlaylistNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create playlist not found response has a 3xx status code
func (o *CreatePlaylistNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create playlist not found response has a 4xx status code
func (o *CreatePlaylistNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this create playlist not found response has a 5xx status code
func (o *CreatePlaylistNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this create playlist not found response a status code equal to that given
func (o *CreatePlaylistNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the create playlist not found response
func (o *CreatePlaylistNotFound) Code() int {
	return 404
}

func (o *CreatePlaylistNotFound) Error() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistNotFound  %+v", 404, o.Payload)
}

func (o *CreatePlaylistNotFound) String() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistNotFound  %+v", 404, o.Payload)
}

func (o *CreatePlaylistNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreatePlaylistNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePlaylistInternalServerError creates a CreatePlaylistInternalServerError with default headers values
func NewCreatePlaylistInternalServerError() *CreatePlaylistInternalServerError {
	return &CreatePlaylistInternalServerError{}
}

/*
CreatePlaylistInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreatePlaylistInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create playlist internal server error response has a 2xx status code
func (o *CreatePlaylistInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create playlist internal server error response has a 3xx status code
func (o *CreatePlaylistInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create playlist internal server error response has a 4xx status code
func (o *CreatePlaylistInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create playlist internal server error response has a 5xx status code
func (o *CreatePlaylistInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create playlist internal server error response a status code equal to that given
func (o *CreatePlaylistInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create playlist internal server error response
func (o *CreatePlaylistInternalServerError) Code() int {
	return 500
}

func (o *CreatePlaylistInternalServerError) Error() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistInternalServerError  %+v", 500, o.Payload)
}

func (o *CreatePlaylistInternalServerError) String() string {
	return fmt.Sprintf("[POST /playlists][%d] createPlaylistInternalServerError  %+v", 500, o.Payload)
}

func (o *CreatePlaylistInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreatePlaylistInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
