// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetOrgByIDParams creates a new GetOrgByIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetOrgByIDParams() *GetOrgByIDParams {
	return &GetOrgByIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetOrgByIDParamsWithTimeout creates a new GetOrgByIDParams object
// with the ability to set a timeout on a request.
func NewGetOrgByIDParamsWithTimeout(timeout time.Duration) *GetOrgByIDParams {
	return &GetOrgByIDParams{
		timeout: timeout,
	}
}

// NewGetOrgByIDParamsWithContext creates a new GetOrgByIDParams object
// with the ability to set a context for a request.
func NewGetOrgByIDParamsWithContext(ctx context.Context) *GetOrgByIDParams {
	return &GetOrgByIDParams{
		Context: ctx,
	}
}

// NewGetOrgByIDParamsWithHTTPClient creates a new GetOrgByIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetOrgByIDParamsWithHTTPClient(client *http.Client) *GetOrgByIDParams {
	return &GetOrgByIDParams{
		HTTPClient: client,
	}
}

/*
GetOrgByIDParams contains all the parameters to send to the API endpoint

	for the get org by ID operation.

	Typically these are written to a http.Request.
*/
type GetOrgByIDParams struct {

	// OrgID.
	//
	// Format: int64
	OrgID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get org by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetOrgByIDParams) WithDefaults() *GetOrgByIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get org by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetOrgByIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get org by ID params
func (o *GetOrgByIDParams) WithTimeout(timeout time.Duration) *GetOrgByIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get org by ID params
func (o *GetOrgByIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get org by ID params
func (o *GetOrgByIDParams) WithContext(ctx context.Context) *GetOrgByIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get org by ID params
func (o *GetOrgByIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get org by ID params
func (o *GetOrgByIDParams) WithHTTPClient(client *http.Client) *GetOrgByIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get org by ID params
func (o *GetOrgByIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOrgID adds the orgID to the get org by ID params
func (o *GetOrgByIDParams) WithOrgID(orgID int64) *GetOrgByIDParams {
	o.SetOrgID(orgID)
	return o
}

// SetOrgID adds the orgId to the get org by ID params
func (o *GetOrgByIDParams) SetOrgID(orgID int64) {
	o.OrgID = orgID
}

// WriteToRequest writes these params to a swagger request
func (o *GetOrgByIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param org_id
	if err := r.SetPathParam("org_id", swag.FormatInt64(o.OrgID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
