// Code generated by go-swagger; DO NOT EDIT.

package legacy_alerts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPauseAlertParams creates a new PauseAlertParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPauseAlertParams() *PauseAlertParams {
	return &PauseAlertParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPauseAlertParamsWithTimeout creates a new PauseAlertParams object
// with the ability to set a timeout on a request.
func NewPauseAlertParamsWithTimeout(timeout time.Duration) *PauseAlertParams {
	return &PauseAlertParams{
		timeout: timeout,
	}
}

// NewPauseAlertParamsWithContext creates a new PauseAlertParams object
// with the ability to set a context for a request.
func NewPauseAlertParamsWithContext(ctx context.Context) *PauseAlertParams {
	return &PauseAlertParams{
		Context: ctx,
	}
}

// NewPauseAlertParamsWithHTTPClient creates a new PauseAlertParams object
// with the ability to set a custom HTTPClient for a request.
func NewPauseAlertParamsWithHTTPClient(client *http.Client) *PauseAlertParams {
	return &PauseAlertParams{
		HTTPClient: client,
	}
}

/*
PauseAlertParams contains all the parameters to send to the API endpoint

	for the pause alert operation.

	Typically these are written to a http.Request.
*/
type PauseAlertParams struct {

	// AlertID.
	AlertID string

	// Body.
	Body *models.PauseAlertCommand

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the pause alert params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PauseAlertParams) WithDefaults() *PauseAlertParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the pause alert params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PauseAlertParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the pause alert params
func (o *PauseAlertParams) WithTimeout(timeout time.Duration) *PauseAlertParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the pause alert params
func (o *PauseAlertParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the pause alert params
func (o *PauseAlertParams) WithContext(ctx context.Context) *PauseAlertParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the pause alert params
func (o *PauseAlertParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the pause alert params
func (o *PauseAlertParams) WithHTTPClient(client *http.Client) *PauseAlertParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the pause alert params
func (o *PauseAlertParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAlertID adds the alertID to the pause alert params
func (o *PauseAlertParams) WithAlertID(alertID string) *PauseAlertParams {
	o.SetAlertID(alertID)
	return o
}

// SetAlertID adds the alertId to the pause alert params
func (o *PauseAlertParams) SetAlertID(alertID string) {
	o.AlertID = alertID
}

// WithBody adds the body to the pause alert params
func (o *PauseAlertParams) WithBody(body *models.PauseAlertCommand) *PauseAlertParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the pause alert params
func (o *PauseAlertParams) SetBody(body *models.PauseAlertCommand) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PauseAlertParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param alert_id
	if err := r.SetPathParam("alert_id", o.AlertID); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
