// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new datasources API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for datasources API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AddDataSource(body *models.AddDataSourceCommand, opts ...ClientOption) (*AddDataSourceOK, error)
	AddDataSourceWithParams(params *AddDataSourceParams, opts ...ClientOption) (*AddDataSourceOK, error)

	CallDatasourceResourceByID(id string, datasourceProxyRoute string, opts ...ClientOption) (*CallDatasourceResourceByIDOK, error)
	CallDatasourceResourceByIDWithParams(params *CallDatasourceResourceByIDParams, opts ...ClientOption) (*CallDatasourceResourceByIDOK, error)

	CallDatasourceResourceWithUID(uid string, datasourceProxyRoute string, opts ...ClientOption) (*CallDatasourceResourceWithUIDOK, error)
	CallDatasourceResourceWithUIDWithParams(params *CallDatasourceResourceWithUIDParams, opts ...ClientOption) (*CallDatasourceResourceWithUIDOK, error)

	CheckDatasourceHealthByID(id string, opts ...ClientOption) (*CheckDatasourceHealthByIDOK, error)
	CheckDatasourceHealthByIDWithParams(params *CheckDatasourceHealthByIDParams, opts ...ClientOption) (*CheckDatasourceHealthByIDOK, error)

	CheckDatasourceHealthWithUID(uid string, opts ...ClientOption) (*CheckDatasourceHealthWithUIDOK, error)
	CheckDatasourceHealthWithUIDWithParams(params *CheckDatasourceHealthWithUIDParams, opts ...ClientOption) (*CheckDatasourceHealthWithUIDOK, error)

	DatasourceProxyDELETEByUIDcalls(uid string, datasourceProxyRoute string, opts ...ClientOption) (*DatasourceProxyDELETEByUIDcallsAccepted, error)
	DatasourceProxyDELETEByUIDcallsWithParams(params *DatasourceProxyDELETEByUIDcallsParams, opts ...ClientOption) (*DatasourceProxyDELETEByUIDcallsAccepted, error)

	DatasourceProxyDELETEcalls(id string, datasourceProxyRoute string, opts ...ClientOption) (*DatasourceProxyDELETEcallsAccepted, error)
	DatasourceProxyDELETEcallsWithParams(params *DatasourceProxyDELETEcallsParams, opts ...ClientOption) (*DatasourceProxyDELETEcallsAccepted, error)

	DatasourceProxyGETByUIDcalls(uid string, datasourceProxyRoute string, opts ...ClientOption) (*DatasourceProxyGETByUIDcallsOK, error)
	DatasourceProxyGETByUIDcallsWithParams(params *DatasourceProxyGETByUIDcallsParams, opts ...ClientOption) (*DatasourceProxyGETByUIDcallsOK, error)

	DatasourceProxyGETcalls(id string, datasourceProxyRoute string, opts ...ClientOption) (*DatasourceProxyGETcallsOK, error)
	DatasourceProxyGETcallsWithParams(params *DatasourceProxyGETcallsParams, opts ...ClientOption) (*DatasourceProxyGETcallsOK, error)

	DatasourceProxyPOSTByUIDcalls(params *DatasourceProxyPOSTByUIDcallsParams, opts ...ClientOption) (*DatasourceProxyPOSTByUIDcallsCreated, *DatasourceProxyPOSTByUIDcallsAccepted, error)

	DatasourceProxyPOSTcalls(params *DatasourceProxyPOSTcallsParams, opts ...ClientOption) (*DatasourceProxyPOSTcallsCreated, *DatasourceProxyPOSTcallsAccepted, error)

	DeleteDataSourceByID(id string, opts ...ClientOption) (*DeleteDataSourceByIDOK, error)
	DeleteDataSourceByIDWithParams(params *DeleteDataSourceByIDParams, opts ...ClientOption) (*DeleteDataSourceByIDOK, error)

	DeleteDataSourceByName(name string, opts ...ClientOption) (*DeleteDataSourceByNameOK, error)
	DeleteDataSourceByNameWithParams(params *DeleteDataSourceByNameParams, opts ...ClientOption) (*DeleteDataSourceByNameOK, error)

	DeleteDataSourceByUID(uid string, opts ...ClientOption) (*DeleteDataSourceByUIDOK, error)
	DeleteDataSourceByUIDWithParams(params *DeleteDataSourceByUIDParams, opts ...ClientOption) (*DeleteDataSourceByUIDOK, error)

	GetDataSourceByID(id string, opts ...ClientOption) (*GetDataSourceByIDOK, error)
	GetDataSourceByIDWithParams(params *GetDataSourceByIDParams, opts ...ClientOption) (*GetDataSourceByIDOK, error)

	GetDataSourceByName(name string, opts ...ClientOption) (*GetDataSourceByNameOK, error)
	GetDataSourceByNameWithParams(params *GetDataSourceByNameParams, opts ...ClientOption) (*GetDataSourceByNameOK, error)

	GetDataSourceByUID(uid string, opts ...ClientOption) (*GetDataSourceByUIDOK, error)
	GetDataSourceByUIDWithParams(params *GetDataSourceByUIDParams, opts ...ClientOption) (*GetDataSourceByUIDOK, error)

	GetDataSourceIDByName(name string, opts ...ClientOption) (*GetDataSourceIDByNameOK, error)
	GetDataSourceIDByNameWithParams(params *GetDataSourceIDByNameParams, opts ...ClientOption) (*GetDataSourceIDByNameOK, error)

	GetDataSources(opts ...ClientOption) (*GetDataSourcesOK, error)
	GetDataSourcesWithParams(params *GetDataSourcesParams, opts ...ClientOption) (*GetDataSourcesOK, error)

	UpdateDataSourceByID(id string, body *models.UpdateDataSourceCommand, opts ...ClientOption) (*UpdateDataSourceByIDOK, error)
	UpdateDataSourceByIDWithParams(params *UpdateDataSourceByIDParams, opts ...ClientOption) (*UpdateDataSourceByIDOK, error)

	UpdateDataSourceByUID(uid string, body *models.UpdateDataSourceCommand, opts ...ClientOption) (*UpdateDataSourceByUIDOK, error)
	UpdateDataSourceByUIDWithParams(params *UpdateDataSourceByUIDParams, opts ...ClientOption) (*UpdateDataSourceByUIDOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AddDataSource creates a data source

By defining `password` and `basicAuthPassword` under secureJsonData property
Grafana encrypts them securely as an encrypted blob in the database.
The response then lists the encrypted fields under secureJsonFields.

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:create`
*/
func (a *Client) AddDataSource(body *models.AddDataSourceCommand, opts ...ClientOption) (*AddDataSourceOK, error) {
	params := NewAddDataSourceParams().WithBody(body)
	return a.AddDataSourceWithParams(params, opts...)
}

func (a *Client) AddDataSourceWithParams(params *AddDataSourceParams, opts ...ClientOption) (*AddDataSourceOK, error) {
	if params == nil {
		params = NewAddDataSourceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addDataSource",
		Method:             "POST",
		PathPattern:        "/datasources",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AddDataSourceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AddDataSourceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for addDataSource: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CallDatasourceResourceByID fetches data source resources by Id

Please refer to [updated API](#/datasources/callDatasourceResourceWithUID) instead
*/
func (a *Client) CallDatasourceResourceByID(id string, datasourceProxyRoute string, opts ...ClientOption) (*CallDatasourceResourceByIDOK, error) {
	params := NewCallDatasourceResourceByIDParams().WithDatasourceProxyRoute(datasourceProxyRoute).WithID(id)
	return a.CallDatasourceResourceByIDWithParams(params, opts...)
}

func (a *Client) CallDatasourceResourceByIDWithParams(params *CallDatasourceResourceByIDParams, opts ...ClientOption) (*CallDatasourceResourceByIDOK, error) {
	if params == nil {
		params = NewCallDatasourceResourceByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "callDatasourceResourceByID",
		Method:             "GET",
		PathPattern:        "/datasources/{id}/resources/{datasource_proxy_route}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CallDatasourceResourceByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CallDatasourceResourceByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for callDatasourceResourceByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CallDatasourceResourceWithUID fetches data source resources
*/
func (a *Client) CallDatasourceResourceWithUID(uid string, datasourceProxyRoute string, opts ...ClientOption) (*CallDatasourceResourceWithUIDOK, error) {
	params := NewCallDatasourceResourceWithUIDParams().WithDatasourceProxyRoute(datasourceProxyRoute).WithUID(uid)
	return a.CallDatasourceResourceWithUIDWithParams(params, opts...)
}

func (a *Client) CallDatasourceResourceWithUIDWithParams(params *CallDatasourceResourceWithUIDParams, opts ...ClientOption) (*CallDatasourceResourceWithUIDOK, error) {
	if params == nil {
		params = NewCallDatasourceResourceWithUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "callDatasourceResourceWithUID",
		Method:             "GET",
		PathPattern:        "/datasources/uid/{uid}/resources/{datasource_proxy_route}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CallDatasourceResourceWithUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CallDatasourceResourceWithUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for callDatasourceResourceWithUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CheckDatasourceHealthByID sends a health check request to the plugin datasource identified by the ID

Please refer to [updated API](#/datasources/checkDatasourceHealthWithUID) instead
*/
func (a *Client) CheckDatasourceHealthByID(id string, opts ...ClientOption) (*CheckDatasourceHealthByIDOK, error) {
	params := NewCheckDatasourceHealthByIDParams().WithID(id)
	return a.CheckDatasourceHealthByIDWithParams(params, opts...)
}

func (a *Client) CheckDatasourceHealthByIDWithParams(params *CheckDatasourceHealthByIDParams, opts ...ClientOption) (*CheckDatasourceHealthByIDOK, error) {
	if params == nil {
		params = NewCheckDatasourceHealthByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "checkDatasourceHealthByID",
		Method:             "GET",
		PathPattern:        "/datasources/{id}/health",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CheckDatasourceHealthByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CheckDatasourceHealthByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for checkDatasourceHealthByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CheckDatasourceHealthWithUID sends a health check request to the plugin datasource identified by the UID
*/
func (a *Client) CheckDatasourceHealthWithUID(uid string, opts ...ClientOption) (*CheckDatasourceHealthWithUIDOK, error) {
	params := NewCheckDatasourceHealthWithUIDParams().WithUID(uid)
	return a.CheckDatasourceHealthWithUIDWithParams(params, opts...)
}

func (a *Client) CheckDatasourceHealthWithUIDWithParams(params *CheckDatasourceHealthWithUIDParams, opts ...ClientOption) (*CheckDatasourceHealthWithUIDOK, error) {
	if params == nil {
		params = NewCheckDatasourceHealthWithUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "checkDatasourceHealthWithUID",
		Method:             "GET",
		PathPattern:        "/datasources/uid/{uid}/health",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CheckDatasourceHealthWithUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CheckDatasourceHealthWithUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for checkDatasourceHealthWithUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DatasourceProxyDELETEByUIDcalls data source proxy d e l e t e calls

Proxies all calls to the actual data source.
*/
func (a *Client) DatasourceProxyDELETEByUIDcalls(uid string, datasourceProxyRoute string, opts ...ClientOption) (*DatasourceProxyDELETEByUIDcallsAccepted, error) {
	params := NewDatasourceProxyDELETEByUIDcallsParams().WithDatasourceProxyRoute(datasourceProxyRoute).WithUID(uid)
	return a.DatasourceProxyDELETEByUIDcallsWithParams(params, opts...)
}

func (a *Client) DatasourceProxyDELETEByUIDcallsWithParams(params *DatasourceProxyDELETEByUIDcallsParams, opts ...ClientOption) (*DatasourceProxyDELETEByUIDcallsAccepted, error) {
	if params == nil {
		params = NewDatasourceProxyDELETEByUIDcallsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datasourceProxyDELETEByUIDcalls",
		Method:             "DELETE",
		PathPattern:        "/datasources/proxy/uid/{uid}/{datasource_proxy_route}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DatasourceProxyDELETEByUIDcallsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatasourceProxyDELETEByUIDcallsAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for datasourceProxyDELETEByUIDcalls: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DatasourceProxyDELETEcalls data source proxy d e l e t e calls

Proxies all calls to the actual data source.

Please refer to [updated API](#/datasources/datasourceProxyDELETEByUIDcalls) instead
*/
func (a *Client) DatasourceProxyDELETEcalls(id string, datasourceProxyRoute string, opts ...ClientOption) (*DatasourceProxyDELETEcallsAccepted, error) {
	params := NewDatasourceProxyDELETEcallsParams().WithDatasourceProxyRoute(datasourceProxyRoute).WithID(id)
	return a.DatasourceProxyDELETEcallsWithParams(params, opts...)
}

func (a *Client) DatasourceProxyDELETEcallsWithParams(params *DatasourceProxyDELETEcallsParams, opts ...ClientOption) (*DatasourceProxyDELETEcallsAccepted, error) {
	if params == nil {
		params = NewDatasourceProxyDELETEcallsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datasourceProxyDELETEcalls",
		Method:             "DELETE",
		PathPattern:        "/datasources/proxy/{id}/{datasource_proxy_route}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DatasourceProxyDELETEcallsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatasourceProxyDELETEcallsAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for datasourceProxyDELETEcalls: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DatasourceProxyGETByUIDcalls data source proxy g e t calls

Proxies all calls to the actual data source.
*/
func (a *Client) DatasourceProxyGETByUIDcalls(uid string, datasourceProxyRoute string, opts ...ClientOption) (*DatasourceProxyGETByUIDcallsOK, error) {
	params := NewDatasourceProxyGETByUIDcallsParams().WithDatasourceProxyRoute(datasourceProxyRoute).WithUID(uid)
	return a.DatasourceProxyGETByUIDcallsWithParams(params, opts...)
}

func (a *Client) DatasourceProxyGETByUIDcallsWithParams(params *DatasourceProxyGETByUIDcallsParams, opts ...ClientOption) (*DatasourceProxyGETByUIDcallsOK, error) {
	if params == nil {
		params = NewDatasourceProxyGETByUIDcallsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datasourceProxyGETByUIDcalls",
		Method:             "GET",
		PathPattern:        "/datasources/proxy/uid/{uid}/{datasource_proxy_route}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DatasourceProxyGETByUIDcallsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatasourceProxyGETByUIDcallsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for datasourceProxyGETByUIDcalls: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DatasourceProxyGETcalls data source proxy g e t calls

Proxies all calls to the actual data source.

Please refer to [updated API](#/datasources/datasourceProxyGETByUIDcalls) instead
*/
func (a *Client) DatasourceProxyGETcalls(id string, datasourceProxyRoute string, opts ...ClientOption) (*DatasourceProxyGETcallsOK, error) {
	params := NewDatasourceProxyGETcallsParams().WithDatasourceProxyRoute(datasourceProxyRoute).WithID(id)
	return a.DatasourceProxyGETcallsWithParams(params, opts...)
}

func (a *Client) DatasourceProxyGETcallsWithParams(params *DatasourceProxyGETcallsParams, opts ...ClientOption) (*DatasourceProxyGETcallsOK, error) {
	if params == nil {
		params = NewDatasourceProxyGETcallsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datasourceProxyGETcalls",
		Method:             "GET",
		PathPattern:        "/datasources/proxy/{id}/{datasource_proxy_route}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DatasourceProxyGETcallsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DatasourceProxyGETcallsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for datasourceProxyGETcalls: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DatasourceProxyPOSTByUIDcalls data source proxy p o s t calls

Proxies all calls to the actual data source. The data source should support POST methods for the specific path and role as defined
*/

func (a *Client) DatasourceProxyPOSTByUIDcalls(params *DatasourceProxyPOSTByUIDcallsParams, opts ...ClientOption) (*DatasourceProxyPOSTByUIDcallsCreated, *DatasourceProxyPOSTByUIDcallsAccepted, error) {
	if params == nil {
		params = NewDatasourceProxyPOSTByUIDcallsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datasourceProxyPOSTByUIDcalls",
		Method:             "POST",
		PathPattern:        "/datasources/proxy/uid/{uid}/{datasource_proxy_route}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DatasourceProxyPOSTByUIDcallsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatasourceProxyPOSTByUIDcallsCreated:
		return value, nil, nil
	case *DatasourceProxyPOSTByUIDcallsAccepted:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for datasources: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DatasourceProxyPOSTcalls data source proxy p o s t calls

Proxies all calls to the actual data source. The data source should support POST methods for the specific path and role as defined

Please refer to [updated API](#/datasources/datasourceProxyPOSTByUIDcalls) instead
*/

func (a *Client) DatasourceProxyPOSTcalls(params *DatasourceProxyPOSTcallsParams, opts ...ClientOption) (*DatasourceProxyPOSTcallsCreated, *DatasourceProxyPOSTcallsAccepted, error) {
	if params == nil {
		params = NewDatasourceProxyPOSTcallsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "datasourceProxyPOSTcalls",
		Method:             "POST",
		PathPattern:        "/datasources/proxy/{id}/{datasource_proxy_route}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DatasourceProxyPOSTcallsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DatasourceProxyPOSTcallsCreated:
		return value, nil, nil
	case *DatasourceProxyPOSTcallsAccepted:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for datasources: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteDataSourceByID deletes an existing data source by id

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:delete` and scopes: `datasources:*`, `datasources:id:*` and `datasources:id:1` (single data source).

Please refer to [updated API](#/datasources/deleteDataSourceByUID) instead
*/
func (a *Client) DeleteDataSourceByID(id string, opts ...ClientOption) (*DeleteDataSourceByIDOK, error) {
	params := NewDeleteDataSourceByIDParams().WithID(id)
	return a.DeleteDataSourceByIDWithParams(params, opts...)
}

func (a *Client) DeleteDataSourceByIDWithParams(params *DeleteDataSourceByIDParams, opts ...ClientOption) (*DeleteDataSourceByIDOK, error) {
	if params == nil {
		params = NewDeleteDataSourceByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteDataSourceByID",
		Method:             "DELETE",
		PathPattern:        "/datasources/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteDataSourceByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteDataSourceByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteDataSourceByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteDataSourceByName deletes an existing data source by name

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:delete` and scopes: `datasources:*`, `datasources:name:*` and `datasources:name:test_datasource` (single data source).
*/
func (a *Client) DeleteDataSourceByName(name string, opts ...ClientOption) (*DeleteDataSourceByNameOK, error) {
	params := NewDeleteDataSourceByNameParams().WithName(name)
	return a.DeleteDataSourceByNameWithParams(params, opts...)
}

func (a *Client) DeleteDataSourceByNameWithParams(params *DeleteDataSourceByNameParams, opts ...ClientOption) (*DeleteDataSourceByNameOK, error) {
	if params == nil {
		params = NewDeleteDataSourceByNameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteDataSourceByName",
		Method:             "DELETE",
		PathPattern:        "/datasources/name/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteDataSourceByNameReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteDataSourceByNameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteDataSourceByName: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteDataSourceByUID deletes an existing data source by UID

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:delete` and scopes: `datasources:*`, `datasources:uid:*` and `datasources:uid:kLtEtcRGk` (single data source).
*/
func (a *Client) DeleteDataSourceByUID(uid string, opts ...ClientOption) (*DeleteDataSourceByUIDOK, error) {
	params := NewDeleteDataSourceByUIDParams().WithUID(uid)
	return a.DeleteDataSourceByUIDWithParams(params, opts...)
}

func (a *Client) DeleteDataSourceByUIDWithParams(params *DeleteDataSourceByUIDParams, opts ...ClientOption) (*DeleteDataSourceByUIDOK, error) {
	if params == nil {
		params = NewDeleteDataSourceByUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteDataSourceByUID",
		Method:             "DELETE",
		PathPattern:        "/datasources/uid/{uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteDataSourceByUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteDataSourceByUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteDataSourceByUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetDataSourceByID gets a single data source by Id

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:read` and scopes: `datasources:*`, `datasources:id:*` and `datasources:id:1` (single data source).

Please refer to [updated API](#/datasources/getDataSourceByUID) instead
*/
func (a *Client) GetDataSourceByID(id string, opts ...ClientOption) (*GetDataSourceByIDOK, error) {
	params := NewGetDataSourceByIDParams().WithID(id)
	return a.GetDataSourceByIDWithParams(params, opts...)
}

func (a *Client) GetDataSourceByIDWithParams(params *GetDataSourceByIDParams, opts ...ClientOption) (*GetDataSourceByIDOK, error) {
	if params == nil {
		params = NewGetDataSourceByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getDataSourceByID",
		Method:             "GET",
		PathPattern:        "/datasources/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDataSourceByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDataSourceByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getDataSourceByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetDataSourceByName gets a single data source by name

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:read` and scopes: `datasources:*`, `datasources:name:*` and `datasources:name:test_datasource` (single data source).
*/
func (a *Client) GetDataSourceByName(name string, opts ...ClientOption) (*GetDataSourceByNameOK, error) {
	params := NewGetDataSourceByNameParams().WithName(name)
	return a.GetDataSourceByNameWithParams(params, opts...)
}

func (a *Client) GetDataSourceByNameWithParams(params *GetDataSourceByNameParams, opts ...ClientOption) (*GetDataSourceByNameOK, error) {
	if params == nil {
		params = NewGetDataSourceByNameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getDataSourceByName",
		Method:             "GET",
		PathPattern:        "/datasources/name/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDataSourceByNameReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDataSourceByNameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getDataSourceByName: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetDataSourceByUID gets a single data source by UID

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:read` and scopes: `datasources:*`, `datasources:uid:*` and `datasources:uid:kLtEtcRGk` (single data source).
*/
func (a *Client) GetDataSourceByUID(uid string, opts ...ClientOption) (*GetDataSourceByUIDOK, error) {
	params := NewGetDataSourceByUIDParams().WithUID(uid)
	return a.GetDataSourceByUIDWithParams(params, opts...)
}

func (a *Client) GetDataSourceByUIDWithParams(params *GetDataSourceByUIDParams, opts ...ClientOption) (*GetDataSourceByUIDOK, error) {
	if params == nil {
		params = NewGetDataSourceByUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getDataSourceByUID",
		Method:             "GET",
		PathPattern:        "/datasources/uid/{uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDataSourceByUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDataSourceByUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getDataSourceByUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetDataSourceIDByName gets data source Id by name

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:read` and scopes: `datasources:*`, `datasources:name:*` and `datasources:name:test_datasource` (single data source).
*/
func (a *Client) GetDataSourceIDByName(name string, opts ...ClientOption) (*GetDataSourceIDByNameOK, error) {
	params := NewGetDataSourceIDByNameParams().WithName(name)
	return a.GetDataSourceIDByNameWithParams(params, opts...)
}

func (a *Client) GetDataSourceIDByNameWithParams(params *GetDataSourceIDByNameParams, opts ...ClientOption) (*GetDataSourceIDByNameOK, error) {
	if params == nil {
		params = NewGetDataSourceIDByNameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getDataSourceIdByName",
		Method:             "GET",
		PathPattern:        "/datasources/id/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDataSourceIDByNameReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDataSourceIDByNameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getDataSourceIdByName: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetDataSources gets all data sources

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:read` and scope: `datasources:*`.
*/
func (a *Client) GetDataSources(opts ...ClientOption) (*GetDataSourcesOK, error) {
	params := NewGetDataSourcesParams()
	return a.GetDataSourcesWithParams(params, opts...)
}

func (a *Client) GetDataSourcesWithParams(params *GetDataSourcesParams, opts ...ClientOption) (*GetDataSourcesOK, error) {
	if params == nil {
		params = NewGetDataSourcesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getDataSources",
		Method:             "GET",
		PathPattern:        "/datasources",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDataSourcesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDataSourcesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getDataSources: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateDataSourceByID updates an existing data source by its sequential ID

Similar to creating a data source, `password` and `basicAuthPassword` should be defined under
secureJsonData in order to be stored securely as an encrypted blob in the database. Then, the
encrypted fields are listed under secureJsonFields section in the response.

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:write` and scopes: `datasources:*`, `datasources:id:*` and `datasources:id:1` (single data source).

Please refer to [updated API](#/datasources/updateDataSourceByUID) instead
*/
func (a *Client) UpdateDataSourceByID(id string, body *models.UpdateDataSourceCommand, opts ...ClientOption) (*UpdateDataSourceByIDOK, error) {
	params := NewUpdateDataSourceByIDParams().WithBody(body).WithID(id)
	return a.UpdateDataSourceByIDWithParams(params, opts...)
}

func (a *Client) UpdateDataSourceByIDWithParams(params *UpdateDataSourceByIDParams, opts ...ClientOption) (*UpdateDataSourceByIDOK, error) {
	if params == nil {
		params = NewUpdateDataSourceByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateDataSourceByID",
		Method:             "PUT",
		PathPattern:        "/datasources/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateDataSourceByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateDataSourceByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateDataSourceByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateDataSourceByUID updates an existing data source

Similar to creating a data source, `password` and `basicAuthPassword` should be defined under
secureJsonData in order to be stored securely as an encrypted blob in the database. Then, the
encrypted fields are listed under secureJsonFields section in the response.

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `datasources:write` and scopes: `datasources:*`, `datasources:uid:*` and `datasources:uid:1` (single data source).
*/
func (a *Client) UpdateDataSourceByUID(uid string, body *models.UpdateDataSourceCommand, opts ...ClientOption) (*UpdateDataSourceByUIDOK, error) {
	params := NewUpdateDataSourceByUIDParams().WithBody(body).WithUID(uid)
	return a.UpdateDataSourceByUIDWithParams(params, opts...)
}

func (a *Client) UpdateDataSourceByUIDWithParams(params *UpdateDataSourceByUIDParams, opts ...ClientOption) (*UpdateDataSourceByUIDOK, error) {
	if params == nil {
		params = NewUpdateDataSourceByUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateDataSourceByUID",
		Method:             "PUT",
		PathPattern:        "/datasources/uid/{uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateDataSourceByUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateDataSourceByUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateDataSourceByUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
