// Code generated by go-swagger; DO NOT EDIT.

package annotations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewUpdateAnnotationParams creates a new UpdateAnnotationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateAnnotationParams() *UpdateAnnotationParams {
	return &UpdateAnnotationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateAnnotationParamsWithTimeout creates a new UpdateAnnotationParams object
// with the ability to set a timeout on a request.
func NewUpdateAnnotationParamsWithTimeout(timeout time.Duration) *UpdateAnnotationParams {
	return &UpdateAnnotationParams{
		timeout: timeout,
	}
}

// NewUpdateAnnotationParamsWithContext creates a new UpdateAnnotationParams object
// with the ability to set a context for a request.
func NewUpdateAnnotationParamsWithContext(ctx context.Context) *UpdateAnnotationParams {
	return &UpdateAnnotationParams{
		Context: ctx,
	}
}

// NewUpdateAnnotationParamsWithHTTPClient creates a new UpdateAnnotationParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateAnnotationParamsWithHTTPClient(client *http.Client) *UpdateAnnotationParams {
	return &UpdateAnnotationParams{
		HTTPClient: client,
	}
}

/*
UpdateAnnotationParams contains all the parameters to send to the API endpoint

	for the update annotation operation.

	Typically these are written to a http.Request.
*/
type UpdateAnnotationParams struct {

	// AnnotationID.
	AnnotationID string

	// Body.
	Body *models.UpdateAnnotationsCmd

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update annotation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateAnnotationParams) WithDefaults() *UpdateAnnotationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update annotation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateAnnotationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update annotation params
func (o *UpdateAnnotationParams) WithTimeout(timeout time.Duration) *UpdateAnnotationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update annotation params
func (o *UpdateAnnotationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update annotation params
func (o *UpdateAnnotationParams) WithContext(ctx context.Context) *UpdateAnnotationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update annotation params
func (o *UpdateAnnotationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update annotation params
func (o *UpdateAnnotationParams) WithHTTPClient(client *http.Client) *UpdateAnnotationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update annotation params
func (o *UpdateAnnotationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAnnotationID adds the annotationID to the update annotation params
func (o *UpdateAnnotationParams) WithAnnotationID(annotationID string) *UpdateAnnotationParams {
	o.SetAnnotationID(annotationID)
	return o
}

// SetAnnotationID adds the annotationId to the update annotation params
func (o *UpdateAnnotationParams) SetAnnotationID(annotationID string) {
	o.AnnotationID = annotationID
}

// WithBody adds the body to the update annotation params
func (o *UpdateAnnotationParams) WithBody(body *models.UpdateAnnotationsCmd) *UpdateAnnotationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update annotation params
func (o *UpdateAnnotationParams) SetBody(body *models.UpdateAnnotationsCmd) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateAnnotationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param annotation_id
	if err := r.SetPathParam("annotation_id", o.AnnotationID); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
