// Code generated by go-swagger; DO NOT EDIT.

package annotations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAnnotationsParams creates a new GetAnnotationsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAnnotationsParams() *GetAnnotationsParams {
	return &GetAnnotationsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAnnotationsParamsWithTimeout creates a new GetAnnotationsParams object
// with the ability to set a timeout on a request.
func NewGetAnnotationsParamsWithTimeout(timeout time.Duration) *GetAnnotationsParams {
	return &GetAnnotationsParams{
		timeout: timeout,
	}
}

// NewGetAnnotationsParamsWithContext creates a new GetAnnotationsParams object
// with the ability to set a context for a request.
func NewGetAnnotationsParamsWithContext(ctx context.Context) *GetAnnotationsParams {
	return &GetAnnotationsParams{
		Context: ctx,
	}
}

// NewGetAnnotationsParamsWithHTTPClient creates a new GetAnnotationsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAnnotationsParamsWithHTTPClient(client *http.Client) *GetAnnotationsParams {
	return &GetAnnotationsParams{
		HTTPClient: client,
	}
}

/*
GetAnnotationsParams contains all the parameters to send to the API endpoint

	for the get annotations operation.

	Typically these are written to a http.Request.
*/
type GetAnnotationsParams struct {

	/* AlertID.

	   Find annotations for a specified alert.

	   Format: int64
	*/
	AlertID *int64

	/* DashboardID.

	   Find annotations that are scoped to a specific dashboard

	   Format: int64
	*/
	DashboardID *int64

	/* DashboardUID.

	   Find annotations that are scoped to a specific dashboard
	*/
	DashboardUID *string

	/* From.

	   Find annotations created after specific epoch datetime in milliseconds.

	   Format: int64
	*/
	From *int64

	/* Limit.

	   Max limit for results returned.

	   Format: int64
	*/
	Limit *int64

	/* MatchAny.

	   Match any or all tags
	*/
	MatchAny *bool

	/* PanelID.

	   Find annotations that are scoped to a specific panel

	   Format: int64
	*/
	PanelID *int64

	/* Tags.

	   Use this to filter organization annotations. Organization annotations are annotations from an annotation data source that are not connected specifically to a dashboard or panel. You can filter by multiple tags.
	*/
	Tags []string

	/* To.

	   Find annotations created before specific epoch datetime in milliseconds.

	   Format: int64
	*/
	To *int64

	/* Type.

	   Return alerts or user created annotations
	*/
	Type *string

	/* UserID.

	   Limit response to annotations created by specific user.

	   Format: int64
	*/
	UserID *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get annotations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAnnotationsParams) WithDefaults() *GetAnnotationsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get annotations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAnnotationsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get annotations params
func (o *GetAnnotationsParams) WithTimeout(timeout time.Duration) *GetAnnotationsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get annotations params
func (o *GetAnnotationsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get annotations params
func (o *GetAnnotationsParams) WithContext(ctx context.Context) *GetAnnotationsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get annotations params
func (o *GetAnnotationsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get annotations params
func (o *GetAnnotationsParams) WithHTTPClient(client *http.Client) *GetAnnotationsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get annotations params
func (o *GetAnnotationsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAlertID adds the alertID to the get annotations params
func (o *GetAnnotationsParams) WithAlertID(alertID *int64) *GetAnnotationsParams {
	o.SetAlertID(alertID)
	return o
}

// SetAlertID adds the alertId to the get annotations params
func (o *GetAnnotationsParams) SetAlertID(alertID *int64) {
	o.AlertID = alertID
}

// WithDashboardID adds the dashboardID to the get annotations params
func (o *GetAnnotationsParams) WithDashboardID(dashboardID *int64) *GetAnnotationsParams {
	o.SetDashboardID(dashboardID)
	return o
}

// SetDashboardID adds the dashboardId to the get annotations params
func (o *GetAnnotationsParams) SetDashboardID(dashboardID *int64) {
	o.DashboardID = dashboardID
}

// WithDashboardUID adds the dashboardUID to the get annotations params
func (o *GetAnnotationsParams) WithDashboardUID(dashboardUID *string) *GetAnnotationsParams {
	o.SetDashboardUID(dashboardUID)
	return o
}

// SetDashboardUID adds the dashboardUid to the get annotations params
func (o *GetAnnotationsParams) SetDashboardUID(dashboardUID *string) {
	o.DashboardUID = dashboardUID
}

// WithFrom adds the from to the get annotations params
func (o *GetAnnotationsParams) WithFrom(from *int64) *GetAnnotationsParams {
	o.SetFrom(from)
	return o
}

// SetFrom adds the from to the get annotations params
func (o *GetAnnotationsParams) SetFrom(from *int64) {
	o.From = from
}

// WithLimit adds the limit to the get annotations params
func (o *GetAnnotationsParams) WithLimit(limit *int64) *GetAnnotationsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get annotations params
func (o *GetAnnotationsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithMatchAny adds the matchAny to the get annotations params
func (o *GetAnnotationsParams) WithMatchAny(matchAny *bool) *GetAnnotationsParams {
	o.SetMatchAny(matchAny)
	return o
}

// SetMatchAny adds the matchAny to the get annotations params
func (o *GetAnnotationsParams) SetMatchAny(matchAny *bool) {
	o.MatchAny = matchAny
}

// WithPanelID adds the panelID to the get annotations params
func (o *GetAnnotationsParams) WithPanelID(panelID *int64) *GetAnnotationsParams {
	o.SetPanelID(panelID)
	return o
}

// SetPanelID adds the panelId to the get annotations params
func (o *GetAnnotationsParams) SetPanelID(panelID *int64) {
	o.PanelID = panelID
}

// WithTags adds the tags to the get annotations params
func (o *GetAnnotationsParams) WithTags(tags []string) *GetAnnotationsParams {
	o.SetTags(tags)
	return o
}

// SetTags adds the tags to the get annotations params
func (o *GetAnnotationsParams) SetTags(tags []string) {
	o.Tags = tags
}

// WithTo adds the to to the get annotations params
func (o *GetAnnotationsParams) WithTo(to *int64) *GetAnnotationsParams {
	o.SetTo(to)
	return o
}

// SetTo adds the to to the get annotations params
func (o *GetAnnotationsParams) SetTo(to *int64) {
	o.To = to
}

// WithType adds the typeVar to the get annotations params
func (o *GetAnnotationsParams) WithType(typeVar *string) *GetAnnotationsParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the get annotations params
func (o *GetAnnotationsParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUserID adds the userID to the get annotations params
func (o *GetAnnotationsParams) WithUserID(userID *int64) *GetAnnotationsParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the get annotations params
func (o *GetAnnotationsParams) SetUserID(userID *int64) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *GetAnnotationsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AlertID != nil {

		// query param alertId
		var qrAlertID int64

		if o.AlertID != nil {
			qrAlertID = *o.AlertID
		}
		qAlertID := swag.FormatInt64(qrAlertID)
		if qAlertID != "" {

			if err := r.SetQueryParam("alertId", qAlertID); err != nil {
				return err
			}
		}
	}

	if o.DashboardID != nil {

		// query param dashboardId
		var qrDashboardID int64

		if o.DashboardID != nil {
			qrDashboardID = *o.DashboardID
		}
		qDashboardID := swag.FormatInt64(qrDashboardID)
		if qDashboardID != "" {

			if err := r.SetQueryParam("dashboardId", qDashboardID); err != nil {
				return err
			}
		}
	}

	if o.DashboardUID != nil {

		// query param dashboardUID
		var qrDashboardUID string

		if o.DashboardUID != nil {
			qrDashboardUID = *o.DashboardUID
		}
		qDashboardUID := qrDashboardUID
		if qDashboardUID != "" {

			if err := r.SetQueryParam("dashboardUID", qDashboardUID); err != nil {
				return err
			}
		}
	}

	if o.From != nil {

		// query param from
		var qrFrom int64

		if o.From != nil {
			qrFrom = *o.From
		}
		qFrom := swag.FormatInt64(qrFrom)
		if qFrom != "" {

			if err := r.SetQueryParam("from", qFrom); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.MatchAny != nil {

		// query param matchAny
		var qrMatchAny bool

		if o.MatchAny != nil {
			qrMatchAny = *o.MatchAny
		}
		qMatchAny := swag.FormatBool(qrMatchAny)
		if qMatchAny != "" {

			if err := r.SetQueryParam("matchAny", qMatchAny); err != nil {
				return err
			}
		}
	}

	if o.PanelID != nil {

		// query param panelId
		var qrPanelID int64

		if o.PanelID != nil {
			qrPanelID = *o.PanelID
		}
		qPanelID := swag.FormatInt64(qrPanelID)
		if qPanelID != "" {

			if err := r.SetQueryParam("panelId", qPanelID); err != nil {
				return err
			}
		}
	}

	if o.Tags != nil {

		// binding items for tags
		joinedTags := o.bindParamTags(reg)

		// query array param tags
		if err := r.SetQueryParam("tags", joinedTags...); err != nil {
			return err
		}
	}

	if o.To != nil {

		// query param to
		var qrTo int64

		if o.To != nil {
			qrTo = *o.To
		}
		qTo := swag.FormatInt64(qrTo)
		if qTo != "" {

			if err := r.SetQueryParam("to", qTo); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UserID != nil {

		// query param userId
		var qrUserID int64

		if o.UserID != nil {
			qrUserID = *o.UserID
		}
		qUserID := swag.FormatInt64(qrUserID)
		if qUserID != "" {

			if err := r.SetQueryParam("userId", qUserID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetAnnotations binds the parameter tags
func (o *GetAnnotationsParams) bindParamTags(formats strfmt.Registry) []string {
	tagsIR := o.Tags

	var tagsIC []string
	for _, tagsIIR := range tagsIR { // explode []string

		tagsIIV := tagsIIR // string as string
		tagsIC = append(tagsIC, tagsIIV)
	}

	// items.CollectionFormat: "multi"
	tagsIS := swag.JoinByFormat(tagsIC, "multi")

	return tagsIS
}
