//
//Copyright 2019 The Vitess Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// This file contains the Vitess topology related data structures.
// Very few of these structures are exchanged over the wire (only
// TabletType and KeyRange), but they are all used by the topology
// service.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.3
// source: dolthub/vt/topodata.proto

package topodata

import (
	vttime "github.com/dolthub/vitess/go/vt/proto/vttime"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// KeyspaceType describes the type of the keyspace
type KeyspaceType int32

const (
	// NORMAL is the default value
	KeyspaceType_NORMAL KeyspaceType = 0
	// SNAPSHOT is when we are creating a snapshot keyspace
	KeyspaceType_SNAPSHOT KeyspaceType = 1
)

// Enum value maps for KeyspaceType.
var (
	KeyspaceType_name = map[int32]string{
		0: "NORMAL",
		1: "SNAPSHOT",
	}
	KeyspaceType_value = map[string]int32{
		"NORMAL":   0,
		"SNAPSHOT": 1,
	}
)

func (x KeyspaceType) Enum() *KeyspaceType {
	p := new(KeyspaceType)
	*p = x
	return p
}

func (x KeyspaceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyspaceType) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_topodata_proto_enumTypes[0].Descriptor()
}

func (KeyspaceType) Type() protoreflect.EnumType {
	return &file_dolthub_vt_topodata_proto_enumTypes[0]
}

func (x KeyspaceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyspaceType.Descriptor instead.
func (KeyspaceType) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{0}
}

// KeyspaceIdType describes the type of the sharding key for a
// range-based sharded keyspace.
type KeyspaceIdType int32

const (
	// UNSET is the default value, when range-based sharding is not used.
	KeyspaceIdType_UNSET KeyspaceIdType = 0
	// UINT64 is when uint64 value is used.
	// This is represented as 'unsigned bigint' in mysql
	KeyspaceIdType_UINT64 KeyspaceIdType = 1
	// BYTES is when an array of bytes is used.
	// This is represented as 'varbinary' in mysql
	KeyspaceIdType_BYTES KeyspaceIdType = 2
)

// Enum value maps for KeyspaceIdType.
var (
	KeyspaceIdType_name = map[int32]string{
		0: "UNSET",
		1: "UINT64",
		2: "BYTES",
	}
	KeyspaceIdType_value = map[string]int32{
		"UNSET":  0,
		"UINT64": 1,
		"BYTES":  2,
	}
)

func (x KeyspaceIdType) Enum() *KeyspaceIdType {
	p := new(KeyspaceIdType)
	*p = x
	return p
}

func (x KeyspaceIdType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyspaceIdType) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_topodata_proto_enumTypes[1].Descriptor()
}

func (KeyspaceIdType) Type() protoreflect.EnumType {
	return &file_dolthub_vt_topodata_proto_enumTypes[1]
}

func (x KeyspaceIdType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyspaceIdType.Descriptor instead.
func (KeyspaceIdType) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{1}
}

// TabletType represents the type of a given tablet.
type TabletType int32

const (
	// UNKNOWN is not a valid value.
	TabletType_UNKNOWN TabletType = 0
	// MASTER is the master server for the shard. Only MASTER allows DMLs.
	TabletType_MASTER TabletType = 1
	// REPLICA is a slave type. It is used to serve live traffic.
	// A REPLICA can be promoted to MASTER. A demoted MASTER will go to REPLICA.
	TabletType_REPLICA TabletType = 2
	// RDONLY (old name) / BATCH (new name) is used to serve traffic for
	// long-running jobs. It is a separate type from REPLICA so
	// long-running queries don't affect web-like traffic.
	TabletType_RDONLY TabletType = 3
	TabletType_BATCH  TabletType = 3
	// SPARE is a type of servers that cannot serve queries, but is available
	// in case an extra server is needed.
	TabletType_SPARE TabletType = 4
	// EXPERIMENTAL is like SPARE, except it can serve queries. This
	// type can be used for usages not planned by Vitess, like online
	// export to another storage engine.
	TabletType_EXPERIMENTAL TabletType = 5
	// BACKUP is the type a server goes to when taking a backup. No queries
	// can be served in BACKUP mode.
	TabletType_BACKUP TabletType = 6
	// RESTORE is the type a server uses when restoring a backup, at
	// startup time.  No queries can be served in RESTORE mode.
	TabletType_RESTORE TabletType = 7
	// DRAINED is the type a server goes into when used by Vitess tools
	// to perform an offline action. It is a serving type (as
	// the tools processes may need to run queries), but it's not used
	// to route queries from Vitess users. In this state,
	// this tablet is dedicated to the process that uses it.
	TabletType_DRAINED TabletType = 8
)

// Enum value maps for TabletType.
var (
	TabletType_name = map[int32]string{
		0: "UNKNOWN",
		1: "MASTER",
		2: "REPLICA",
		3: "RDONLY",
		// Duplicate value: 3: "BATCH",
		4: "SPARE",
		5: "EXPERIMENTAL",
		6: "BACKUP",
		7: "RESTORE",
		8: "DRAINED",
	}
	TabletType_value = map[string]int32{
		"UNKNOWN":      0,
		"MASTER":       1,
		"REPLICA":      2,
		"RDONLY":       3,
		"BATCH":        3,
		"SPARE":        4,
		"EXPERIMENTAL": 5,
		"BACKUP":       6,
		"RESTORE":      7,
		"DRAINED":      8,
	}
)

func (x TabletType) Enum() *TabletType {
	p := new(TabletType)
	*p = x
	return p
}

func (x TabletType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TabletType) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_topodata_proto_enumTypes[2].Descriptor()
}

func (TabletType) Type() protoreflect.EnumType {
	return &file_dolthub_vt_topodata_proto_enumTypes[2]
}

func (x TabletType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TabletType.Descriptor instead.
func (TabletType) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{2}
}

// KeyRange describes a range of sharding keys, when range-based
// sharding is used.
type KeyRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Start []byte `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	End   []byte `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *KeyRange) Reset() {
	*x = KeyRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyRange) ProtoMessage() {}

func (x *KeyRange) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyRange.ProtoReflect.Descriptor instead.
func (*KeyRange) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{0}
}

func (x *KeyRange) GetStart() []byte {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *KeyRange) GetEnd() []byte {
	if x != nil {
		return x.End
	}
	return nil
}

// TabletAlias is a globally unique tablet identifier.
type TabletAlias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// cell is the cell (or datacenter) the tablet is in
	Cell string `protobuf:"bytes,1,opt,name=cell,proto3" json:"cell,omitempty"`
	// uid is a unique id for this tablet within the shard
	// (this is the MySQL server id as well).
	Uid uint32 `protobuf:"varint,2,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *TabletAlias) Reset() {
	*x = TabletAlias{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TabletAlias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TabletAlias) ProtoMessage() {}

func (x *TabletAlias) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TabletAlias.ProtoReflect.Descriptor instead.
func (*TabletAlias) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{1}
}

func (x *TabletAlias) GetCell() string {
	if x != nil {
		return x.Cell
	}
	return ""
}

func (x *TabletAlias) GetUid() uint32 {
	if x != nil {
		return x.Uid
	}
	return 0
}

// Tablet represents information about a running instance of vttablet.
type Tablet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// alias is the unique name of the tablet.
	Alias *TabletAlias `protobuf:"bytes,1,opt,name=alias,proto3" json:"alias,omitempty"`
	// Fully qualified domain name of the host.
	Hostname string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Map of named ports. Normally this should include vt and grpc.
	// Going forward, the mysql port will be stored in mysql_port
	// instead of here.
	// For accessing mysql port, use topoproto.MysqlPort to fetch, and
	// topoproto.SetMysqlPort to set. These wrappers will ensure
	// legacy behavior is supported.
	PortMap map[string]int32 `protobuf:"bytes,4,rep,name=port_map,json=portMap,proto3" json:"port_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Keyspace name.
	Keyspace string `protobuf:"bytes,5,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// Shard name. If range based sharding is used, it should match
	// key_range.
	Shard string `protobuf:"bytes,6,opt,name=shard,proto3" json:"shard,omitempty"`
	// If range based sharding is used, range for the tablet's shard.
	KeyRange *KeyRange `protobuf:"bytes,7,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// type is the current type of the tablet.
	Type TabletType `protobuf:"varint,8,opt,name=type,proto3,enum=dolthub.vt.topodata.TabletType" json:"type,omitempty"`
	// It this is set, it is used as the database name instead of the
	// normal "vt_" + keyspace.
	DbNameOverride string `protobuf:"bytes,9,opt,name=db_name_override,json=dbNameOverride,proto3" json:"db_name_override,omitempty"`
	// tablet tags
	Tags map[string]string `protobuf:"bytes,10,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// MySQL hostname.
	MysqlHostname string `protobuf:"bytes,12,opt,name=mysql_hostname,json=mysqlHostname,proto3" json:"mysql_hostname,omitempty"`
	// MySQL port. Use topoproto.MysqlPort and topoproto.SetMysqlPort
	// to access this variable. The functions provide support
	// for legacy behavior.
	MysqlPort int32 `protobuf:"varint,13,opt,name=mysql_port,json=mysqlPort,proto3" json:"mysql_port,omitempty"`
	// master_term_start_time is the time (in UTC) at which the current term of
	// the current tablet began as master. If this tablet is not currently the
	// master, this value is ignored.
	//
	// A new master term begins any time an authoritative decision is communicated
	// about which tablet should be the master, such as via Vitess
	// replication-management commands like PlannedReparentShard,
	// EmergencyReparentShard, and TabletExternallyReparented.
	//
	MasterTermStartTime *vttime.Time `protobuf:"bytes,14,opt,name=master_term_start_time,json=masterTermStartTime,proto3" json:"master_term_start_time,omitempty"`
}

func (x *Tablet) Reset() {
	*x = Tablet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tablet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tablet) ProtoMessage() {}

func (x *Tablet) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tablet.ProtoReflect.Descriptor instead.
func (*Tablet) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{2}
}

func (x *Tablet) GetAlias() *TabletAlias {
	if x != nil {
		return x.Alias
	}
	return nil
}

func (x *Tablet) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *Tablet) GetPortMap() map[string]int32 {
	if x != nil {
		return x.PortMap
	}
	return nil
}

func (x *Tablet) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *Tablet) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

func (x *Tablet) GetKeyRange() *KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

func (x *Tablet) GetType() TabletType {
	if x != nil {
		return x.Type
	}
	return TabletType_UNKNOWN
}

func (x *Tablet) GetDbNameOverride() string {
	if x != nil {
		return x.DbNameOverride
	}
	return ""
}

func (x *Tablet) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Tablet) GetMysqlHostname() string {
	if x != nil {
		return x.MysqlHostname
	}
	return ""
}

func (x *Tablet) GetMysqlPort() int32 {
	if x != nil {
		return x.MysqlPort
	}
	return 0
}

func (x *Tablet) GetMasterTermStartTime() *vttime.Time {
	if x != nil {
		return x.MasterTermStartTime
	}
	return nil
}

// A Shard contains data about a subset of the data whithin a keyspace.
type Shard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// master_alias is the tablet alias of the master for the shard.
	// If it is unset, then there is no master in this shard yet.
	// No lock is necessary to update this field, when for instance
	// TabletExternallyReparented updates this. However, we lock the
	// shard for reparenting operations (InitShardMaster,
	// PlannedReparentShard,EmergencyReparentShard), to guarantee
	// exclusive operation.
	MasterAlias *TabletAlias `protobuf:"bytes,1,opt,name=master_alias,json=masterAlias,proto3" json:"master_alias,omitempty"`
	// master_term_start_time is the time (in UTC) at which the current term of
	// the master specified in master_alias began.
	//
	// A new master term begins any time an authoritative decision is communicated
	// about which tablet should be the master, such as via Vitess
	// replication-management commands like PlannedReparentShard,
	// EmergencyReparentShard, and TabletExternallyReparented.
	//
	// The master_alias should only ever be changed if the new master's term began
	// at a later time than this. Note that a new term can start for the tablet
	// that is already the master. In that case, the master_term_start_time would
	// be increased without changing the master_alias.
	MasterTermStartTime *vttime.Time `protobuf:"bytes,8,opt,name=master_term_start_time,json=masterTermStartTime,proto3" json:"master_term_start_time,omitempty"`
	// key_range is the KeyRange for this shard. It can be unset if:
	// - we are not using range-based sharding in this shard.
	// - the shard covers the entire keyrange.
	// This must match the shard name based on our other conventions, but
	// helpful to have it decomposed here.
	// Once set at creation time, it is never changed.
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// served_types has at most one entry per TabletType
	// This field is in the process of being deprecated in favor of
	// is_master_serving. Keeping for backwards compatibility purposes.
	ServedTypes []*Shard_ServedType `protobuf:"bytes,3,rep,name=served_types,json=servedTypes,proto3" json:"served_types,omitempty"`
	// SourceShards is the list of shards we're replicating from,
	// using filtered replication.
	// The keyspace lock is always taken when changing this.
	SourceShards []*Shard_SourceShard `protobuf:"bytes,4,rep,name=source_shards,json=sourceShards,proto3" json:"source_shards,omitempty"`
	// tablet_controls has at most one entry per TabletType.
	// The keyspace lock is always taken when changing this.
	TabletControls []*Shard_TabletControl `protobuf:"bytes,6,rep,name=tablet_controls,json=tabletControls,proto3" json:"tablet_controls,omitempty"`
	// is_master_serving sets whether this shard master is serving traffic or not.
	// The keyspace lock is always taken when changing this.
	IsMasterServing bool `protobuf:"varint,7,opt,name=is_master_serving,json=isMasterServing,proto3" json:"is_master_serving,omitempty"`
}

func (x *Shard) Reset() {
	*x = Shard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard) ProtoMessage() {}

func (x *Shard) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard.ProtoReflect.Descriptor instead.
func (*Shard) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{3}
}

func (x *Shard) GetMasterAlias() *TabletAlias {
	if x != nil {
		return x.MasterAlias
	}
	return nil
}

func (x *Shard) GetMasterTermStartTime() *vttime.Time {
	if x != nil {
		return x.MasterTermStartTime
	}
	return nil
}

func (x *Shard) GetKeyRange() *KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

func (x *Shard) GetServedTypes() []*Shard_ServedType {
	if x != nil {
		return x.ServedTypes
	}
	return nil
}

func (x *Shard) GetSourceShards() []*Shard_SourceShard {
	if x != nil {
		return x.SourceShards
	}
	return nil
}

func (x *Shard) GetTabletControls() []*Shard_TabletControl {
	if x != nil {
		return x.TabletControls
	}
	return nil
}

func (x *Shard) GetIsMasterServing() bool {
	if x != nil {
		return x.IsMasterServing
	}
	return false
}

// A Keyspace contains data about a keyspace.
type Keyspace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the column used for sharding
	// empty if the keyspace is not sharded
	ShardingColumnName string `protobuf:"bytes,1,opt,name=sharding_column_name,json=shardingColumnName,proto3" json:"sharding_column_name,omitempty"`
	// type of the column used for sharding
	// UNSET if the keyspace is not sharded
	ShardingColumnType KeyspaceIdType `protobuf:"varint,2,opt,name=sharding_column_type,json=shardingColumnType,proto3,enum=dolthub.vt.topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	// ServedFrom will redirect the appropriate traffic to
	// another keyspace.
	ServedFroms []*Keyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_froms,json=servedFroms,proto3" json:"served_froms,omitempty"`
	// keyspace_type will determine how this keyspace is treated by
	// vtgate / vschema. Normal keyspaces are routable by
	// any query. Snapshot keyspaces are only accessible
	// by explicit addresssing or by calling "use keyspace" first
	KeyspaceType KeyspaceType `protobuf:"varint,5,opt,name=keyspace_type,json=keyspaceType,proto3,enum=dolthub.vt.topodata.KeyspaceType" json:"keyspace_type,omitempty"`
	// base_keyspace is the base keyspace from which a snapshot
	// keyspace is created. empty for normal keyspaces
	BaseKeyspace string `protobuf:"bytes,6,opt,name=base_keyspace,json=baseKeyspace,proto3" json:"base_keyspace,omitempty"`
	// snapshot_time (in UTC) is a property of snapshot
	// keyspaces which tells us what point in time
	// the snapshot is of
	SnapshotTime *vttime.Time `protobuf:"bytes,7,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
}

func (x *Keyspace) Reset() {
	*x = Keyspace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Keyspace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Keyspace) ProtoMessage() {}

func (x *Keyspace) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Keyspace.ProtoReflect.Descriptor instead.
func (*Keyspace) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{4}
}

func (x *Keyspace) GetShardingColumnName() string {
	if x != nil {
		return x.ShardingColumnName
	}
	return ""
}

func (x *Keyspace) GetShardingColumnType() KeyspaceIdType {
	if x != nil {
		return x.ShardingColumnType
	}
	return KeyspaceIdType_UNSET
}

func (x *Keyspace) GetServedFroms() []*Keyspace_ServedFrom {
	if x != nil {
		return x.ServedFroms
	}
	return nil
}

func (x *Keyspace) GetKeyspaceType() KeyspaceType {
	if x != nil {
		return x.KeyspaceType
	}
	return KeyspaceType_NORMAL
}

func (x *Keyspace) GetBaseKeyspace() string {
	if x != nil {
		return x.BaseKeyspace
	}
	return ""
}

func (x *Keyspace) GetSnapshotTime() *vttime.Time {
	if x != nil {
		return x.SnapshotTime
	}
	return nil
}

// ShardReplication describes the MySQL replication relationships
// whithin a cell.
type ShardReplication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Note there can be only one Node in this array
	// for a given tablet.
	Nodes []*ShardReplication_Node `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
}

func (x *ShardReplication) Reset() {
	*x = ShardReplication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardReplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardReplication) ProtoMessage() {}

func (x *ShardReplication) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardReplication.ProtoReflect.Descriptor instead.
func (*ShardReplication) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{5}
}

func (x *ShardReplication) GetNodes() []*ShardReplication_Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// ShardReference is used as a pointer from a SrvKeyspace to a Shard
type ShardReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Copied from Shard.
	Name     string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"` // Disable query serving in this shard
}

func (x *ShardReference) Reset() {
	*x = ShardReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardReference) ProtoMessage() {}

func (x *ShardReference) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardReference.ProtoReflect.Descriptor instead.
func (*ShardReference) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{6}
}

func (x *ShardReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ShardReference) GetKeyRange() *KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

// ShardTabletControl is used as a pointer from a SrvKeyspace to a Shard
type ShardTabletControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Copied from Shard.
	Name     string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// Disable query serving in this shard
	QueryServiceDisabled bool `protobuf:"varint,3,opt,name=query_service_disabled,json=queryServiceDisabled,proto3" json:"query_service_disabled,omitempty"`
}

func (x *ShardTabletControl) Reset() {
	*x = ShardTabletControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardTabletControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardTabletControl) ProtoMessage() {}

func (x *ShardTabletControl) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardTabletControl.ProtoReflect.Descriptor instead.
func (*ShardTabletControl) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{7}
}

func (x *ShardTabletControl) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ShardTabletControl) GetKeyRange() *KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

func (x *ShardTabletControl) GetQueryServiceDisabled() bool {
	if x != nil {
		return x.QueryServiceDisabled
	}
	return false
}

// SrvKeyspace is a rollup node for the keyspace itself.
type SrvKeyspace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The partitions this keyspace is serving, per tablet type.
	Partitions []*SrvKeyspace_KeyspacePartition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// copied from Keyspace
	ShardingColumnName string                    `protobuf:"bytes,2,opt,name=sharding_column_name,json=shardingColumnName,proto3" json:"sharding_column_name,omitempty"`
	ShardingColumnType KeyspaceIdType            `protobuf:"varint,3,opt,name=sharding_column_type,json=shardingColumnType,proto3,enum=dolthub.vt.topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	ServedFrom         []*SrvKeyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_from,json=servedFrom,proto3" json:"served_from,omitempty"`
}

func (x *SrvKeyspace) Reset() {
	*x = SrvKeyspace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SrvKeyspace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SrvKeyspace) ProtoMessage() {}

func (x *SrvKeyspace) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SrvKeyspace.ProtoReflect.Descriptor instead.
func (*SrvKeyspace) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{8}
}

func (x *SrvKeyspace) GetPartitions() []*SrvKeyspace_KeyspacePartition {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *SrvKeyspace) GetShardingColumnName() string {
	if x != nil {
		return x.ShardingColumnName
	}
	return ""
}

func (x *SrvKeyspace) GetShardingColumnType() KeyspaceIdType {
	if x != nil {
		return x.ShardingColumnType
	}
	return KeyspaceIdType_UNSET
}

func (x *SrvKeyspace) GetServedFrom() []*SrvKeyspace_ServedFrom {
	if x != nil {
		return x.ServedFrom
	}
	return nil
}

// CellInfo contains information about a cell. CellInfo objects are
// stored in the global topology server, and describe how to reach
// local topology servers.
type CellInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ServerAddress contains the address of the server for the cell.
	// The syntax of this field is topology implementation specific.
	// For instance, for Zookeeper, it is a comma-separated list of
	// server addresses.
	ServerAddress string `protobuf:"bytes,1,opt,name=server_address,json=serverAddress,proto3" json:"server_address,omitempty"`
	// Root is the path to store data in. It is only used when talking
	// to server_address.
	Root string `protobuf:"bytes,2,opt,name=root,proto3" json:"root,omitempty"`
}

func (x *CellInfo) Reset() {
	*x = CellInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CellInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CellInfo) ProtoMessage() {}

func (x *CellInfo) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CellInfo.ProtoReflect.Descriptor instead.
func (*CellInfo) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{9}
}

func (x *CellInfo) GetServerAddress() string {
	if x != nil {
		return x.ServerAddress
	}
	return ""
}

func (x *CellInfo) GetRoot() string {
	if x != nil {
		return x.Root
	}
	return ""
}

// CellsAlias
type CellsAlias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cells that map to this alias
	Cells []string `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
}

func (x *CellsAlias) Reset() {
	*x = CellsAlias{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CellsAlias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CellsAlias) ProtoMessage() {}

func (x *CellsAlias) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CellsAlias.ProtoReflect.Descriptor instead.
func (*CellsAlias) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{10}
}

func (x *CellsAlias) GetCells() []string {
	if x != nil {
		return x.Cells
	}
	return nil
}

// ServedType is an entry in the served_types
type Shard_ServedType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	Cells      []string   `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
}

func (x *Shard_ServedType) Reset() {
	*x = Shard_ServedType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shard_ServedType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard_ServedType) ProtoMessage() {}

func (x *Shard_ServedType) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard_ServedType.ProtoReflect.Descriptor instead.
func (*Shard_ServedType) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Shard_ServedType) GetTabletType() TabletType {
	if x != nil {
		return x.TabletType
	}
	return TabletType_UNKNOWN
}

func (x *Shard_ServedType) GetCells() []string {
	if x != nil {
		return x.Cells
	}
	return nil
}

// SourceShard represents a data source for filtered replication
// across shards. When this is used in a destination shard, the master
// of that shard will run filtered replication.
type Shard_SourceShard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uid is the unique ID for this SourceShard object.
	Uid uint32 `protobuf:"varint,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// the source keyspace
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// the source shard
	Shard string `protobuf:"bytes,3,opt,name=shard,proto3" json:"shard,omitempty"`
	// the source shard keyrange
	KeyRange *KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// the source table list to replicate
	Tables []string `protobuf:"bytes,5,rep,name=tables,proto3" json:"tables,omitempty"`
}

func (x *Shard_SourceShard) Reset() {
	*x = Shard_SourceShard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shard_SourceShard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard_SourceShard) ProtoMessage() {}

func (x *Shard_SourceShard) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard_SourceShard.ProtoReflect.Descriptor instead.
func (*Shard_SourceShard) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{3, 1}
}

func (x *Shard_SourceShard) GetUid() uint32 {
	if x != nil {
		return x.Uid
	}
	return 0
}

func (x *Shard_SourceShard) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *Shard_SourceShard) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

func (x *Shard_SourceShard) GetKeyRange() *KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

func (x *Shard_SourceShard) GetTables() []string {
	if x != nil {
		return x.Tables
	}
	return nil
}

// TabletControl controls tablet's behavior
type Shard_TabletControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// which tablet type is affected
	TabletType        TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	Cells             []string   `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	BlacklistedTables []string   `protobuf:"bytes,4,rep,name=blacklisted_tables,json=blacklistedTables,proto3" json:"blacklisted_tables,omitempty"`
	// frozen is set if we've started failing over traffic for
	// the master. If set, this record should not be removed.
	Frozen bool `protobuf:"varint,5,opt,name=frozen,proto3" json:"frozen,omitempty"`
}

func (x *Shard_TabletControl) Reset() {
	*x = Shard_TabletControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shard_TabletControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard_TabletControl) ProtoMessage() {}

func (x *Shard_TabletControl) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard_TabletControl.ProtoReflect.Descriptor instead.
func (*Shard_TabletControl) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{3, 2}
}

func (x *Shard_TabletControl) GetTabletType() TabletType {
	if x != nil {
		return x.TabletType
	}
	return TabletType_UNKNOWN
}

func (x *Shard_TabletControl) GetCells() []string {
	if x != nil {
		return x.Cells
	}
	return nil
}

func (x *Shard_TabletControl) GetBlacklistedTables() []string {
	if x != nil {
		return x.BlacklistedTables
	}
	return nil
}

func (x *Shard_TabletControl) GetFrozen() bool {
	if x != nil {
		return x.Frozen
	}
	return false
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type Keyspace_ServedFrom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the tablet type (key for the map)
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// the cells to limit this to
	Cells []string `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	// the keyspace name that's serving it
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
}

func (x *Keyspace_ServedFrom) Reset() {
	*x = Keyspace_ServedFrom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Keyspace_ServedFrom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Keyspace_ServedFrom) ProtoMessage() {}

func (x *Keyspace_ServedFrom) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Keyspace_ServedFrom.ProtoReflect.Descriptor instead.
func (*Keyspace_ServedFrom) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Keyspace_ServedFrom) GetTabletType() TabletType {
	if x != nil {
		return x.TabletType
	}
	return TabletType_UNKNOWN
}

func (x *Keyspace_ServedFrom) GetCells() []string {
	if x != nil {
		return x.Cells
	}
	return nil
}

func (x *Keyspace_ServedFrom) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

// Node describes a tablet instance within the cell
type ShardReplication_Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TabletAlias *TabletAlias `protobuf:"bytes,1,opt,name=tablet_alias,json=tabletAlias,proto3" json:"tablet_alias,omitempty"`
}

func (x *ShardReplication_Node) Reset() {
	*x = ShardReplication_Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardReplication_Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardReplication_Node) ProtoMessage() {}

func (x *ShardReplication_Node) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardReplication_Node.ProtoReflect.Descriptor instead.
func (*ShardReplication_Node) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ShardReplication_Node) GetTabletAlias() *TabletAlias {
	if x != nil {
		return x.TabletAlias
	}
	return nil
}

type SrvKeyspace_KeyspacePartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type this partition applies to.
	ServedType TabletType `protobuf:"varint,1,opt,name=served_type,json=servedType,proto3,enum=dolthub.vt.topodata.TabletType" json:"served_type,omitempty"`
	// List of non-overlapping continuous shards sorted by range.
	ShardReferences []*ShardReference `protobuf:"bytes,2,rep,name=shard_references,json=shardReferences,proto3" json:"shard_references,omitempty"`
	// List of shard tablet controls
	ShardTabletControls []*ShardTabletControl `protobuf:"bytes,3,rep,name=shard_tablet_controls,json=shardTabletControls,proto3" json:"shard_tablet_controls,omitempty"`
}

func (x *SrvKeyspace_KeyspacePartition) Reset() {
	*x = SrvKeyspace_KeyspacePartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SrvKeyspace_KeyspacePartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SrvKeyspace_KeyspacePartition) ProtoMessage() {}

func (x *SrvKeyspace_KeyspacePartition) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SrvKeyspace_KeyspacePartition.ProtoReflect.Descriptor instead.
func (*SrvKeyspace_KeyspacePartition) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{8, 0}
}

func (x *SrvKeyspace_KeyspacePartition) GetServedType() TabletType {
	if x != nil {
		return x.ServedType
	}
	return TabletType_UNKNOWN
}

func (x *SrvKeyspace_KeyspacePartition) GetShardReferences() []*ShardReference {
	if x != nil {
		return x.ShardReferences
	}
	return nil
}

func (x *SrvKeyspace_KeyspacePartition) GetShardTabletControls() []*ShardTabletControl {
	if x != nil {
		return x.ShardTabletControls
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type SrvKeyspace_ServedFrom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the tablet type
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// the keyspace name that's serving it
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
}

func (x *SrvKeyspace_ServedFrom) Reset() {
	*x = SrvKeyspace_ServedFrom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_topodata_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SrvKeyspace_ServedFrom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SrvKeyspace_ServedFrom) ProtoMessage() {}

func (x *SrvKeyspace_ServedFrom) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_topodata_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SrvKeyspace_ServedFrom.ProtoReflect.Descriptor instead.
func (*SrvKeyspace_ServedFrom) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_topodata_proto_rawDescGZIP(), []int{8, 1}
}

func (x *SrvKeyspace_ServedFrom) GetTabletType() TabletType {
	if x != nil {
		return x.TabletType
	}
	return TabletType_UNKNOWN
}

func (x *SrvKeyspace_ServedFrom) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

var File_dolthub_vt_topodata_proto protoreflect.FileDescriptor

var file_dolthub_vt_topodata_proto_rawDesc = []byte{
	0x0a, 0x19, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x74, 0x6f, 0x70,
	0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61,
	0x1a, 0x15, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x32, 0x0a, 0x08, 0x4b, 0x65, 0x79, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0x33, 0x0a, 0x0b, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x65,
	0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x65, 0x6c, 0x6c, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x22, 0xbe, 0x05, 0x0a, 0x06, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x05, 0x61,
	0x6c, 0x69, 0x61, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x52, 0x05, 0x61, 0x6c,
	0x69, 0x61, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x43, 0x0a, 0x08, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74,
	0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x2e, 0x50,
	0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x70, 0x6f, 0x72,
	0x74, 0x4d, 0x61, 0x70, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x3a, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x33, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f,
	0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x64, 0x62, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x64, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x12, 0x39, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70,
	0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x2e, 0x54, 0x61, 0x67,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x50, 0x6f,
	0x72, 0x74, 0x12, 0x4c, 0x0a, 0x16, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x72,
	0x6d, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x76, 0x74, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x13, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x54, 0x65, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x1a, 0x3a, 0x0a, 0x0c, 0x50, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09,
	0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x0b, 0x10,
	0x0c, 0x22, 0xb7, 0x07, 0x0a, 0x05, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x43, 0x0a, 0x0c, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74,
	0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x41, 0x6c,
	0x69, 0x61, 0x73, 0x52, 0x0b, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x6c, 0x69, 0x61, 0x73,
	0x12, 0x4c, 0x0a, 0x16, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x13, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x54, 0x65, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74,
	0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x08, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x48, 0x0a, 0x0c, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f,
	0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x73, 0x12, 0x51, 0x0a, 0x0f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x52, 0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x69, 0x73, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x69, 0x73, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67,
	0x1a, 0x64, 0x0a, 0x0a, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x1a, 0xa5, 0x01, 0x0a, 0x0b, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x3a, 0x0a, 0x09, 0x6b, 0x65,
	0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x08, 0x6b, 0x65,
	0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x1a, 0xb4,
	0x01, 0x0a, 0x0d, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x62, 0x6c, 0x61, 0x63,
	0x6b, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x6c, 0x69, 0x73, 0x74, 0x65,
	0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x72, 0x6f, 0x7a, 0x65,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x66, 0x72, 0x6f, 0x7a, 0x65, 0x6e, 0x4a,
	0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x22, 0x94, 0x04, 0x0a, 0x08,
	0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x14, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b,
	0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65,
	0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64, 0x46, 0x72, 0x6f,
	0x6d, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x73, 0x12, 0x46,
	0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x62,
	0x61, 0x73, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x0d, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x76, 0x74, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x0c, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x80, 0x01, 0x0a, 0x0a, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x65,
	0x6c, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4a, 0x04, 0x08, 0x03,
	0x10, 0x04, 0x22, 0xa1, 0x01, 0x0a, 0x10, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x1a, 0x4b, 0x0a, 0x04, 0x4e, 0x6f, 0x64,
	0x65, 0x12, 0x43, 0x0a, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x61, 0x6c, 0x69, 0x61,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x52, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x22, 0x60, 0x0a, 0x0e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x09,
	0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70,
	0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x08,
	0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x12, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x34, 0x0a, 0x16, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xaf, 0x05, 0x0a, 0x0b, 0x53, 0x72, 0x76, 0x4b, 0x65, 0x79,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x53, 0x72, 0x76, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x4b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x14, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f,
	0x6d, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x72,
	0x76, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64,
	0x46, 0x72, 0x6f, 0x6d, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d,
	0x1a, 0x82, 0x02, 0x0a, 0x11, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4e, 0x0a, 0x10, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x15, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x52, 0x13, 0x73, 0x68, 0x61, 0x72, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x73, 0x1a, 0x6a, 0x0a, 0x0a, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64, 0x46,
	0x72, 0x6f, 0x6d, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x22, 0x4b, 0x0a, 0x08, 0x43, 0x65, 0x6c, 0x6c, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f,
	0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x4a, 0x04,
	0x08, 0x03, 0x10, 0x04, 0x22, 0x22, 0x0a, 0x0a, 0x43, 0x65, 0x6c, 0x6c, 0x73, 0x41, 0x6c, 0x69,
	0x61, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x2a, 0x28, 0x0a, 0x0c, 0x4b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d,
	0x41, 0x4c, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54,
	0x10, 0x01, 0x2a, 0x32, 0x0a, 0x0e, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x4e, 0x53, 0x45, 0x54, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x55, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x42,
	0x59, 0x54, 0x45, 0x53, 0x10, 0x02, 0x2a, 0x90, 0x01, 0x0a, 0x0a, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x52,
	0x44, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x54, 0x43, 0x48,
	0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x50, 0x41, 0x52, 0x45, 0x10, 0x04, 0x12, 0x10, 0x0a,
	0x0c, 0x45, 0x58, 0x50, 0x45, 0x52, 0x49, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0x05, 0x12,
	0x0a, 0x0a, 0x06, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x52, 0x41, 0x49,
	0x4e, 0x45, 0x44, 0x10, 0x08, 0x1a, 0x02, 0x10, 0x01, 0x42, 0x41, 0x0a, 0x0f, 0x69, 0x6f, 0x2e,
	0x76, 0x69, 0x74, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5a, 0x2e, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2f, 0x76, 0x69, 0x74, 0x65, 0x73, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x74, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_dolthub_vt_topodata_proto_rawDescOnce sync.Once
	file_dolthub_vt_topodata_proto_rawDescData = file_dolthub_vt_topodata_proto_rawDesc
)

func file_dolthub_vt_topodata_proto_rawDescGZIP() []byte {
	file_dolthub_vt_topodata_proto_rawDescOnce.Do(func() {
		file_dolthub_vt_topodata_proto_rawDescData = protoimpl.X.CompressGZIP(file_dolthub_vt_topodata_proto_rawDescData)
	})
	return file_dolthub_vt_topodata_proto_rawDescData
}

var file_dolthub_vt_topodata_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_dolthub_vt_topodata_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_dolthub_vt_topodata_proto_goTypes = []interface{}{
	(KeyspaceType)(0),                     // 0: dolthub.vt.topodata.KeyspaceType
	(KeyspaceIdType)(0),                   // 1: dolthub.vt.topodata.KeyspaceIdType
	(TabletType)(0),                       // 2: dolthub.vt.topodata.TabletType
	(*KeyRange)(nil),                      // 3: dolthub.vt.topodata.KeyRange
	(*TabletAlias)(nil),                   // 4: dolthub.vt.topodata.TabletAlias
	(*Tablet)(nil),                        // 5: dolthub.vt.topodata.Tablet
	(*Shard)(nil),                         // 6: dolthub.vt.topodata.Shard
	(*Keyspace)(nil),                      // 7: dolthub.vt.topodata.Keyspace
	(*ShardReplication)(nil),              // 8: dolthub.vt.topodata.ShardReplication
	(*ShardReference)(nil),                // 9: dolthub.vt.topodata.ShardReference
	(*ShardTabletControl)(nil),            // 10: dolthub.vt.topodata.ShardTabletControl
	(*SrvKeyspace)(nil),                   // 11: dolthub.vt.topodata.SrvKeyspace
	(*CellInfo)(nil),                      // 12: dolthub.vt.topodata.CellInfo
	(*CellsAlias)(nil),                    // 13: dolthub.vt.topodata.CellsAlias
	nil,                                   // 14: dolthub.vt.topodata.Tablet.PortMapEntry
	nil,                                   // 15: dolthub.vt.topodata.Tablet.TagsEntry
	(*Shard_ServedType)(nil),              // 16: dolthub.vt.topodata.Shard.ServedType
	(*Shard_SourceShard)(nil),             // 17: dolthub.vt.topodata.Shard.SourceShard
	(*Shard_TabletControl)(nil),           // 18: dolthub.vt.topodata.Shard.TabletControl
	(*Keyspace_ServedFrom)(nil),           // 19: dolthub.vt.topodata.Keyspace.ServedFrom
	(*ShardReplication_Node)(nil),         // 20: dolthub.vt.topodata.ShardReplication.Node
	(*SrvKeyspace_KeyspacePartition)(nil), // 21: dolthub.vt.topodata.SrvKeyspace.KeyspacePartition
	(*SrvKeyspace_ServedFrom)(nil),        // 22: dolthub.vt.topodata.SrvKeyspace.ServedFrom
	(*vttime.Time)(nil),                   // 23: dolthub.vt.vttime.Time
}
var file_dolthub_vt_topodata_proto_depIdxs = []int32{
	4,  // 0: dolthub.vt.topodata.Tablet.alias:type_name -> dolthub.vt.topodata.TabletAlias
	14, // 1: dolthub.vt.topodata.Tablet.port_map:type_name -> dolthub.vt.topodata.Tablet.PortMapEntry
	3,  // 2: dolthub.vt.topodata.Tablet.key_range:type_name -> dolthub.vt.topodata.KeyRange
	2,  // 3: dolthub.vt.topodata.Tablet.type:type_name -> dolthub.vt.topodata.TabletType
	15, // 4: dolthub.vt.topodata.Tablet.tags:type_name -> dolthub.vt.topodata.Tablet.TagsEntry
	23, // 5: dolthub.vt.topodata.Tablet.master_term_start_time:type_name -> dolthub.vt.vttime.Time
	4,  // 6: dolthub.vt.topodata.Shard.master_alias:type_name -> dolthub.vt.topodata.TabletAlias
	23, // 7: dolthub.vt.topodata.Shard.master_term_start_time:type_name -> dolthub.vt.vttime.Time
	3,  // 8: dolthub.vt.topodata.Shard.key_range:type_name -> dolthub.vt.topodata.KeyRange
	16, // 9: dolthub.vt.topodata.Shard.served_types:type_name -> dolthub.vt.topodata.Shard.ServedType
	17, // 10: dolthub.vt.topodata.Shard.source_shards:type_name -> dolthub.vt.topodata.Shard.SourceShard
	18, // 11: dolthub.vt.topodata.Shard.tablet_controls:type_name -> dolthub.vt.topodata.Shard.TabletControl
	1,  // 12: dolthub.vt.topodata.Keyspace.sharding_column_type:type_name -> dolthub.vt.topodata.KeyspaceIdType
	19, // 13: dolthub.vt.topodata.Keyspace.served_froms:type_name -> dolthub.vt.topodata.Keyspace.ServedFrom
	0,  // 14: dolthub.vt.topodata.Keyspace.keyspace_type:type_name -> dolthub.vt.topodata.KeyspaceType
	23, // 15: dolthub.vt.topodata.Keyspace.snapshot_time:type_name -> dolthub.vt.vttime.Time
	20, // 16: dolthub.vt.topodata.ShardReplication.nodes:type_name -> dolthub.vt.topodata.ShardReplication.Node
	3,  // 17: dolthub.vt.topodata.ShardReference.key_range:type_name -> dolthub.vt.topodata.KeyRange
	3,  // 18: dolthub.vt.topodata.ShardTabletControl.key_range:type_name -> dolthub.vt.topodata.KeyRange
	21, // 19: dolthub.vt.topodata.SrvKeyspace.partitions:type_name -> dolthub.vt.topodata.SrvKeyspace.KeyspacePartition
	1,  // 20: dolthub.vt.topodata.SrvKeyspace.sharding_column_type:type_name -> dolthub.vt.topodata.KeyspaceIdType
	22, // 21: dolthub.vt.topodata.SrvKeyspace.served_from:type_name -> dolthub.vt.topodata.SrvKeyspace.ServedFrom
	2,  // 22: dolthub.vt.topodata.Shard.ServedType.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	3,  // 23: dolthub.vt.topodata.Shard.SourceShard.key_range:type_name -> dolthub.vt.topodata.KeyRange
	2,  // 24: dolthub.vt.topodata.Shard.TabletControl.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	2,  // 25: dolthub.vt.topodata.Keyspace.ServedFrom.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	4,  // 26: dolthub.vt.topodata.ShardReplication.Node.tablet_alias:type_name -> dolthub.vt.topodata.TabletAlias
	2,  // 27: dolthub.vt.topodata.SrvKeyspace.KeyspacePartition.served_type:type_name -> dolthub.vt.topodata.TabletType
	9,  // 28: dolthub.vt.topodata.SrvKeyspace.KeyspacePartition.shard_references:type_name -> dolthub.vt.topodata.ShardReference
	10, // 29: dolthub.vt.topodata.SrvKeyspace.KeyspacePartition.shard_tablet_controls:type_name -> dolthub.vt.topodata.ShardTabletControl
	2,  // 30: dolthub.vt.topodata.SrvKeyspace.ServedFrom.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_dolthub_vt_topodata_proto_init() }
func file_dolthub_vt_topodata_proto_init() {
	if File_dolthub_vt_topodata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_dolthub_vt_topodata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TabletAlias); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tablet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Keyspace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardReplication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardTabletControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SrvKeyspace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CellInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CellsAlias); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shard_ServedType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shard_SourceShard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shard_TabletControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Keyspace_ServedFrom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardReplication_Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SrvKeyspace_KeyspacePartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_topodata_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SrvKeyspace_ServedFrom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_dolthub_vt_topodata_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_dolthub_vt_topodata_proto_goTypes,
		DependencyIndexes: file_dolthub_vt_topodata_proto_depIdxs,
		EnumInfos:         file_dolthub_vt_topodata_proto_enumTypes,
		MessageInfos:      file_dolthub_vt_topodata_proto_msgTypes,
	}.Build()
	File_dolthub_vt_topodata_proto = out.File
	file_dolthub_vt_topodata_proto_rawDesc = nil
	file_dolthub_vt_topodata_proto_goTypes = nil
	file_dolthub_vt_topodata_proto_depIdxs = nil
}
