// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package information_schema

type UnitOfMeasure struct {
	Name             string
	Type             string
	Description      string
	ConversionFactor float64
}

var unitsOfMeasureArray = [47]UnitOfMeasure{
	{"British chain (Sears 1922 truncated)", "LINEAR", "", 20.116756},
	{"British foot (Sears 1922 truncated)", "LINEAR", "", 0.30479933333333337},
	{"chain", "LINEAR", "", 20.1168},
	{"yard", "LINEAR", "", 0.9144},
	{"British foot (1936)", "LINEAR", "", 0.3048007491},
	{"British link (Sears 1922 truncated)", "LINEAR", "", 0.20116756},
	{"Gold Coast foot", "LINEAR", "", 0.3047997101815088},
	{"Indian yard (1937)", "LINEAR", "", 0.91439523},
	{"link", "LINEAR", "", 0.201168},
	{"Indian yard", "LINEAR", "", 0.9143985307444408},
	{"Indian yard (1975)", "LINEAR", "", 0.9143985},
	{"Indian yard (1962)", "LINEAR", "", 0.9143988},
	{"Indian foot (1975)", "LINEAR", "", 0.3047995},
	{"Indian foot (1937)", "LINEAR", "", 0.30479841},
	{"Indian foot", "LINEAR", "", 0.30479951024814694},
	{"Indian foot (1962)", "LINEAR", "", 0.3047996},
	{"British foot (1865)", "LINEAR", "", 0.30480083333333335},
	{"British link (Benoit 1895 B)", "LINEAR", "", 0.2011678249437587},
	{"Statute mile", "LINEAR", "", 1609.344},
	{"British chain (Benoit 1895 B)", "LINEAR", "", 20.116782494375872},
	{"British foot (Benoit 1895 B)", "LINEAR", "", 0.30479973476327077},
	{"British link (Benoit 1895 A)", "LINEAR", "", 0.201167824},
	{"British yard (Sears 1922 truncated)", "LINEAR", "", 0.914398},
	{"British yard (Benoit 1895 B)", "LINEAR", "", 0.9143992042898124},
	{"foot", "LINEAR", "", 0.3048},
	{"British foot (Benoit 1895 A)", "LINEAR", "", 0.3047997333333333},
	{"British yard (Benoit 1895 A)", "LINEAR", "", 0.9143992},
	{"British chain (Sears 1922)", "LINEAR", "", 20.116765121552632},
	{"Clarke's link", "LINEAR", "", 0.201166195164},
	{"Clarke's chain", "LINEAR", "", 20.1166195164},
	{"British chain (Benoit 1895 A)", "LINEAR", "", 20.1167824},
	{"Clarke's yard", "LINEAR", "", 0.9143917962},
	{"US survey foot", "LINEAR", "", 0.30480060960121924},
	{"kilometre", "LINEAR", "", 1000},
	{"centimetre", "LINEAR", "", 0.01},
	{"British yard (Sears 1922)", "LINEAR", "", 0.9143984146160288},
	{"US survey mile", "LINEAR", "", 1609.3472186944375},
	{"metre", "LINEAR", "", 1},
	{"US survey link", "LINEAR", "", 0.2011684023368047},
	{"nautical mile", "LINEAR", "", 1852},
	{"British foot (Sears 1922)", "LINEAR", "", 0.3047994715386762},
	{"British link (Sears 1922)", "LINEAR", "", 0.2011676512155263},
	{"fathom", "LINEAR", "", 1.8288},
	{"US survey chain", "LINEAR", "", 20.11684023368047},
	{"German legal metre", "LINEAR", "", 1.0000135965},
	{"Clarke's foot", "LINEAR", "", 0.3047972654},
	{"millimetre", "LINEAR", "", 0.001},
}

type Keyword struct {
	Word     string
	Reserved int32
}

var keywordsArray = [747]Keyword{
	{"ACCESSIBLE", 1},
	{"ACCOUNT", 0},
	{"ACTION", 0},
	{"ACTIVE", 0},
	{"ADD", 1},
	{"ADMIN", 0},
	{"AFTER", 0},
	{"AGAINST", 0},
	{"AGGREGATE", 0},
	{"ALGORITHM", 0},
	{"ALL", 1},
	{"ALTER", 1},
	{"ALWAYS", 0},
	{"ANALYZE", 1},
	{"AND", 1},
	{"ANY", 0},
	{"ARRAY", 0},
	{"AS", 1},
	{"ASC", 1},
	{"ASCII", 0},
	{"ASENSITIVE", 1},
	{"ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS", 0},
	{"AT", 0},
	{"ATTRIBUTE", 0},
	{"AUTHENTICATION", 0},
	{"AUTO_INCREMENT", 0},
	{"AUTOEXTEND_SIZE", 0},
	{"AVG", 0},
	{"AVG_ROW_LENGTH", 0},
	{"BACKUP", 0},
	{"BEFORE", 1},
	{"BEGIN", 0},
	{"BETWEEN", 1},
	{"BIGINT", 1},
	{"BINARY", 1},
	{"BINLOG", 0},
	{"BIT", 0},
	{"BLOB", 1},
	{"BLOCK", 0},
	{"BOOL", 0},
	{"BOOLEAN", 0},
	{"BOTH", 1},
	{"BTREE", 0},
	{"BUCKETS", 0},
	{"BY", 1},
	{"BYTE", 0},
	{"CACHE", 0},
	{"CALL", 1},
	{"CASCADE", 1},
	{"CASCADED", 0},
	{"CASE", 1},
	{"CATALOG_NAME", 0},
	{"CHAIN", 0},
	{"CHALLENGE_RESPONSE", 0},
	{"CHANGE", 1},
	{"CHANGED", 0},
	{"CHANNEL", 0},
	{"CHAR", 1},
	{"CHARACTER", 1},
	{"CHARSET", 0},
	{"CHECK", 1},
	{"CHECKSUM", 0},
	{"CIPHER", 0},
	{"CLASS_ORIGIN", 0},
	{"CLIENT", 0},
	{"CLONE", 0},
	{"CLOSE", 0},
	{"COALESCE", 0},
	{"CODE", 0},
	{"COLLATE", 1},
	{"COLLATION", 0},
	{"COLUMN", 1},
	{"COLUMN_FORMAT", 0},
	{"COLUMN_NAME", 0},
	{"COLUMNS", 0},
	{"COMMENT", 0},
	{"COMMIT", 0},
	{"COMMITTED", 0},
	{"COMPACT", 0},
	{"COMPLETION", 0},
	{"COMPONENT", 0},
	{"COMPRESSED", 0},
	{"COMPRESSION", 0},
	{"CONCURRENT", 0},
	{"CONDITION", 1},
	{"CONNECTION", 0},
	{"CONSISTENT", 0},
	{"CONSTRAINT", 1},
	{"CONSTRAINT_CATALOG", 0},
	{"CONSTRAINT_NAME", 0},
	{"CONSTRAINT_SCHEMA", 0},
	{"CONTAINS", 0},
	{"CONTEXT", 0},
	{"CONTINUE", 1},
	{"CONVERT", 1},
	{"CPU", 0},
	{"CREATE", 1},
	{"CROSS", 1},
	{"CUBE", 1},
	{"CUME_DIST", 1},
	{"CURRENT", 0},
	{"CURRENT_DATE", 1},
	{"CURRENT_TIME", 1},
	{"CURRENT_TIMESTAMP", 1},
	{"CURRENT_USER", 1},
	{"CURSOR", 1},
	{"CURSOR_NAME", 0},
	{"DATA", 0},
	{"DATABASE", 1},
	{"DATABASES", 1},
	{"DATAFILE", 0},
	{"DATE", 0},
	{"DATETIME", 0},
	{"DAY", 0},
	{"DAY_HOUR", 1},
	{"DAY_MICROSECOND", 1},
	{"DAY_MINUTE", 1},
	{"DAY_SECOND", 1},
	{"DEALLOCATE", 0},
	{"DEC", 1},
	{"DECIMAL", 1},
	{"DECLARE", 1},
	{"DEFAULT", 1},
	{"DEFAULT_AUTH", 0},
	{"DEFINER", 0},
	{"DEFINITION", 0},
	{"DELAY_KEY_WRITE", 0},
	{"DELAYED", 1},
	{"DELETE", 1},
	{"DENSE_RANK", 1},
	{"DESC", 1},
	{"DESCRIBE", 1},
	{"DESCRIPTION", 0},
	{"DETERMINISTIC", 1},
	{"DIAGNOSTICS", 0},
	{"DIRECTORY", 0},
	{"DISABLE", 0},
	{"DISCARD", 0},
	{"DISK", 0},
	{"DISTINCT", 1},
	{"DISTINCTROW", 1},
	{"DIV", 1},
	{"DO", 0},
	{"DOUBLE", 1},
	{"DROP", 1},
	{"DUAL", 1},
	{"DUMPFILE", 0},
	{"DUPLICATE", 0},
	{"DYNAMIC", 0},
	{"EACH", 1},
	{"ELSE", 1},
	{"ELSEIF", 1},
	{"EMPTY", 1},
	{"ENABLE", 0},
	{"ENCLOSED", 1},
	{"ENCRYPTION", 0},
	{"END", 0},
	{"ENDS", 0},
	{"ENFORCED", 0},
	{"ENGINE", 0},
	{"ENGINE_ATTRIBUTE", 0},
	{"ENGINES", 0},
	{"ENUM", 0},
	{"ERROR", 0},
	{"ERRORS", 0},
	{"ESCAPE", 0},
	{"ESCAPED", 1},
	{"EVENT", 0},
	{"EVENTS", 0},
	{"EVERY", 0},
	{"EXCEPT", 1},
	{"EXCHANGE", 0},
	{"EXCLUDE", 0},
	{"EXECUTE", 0},
	{"EXISTS", 1},
	{"EXIT", 1},
	{"EXPANSION", 0},
	{"EXPIRE", 0},
	{"EXPLAIN", 1},
	{"EXPORT", 0},
	{"EXTENDED", 0},
	{"EXTENT_SIZE", 0},
	{"FACTOR", 0},
	{"FAILED_LOGIN_ATTEMPTS", 0},
	{"FALSE", 1},
	{"FAST", 0},
	{"FAULTS", 0},
	{"FETCH", 1},
	{"FIELDS", 0},
	{"FILE", 0},
	{"FILE_BLOCK_SIZE", 0},
	{"FILTER", 0},
	{"FINISH", 0},
	{"FIRST", 0},
	{"FIRST_VALUE", 1},
	{"FIXED", 0},
	{"FLOAT", 1},
	{"FLOAT4", 1},
	{"FLOAT8", 1},
	{"FLUSH", 0},
	{"FOLLOWING", 0},
	{"FOLLOWS", 0},
	{"FOR", 1},
	{"FORCE", 1},
	{"FOREIGN", 1},
	{"FORMAT", 0},
	{"FOUND", 0},
	{"FROM", 1},
	{"FULL", 0},
	{"FULLTEXT", 1},
	{"FUNCTION", 1},
	{"GENERAL", 0},
	{"GENERATED", 1},
	{"GEOMCOLLECTION", 0},
	{"GEOMETRY", 0},
	{"GEOMETRYCOLLECTION", 0},
	{"GET", 1},
	{"GET_FORMAT", 0},
	{"GET_MASTER_PUBLIC_KEY", 0},
	{"GET_SOURCE_PUBLIC_KEY", 0},
	{"GLOBAL", 0},
	{"GRANT", 1},
	{"GRANTS", 0},
	{"GROUP", 1},
	{"GROUP_REPLICATION", 0},
	{"GROUPING", 1},
	{"GROUPS", 1},
	{"GTID_ONLY", 0},
	{"HANDLER", 0},
	{"HASH", 0},
	{"HAVING", 1},
	{"HELP", 0},
	{"HIGH_PRIORITY", 1},
	{"HISTOGRAM", 0},
	{"HISTORY", 0},
	{"HOST", 0},
	{"HOSTS", 0},
	{"HOUR", 0},
	{"HOUR_MICROSECOND", 1},
	{"HOUR_MINUTE", 1},
	{"HOUR_SECOND", 1},
	{"IDENTIFIED", 0},
	{"IF", 1},
	{"IGNORE", 1},
	{"IGNORE_SERVER_IDS", 0},
	{"IMPORT", 0},
	{"IN", 1},
	{"INACTIVE", 0},
	{"INDEX", 1},
	{"INDEXES", 0},
	{"INFILE", 1},
	{"INITIAL", 0},
	{"INITIAL_SIZE", 0},
	{"INITIATE", 0},
	{"INNER", 1},
	{"INOUT", 1},
	{"INSENSITIVE", 1},
	{"INSERT", 1},
	{"INSERT_METHOD", 0},
	{"INSTALL", 0},
	{"INSTANCE", 0},
	{"INT", 1},
	{"INT1", 1},
	{"INT2", 1},
	{"INT3", 1},
	{"INT4", 1},
	{"INT8", 1},
	{"INTEGER", 1},
	{"INTERVAL", 1},
	{"INTO", 1},
	{"INVISIBLE", 0},
	{"INVOKER", 0},
	{"IO", 0},
	{"IO_AFTER_GTIDS", 1},
	{"IO_BEFORE_GTIDS", 1},
	{"IO_THREAD", 0},
	{"IPC", 0},
	{"IS", 1},
	{"ISOLATION", 0},
	{"ISSUER", 0},
	{"ITERATE", 1},
	{"JOIN", 1},
	{"JSON", 0},
	{"JSON_TABLE", 1},
	{"JSON_VALUE", 0},
	{"KEY", 1},
	{"KEY_BLOCK_SIZE", 0},
	{"KEYRING", 0},
	{"KEYS", 1},
	{"KILL", 1},
	{"LAG", 1},
	{"LANGUAGE", 0},
	{"LAST", 0},
	{"LAST_VALUE", 1},
	{"LATERAL", 1},
	{"LEAD", 1},
	{"LEADING", 1},
	{"LEAVE", 1},
	{"LEAVES", 0},
	{"LEFT", 1},
	{"LESS", 0},
	{"LEVEL", 0},
	{"LIKE", 1},
	{"LIMIT", 1},
	{"LINEAR", 1},
	{"LINES", 1},
	{"LINESTRING", 0},
	{"LIST", 0},
	{"LOAD", 1},
	{"LOCAL", 0},
	{"LOCALTIME", 1},
	{"LOCALTIMESTAMP", 1},
	{"LOCK", 1},
	{"LOCKED", 0},
	{"LOCKS", 0},
	{"LOGFILE", 0},
	{"LOGS", 0},
	{"LONG", 1},
	{"LONGBLOB", 1},
	{"LONGTEXT", 1},
	{"LOOP", 1},
	{"LOW_PRIORITY", 1},
	{"MASTER", 0},
	{"MASTER_AUTO_POSITION", 0},
	{"MASTER_BIND", 1},
	{"MASTER_COMPRESSION_ALGORITHMS", 0},
	{"MASTER_CONNECT_RETRY", 0},
	{"MASTER_DELAY", 0},
	{"MASTER_HEARTBEAT_PERIOD", 0},
	{"MASTER_HOST", 0},
	{"MASTER_LOG_FILE", 0},
	{"MASTER_LOG_POS", 0},
	{"MASTER_PASSWORD", 0},
	{"MASTER_PORT", 0},
	{"MASTER_PUBLIC_KEY_PATH", 0},
	{"MASTER_RETRY_COUNT", 0},
	{"MASTER_SSL", 0},
	{"MASTER_SSL_CA", 0},
	{"MASTER_SSL_CAPATH", 0},
	{"MASTER_SSL_CERT", 0},
	{"MASTER_SSL_CIPHER", 0},
	{"MASTER_SSL_CRL", 0},
	{"MASTER_SSL_CRLPATH", 0},
	{"MASTER_SSL_KEY", 0},
	{"MASTER_SSL_VERIFY_SERVER_CERT", 1},
	{"MASTER_TLS_CIPHERSUITES", 0},
	{"MASTER_TLS_VERSION", 0},
	{"MASTER_USER", 0},
	{"MASTER_ZSTD_COMPRESSION_LEVEL", 0},
	{"MATCH", 1},
	{"MAX_CONNECTIONS_PER_HOUR", 0},
	{"MAX_QUERIES_PER_HOUR", 0},
	{"MAX_ROWS", 0},
	{"MAX_SIZE", 0},
	{"MAX_UPDATES_PER_HOUR", 0},
	{"MAX_USER_CONNECTIONS", 0},
	{"MAXVALUE", 1},
	{"MEDIUM", 0},
	{"MEDIUMBLOB", 1},
	{"MEDIUMINT", 1},
	{"MEDIUMTEXT", 1},
	{"MEMBER", 0},
	{"MEMORY", 0},
	{"MERGE", 0},
	{"MESSAGE_TEXT", 0},
	{"MICROSECOND", 0},
	{"MIDDLEINT", 1},
	{"MIGRATE", 0},
	{"MIN_ROWS", 0},
	{"MINUTE", 0},
	{"MINUTE_MICROSECOND", 1},
	{"MINUTE_SECOND", 1},
	{"MOD", 1},
	{"MODE", 0},
	{"MODIFIES", 1},
	{"MODIFY", 0},
	{"MONTH", 0},
	{"MULTILINESTRING", 0},
	{"MULTIPOINT", 0},
	{"MULTIPOLYGON", 0},
	{"MUTEX", 0},
	{"MYSQL_ERRNO", 0},
	{"NAME", 0},
	{"NAMES", 0},
	{"NATIONAL", 0},
	{"NATURAL", 1},
	{"NCHAR", 0},
	{"NDB", 0},
	{"NDBCLUSTER", 0},
	{"NESTED", 0},
	{"NETWORK_NAMESPACE", 0},
	{"NEVER", 0},
	{"NEW", 0},
	{"NEXT", 0},
	{"NO", 0},
	{"NO_WAIT", 0},
	{"NO_WRITE_TO_BINLOG", 1},
	{"NODEGROUP", 0},
	{"NONE", 0},
	{"NOT", 1},
	{"NOWAIT", 0},
	{"NTH_VALUE", 1},
	{"NTILE", 1},
	{"NULL", 1},
	{"NULLS", 0},
	{"NUMBER", 0},
	{"NUMERIC", 1},
	{"NVARCHAR", 0},
	{"OF", 1},
	{"OFF", 0},
	{"OFFSET", 0},
	{"OJ", 0},
	{"OLD", 0},
	{"ON", 1},
	{"ONE", 0},
	{"ONLY", 0},
	{"OPEN", 0},
	{"OPTIMIZE", 1},
	{"OPTIMIZER_COSTS", 1},
	{"OPTION", 1},
	{"OPTIONAL", 0},
	{"OPTIONALLY", 1},
	{"OPTIONS", 0},
	{"OR", 1},
	{"ORDER", 1},
	{"ORDINALITY", 0},
	{"ORGANIZATION", 0},
	{"OTHERS", 0},
	{"OUT", 1},
	{"OUTER", 1},
	{"OUTFILE", 1},
	{"OVER", 1},
	{"OWNER", 0},
	{"PACK_KEYS", 0},
	{"PAGE", 0},
	{"PARSER", 0},
	{"PARTIAL", 0},
	{"PARTITION", 1},
	{"PARTITIONING", 0},
	{"PARTITIONS", 0},
	{"PASSWORD", 0},
	{"PASSWORD_LOCK_TIME", 0},
	{"PATH", 0},
	{"PERCENT_RANK", 1},
	{"PERSIST", 0},
	{"PERSIST_ONLY", 0},
	{"PHASE", 0},
	{"PLUGIN", 0},
	{"PLUGIN_DIR", 0},
	{"PLUGINS", 0},
	{"POINT", 0},
	{"POLYGON", 0},
	{"PORT", 0},
	{"PRECEDES", 0},
	{"PRECEDING", 0},
	{"PRECISION", 1},
	{"PREPARE", 0},
	{"PRESERVE", 0},
	{"PREV", 0},
	{"PRIMARY", 1},
	{"PRIVILEGE_CHECKS_USER", 0},
	{"PRIVILEGES", 0},
	{"PROCEDURE", 1},
	{"PROCESS", 0},
	{"PROCESSLIST", 0},
	{"PROFILE", 0},
	{"PROFILES", 0},
	{"PROXY", 0},
	{"PURGE", 1},
	{"QUARTER", 0},
	{"QUERY", 0},
	{"QUICK", 0},
	{"RANDOM", 0},
	{"RANGE", 1},
	{"RANK", 1},
	{"READ", 1},
	{"READ_ONLY", 0},
	{"READ_WRITE", 1},
	{"READS", 1},
	{"REAL", 1},
	{"REBUILD", 0},
	{"RECOVER", 0},
	{"RECURSIVE", 1},
	{"REDO_BUFFER_SIZE", 0},
	{"REDUNDANT", 0},
	{"REFERENCE", 0},
	{"REFERENCES", 1},
	{"REGEXP", 1},
	{"REGISTRATION", 0},
	{"RELAY", 0},
	{"RELAY_LOG_FILE", 0},
	{"RELAY_LOG_POS", 0},
	{"RELAY_THREAD", 0},
	{"RELAYLOG", 0},
	{"RELEASE", 1},
	{"RELOAD", 0},
	{"REMOVE", 0},
	{"RENAME", 1},
	{"REORGANIZE", 0},
	{"REPAIR", 0},
	{"REPEAT", 1},
	{"REPEATABLE", 0},
	{"REPLACE", 1},
	{"REPLICA", 0},
	{"REPLICAS", 0},
	{"REPLICATE_DO_DB", 0},
	{"REPLICATE_DO_TABLE", 0},
	{"REPLICATE_IGNORE_DB", 0},
	{"REPLICATE_IGNORE_TABLE", 0},
	{"REPLICATE_REWRITE_DB", 0},
	{"REPLICATE_WILD_DO_TABLE", 0},
	{"REPLICATE_WILD_IGNORE_TABLE", 0},
	{"REPLICATION", 0},
	{"REQUIRE", 1},
	{"REQUIRE_ROW_FORMAT", 0},
	{"REQUIRE_TABLE_PRIMARY_KEY_CHECK", 0},
	{"RESET", 0},
	{"RESIGNAL", 1},
	{"RESOURCE", 0},
	{"RESPECT", 0},
	{"RESTART", 0},
	{"RESTORE", 0},
	{"RESTRICT", 1},
	{"RESUME", 0},
	{"RETAIN", 0},
	{"RETURN", 1},
	{"RETURNED_SQLSTATE", 0},
	{"RETURNING", 0},
	{"RETURNS", 0},
	{"REUSE", 0},
	{"REVERSE", 0},
	{"REVOKE", 1},
	{"RIGHT", 1},
	{"RLIKE", 1},
	{"ROLE", 0},
	{"ROLLBACK", 0},
	{"ROLLUP", 0},
	{"ROTATE", 0},
	{"ROUTINE", 0},
	{"ROW", 1},
	{"ROW_COUNT", 0},
	{"ROW_FORMAT", 0},
	{"ROW_NUMBER", 1},
	{"ROWS", 1},
	{"RTREE", 0},
	{"SAVEPOINT", 0},
	{"SCHEDULE", 0},
	{"SCHEMA", 1},
	{"SCHEMA_NAME", 0},
	{"SCHEMAS", 1},
	{"SECOND", 0},
	{"SECOND_MICROSECOND", 1},
	{"SECONDARY", 0},
	{"SECONDARY_ENGINE", 0},
	{"SECONDARY_ENGINE_ATTRIBUTE", 0},
	{"SECONDARY_LOAD", 0},
	{"SECONDARY_UNLOAD", 0},
	{"SECURITY", 0},
	{"SELECT", 1},
	{"SENSITIVE", 1},
	{"SEPARATOR", 1},
	{"SERIAL", 0},
	{"SERIALIZABLE", 0},
	{"SERVER", 0},
	{"SESSION", 0},
	{"SET", 1},
	{"SHARE", 0},
	{"SHOW", 1},
	{"SHUTDOWN", 0},
	{"SIGNAL", 1},
	{"SIGNED", 0},
	{"SIMPLE", 0},
	{"SKIP", 0},
	{"SLAVE", 0},
	{"SLOW", 0},
	{"SMALLINT", 1},
	{"SNAPSHOT", 0},
	{"SOCKET", 0},
	{"SOME", 0},
	{"SONAME", 0},
	{"SOUNDS", 0},
	{"SOURCE", 0},
	{"SOURCE_AUTO_POSITION", 0},
	{"SOURCE_BIND", 0},
	{"SOURCE_COMPRESSION_ALGORITHMS", 0},
	{"SOURCE_CONNECT_RETRY", 0},
	{"SOURCE_CONNECTION_AUTO_FAILOVER", 0},
	{"SOURCE_DELAY", 0},
	{"SOURCE_HEARTBEAT_PERIOD", 0},
	{"SOURCE_HOST", 0},
	{"SOURCE_LOG_FILE", 0},
	{"SOURCE_LOG_POS", 0},
	{"SOURCE_PASSWORD", 0},
	{"SOURCE_PORT", 0},
	{"SOURCE_PUBLIC_KEY_PATH", 0},
	{"SOURCE_RETRY_COUNT", 0},
	{"SOURCE_SSL", 0},
	{"SOURCE_SSL_CA", 0},
	{"SOURCE_SSL_CAPATH", 0},
	{"SOURCE_SSL_CERT", 0},
	{"SOURCE_SSL_CIPHER", 0},
	{"SOURCE_SSL_CRL", 0},
	{"SOURCE_SSL_CRLPATH", 0},
	{"SOURCE_SSL_KEY", 0},
	{"SOURCE_SSL_VERIFY_SERVER_CERT", 0},
	{"SOURCE_TLS_CIPHERSUITES", 0},
	{"SOURCE_TLS_VERSION", 0},
	{"SOURCE_USER", 0},
	{"SOURCE_ZSTD_COMPRESSION_LEVEL", 0},
	{"SPATIAL", 1},
	{"SPECIFIC", 1},
	{"SQL", 1},
	{"SQL_AFTER_GTIDS", 0},
	{"SQL_AFTER_MTS_GAPS", 0},
	{"SQL_BEFORE_GTIDS", 0},
	{"SQL_BIG_RESULT", 1},
	{"SQL_BUFFER_RESULT", 0},
	{"SQL_CALC_FOUND_ROWS", 1},
	{"SQL_NO_CACHE", 0},
	{"SQL_SMALL_RESULT", 1},
	{"SQL_THREAD", 0},
	{"SQL_TSI_DAY", 0},
	{"SQL_TSI_HOUR", 0},
	{"SQL_TSI_MINUTE", 0},
	{"SQL_TSI_MONTH", 0},
	{"SQL_TSI_QUARTER", 0},
	{"SQL_TSI_SECOND", 0},
	{"SQL_TSI_WEEK", 0},
	{"SQL_TSI_YEAR", 0},
	{"SQLEXCEPTION", 1},
	{"SQLSTATE", 1},
	{"SQLWARNING", 1},
	{"SRID", 0},
	{"SSL", 1},
	{"STACKED", 0},
	{"START", 0},
	{"STARTING", 1},
	{"STARTS", 0},
	{"STATS_AUTO_RECALC", 0},
	{"STATS_PERSISTENT", 0},
	{"STATS_SAMPLE_PAGES", 0},
	{"STATUS", 0},
	{"STOP", 0},
	{"STORAGE", 0},
	{"STORED", 1},
	{"STRAIGHT_JOIN", 1},
	{"STREAM", 0},
	{"STRING", 0},
	{"SUBCLASS_ORIGIN", 0},
	{"SUBJECT", 0},
	{"SUBPARTITION", 0},
	{"SUBPARTITIONS", 0},
	{"SUPER", 0},
	{"SUSPEND", 0},
	{"SWAPS", 0},
	{"SWITCHES", 0},
	{"SYSTEM", 1},
	{"TABLE", 1},
	{"TABLE_CHECKSUM", 0},
	{"TABLE_NAME", 0},
	{"TABLES", 0},
	{"TABLESPACE", 0},
	{"TEMPORARY", 0},
	{"TEMPTABLE", 0},
	{"TERMINATED", 1},
	{"TEXT", 0},
	{"THAN", 0},
	{"THEN", 1},
	{"THREAD_PRIORITY", 0},
	{"TIES", 0},
	{"TIME", 0},
	{"TIMESTAMP", 0},
	{"TIMESTAMPADD", 0},
	{"TIMESTAMPDIFF", 0},
	{"TINYBLOB", 1},
	{"TINYINT", 1},
	{"TINYTEXT", 1},
	{"TLS", 0},
	{"TO", 1},
	{"TRAILING", 1},
	{"TRANSACTION", 0},
	{"TRIGGER", 1},
	{"TRIGGERS", 0},
	{"TRUE", 1},
	{"TRUNCATE", 0},
	{"TYPE", 0},
	{"TYPES", 0},
	{"UNBOUNDED", 0},
	{"UNCOMMITTED", 0},
	{"UNDEFINED", 0},
	{"UNDO", 1},
	{"UNDO_BUFFER_SIZE", 0},
	{"UNDOFILE", 0},
	{"UNICODE", 0},
	{"UNINSTALL", 0},
	{"UNION", 1},
	{"UNIQUE", 1},
	{"UNKNOWN", 0},
	{"UNLOCK", 1},
	{"UNREGISTER", 0},
	{"UNSIGNED", 1},
	{"UNTIL", 0},
	{"UPDATE", 1},
	{"UPGRADE", 0},
	{"USAGE", 1},
	{"USE", 1},
	{"USE_FRM", 0},
	{"USER", 0},
	{"USER_RESOURCES", 0},
	{"USING", 1},
	{"UTC_DATE", 1},
	{"UTC_TIME", 1},
	{"UTC_TIMESTAMP", 1},
	{"VALIDATION", 0},
	{"VALUE", 0},
	{"VALUES", 1},
	{"VARBINARY", 1},
	{"VARCHAR", 1},
	{"VARCHARACTER", 1},
	{"VARIABLES", 0},
	{"VARYING", 1},
	{"VCPU", 0},
	{"VIEW", 0},
	{"VIRTUAL", 1},
	{"VISIBLE", 0},
	{"WAIT", 0},
	{"WARNINGS", 0},
	{"WEEK", 0},
	{"WHEN", 1},
	{"WHERE", 1},
	{"WHILE", 1},
	{"WINDOW", 1},
	{"WITH", 1},
	{"WITHOUT", 0},
	{"WORK", 0},
	{"WRAPPER", 0},
	{"WRITE", 1},
	{"X509", 0},
	{"XA", 0},
	{"XID", 0},
	{"XML", 0},
	{"XOR", 1},
	{"YEAR", 0},
	{"YEAR_MONTH", 1},
	{"ZEROFILL", 1},
	{"ZONE", 0},
}
