// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Utf8mb3_general_mysql500_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `utf8mb3_general_mysql500_ci` collation.
func Utf8mb3_general_mysql500_ci_RuneWeight(r rune) int32 {
	weight, ok := utf8mb3_general_mysql500_ci_Weights[r]
	if ok {
		return weight
	} else if r >= 659 && r <= 836 {
		return r - 341
	} else if r >= 1415 && r <= 7679 {
		return r - 585
	} else if r >= 8189 && r <= 8544 {
		return r - 1039
	} else if r >= 8575 && r <= 9398 {
		return r - 1055
	} else if r >= 9449 && r <= 55295 {
		return r - 1081
	} else if r >= 57345 && r <= 65313 {
		return r - 3129
	} else if r >= 65371 && r <= 65535 {
		return r - 3155
	} else {
		return 2147483647
	}
}

// utf8mb3_general_mysql500_ci_Weights contain a map from rune to weight for the `utf8mb3_general_mysql500_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var utf8mb3_general_mysql500_ci_Weights = map[rune]int32{
	0:     0,
	1:     1,
	2:     2,
	3:     3,
	4:     4,
	5:     5,
	6:     6,
	7:     7,
	8:     8,
	9:     9,
	10:    10,
	11:    11,
	12:    12,
	13:    13,
	14:    14,
	15:    15,
	16:    16,
	17:    17,
	18:    18,
	19:    19,
	20:    20,
	21:    21,
	22:    22,
	23:    23,
	24:    24,
	25:    25,
	26:    26,
	27:    27,
	28:    28,
	29:    29,
	30:    30,
	31:    31,
	32:    32,
	33:    33,
	34:    34,
	35:    35,
	36:    36,
	37:    37,
	38:    38,
	39:    39,
	40:    40,
	41:    41,
	42:    42,
	43:    43,
	44:    44,
	45:    45,
	46:    46,
	47:    47,
	48:    48,
	49:    49,
	50:    50,
	51:    51,
	52:    52,
	53:    53,
	54:    54,
	55:    55,
	56:    56,
	57:    57,
	58:    58,
	59:    59,
	60:    60,
	61:    61,
	62:    62,
	63:    63,
	64:    64,
	65:    65,
	97:    65,
	192:   65,
	193:   65,
	194:   65,
	195:   65,
	196:   65,
	197:   65,
	224:   65,
	225:   65,
	226:   65,
	227:   65,
	228:   65,
	229:   65,
	256:   65,
	257:   65,
	258:   65,
	259:   65,
	260:   65,
	261:   65,
	461:   65,
	462:   65,
	478:   65,
	479:   65,
	480:   65,
	481:   65,
	506:   65,
	507:   65,
	512:   65,
	513:   65,
	514:   65,
	515:   65,
	550:   65,
	551:   65,
	7680:  65,
	7681:  65,
	7840:  65,
	7841:  65,
	7842:  65,
	7843:  65,
	7844:  65,
	7845:  65,
	7846:  65,
	7847:  65,
	7848:  65,
	7849:  65,
	7850:  65,
	7851:  65,
	7852:  65,
	7853:  65,
	7854:  65,
	7855:  65,
	7856:  65,
	7857:  65,
	7858:  65,
	7859:  65,
	7860:  65,
	7861:  65,
	7862:  65,
	7863:  65,
	66:    66,
	98:    66,
	7682:  66,
	7683:  66,
	7684:  66,
	7685:  66,
	7686:  66,
	7687:  66,
	67:    67,
	99:    67,
	199:   67,
	231:   67,
	262:   67,
	263:   67,
	264:   67,
	265:   67,
	266:   67,
	267:   67,
	268:   67,
	269:   67,
	7688:  67,
	7689:  67,
	68:    68,
	100:   68,
	270:   68,
	271:   68,
	7690:  68,
	7691:  68,
	7692:  68,
	7693:  68,
	7694:  68,
	7695:  68,
	7696:  68,
	7697:  68,
	7698:  68,
	7699:  68,
	69:    69,
	101:   69,
	200:   69,
	201:   69,
	202:   69,
	203:   69,
	232:   69,
	233:   69,
	234:   69,
	235:   69,
	274:   69,
	275:   69,
	276:   69,
	277:   69,
	278:   69,
	279:   69,
	280:   69,
	281:   69,
	282:   69,
	283:   69,
	516:   69,
	517:   69,
	518:   69,
	519:   69,
	552:   69,
	553:   69,
	7700:  69,
	7701:  69,
	7702:  69,
	7703:  69,
	7704:  69,
	7705:  69,
	7706:  69,
	7707:  69,
	7708:  69,
	7709:  69,
	7864:  69,
	7865:  69,
	7866:  69,
	7867:  69,
	7868:  69,
	7869:  69,
	7870:  69,
	7871:  69,
	7872:  69,
	7873:  69,
	7874:  69,
	7875:  69,
	7876:  69,
	7877:  69,
	7878:  69,
	7879:  69,
	70:    70,
	102:   70,
	7710:  70,
	7711:  70,
	71:    71,
	103:   71,
	284:   71,
	285:   71,
	286:   71,
	287:   71,
	288:   71,
	289:   71,
	290:   71,
	291:   71,
	486:   71,
	487:   71,
	500:   71,
	501:   71,
	7712:  71,
	7713:  71,
	72:    72,
	104:   72,
	292:   72,
	293:   72,
	542:   72,
	543:   72,
	7714:  72,
	7715:  72,
	7716:  72,
	7717:  72,
	7718:  72,
	7719:  72,
	7720:  72,
	7721:  72,
	7722:  72,
	7723:  72,
	7830:  72,
	73:    73,
	105:   73,
	204:   73,
	205:   73,
	206:   73,
	207:   73,
	236:   73,
	237:   73,
	238:   73,
	239:   73,
	296:   73,
	297:   73,
	298:   73,
	299:   73,
	300:   73,
	301:   73,
	302:   73,
	303:   73,
	304:   73,
	305:   73,
	463:   73,
	464:   73,
	520:   73,
	521:   73,
	522:   73,
	523:   73,
	7724:  73,
	7725:  73,
	7726:  73,
	7727:  73,
	7880:  73,
	7881:  73,
	7882:  73,
	7883:  73,
	74:    74,
	106:   74,
	308:   74,
	309:   74,
	496:   74,
	75:    75,
	107:   75,
	310:   75,
	311:   75,
	488:   75,
	489:   75,
	7728:  75,
	7729:  75,
	7730:  75,
	7731:  75,
	7732:  75,
	7733:  75,
	76:    76,
	108:   76,
	313:   76,
	314:   76,
	315:   76,
	316:   76,
	317:   76,
	318:   76,
	7734:  76,
	7735:  76,
	7736:  76,
	7737:  76,
	7738:  76,
	7739:  76,
	7740:  76,
	7741:  76,
	77:    77,
	109:   77,
	7742:  77,
	7743:  77,
	7744:  77,
	7745:  77,
	7746:  77,
	7747:  77,
	78:    78,
	110:   78,
	209:   78,
	241:   78,
	323:   78,
	324:   78,
	325:   78,
	326:   78,
	327:   78,
	328:   78,
	504:   78,
	505:   78,
	7748:  78,
	7749:  78,
	7750:  78,
	7751:  78,
	7752:  78,
	7753:  78,
	7754:  78,
	7755:  78,
	79:    79,
	111:   79,
	210:   79,
	211:   79,
	212:   79,
	213:   79,
	214:   79,
	242:   79,
	243:   79,
	244:   79,
	245:   79,
	246:   79,
	332:   79,
	333:   79,
	334:   79,
	335:   79,
	336:   79,
	337:   79,
	416:   79,
	417:   79,
	465:   79,
	466:   79,
	490:   79,
	491:   79,
	492:   79,
	493:   79,
	524:   79,
	525:   79,
	526:   79,
	527:   79,
	554:   79,
	555:   79,
	556:   79,
	557:   79,
	558:   79,
	559:   79,
	560:   79,
	561:   79,
	7756:  79,
	7757:  79,
	7758:  79,
	7759:  79,
	7760:  79,
	7761:  79,
	7762:  79,
	7763:  79,
	7884:  79,
	7885:  79,
	7886:  79,
	7887:  79,
	7888:  79,
	7889:  79,
	7890:  79,
	7891:  79,
	7892:  79,
	7893:  79,
	7894:  79,
	7895:  79,
	7896:  79,
	7897:  79,
	7898:  79,
	7899:  79,
	7900:  79,
	7901:  79,
	7902:  79,
	7903:  79,
	7904:  79,
	7905:  79,
	7906:  79,
	7907:  79,
	80:    80,
	112:   80,
	7764:  80,
	7765:  80,
	7766:  80,
	7767:  80,
	81:    81,
	113:   81,
	82:    82,
	114:   82,
	340:   82,
	341:   82,
	342:   82,
	343:   82,
	344:   82,
	345:   82,
	528:   82,
	529:   82,
	530:   82,
	531:   82,
	7768:  82,
	7769:  82,
	7770:  82,
	7771:  82,
	7772:  82,
	7773:  82,
	7774:  82,
	7775:  82,
	83:    83,
	115:   83,
	346:   83,
	347:   83,
	348:   83,
	349:   83,
	350:   83,
	351:   83,
	352:   83,
	353:   83,
	383:   83,
	536:   83,
	537:   83,
	7776:  83,
	7777:  83,
	7778:  83,
	7779:  83,
	7780:  83,
	7781:  83,
	7782:  83,
	7783:  83,
	7784:  83,
	7785:  83,
	7835:  83,
	84:    84,
	116:   84,
	354:   84,
	355:   84,
	356:   84,
	357:   84,
	538:   84,
	539:   84,
	7786:  84,
	7787:  84,
	7788:  84,
	7789:  84,
	7790:  84,
	7791:  84,
	7792:  84,
	7793:  84,
	7831:  84,
	85:    85,
	117:   85,
	217:   85,
	218:   85,
	219:   85,
	220:   85,
	249:   85,
	250:   85,
	251:   85,
	252:   85,
	360:   85,
	361:   85,
	362:   85,
	363:   85,
	364:   85,
	365:   85,
	366:   85,
	367:   85,
	368:   85,
	369:   85,
	370:   85,
	371:   85,
	431:   85,
	432:   85,
	467:   85,
	468:   85,
	469:   85,
	470:   85,
	471:   85,
	472:   85,
	473:   85,
	474:   85,
	475:   85,
	476:   85,
	532:   85,
	533:   85,
	534:   85,
	535:   85,
	7794:  85,
	7795:  85,
	7796:  85,
	7797:  85,
	7798:  85,
	7799:  85,
	7800:  85,
	7801:  85,
	7802:  85,
	7803:  85,
	7908:  85,
	7909:  85,
	7910:  85,
	7911:  85,
	7912:  85,
	7913:  85,
	7914:  85,
	7915:  85,
	7916:  85,
	7917:  85,
	7918:  85,
	7919:  85,
	7920:  85,
	7921:  85,
	86:    86,
	118:   86,
	7804:  86,
	7805:  86,
	7806:  86,
	7807:  86,
	87:    87,
	119:   87,
	372:   87,
	373:   87,
	7808:  87,
	7809:  87,
	7810:  87,
	7811:  87,
	7812:  87,
	7813:  87,
	7814:  87,
	7815:  87,
	7816:  87,
	7817:  87,
	7832:  87,
	88:    88,
	120:   88,
	7818:  88,
	7819:  88,
	7820:  88,
	7821:  88,
	89:    89,
	121:   89,
	221:   89,
	253:   89,
	255:   89,
	374:   89,
	375:   89,
	376:   89,
	562:   89,
	563:   89,
	7822:  89,
	7823:  89,
	7833:  89,
	7922:  89,
	7923:  89,
	7924:  89,
	7925:  89,
	7926:  89,
	7927:  89,
	7928:  89,
	7929:  89,
	90:    90,
	122:   90,
	377:   90,
	378:   90,
	379:   90,
	380:   90,
	381:   90,
	382:   90,
	7824:  90,
	7825:  90,
	7826:  90,
	7827:  90,
	7828:  90,
	7829:  90,
	91:    91,
	92:    92,
	93:    93,
	94:    94,
	95:    95,
	96:    96,
	123:   97,
	124:   98,
	125:   99,
	126:   100,
	127:   101,
	128:   102,
	129:   103,
	130:   104,
	131:   105,
	132:   106,
	133:   107,
	134:   108,
	135:   109,
	136:   110,
	137:   111,
	138:   112,
	139:   113,
	140:   114,
	141:   115,
	142:   116,
	143:   117,
	144:   118,
	145:   119,
	146:   120,
	147:   121,
	148:   122,
	149:   123,
	150:   124,
	151:   125,
	152:   126,
	153:   127,
	154:   128,
	155:   129,
	156:   130,
	157:   131,
	158:   132,
	159:   133,
	160:   134,
	161:   135,
	162:   136,
	163:   137,
	164:   138,
	165:   139,
	166:   140,
	167:   141,
	168:   142,
	169:   143,
	170:   144,
	171:   145,
	172:   146,
	173:   147,
	174:   148,
	175:   149,
	176:   150,
	177:   151,
	178:   152,
	179:   153,
	180:   154,
	182:   155,
	183:   156,
	184:   157,
	185:   158,
	186:   159,
	187:   160,
	188:   161,
	189:   162,
	190:   163,
	191:   164,
	198:   165,
	230:   165,
	482:   165,
	483:   165,
	508:   165,
	509:   165,
	208:   166,
	240:   166,
	215:   167,
	216:   168,
	248:   168,
	510:   168,
	511:   168,
	222:   169,
	254:   169,
	223:   170,
	247:   171,
	272:   172,
	273:   172,
	294:   173,
	295:   173,
	306:   174,
	307:   174,
	312:   175,
	319:   176,
	320:   176,
	321:   177,
	322:   177,
	329:   178,
	330:   179,
	331:   179,
	338:   180,
	339:   180,
	358:   181,
	359:   181,
	384:   182,
	385:   183,
	595:   183,
	386:   184,
	387:   184,
	388:   185,
	389:   185,
	390:   186,
	596:   186,
	391:   187,
	392:   187,
	393:   188,
	598:   188,
	394:   189,
	599:   189,
	395:   190,
	396:   190,
	397:   191,
	398:   192,
	477:   192,
	399:   193,
	601:   193,
	400:   194,
	603:   194,
	401:   195,
	402:   195,
	403:   196,
	608:   196,
	404:   197,
	611:   197,
	406:   198,
	617:   198,
	407:   199,
	616:   199,
	408:   200,
	409:   200,
	410:   201,
	411:   202,
	412:   203,
	623:   203,
	413:   204,
	626:   204,
	414:   205,
	415:   206,
	629:   206,
	418:   207,
	419:   207,
	420:   208,
	421:   208,
	422:   209,
	640:   209,
	423:   210,
	424:   210,
	425:   211,
	643:   211,
	426:   212,
	427:   213,
	428:   214,
	429:   214,
	430:   215,
	648:   215,
	433:   216,
	650:   216,
	434:   217,
	651:   217,
	435:   218,
	436:   218,
	437:   219,
	438:   219,
	439:   220,
	494:   220,
	495:   220,
	658:   220,
	440:   221,
	441:   221,
	442:   222,
	443:   223,
	444:   224,
	445:   224,
	446:   225,
	448:   226,
	449:   227,
	450:   228,
	451:   229,
	452:   230,
	453:   230,
	454:   230,
	455:   231,
	456:   231,
	457:   231,
	458:   232,
	459:   232,
	460:   232,
	484:   233,
	485:   233,
	497:   234,
	498:   234,
	499:   234,
	405:   235,
	502:   235,
	447:   236,
	503:   236,
	540:   237,
	541:   237,
	544:   238,
	545:   239,
	546:   240,
	547:   240,
	548:   241,
	549:   241,
	564:   242,
	565:   243,
	566:   244,
	567:   245,
	568:   246,
	569:   247,
	570:   248,
	571:   249,
	572:   250,
	573:   251,
	574:   252,
	575:   253,
	576:   254,
	577:   255,
	578:   256,
	579:   257,
	580:   258,
	581:   259,
	582:   260,
	583:   261,
	584:   262,
	585:   263,
	586:   264,
	587:   265,
	588:   266,
	589:   267,
	590:   268,
	591:   269,
	592:   270,
	593:   271,
	594:   272,
	597:   273,
	600:   274,
	602:   275,
	604:   276,
	605:   277,
	606:   278,
	607:   279,
	609:   280,
	610:   281,
	612:   282,
	613:   283,
	614:   284,
	615:   285,
	618:   286,
	619:   287,
	620:   288,
	621:   289,
	622:   290,
	624:   291,
	625:   292,
	627:   293,
	628:   294,
	630:   295,
	631:   296,
	632:   297,
	633:   298,
	634:   299,
	635:   300,
	636:   301,
	637:   302,
	638:   303,
	639:   304,
	641:   305,
	642:   306,
	644:   307,
	645:   308,
	646:   309,
	647:   310,
	649:   311,
	652:   312,
	653:   313,
	654:   314,
	655:   315,
	656:   316,
	657:   317,
	838:   496,
	839:   497,
	840:   498,
	841:   499,
	842:   500,
	843:   501,
	844:   502,
	845:   503,
	846:   504,
	847:   505,
	848:   506,
	849:   507,
	850:   508,
	851:   509,
	852:   510,
	853:   511,
	854:   512,
	855:   513,
	856:   514,
	857:   515,
	858:   516,
	859:   517,
	860:   518,
	861:   519,
	862:   520,
	863:   521,
	864:   522,
	865:   523,
	866:   524,
	867:   525,
	868:   526,
	869:   527,
	870:   528,
	871:   529,
	872:   530,
	873:   531,
	874:   532,
	875:   533,
	876:   534,
	877:   535,
	878:   536,
	879:   537,
	880:   538,
	881:   539,
	882:   540,
	883:   541,
	884:   542,
	885:   543,
	886:   544,
	887:   545,
	888:   546,
	889:   547,
	890:   548,
	891:   549,
	892:   550,
	893:   551,
	894:   552,
	895:   553,
	896:   554,
	897:   555,
	898:   556,
	899:   557,
	900:   558,
	901:   559,
	903:   560,
	907:   561,
	909:   562,
	902:   563,
	913:   563,
	940:   563,
	945:   563,
	7936:  563,
	7937:  563,
	7938:  563,
	7939:  563,
	7940:  563,
	7941:  563,
	7942:  563,
	7943:  563,
	7944:  563,
	7945:  563,
	7946:  563,
	7947:  563,
	7948:  563,
	7949:  563,
	7950:  563,
	7951:  563,
	8048:  563,
	8064:  563,
	8065:  563,
	8066:  563,
	8067:  563,
	8068:  563,
	8069:  563,
	8070:  563,
	8071:  563,
	8072:  563,
	8073:  563,
	8074:  563,
	8075:  563,
	8076:  563,
	8077:  563,
	8078:  563,
	8079:  563,
	8112:  563,
	8113:  563,
	8114:  563,
	8115:  563,
	8116:  563,
	8118:  563,
	8119:  563,
	8120:  563,
	8121:  563,
	8122:  563,
	8124:  563,
	914:   564,
	946:   564,
	976:   564,
	915:   565,
	947:   565,
	916:   566,
	948:   566,
	904:   567,
	917:   567,
	941:   567,
	949:   567,
	7952:  567,
	7953:  567,
	7954:  567,
	7955:  567,
	7956:  567,
	7957:  567,
	7960:  567,
	7961:  567,
	7962:  567,
	7963:  567,
	7964:  567,
	7965:  567,
	8050:  567,
	8136:  567,
	918:   568,
	950:   568,
	905:   569,
	919:   569,
	942:   569,
	951:   569,
	7968:  569,
	7969:  569,
	7970:  569,
	7971:  569,
	7972:  569,
	7973:  569,
	7974:  569,
	7975:  569,
	7976:  569,
	7977:  569,
	7978:  569,
	7979:  569,
	7980:  569,
	7981:  569,
	7982:  569,
	7983:  569,
	8052:  569,
	8080:  569,
	8081:  569,
	8082:  569,
	8083:  569,
	8084:  569,
	8085:  569,
	8086:  569,
	8087:  569,
	8088:  569,
	8089:  569,
	8090:  569,
	8091:  569,
	8092:  569,
	8093:  569,
	8094:  569,
	8095:  569,
	8130:  569,
	8131:  569,
	8132:  569,
	8134:  569,
	8135:  569,
	8138:  569,
	8140:  569,
	920:   570,
	952:   570,
	977:   570,
	837:   571,
	906:   571,
	912:   571,
	921:   571,
	938:   571,
	943:   571,
	953:   571,
	970:   571,
	7984:  571,
	7985:  571,
	7986:  571,
	7987:  571,
	7988:  571,
	7989:  571,
	7990:  571,
	7991:  571,
	7992:  571,
	7993:  571,
	7994:  571,
	7995:  571,
	7996:  571,
	7997:  571,
	7998:  571,
	7999:  571,
	8054:  571,
	8126:  571,
	8144:  571,
	8145:  571,
	8146:  571,
	8150:  571,
	8151:  571,
	8152:  571,
	8153:  571,
	8154:  571,
	922:   572,
	954:   572,
	1008:  572,
	923:   573,
	955:   573,
	181:   574,
	924:   574,
	956:   574,
	925:   575,
	957:   575,
	926:   576,
	958:   576,
	908:   577,
	927:   577,
	959:   577,
	972:   577,
	8000:  577,
	8001:  577,
	8002:  577,
	8003:  577,
	8004:  577,
	8005:  577,
	8008:  577,
	8009:  577,
	8010:  577,
	8011:  577,
	8012:  577,
	8013:  577,
	8056:  577,
	8184:  577,
	928:   578,
	960:   578,
	982:   578,
	929:   579,
	961:   579,
	1009:  579,
	8164:  579,
	8165:  579,
	8172:  579,
	930:   580,
	931:   581,
	962:   581,
	963:   581,
	1010:  581,
	932:   582,
	964:   582,
	910:   583,
	933:   583,
	939:   583,
	944:   583,
	965:   583,
	971:   583,
	973:   583,
	8016:  583,
	8017:  583,
	8018:  583,
	8019:  583,
	8020:  583,
	8021:  583,
	8022:  583,
	8023:  583,
	8025:  583,
	8027:  583,
	8029:  583,
	8031:  583,
	8058:  583,
	8160:  583,
	8161:  583,
	8162:  583,
	8166:  583,
	8167:  583,
	8168:  583,
	8169:  583,
	8170:  583,
	934:   584,
	966:   584,
	981:   584,
	935:   585,
	967:   585,
	936:   586,
	968:   586,
	911:   587,
	937:   587,
	969:   587,
	974:   587,
	8032:  587,
	8033:  587,
	8034:  587,
	8035:  587,
	8036:  587,
	8037:  587,
	8038:  587,
	8039:  587,
	8040:  587,
	8041:  587,
	8042:  587,
	8043:  587,
	8044:  587,
	8045:  587,
	8046:  587,
	8047:  587,
	8060:  587,
	8096:  587,
	8097:  587,
	8098:  587,
	8099:  587,
	8100:  587,
	8101:  587,
	8102:  587,
	8103:  587,
	8104:  587,
	8105:  587,
	8106:  587,
	8107:  587,
	8108:  587,
	8109:  587,
	8110:  587,
	8111:  587,
	8178:  587,
	8179:  587,
	8180:  587,
	8182:  587,
	8183:  587,
	8186:  587,
	8188:  587,
	975:   588,
	978:   589,
	979:   589,
	980:   589,
	983:   590,
	984:   591,
	985:   592,
	986:   593,
	987:   593,
	988:   594,
	989:   594,
	990:   595,
	991:   595,
	992:   596,
	993:   596,
	994:   597,
	995:   597,
	996:   598,
	997:   598,
	998:   599,
	999:   599,
	1000:  600,
	1001:  600,
	1002:  601,
	1003:  601,
	1004:  602,
	1005:  602,
	1006:  603,
	1007:  603,
	1011:  604,
	1012:  605,
	1013:  606,
	1014:  607,
	1015:  608,
	1016:  609,
	1017:  610,
	1018:  611,
	1019:  612,
	1020:  613,
	1021:  614,
	1022:  615,
	1023:  616,
	1026:  617,
	1106:  617,
	1028:  618,
	1108:  618,
	1029:  619,
	1109:  619,
	1030:  620,
	1031:  620,
	1110:  620,
	1111:  620,
	1032:  621,
	1112:  621,
	1033:  622,
	1113:  622,
	1034:  623,
	1114:  623,
	1035:  624,
	1115:  624,
	1039:  625,
	1119:  625,
	1040:  626,
	1072:  626,
	1232:  626,
	1233:  626,
	1234:  626,
	1235:  626,
	1041:  627,
	1073:  627,
	1042:  628,
	1074:  628,
	1027:  629,
	1043:  629,
	1075:  629,
	1107:  629,
	1044:  630,
	1076:  630,
	1024:  631,
	1025:  631,
	1045:  631,
	1077:  631,
	1104:  631,
	1105:  631,
	1238:  631,
	1239:  631,
	1046:  632,
	1078:  632,
	1217:  632,
	1218:  632,
	1244:  632,
	1245:  632,
	1047:  633,
	1079:  633,
	1246:  633,
	1247:  633,
	1037:  634,
	1048:  634,
	1080:  634,
	1117:  634,
	1250:  634,
	1251:  634,
	1252:  634,
	1253:  634,
	1049:  635,
	1081:  635,
	1036:  636,
	1050:  636,
	1082:  636,
	1116:  636,
	1051:  637,
	1083:  637,
	1052:  638,
	1084:  638,
	1053:  639,
	1085:  639,
	1054:  640,
	1086:  640,
	1254:  640,
	1255:  640,
	1055:  641,
	1087:  641,
	1056:  642,
	1088:  642,
	1057:  643,
	1089:  643,
	1058:  644,
	1090:  644,
	1038:  645,
	1059:  645,
	1091:  645,
	1118:  645,
	1262:  645,
	1263:  645,
	1264:  645,
	1265:  645,
	1266:  645,
	1267:  645,
	1060:  646,
	1092:  646,
	1061:  647,
	1093:  647,
	1062:  648,
	1094:  648,
	1063:  649,
	1095:  649,
	1268:  649,
	1269:  649,
	1064:  650,
	1096:  650,
	1065:  651,
	1097:  651,
	1066:  652,
	1098:  652,
	1067:  653,
	1099:  653,
	1272:  653,
	1273:  653,
	1068:  654,
	1100:  654,
	1069:  655,
	1101:  655,
	1260:  655,
	1261:  655,
	1070:  656,
	1102:  656,
	1071:  657,
	1103:  657,
	1120:  658,
	1121:  658,
	1122:  659,
	1123:  659,
	1124:  660,
	1125:  660,
	1126:  661,
	1127:  661,
	1128:  662,
	1129:  662,
	1130:  663,
	1131:  663,
	1132:  664,
	1133:  664,
	1134:  665,
	1135:  665,
	1136:  666,
	1137:  666,
	1138:  667,
	1139:  667,
	1140:  668,
	1141:  668,
	1142:  668,
	1143:  668,
	1144:  669,
	1145:  669,
	1146:  670,
	1147:  670,
	1148:  671,
	1149:  671,
	1150:  672,
	1151:  672,
	1152:  673,
	1153:  673,
	1154:  674,
	1155:  675,
	1156:  676,
	1157:  677,
	1158:  678,
	1159:  679,
	1160:  680,
	1161:  681,
	1162:  682,
	1163:  683,
	1164:  684,
	1165:  684,
	1166:  685,
	1167:  685,
	1168:  686,
	1169:  686,
	1170:  687,
	1171:  687,
	1172:  688,
	1173:  688,
	1174:  689,
	1175:  689,
	1176:  690,
	1177:  690,
	1178:  691,
	1179:  691,
	1180:  692,
	1181:  692,
	1182:  693,
	1183:  693,
	1184:  694,
	1185:  694,
	1186:  695,
	1187:  695,
	1188:  696,
	1189:  696,
	1190:  697,
	1191:  697,
	1192:  698,
	1193:  698,
	1194:  699,
	1195:  699,
	1196:  700,
	1197:  700,
	1198:  701,
	1199:  701,
	1200:  702,
	1201:  702,
	1202:  703,
	1203:  703,
	1204:  704,
	1205:  704,
	1206:  705,
	1207:  705,
	1208:  706,
	1209:  706,
	1210:  707,
	1211:  707,
	1212:  708,
	1213:  708,
	1214:  709,
	1215:  709,
	1216:  710,
	1219:  711,
	1220:  711,
	1221:  712,
	1222:  713,
	1223:  714,
	1224:  714,
	1225:  715,
	1226:  716,
	1227:  717,
	1228:  717,
	1229:  718,
	1230:  719,
	1231:  720,
	1236:  721,
	1237:  721,
	1240:  722,
	1241:  722,
	1242:  722,
	1243:  722,
	1248:  723,
	1249:  723,
	1256:  724,
	1257:  724,
	1258:  724,
	1259:  724,
	1270:  725,
	1271:  726,
	1274:  727,
	1275:  728,
	1276:  729,
	1277:  730,
	1278:  731,
	1279:  732,
	1280:  733,
	1281:  734,
	1282:  735,
	1283:  736,
	1284:  737,
	1285:  738,
	1286:  739,
	1287:  740,
	1288:  741,
	1289:  742,
	1290:  743,
	1291:  744,
	1292:  745,
	1293:  746,
	1294:  747,
	1295:  748,
	1296:  749,
	1297:  750,
	1298:  751,
	1299:  752,
	1300:  753,
	1301:  754,
	1302:  755,
	1303:  756,
	1304:  757,
	1305:  758,
	1306:  759,
	1307:  760,
	1308:  761,
	1309:  762,
	1310:  763,
	1311:  764,
	1312:  765,
	1313:  766,
	1314:  767,
	1315:  768,
	1316:  769,
	1317:  770,
	1318:  771,
	1319:  772,
	1320:  773,
	1321:  774,
	1322:  775,
	1323:  776,
	1324:  777,
	1325:  778,
	1326:  779,
	1327:  780,
	1328:  781,
	1329:  782,
	1377:  782,
	1330:  783,
	1378:  783,
	1331:  784,
	1379:  784,
	1332:  785,
	1380:  785,
	1333:  786,
	1381:  786,
	1334:  787,
	1382:  787,
	1335:  788,
	1383:  788,
	1336:  789,
	1384:  789,
	1337:  790,
	1385:  790,
	1338:  791,
	1386:  791,
	1339:  792,
	1387:  792,
	1340:  793,
	1388:  793,
	1341:  794,
	1389:  794,
	1342:  795,
	1390:  795,
	1343:  796,
	1391:  796,
	1344:  797,
	1392:  797,
	1345:  798,
	1393:  798,
	1346:  799,
	1394:  799,
	1347:  800,
	1395:  800,
	1348:  801,
	1396:  801,
	1349:  802,
	1397:  802,
	1350:  803,
	1398:  803,
	1351:  804,
	1399:  804,
	1352:  805,
	1400:  805,
	1353:  806,
	1401:  806,
	1354:  807,
	1402:  807,
	1355:  808,
	1403:  808,
	1356:  809,
	1404:  809,
	1357:  810,
	1405:  810,
	1358:  811,
	1406:  811,
	1359:  812,
	1407:  812,
	1360:  813,
	1408:  813,
	1361:  814,
	1409:  814,
	1362:  815,
	1410:  815,
	1363:  816,
	1411:  816,
	1364:  817,
	1412:  817,
	1365:  818,
	1413:  818,
	1366:  819,
	1414:  819,
	1367:  820,
	1368:  821,
	1369:  822,
	1370:  823,
	1371:  824,
	1372:  825,
	1373:  826,
	1374:  827,
	1375:  828,
	1376:  829,
	7834:  7095,
	7836:  7096,
	7837:  7097,
	7838:  7098,
	7839:  7099,
	7930:  7100,
	7931:  7101,
	7932:  7102,
	7933:  7103,
	7934:  7104,
	7935:  7105,
	7958:  7106,
	7959:  7107,
	7966:  7108,
	7967:  7109,
	8006:  7110,
	8007:  7111,
	8014:  7112,
	8015:  7113,
	8024:  7114,
	8026:  7115,
	8028:  7116,
	8030:  7117,
	8062:  7118,
	8063:  7119,
	8117:  7120,
	8049:  7121,
	8123:  7121,
	8125:  7122,
	8127:  7123,
	8128:  7124,
	8129:  7125,
	8133:  7126,
	8051:  7127,
	8137:  7127,
	8053:  7128,
	8139:  7128,
	8141:  7129,
	8142:  7130,
	8143:  7131,
	8147:  7132,
	8148:  7133,
	8149:  7134,
	8055:  7135,
	8155:  7135,
	8156:  7136,
	8157:  7137,
	8158:  7138,
	8159:  7139,
	8163:  7140,
	8059:  7141,
	8171:  7141,
	8173:  7142,
	8174:  7143,
	8175:  7144,
	8176:  7145,
	8177:  7146,
	8181:  7147,
	8057:  7148,
	8185:  7148,
	8061:  7149,
	8187:  7149,
	8560:  7505,
	8545:  7506,
	8561:  7506,
	8546:  7507,
	8562:  7507,
	8547:  7508,
	8563:  7508,
	8548:  7509,
	8564:  7509,
	8549:  7510,
	8565:  7510,
	8550:  7511,
	8566:  7511,
	8551:  7512,
	8567:  7512,
	8552:  7513,
	8568:  7513,
	8553:  7514,
	8569:  7514,
	8554:  7515,
	8570:  7515,
	8555:  7516,
	8571:  7516,
	8556:  7517,
	8572:  7517,
	8557:  7518,
	8573:  7518,
	8558:  7519,
	8574:  7519,
	8559:  7520,
	9424:  8343,
	9399:  8344,
	9425:  8344,
	9400:  8345,
	9426:  8345,
	9401:  8346,
	9427:  8346,
	9402:  8347,
	9428:  8347,
	9403:  8348,
	9429:  8348,
	9404:  8349,
	9430:  8349,
	9405:  8350,
	9431:  8350,
	9406:  8351,
	9432:  8351,
	9407:  8352,
	9433:  8352,
	9408:  8353,
	9434:  8353,
	9409:  8354,
	9435:  8354,
	9410:  8355,
	9436:  8355,
	9411:  8356,
	9437:  8356,
	9412:  8357,
	9438:  8357,
	9413:  8358,
	9439:  8358,
	9414:  8359,
	9440:  8359,
	9415:  8360,
	9441:  8360,
	9416:  8361,
	9442:  8361,
	9417:  8362,
	9443:  8362,
	9418:  8363,
	9444:  8363,
	9419:  8364,
	9445:  8364,
	9420:  8365,
	9446:  8365,
	9421:  8366,
	9447:  8366,
	9422:  8367,
	9448:  8367,
	9423:  8368,
	57344: 54215,
	65345: 62184,
	65314: 62185,
	65346: 62185,
	65315: 62186,
	65347: 62186,
	65316: 62187,
	65348: 62187,
	65317: 62188,
	65349: 62188,
	65318: 62189,
	65350: 62189,
	65319: 62190,
	65351: 62190,
	65320: 62191,
	65352: 62191,
	65321: 62192,
	65353: 62192,
	65322: 62193,
	65354: 62193,
	65323: 62194,
	65355: 62194,
	65324: 62195,
	65356: 62195,
	65325: 62196,
	65357: 62196,
	65326: 62197,
	65358: 62197,
	65327: 62198,
	65359: 62198,
	65328: 62199,
	65360: 62199,
	65329: 62200,
	65361: 62200,
	65330: 62201,
	65362: 62201,
	65331: 62202,
	65363: 62202,
	65332: 62203,
	65364: 62203,
	65333: 62204,
	65365: 62204,
	65334: 62205,
	65366: 62205,
	65335: 62206,
	65367: 62206,
	65336: 62207,
	65368: 62207,
	65337: 62208,
	65369: 62208,
	65338: 62209,
	65370: 62209,
	65339: 62210,
	65340: 62211,
	65341: 62212,
	65342: 62213,
	65343: 62214,
	65344: 62215,
}
