// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Latin7_general_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `latin7_general_ci` collation.
func Latin7_general_ci_RuneWeight(r rune) int32 {
	weight, ok := latin7_general_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// latin7_general_ci_Weights contain a map from rune to weight for the `latin7_general_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var latin7_general_ci_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	127:  32,
	129:  33,
	131:  34,
	136:  35,
	138:  36,
	140:  37,
	144:  38,
	152:  39,
	154:  40,
	156:  41,
	159:  42,
	39:   43,
	45:   44,
	173:  45,
	216:  45,
	150:  46,
	151:  47,
	32:   48,
	160:  49,
	33:   50,
	34:   51,
	35:   52,
	36:   53,
	37:   54,
	38:   55,
	40:   56,
	41:   57,
	42:   58,
	44:   59,
	46:   60,
	47:   61,
	58:   62,
	59:   63,
	63:   64,
	64:   65,
	91:   66,
	92:   67,
	93:   68,
	94:   69,
	95:   70,
	96:   71,
	123:  72,
	124:  73,
	125:  74,
	126:  75,
	166:  76,
	141:  77,
	157:  78,
	8220: 79,
	143:  80,
	142:  81,
	8217: 82,
	158:  83,
	145:  84,
	146:  85,
	130:  86,
	147:  87,
	148:  88,
	132:  89,
	139:  90,
	155:  91,
	43:   92,
	60:   93,
	61:   94,
	62:   95,
	177:  96,
	171:  97,
	187:  98,
	215:  99,
	247:  100,
	162:  101,
	163:  102,
	164:  103,
	167:  104,
	169:  105,
	172:  106,
	174:  107,
	176:  108,
	181:  109,
	182:  110,
	183:  111,
	134:  112,
	135:  113,
	149:  114,
	133:  115,
	137:  116,
	128:  117,
	48:   118,
	188:  119,
	189:  120,
	190:  121,
	49:   122,
	185:  123,
	50:   124,
	178:  125,
	51:   126,
	179:  127,
	52:   128,
	53:   129,
	54:   130,
	55:   131,
	56:   132,
	57:   133,
	65:   134,
	97:   134,
	196:  135,
	228:  135,
	256:  136,
	257:  136,
	197:  137,
	229:  137,
	260:  138,
	261:  138,
	198:  139,
	230:  139,
	66:   140,
	98:   140,
	67:   141,
	99:   141,
	262:  142,
	263:  142,
	268:  143,
	269:  143,
	68:   144,
	100:  144,
	69:   145,
	101:  145,
	201:  146,
	233:  146,
	278:  147,
	279:  147,
	274:  148,
	275:  148,
	280:  149,
	281:  149,
	70:   150,
	102:  150,
	71:   151,
	103:  151,
	290:  152,
	291:  152,
	72:   153,
	104:  153,
	73:   154,
	105:  154,
	298:  155,
	299:  155,
	302:  156,
	303:  156,
	74:   157,
	106:  157,
	75:   158,
	107:  158,
	310:  159,
	311:  159,
	76:   160,
	108:  160,
	321:  161,
	322:  161,
	315:  162,
	316:  162,
	77:   163,
	109:  163,
	78:   164,
	110:  164,
	323:  165,
	324:  165,
	325:  166,
	326:  166,
	79:   167,
	111:  167,
	211:  168,
	243:  168,
	214:  169,
	246:  169,
	332:  170,
	333:  170,
	213:  171,
	245:  171,
	248:  172,
	80:   173,
	112:  173,
	81:   174,
	113:  174,
	82:   175,
	114:  175,
	342:  176,
	343:  177,
	83:   178,
	115:  178,
	346:  179,
	347:  179,
	223:  180,
	352:  181,
	353:  181,
	116:  182,
	84:   183,
	153:  184,
	85:   185,
	117:  185,
	220:  186,
	252:  186,
	362:  187,
	363:  187,
	370:  188,
	371:  188,
	86:   189,
	118:  189,
	87:   190,
	119:  190,
	88:   191,
	120:  191,
	89:   192,
	121:  192,
	90:   193,
	122:  193,
	377:  194,
	378:  194,
	379:  195,
	380:  195,
	381:  196,
	382:  196,
	8221: 197,
	8222: 198,
}
