// Copyright 2022 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Latin1 represents the `latin1` character set encoding.
var Latin1 Encoder = &RangeMap{
	inputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
			{
				inputRange:  rangeBounds{{128, 128}},
				outputRange: rangeBounds{{226, 226}, {130, 130}, {172, 172}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{129, 129}},
				outputRange: rangeBounds{{194, 194}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{130, 130}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {154, 154}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{131, 131}},
				outputRange: rangeBounds{{198, 198}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{132, 132}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{133, 133}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{134, 135}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {160, 161}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{136, 136}},
				outputRange: rangeBounds{{203, 203}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{137, 137}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {176, 176}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{138, 138}},
				outputRange: rangeBounds{{197, 197}, {160, 160}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{139, 139}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{140, 140}},
				outputRange: rangeBounds{{197, 197}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{141, 141}},
				outputRange: rangeBounds{{194, 194}, {141, 141}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{142, 142}},
				outputRange: rangeBounds{{197, 197}, {189, 189}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{143, 144}},
				outputRange: rangeBounds{{194, 194}, {143, 144}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{145, 146}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {152, 153}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{147, 148}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {156, 157}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{149, 149}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{150, 151}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {147, 148}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{152, 152}},
				outputRange: rangeBounds{{203, 203}, {156, 156}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{153, 153}},
				outputRange: rangeBounds{{226, 226}, {132, 132}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{154, 154}},
				outputRange: rangeBounds{{197, 197}, {161, 161}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{155, 155}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{156, 156}},
				outputRange: rangeBounds{{197, 197}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{157, 157}},
				outputRange: rangeBounds{{194, 194}, {157, 157}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{158, 158}},
				outputRange: rangeBounds{{197, 197}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{159, 159}},
				outputRange: rangeBounds{{197, 197}, {184, 184}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{160, 191}},
				outputRange: rangeBounds{{194, 194}, {160, 191}},
				inputMults:  []int{1},
				outputMults: []int{32, 1},
			},
			{
				inputRange:  rangeBounds{{192, 255}},
				outputRange: rangeBounds{{195, 195}, {128, 191}},
				inputMults:  []int{1},
				outputMults: []int{64, 1},
			},
		},
		nil,
		nil,
		nil,
	},
	outputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{129, 129}},
				outputRange: rangeBounds{{194, 194}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{131, 131}},
				outputRange: rangeBounds{{198, 198}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{136, 136}},
				outputRange: rangeBounds{{203, 203}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{138, 138}},
				outputRange: rangeBounds{{197, 197}, {160, 160}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{140, 140}},
				outputRange: rangeBounds{{197, 197}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{141, 141}},
				outputRange: rangeBounds{{194, 194}, {141, 141}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{142, 142}},
				outputRange: rangeBounds{{197, 197}, {189, 189}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{143, 144}},
				outputRange: rangeBounds{{194, 194}, {143, 144}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{152, 152}},
				outputRange: rangeBounds{{203, 203}, {156, 156}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{154, 154}},
				outputRange: rangeBounds{{197, 197}, {161, 161}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{156, 156}},
				outputRange: rangeBounds{{197, 197}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{157, 157}},
				outputRange: rangeBounds{{194, 194}, {157, 157}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{158, 158}},
				outputRange: rangeBounds{{197, 197}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{159, 159}},
				outputRange: rangeBounds{{197, 197}, {184, 184}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{160, 191}},
				outputRange: rangeBounds{{194, 194}, {160, 191}},
				inputMults:  []int{1},
				outputMults: []int{32, 1},
			},
			{
				inputRange:  rangeBounds{{192, 255}},
				outputRange: rangeBounds{{195, 195}, {128, 191}},
				inputMults:  []int{1},
				outputMults: []int{64, 1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{128, 128}},
				outputRange: rangeBounds{{226, 226}, {130, 130}, {172, 172}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{130, 130}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {154, 154}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{132, 132}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{133, 133}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{134, 135}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {160, 161}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{137, 137}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {176, 176}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{139, 139}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{145, 146}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {152, 153}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{147, 148}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {156, 157}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{149, 149}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{150, 151}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {147, 148}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{153, 153}},
				outputRange: rangeBounds{{226, 226}, {132, 132}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{155, 155}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
		},
		nil,
	},
	toUpper: map[rune]rune{
		97:  65,
		98:  66,
		99:  67,
		100: 68,
		101: 69,
		102: 70,
		103: 71,
		104: 72,
		105: 73,
		106: 74,
		107: 75,
		108: 76,
		109: 77,
		110: 78,
		111: 79,
		112: 80,
		113: 81,
		114: 82,
		115: 83,
		116: 84,
		117: 85,
		118: 86,
		119: 87,
		120: 88,
		121: 89,
		122: 90,
		224: 192,
		225: 193,
		226: 194,
		227: 195,
		228: 196,
		229: 197,
		230: 198,
		231: 199,
		232: 200,
		233: 201,
		234: 202,
		235: 203,
		236: 204,
		237: 205,
		238: 206,
		239: 207,
		240: 208,
		241: 209,
		242: 210,
		243: 211,
		244: 212,
		245: 213,
		246: 214,
		248: 216,
		249: 217,
		250: 218,
		251: 219,
		252: 220,
		253: 221,
		254: 222,
	},
	toLower: map[rune]rune{
		65:  97,
		66:  98,
		67:  99,
		68:  100,
		69:  101,
		70:  102,
		71:  103,
		72:  104,
		73:  105,
		74:  106,
		75:  107,
		76:  108,
		77:  109,
		78:  110,
		79:  111,
		80:  112,
		81:  113,
		82:  114,
		83:  115,
		84:  116,
		85:  117,
		86:  118,
		87:  119,
		88:  120,
		89:  121,
		90:  122,
		192: 224,
		193: 225,
		194: 226,
		195: 227,
		196: 228,
		197: 229,
		198: 230,
		199: 231,
		200: 232,
		201: 233,
		202: 234,
		203: 235,
		204: 236,
		205: 237,
		206: 238,
		207: 239,
		208: 240,
		209: 241,
		210: 242,
		211: 243,
		212: 244,
		213: 245,
		214: 246,
		216: 248,
		217: 249,
		218: 250,
		219: 251,
		220: 252,
		221: 253,
		222: 254,
	},
}
