--
-- PostgreSQL database dump
--

-- Dumped from database version 16.1 (Debian 16.1-1.pgdg120+1)
-- Dumped by pg_dump version 16.1 (Debian 16.1-1.pgdg120+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: auth_group; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.auth_group (
    id integer NOT NULL,
    name character varying(150) NOT NULL
);


ALTER TABLE public.auth_group OWNER TO authentik;

--
-- Name: auth_group_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.auth_group ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_group_permissions; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.auth_group_permissions (
    id integer NOT NULL,
    group_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.auth_group_permissions OWNER TO authentik;

--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.auth_group_permissions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_group_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_permission; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.auth_permission (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    codename character varying(100) NOT NULL
);


ALTER TABLE public.auth_permission OWNER TO authentik;

--
-- Name: auth_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.auth_permission ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_blueprints_blueprintinstance; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_blueprints_blueprintinstance (
    created timestamp with time zone NOT NULL,
    last_updated timestamp with time zone NOT NULL,
    managed text,
    instance_uuid uuid NOT NULL,
    name text NOT NULL,
    metadata jsonb NOT NULL,
    path text NOT NULL,
    context jsonb NOT NULL,
    last_applied timestamp with time zone NOT NULL,
    last_applied_hash text NOT NULL,
    status text NOT NULL,
    enabled boolean NOT NULL,
    managed_models text[] NOT NULL,
    content text NOT NULL
);


ALTER TABLE public.authentik_blueprints_blueprintinstance OWNER TO authentik;

--
-- Name: authentik_core_application; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_application (
    policybindingmodel_ptr_id uuid NOT NULL,
    name text NOT NULL,
    slug character varying(50) NOT NULL,
    meta_launch_url text NOT NULL,
    meta_description text NOT NULL,
    meta_publisher text NOT NULL,
    provider_id integer,
    meta_icon character varying(500),
    "group" text NOT NULL,
    open_in_new_tab boolean NOT NULL
);


ALTER TABLE public.authentik_core_application OWNER TO authentik;

--
-- Name: authentik_core_authenticatedsession; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_authenticatedsession (
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL,
    uuid uuid NOT NULL,
    session_key character varying(40) NOT NULL,
    last_ip text NOT NULL,
    last_user_agent text NOT NULL,
    last_used timestamp with time zone NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.authentik_core_authenticatedsession OWNER TO authentik;

--
-- Name: authentik_core_group; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_group (
    group_uuid uuid NOT NULL,
    name character varying(80) NOT NULL,
    attributes jsonb NOT NULL,
    parent_id uuid,
    is_superuser boolean NOT NULL
);


ALTER TABLE public.authentik_core_group OWNER TO authentik;

--
-- Name: authentik_core_group_roles; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_group_roles (
    id integer NOT NULL,
    group_id uuid NOT NULL,
    role_id uuid NOT NULL
);


ALTER TABLE public.authentik_core_group_roles OWNER TO authentik;

--
-- Name: authentik_core_group_roles_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_group_roles ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_group_roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_core_propertymapping; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_propertymapping (
    pm_uuid uuid NOT NULL,
    name text NOT NULL,
    expression text NOT NULL,
    managed text
);


ALTER TABLE public.authentik_core_propertymapping OWNER TO authentik;

--
-- Name: authentik_core_provider; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_provider (
    id integer NOT NULL,
    authorization_flow_id uuid,
    name text NOT NULL,
    authentication_flow_id uuid,
    backchannel_application_id uuid,
    is_backchannel boolean NOT NULL
);


ALTER TABLE public.authentik_core_provider OWNER TO authentik;

--
-- Name: authentik_core_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_provider ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_provider_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_core_provider_property_mappings; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_provider_property_mappings (
    id integer NOT NULL,
    provider_id integer NOT NULL,
    propertymapping_id uuid NOT NULL
);


ALTER TABLE public.authentik_core_provider_property_mappings OWNER TO authentik;

--
-- Name: authentik_core_provider_property_mappings_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_provider_property_mappings ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_provider_property_mappings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_core_source; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_source (
    policybindingmodel_ptr_id uuid NOT NULL,
    name text NOT NULL,
    slug character varying(50) NOT NULL,
    enabled boolean NOT NULL,
    authentication_flow_id uuid,
    enrollment_flow_id uuid,
    managed text,
    user_matching_mode text NOT NULL,
    user_path_template text NOT NULL,
    icon character varying(500)
);


ALTER TABLE public.authentik_core_source OWNER TO authentik;

--
-- Name: authentik_core_source_property_mappings; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_source_property_mappings (
    id integer NOT NULL,
    source_id uuid NOT NULL,
    propertymapping_id uuid NOT NULL
);


ALTER TABLE public.authentik_core_source_property_mappings OWNER TO authentik;

--
-- Name: authentik_core_source_property_mappings_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_source_property_mappings ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_source_property_mappings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_core_token; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_token (
    token_uuid uuid NOT NULL,
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL,
    description text NOT NULL,
    user_id integer NOT NULL,
    intent text NOT NULL,
    identifier character varying(255) NOT NULL,
    key text NOT NULL,
    managed text
);


ALTER TABLE public.authentik_core_token OWNER TO authentik;

--
-- Name: authentik_core_user; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_user (
    id integer NOT NULL,
    password character varying(128) NOT NULL,
    last_login timestamp with time zone,
    username character varying(150) NOT NULL,
    first_name character varying(150) NOT NULL,
    last_name character varying(150) NOT NULL,
    email character varying(254) NOT NULL,
    is_active boolean NOT NULL,
    date_joined timestamp with time zone NOT NULL,
    uuid uuid NOT NULL,
    name text NOT NULL,
    password_change_date timestamp with time zone NOT NULL,
    attributes jsonb NOT NULL,
    path text NOT NULL,
    type text NOT NULL
);


ALTER TABLE public.authentik_core_user OWNER TO authentik;

--
-- Name: authentik_core_user_ak_groups; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_user_ak_groups (
    id integer NOT NULL,
    user_id integer NOT NULL,
    group_id uuid NOT NULL
);


ALTER TABLE public.authentik_core_user_ak_groups OWNER TO authentik;

--
-- Name: authentik_core_user_groups; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_user_groups (
    id integer NOT NULL,
    user_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.authentik_core_user_groups OWNER TO authentik;

--
-- Name: authentik_core_user_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_user_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_user_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_core_user_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_user ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_core_user_pb_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_user_ak_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_user_pb_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_core_user_user_permissions; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_user_user_permissions (
    id integer NOT NULL,
    user_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.authentik_core_user_user_permissions OWNER TO authentik;

--
-- Name: authentik_core_user_user_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_user_user_permissions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_user_user_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_core_usersourceconnection; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_core_usersourceconnection (
    id integer NOT NULL,
    created timestamp with time zone NOT NULL,
    last_updated timestamp with time zone NOT NULL,
    source_id uuid NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.authentik_core_usersourceconnection OWNER TO authentik;

--
-- Name: authentik_core_usersourceconnection_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_core_usersourceconnection ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_core_usersourceconnection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_crypto_certificatekeypair; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_crypto_certificatekeypair (
    created timestamp with time zone NOT NULL,
    last_updated timestamp with time zone NOT NULL,
    kp_uuid uuid NOT NULL,
    name text NOT NULL,
    certificate_data text NOT NULL,
    key_data text NOT NULL,
    managed text
);


ALTER TABLE public.authentik_crypto_certificatekeypair OWNER TO authentik;

--
-- Name: authentik_enterprise_license; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_enterprise_license (
    license_uuid uuid NOT NULL,
    key text NOT NULL,
    name text NOT NULL,
    expiry timestamp with time zone NOT NULL,
    internal_users bigint NOT NULL,
    external_users bigint NOT NULL
);


ALTER TABLE public.authentik_enterprise_license OWNER TO authentik;

--
-- Name: authentik_enterprise_licenseusage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_enterprise_licenseusage (
    expiring boolean NOT NULL,
    expires timestamp with time zone NOT NULL,
    usage_uuid uuid NOT NULL,
    user_count bigint NOT NULL,
    external_user_count bigint NOT NULL,
    within_limits boolean NOT NULL,
    record_date timestamp with time zone NOT NULL
);


ALTER TABLE public.authentik_enterprise_licenseusage OWNER TO authentik;

--
-- Name: authentik_events_event; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_events_event (
    event_uuid uuid NOT NULL,
    action text NOT NULL,
    app text NOT NULL,
    context jsonb NOT NULL,
    client_ip inet,
    created timestamp with time zone NOT NULL,
    "user" jsonb NOT NULL,
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL,
    tenant jsonb NOT NULL
);


ALTER TABLE public.authentik_events_event OWNER TO authentik;

--
-- Name: authentik_events_notification; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_events_notification (
    uuid uuid NOT NULL,
    severity text NOT NULL,
    body text NOT NULL,
    created timestamp with time zone NOT NULL,
    seen boolean NOT NULL,
    event_id uuid,
    user_id integer NOT NULL
);


ALTER TABLE public.authentik_events_notification OWNER TO authentik;

--
-- Name: authentik_events_notificationrule; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_events_notificationrule (
    policybindingmodel_ptr_id uuid NOT NULL,
    name text NOT NULL,
    severity text NOT NULL,
    group_id uuid
);


ALTER TABLE public.authentik_events_notificationrule OWNER TO authentik;

--
-- Name: authentik_events_notificationrule_transports; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_events_notificationrule_transports (
    id integer NOT NULL,
    notificationrule_id uuid NOT NULL,
    notificationtransport_id uuid NOT NULL
);


ALTER TABLE public.authentik_events_notificationrule_transports OWNER TO authentik;

--
-- Name: authentik_events_notificationrule_transports_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_events_notificationrule_transports ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_events_notificationrule_transports_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_events_notificationtransport; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_events_notificationtransport (
    uuid uuid NOT NULL,
    name text NOT NULL,
    mode text NOT NULL,
    webhook_url text NOT NULL,
    send_once boolean NOT NULL,
    webhook_mapping_id uuid
);


ALTER TABLE public.authentik_events_notificationtransport OWNER TO authentik;

--
-- Name: authentik_events_notificationwebhookmapping; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_events_notificationwebhookmapping (
    propertymapping_ptr_id uuid NOT NULL
);


ALTER TABLE public.authentik_events_notificationwebhookmapping OWNER TO authentik;

--
-- Name: authentik_flows_flow; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_flows_flow (
    flow_uuid uuid NOT NULL,
    name text NOT NULL,
    slug character varying(50) NOT NULL,
    designation character varying(100) NOT NULL,
    policybindingmodel_ptr_id uuid NOT NULL,
    title text NOT NULL,
    background character varying(500),
    compatibility_mode boolean NOT NULL,
    layout text NOT NULL,
    denied_action text NOT NULL,
    authentication text NOT NULL
);


ALTER TABLE public.authentik_flows_flow OWNER TO authentik;

--
-- Name: authentik_flows_flowstagebinding; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_flows_flowstagebinding (
    policybindingmodel_ptr_id uuid NOT NULL,
    fsb_uuid uuid NOT NULL,
    re_evaluate_policies boolean NOT NULL,
    "order" integer NOT NULL,
    target_id uuid NOT NULL,
    stage_id uuid NOT NULL,
    evaluate_on_plan boolean NOT NULL,
    invalid_response_action text NOT NULL
);


ALTER TABLE public.authentik_flows_flowstagebinding OWNER TO authentik;

--
-- Name: authentik_flows_flowtoken; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_flows_flowtoken (
    token_ptr_id uuid NOT NULL,
    _plan text NOT NULL,
    flow_id uuid NOT NULL
);


ALTER TABLE public.authentik_flows_flowtoken OWNER TO authentik;

--
-- Name: authentik_flows_stage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_flows_stage (
    stage_uuid uuid NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.authentik_flows_stage OWNER TO authentik;

--
-- Name: authentik_install_id; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_install_id (
    id text NOT NULL
);


ALTER TABLE public.authentik_install_id OWNER TO authentik;

--
-- Name: authentik_outposts_dockerserviceconnection; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_outposts_dockerserviceconnection (
    outpostserviceconnection_ptr_id uuid NOT NULL,
    url text NOT NULL,
    tls_authentication_id uuid,
    tls_verification_id uuid
);


ALTER TABLE public.authentik_outposts_dockerserviceconnection OWNER TO authentik;

--
-- Name: authentik_outposts_kubernetesserviceconnection; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_outposts_kubernetesserviceconnection (
    outpostserviceconnection_ptr_id uuid NOT NULL,
    kubeconfig jsonb NOT NULL,
    verify_ssl boolean NOT NULL
);


ALTER TABLE public.authentik_outposts_kubernetesserviceconnection OWNER TO authentik;

--
-- Name: authentik_outposts_outpost; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_outposts_outpost (
    uuid uuid NOT NULL,
    name text NOT NULL,
    _config jsonb NOT NULL,
    type text NOT NULL,
    service_connection_id uuid,
    managed text
);


ALTER TABLE public.authentik_outposts_outpost OWNER TO authentik;

--
-- Name: authentik_outposts_outpost_providers; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_outposts_outpost_providers (
    id integer NOT NULL,
    outpost_id uuid NOT NULL,
    provider_id integer NOT NULL
);


ALTER TABLE public.authentik_outposts_outpost_providers OWNER TO authentik;

--
-- Name: authentik_outposts_outpost_providers_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_outposts_outpost_providers ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_outposts_outpost_providers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_outposts_outpostserviceconnection; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_outposts_outpostserviceconnection (
    uuid uuid NOT NULL,
    name text NOT NULL,
    local boolean NOT NULL
);


ALTER TABLE public.authentik_outposts_outpostserviceconnection OWNER TO authentik;

--
-- Name: authentik_policies_dummy_dummypolicy; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_dummy_dummypolicy (
    policy_ptr_id uuid NOT NULL,
    result boolean NOT NULL,
    wait_min integer NOT NULL,
    wait_max integer NOT NULL
);


ALTER TABLE public.authentik_policies_dummy_dummypolicy OWNER TO authentik;

--
-- Name: authentik_policies_event_matcher_eventmatcherpolicy; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_event_matcher_eventmatcherpolicy (
    policy_ptr_id uuid NOT NULL,
    action text,
    client_ip text,
    app text,
    model text
);


ALTER TABLE public.authentik_policies_event_matcher_eventmatcherpolicy OWNER TO authentik;

--
-- Name: authentik_policies_expiry_passwordexpirypolicy; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_expiry_passwordexpirypolicy (
    policy_ptr_id uuid NOT NULL,
    deny_only boolean NOT NULL,
    days integer NOT NULL
);


ALTER TABLE public.authentik_policies_expiry_passwordexpirypolicy OWNER TO authentik;

--
-- Name: authentik_policies_expression_expressionpolicy; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_expression_expressionpolicy (
    policy_ptr_id uuid NOT NULL,
    expression text NOT NULL
);


ALTER TABLE public.authentik_policies_expression_expressionpolicy OWNER TO authentik;

--
-- Name: authentik_policies_password_passwordpolicy; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_password_passwordpolicy (
    policy_ptr_id uuid NOT NULL,
    amount_uppercase integer NOT NULL,
    amount_lowercase integer NOT NULL,
    amount_symbols integer NOT NULL,
    length_min integer NOT NULL,
    symbol_charset text NOT NULL,
    error_message text NOT NULL,
    password_field text NOT NULL,
    amount_digits integer NOT NULL,
    check_have_i_been_pwned boolean NOT NULL,
    check_static_rules boolean NOT NULL,
    check_zxcvbn boolean NOT NULL,
    hibp_allowed_count integer NOT NULL,
    zxcvbn_score_threshold integer NOT NULL,
    CONSTRAINT authentik_policies_pass_amount_lowercase_9d79427e_check CHECK ((amount_lowercase >= 0)),
    CONSTRAINT authentik_policies_pass_amount_symbols_d57af249_check CHECK ((amount_symbols >= 0)),
    CONSTRAINT authentik_policies_pass_amount_uppercase_7c908a32_check CHECK ((amount_uppercase >= 0)),
    CONSTRAINT authentik_policies_pass_length_min_7acd2128_check CHECK ((length_min >= 0)),
    CONSTRAINT authentik_policies_password_passwo_zxcvbn_score_threshold_check CHECK ((zxcvbn_score_threshold >= 0)),
    CONSTRAINT authentik_policies_password_passwordpo_hibp_allowed_count_check CHECK ((hibp_allowed_count >= 0)),
    CONSTRAINT authentik_policies_password_passwordpolicy_amount_digits_check CHECK ((amount_digits >= 0))
);


ALTER TABLE public.authentik_policies_password_passwordpolicy OWNER TO authentik;

--
-- Name: authentik_policies_policy; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_policy (
    created timestamp with time zone NOT NULL,
    last_updated timestamp with time zone NOT NULL,
    policy_uuid uuid NOT NULL,
    name text NOT NULL,
    execution_logging boolean NOT NULL
);


ALTER TABLE public.authentik_policies_policy OWNER TO authentik;

--
-- Name: authentik_policies_policybinding; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_policybinding (
    policy_binding_uuid uuid NOT NULL,
    enabled boolean NOT NULL,
    "order" integer NOT NULL,
    policy_id uuid,
    target_id uuid NOT NULL,
    negate boolean NOT NULL,
    timeout integer NOT NULL,
    group_id uuid,
    user_id integer,
    failure_result boolean NOT NULL,
    CONSTRAINT authentik_policies_policybinding_timeout_b41b0d57_check CHECK ((timeout >= 0))
);


ALTER TABLE public.authentik_policies_policybinding OWNER TO authentik;

--
-- Name: authentik_policies_policybindingmodel; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_policybindingmodel (
    pbm_uuid uuid NOT NULL,
    policy_engine_mode text NOT NULL
);


ALTER TABLE public.authentik_policies_policybindingmodel OWNER TO authentik;

--
-- Name: authentik_policies_reputation_reputation; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_reputation_reputation (
    reputation_uuid uuid NOT NULL,
    identifier text NOT NULL,
    ip inet NOT NULL,
    ip_geo_data jsonb NOT NULL,
    score bigint NOT NULL,
    updated timestamp with time zone NOT NULL,
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL
);


ALTER TABLE public.authentik_policies_reputation_reputation OWNER TO authentik;

--
-- Name: authentik_policies_reputation_reputationpolicy; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_policies_reputation_reputationpolicy (
    policy_ptr_id uuid NOT NULL,
    check_ip boolean NOT NULL,
    check_username boolean NOT NULL,
    threshold integer NOT NULL
);


ALTER TABLE public.authentik_policies_reputation_reputationpolicy OWNER TO authentik;

--
-- Name: authentik_providers_ldap_ldapprovider; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_ldap_ldapprovider (
    provider_ptr_id integer NOT NULL,
    base_dn text NOT NULL,
    search_group_id uuid,
    certificate_id uuid,
    tls_server_name text NOT NULL,
    gid_start_number integer NOT NULL,
    uid_start_number integer NOT NULL,
    search_mode text NOT NULL,
    bind_mode text NOT NULL,
    mfa_support boolean NOT NULL
);


ALTER TABLE public.authentik_providers_ldap_ldapprovider OWNER TO authentik;

--
-- Name: authentik_providers_oauth2_accesstoken; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_oauth2_accesstoken (
    id integer NOT NULL,
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL,
    revoked boolean NOT NULL,
    _scope text NOT NULL,
    token text NOT NULL,
    _id_token text NOT NULL,
    provider_id integer NOT NULL,
    user_id integer NOT NULL,
    auth_time timestamp with time zone NOT NULL,
    session_id character varying NOT NULL
);


ALTER TABLE public.authentik_providers_oauth2_accesstoken OWNER TO authentik;

--
-- Name: authentik_providers_oauth2_accesstoken_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_providers_oauth2_accesstoken ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_providers_oauth2_accesstoken_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_providers_oauth2_authorizationcode; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_oauth2_authorizationcode (
    id integer NOT NULL,
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL,
    _scope text NOT NULL,
    code character varying(255) NOT NULL,
    nonce text,
    code_challenge character varying(255),
    code_challenge_method character varying(255),
    provider_id integer NOT NULL,
    user_id integer NOT NULL,
    revoked boolean NOT NULL,
    auth_time timestamp with time zone NOT NULL,
    session_id character varying NOT NULL
);


ALTER TABLE public.authentik_providers_oauth2_authorizationcode OWNER TO authentik;

--
-- Name: authentik_providers_oauth2_authorizationcode_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_providers_oauth2_authorizationcode ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_providers_oauth2_authorizationcode_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_providers_oauth2_devicetoken; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_oauth2_devicetoken (
    id integer NOT NULL,
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL,
    device_code text NOT NULL,
    user_code text NOT NULL,
    _scope text NOT NULL,
    provider_id integer NOT NULL,
    user_id integer
);


ALTER TABLE public.authentik_providers_oauth2_devicetoken OWNER TO authentik;

--
-- Name: authentik_providers_oauth2_devicetoken_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_providers_oauth2_devicetoken ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_providers_oauth2_devicetoken_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_providers_oauth2_oauth2provider; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_oauth2_oauth2provider (
    provider_ptr_id integer NOT NULL,
    client_type character varying(30) NOT NULL,
    client_id character varying(255) NOT NULL,
    client_secret character varying(255) NOT NULL,
    redirect_uris text NOT NULL,
    include_claims_in_id_token boolean NOT NULL,
    refresh_token_validity text NOT NULL,
    signing_key_id uuid,
    sub_mode text NOT NULL,
    issuer_mode text NOT NULL,
    access_code_validity text NOT NULL,
    access_token_validity text NOT NULL
);


ALTER TABLE public.authentik_providers_oauth2_oauth2provider OWNER TO authentik;

--
-- Name: authentik_providers_oauth2_oauth2provider_jwks_sources; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_oauth2_oauth2provider_jwks_sources (
    id integer NOT NULL,
    oauth2provider_id integer NOT NULL,
    oauthsource_id uuid NOT NULL
);


ALTER TABLE public.authentik_providers_oauth2_oauth2provider_jwks_sources OWNER TO authentik;

--
-- Name: authentik_providers_oauth2_oauth2provider_jwks_sources_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_providers_oauth2_oauth2provider_jwks_sources ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_providers_oauth2_oauth2provider_jwks_sources_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_providers_oauth2_refreshtoken; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_oauth2_refreshtoken (
    id integer NOT NULL,
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL,
    _scope text NOT NULL,
    _id_token text NOT NULL,
    provider_id integer NOT NULL,
    user_id integer NOT NULL,
    revoked boolean NOT NULL,
    token text NOT NULL,
    auth_time timestamp with time zone NOT NULL,
    session_id character varying NOT NULL
);


ALTER TABLE public.authentik_providers_oauth2_refreshtoken OWNER TO authentik;

--
-- Name: authentik_providers_oauth2_refreshtoken_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_providers_oauth2_refreshtoken ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_providers_oauth2_refreshtoken_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_providers_oauth2_scopemapping; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_oauth2_scopemapping (
    propertymapping_ptr_id uuid NOT NULL,
    scope_name text NOT NULL,
    description text NOT NULL
);


ALTER TABLE public.authentik_providers_oauth2_scopemapping OWNER TO authentik;

--
-- Name: authentik_providers_proxy_proxyprovider; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_proxy_proxyprovider (
    oauth2provider_ptr_id integer NOT NULL,
    internal_host text NOT NULL,
    external_host text NOT NULL,
    cookie_secret text NOT NULL,
    certificate_id uuid,
    skip_path_regex text NOT NULL,
    internal_host_ssl_validation boolean NOT NULL,
    basic_auth_enabled boolean NOT NULL,
    basic_auth_password_attribute text NOT NULL,
    basic_auth_user_attribute text NOT NULL,
    cookie_domain text NOT NULL,
    mode text NOT NULL,
    intercept_header_auth boolean NOT NULL
);


ALTER TABLE public.authentik_providers_proxy_proxyprovider OWNER TO authentik;

--
-- Name: authentik_providers_radius_radiusprovider; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_radius_radiusprovider (
    provider_ptr_id integer NOT NULL,
    shared_secret text NOT NULL,
    client_networks text NOT NULL,
    mfa_support boolean NOT NULL
);


ALTER TABLE public.authentik_providers_radius_radiusprovider OWNER TO authentik;

--
-- Name: authentik_providers_saml_samlpropertymapping; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_saml_samlpropertymapping (
    propertymapping_ptr_id uuid NOT NULL,
    saml_name text NOT NULL,
    friendly_name text
);


ALTER TABLE public.authentik_providers_saml_samlpropertymapping OWNER TO authentik;

--
-- Name: authentik_providers_saml_samlprovider; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_saml_samlprovider (
    provider_ptr_id integer NOT NULL,
    acs_url character varying(200) NOT NULL,
    audience text NOT NULL,
    issuer text NOT NULL,
    assertion_valid_not_before text NOT NULL,
    assertion_valid_not_on_or_after text NOT NULL,
    session_valid_not_on_or_after text NOT NULL,
    digest_algorithm character varying(50) NOT NULL,
    signature_algorithm character varying(50) NOT NULL,
    signing_kp_id uuid,
    sp_binding text NOT NULL,
    verification_kp_id uuid,
    name_id_mapping_id uuid,
    default_relay_state text NOT NULL
);


ALTER TABLE public.authentik_providers_saml_samlprovider OWNER TO authentik;

--
-- Name: authentik_providers_scim_scimgroup; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_scim_scimgroup (
    id text NOT NULL,
    group_id uuid NOT NULL,
    provider_id integer NOT NULL
);


ALTER TABLE public.authentik_providers_scim_scimgroup OWNER TO authentik;

--
-- Name: authentik_providers_scim_scimmapping; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_scim_scimmapping (
    propertymapping_ptr_id uuid NOT NULL
);


ALTER TABLE public.authentik_providers_scim_scimmapping OWNER TO authentik;

--
-- Name: authentik_providers_scim_scimprovider; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_scim_scimprovider (
    provider_ptr_id integer NOT NULL,
    url text NOT NULL,
    token text NOT NULL,
    exclude_users_service_account boolean NOT NULL,
    filter_group_id uuid
);


ALTER TABLE public.authentik_providers_scim_scimprovider OWNER TO authentik;

--
-- Name: authentik_providers_scim_scimprovider_property_mappings_group; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_scim_scimprovider_property_mappings_group (
    id integer NOT NULL,
    scimprovider_id integer NOT NULL,
    propertymapping_id uuid NOT NULL
);


ALTER TABLE public.authentik_providers_scim_scimprovider_property_mappings_group OWNER TO authentik;

--
-- Name: authentik_providers_scim_scimprovider_property_mappings__id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_providers_scim_scimprovider_property_mappings_group ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_providers_scim_scimprovider_property_mappings__id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_providers_scim_scimuser; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_providers_scim_scimuser (
    id text NOT NULL,
    provider_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.authentik_providers_scim_scimuser OWNER TO authentik;

--
-- Name: authentik_rbac_role; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_rbac_role (
    uuid uuid NOT NULL,
    name text NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.authentik_rbac_role OWNER TO authentik;

--
-- Name: authentik_sources_ldap_ldappropertymapping; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_ldap_ldappropertymapping (
    propertymapping_ptr_id uuid NOT NULL,
    object_field text NOT NULL
);


ALTER TABLE public.authentik_sources_ldap_ldappropertymapping OWNER TO authentik;

--
-- Name: authentik_sources_ldap_ldapsource; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_ldap_ldapsource (
    source_ptr_id uuid NOT NULL,
    server_uri text NOT NULL,
    bind_cn text NOT NULL,
    bind_password text NOT NULL,
    start_tls boolean NOT NULL,
    base_dn text NOT NULL,
    additional_user_dn text NOT NULL,
    additional_group_dn text NOT NULL,
    user_object_filter text NOT NULL,
    group_object_filter text NOT NULL,
    object_uniqueness_field text NOT NULL,
    sync_groups boolean NOT NULL,
    sync_parent_group_id uuid,
    sync_users boolean NOT NULL,
    sync_users_password boolean NOT NULL,
    group_membership_field text NOT NULL,
    peer_certificate_id uuid,
    client_certificate_id uuid,
    sni boolean NOT NULL
);


ALTER TABLE public.authentik_sources_ldap_ldapsource OWNER TO authentik;

--
-- Name: authentik_sources_ldap_ldapsource_property_mappings_group; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_ldap_ldapsource_property_mappings_group (
    id integer NOT NULL,
    ldapsource_id uuid NOT NULL,
    propertymapping_id uuid NOT NULL
);


ALTER TABLE public.authentik_sources_ldap_ldapsource_property_mappings_group OWNER TO authentik;

--
-- Name: authentik_sources_ldap_ldapsource_property_mappings_grou_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_sources_ldap_ldapsource_property_mappings_group ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_sources_ldap_ldapsource_property_mappings_grou_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_sources_oauth_oauthsource; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_oauth_oauthsource (
    source_ptr_id uuid NOT NULL,
    provider_type character varying(255) NOT NULL,
    request_token_url character varying(255),
    authorization_url character varying(255),
    access_token_url character varying(255),
    profile_url character varying(255),
    consumer_key text NOT NULL,
    consumer_secret text NOT NULL,
    additional_scopes text NOT NULL,
    oidc_jwks jsonb NOT NULL,
    oidc_jwks_url text NOT NULL,
    oidc_well_known_url text NOT NULL
);


ALTER TABLE public.authentik_sources_oauth_oauthsource OWNER TO authentik;

--
-- Name: authentik_sources_oauth_useroauthsourceconnection; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_oauth_useroauthsourceconnection (
    usersourceconnection_ptr_id integer NOT NULL,
    identifier character varying(255) NOT NULL,
    access_token text
);


ALTER TABLE public.authentik_sources_oauth_useroauthsourceconnection OWNER TO authentik;

--
-- Name: authentik_sources_plex_plexsource; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_plex_plexsource (
    source_ptr_id uuid NOT NULL,
    client_id text NOT NULL,
    allowed_servers text[] NOT NULL,
    allow_friends boolean NOT NULL,
    plex_token text NOT NULL
);


ALTER TABLE public.authentik_sources_plex_plexsource OWNER TO authentik;

--
-- Name: authentik_sources_plex_plexsourceconnection; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_plex_plexsourceconnection (
    usersourceconnection_ptr_id integer NOT NULL,
    plex_token text NOT NULL,
    identifier text NOT NULL
);


ALTER TABLE public.authentik_sources_plex_plexsourceconnection OWNER TO authentik;

--
-- Name: authentik_sources_saml_samlsource; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_saml_samlsource (
    source_ptr_id uuid NOT NULL,
    issuer text NOT NULL,
    sso_url character varying(200) NOT NULL,
    slo_url character varying(200),
    signing_kp_id uuid,
    binding_type character varying(100) NOT NULL,
    temporary_user_delete_after text NOT NULL,
    name_id_policy text NOT NULL,
    allow_idp_initiated boolean NOT NULL,
    digest_algorithm character varying(50) NOT NULL,
    signature_algorithm character varying(50) NOT NULL,
    pre_authentication_flow_id uuid NOT NULL,
    verification_kp_id uuid
);


ALTER TABLE public.authentik_sources_saml_samlsource OWNER TO authentik;

--
-- Name: authentik_sources_saml_usersamlsourceconnection; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_sources_saml_usersamlsourceconnection (
    usersourceconnection_ptr_id integer NOT NULL,
    identifier text NOT NULL
);


ALTER TABLE public.authentik_sources_saml_usersamlsourceconnection OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_duo_authenticatorduostage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_duo_authenticatorduostage (
    stage_ptr_id uuid NOT NULL,
    client_id text NOT NULL,
    client_secret text NOT NULL,
    api_hostname text NOT NULL,
    configure_flow_id uuid,
    admin_integration_key text NOT NULL,
    admin_secret_key text NOT NULL,
    friendly_name text
);


ALTER TABLE public.authentik_stages_authenticator_duo_authenticatorduostage OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_duo_duodevice; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_duo_duodevice (
    id integer NOT NULL,
    name character varying(64) NOT NULL,
    confirmed boolean NOT NULL,
    duo_user_id text NOT NULL,
    stage_id uuid NOT NULL,
    user_id integer NOT NULL,
    last_t timestamp with time zone NOT NULL
);


ALTER TABLE public.authentik_stages_authenticator_duo_duodevice OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_duo_duodevice_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_authenticator_duo_duodevice ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_authenticator_duo_duodevice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_authenticator_sms_authenticatorsmsstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_sms_authenticatorsmsstage (
    stage_ptr_id uuid NOT NULL,
    provider text NOT NULL,
    account_sid text NOT NULL,
    auth text NOT NULL,
    configure_flow_id uuid,
    from_number text NOT NULL,
    auth_password text NOT NULL,
    auth_type text NOT NULL,
    verify_only boolean NOT NULL,
    mapping_id uuid,
    friendly_name text
);


ALTER TABLE public.authentik_stages_authenticator_sms_authenticatorsmsstage OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_sms_smsdevice; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_sms_smsdevice (
    id integer NOT NULL,
    name character varying(64) NOT NULL,
    confirmed boolean NOT NULL,
    token character varying(16),
    valid_until timestamp with time zone NOT NULL,
    phone_number text NOT NULL,
    stage_id uuid NOT NULL,
    user_id integer NOT NULL,
    last_t timestamp with time zone NOT NULL
);


ALTER TABLE public.authentik_stages_authenticator_sms_smsdevice OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_sms_smsdevice_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_authenticator_sms_smsdevice ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_authenticator_sms_smsdevice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_authenticator_static_authenticatorstaticstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_static_authenticatorstaticstage (
    stage_ptr_id uuid NOT NULL,
    token_count integer NOT NULL,
    configure_flow_id uuid,
    friendly_name text,
    token_length integer NOT NULL,
    CONSTRAINT authentik_stages_authen_token_count_72138a40_check CHECK ((token_count >= 0)),
    CONSTRAINT authentik_stages_authenticator_static_authen_token_length_check CHECK ((token_length >= 0))
);


ALTER TABLE public.authentik_stages_authenticator_static_authenticatorstaticstage OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_static_staticdevice; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_static_staticdevice (
    id integer NOT NULL,
    name character varying(64) NOT NULL,
    confirmed boolean NOT NULL,
    user_id integer NOT NULL,
    throttling_failure_count integer NOT NULL,
    throttling_failure_timestamp timestamp with time zone,
    CONSTRAINT otp_static_staticdevice_throttling_failure_count_check CHECK ((throttling_failure_count >= 0))
);


ALTER TABLE public.authentik_stages_authenticator_static_staticdevice OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_static_staticdevice_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_authenticator_static_staticdevice ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_authenticator_static_staticdevice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_authenticator_static_statictoken; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_static_statictoken (
    id integer NOT NULL,
    token character varying(16) NOT NULL,
    device_id integer NOT NULL
);


ALTER TABLE public.authentik_stages_authenticator_static_statictoken OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_static_statictoken_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_authenticator_static_statictoken ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_authenticator_static_statictoken_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_authenticator_totp_authenticatortotpstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_totp_authenticatortotpstage (
    stage_ptr_id uuid NOT NULL,
    digits integer NOT NULL,
    configure_flow_id uuid,
    friendly_name text
);


ALTER TABLE public.authentik_stages_authenticator_totp_authenticatortotpstage OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_totp_totpdevice; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_totp_totpdevice (
    id integer NOT NULL,
    name character varying(64) NOT NULL,
    confirmed boolean NOT NULL,
    key character varying(80) NOT NULL,
    step smallint NOT NULL,
    t0 bigint NOT NULL,
    digits smallint NOT NULL,
    tolerance smallint NOT NULL,
    drift smallint NOT NULL,
    last_t bigint NOT NULL,
    user_id integer NOT NULL,
    throttling_failure_count integer NOT NULL,
    throttling_failure_timestamp timestamp with time zone,
    CONSTRAINT otp_totp_totpdevice_digits_check CHECK ((digits >= 0)),
    CONSTRAINT otp_totp_totpdevice_step_check CHECK ((step >= 0)),
    CONSTRAINT otp_totp_totpdevice_throttling_failure_count_check CHECK ((throttling_failure_count >= 0)),
    CONSTRAINT otp_totp_totpdevice_tolerance_check CHECK ((tolerance >= 0))
);


ALTER TABLE public.authentik_stages_authenticator_totp_totpdevice OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_totp_totpdevice_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_authenticator_totp_totpdevice ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_authenticator_totp_totpdevice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_authenticator_validate_authenticatorvalida3e25; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_validate_authenticatorvalida3e25 (
    id integer NOT NULL,
    authenticatorvalidatestage_id uuid NOT NULL,
    stage_id uuid NOT NULL
);


ALTER TABLE public.authentik_stages_authenticator_validate_authenticatorvalida3e25 OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_validate_authenticatorval_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_authenticator_validate_authenticatorvalida3e25 ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_authenticator_validate_authenticatorval_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_authenticator_validate_authenticatorvalida499c; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_validate_authenticatorvalida499c (
    stage_ptr_id uuid NOT NULL,
    not_configured_action text NOT NULL,
    device_classes text[] NOT NULL,
    last_auth_threshold text NOT NULL,
    webauthn_user_verification text NOT NULL
);


ALTER TABLE public.authentik_stages_authenticator_validate_authenticatorvalida499c OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_webauthn_authenticatewebauth4bbe; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_webauthn_authenticatewebauth4bbe (
    stage_ptr_id uuid NOT NULL,
    configure_flow_id uuid,
    user_verification text NOT NULL,
    authenticator_attachment text,
    resident_key_requirement text NOT NULL,
    friendly_name text
);


ALTER TABLE public.authentik_stages_authenticator_webauthn_authenticatewebauth4bbe OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_webauthn_webauthndevice; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_authenticator_webauthn_webauthndevice (
    id integer NOT NULL,
    name text NOT NULL,
    credential_id text NOT NULL,
    public_key text NOT NULL,
    sign_count integer NOT NULL,
    rp_id character varying(253) NOT NULL,
    created_on timestamp with time zone NOT NULL,
    last_t timestamp with time zone NOT NULL,
    user_id integer NOT NULL,
    confirmed boolean NOT NULL
);


ALTER TABLE public.authentik_stages_authenticator_webauthn_webauthndevice OWNER TO authentik;

--
-- Name: authentik_stages_authenticator_webauthn_webauthndevice_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_authenticator_webauthn_webauthndevice ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_authenticator_webauthn_webauthndevice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_captcha_captchastage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_captcha_captchastage (
    stage_ptr_id uuid NOT NULL,
    public_key text NOT NULL,
    private_key text NOT NULL,
    api_url text NOT NULL,
    js_url text NOT NULL
);


ALTER TABLE public.authentik_stages_captcha_captchastage OWNER TO authentik;

--
-- Name: authentik_stages_consent_consentstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_consent_consentstage (
    stage_ptr_id uuid NOT NULL,
    consent_expire_in text NOT NULL,
    mode text NOT NULL
);


ALTER TABLE public.authentik_stages_consent_consentstage OWNER TO authentik;

--
-- Name: authentik_stages_consent_userconsent; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_consent_userconsent (
    id integer NOT NULL,
    expires timestamp with time zone NOT NULL,
    expiring boolean NOT NULL,
    application_id uuid NOT NULL,
    user_id integer NOT NULL,
    permissions text NOT NULL
);


ALTER TABLE public.authentik_stages_consent_userconsent OWNER TO authentik;

--
-- Name: authentik_stages_consent_userconsent_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_consent_userconsent ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_consent_userconsent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_deny_denystage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_deny_denystage (
    stage_ptr_id uuid NOT NULL,
    deny_message text NOT NULL
);


ALTER TABLE public.authentik_stages_deny_denystage OWNER TO authentik;

--
-- Name: authentik_stages_dummy_dummystage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_dummy_dummystage (
    stage_ptr_id uuid NOT NULL,
    throw_error boolean NOT NULL
);


ALTER TABLE public.authentik_stages_dummy_dummystage OWNER TO authentik;

--
-- Name: authentik_stages_email_emailstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_email_emailstage (
    stage_ptr_id uuid NOT NULL,
    host text NOT NULL,
    port integer NOT NULL,
    username text NOT NULL,
    password text NOT NULL,
    use_tls boolean NOT NULL,
    use_ssl boolean NOT NULL,
    timeout integer NOT NULL,
    from_address character varying(254) NOT NULL,
    token_expiry integer NOT NULL,
    subject text NOT NULL,
    template text NOT NULL,
    use_global_settings boolean NOT NULL,
    activate_user_on_success boolean NOT NULL
);


ALTER TABLE public.authentik_stages_email_emailstage OWNER TO authentik;

--
-- Name: authentik_stages_identification_identificationstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_identification_identificationstage (
    stage_ptr_id uuid NOT NULL,
    user_fields character varying(100)[] NOT NULL,
    enrollment_flow_id uuid,
    recovery_flow_id uuid,
    case_insensitive_matching boolean NOT NULL,
    show_matched_user boolean NOT NULL,
    password_stage_id uuid,
    show_source_labels boolean NOT NULL,
    passwordless_flow_id uuid
);


ALTER TABLE public.authentik_stages_identification_identificationstage OWNER TO authentik;

--
-- Name: authentik_stages_identification_identificationstage_sources; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_identification_identificationstage_sources (
    id integer NOT NULL,
    identificationstage_id uuid NOT NULL,
    source_id uuid NOT NULL
);


ALTER TABLE public.authentik_stages_identification_identificationstage_sources OWNER TO authentik;

--
-- Name: authentik_stages_identification_identificationstage_sour_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_identification_identificationstage_sources ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_identification_identificationstage_sour_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_invitation_invitation; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_invitation_invitation (
    invite_uuid uuid NOT NULL,
    expires timestamp with time zone NOT NULL,
    fixed_data jsonb NOT NULL,
    created_by_id integer NOT NULL,
    single_use boolean NOT NULL,
    expiring boolean NOT NULL,
    name character varying(50) NOT NULL,
    flow_id uuid
);


ALTER TABLE public.authentik_stages_invitation_invitation OWNER TO authentik;

--
-- Name: authentik_stages_invitation_invitationstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_invitation_invitationstage (
    stage_ptr_id uuid NOT NULL,
    continue_flow_without_invitation boolean NOT NULL
);


ALTER TABLE public.authentik_stages_invitation_invitationstage OWNER TO authentik;

--
-- Name: authentik_stages_password_passwordstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_password_passwordstage (
    stage_ptr_id uuid NOT NULL,
    backends text[] NOT NULL,
    configure_flow_id uuid,
    failed_attempts_before_cancel integer NOT NULL
);


ALTER TABLE public.authentik_stages_password_passwordstage OWNER TO authentik;

--
-- Name: authentik_stages_prompt_prompt; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_prompt_prompt (
    prompt_uuid uuid NOT NULL,
    field_key text NOT NULL,
    label text NOT NULL,
    type character varying(100) NOT NULL,
    required boolean NOT NULL,
    placeholder text NOT NULL,
    "order" integer NOT NULL,
    sub_text text NOT NULL,
    placeholder_expression boolean NOT NULL,
    name text NOT NULL,
    initial_value text NOT NULL,
    initial_value_expression boolean NOT NULL
);


ALTER TABLE public.authentik_stages_prompt_prompt OWNER TO authentik;

--
-- Name: authentik_stages_prompt_promptstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_prompt_promptstage (
    stage_ptr_id uuid NOT NULL
);


ALTER TABLE public.authentik_stages_prompt_promptstage OWNER TO authentik;

--
-- Name: authentik_stages_prompt_promptstage_fields; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_prompt_promptstage_fields (
    id integer NOT NULL,
    promptstage_id uuid NOT NULL,
    prompt_id uuid NOT NULL
);


ALTER TABLE public.authentik_stages_prompt_promptstage_fields OWNER TO authentik;

--
-- Name: authentik_stages_prompt_promptstage_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_prompt_promptstage_fields ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_prompt_promptstage_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_prompt_promptstage_validation_policies; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_prompt_promptstage_validation_policies (
    id integer NOT NULL,
    promptstage_id uuid NOT NULL,
    policy_id uuid NOT NULL
);


ALTER TABLE public.authentik_stages_prompt_promptstage_validation_policies OWNER TO authentik;

--
-- Name: authentik_stages_prompt_promptstage_validation_policies_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.authentik_stages_prompt_promptstage_validation_policies ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.authentik_stages_prompt_promptstage_validation_policies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: authentik_stages_user_delete_userdeletestage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_user_delete_userdeletestage (
    stage_ptr_id uuid NOT NULL
);


ALTER TABLE public.authentik_stages_user_delete_userdeletestage OWNER TO authentik;

--
-- Name: authentik_stages_user_login_userloginstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_user_login_userloginstage (
    stage_ptr_id uuid NOT NULL,
    session_duration text NOT NULL,
    terminate_other_sessions boolean NOT NULL,
    remember_me_offset text NOT NULL
);


ALTER TABLE public.authentik_stages_user_login_userloginstage OWNER TO authentik;

--
-- Name: authentik_stages_user_logout_userlogoutstage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_user_logout_userlogoutstage (
    stage_ptr_id uuid NOT NULL
);


ALTER TABLE public.authentik_stages_user_logout_userlogoutstage OWNER TO authentik;

--
-- Name: authentik_stages_user_write_userwritestage; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_stages_user_write_userwritestage (
    stage_ptr_id uuid NOT NULL,
    create_users_as_inactive boolean NOT NULL,
    create_users_group_id uuid,
    user_path_template text NOT NULL,
    user_creation_mode text NOT NULL,
    user_type text NOT NULL
);


ALTER TABLE public.authentik_stages_user_write_userwritestage OWNER TO authentik;

--
-- Name: authentik_tenants_tenant; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.authentik_tenants_tenant (
    tenant_uuid uuid NOT NULL,
    domain text NOT NULL,
    "default" boolean NOT NULL,
    branding_title text NOT NULL,
    branding_logo text NOT NULL,
    flow_authentication_id uuid,
    flow_invalidation_id uuid,
    flow_recovery_id uuid,
    flow_unenrollment_id uuid,
    branding_favicon text NOT NULL,
    event_retention text NOT NULL,
    web_certificate_id uuid,
    flow_user_settings_id uuid,
    attributes jsonb NOT NULL,
    flow_device_code_id uuid
);


ALTER TABLE public.authentik_tenants_tenant OWNER TO authentik;

--
-- Name: django_content_type; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.django_content_type (
    id integer NOT NULL,
    app_label character varying(100) NOT NULL,
    model character varying(100) NOT NULL
);


ALTER TABLE public.django_content_type OWNER TO authentik;

--
-- Name: django_content_type_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.django_content_type ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_content_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_migrations; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.django_migrations (
    id integer NOT NULL,
    app character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    applied timestamp with time zone NOT NULL
);


ALTER TABLE public.django_migrations OWNER TO authentik;

--
-- Name: django_migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.django_migrations ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_session; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.django_session (
    session_key character varying(40) NOT NULL,
    session_data text NOT NULL,
    expire_date timestamp with time zone NOT NULL
);


ALTER TABLE public.django_session OWNER TO authentik;

--
-- Name: guardian_groupobjectpermission; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.guardian_groupobjectpermission (
    id integer NOT NULL,
    object_pk character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    group_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.guardian_groupobjectpermission OWNER TO authentik;

--
-- Name: guardian_groupobjectpermission_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.guardian_groupobjectpermission ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.guardian_groupobjectpermission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: guardian_userobjectpermission; Type: TABLE; Schema: public; Owner: authentik
--

CREATE TABLE public.guardian_userobjectpermission (
    id integer NOT NULL,
    object_pk character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    permission_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.guardian_userobjectpermission OWNER TO authentik;

--
-- Name: guardian_userobjectpermission_id_seq; Type: SEQUENCE; Schema: public; Owner: authentik
--

ALTER TABLE public.guardian_userobjectpermission ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.guardian_userobjectpermission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Data for Name: auth_group; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.auth_group (id, name) FROM stdin;
\.


--
-- Data for Name: auth_group_permissions; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.auth_group_permissions (id, group_id, permission_id) FROM stdin;
\.


--
-- Data for Name: auth_permission; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.auth_permission (id, name, content_type_id, codename) FROM stdin;
1	Can add permission	1	add_permission
2	Can change permission	1	change_permission
3	Can delete permission	1	delete_permission
4	Can view permission	1	view_permission
5	Can add group	2	add_group
6	Can change group	2	change_group
7	Can delete group	2	delete_group
8	Can view group	2	view_group
9	Can add content type	3	add_contenttype
10	Can change content type	3	change_contenttype
11	Can delete content type	3	delete_contenttype
12	Can view content type	3	view_contenttype
13	Can add session	4	add_session
14	Can change session	4	change_session
15	Can delete session	4	delete_session
16	Can view session	4	view_session
17	Can add Certificate-Key Pair	5	add_certificatekeypair
18	Can change Certificate-Key Pair	5	change_certificatekeypair
19	Can delete Certificate-Key Pair	5	delete_certificatekeypair
20	Can view Certificate-Key Pair	5	view_certificatekeypair
21	Can add Event	6	add_event
22	Can change Event	6	change_event
23	Can delete Event	6	delete_event
24	Can view Event	6	view_event
25	Can add Notification Transport	7	add_notificationtransport
26	Can change Notification Transport	7	change_notificationtransport
27	Can delete Notification Transport	7	delete_notificationtransport
28	Can view Notification Transport	7	view_notificationtransport
29	Can add Notification Rule	8	add_notificationrule
30	Can change Notification Rule	8	change_notificationrule
31	Can delete Notification Rule	8	delete_notificationrule
32	Can view Notification Rule	8	view_notificationrule
33	Can add Notification	9	add_notification
34	Can change Notification	9	change_notification
35	Can delete Notification	9	delete_notification
36	Can view Notification	9	view_notification
37	Can add Webhook Mapping	10	add_notificationwebhookmapping
38	Can change Webhook Mapping	10	change_notificationwebhookmapping
39	Can delete Webhook Mapping	10	delete_notificationwebhookmapping
40	Can view Webhook Mapping	10	view_notificationwebhookmapping
41	Can add Flow	11	add_flow
42	Can change Flow	11	change_flow
43	Can delete Flow	11	delete_flow
44	Can view Flow	11	view_flow
45	Can export a Flow	11	export_flow
46	View Flow's cache metrics	11	view_flow_cache
47	Clear Flow's cache metrics	11	clear_flow_cache
48	Can add stage	12	add_stage
49	Can change stage	12	change_stage
50	Can delete stage	12	delete_stage
51	Can view stage	12	view_stage
52	Can add Flow Stage Binding	13	add_flowstagebinding
53	Can change Flow Stage Binding	13	change_flowstagebinding
54	Can delete Flow Stage Binding	13	delete_flowstagebinding
55	Can view Flow Stage Binding	13	view_flowstagebinding
56	Can add Flow Token	14	add_flowtoken
57	Can change Flow Token	14	change_flowtoken
58	Can delete Flow Token	14	delete_flowtoken
59	Can view Flow Token	14	view_flowtoken
60	Can add outpost	15	add_outpost
61	Can change outpost	15	change_outpost
62	Can delete outpost	15	delete_outpost
63	Can view outpost	15	view_outpost
64	Can add Outpost Service-Connection	16	add_outpostserviceconnection
65	Can change Outpost Service-Connection	16	change_outpostserviceconnection
66	Can delete Outpost Service-Connection	16	delete_outpostserviceconnection
67	Can view Outpost Service-Connection	16	view_outpostserviceconnection
68	Can add Docker Service-Connection	17	add_dockerserviceconnection
69	Can change Docker Service-Connection	17	change_dockerserviceconnection
70	Can delete Docker Service-Connection	17	delete_dockerserviceconnection
71	Can view Docker Service-Connection	17	view_dockerserviceconnection
72	Can add Kubernetes Service-Connection	18	add_kubernetesserviceconnection
73	Can change Kubernetes Service-Connection	18	change_kubernetesserviceconnection
74	Can delete Kubernetes Service-Connection	18	delete_kubernetesserviceconnection
75	Can view Kubernetes Service-Connection	18	view_kubernetesserviceconnection
76	Can add Dummy Policy	19	add_dummypolicy
77	Can change Dummy Policy	19	change_dummypolicy
78	Can delete Dummy Policy	19	delete_dummypolicy
79	Can view Dummy Policy	19	view_dummypolicy
80	Can add Event Matcher Policy	20	add_eventmatcherpolicy
81	Can change Event Matcher Policy	20	change_eventmatcherpolicy
82	Can delete Event Matcher Policy	20	delete_eventmatcherpolicy
83	Can view Event Matcher Policy	20	view_eventmatcherpolicy
84	Can add Password Expiry Policy	21	add_passwordexpirypolicy
85	Can change Password Expiry Policy	21	change_passwordexpirypolicy
86	Can delete Password Expiry Policy	21	delete_passwordexpirypolicy
87	Can view Password Expiry Policy	21	view_passwordexpirypolicy
88	Can add Expression Policy	22	add_expressionpolicy
89	Can change Expression Policy	22	change_expressionpolicy
90	Can delete Expression Policy	22	delete_expressionpolicy
91	Can view Expression Policy	22	view_expressionpolicy
92	Can add Have I Been Pwned Policy	23	add_haveibeenpwendpolicy
93	Can change Have I Been Pwned Policy	23	change_haveibeenpwendpolicy
94	Can delete Have I Been Pwned Policy	23	delete_haveibeenpwendpolicy
95	Can view Have I Been Pwned Policy	23	view_haveibeenpwendpolicy
96	Can add Password Policy	24	add_passwordpolicy
97	Can change Password Policy	24	change_passwordpolicy
98	Can delete Password Policy	24	delete_passwordpolicy
99	Can view Password Policy	24	view_passwordpolicy
100	Can add Reputation Policy	25	add_reputationpolicy
101	Can change Reputation Policy	25	change_reputationpolicy
102	Can delete Reputation Policy	25	delete_reputationpolicy
103	Can view Reputation Policy	25	view_reputationpolicy
104	Can add reputation	26	add_reputation
105	Can change reputation	26	change_reputation
106	Can delete reputation	26	delete_reputation
107	Can view reputation	26	view_reputation
108	Can add Policy	27	add_policy
109	Can change Policy	27	change_policy
110	Can delete Policy	27	delete_policy
111	Can view Policy	27	view_policy
112	View Policy's cache metrics	27	view_policy_cache
113	Clear Policy's cache metrics	27	clear_policy_cache
114	Can add Policy Binding	28	add_policybinding
115	Can change Policy Binding	28	change_policybinding
116	Can delete Policy Binding	28	delete_policybinding
117	Can view Policy Binding	28	view_policybinding
118	Can add Policy Binding Model	29	add_policybindingmodel
119	Can change Policy Binding Model	29	change_policybindingmodel
120	Can delete Policy Binding Model	29	delete_policybindingmodel
121	Can view Policy Binding Model	29	view_policybindingmodel
122	Can add LDAP Provider	30	add_ldapprovider
123	Can change LDAP Provider	30	change_ldapprovider
124	Can delete LDAP Provider	30	delete_ldapprovider
125	Can view LDAP Provider	30	view_ldapprovider
126	Can add OAuth2/OpenID Provider	31	add_oauth2provider
127	Can change OAuth2/OpenID Provider	31	change_oauth2provider
128	Can delete OAuth2/OpenID Provider	31	delete_oauth2provider
129	Can view OAuth2/OpenID Provider	31	view_oauth2provider
130	Can add Scope Mapping	32	add_scopemapping
131	Can change Scope Mapping	32	change_scopemapping
132	Can delete Scope Mapping	32	delete_scopemapping
133	Can view Scope Mapping	32	view_scopemapping
134	Can add OAuth2 Token	33	add_refreshtoken
135	Can change OAuth2 Token	33	change_refreshtoken
136	Can delete OAuth2 Token	33	delete_refreshtoken
137	Can view OAuth2 Token	33	view_refreshtoken
138	Can add Authorization Code	34	add_authorizationcode
139	Can change Authorization Code	34	change_authorizationcode
140	Can delete Authorization Code	34	delete_authorizationcode
141	Can view Authorization Code	34	view_authorizationcode
142	Can add Device Token	35	add_devicetoken
143	Can change Device Token	35	change_devicetoken
144	Can delete Device Token	35	delete_devicetoken
145	Can view Device Token	35	view_devicetoken
146	Can add Proxy Provider	36	add_proxyprovider
147	Can change Proxy Provider	36	change_proxyprovider
148	Can delete Proxy Provider	36	delete_proxyprovider
149	Can view Proxy Provider	36	view_proxyprovider
150	Can add SAML Property Mapping	37	add_samlpropertymapping
151	Can change SAML Property Mapping	37	change_samlpropertymapping
152	Can delete SAML Property Mapping	37	delete_samlpropertymapping
153	Can view SAML Property Mapping	37	view_samlpropertymapping
154	Can add SAML Provider	38	add_samlprovider
155	Can change SAML Provider	38	change_samlprovider
156	Can delete SAML Provider	38	delete_samlprovider
157	Can view SAML Provider	38	view_samlprovider
158	Can add LDAP Property Mapping	39	add_ldappropertymapping
159	Can change LDAP Property Mapping	39	change_ldappropertymapping
160	Can delete LDAP Property Mapping	39	delete_ldappropertymapping
161	Can view LDAP Property Mapping	39	view_ldappropertymapping
162	Can add LDAP Source	40	add_ldapsource
163	Can change LDAP Source	40	change_ldapsource
164	Can delete LDAP Source	40	delete_ldapsource
165	Can view LDAP Source	40	view_ldapsource
166	Can add OAuth Source	41	add_oauthsource
167	Can change OAuth Source	41	change_oauthsource
168	Can delete OAuth Source	41	delete_oauthsource
169	Can view OAuth Source	41	view_oauthsource
170	Can add User OAuth Source Connection	42	add_useroauthsourceconnection
171	Can change User OAuth Source Connection	42	change_useroauthsourceconnection
172	Can delete User OAuth Source Connection	42	delete_useroauthsourceconnection
173	Can view User OAuth Source Connection	42	view_useroauthsourceconnection
174	Can add Plex Source	43	add_plexsource
175	Can change Plex Source	43	change_plexsource
176	Can delete Plex Source	43	delete_plexsource
177	Can view Plex Source	43	view_plexsource
178	Can add User Plex Source Connection	44	add_plexsourceconnection
179	Can change User Plex Source Connection	44	change_plexsourceconnection
180	Can delete User Plex Source Connection	44	delete_plexsourceconnection
181	Can view User Plex Source Connection	44	view_plexsourceconnection
182	Can add SAML Source	45	add_samlsource
183	Can change SAML Source	45	change_samlsource
184	Can delete SAML Source	45	delete_samlsource
185	Can view SAML Source	45	view_samlsource
186	Can add User SAML Source Connection	46	add_usersamlsourceconnection
187	Can change User SAML Source Connection	46	change_usersamlsourceconnection
188	Can delete User SAML Source Connection	46	delete_usersamlsourceconnection
189	Can view User SAML Source Connection	46	view_usersamlsourceconnection
190	Can add Duo Authenticator Setup Stage	47	add_authenticatorduostage
191	Can change Duo Authenticator Setup Stage	47	change_authenticatorduostage
192	Can delete Duo Authenticator Setup Stage	47	delete_authenticatorduostage
193	Can view Duo Authenticator Setup Stage	47	view_authenticatorduostage
194	Can add Duo Device	48	add_duodevice
195	Can change Duo Device	48	change_duodevice
196	Can delete Duo Device	48	delete_duodevice
197	Can view Duo Device	48	view_duodevice
198	Can add SMS Authenticator Setup Stage	49	add_authenticatorsmsstage
199	Can change SMS Authenticator Setup Stage	49	change_authenticatorsmsstage
200	Can delete SMS Authenticator Setup Stage	49	delete_authenticatorsmsstage
201	Can view SMS Authenticator Setup Stage	49	view_authenticatorsmsstage
202	Can add SMS Device	50	add_smsdevice
203	Can change SMS Device	50	change_smsdevice
204	Can delete SMS Device	50	delete_smsdevice
205	Can view SMS Device	50	view_smsdevice
206	Can add Static Authenticator Stage	51	add_authenticatorstaticstage
207	Can change Static Authenticator Stage	51	change_authenticatorstaticstage
208	Can delete Static Authenticator Stage	51	delete_authenticatorstaticstage
209	Can view Static Authenticator Stage	51	view_authenticatorstaticstage
210	Can add TOTP Authenticator Setup Stage	52	add_authenticatortotpstage
211	Can change TOTP Authenticator Setup Stage	52	change_authenticatortotpstage
212	Can delete TOTP Authenticator Setup Stage	52	delete_authenticatortotpstage
213	Can view TOTP Authenticator Setup Stage	52	view_authenticatortotpstage
214	Can add Authenticator Validation Stage	53	add_authenticatorvalidatestage
215	Can change Authenticator Validation Stage	53	change_authenticatorvalidatestage
216	Can delete Authenticator Validation Stage	53	delete_authenticatorvalidatestage
217	Can view Authenticator Validation Stage	53	view_authenticatorvalidatestage
218	Can add WebAuthn Device	54	add_webauthndevice
219	Can change WebAuthn Device	54	change_webauthndevice
220	Can delete WebAuthn Device	54	delete_webauthndevice
221	Can view WebAuthn Device	54	view_webauthndevice
222	Can add WebAuthn Authenticator Setup Stage	55	add_authenticatewebauthnstage
223	Can change WebAuthn Authenticator Setup Stage	55	change_authenticatewebauthnstage
224	Can delete WebAuthn Authenticator Setup Stage	55	delete_authenticatewebauthnstage
225	Can view WebAuthn Authenticator Setup Stage	55	view_authenticatewebauthnstage
226	Can add Captcha Stage	56	add_captchastage
227	Can change Captcha Stage	56	change_captchastage
228	Can delete Captcha Stage	56	delete_captchastage
229	Can view Captcha Stage	56	view_captchastage
230	Can add Consent Stage	57	add_consentstage
231	Can change Consent Stage	57	change_consentstage
232	Can delete Consent Stage	57	delete_consentstage
233	Can view Consent Stage	57	view_consentstage
234	Can add User Consent	58	add_userconsent
235	Can change User Consent	58	change_userconsent
236	Can delete User Consent	58	delete_userconsent
237	Can view User Consent	58	view_userconsent
238	Can add Deny Stage	59	add_denystage
239	Can change Deny Stage	59	change_denystage
240	Can delete Deny Stage	59	delete_denystage
241	Can view Deny Stage	59	view_denystage
242	Can add Dummy Stage	60	add_dummystage
243	Can change Dummy Stage	60	change_dummystage
244	Can delete Dummy Stage	60	delete_dummystage
245	Can view Dummy Stage	60	view_dummystage
246	Can add Email Stage	61	add_emailstage
247	Can change Email Stage	61	change_emailstage
248	Can delete Email Stage	61	delete_emailstage
249	Can view Email Stage	61	view_emailstage
250	Can add Identification Stage	62	add_identificationstage
251	Can change Identification Stage	62	change_identificationstage
252	Can delete Identification Stage	62	delete_identificationstage
253	Can view Identification Stage	62	view_identificationstage
254	Can add Invitation Stage	63	add_invitationstage
255	Can change Invitation Stage	63	change_invitationstage
256	Can delete Invitation Stage	63	delete_invitationstage
257	Can view Invitation Stage	63	view_invitationstage
258	Can add Invitation	64	add_invitation
259	Can change Invitation	64	change_invitation
260	Can delete Invitation	64	delete_invitation
261	Can view Invitation	64	view_invitation
262	Can add Password Stage	65	add_passwordstage
263	Can change Password Stage	65	change_passwordstage
264	Can delete Password Stage	65	delete_passwordstage
265	Can view Password Stage	65	view_passwordstage
266	Can add Prompt	66	add_prompt
267	Can change Prompt	66	change_prompt
268	Can delete Prompt	66	delete_prompt
269	Can view Prompt	66	view_prompt
270	Can add Prompt Stage	67	add_promptstage
271	Can change Prompt Stage	67	change_promptstage
272	Can delete Prompt Stage	67	delete_promptstage
273	Can view Prompt Stage	67	view_promptstage
274	Can add User Delete Stage	68	add_userdeletestage
275	Can change User Delete Stage	68	change_userdeletestage
276	Can delete User Delete Stage	68	delete_userdeletestage
277	Can view User Delete Stage	68	view_userdeletestage
278	Can add User Login Stage	69	add_userloginstage
279	Can change User Login Stage	69	change_userloginstage
280	Can delete User Login Stage	69	delete_userloginstage
281	Can view User Login Stage	69	view_userloginstage
282	Can add User Logout Stage	70	add_userlogoutstage
283	Can change User Logout Stage	70	change_userlogoutstage
284	Can delete User Logout Stage	70	delete_userlogoutstage
285	Can view User Logout Stage	70	view_userlogoutstage
286	Can add User Write Stage	71	add_userwritestage
287	Can change User Write Stage	71	change_userwritestage
288	Can delete User Write Stage	71	delete_userwritestage
289	Can view User Write Stage	71	view_userwritestage
290	Can add Tenant	72	add_tenant
291	Can change Tenant	72	change_tenant
292	Can delete Tenant	72	delete_tenant
293	Can view Tenant	72	view_tenant
294	Can add Blueprint Instance	73	add_blueprintinstance
295	Can change Blueprint Instance	73	change_blueprintinstance
296	Can delete Blueprint Instance	73	delete_blueprintinstance
297	Can view Blueprint Instance	73	view_blueprintinstance
298	Can add group object permission	74	add_groupobjectpermission
299	Can change group object permission	74	change_groupobjectpermission
300	Can delete group object permission	74	delete_groupobjectpermission
301	Can view group object permission	74	view_groupobjectpermission
302	Can add user object permission	75	add_userobjectpermission
303	Can change user object permission	75	change_userobjectpermission
304	Can delete user object permission	75	delete_userobjectpermission
305	Can view user object permission	75	view_userobjectpermission
306	Can add static device	76	add_staticdevice
307	Can change static device	76	change_staticdevice
308	Can delete static device	76	delete_staticdevice
309	Can view static device	76	view_staticdevice
310	Can add static token	77	add_statictoken
311	Can change static token	77	change_statictoken
312	Can delete static token	77	delete_statictoken
313	Can view static token	77	view_statictoken
314	Can add TOTP device	78	add_totpdevice
315	Can change TOTP device	78	change_totpdevice
316	Can delete TOTP device	78	delete_totpdevice
317	Can view TOTP device	78	view_totpdevice
318	Can add User	79	add_user
319	Can change User	79	change_user
320	Can delete User	79	delete_user
321	Can view User	79	view_user
322	Reset Password	79	reset_user_password
323	Can impersonate other users	79	impersonate
324	Can add Property Mapping	80	add_propertymapping
325	Can change Property Mapping	80	change_propertymapping
326	Can delete Property Mapping	80	delete_propertymapping
327	Can view Property Mapping	80	view_propertymapping
328	Can add source	81	add_source
329	Can change source	81	change_source
330	Can delete source	81	delete_source
331	Can view source	81	view_source
332	Can add user source connection	82	add_usersourceconnection
333	Can change user source connection	82	change_usersourceconnection
334	Can delete user source connection	82	delete_usersourceconnection
335	Can view user source connection	82	view_usersourceconnection
336	Can add Token	83	add_token
337	Can change Token	83	change_token
338	Can delete Token	83	delete_token
339	Can view Token	83	view_token
340	View token's key	83	view_token_key
341	Can add provider	84	add_provider
342	Can change provider	84	change_provider
343	Can delete provider	84	delete_provider
344	Can view provider	84	view_provider
345	Can add group	85	add_group
346	Can change group	85	change_group
347	Can delete group	85	delete_group
348	Can view group	85	view_group
349	Can add Application	86	add_application
350	Can change Application	86	change_application
351	Can delete Application	86	delete_application
352	Can view Application	86	view_application
353	Can add Authenticated Session	87	add_authenticatedsession
354	Can change Authenticated Session	87	change_authenticatedsession
355	Can delete Authenticated Session	87	delete_authenticatedsession
356	Can view Authenticated Session	87	view_authenticatedsession
357	Can add OAuth2 Access Token	88	add_accesstoken
358	Can change OAuth2 Access Token	88	change_accesstoken
359	Can delete OAuth2 Access Token	88	delete_accesstoken
360	Can view OAuth2 Access Token	88	view_accesstoken
361	Can add Radius Provider	89	add_radiusprovider
362	Can change Radius Provider	89	change_radiusprovider
363	Can delete Radius Provider	89	delete_radiusprovider
364	Can view Radius Provider	89	view_radiusprovider
365	Can add SCIM Mapping	90	add_scimmapping
366	Can change SCIM Mapping	90	change_scimmapping
367	Can delete SCIM Mapping	90	delete_scimmapping
368	Can view SCIM Mapping	90	view_scimmapping
369	Can add SCIM Provider	91	add_scimprovider
370	Can change SCIM Provider	91	change_scimprovider
371	Can delete SCIM Provider	91	delete_scimprovider
372	Can view SCIM Provider	91	view_scimprovider
373	Can add scim user	92	add_scimuser
374	Can change scim user	92	change_scimuser
375	Can delete scim user	92	delete_scimuser
376	Can view scim user	92	view_scimuser
377	Can add scim group	93	add_scimgroup
378	Can change scim group	93	change_scimgroup
379	Can delete scim group	93	delete_scimgroup
380	Can view scim group	93	view_scimgroup
381	Can add license	94	add_license
382	Can change license	94	change_license
383	Can delete license	94	delete_license
384	Can view license	94	view_license
385	Can add license usage	95	add_licenseusage
386	Can change license usage	95	change_licenseusage
387	Can delete license usage	95	delete_licenseusage
388	Can view license usage	95	view_licenseusage
389	Can inspect a Flow's execution	11	inspect_flow
390	Can add Role	96	add_role
391	Can change Role	96	change_role
392	Can delete Role	96	delete_role
393	Can view Role	96	view_role
394	Can assign permissions to users	96	assign_role_permissions
395	Can unassign permissions from users	96	unassign_role_permissions
396	Can view system info	97	view_system_info
397	Can view system tasks	97	view_system_tasks
398	Can run system tasks	97	run_system_tasks
399	Can access admin interface	97	access_admin_interface
400	Can add Static Device	98	add_staticdevice
401	Can change Static Device	98	change_staticdevice
402	Can delete Static Device	98	delete_staticdevice
403	Can view Static Device	98	view_staticdevice
404	Can add Static Token	99	add_statictoken
405	Can change Static Token	99	change_statictoken
406	Can delete Static Token	99	delete_statictoken
407	Can view Static Token	99	view_statictoken
408	Can add TOTP Device	100	add_totpdevice
409	Can change TOTP Device	100	change_totpdevice
410	Can delete TOTP Device	100	delete_totpdevice
411	Can view TOTP Device	100	view_totpdevice
412	Can assign permissions to users	79	assign_user_permissions
413	Can unassign permissions from users	79	unassign_user_permissions
\.


--
-- Data for Name: authentik_blueprints_blueprintinstance; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_blueprints_blueprintinstance (created, last_updated, managed, instance_uuid, name, metadata, path, context, last_applied, last_applied_hash, status, enabled, managed_models, content) FROM stdin;
2022-10-25 09:00:53.406863+00	2022-10-25 09:10:18.979063+00	\N	c447f75b-a332-422c-a7dd-74bae02281ef	System - SAML Provider - Mappings	{"name": "System - SAML Provider - Mappings", "labels": {"blueprints.goauthentik.io/system": "true"}}	system/providers-saml.yaml	{}	2022-10-25 09:10:18.979067+00	15301d80ffa95fa0c37bc14fe3b5aaa74224a5998f82cdbd1a701ab96f05290b05dcee25df7053282c516383a6ba9890cbaac11aeca0fe1f9717f24e3d819ae3	successful	t	{}	
2024-01-10 13:34:48.625092+00	2024-01-10 13:34:54.474912+00	\N	7adb4b0a-c9bf-4872-9220-bbe6245e3162	Default - Tenant	{"name": "Default - Tenant", "labels": {}}	default/default-tenant.yaml	{}	2024-01-10 13:34:54.474916+00	65a18916f00bcac6bb8a2fb5d05f891eb1473ef262d4d9c78afeba012efbaf1330c2141923f7ffade17472be0c19b9f0b53b40f46e66f07a35bb6d2c00922aee	successful	t	{}	
2024-01-10 13:34:48.638166+00	2024-01-10 13:34:52.69052+00	\N	55bfa7bc-b223-41f2-b105-1f95da2685e6	Default - Events Transport & Rules	{"name": "Default - Events Transport & Rules", "labels": {}}	default/events-default.yaml	{}	2024-01-10 13:34:52.690524+00	bbee0ba3e8e51ea5290dbb2081c7c0a18f633766ff8f43c8897d68d0ea51b648cdffb345239b55cbab72d041972e80aea793d8a7a379f25aca02882f9fbf94ff	successful	t	{}	
2024-01-10 13:34:48.645446+00	2024-01-10 13:34:53.155446+00	\N	e990d111-e8a0-4ad8-9d7e-6a5d2437a146	Default - Static MFA setup flow	{"name": "Default - Static MFA setup flow", "labels": {}}	default/flow-default-authenticator-static-setup.yaml	{}	2024-01-10 13:34:53.155449+00	552f08718b573593e1b643f47734a1c185d7bc9efbea9c8d3dc49e6fd5060cd979098637fa20d958f4c3c9ff375e0fde3b871c956b87ebfbb1fb9319ba073bcb	successful	t	{}	
2024-01-10 13:34:48.649232+00	2024-01-10 13:34:53.730219+00	\N	e23700e3-9a34-4c4e-875d-91cfb5c4f256	Default - TOTP MFA setup flow	{"name": "Default - TOTP MFA setup flow", "labels": {}}	default/flow-default-authenticator-totp-setup.yaml	{}	2024-01-10 13:34:53.730224+00	43d2dcce568cbbe0f5409f52e2250ce4aa28ca34049cfc6f284070a2c28f81e85bb11fcf797f171beb1cb7aa15d70f26175ba9010b615563cac6057fc2563104	successful	t	{}	
2024-01-10 13:34:48.653021+00	2024-01-10 13:34:54.090272+00	\N	d359504f-978c-45a0-b6aa-b966c6e03cd7	Default - WebAuthn MFA setup flow	{"name": "Default - WebAuthn MFA setup flow", "labels": {}}	default/flow-default-authenticator-webauthn-setup.yaml	{}	2024-01-10 13:34:54.090276+00	67ef724536f41c451b9a88edd01100bd9ba4460f41b88f86a1385f9df30617371d0ddb610526b0a93aa32b9918475a63db03dfcf57bf7d0b02e7b509f9d35870	successful	t	{}	
2024-01-10 13:34:48.686469+00	2024-01-10 13:34:54.232304+00	\N	8a3417bb-039c-4bfe-b6ff-5d5a8911f01f	Default - Password change flow	{"name": "Default - Password change flow", "labels": {}}	default/flow-password-change.yaml	{}	2024-01-10 13:34:54.232307+00	6d7f1794e5a024d80e373fa9c9c791fa4837c690ad70d707fdf16208dec7c4b7feb490ab83f1db3e7d37f3d3ea41dfc4b06d87a221ffb208c076ff6672c27cc1	successful	t	{}	
2024-01-10 13:34:48.641729+00	2024-01-10 13:34:54.29831+00	\N	f5735a05-808c-4889-bba5-988fcb3063b6	Default - Authentication flow	{"name": "Default - Authentication flow", "labels": {}}	default/flow-default-authentication-flow.yaml	{}	2024-01-10 13:34:54.298314+00	4a184d3cf46bcc05e3e6e2428b1100877d3b3a6ddf934a936d65f26ef81bc5cfb5481cf3128217ee3bbf4d1a83060f4b0c7b43a88546827b9e65fdaa361e8259	successful	t	{}	
2024-01-10 13:34:48.656613+00	2024-01-10 13:34:54.329178+00	\N	a1c83a68-6d68-47ae-af9a-62c9762cf788	Default - Invalidation flow	{"name": "Default - Invalidation flow", "labels": {}}	default/flow-default-invalidation-flow.yaml	{}	2024-01-10 13:34:54.329181+00	a143bf2b9a1d20e2078389f7c37d213e51c52ea6a8df8f8ae7a7e6a1bb129ec4b862803aa44b8b1dbfe727e98e45cedac7a1a03632065040c87f045dcabab86a	successful	t	{}	
2024-01-10 13:34:48.679748+00	2024-01-10 13:34:54.462557+00	\N	f4774725-5832-4732-a797-c06f0893fc63	Default - User settings flow	{"name": "Default - User settings flow", "labels": {}}	default/flow-default-user-settings-flow.yaml	{}	2024-01-10 13:34:54.462561+00	192e32332465563ca0ec85be2ef4057a6bb8aeb3a291503d184f66c45377caa313225dc367780ef5ea4f1c86fbddc0b7706dd4cf0a3b9f5528abc98c790a883b	successful	t	{}	
2022-10-25 09:00:53.413147+00	2024-01-10 13:36:28.987297+00	\N	6c91b3d1-2c5f-435e-b678-cb1b061cb9d8	System - LDAP Source - Mappings	{"name": "System - LDAP Source - Mappings", "labels": {"blueprints.goauthentik.io/system": "true"}}	system/sources-ldap.yaml	{}	2024-01-10 13:36:28.987301+00	cd457d2cef04cfc24d7bbadfac35d8ee1e91b04a0a1662a18a0428e97043bdbfbe7a23b21b065d2e201c291c99f22a38b32436d76edfa86dbae3a5dc4d0ae4fc	successful	t	{}	
2024-01-10 13:34:48.704062+00	2024-01-10 13:36:28.914859+00	\N	d2e1c529-0d50-466b-8e49-99be615d70ae	System - SCIM Provider - Mappings	{"name": "System - SCIM Provider - Mappings", "labels": {"blueprints.goauthentik.io/system": "true"}}	system/providers-scim.yaml	{}	2024-01-10 13:36:28.914863+00	02355b6b64a68ce55025b5ddfe82f1153e1cc96bb3d2dad1176eef58a2285090944db5d583dd3a196bb5b7366f023412e043e72738613dc00f943f836cfc5b77	successful	t	{}	
2024-01-10 13:34:48.659762+00	2024-01-10 13:36:28.345301+00	\N	24622aa4-74dc-46ba-8dba-f49da993c93e	Default - Provider authorization flow (explicit consent)	{"name": "Default - Provider authorization flow (explicit consent)", "labels": {}}	default/flow-default-provider-authorization-explicit-consent.yaml	{}	2024-01-10 13:36:28.345305+00	598eee861d8814c0dc200542f59e5d8085c140f7131e87a9fc6baf688a3e9e7b0a32e865c439084f76b11992ce056be574e5aba2664375cee287206d66d345c9	successful	t	{}	
2024-01-10 13:34:48.663845+00	2024-01-10 13:36:28.370938+00	\N	ec217fcf-60d9-4503-9e9c-345ff752a84d	Default - Provider authorization flow (implicit consent)	{"name": "Default - Provider authorization flow (implicit consent)", "labels": {}}	default/flow-default-provider-authorization-implicit-consent.yaml	{}	2024-01-10 13:36:28.370942+00	2321088d922a57fdb741f6857eb48d3090210b552a6ecadf9b08de4832f574c5231f37943da3dfda3a4fa07c900d236ace3d237710e2e986a207c758859c1ecb	successful	t	{}	
2024-01-10 13:34:48.672318+00	2024-01-10 13:36:28.547263+00	\N	2e2d0f4b-634d-4b56-a0ea-f06b33a789be	Default - Source enrollment flow	{"name": "Default - Source enrollment flow", "labels": {}}	default/flow-default-source-enrollment.yaml	{}	2024-01-10 13:36:28.547269+00	09d441466d7e215601551bcd7c147616bf3794909f706c99c8fe527120d6fc612c1e4885c09bca433b97273e6a3fb10840d957bd7c898b14495a7bb245060792	successful	t	{}	
2024-01-10 13:34:48.683193+00	2024-01-10 13:36:28.724385+00	\N	c0185639-17d7-4acb-bba0-f2044a8639a2	Default - Out-of-box-experience flow	{"name": "Default - Out-of-box-experience flow", "labels": {}}	default/flow-oobe.yaml	{}	2024-01-10 13:36:28.724389+00	92a35a46db8ccbcd707c6065bf07797ab7a45406e24660d921224fb534875a2e204acf9bc65bcfc3a7b6f876414f0ee6d43669fa51244022afdf1b51aac11940	successful	t	{}	
2022-10-25 09:00:53.400474+00	2024-01-10 13:36:28.879985+00	\N	de836c31-6248-4155-b6d2-94f8e81ba828	System - Proxy Provider - Scopes	{"name": "System - Proxy Provider - Scopes", "labels": {"blueprints.goauthentik.io/system": "true"}}	system/providers-proxy.yaml	{}	2024-01-10 13:36:28.879989+00	a17fede4a19025273be4e8556cdef4b62c6a4ebc8051f6dde98657cf571f16cf7ce45388539b68e891f96184b6cde3bb2273de43643e1b6d788548cfbf0393dc	successful	t	{}	
2022-10-25 09:00:53.397894+00	2024-01-10 13:36:28.896306+00	\N	213482b6-347a-4595-ad7d-0840332a7cce	System - OAuth2 Provider - Scopes	{"name": "System - OAuth2 Provider - Scopes", "labels": {"blueprints.goauthentik.io/system": "true"}}	system/providers-oauth2.yaml	{}	2024-01-10 13:36:28.89631+00	bef8877737dd0345a5e88ef83518cbcdd45b2345037f925dc51eb7097bdbd0c4e1565aacdf08ec3ce2c0b90f8bcba013fa8618ea12881062e4e59d87a2abf992	successful	t	{}	
2024-01-10 13:34:48.668685+00	2024-01-10 13:36:28.445116+00	\N	4ec2089d-f691-4167-bd7c-5e569f26e126	Default - Source authentication flow	{"name": "Default - Source authentication flow", "labels": {}}	default/flow-default-source-authentication.yaml	{}	2024-01-10 13:36:28.445119+00	d86613f21394af35d554692e9868e7e714bb7cbd99a362ef3b64476edc1ffcb832443610f193d3d116685a360a1734482a7152b6b6bc8913f45be9aac3934233	successful	t	{}	
2024-01-10 13:34:48.676012+00	2024-01-10 13:36:28.470437+00	\N	60726d29-8b4f-461a-af0e-9f53a47016fa	Default - Source pre-authentication flow	{"name": "Default - Source pre-authentication flow", "labels": {}}	default/flow-default-source-pre-authentication.yaml	{}	2024-01-10 13:36:28.470448+00	51b6b65fb60f2f925d80b38cf173e7aa1bc00a074990e8d0b0dfaae088007ceb9051d0722f41500da309af5d0c78417dfa08a40c706203c3d6ee1eb613ad564c	successful	t	{}	
2024-01-10 13:34:48.694474+00	2024-01-10 13:36:28.845959+00	\N	018eec69-91fa-45fd-9157-153b590aadf8	Migration - Remove old prompt fields	{"name": "Migration - Remove old prompt fields", "labels": {"blueprints.goauthentik.io/description": "Migrate to 2023.2, remove unused prompt fields"}}	migrations/migrate-prompt-name.yaml	{}	2024-01-10 13:36:28.845963+00	75617432af2bb8d9cbf74db0ba9d6ec1b123811fdb40975685386c85d8fa4046cc4749a8e6f1f3e0c1068e45bf2af73914c6ede5b3d31fa2ac3195a53b94cf43	successful	t	{}	
2024-01-10 13:34:48.697665+00	2024-01-10 13:36:28.845678+00	\N	104c603e-f3e5-4e67-b3ad-ec31a9b2a9de	authentik Bootstrap	{"name": "authentik Bootstrap", "labels": {"blueprints.goauthentik.io/system": "true", "blueprints.goauthentik.io/description": "This blueprint configures the default admin user and group, and configures them for the [Automated install](https://goauthentik.io/docs/installation/automated-install).\\n", "blueprints.goauthentik.io/system-bootstrap": "true"}}	system/bootstrap.yaml	{}	2024-01-10 13:36:28.845683+00	c572042434ffa2218c5a30a656cbf10c80c434f19c596cdd9bc6aa37897af3be3f0ab0a73e332ebafb72bdf8a1a15937fb62c9077b484602edf4a196b632aa45	successful	t	{}	
\.


--
-- Data for Name: authentik_core_application; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_application (policybindingmodel_ptr_id, name, slug, meta_launch_url, meta_description, meta_publisher, provider_id, meta_icon, "group", open_in_new_tab) FROM stdin;
77d294b5-8a50-4d6d-8edd-5b15e5871826	Grafana	grafana				1			t
506b1180-4069-4dda-9405-e185f355c34d	Grafana SAML	grafana-saml				2			t
d7dfa1d6-58cb-4bfc-94c5-38a2e507e290	Grafana OIDC	grafana-oidc				3			f
\.


--
-- Data for Name: authentik_core_authenticatedsession; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_authenticatedsession (expires, expiring, uuid, session_key, last_ip, last_user_agent, last_used, user_id) FROM stdin;
2024-01-25 22:11:15.829855+00	t	a1b000d1-d98e-4e84-8f3a-39476361245a	3w9uc4x8na04umrd1glnat6bpldocjkg	172.20.0.8	goauthentik.io/outpost/2023.10.6	2024-01-11 22:11:15.830189+00	6
\.


--
-- Data for Name: authentik_core_group; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_group (group_uuid, name, attributes, parent_id, is_superuser) FROM stdin;
15c25b04-748c-43dc-bf4b-0dad5c987f0c	authentik Admins	{}	\N	t
a9c6327c-cfca-4d5b-a0af-421645e43c31	ldapsearch	{}	\N	f
17bb354e-cea2-48db-b322-9f9c8b53b8bb	admin	{}	\N	f
7e216c1b-2a0f-4772-ac3d-7bdaf7511a2e	editor	{}	\N	f
10d9a55e-195b-41a0-9fe6-63382d5b8208	viewer	{}	\N	f
ca14281c-e025-4691-b5a2-3ee415920e80	extra-group	{}	\N	f
\.


--
-- Data for Name: authentik_core_group_roles; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_group_roles (id, group_id, role_id) FROM stdin;
\.


--
-- Data for Name: authentik_core_propertymapping; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_propertymapping (pm_uuid, name, expression, managed) FROM stdin;
765b25ee-0e8b-4394-a56c-e27abf68f5ce	authentik default SAML Mapping: UPN	return request.user.attributes.get('upn', request.user.email)	goauthentik.io/providers/saml/upn
ef027c1a-728f-44e5-9072-6942d3e8d15e	authentik default SAML Mapping: Name	return request.user.name	goauthentik.io/providers/saml/name
05712cf6-0557-4ae7-95e7-3a0538962b67	authentik default SAML Mapping: Email	return request.user.email	goauthentik.io/providers/saml/email
b3fa1ee7-9507-4869-a29a-3c17c2482839	authentik default SAML Mapping: Username	return request.user.username	goauthentik.io/providers/saml/username
38ac59c3-e754-44e7-9790-5108a2cd027c	authentik default SAML Mapping: User ID	return request.user.pk	goauthentik.io/providers/saml/uid
c5d93ce6-8cda-42fa-9c19-3837ba67788a	authentik default SAML Mapping: Groups	for group in request.user.ak_groups.all():\n    yield group.name	goauthentik.io/providers/saml/groups
29fab284-b6db-433a-9c3c-7575aba47b2b	authentik default SAML Mapping: WindowsAccountname (Username)	return request.user.username	goauthentik.io/providers/saml/ms-windowsaccountname
9c13a34a-6007-4846-8c28-11d6dbd235c7	authentik default OAuth Mapping: OpenID 'openid'	# This scope is required by the OpenID-spec, and must as such exist in authentik.\n# The scope by itself does not grant any information\nreturn {}	goauthentik.io/providers/oauth2/scope-openid
a4825145-a8d1-4fbf-b88c-70d8cc801a4a	authentik default OAuth Mapping: OpenID 'email'	return {\n    "email": request.user.email,\n    "email_verified": True\n}	goauthentik.io/providers/oauth2/scope-email
252edb40-34ee-4f55-8ca4-4bf0a7fb445f	authentik default SCIM Mapping: Group	return {\n    "displayName": group.name,\n}	goauthentik.io/providers/scim/group
353b9d65-66ce-4fea-814b-e12c6e45a277	authentik default LDAP Mapping: Name	return ldap.get('name')	goauthentik.io/sources/ldap/default-name
a58eb3a5-c68d-406d-a5ff-688a6a047575	authentik default LDAP Mapping: mail	return ldap.get('mail')	goauthentik.io/sources/ldap/default-mail
a75310af-c0cf-4709-a66c-963d8c27e662	authentik default Active Directory Mapping: sAMAccountName	return ldap.get('sAMAccountName')	goauthentik.io/sources/ldap/ms-samaccountname
b5ae1f98-a70a-4ea3-a8c5-15285a8755bc	authentik default Active Directory Mapping: userPrincipalName	return list_flatten(ldap.get('userPrincipalName'))	goauthentik.io/sources/ldap/ms-userprincipalname
e8244e12-ed86-4f61-a0df-cfac793c267e	authentik default Active Directory Mapping: givenName	return list_flatten(ldap.get('givenName'))	goauthentik.io/sources/ldap/ms-givenName
81c79ce4-042d-470d-9aa4-48baaa08591b	authentik default Active Directory Mapping: sn	return list_flatten(ldap.get('sn'))	goauthentik.io/sources/ldap/ms-sn
0094050f-e24a-4eff-8346-712851851af9	authentik default OpenLDAP Mapping: uid	return ldap.get('uid')	goauthentik.io/sources/ldap/openldap-uid
e8809202-4ff0-4086-b078-196e6152e826	authentik default OpenLDAP Mapping: cn	return ldap.get('cn')	goauthentik.io/sources/ldap/openldap-cn
7446364c-faec-4cab-9191-beb2889d47b7	authentik default OAuth Mapping: OpenID 'profile'	return {\n    # Because authentik only saves the user's full name, and has no concept of first and last names,\n    # the full name is used as given name.\n    # You can override this behaviour in custom mappings, i.e. `request.user.name.split(" ")`\n    "name": request.user.name,\n    "given_name": request.user.name,\n    "preferred_username": request.user.username,\n    "nickname": request.user.username,\n    # groups is not part of the official userinfo schema, but is a quasi-standard\n    "groups": [group.name for group in request.user.ak_groups.all()],\n}	goauthentik.io/providers/oauth2/scope-profile
200af9d0-7476-43e1-a0fb-b7a7a68dd277	authentik default LDAP Mapping: DN to User Path	dn = ldap.get("distinguishedName")\npath_elements = []\nfor pair in dn.split(","):\n    attr, _, value = pair.partition("=")\n    # Ignore elements from the Root DSE and the canonical name of the object\n    if attr.lower() in ["cn", "dc"]:\n        continue\n    path_elements.append(value)\npath_elements.reverse()\n\npath = source.get_user_path()\nif len(path_elements) > 0:\n    path = f"{path}/{'/'.join(path_elements)}"\nreturn path	goauthentik.io/sources/ldap/default-dn-path
d3406e7e-2c6d-4d72-acdd-dda5513b1396	authentik default OAuth Mapping: Proxy outpost	# This mapping is used by the authentik proxy. It passes extra user attributes,\n# which are used for example for the HTTP-Basic Authentication mapping.\nsession_id = None\nif "token" in request.context:\n    session_id = request.context.get("token").session_id\nreturn {\n    "sid": session_id,\n    "ak_proxy": {\n        "user_attributes": request.user.group_attributes(request),\n        "is_superuser": request.user.is_superuser,\n    }\n}	goauthentik.io/providers/proxy/scope-proxy
83a19cb8-acab-44e1-884f-a0a279ae4d2d	authentik default SCIM Mapping: User	# Some implementations require givenName and familyName to be set\ngivenName, familyName = request.user.name, " "\nformatted = request.user.name + " "\n# This default sets givenName to the name before the first space\n# and the remainder as family name\n# if the user's name has no space the givenName is the entire name\n# (this might cause issues with some SCIM implementations)\nif " " in request.user.name:\n    givenName, _, familyName = request.user.name.partition(" ")\n    formatted = request.user.name\n\n# photos supports URLs to images, however authentik might return data URIs\navatar = request.user.avatar\nphotos = None\nif "://" in avatar:\n    photos = [{"value": avatar, "type": "photo"}]\n\nlocale = request.user.locale()\nif locale == "":\n    locale = None\n\nemails = []\nif request.user.email != "":\n    emails = [{\n        "value": request.user.email,\n        "type": "other",\n        "primary": True,\n    }]\nreturn {\n    "userName": request.user.username,\n    "name": {\n        "formatted": formatted,\n        "givenName": givenName,\n        "familyName": familyName,\n    },\n    "displayName": request.user.name,\n    "photos": photos,\n    "locale": locale,\n    "active": request.user.is_active,\n    "emails": emails,\n}	goauthentik.io/providers/scim/user
\.


--
-- Data for Name: authentik_core_provider; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_provider (id, authorization_flow_id, name, authentication_flow_id, backchannel_application_id, is_backchannel) FROM stdin;
1	87ca9599-5323-451c-8603-2f5bee7a0c12	grafana-ldap	\N	\N	t
3	a7ef54bb-7959-4559-979d-9345c022e086	grafana-oidc	\N	\N	f
2	a7ef54bb-7959-4559-979d-9345c022e086	grafana-saml	\N	\N	f
\.


--
-- Data for Name: authentik_core_provider_property_mappings; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_provider_property_mappings (id, provider_id, propertymapping_id) FROM stdin;
1	2	05712cf6-0557-4ae7-95e7-3a0538962b67
2	2	38ac59c3-e754-44e7-9790-5108a2cd027c
3	2	ef027c1a-728f-44e5-9072-6942d3e8d15e
4	2	29fab284-b6db-433a-9c3c-7575aba47b2b
5	2	c5d93ce6-8cda-42fa-9c19-3837ba67788a
6	2	765b25ee-0e8b-4394-a56c-e27abf68f5ce
7	2	b3fa1ee7-9507-4869-a29a-3c17c2482839
8	3	a4825145-a8d1-4fbf-b88c-70d8cc801a4a
9	3	9c13a34a-6007-4846-8c28-11d6dbd235c7
10	3	7446364c-faec-4cab-9191-beb2889d47b7
\.


--
-- Data for Name: authentik_core_source; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_source (policybindingmodel_ptr_id, name, slug, enabled, authentication_flow_id, enrollment_flow_id, managed, user_matching_mode, user_path_template, icon) FROM stdin;
0e32dc99-655c-42f4-aca4-f3f271e010fd	authentik Built-in	authentik-built-in	t	\N	\N	goauthentik.io/sources/inbuilt	identifier	goauthentik.io/sources/%(slug)s	
\.


--
-- Data for Name: authentik_core_source_property_mappings; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_source_property_mappings (id, source_id, propertymapping_id) FROM stdin;
\.


--
-- Data for Name: authentik_core_token; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_token (token_uuid, expires, expiring, description, user_id, intent, identifier, key, managed) FROM stdin;
3ffc5fb1-afc3-42b0-9af2-4dd2ca75d3db	2022-10-25 09:40:35.745032+00	f	Autogenerated by authentik for Outpost authentik Embedded Outpost	3	api	ak-outpost-0c24aadc-f97e-4720-a70f-72a190b0cafc-api	3AvDluVrv0nwNQRZussHzBb1fprTUK3UxWG375JqkYfMx9TG9VaJthxWnaMQ	goauthentik.io/outpost/ak-outpost-0c24aadc-f97e-4720-a70f-72a190b0cafc-api
44299d02-c086-4d35-b54e-2e56bb3346f2	2022-10-25 09:43:37.88082+00	f	Autogenerated by authentik for Outpost ldap-outpost	4	api	ak-outpost-efe635b9-2ce7-4de4-977f-9f25b9f36d97-api	77vDKwFWqCAsD9ykbH6vsGuMHtloM6urfeglrR9KRhWFcABtwmGGiQWHQStw	goauthentik.io/outpost/ak-outpost-efe635b9-2ce7-4de4-977f-9f25b9f36d97-api
\.


--
-- Data for Name: authentik_core_user; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_user (id, password, last_login, username, first_name, last_name, email, is_active, date_joined, uuid, name, password_change_date, attributes, path, type) FROM stdin;
2	!n7aLj0jKk3WIaSvfbaqM1nyy6fWejHsM54lRFljX	\N	AnonymousUser				t	2022-10-25 09:01:03.467789+00	fe23113c-e658-40b0-872b-d522b6d84e95		2022-10-25 09:01:03.468042+00	{}	users	internal
3	!8j4wiqLzHmjS9fUEU0e0DsXx4z8Cj8W6lXnOCbo3	\N	ak-outpost-0c24aadcf97e4720a70f72a190b0cafc				t	2022-10-25 09:01:07.984838+00	b9835bf9-2711-41ef-86d2-b07124b9fef9	Outpost authentik Embedded Outpost Service-Account	2022-10-25 09:01:07.98507+00	{"goauthentik.io/user/override-ips": true, "goauthentik.io/user/service-account": true}	goauthentik.io/outposts	internal_service_account
4	!yrI1uXKCdF0svOmz83ldwXJnWMOUY8oY52dzYNT1	\N	ak-outpost-efe635b92ce74de4977f9f25b9f36d97				t	2022-10-25 09:13:37.843347+00	a7dc29a9-11b7-4d35-aec1-260ae1ea62f5	Outpost ldap-outpost Service-Account	2022-10-25 09:13:37.843557+00	{"goauthentik.io/user/override-ips": true, "goauthentik.io/user/service-account": true}	goauthentik.io/outposts	internal_service_account
1	pbkdf2_sha256$600000$Z9YK1xODbvcOk3u3p0KonJ$N/S+WQZ1f9iXB734Xcc30AmE5hmV7e8EtT9cihvtc0g=	2024-01-11 22:06:44.87578+00	akadmin			admin@localhost	t	2022-10-25 09:00:53.707692+00	d719cb26-008d-4bff-8f5c-13d1bf53de25	authentik Default Admin	2022-10-25 09:09:42.841946+00	{}	users	internal
7	pbkdf2_sha256$600000$KzvAt9vwjfcZZ2j2vUxBeo$z3TLTqCB6IGqNiuqMhOp89GqCOA8NztlPc2CuSBlz2E=	2024-01-11 22:10:28.187334+00	authentik-viewer			authentik-viewer@localhost	t	2022-10-25 09:56:58.979268+00	ee7aa163-4303-4c2d-99c7-293ffd9d08dd	authentik-viewer	2022-10-25 09:57:13.55852+00	{}	users	internal
8	pbkdf2_sha256$600000$mvb1xpRzqjDKlTV77sIulv$7dItv/PVoaamglojWjnh/AJrm9kzs/ZFPT6hPoSqk6Y=	2024-01-11 22:10:54.084985+00	authentik-editor			authentik-editor@localhost	t	2022-10-25 09:57:43.64112+00	3678963f-023e-48b3-97a1-0910b4fbbfea	authentik-editor	2022-10-25 09:57:54.40015+00	{}	users	internal
6	pbkdf2_sha256$600000$5yumaes8rmMgoYHBoZJccx$ZwJQzQihlRZFZU8XwPj1WbJW0ZZhdHNo4SnoSEx+xV4=	2024-01-11 22:11:15.849616+00	ldapservice			ldapservice@localhost	t	2022-10-25 09:49:18.218809+00	94fafa12-9abd-4567-9627-3c6998f38cca	ldapservice	2022-10-25 09:49:50.76013+00	{}	users	internal
5	pbkdf2_sha256$600000$SAxnow0EApm0aOYiQX5ZsB$iAxPX8OJVoKC+Cwf3mZyK9lOf1Q+i1BVJR+ECWd7jik=	2024-01-11 22:11:16.862134+00	authentik-admin			authentik-admin@localhost	t	2022-10-25 09:37:30.689793+00	a7d3e4ed-8b75-456f-b3aa-f53f45afd3a4	authentik-admin	2022-10-25 09:37:49.480346+00	{}	users	internal
\.


--
-- Data for Name: authentik_core_user_ak_groups; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_user_ak_groups (id, user_id, group_id) FROM stdin;
1	1	15c25b04-748c-43dc-bf4b-0dad5c987f0c
2	6	a9c6327c-cfca-4d5b-a0af-421645e43c31
3	5	17bb354e-cea2-48db-b322-9f9c8b53b8bb
4	8	7e216c1b-2a0f-4772-ac3d-7bdaf7511a2e
5	7	10d9a55e-195b-41a0-9fe6-63382d5b8208
6	8	ca14281c-e025-4691-b5a2-3ee415920e80
7	5	ca14281c-e025-4691-b5a2-3ee415920e80
\.


--
-- Data for Name: authentik_core_user_groups; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_user_groups (id, user_id, group_id) FROM stdin;
\.


--
-- Data for Name: authentik_core_user_user_permissions; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_user_user_permissions (id, user_id, permission_id) FROM stdin;
38	4	21
39	4	321
40	4	348
41	3	21
\.


--
-- Data for Name: authentik_core_usersourceconnection; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_core_usersourceconnection (id, created, last_updated, source_id, user_id) FROM stdin;
\.


--
-- Data for Name: authentik_crypto_certificatekeypair; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_crypto_certificatekeypair (created, last_updated, kp_uuid, name, certificate_data, key_data, managed) FROM stdin;
2022-10-25 09:01:06.131741+00	2024-01-10 13:34:38.497975+00	44404c15-dd39-48d7-8962-fcb807cd5e58	authentik Internal JWT Certificate	-----BEGIN CERTIFICATE-----\nMIIFHjCCAwagAwIBAgIQF5FQmU7oSciGLNkWVbLSpzANBgkqhkiG9w0BAQsFADAd\nMRswGQYDVQQDDBJhdXRoZW50aWsgMjAyMy44LjEwHhcNMjQwMTA5MTMzNDM4WhcN\nMjUwMTA0MTMzNDM4WjBXMSswKQYDVQQDDCJhdXRoZW50aWsgSW50ZXJuYWwgSldU\nIENlcnRpZmljYXRlMRIwEAYDVQQKDAlhdXRoZW50aWsxFDASBgNVBAsMC1NlbGYt\nc2lnbmVkMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAz7YMxtUcRT+A\ni8oOZpnBHF/5NFQ15dexytyfB/ni2B0w7SjN0aoOXAY0/AHd8ykloSz9XLgDrUx+\n8qHYMX4V941DVPrFLe26UYnXNUDaLW4N6uMhJjxFzQQQ3bjMTzizJ8sbT7qAJ5yh\n2cs+IM3vHnivc/pYuM7VgLlbnPfbjYtnvpLNf94xkOaMuOX8HdbQmtlt/ARMe9mS\nhZYDkPcAkFjnxOE+dZkkKE13sZyoeghcrjaB56GZqhQ8e6Jkih6cbJ5vto5UOP8+\n9Hwe2FD//wEvRYYl2d32GREDqqrJX5ChODyL2u99z/6Zfe2UGbIYn0vF7zTYICTq\nAZgUuPzk5X2caUAVwDG1DRzu6xaU9AmNarg+MgdhKdO20F9qjJ/DJ3srSgaSLHyd\ne1XW94Pagt1mCGfPuxpuX/b0HCUhR4hQGmm76FbthkZn8VlucZc+qXuLzWyNWbI1\nNFXIpewSn5vGOyMRifCEZAXkIU0mBLp/ah8OK63Q4YoH+LnM7y1haIScVlY77AGa\nZq0wDnr5bpq5Cruylu90RsgkXqokqHmVJtKW0IQIxT5ilMpGXNnPkuwZxsFkAz2U\nlwBfKPhyrmYIIHvvLQYHohZOu/JSESqQ+KzkiRlzmdXmWciuC/G58Khz+Zoq+xas\nrR/vATcNjfkldbH6hJoV6o6gD1fO9TcCAwEAAaMgMB4wHAYDVR0RAQH/BBIwEIIO\nZ29hdXRoZW50aWsuaW8wDQYJKoZIhvcNAQELBQADggIBAG+xj/e41S2wPMmkSXx6\no88x7FhS+pCMUQqhdlCSSjweIWuIK+iTW+MHOhk9xVqwBKkO6fu1ImiDcZHv88JA\ne/dEMyqv+hfqx8MpAr6pPYfVloEY8UsafTXwGoE5bgr5SIeO2yqZ5IBEys3pC1I4\necGLEgKFJ+nNyCeC2COE7NTDQOSfYnnQQLDhBSehJU7gHJ05FJJCGwjSNp25TKEl\nT/9r7tnfgPkygu38bUHg9wRrR69gLsfgG4gkVrkgg/ac9XfKFOMstsXH/njm2CpI\nk6Kl1XrKxeJX65fFMSzHZ05NyWVRNyFH6EvLuFNehwF9fYiYFBGrLGjOD+LtnIPo\nOD+8Mx415zRAWGQzePrgK2oWuVqGAz/Rdw18vAFKHJdt0zwd1D+RzUKXNJIha40n\nyDvHIUjAGIcE5iOozoYk0VqCDzYaQDib+aYiy8UXmK7ac+AfYhH/+HmpcibQGOXx\n1XpDjkbYXosKfi9E77yOFL7Iuavgu8u4/F1OMF/yG1UxDEo/WS1mriF6e3Ec8snq\nV2taRnKmjj0vI1cRCPeLf8uoD/MoLjjyuTwmDhnIjbt24b6+bul87ZKpQtk3Ecp6\nyB7SWjTuIph3pxpwmHjRopFP7Upz7YLzU0/TViIF++pN2X65yDxiZc0zSoqJ/53I\nNfx5/oC06EbgbJieCxnHeYuB\n-----END CERTIFICATE-----\n	-----BEGIN RSA PRIVATE KEY-----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\n-----END RSA PRIVATE KEY-----\n	goauthentik.io/crypto/jwt-managed
2024-01-11 22:07:32.546353+00	2024-01-11 22:07:32.546366+00	3fcd5d6c-3e40-43bc-b916-c7cd3675d0f1	authentik Self-signed Certificate	-----BEGIN CERTIFICATE-----\nMIIE/TCCAuWgAwIBAgIRAK1LRDkgWUYlrpBkN5TBxu8wDQYJKoZIhvcNAQELBQAw\nHjEcMBoGA1UEAwwTYXV0aGVudGlrIDIwMjMuMTAuNjAeFw0yNDAxMTAyMjA3MzJa\nFw0zNDAxMDgyMjA3MzJaMFYxKjAoBgNVBAMMIWF1dGhlbnRpayBTZWxmLXNpZ25l\nZCBDZXJ0aWZpY2F0ZTESMBAGA1UECgwJYXV0aGVudGlrMRQwEgYDVQQLDAtTZWxm\nLXNpZ25lZDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBALY9CVd1AZoE\nidS5z5x0UiXhOlvrxDeJ2gZOzpKdfQ/V6piMruOnz247vsqTWTziy3dTejuTiBA4\nvxOolWzuTu6jWs20zmbpynqfszEB9X83ag0ijpkzIgj2nvtgIkXn+ti2v4f4tdmC\n8OlY6G4tlD0NUc95VBo6qFdrsKJHmDfNsNqcsYzsxvi4QXoIXx+WILcvMFAP0wU5\ndKIg3mrTc2EO08KHqh2rXj2W6DzhBCbQUTDRnuJwH0I4wtr8QgUGbjY2l5qig2Fm\nonH0L229NUiQmo7ptp9xvj3L1Kzt8q/aEoUW3hSTRujP0Wx72U3Q86xaD3dnC1tK\nF5PXG/JBb72oRGF978kfgAhERUvkmuyAV4kvFCTWw2oZTsszOZMIbQ10lxJ5+yGg\n0AhYojNnqWiM+D03FCnXpYdMUfTmEHSxFTmYivi7RKE/uA7VjvKL/mXLqR6alQBC\nHg08bhXcZCBvJEn+LKsysAvFuwb+yauV6O8BOKL1f1PMxK0VEhzISQ9p7FB84v7d\nZLH7pCzBSb8Or3URgls0wuNVsg6WedOgdCW3KOr1JcFNEn9daEKF3uoGxJ+58k5L\ngFV1+JOO1rgAFpUlIy8+UXHEkKUIA2HnUStedNfta5Rduw0sVkrIOOxG5GF3/wlu\n7ZKoogrKWVsmBIaDHD1FRTdtkz5BbJrtAgMBAAEwDQYJKoZIhvcNAQELBQADggIB\nAAHdrZStP3QAgiQclZHmW9rgjMIFstWGj3+MbR+MxJPqTJLAjXWYiFsTWE1WrjLv\n3eoE2pszEKPV+ZLSTmSFC3N61F9u7coXXLmGq8Z01ubyzZIiyih/pJOWax+0xYkD\n+gNZ0syjgyBQ9JxaOHol0ydoQSKYEhI+BsD5GVrh1q9FBtmJhB+E3Z+qb4axd+n1\n9u9G77ZMcoAjknXZsULx9jkAQehC5+qO6+7zOdKZ5LfvQGY7K6lsKpsCuC9nC9nl\n33BeKdshrIvJwFQ60U9f8CrbAEMVKaEB6UCWlmHAVk/i3/vYW49L31UKl0d8nyxC\neg+xE9lK8xfZ18P2G5xPOXkj0qqk/byMrTYTeVCzYQstc4Vpkcr6H0ltuYF41Fcg\nHJSV4mtxv3EvkZdpPx2Iqw8td4theHjt+j7Xb3sufgBfjEcX/ZYgPOYlFCs2ScDR\nwBvpXytwd58s7pWfIYhi7mnn4LDqhLgYMOue5KpuqMTBbINGywyoiA+tr5paJOy1\n7+KFqUuymClfKtvsBWEci+a71Toy/5O0OvvqbfBkiwpjSNwvTWLiVjuTCQx9BcBP\n3ZXeKE4s3SQ9WHTi4PLpItYNpkjDDQgy7avEBGSofh9k6RNunLkOmQJDTWofPXbI\nfVB1RPV/Pi69jLSI4y4nNPSXIN6r7R6mAHv4nng+Q6Tj\n-----END CERTIFICATE-----\n	-----BEGIN RSA PRIVATE KEY-----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\n-----END RSA PRIVATE KEY-----\n	\N
\.


--
-- Data for Name: authentik_enterprise_license; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_enterprise_license (license_uuid, key, name, expiry, internal_users, external_users) FROM stdin;
\.


--
-- Data for Name: authentik_enterprise_licenseusage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_enterprise_licenseusage (expiring, expires, usage_uuid, user_count, external_user_count, within_limits, record_date) FROM stdin;
\.


--
-- Data for Name: authentik_events_event; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_events_event (event_uuid, action, app, context, client_ip, created, "user", expires, expiring, tenant) FROM stdin;
d0c607f5-b34e-4c87-bfe3-86b6af93bff8	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:32.449521+00	{}	2024-03-12 09:19:32.448974+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
efb6497b-cd83-4e42-a2da-9ea634020d29	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:18:52.857773+00	{}	2024-03-12 09:18:52.85257+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
f2345f3c-50f4-445f-b1f1-fd3cdfc1e548	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:18:55.67402+00	{}	2024-03-12 09:18:55.673476+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
1da692a0-5369-49b1-918d-397a8fb4f6c7	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:18:59.93416+00	{}	2024-03-12 09:18:59.933726+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
08827716-f997-48c3-8660-5429ee765f29	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:18:59.943075+00	{}	2024-03-12 09:18:59.942744+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
9df2624d-2696-4d62-be72-79943fa3c453	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:00.403041+00	{}	2024-03-12 09:19:00.402397+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
cc081dd6-04a1-41d3-86ce-94ab80260f39	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:02.271247+00	{}	2024-03-12 09:19:02.270741+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
2216842c-6a8d-405c-86c0-efdd56c02ed7	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:02.852389+00	{}	2024-03-12 09:19:02.851956+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
e446c461-318c-43dd-bb54-7332f31957f7	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:02.866594+00	{}	2024-03-12 09:19:02.866286+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
dacc361d-bc8e-4593-9c52-ba2a3203c8c4	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:09.271586+00	{}	2024-03-12 09:19:09.271126+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
cfd7c81e-6491-4300-9d79-7b08bfad23fc	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:10.067664+00	{}	2024-03-12 09:19:10.067136+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
bef8f80b-80d0-45a3-bb49-8e7c77512e3b	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:10.47359+00	{}	2024-03-12 09:19:10.473125+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
414d7650-07b8-45a3-8a60-b73eb18ffcf6	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:11.635958+00	{}	2024-03-12 09:19:11.635545+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
cde67ec8-645f-427b-98c9-4364cf4170b3	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:24.629477+00	{}	2024-03-12 09:19:24.628994+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
32dd6fc1-b943-41d3-87be-2824ea531c77	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:27.79875+00	{}	2024-03-12 09:19:27.797948+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
1892c61f-d5b3-438e-8c19-d9f423efff5f	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:29.355873+00	{}	2024-03-12 09:19:29.355389+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
1b4158d7-262b-406d-8160-5787d57ada28	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:31.836547+00	{}	2024-03-12 09:19:31.836116+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
56fced5b-c9ad-44b7-a809-6510b61bb563	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:34.246716+00	{}	2024-03-12 09:19:34.246051+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
7ef2a372-2a40-4864-a622-c692c7c4b43f	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "next=%2F"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:19:36.718109+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2024-03-12 09:19:36.717172+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
22db014b-be6d-4a3f-965a-0ace0464b794	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:36.72656+00	{}	2024-03-12 09:19:36.72612+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
c21cf203-828e-41d2-950d-53a9637461b3	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:37.136266+00	{}	2024-03-12 09:19:37.134873+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
b5d73ef4-1c7a-4900-8987-1087da3764c9	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:37.61176+00	{}	2024-03-12 09:19:37.611147+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
3489e920-1950-4568-bcbc-2589f668796f	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:40.033968+00	{}	2024-03-12 09:19:40.033581+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
273bb145-a3fa-4863-9b93-a89f5999f88f	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:41.303658+00	{}	2024-03-12 09:19:41.303232+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
7d46ee06-871a-4d5f-8889-467998876ba8	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:42.427351+00	{}	2024-03-12 09:19:42.426844+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
bbe5df98-293e-4f48-8c72-9dcf11358436	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:44.984313+00	{}	2024-03-12 09:19:44.983799+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
dd320df9-769b-4175-90d4-78a5b5b3092d	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:47.502574+00	{}	2024-03-12 09:19:47.502103+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
4d2d029b-ef81-4567-af17-a9244c4ca8d9	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:47.556538+00	{}	2024-03-12 09:19:47.55626+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
abae7a06-0d04-4296-b2d3-77050ce7cbb3	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:49.959876+00	{}	2024-03-12 09:19:49.959179+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
c15fb1d4-da26-45bf-872f-9475973f9729	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:50.207578+00	{}	2024-03-12 09:19:50.207071+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
d872d39a-e398-4511-b1bb-90bf346f7fd2	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:19:52.466447+00	{}	2024-03-12 09:19:52.465616+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
f5446f06-efbb-46d7-aee8-5da6e31907a8	update_available	authentik.admin.tasks	{"message": "Changelog: https://goauthentik.io/docs/releases/2023.2#fixed-in-202322", "new_version": "2023.2.2"}	\N	2023-03-13 09:20:15.203522+00	{}	2024-03-12 09:20:15.203012+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
90454ab3-aa5b-49f9-bd63-80a337530bfe	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:20:56.688877+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:20:56.684176+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
b9164e93-692b-498f-9c4f-2f32becceb1f	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:21:58.829126+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:21:58.824794+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
2c78aaec-ee09-4d27-926f-9c19f0c8496c	login_failed	authentik.events.signals	{"stage": {"pk": "f4abcb7d5f9248908760afb9effda665", "app": "authentik_stages_identification", "name": "ldap-identification-stage", "model_name": "identificationstage"}, "password": "********************", "username": "authentik-editor", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "POST"}}	172.21.0.1	2023-03-13 09:22:00.426329+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2024-03-12 09:22:00.421307+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
3af0dca3-49ff-4102-88cb-ed536fec2e8a	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:22:06.774895+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:22:06.770422+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
9b2984e5-842b-4f0c-9cb7-be158c42e7fe	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:22:07.842618+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 09:22:07.839264+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
32a8449f-472d-420d-a958-01a215aa9bb2	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:26:00.701171+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:26:00.696828+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
8dc5f642-fb3e-4047-9a44-4c1a1e1e1088	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:27:12.761049+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:27:12.757389+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
28231592-4af2-4e74-8634-52677957e9b0	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:33:04.054979+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:33:04.050877+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
21f073ff-bf93-41d5-894a-535b86dd19a8	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:36:00.691981+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:36:00.686928+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
705c750a-e2eb-4f51-b449-063145343de4	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 09:37:00.0425+00	{}	2024-03-12 09:37:00.042+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
d3f1298a-d0ce-48ed-b906-0f8a5ee76031	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:38:09.293105+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:38:09.289073+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
e67a1639-150c-4300-8d99-f74bb826f638	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 09:42:00.028249+00	{}	2024-03-12 09:42:00.027638+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
e1345c74-01d6-49df-8757-76a95ee2a5dc	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:46:00.690728+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:46:00.68571+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
9d9afdbb-3cb1-4977-ac34-60274bf02b4f	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 09:47:00.051941+00	{}	2024-03-12 09:47:00.051448+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
2aa9f466-6cad-43f9-b1ab-08eac21d7e99	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 09:52:00.033336+00	{}	2024-03-12 09:52:00.032795+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
684f702d-2611-41cd-b44e-a5ba30a33378	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:55:00.391649+00	{}	2024-03-12 09:55:00.391185+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
28f603a8-f023-4d47-ae35-bfae6786ac45	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:55:00.397507+00	{}	2024-03-12 09:55:00.397286+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
f60be89d-9fa0-436f-b0e0-f09fa4ef93b5	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:55:02.75746+00	{}	2024-03-12 09:55:02.756545+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
700c0df4-1498-4489-bfd5-00a3c06017bb	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:55:02.856166+00	{}	2024-03-12 09:55:02.855898+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
770927d2-df41-4617-a2e8-5be8e3bd5455	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:55:02.869143+00	{}	2024-03-12 09:55:02.868899+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
15489a5d-89f8-4678-89dc-3877381a3a07	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 09:55:05.083752+00	{}	2024-03-12 09:55:05.083113+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
c70a59e5-58b6-4a28-b1e8-ed6d4496c16c	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 09:56:00.710844+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 09:56:00.705685+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
9b22e42f-b3f2-43ba-9267-dd8d6ec8dbd9	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 09:57:00.04607+00	{}	2024-03-12 09:57:00.045313+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
0811b173-1a28-4ffc-8805-f25b7b32566e	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:02:00.03614+00	{}	2024-03-12 10:02:00.035596+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
2c333a98-104b-4069-99f8-3995f8e276fe	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:07:00.057378+00	{}	2024-03-12 10:07:00.056377+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
95d26a20-b12f-45c3-9ea6-937eefbf4c8a	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:12:00.043399+00	{}	2024-03-12 10:12:00.042488+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
c9a70db7-55e2-4bec-99c7-fad51b4cbefb	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"next": "/if/admin/#/crypto/certificates"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}, "auth_method_args": {}}	172.20.0.1	2024-01-11 22:06:44.865953+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-10 22:06:44.865331+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
509eaab6-93c5-402d-bcac-2236f3abed19	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:17:00.031189+00	{}	2024-03-12 10:17:00.030686+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
c00c8441-beb6-4486-94fb-1e908df60050	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:22:00.032774+00	{}	2024-03-12 10:22:00.032273+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
c3738939-74b3-46a0-9599-e5675a21fddf	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:27:00.033048+00	{}	2024-03-12 10:27:00.032527+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
3495130d-70b8-4500-9b7b-16f2622023a3	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:32:00.031199+00	{}	2024-03-12 10:32:00.030615+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
544be902-73aa-4eac-9ff1-44b6cfae46fd	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:37:00.038657+00	{}	2024-03-12 10:37:00.037794+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
6b326d49-2dab-457d-bed2-f616e3ef95df	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:42:00.03957+00	{}	2024-03-12 10:42:00.038846+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
00d0e1ea-d9bc-458c-8d5e-835b22c24bd9	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:47:00.031649+00	{}	2024-03-12 10:47:00.031068+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
3ae5d7f4-f8b6-4d2e-b5a2-1ce21fb49293	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:52:00.032997+00	{}	2024-03-12 10:52:00.032085+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
0ccd9976-642a-48fc-a197-4f2a334bb052	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 10:55:00.434556+00	{}	2024-03-12 10:55:00.433922+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
f581e71a-734f-4d1c-9632-e7de00452063	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 10:55:00.442387+00	{}	2024-03-12 10:55:00.442143+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
61dbfa49-f2ca-4abe-adce-cd71b628bf2c	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 10:55:02.899679+00	{}	2024-03-12 10:55:02.899191+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
9165db49-6dff-439e-934e-3b010311901f	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 10:55:02.915594+00	{}	2024-03-12 10:55:02.915338+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
b9f9a80a-54c0-4e99-b1b3-dbdb61a8a8e1	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 10:55:02.921301+00	{}	2024-03-12 10:55:02.920999+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
4306c39d-89fc-439d-afa7-92e599477417	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 10:55:10.307515+00	{}	2024-03-12 10:55:10.30681+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
843f8709-4e62-41b8-a98b-213645931ca1	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 10:57:00.032694+00	{}	2024-03-12 10:57:00.031958+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
cf434072-8f63-4112-acae-f8bb01a43709	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:15:42.997603+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 12:15:42.993087+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
62899e67-5886-49ee-88a7-8c664e2f746d	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:02:00.034669+00	{}	2024-03-12 11:02:00.034074+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
387c9985-3baf-4cd2-ad89-a64642510aaf	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:07:00.025306+00	{}	2024-03-12 11:07:00.024832+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
4f3a4faf-c73b-40ab-9d4c-27a91a60fd69	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:12:00.037904+00	{}	2024-03-12 11:12:00.037441+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
d1014f1d-f907-4ed8-bb64-50fece7cc94b	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBb9swDIX%2FiqC7I9lu40aoDWQNhgXotqDJdtiNkZhGgCx5Ir2t%2F36ImwEdMPiwoyS%2B94mPvCfow2DWI5%2FjE34fkVj86kMkc3lo5ZijSUCeTIQeybA1%2B%2FXHR1MttAEizOxTlG8kw7xmyImTTUGK7aaV3hUrfTy6m2bpdLVcVWWDDdjbu5uycqfG4hJq3cDtCWspvmImn2Irq4WWYks04jYSQ%2BRWVrqqC10XZX0oK1PeGV0uVk39TYoNEvsIPCnPzINRKiQL4ZyIzUprrWAYgrdTibq0oJ4znCBCMR2Ikjr66Hx8Vhmdz2hZSbH%2B0%2FxDijT2mPeYf3iLX54e%2F8GpL5zJDixJsbum8O7Vdz6yK5zMh8NhV%2Bw%2B7w%2Bym8ZmpgyyeJ9yDzxvcrnxrjhNpQYje36R3cw%2Fe2RwwHCv3qC667p8gh63m10K3r78B54zRPIYWYp1COnnQ0ZgbCXnEaXqXpF%2FL2X3OwAA%2F%2F8%3D&RelayState=YWRYcTJyV01iNlVkY2R2VWZnVFpHRkVJNlNlM0lIYzM3bmVqWjJwTVd6dWtab2QwYzd8Y2VlMzM1M2Mt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=lUlHgH7IwMv%2F04xulllUtloFIwLWu2r%2FuyoXy4FHZ68ofaEEWzof2L7vMBv8aI3QQ91jI6eeQUjIBLO0HqaSUpadpp8ap%2Bm4cOsilBImRjoOIqpLsukzdBm4S7u1tjO5OqmeQaJmdZuBfwAWemiBEKp0DW1VCHsEDV9th%2BK%2BrptQAhVb8gfVmqRsYY13NZav0ZQOEHu7thDoDfVwQ1l6e6htxcpUFMfQvIB%2BQfB1aA5AAocVylIW1f%2B%2BtMNArDGW4VFAUpBga6lafl6cdSNhxRjPvVEdwAkLK%2BlKvhirGCM44R7ayQBTTIlrdfDaFKl3BEY8XuAnV2eQT6xSERBDyVpunPrZObQqFIp93%2Bm8vovmq8A6xNBHzkmwG%2BWPR4SoVoxIygRogkLuSxi%2B3RtXvRna7vs89sLyZgcIzDLAe6xMt%2FYHphlCvpM3yv83VqmQtPVhFKqQmqaeeJEGtB7JE5P4HK0fPReRXY65zFUeDDYpPrRbUjerI6YJogJqasG9UdZC%2BJXTW%2BAx3eNIpteqehGRXJP9FAbXUVgACS2%2FEUUJy%2FmgxkVHpK%2FUotX0DL50oHCmt0XCFMpWCUZMCXwMFXHEuO%2F%2BpSUqPOkVhX%2Bz3iWKCnUpHgF73UAbjUtgfXpA%2FGo4N3MyoDX1sNbQqPLai5iCZTRwdObBgsgQn%2FXPegw%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:18:02.192895+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:18:02.192123+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
2bb35f8d-322c-4193-b09d-32aafac220b7	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:17:00.043594+00	{}	2024-03-12 11:17:00.043125+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
076a18d6-6d9b-4524-b619-cc4a0a6b5f94	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:22:00.029942+00	{}	2024-03-12 11:22:00.029491+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
05424407-2396-4a74-86e4-6b6833846bcf	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:16:00.769208+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 12:16:00.765898+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
51e69755-68bd-42de-817c-bd744ea221df	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:16:25.296145+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 12:16:25.291452+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
93da91ee-16b7-4bd8-b05f-ed07b6f9e8b6	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:27:00.027139+00	{}	2024-03-12 11:27:00.026677+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
ad4eb94d-1d1b-4e70-b8dc-9f60371a3076	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:32:00.028541+00	{}	2024-03-12 11:32:00.028065+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
eb523ba5-1b16-45bb-8ae8-7a40eb463c30	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:37:00.048995+00	{}	2024-03-12 11:37:00.048385+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
beb1857e-f773-4ff2-a735-fb8c132543f1	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:42:00.02757+00	{}	2024-03-12 11:42:00.02711+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
2b9c49c0-df89-4b3d-8dba-d2033380645a	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:47:00.039745+00	{}	2024-03-12 11:47:00.03924+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
7ed7e8ea-6f1d-4632-805c-2c1b5097cd02	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:52:00.046914+00	{}	2024-03-12 11:52:00.046434+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
61c7403e-b176-481b-acb6-135f961da9de	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 11:55:00.348459+00	{}	2024-03-12 11:55:00.34801+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
350f90b1-8566-4acd-843e-9ee8545a559b	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 11:55:00.354408+00	{}	2024-03-12 11:55:00.354201+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
edf78c8c-de1a-4b2e-ba1d-686569e9db82	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 11:55:02.661045+00	{}	2024-03-12 11:55:02.660437+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
006941ff-49c6-4ce4-9ce1-908b6791978a	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 11:55:02.732599+00	{}	2024-03-12 11:55:02.732334+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
2f4b2d77-54b7-4677-815e-ae50f34adf7e	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 11:55:02.747185+00	{}	2024-03-12 11:55:02.746942+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
4e1057af-3785-46e2-b21b-07f85c38a61f	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 11:55:07.531247+00	{}	2024-03-12 11:55:07.530805+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
cef79b5a-c90c-4d64-b140-c9a302f31a8e	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 11:57:00.036941+00	{}	2024-03-12 11:57:00.036489+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
13fb035f-9f88-4a18-b588-9d68361667a5	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:02:00.040959+00	{}	2024-03-12 12:02:00.040479+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
39052e69-2537-41c7-9709-8170094bb2f0	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJPj9MwEMW%2FiuV7asdR%2F1mbSGUrRKUFqm3hwG3WmWwtOXbwTID99ijZIi0S6oGj7Xnv53kzdwR9GOxu5Et8xO8jEotffYhkp4dajjnaBOTJRuiRLDt72n18sGahLRBhZp%2BifCMZbmuGnDi5FKQ47Gvp26JbbzfVGio0K72BrTGlgW6jn1bGadDLzpW47tp2JcVXzORTrKVZaCkORCMeIjFErqXRpip0VZTVuTS23NjSLJbb5Tcp9kjsI%2FCsvDAPVqmQHIRLIrZbrbWCYQjezSVqakE9Z%2BggQjEfiJJ68rH18VllbH1Gx0qK3Z%2Fm71Okscd8wvzDO%2Fzy%2BPAPTjVxZjtwJMXxmsK7V9%2FbkV3hZD%2Bcz8fi%2BPl0ls08NjtnkMX7lHvg2ybTzZT2XGoxsucX2dz4Z48MLTDcqTeo5roun6DHw%2F6Ygncv%2F4HnDJE8RpZiF0L6eZ8RGGvJeUSpmlfk30vZ%2FA4AAP%2F%2F&RelayState=NzhJeXNnVnNZZDZKRDd3Q3BLVmFJa3hSaXRtOTlFdjJ2ZE8xaDQ0VlE4OVhlMGVjVE98YThlZWJkMDgt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=puFkhzy3Z5ac%2F1r3XdkaI0iEal2x1%2F0VLcr70BnL2IzjKUZifOxWx5laZoeWQnLdh1kKv1Nwnn32R53gOQkY4ofvAN81RaOB6vuJLTupOqA8XVkv2B%2Fs%2BwpfZrYgpUbxMVVJCzasr15e5%2FLd8uvDbdL6EBKJuVqhKfEP1T%2FH%2Bgnjc8WnW6yPJpAzQa3VuciZCBxkyq7SWfZabfADGwrF7PYzUniCOzXco%2FCHPuqgoPi5DNg32g4UxkgZmgCum%2B16Hf0hcT3eHUFuCkn5CA4PnnmWeDJeWiy%2B8yiYthZcfZAsZ1d0ngr58nmn9%2B3pbq5ICAC6ebpQci5NuY1nH4h%2FabMCJQsS1RDlkVpQdfWImyY3KcrgXavDKmqlWZ66dPGOP94LiFrB6hvGCrgPujvxnMUF3q54I9m2DGI9n5NA9Tx6rvClljP35bjMHV16H%2BzKsmPdInvmXtSJCf1OQC4GHAnGXsHTKLOCXqEQGFcb%2BwXVMGCCpXcguc4pWxd4wgMhc18bTANKN5%2FzlXGFWQyHLFMwC5iIuJFll4DKGC0gZTlixuGPjyiBEkCWtIIq8CZkSvKp6Dcx1CdC8gsZhJUxWxVws8IgfrL2TpL9AHlWOjZEWPYA8GiZF%2B9Cuyt%2F%2BZZCxoHl2ISx1CMR46pXirmSKWU3sAB3qDXHuv%2FaXxIt5tc%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:18:12.851482+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:18:12.85073+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
0f288bb0-3131-4b6b-bd13-781b1fc8f7f1	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:07:00.029026+00	{}	2024-03-12 12:07:00.028562+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
cea6cb21-9afe-4f32-9daa-5f5e65bc6d8c	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:12:00.033447+00	{}	2024-03-12 12:12:00.032956+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
5c20ff33-9685-41f9-a1a2-db46d9e4f5d9	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBb9swDIX%2FiqC7K0V201ioDWQNhgXotqDJdtiNkZlGgCx5Ir2t%2F36wmwEdMOSwoyS%2B94mPvCfow2DXI5%2FjE34fkVj86kMkOz00cszRJiBPNkKPZNnZ%2FfrjozU32gIRZvYpyjeS4bpmyImTS0GK7aaRvitOZVXWxxpcZW67FTiHtTtWGmpcLQ3cGaPvXF2fllJ8xUw%2BxUaaGy3FlmjEbSSGyI002pSFLotFeVgYu1ja6vZmVa2%2BSbFBYh%2BBZ%2BWZebBKheQgnBOxrbXWCoYheDeXqKkF9ZzhBBGK%2BUCU1NHHzsdnlbHzGR0rKdZ%2Fmn9IkcYe8x7zD%2B%2Fwy9PjPzjlxJntwJEUu0sK7159r0d2gZP9cDjsit3n%2FUG289jsnEEW71Puga%2BbTDdT2nOpxcieX2R75Z89MnTAcK%2FeoNrLunyCHrebXQrevfwHnjNE8hhZinUI6edDRmBsJOcRpWpfkX8vZfs7AAD%2F%2Fw%3D%3D&RelayState=VElyVjNaN2pnbDRVd1RWM29FM2x5MVZuVlBkY2N0WXBoZ01ET2Z4d2RKU2dOUE10ZFF8YmFjMjQzNDIt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=b5zxgS%2FAfwENvPrKFQIwHF04kGrruQL8VG3I15mtw7IOTkKWg%2BBZ6MuhG7C%2Bc4XNQfqTNtYwHNCr8FFd3STN1%2BsLv7NaBdcHjA%2BPAOZWrZc%2BsqB%2FFBpH6rWmB667UNcC9sTtlX1XS9O5vAJ%2Fln3Hb3pgV5r%2FEXcyrC1KSTiLSz6Xt6fqqopH6P7b%2FBOcAiWqvpt4J10UxXsC3huufmdg0MSGJO4ROun5dyL2NjxgASre4q9B2ka4pN3QaFdv5LOV9ptCd6EU5WJkc8rGVkvpGm2OdlrdxJi0jJy951%2FomKNGzfuR%2Bv6gWONM7aUoYUJbTKBibdC65EFVoNX%2BFnZIli9%2FK2zr00IoLqsyWkVpqZi4ziSevs%2F7XK4Hx4bFQ39E94Cs79uc6Mv1xDYa3Vf4grFkK99UUGoPBPgVrHOCRDt7SGw66ugSMktBFr7XPzJiTz%2B9Ue%2Fv4spp9J%2BuyQc1bdVFcgXIfBXwfomYvr%2BtPvc8gsIZJq2DFABStFX7OuaJOe5nKqhQuvfGMUlpFEePSOlTv2FhkH2ANMX0W%2B30pZjiOA1B7wthS6FrGJ9S6DVxqzvmfCzHFtMYPzOkLnE2hTNTjVIv%2FF5%2Bcsh8a4KT9o7KRAhXHbnrbyKA%2F1CKKJS%2FJfml7dG8eUOnGLg5BlQfTr4OS8DxxyHtFLykHPvfSQI%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:16:46.200868+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2024-03-12 12:16:46.200309+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
bc3357f2-1df7-47bd-8fa2-e853e44df893	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBb9swDIX%2FiqC7I1v2mkaoDWQNhgXotqDJdtiNkZhGgCx5Ir2t%2F36ImwEdMPjQoyS%2B94mPvCPow2DWI5%2FjI%2F4YkVj87kMkc3lo5ZijSUCeTIQeybA1%2B%2FWnB6MXpQEizOxTlK8kw7xmyImTTUGK7aaV3hUNNEtcHt%2FBaalRQ31cVo11VVNXK32ra8TjyTl7C1J8w0w%2BxVbqRSnFlmjEbSSGyK3Upa6Lsi6q%2BlBpU92YZrW4KevvUmyQ2EfgSXlmHoxSIVkI50RsVmVZKhiG4O1Uoi4tqKcMJ4hQTAeipI4%2BOh%2BfVEbnM1pWUqz%2FNn%2BfIo095j3mn97i18eH%2F3DqC2eyA0tS7K4pvH%2FxnY%2FsCifz8XDYFbsv%2B4PsprGZKYMsPqTcA8%2BbXG68K05TqcHInp9lN%2FPPHhkcMNypV6juui6focftZpeCt89vwHOGSB4jS7EOIf26zwiMreQ8olTdC%2FLfpez%2BBAAA%2F%2F8%3D&RelayState=VDBZcDVuczVpbVhzTlFMaXg0Y2k5UUk1b1N0M05LQ1YwaHVhcXlrZVJHdDBITTluOUR8ZDMxZDgxNzIt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=wUqtpzGasm1xm0%2B21lZLUOer33uK6YPH6MphpRPlGp8veCavKzKyr%2Fk%2BC9%2Fy6YqUScqYLmFd8joiRTWq1l0rZ1o6olA8Hq1%2FTyTx6OzuzbVV9qPd6hCIqfNFgNhfSjFLXolj079hkVqzs43nILWLyUb%2FH7bfLDu6yGPqndwpuvnZiRR4R3gYtkkTKsDvA%2B2BqskaLiW%2B%2FbMVaunroA0feuPWYlS6sO9gEwN%2BmNd2y8Ny9YmTBh8D8kwUrjasqsj7VwUQvA%2FPBxHrVY1qE%2B%2Bc2a0X0JOm4eBOvrAbuUGC58vZykC%2Fo7ub%2B2iaEsuPZow9vvJdYKzXUZSrYbRIdDBNOmkBpmA4QllPjV1vEdgDCNrGWmUPU7fB4xtLyoc2X0%2Bx010L1t9Z2QuLm3lQm8pK11oBzsiMcfzXBEbdZg%2BkPTQFL2szutYG3f2V4QmSUjQhDuphAKs99%2FUunI57Qn5rrck5cBmM0J97xWzNPzceIO0uamESgaBiteqw2ywBYgxpD0vTfc7VonPXpymR6z%2BjA0UPgslrQgqZxjAdHdPACdYKdHLfFIsRLAtyzHY%2FFkh5z6lmEqT9%2BGENv%2FGph%2FRxshU3Fhj4VQaT%2FHbkz6BOug2HUAbt8WiCgp4bwd8qSYAQLKSxXButM%2BLMofSt7GHhgdW2xMGurtNGqUhjX2jDFUo%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:16:49.912109+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2024-03-12 12:16:49.911609+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
2fe33328-90f8-4505-917b-5a6ba069ef79	model_updated	authentik.events.middleware	{"model": {"pk": 1, "app": "authentik_core", "name": "authentik Default Admin", "model_name": "user"}, "http_request": {"args": {"next": "/if/admin/#/crypto/certificates"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:06:44.879979+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:06:44.879476+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
a6bcd075-2241-45f4-93c3-ba4b69af2918	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:17:00.03235+00	{}	2024-03-12 12:17:00.031758+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
85b9d791-85e5-4c24-8c4d-36583538b4fa	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:17:03.682721+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 12:17:03.67834+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
2597fa7f-1be7-4636-9165-04f0b2dd813b	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "next=%2Fapplication%2Fsaml%2Fgrafana-saml%2Fsso%2Fbinding%2Fredirect%2F%3FSAMLRequest%3DnJJBj9MwEIX%252FiuV7aidhCbE2kcpWiEoLVNvCgds0mWwtOePgmQD771GzRVok1MMebc97n%252BfN3DKMYXLrWU70gD9mZFG%252Fx0Dszg%252BNnhO5COzZEYzITjq3X3%252B6d8XKOmDGJD6SfiGZrmumFCV2MWi13TTa95mtclu%252BHfI%252BH4ayACxsVeRV%252FabEfKhtfQMW62N%252FBK2%252BYWIfqdHFymq1ZZ5xSyxA0ujCFmVmyywvD3nh8srZavWuvPmu1QZZPIEsypPI5IwJsYNwiiyuttYamKbgu6XEnFswjwkGIMiWA3M0R0%252B9p0eTsPcJOzFarf82fxeJ5xHTHtNP3%252BHXh%252Fv%252FcMozZ7GDjrXaXVJ4%252F%252Bx7PbILnN3Hw2GX7b7sD7pdxuaWDJL6ENMIct3kfOP7bFhKHZJ4edLtlX%252BOKNCDwK15gWov6%252FIZRtxudjH47ukVeElA7JFEq3UI8dddQhBstKQZtWmfkf8uZfsnAAD%252F%252Fw%253D%253D%26RelayState%3DM01VdDk4TzhnSWtVMjBDTnlWb2FZZ05GOWZjUmxSNU41Sk1UbXdVcUxHcmM1dmJac2t8YWI3YjFjYTYt%26SigAlg%3Dhttp%253A%252F%252Fwww.w3.org%252F2001%252F04%252Fxmldsig-more%2523rsa-sha256%26Signature%3DW1uiWN6vvpGfU5nA49tvVbhWp71UjMbe%252Bsao3uLOeCYRCdJAxe22GIdpdViY8iuKSWISmNRMIDp3oWlTmbg5leMgWtO1wJxdk4AxnH8dLcMBhpNhhr8VD3QvQsJZfEMPBeWDa4IeFhfn%252FCL7gBKFHi5%252BNfzZuFUESyGQ0ZhRezPyff9pSPaZacYe%252FlAB%252FFQcejoGxBBohsbeVd5OMwYy0UVPmcgIWvp72%252FYYdMY5NEpre5tbQ9KQY1TlzMHKZAbVqfdPODKxobEXYuZBtEjrRzTJJP9iEpj4XXNEezg8vYOsAeex8Iagke2pSOa%252Bg741XW6HmEWDYNF3lksMd7f7lOP8b6MbcVeVUgZcF7s5XcSPYLuTelEruz%252BJgBGbtquqmUMidbeWAfvF4oiYcPnjncwToTSRa0EE1c%252BLxJaVwBAfDOYTRkYXb7BAg19tHQ8eMpG6JaQqdWY0OSabb2%252FGObiY9SMCjqgHFVYesRm9hn5Sv5nofAjjSxnQf69WiPCNTENznRZ%252BCYezWfEkXeYvh2Qk830%252BA24FHHRUZ4mvjlWwd9fFGuxcIy88LVkFfo5MmR%252FzrXZuPOLY5hRsBo9bHTbxxmYIW9HV8Q3UxO%252BuWnvYzhF3luBdePoxi%252B%252FDy%252B%252BrVaG1VfVUx89qVwgNcksp8C8FtkXO88t%252F1sIp8Hu0I3w%253D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:17:27.490802+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:17:27.490352+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
5d5b9b18-8d7e-453e-806a-b27c049bdd70	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBj9MwEIX%2FiuV7aidhCbE2kcpWiEoLVNvCgds0mWwtOePgmQD771GzRVok1MMebc97n%2BfN3DKMYXLrWU70gD9mZFG%2Fx0Dszg%2BNnhO5COzZEYzITjq3X3%2B6d8XKOmDGJD6SfiGZrmumFCV2MWi13TTa95mtclu%2BHfI%2BH4ayACxsVeRV%2FabEfKhtfQMW62N%2FBK2%2BYWIfqdHFymq1ZZ5xSyxA0ujCFmVmyywvD3nh8srZavWuvPmu1QZZPIEsypPI5IwJsYNwiiyuttYamKbgu6XEnFswjwkGIMiWA3M0R0%2B9p0eTsPcJOzFarf82fxeJ5xHTHtNP3%2BHXh%2Fv%2FcMozZ7GDjrXaXVJ4%2F%2Bx7PbILnN3Hw2GX7b7sD7pdxuaWDJL6ENMIct3kfOP7bFhKHZJ4edLtlX%2BOKNCDwK15gWov6%2FIZRtxudjH47ukVeElA7JFEq3UI8dddQhBstKQZtWmfkf8uZfsnAAD%2F%2Fw%3D%3D&RelayState=M01VdDk4TzhnSWtVMjBDTnlWb2FZZ05GOWZjUmxSNU41Sk1UbXdVcUxHcmM1dmJac2t8YWI3YjFjYTYt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=W1uiWN6vvpGfU5nA49tvVbhWp71UjMbe%2Bsao3uLOeCYRCdJAxe22GIdpdViY8iuKSWISmNRMIDp3oWlTmbg5leMgWtO1wJxdk4AxnH8dLcMBhpNhhr8VD3QvQsJZfEMPBeWDa4IeFhfn%2FCL7gBKFHi5%2BNfzZuFUESyGQ0ZhRezPyff9pSPaZacYe%2FlAB%2FFQcejoGxBBohsbeVd5OMwYy0UVPmcgIWvp72%2FYYdMY5NEpre5tbQ9KQY1TlzMHKZAbVqfdPODKxobEXYuZBtEjrRzTJJP9iEpj4XXNEezg8vYOsAeex8Iagke2pSOa%2Bg741XW6HmEWDYNF3lksMd7f7lOP8b6MbcVeVUgZcF7s5XcSPYLuTelEruz%2BJgBGbtquqmUMidbeWAfvF4oiYcPnjncwToTSRa0EE1c%2BLxJaVwBAfDOYTRkYXb7BAg19tHQ8eMpG6JaQqdWY0OSabb2%2FGObiY9SMCjqgHFVYesRm9hn5Sv5nofAjjSxnQf69WiPCNTENznRZ%2BCYezWfEkXeYvh2Qk830%2BA24FHHRUZ4mvjlWwd9fFGuxcIy88LVkFfo5MmR%2FzrXZuPOLY5hRsBo9bHTbxxmYIW9HV8Q3UxO%2BuWnvYzhF3luBdePoxi%2B%2FDy%2B%2BrVaG1VfVUx89qVwgNcksp8C8FtkXO88t%2F1sIp8Hu0I3w%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:17:27.717304+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:17:27.716795+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
f94eaece-3bc4-4092-9074-b696a717870e	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBb9swDIX%2FiqC7I9lq6lSoDWQNhgXotqDJdtiNk5lGgCx5Ir2t%2F36ImwEZMPjQoyS%2B94mPvCfow2DXI5%2FiE%2F4YkVj87kMke35o5JijTUCebIQeybKz%2B%2FXHR1sttAUizOxTlFeSYV4z5MTJpSDFdtNI3xV16cp6Cd2xOppbU6O%2Bwaq%2B1WWly5Vxq6Wp77putVxK8RUz%2BRQbWS20FFuiEbeRGCI3stKVKbQpSnMoK1vW9sYs6lX9TYoNEvsIPClPzINVKiQH4ZSI7Z3WWsEwBO%2BmEnVuQT1nOEKEYjoQJfXdx87HZ5Wx8xkdKynWf5t%2FSJHGHvMe80%2Fv8MvT43845syZ7MCRFLtLCu9efecju8DJfjgcdsXu8%2F4g22lsdsogi%2Fcp98DzJucb3xXHqdRiZM8vsp35Z48MHTDcqytUe1mXT9DjdrNLwbuXN%2BA5QySPkaVYh5B%2BPWQExkZyHlGq9hX571K2fwIAAP%2F%2F&RelayState=anhtSmtjckhYdjh5azJEOUZFV0Z0bUI4c3gyNlNZOUx2aEpkazROR2l5OTlzSjVtZWp8YTE5ODAxMTUt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=tXXSI3zMlSglsX2tlYVsXyQhtUmaGA%2BVNaRFol6F4QBJr3fsReatf05KZDVnaX2gjIrJ3Fu5cnspHnvPlGsrO%2BXe3dRBNz9dqSRj7rg3PSdJY8rffIKLyIUYGu%2F3hGOBja5Ekib4iKxrOwZxWUi%2BcND2VxlO%2BLT0Gs1QOVvIGOSmtl0O7KBOZLUDdJR58ithXjh6Cr1J7i1Hq2u552yuPwr3WRgk0Ux8E4%2FYgGbAf9%2BKFVfJoC0Cm0PuSA4OgAMFLGZiUuZiME4mWwHVRB%2FjOpfFZ5RmWK1l1P0%2B%2FYsMa4Kb8l5YfUe1puZVXqE2WEimDTWiVAFgT0CC5NvS3bdD7l42Y5iibhsnQwAfDDO7rnPQoMw3BULWEvDgFw4h5iMLz2W%2Fmb9pDAjqYsRfojAxJNcI07mApoect1bM34oWXNw5ikoYguCUb8u7ljBb4hz8MqY%2FlhGuq7uMes%2Fplx8uuDRh03txWneQqVA31m743YcVlCgrg8OZrGCtLmhFC5H5CxiuyYIOAn3bRzkH8uaXkG7xACS00paDIOwvwOzLCTipPzE3WdbSgIMlHwTdM6W3Fon6KJTU3BiiOlR8rUxhlUFt6IyCaUQPFyn85cj%2BWJ%2FkbD5Vv0FHjhjVTbICFWEkXlE8xv2fSvstdSd6xFkcPzHnn9tWCs3p5iXlYlhAuJ4%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:17:44.000325+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:17:43.99979+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
b9d9d3dc-b751-4ec6-bc68-a2cba475670d	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJPbxMxEMW%2FiuX7xvb%2BKcHqrhQaISIViJrAgdvUO20see3FMwv026NsgxQktAeOtue9n%2BfN3BIMYbSbiU%2FxAb9PSCx%2BDSGSPT%2B0csrRJiBPNsKAZNnZw%2BbjvS1X2gIRZvYpyivJuKwZc%2BLkUpBit22l7wtooG%2BaG42ux7XWjTZG1%2FVNb9YlVKZxda3fPJYVSvEVM%2FkUW1mutBQ7ogl3kRgit7LUZVXoqjDV0ZTWrG1tVmtTf5Nii8Q%2BAs%2FKE%2FNolQrJQTglYvtWa61gHIN3c4k6t6CeMzxBhGI%2BECX16GPv47PK2PuMjpUUmz%2FN36VI04D5gPmHd%2Fjl4f4fnOrMme3AkRT7SwrvXn2XI7vAyX44HvfF%2FvPhKLt5bHbOIIv3KQ%2FAyybnG98XT3OpxcieX2S38M8BGXpguFVXqO6yLp9gwN12n4J3L%2F%2BB5wyRPEaWYhNC%2BnmXERhbyXlCqbpX5N9L2f0OAAD%2F%2Fw%3D%3D&RelayState=dHgycWF6d0lpVDFhN3BxVDBMcWJkMEZBcXpGcnN0dEhGMG9MQkFwN015djJBSDNpQm18ZTMxMGNmZGUt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=r4FqnQj2PbxoRfujmEXTvU4g2w7xEjFyG3HTjpFoRmoR9SWmRlhTfGfPtf8UCzN5%2FuMTvTPeK9gF8SUumZsc%2BdojIgFJnXLTI6LkhLNtsuG%2BeyeXMQt08EJpUDOL67u3bvq5YX%2FELWyMtE4FuWdCBuS5zIjEjqK6zenMDcqagYSrwMBvJrfXBznRlKGb1eSp6yhBMUr0lHvnYQ0nhKcxUoOM%2BmdZH4kymhBe6O%2B1ptPWle6ndpS1fSM17QjUw%2FrLY5ueZKTq0U9surIsfhtToZQN0DGDRKBJUfdxB0SJRv6yA6FG%2Fh6h5lcaJIsnvqW1ilPiS96CFkQif%2FCYImS9IDaW8p3VnW25NxBFLJWWf5b8eM7CuHvdJ%2BcVt5sg8pudFAWQ5LfswYyuw3d2mD9qtiVcHTziFpMdVAWEQXXvFpv5VyHEJwpwMH8bpK8nH8B%2Bh4C%2Fh6eBojNZ7b%2B7kqlI8%2BT9YgV6lYL6uGxVnXvadPp2ILeMXZjAK5uDuO8tAK%2BWhEWZ3SaxjkoE%2Fjh3WF2nECsJvP7mzb0CpgbS6POzqlA0W%2Fg9ULkRvPoWbSYgOHk3Fa6US5UUyUrINBUtXWuRFTLFRmdDOsK78Wz%2F7EqegMvw9fbTnRrJR15t%2BTj3vbhj6kulOt36IDEHhKiHFlxzRL6zdMaOj5LsdPBggnzUmwM%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:18:42.050422+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:18:42.049694+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
1cc20cb4-d461-42ad-b005-2899cfcd53fb	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBb9QwEIX%2FiuV71k5SVluribR0hVipwKobOHCbOJOuJccOngnQf4%2BSLlKRUA49ejzvfZ7nuSMY%2FGj2E1%2FCI%2F6YkFj8HnwgM19UckrBRCBHJsCAZNia8%2F7Tgyk22gARJnYxyFeScV0zpsjRRi%2FF8VBJ12U5IO622Nud3dqi1Npi2XfbXdl2bX4zF1vb5u%2B0FN8wkYuhksVGS3EkmvAYiCFwJQtdlJkus7xs8sLkt%2BZGb3bFdykOSOwC8CK8MI9GKR8t%2BEskNrdaawXj6J1dWtQ8gXpK0EOAbDkQRdW60LnwpBJ2LqFlJcX%2B7%2Bz3MdA0YDpj%2Buksfn18%2BA%2BnnDmLHViS4nQN4f2L73piVziZj01zyk5fzo2sl18zSwRJfIhpAF43mSuuy%2Fql1WBgx8%2ByXnnngAwdMNypV6j6ui2fYcDj4RS9s89vwHOCQA4DS7H3Pv66TwiMleQ0oVT1C%2FLfnaz%2FBAAA%2F%2F8%3D&RelayState=blBLakNpaTBqMzhHbDdlWTdPSlh2WUtYMldsTml3TjJMQUxsa2JGY1JyT2tTZlQ0N2N8ZTI0NjUzMDQt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=FcXmAO6kLtB2iuQAPdqk4h8cN4IHwDVkBx3kyAxt4asU%2FYy9%2B8DYg0hWVbT777qRsyVOUuTwT8pNwmB5obC2Jw0VfDLuUh4Gd2XACA3KACmHKYJ3gsG%2FSvqONb2xvhTUK%2BPOT7RIRszNa6x5%2Fjw9U845LjlWXAKmkoCLv%2Bhhqhauz0mKLF%2F42Tv8TI8K9KriXRCZIGl34XhnW%2F10dKR2VjXOkaKLuUQyZjoJvpf872VlgB7VDR80RKMSwoe6FhI1GiPAgA%2BpB1ZokA940hpcPKFDG7tgSID5qcUaF4geC5TBjJnWBSaEp%2BgRdtfbqDU83K6jCAXiGDuTujy%2F84eIzjhGgixXLKutkLdrK7o%2Fw4w2aoXGL1aIYzlhY2TPYkbfmvq7XBRPyMUxXXgFM4l5D6wIesPhGgZ8kVQWm8OXEpabXovqJOdKH6vnQ8ZHLyH2aQKVfjYB7n%2BbGH1I%2FHHvXTgZWlhd4G4wtACVp%2BA0b2Crecmq%2FKNObH%2BUKmQ3Hveb9RJRCKLA%2BiPX9iQfn%2FDWapaG%2FjTWQoePyx0t09sVcg%2BW4zUnJ2JdqJH2Nd%2FRofrTcxnMH3grYL3i53wy4xdY7InpaJBq%2FIqku%2FH9Fg9Wi4bxJSmxvY5vxEKKb3C0%2FrVKAitf6ZDwYFfbHaPcgKEtMUGli766PN6LVD2F8lnMOD8%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:19:41.135323+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:19:41.134814+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
ec35d60f-97e1-4eed-b11c-12e5388aabb9	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:22:00.053251+00	{}	2024-03-12 12:22:00.052697+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
40f61b2a-99d1-45ce-8275-fdf436a18020	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:22:20.18532+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 12:22:20.182695+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
8bd6e2af-da1f-4b84-a036-6e7b04cbd66c	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "next=%2Fapplication%2Fsaml%2Fgrafana-saml%2Fsso%2Fbinding%2Fredirect%2F%3FSAMLRequest%3DnJJBj9MwEIX%252FiuV76tTepoq1iVS2QlRaoNoWDtymzmRrybGDZwLsv0fNFmmRUA8cbc97n%252BfN3BMMYbSbic%252FxCb9PSCx%252BDSGSvTw0csrRJiBPNsKAZNnZw%252Bbjo9WL0gIRZvYpyjeS8bZmzImTS0GK3baRvitW7gRQmWq9rhz0rnYG6%252F7U3%252BllpddV3dWmvuu63kjxFTP5FBupF6UUO6IJd5EYIjdSl9oUpSmW5rjUVmurV4tVab5JsUViH4Fn5Zl5tEqF5CCcE7Gty7JUMI7Bu7lEXVpQzxl6iFDMB6KkTj52Pj6rjJ3P6FhJsfnT%252FEOKNA2YD5h%252FeIdfnh7%252FwTEXzmwHjqTYX1N49%252Bp7O7IrnOyH43Ff7D8fjrKdx2bnDLJ4n%252FIAfNvkcuO7op9LLUb2%252FCLbG%252F8ckKEDhnv1BtVe1%252BUTDLjb7lPw7uU%252F8JwhksfIUmxCSD8fMgJjIzlPKFX7ivx7KdvfAQAA%252F%252F8%253D%26RelayState%3DMjBmNjVsNWdZYzZwRU1zRGtCcFR3Q0w5ZUtGR25yOVVKWURhMDRlVHVsdDk3MU9melB8ZGQzZmMwZmQt%26SigAlg%3Dhttp%253A%252F%252Fwww.w3.org%252F2001%252F04%252Fxmldsig-more%2523rsa-sha256%26Signature%3DB3BcE%252BDfKNr68aH3uXR%252F3TvCQvoni9ZtcGouK%252Fo9vxSwu%252BIc9EiPmnZImLaojWcaWfkKGRqaf%252BFlVIPMsPMLwnIqm5DMhM8MoBWOOc9zl7fCq6K7ojpiOZCA4nTIq281TICDjPG0lkVk%252BvVUQOgBAt%252Fm9OHgaBi%252FuIEXAiUKuI9WqlzJ9jmsyGSO4OUScXt%252B0uWh598Lhffjhc51lbK06Ih3t3iN%252ByGnnSZBbh%252Fg0tmrH%252BuyMCZUsFzgTK5k7%252BYKz9tMtb6nh6vUyzXihayOD5sX8S%252Fyen6NdSCM2EztBqahCpTBGKTeNBvJbsaHW%252Bxtm87%252FDddi2dOH71eKGa%252BPr66Bv0t9E6UI0GilGqEGKfe0SCyAdAwjIIy%252FfV3uJlZCuOk3MZa%252F4qgyMcC3PJEAxAiUsdPo9uLTi0pWuTr01qjFxkf28%252B3ERSAh9mlfcrAy9R%252FAF9Eq9KqBXPdqypGtcDkhihivtGpY7uS7xW9lrMiZzv3ffZrFHXfP1cMizvtVXkQiRf3st1KMxcrOXyIyHtaKWB1BQxUiE%252BBsS%252FlG9ZoVSpVXkIKmiMKWozFAzQNNJicWF7E5TEKhKVnB%252BT9Rc0e6qoaU7cgMSPSYPrjN2WEZPrTVMLn2QZ1kV7B8D0FXwthHpJQvDI66nXFW8kf1I7vM5TnWLJZLBYyO6PSMozM%253D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:22:37.480856+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:22:37.480343+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
8f8501fb-9e27-42fd-88d8-329c594baa59	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBj9MwEIX%2FiuV76tTepoq1iVS2QlRaoNoWDtymzmRrybGDZwLsv0fNFmmRUA8cbc97n%2BfN3BMMYbSbic%2FxCb9PSCx%2BDSGSvTw0csrRJiBPNsKAZNnZw%2Bbjo9WL0gIRZvYpyjeS8bZmzImTS0GK3baRvitW7gRQmWq9rhz0rnYG6%2F7U3%2BllpddV3dWmvuu63kjxFTP5FBupF6UUO6IJd5EYIjdSl9oUpSmW5rjUVmurV4tVab5JsUViH4Fn5Zl5tEqF5CCcE7Gty7JUMI7Bu7lEXVpQzxl6iFDMB6KkTj52Pj6rjJ3P6FhJsfnT%2FEOKNA2YD5h%2FeIdfnh7%2FwTEXzmwHjqTYX1N49%2Bp7O7IrnOyH43Ff7D8fjrKdx2bnDLJ4n%2FIAfNvkcuO7op9LLUb2%2FCLbG%2F8ckKEDhnv1BtVe1%2BUTDLjb7lPw7uU%2F8JwhksfIUmxCSD8fMgJjIzlPKFX7ivx7KdvfAQAA%2F%2F8%3D&RelayState=MjBmNjVsNWdZYzZwRU1zRGtCcFR3Q0w5ZUtGR25yOVVKWURhMDRlVHVsdDk3MU9melB8ZGQzZmMwZmQt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=B3BcE%2BDfKNr68aH3uXR%2F3TvCQvoni9ZtcGouK%2Fo9vxSwu%2BIc9EiPmnZImLaojWcaWfkKGRqaf%2BFlVIPMsPMLwnIqm5DMhM8MoBWOOc9zl7fCq6K7ojpiOZCA4nTIq281TICDjPG0lkVk%2BvVUQOgBAt%2Fm9OHgaBi%2FuIEXAiUKuI9WqlzJ9jmsyGSO4OUScXt%2B0uWh598Lhffjhc51lbK06Ih3t3iN%2ByGnnSZBbh%2Fg0tmrH%2BuyMCZUsFzgTK5k7%2BYKz9tMtb6nh6vUyzXihayOD5sX8S%2Fyen6NdSCM2EztBqahCpTBGKTeNBvJbsaHW%2Bxtm87%2FDddi2dOH71eKGa%2BPr66Bv0t9E6UI0GilGqEGKfe0SCyAdAwjIIy%2FfV3uJlZCuOk3MZa%2F4qgyMcC3PJEAxAiUsdPo9uLTi0pWuTr01qjFxkf28%2B3ERSAh9mlfcrAy9R%2FAF9Eq9KqBXPdqypGtcDkhihivtGpY7uS7xW9lrMiZzv3ffZrFHXfP1cMizvtVXkQiRf3st1KMxcrOXyIyHtaKWB1BQxUiE%2BBsS%2FlG9ZoVSpVXkIKmiMKWozFAzQNNJicWF7E5TEKhKVnB%2BT9Rc0e6qoaU7cgMSPSYPrjN2WEZPrTVMLn2QZ1kV7B8D0FXwthHpJQvDI66nXFW8kf1I7vM5TnWLJZLBYyO6PSMozM%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:22:37.698123+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:22:37.697561+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
53020bf2-b2f1-4a00-8106-f068bfd43302	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBbxMxEIX%2FiuX7xo69AWp1VwqNEJEKRE3gwG3inTSWvPbimQX671G2QSoS2kOPtue9z%2FNmbgn6OLj1yOf0gD9GJBa%2F%2B5jIXR4aOZbkMlAgl6BHcuzdfv3p3pmFdkCEhUNO8oVkmNcMJXP2OUqx3TQydJXuTvZtZ9HbI5qVwdU7U4O2Gur6ja6N8X5p9MkfpfiGhUJOjTQLLcWWaMRtIobEjTTa2ErbamkPS%2BOMcfVysTI336XYIHFIwJPyzDw4pWL2EM%2BZ2N1orRUMQwx%2BKlGXFtRjgRMkqKYDUVbHkLqQHlXBLhT0rKRY%2F23%2BLicaeyx7LD%2BDx68P9%2F%2Fh2AtnsgNPUuyuKbx%2F9p2P7Aon9%2FFw2FW7L%2FuDbKexuSmDIj7k0gPPm1xuQledplKHiQM%2FyXbmnz0ydMBwq16g2uu6fIYet5tdjsE%2FvQLPBRIFTCzFOsb8664gMDaSy4hStc%2FIf5ey%2FRMAAP%2F%2F&RelayState=MUZpWUxjVUNYRUttcTdLaXRqVWhadTBkVzFmRUJhUWUwaWdkNHRRcmhsQWk2NXhzNnN8YjY3OGJlODMt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=iEae0yzkwmmEGk7goszwfJQvGB887jfnfszCokTmcnDBxT2FvWwYM%2FQ3chK3nvYHi%2BpmVVQmlFOFeq%2But0c8zbvSHz8oDkLy%2F1aIvQejRm%2B6HOJXxKfscKwYMOczyKD%2BBFTz6qEwiqBXeCmK8ab9jRwgt4NCz77aN%2Fx320cFZFOeK%2F8MQzUj%2FgAW1l1kzFe0eK4fQ2WQqRydvYtUcUMk%2FMfFQZZL%2BysvS8AnGVt15V13ZE6b%2BaM37F%2B726vOBqjyse99cLpZsY08P6PIKr7duElXND25x1jMyqC1hEEOBCzSj9Rd9be4elzUWMDRLPzEpPgLVD05cdvt64Dp%2FIP05HFW036Xt8A37azAfr5gulR%2B1ZDlsNXbnCHAHjVSfuAiS31%2B%2B%2BwPMwCk5hWInP5b8D7uCR989om153iD61cJgUrUHdBknhikTn6hhGahKNLVf6uDNcDiqdfcAEzgnaMB2Hy1MxTpz3Ge4nmXj6wK2%2F%2BgDhPTu6JayscchroBZPt7U4oN6ryuVcuSuOToqVJvhMilGUzMP4a9yeHqv6qk7T9egBBfwIrC%2FQ%2FsfNblceIDUTLomxw3gahf0Qb1JxmsuTqCYYHSJiddmBhMUzQ4iEMjz8tqEFWo6pJZFE1SrQATH7mXEB3Ki6%2FwkyBYPq6KHV36nDYhKJT34kWcrsaoRiA%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:22:41.756407+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:22:41.755874+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
33883ab6-55eb-40af-bd68-6f1b00a360c4	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBb9s%2BDMW%2FiqG7I1VK%2F4mF2kD%2BDYYF6LagyXbYjZXoRoAseSK9rd9%2BiJsBHTDksKMkvvcTH3lHMMTRbiY%2BpUf8NiFx9XOIiez5oRVTSTYDBbIJBiTLzh42Hx6sXigLRFg45CTeSMbrmrFkzi5HUe22rQi%2BXprGm1vjV6s1%2BnWz7lWv%2FNo40zw12rhbpVbw37JfiuoLFgo5tUIvlKh2RBPuEjEkboVW2tTK1DfmeKOt1na5Whijv4pqi8QhAc%2FKE%2FNopYzZQTxlYtsopSSMYwxuLpHnFuRzgR4S1POBKMunkHxIz7KgDwUdS1Ftfjd%2FnxNNA5YDlu%2FB4efHh79wzJkz24EjUe0vKfz%2F6ns9sguc7PvjcV%2FvPx2OopvHZucMSvUulwH4usn5Jvi6n0stJg78Iror%2FxyQwQPDnXyD6i7r8hEG3G33OQb38g94LpAoYGJRbWLMP%2B4LAmMruEwoZPeK%2FHMpu18BAAD%2F%2Fw%3D%3D&RelayState=anIybTVpRXpNb1M1cTY1STZkbTg5MnFEQ2Q5eUhyS3RmMnlhWDZrMWhtRVNCV3dieTJ8ZTU1N2E0YzIt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=Hg4HrLcQEHmjmUoBFkreDfipeHYL03BpwjjG0oErIkjegN5cvJeK6vOKgMuecGSt07zBYnOZ7w4%2BFbztzlUA9Ck1Z4939R8cWdIHwwXWq4EBCIANuRo83ae7igPfWK%2BAa%2FRRcVRsoHwpJC0Mj5Icz4obi6JYrQDy3YdY0jwRa7d5NDiYdmi3zmF2O4gBZqZmrIdJPeDGmF%2F6Ut3%2Bbpkw8Hkc%2FVSXohyNRsedQXLT30Uc7KsNSrdfIqlhJlYFhtDLh3ZKGWXxeI3qsKDwwj%2BCmbuzk8ElQfokH1ZBievQCrZ%2FpJZnxDYWZ2ipmAZAm%2BojsE0gJCVLZT6PMMF%2FJeP98Q8Z35rVZ8fNgJ0F14OPaU%2FRad12rMTJdlnoAVAbxvIhO%2BezuftLg81VAeJmxmhqU0wPpxZjFv3c5jsC2w04QufYW6rGQ9Eqk9Aul%2BBM398CWXo2fdWqSdTK3R9k9Hu4OPMD%2BOE%2FY4TxF4aDDfoDnO2AjWz0aW0SgU4R8%2B1Mq03kZhz5WGJ%2BVV4rbvIZC3rmTU2Uu9PXSUXrFEKe%2Fh3hifwHiCfLiQd7%2FttY1syGI%2ByOjBTCpfEYc8Idbk%2BVZDuWwLHFKk6sJPZ3S65DWFY83uGSmYmhmci8NG9tpaFu47ZrTJ0XIf8uVrp7NbLuJpJQ428XqyWeyskr1QchFoA5gK0%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:22:47.615052+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:22:47.614547+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
a3a94a54-ad14-44e1-b3fa-82daeded38cc	authorize_application	authentik.providers.saml.views.flows	{"flow": "a7ef54bb79594559979d9345c022e086", "http_request": {"args": {"query": "SAMLRequest=nJJBb9swDIX%2FiqC7I1lu6lqoDWQNhgXotqDJdtiNkZlGgCx5Ir2t%2F36ImwEdMOSwoyS%2B94mPvCcYwmhXE5%2FiE36fkFj8GkIke35o5ZSjTUCebIQBybKzu9XHR2sW2gIRZvYpyjeS8bpmzImTS0GKzbqVvi%2BwPkBVHg8llDfQGF0v4Q7uqmZZNb3Dm6o2eHtsbkGKr5jJp9hKs9BSbIgm3ERiiNxKo01V6Kooq31prDF2qRd1WX%2BTYo3EPgLPyhPzaJUKyUE4JWLbaK0VjGPwbi5R5xbUc4YjRCjmA1FSBx97H59Vxt5ndKykWP1p%2FiFFmgbMO8w%2FvMMvT4%2F%2F4FRnzmwHjqTYXlJ49%2Bp7PbILnOyH%2FX5bbD%2Fv9rKbx2bnDLJ4n%2FIAfN3kfOP74jiXWozs%2BUV2V%2F45IEMPDPfqDaq7rMsnGHCz3qbg3ct%2F4DlDJI%2BRpViFkH4%2BZATGVnKeUKruFfn3Una%2FAwAA%2F%2F8%3D&RelayState=M3pwWm9kRldFeml2eThQVHBQcGI1NGp6Y3VCdGE2QU4yY0Eyc05OVlZzS1hlZEpsVEx8ZmFkNjlmYzEt&SigAlg=http%3A%2F%2Fwww.w3.org%2F2001%2F04%2Fxmldsig-more%23rsa-sha256&Signature=AMKBlDIOTlPlZhLhBMQnT6S1%2FPH0luAJKcoJDqnljva%2Fc8y8ttw8hyj9%2FsZ66ghIVdelzLHGYf0zHhnQpjLTnOlss1XKigzxLfzcW4VpNzb87x%2Bo4XgtKVQg41XYUiidoaY7WhaMViAlXit93lAoSVxLSRf2bdVMKAUdze1W2PHZLzNFWb8le%2FkIc1RL9am%2FqKHPVkV7dgaZYzsGjID1buVA8nES5AbeFEa13ncP4BgqlUOhBeYnPO7uY7g6UDXOrGFpsVbg7NCy61ERbU1YZgUUcVB%2F%2Fzuyl%2Bx9oGwAnE%2FcGQ62NWS4MgcUSyC9fUhm%2Bdh1FvCPpLbmh3aAFHwJgfW1zrLZqosu2vgDWdPl%2FFy8GhrPQtxHpUsmminQqVWuB03J5RL5faXuV8KbMSyHEKBYrPL8TosM5AUC8Myc3ofAWmoSnBhHHPDjo%2FGuvjziRCyknuIgMwXASS0fOJonaYJyYGwHNOFYdRhMvP0h40y5sbZZEsDQOZI0x6PkGX41rHfsB2K6nUshcKwr7vxf8DpBblmCgby7ikD11ZQaM32MKv9Nuy91jQ2ukPBlXTOZy2fUKokK0EHs%2Fu7W1%2FB6ZlWSCyC2B0Vk7CsG2WILsRo6U%2Fhpzn9Stka1y0L59k4%2Bj6yErQsSWny06kEaCiaS%2B1Os6Epib00K8q8Mhkf8swk%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "506b118040694dda9405e185f355c34d", "app": "authentik_core", "name": "Grafana SAML", "model_name": "application"}}	172.21.0.1	2023-03-13 12:22:50.948601+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:22:50.94811+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
4bd7b207-ae32-4c25-9122-1aa0c86f429a	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"goauthentik.io/outpost/ldap": "true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET", "user_agent": "goauthentik.io/outpost/2023.10.6"}, "auth_method_args": {}}	172.20.0.8	2024-01-11 22:11:15.836471+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2025-01-10 22:11:15.832207+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
6e9edd91-9db5-4c23-9bcf-66a796709859	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:27:00.034068+00	{}	2024-03-12 12:27:00.033459+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
9cebce0e-a584-4b23-b496-b45994aa0097	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:32:00.030109+00	{}	2024-03-12 12:32:00.02958+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
6d9f7727-b1eb-4886-8bd1-8813397af8f2	model_created	authentik.events.middleware	{"model": {"pk": 3, "app": "authentik_providers_oauth2", "name": "grafana-oidc", "model_name": "oauth2provider"}, "http_request": {"args": {}, "path": "/api/v3/providers/oauth2/", "method": "POST"}}	172.21.0.1	2023-03-13 12:32:49.967325+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2024-03-12 12:32:49.966976+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
fa6cc07b-18e3-4f04-a1c7-8c235e696462	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 12:55:00.387054+00	{}	2024-03-12 12:55:00.386557+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
c319f061-18ad-4abe-a39d-8d952a64c49f	model_created	authentik.events.middleware	{"model": {"pk": "d7dfa1d658cb4bfc94c538a2e507e290", "app": "authentik_core", "name": "Grafana OIDC", "model_name": "application"}, "http_request": {"args": {}, "path": "/api/v3/core/applications/", "method": "POST"}}	172.21.0.1	2023-03-13 12:33:04.824311+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2024-03-12 12:33:04.823908+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
40fa3c92-e9ce-48ed-a80a-f49a5d93d347	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:35:42.688944+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 12:35:42.682304+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
34fe3cf8-47fe-4a75-bf99-74885f47b69e	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:36:00.789499+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 12:36:00.784286+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
637bc09b-af2c-4e11-9e01-e131d553a69b	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "next=%2Fapplication%2Fo%2Fauthorize%2F%3Fclient_id%3D43e8d2746fe2e508325a23cdf816d6ddd12e94f1%26redirect_uri%3Dhttp%253A%252F%252Flocalhost%253A3000%252Flogin%252Fgeneric_oauth%26response_type%3Dcode%26scope%3Dopenid%2Bemail%2Bprofile%26state%3DKhwpxm9LZ-bo7yjuyBvGuTCM2Gi4pSXwJk8hCRWup-s%253D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:36:31.733073+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:36:31.732702+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
530a91a4-929a-4d8e-b2ed-8f26d4e36b0e	authorize_application	authentik.providers.oauth2.views.authorize	{"flow": "a7ef54bb79594559979d9345c022e086", "scopes": "openid email profile", "http_request": {"args": {"query": "client_id=43e8d2746fe2e508325a23cdf816d6ddd12e94f1&redirect_uri=http%3A%2F%2Flocalhost%3A3000%2Flogin%2Fgeneric_oauth&response_type=code&scope=openid+email+profile&state=Khwpxm9LZ-bo7yjuyBvGuTCM2Gi4pSXwJk8hCRWup-s%3D"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET"}, "authorized_application": {"pk": "d7dfa1d658cb4bfc94c538a2e507e290", "app": "authentik_core", "name": "Grafana OIDC", "model_name": "application"}}	172.21.0.1	2023-03-13 12:36:31.983378+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2024-03-12 12:36:31.982723+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
cad2b7aa-cc81-4767-bba1-caa28a096461	model_updated	authentik.events.middleware	{"model": {"pk": 1, "app": "authentik_core", "name": "authentik Default Admin", "model_name": "user"}, "http_request": {"args": {"next": "/if/admin/#/administration/overview"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "POST", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	10.89.0.4	2024-01-10 13:37:34.033723+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-09 13:37:34.032188+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
993af708-fc75-4a06-864f-54fe56c6a753	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:37:00.030818+00	{}	2024-03-12 12:37:00.030297+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
61565f70-33eb-4563-a7a7-a31a963087ee	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"query": "goauthentik.io%2Foutpost%2Fldap=true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET"}, "auth_method_args": {}}	172.21.0.1	2023-03-13 12:40:53.885265+00	{"pk": 6, "email": "ldapservice@localhost", "username": "ldapservice"}	2024-03-12 12:40:53.878318+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
fd92f349-4b74-4387-8f10-56a833ef3c44	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:42:00.041363+00	{}	2024-03-12 12:42:00.040909+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
f5706fbf-6732-4b32-85cd-e196dcf5b955	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:47:00.053771+00	{}	2024-03-12 12:47:00.053281+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
5c7b37ea-42a9-4cb3-be09-9c8dbb6b3585	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:52:00.051624+00	{}	2024-03-12 12:52:00.051085+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
68d2eb3a-2a41-48fb-9d2a-06522ceb6377	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 12:55:00.393913+00	{}	2024-03-12 12:55:00.393671+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
9de89835-a209-433c-a1bf-760c6397182f	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 12:55:02.705404+00	{}	2024-03-12 12:55:02.704791+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
77ec5291-700d-4885-8a0a-72816c0bf28a	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 12:55:02.789671+00	{}	2024-03-12 12:55:02.789415+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
36af14d1-5184-4bd2-aff9-6316e57f4ad3	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 12:55:02.803163+00	{}	2024-03-12 12:55:02.802919+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
89f008f4-c58b-4279-9127-cadeef4b1450	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 12:55:10.131144+00	{}	2024-03-12 12:55:10.130677+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
5f428888-6bf6-4f76-b5b2-6c23ad3085d6	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 12:57:00.044786+00	{}	2024-03-12 12:57:00.044281+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
5d02a037-9888-47a5-986f-9577deca828d	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:02:00.046989+00	{}	2024-03-12 13:02:00.046464+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
15c00b9e-f9aa-41ec-b74b-0cb6baa59718	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:07:00.032693+00	{}	2024-03-12 13:07:00.031989+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
50822949-ba35-463b-ae97-79240c11349e	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:12:00.04835+00	{}	2024-03-12 13:12:00.047877+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
63ab0149-463e-461f-9322-f5c6e4856152	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:17:00.057481+00	{}	2024-03-12 13:17:00.056991+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
27cdf678-0982-4dd4-b90c-3e355523126a	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:22:00.025999+00	{}	2024-03-12 13:22:00.025478+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
aeb6dbe0-af34-4d19-8fe3-6cb9d955df73	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:27:00.031645+00	{}	2024-03-12 13:27:00.031085+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
4d456d22-d212-48d1-92fd-02c7b83d122e	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:32:00.032695+00	{}	2024-03-12 13:32:00.032177+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
faa22bf9-18f1-4699-980a-0b11d33d9ab3	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:37:00.029121+00	{}	2024-03-12 13:37:00.028611+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
67dcf33f-287c-40d2-ab5b-33aa01a35451	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:42:00.030479+00	{}	2024-03-12 13:42:00.029833+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
1c044336-a476-432a-994c-eb63432f857a	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:47:00.028801+00	{}	2024-03-12 13:47:00.028225+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
97abca4d-ce75-4802-8084-fefc98c81a93	system_task_exception	authentik.events.monitored_tasks	{"message": "Task clean_expired_models encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 451, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 207, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 57, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 202, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 734, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/core/tasks.py\\", line 38, in clean_expired_models\\n    for obj in objects:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 394, in __iter__\\n    self._fetch_all()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1867, in _fetch_all\\n    self._result_cache = list(self._iterable_class(self))\\n                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 87, in __iter__\\n    results = compiler.execute_sql(\\n              ^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1398, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 563, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 71, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\ndjango.db.utils.ProgrammingError: column authentik_providers_oauth2_authorizationcode.is_open_id does not exist\\nLINE 1: ...ntik_providers_oauth2_authorizationcode\\".\\"nonce\\", \\"authentik...\\n                                                             ^\\n"}	\N	2023-03-13 13:52:00.028658+00	{}	2024-03-12 13:52:00.028156+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
f05f35f9-fbe7-4838-9728-284298dd4776	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 13:55:00.420374+00	{}	2024-03-12 13:55:00.419803+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
8d7de2bb-2dfd-419a-b87f-dfa0dd383608	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 13:55:00.429683+00	{}	2024-03-12 13:55:00.429333+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
7e57ae9e-48bd-428c-91d6-9127b5dff427	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 13:55:02.788144+00	{}	2024-03-12 13:55:02.787458+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
04362a89-dae5-4023-a99a-541668da1e9e	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 13:55:02.882399+00	{}	2024-03-12 13:55:02.882148+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
a934eccb-bc35-45d4-8e2a-87eaca050a30	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 13:55:02.900363+00	{}	2024-03-12 13:55:02.900026+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
7dc1bd11-f563-45a3-aa35-71e7699619cc	system_exception	authentik.root.celery	{"message": "Traceback (most recent call last):\\ndjango.db.utils.InterfaceError: connection already closed"}	\N	2023-03-13 13:55:05.125416+00	{}	2024-03-12 13:55:05.124542+00	t	{"pk": "8ec6ecbff1624757a9c8360797195029", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
18adc05a-2cc7-45eb-9771-8fdbb2e3f329	system_task_exception	authentik.events.monitored_tasks	{"message": "Task blueprints_discovery encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 477, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 275, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 60, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 270, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 760, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/blueprints/v1/tasks.py\\", line 145, in blueprints_discovery\\n    check_blueprint_v1_file(blueprint)\\n  File \\"/authentik/blueprints/v1/tasks.py\\", line 173, in check_blueprint_v1_file\\n    instance.save()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/base.py\\", line 814, in save\\n    self.save_base(\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/base.py\\", line 877, in save_base\\n    updated = self._save_table(\\n              ^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/base.py\\", line 1020, in _save_table\\n    results = self._do_insert(\\n              ^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/base.py\\", line 1061, in _do_insert\\n    return manager._insert(\\n           ^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/manager.py\\", line 87, in manager_method\\n    return getattr(self.get_queryset(), name)(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1805, in _insert\\n    return query.get_compiler(using=using).execute_sql(returning_fields)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1822, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 616, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 69, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/psycopg/cursor.py\\", line 737, in execute\\n    raise ex.with_traceback(None)\\ndjango.db.utils.IntegrityError: duplicate key value violates unique constraint \\"authentik_blueprints_blueprintinstance_name_404be626_uniq\\"\\nDETAIL:  Key (name)=(Default - Tenant) already exists."}	\N	2024-01-10 13:34:47.947721+00	{}	2025-01-09 13:34:47.947069+00	t	{"pk": "9a0465281f674272822bef895fae1b75", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
359e7883-75a9-4840-a51a-37e75a921b8b	system_task_exception	authentik.events.monitored_tasks	{"message": "Task blueprints_discovery encountered an error: Traceback (most recent call last):\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 477, in trace_task\\n    R = retval = fun(*args, **kwargs)\\n                 ^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 275, in _inner\\n    reraise(*exc_info)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/_compat.py\\", line 60, in reraise\\n    raise value\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/celery.py\\", line 270, in _inner\\n    return f(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/celery/app/trace.py\\", line 760, in __protected_call__\\n    return self.run(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/authentik/blueprints/v1/tasks.py\\", line 145, in blueprints_discovery\\n    check_blueprint_v1_file(blueprint)\\n  File \\"/authentik/blueprints/v1/tasks.py\\", line 173, in check_blueprint_v1_file\\n    instance.save()\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/base.py\\", line 814, in save\\n    self.save_base(\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/base.py\\", line 877, in save_base\\n    updated = self._save_table(\\n              ^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/base.py\\", line 1020, in _save_table\\n    results = self._do_insert(\\n              ^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/base.py\\", line 1061, in _do_insert\\n    return manager._insert(\\n           ^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/manager.py\\", line 87, in manager_method\\n    return getattr(self.get_queryset(), name)(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/query.py\\", line 1805, in _insert\\n    return query.get_compiler(using=using).execute_sql(returning_fields)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/models/sql/compiler.py\\", line 1822, in execute_sql\\n    cursor.execute(sql, params)\\n  File \\"/usr/local/lib/python3.11/site-packages/sentry_sdk/integrations/django/__init__.py\\", line 616, in execute\\n    return real_execute(self, sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 67, in execute\\n    return self._execute_with_wrappers(\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 80, in _execute_with_wrappers\\n    return executor(sql, params, many, context)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 84, in _execute\\n    with self.db.wrap_database_errors:\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/utils.py\\", line 91, in __exit__\\n    raise dj_exc_value.with_traceback(traceback) from exc_value\\n  File \\"/usr/local/lib/python3.11/site-packages/django/db/backends/utils.py\\", line 89, in _execute\\n    return self.cursor.execute(sql, params)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/django_prometheus/db/common.py\\", line 69, in execute\\n    return super().execute(*args, **kwargs)\\n           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\n  File \\"/usr/local/lib/python3.11/site-packages/psycopg/cursor.py\\", line 737, in execute\\n    raise ex.with_traceback(None)\\ndjango.db.utils.IntegrityError: duplicate key value violates unique constraint \\"authentik_blueprints_blueprintinstance_name_path_982f03b6_uniq\\"\\nDETAIL:  Key (name, path)=(Default - Source pre-authentication flow, default/flow-default-source-pre-authentication.yaml) already exists."}	\N	2024-01-10 13:34:48.686741+00	{}	2025-01-09 13:34:48.686124+00	t	{"pk": "9a0465281f674272822bef895fae1b75", "app": "authentik_tenants", "name": "Tenant fallback", "model_name": "tenant"}
d1f42ba6-00e0-446b-b170-9b822c4df6d8	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"next": "/if/admin/#/administration/overview"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}, "auth_method_args": {}}	10.89.0.4	2024-01-10 13:37:34.122453+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-09 13:37:34.121905+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
f3afa096-3cea-422d-8bc7-0b2117edde32	model_updated	authentik.events.middleware	{"model": {"pk": 1, "app": "authentik_core", "name": "authentik Default Admin", "model_name": "user"}, "http_request": {"args": {"next": "/if/admin/#/administration/overview"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	10.89.0.4	2024-01-10 13:37:34.136251+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-09 13:37:34.135644+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
b5999b08-6c2a-4c7b-9356-263fd74f7b5c	model_deleted	authentik.events.middleware	{"model": {"pk": "f0a78f88adc247e682c1d49e9e159329", "app": "authentik_crypto", "name": "authentik Self-signed Certificate_2", "model_name": "certificatekeypair"}, "http_request": {"args": {}, "path": "/api/v3/crypto/certificatekeypairs/f0a78f88-adc2-47e6-82c1-d49e9e159329/", "method": "DELETE", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:06:53.231803+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-10 22:06:53.231151+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
8d921b9a-8cfe-4402-8949-7e73d53a931c	model_updated	authentik.events.middleware	{"model": {"pk": 6, "app": "authentik_core", "name": "ldapservice", "model_name": "user"}, "http_request": {"args": {"goauthentik.io/outpost/ldap": "true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET", "user_agent": "goauthentik.io/outpost/2023.10.6"}}	172.20.0.8	2024-01-11 22:11:15.858579+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:11:15.85419+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
e6b62e94-cac4-4ab7-8cb1-d010fb1a1fd5	model_deleted	authentik.events.middleware	{"model": {"pk": "fd8c40c1e49148d1a26502ef85ea9a12", "app": "authentik_crypto", "name": "authentik Self-signed Certificate_3", "model_name": "certificatekeypair"}, "http_request": {"args": {}, "path": "/api/v3/crypto/certificatekeypairs/fd8c40c1-e491-48d1-a265-02ef85ea9a12/", "method": "DELETE", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:06:59.939328+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-10 22:06:59.936003+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
a1d710c2-239e-400e-bad7-c53d6b3eb7aa	model_deleted	authentik.events.middleware	{"model": {"pk": "6304c99590034fc49ba23d32016fb04e", "app": "authentik_crypto", "name": "authentik Self-signed Certificate-old", "model_name": "certificatekeypair"}, "http_request": {"args": {}, "path": "/api/v3/crypto/certificatekeypairs/6304c995-9003-4fc4-9ba2-3d32016fb04e/", "method": "DELETE", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:10:04.13061+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-10 22:10:04.130083+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
5504bc47-2819-442f-b589-fbcba17e325c	model_updated	authentik.events.middleware	{"model": {"pk": 8, "app": "authentik_core", "name": "authentik-editor", "model_name": "user"}, "http_request": {"args": {"next": "/application/o/authorize/?client_id=43e8d2746fe2e508325a23cdf816d6ddd12e94f1&redirect_uri=http%3A%2F%2Flocalhost%3A3000%2Flogin%2Fgeneric_oauth&response_type=code&scope=openid+email+profile&state=BT8hDLepiB6WQKgDYSIbOMG4bN3mam2JhqoQCA08LxU%3D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "POST", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:10:53.973197+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:10:53.971822+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
4305fdab-10dd-4d90-8f00-6ef86b4b2e2a	model_updated	authentik.events.middleware	{"model": {"pk": 5, "app": "authentik_core", "name": "authentik-admin", "model_name": "user"}, "http_request": {"args": {"goauthentik.io/outpost/ldap": "true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "POST", "user_agent": "goauthentik.io/outpost/2023.10.6"}}	172.20.0.8	2024-01-11 22:11:16.787611+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:11:16.78303+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
47643d1d-1747-47c8-b588-8afb16426f56	model_updated	authentik.events.middleware	{"model": {"pk": "6304c99590034fc49ba23d32016fb04e", "app": "authentik_crypto", "name": "authentik Self-signed Certificate-old", "model_name": "certificatekeypair"}, "http_request": {"args": {}, "path": "/api/v3/crypto/certificatekeypairs/6304c995-9003-4fc4-9ba2-3d32016fb04e/", "method": "PATCH", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:07:21.528806+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-10 22:07:21.528218+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
114e2a99-98b7-45fd-9625-96d8805161f4	model_updated	authentik.events.middleware	{"model": {"pk": 7, "app": "authentik_core", "name": "authentik-viewer", "model_name": "user"}, "http_request": {"args": {"next": "/application/o/authorize/?client_id=43e8d2746fe2e508325a23cdf816d6ddd12e94f1&redirect_uri=http%3A%2F%2Flocalhost%3A3000%2Flogin%2Fgeneric_oauth&response_type=code&scope=openid+email+profile&state=CgTPaX9JYavq4yJ5EWmgXQ9UEPhAp6TCumANg1b1jmw%3D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "POST", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:10:27.787705+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:10:27.7848+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
edd940c9-a07b-402b-9a70-87e5c4c31f74	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"next": "/application/o/authorize/?client_id=43e8d2746fe2e508325a23cdf816d6ddd12e94f1&redirect_uri=http%3A%2F%2Flocalhost%3A3000%2Flogin%2Fgeneric_oauth&response_type=code&scope=openid+email+profile&state=BT8hDLepiB6WQKgDYSIbOMG4bN3mam2JhqoQCA08LxU%3D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}, "auth_method_args": {}}	172.20.0.1	2024-01-11 22:10:54.076153+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2025-01-10 22:10:54.075325+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
95d31a52-acd7-48d6-afb9-ff48c48aef43	model_updated	authentik.events.middleware	{"model": {"pk": 8, "app": "authentik_core", "name": "authentik-editor", "model_name": "user"}, "http_request": {"args": {"next": "/application/o/authorize/?client_id=43e8d2746fe2e508325a23cdf816d6ddd12e94f1&redirect_uri=http%3A%2F%2Flocalhost%3A3000%2Flogin%2Fgeneric_oauth&response_type=code&scope=openid+email+profile&state=BT8hDLepiB6WQKgDYSIbOMG4bN3mam2JhqoQCA08LxU%3D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:10:54.08931+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:10:54.088632+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
6315b883-7b38-46cf-a91e-14ef04761a1b	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"goauthentik.io/outpost/ldap": "true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET", "user_agent": "goauthentik.io/outpost/2023.10.6"}, "auth_method_args": {}}	172.20.0.8	2024-01-11 22:11:16.851466+00	{"pk": 5, "email": "authentik-admin@localhost", "username": "authentik-admin"}	2025-01-10 22:11:16.847575+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
5884597f-5ece-4a83-8171-d14b38f27227	model_updated	authentik.events.middleware	{"model": {"pk": 5, "app": "authentik_core", "name": "authentik-admin", "model_name": "user"}, "http_request": {"args": {"goauthentik.io/outpost/ldap": "true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "GET", "user_agent": "goauthentik.io/outpost/2023.10.6"}}	172.20.0.8	2024-01-11 22:11:16.869188+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:11:16.865921+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
c3258783-f555-4fd6-acb7-6a0a5768b37c	model_created	authentik.events.middleware	{"model": {"pk": "3fcd5d6c3e4043bcb916c7cd3675d0f1", "app": "authentik_crypto", "name": "authentik Self-signed Certificate", "model_name": "certificatekeypair"}, "http_request": {"args": {}, "path": "/api/v3/crypto/certificatekeypairs/generate/", "method": "POST", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:07:32.558046+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-10 22:07:32.557502+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
e5080aed-28b1-4c28-ac1d-e663d7de0062	login	authentik.events.signals	{"auth_method": "password", "http_request": {"args": {"next": "/application/o/authorize/?client_id=43e8d2746fe2e508325a23cdf816d6ddd12e94f1&redirect_uri=http%3A%2F%2Flocalhost%3A3000%2Flogin%2Fgeneric_oauth&response_type=code&scope=openid+email+profile&state=CgTPaX9JYavq4yJ5EWmgXQ9UEPhAp6TCumANg1b1jmw%3D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}, "auth_method_args": {}}	172.20.0.1	2024-01-11 22:10:28.148148+00	{"pk": 7, "email": "authentik-viewer@localhost", "username": "authentik-viewer"}	2025-01-10 22:10:28.145662+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
46c5aafd-ad92-45ed-ba31-d8de54fbdf04	model_updated	authentik.events.middleware	{"model": {"pk": 7, "app": "authentik_core", "name": "authentik-viewer", "model_name": "user"}, "http_request": {"args": {"next": "/application/o/authorize/?client_id=43e8d2746fe2e508325a23cdf816d6ddd12e94f1&redirect_uri=http%3A%2F%2Flocalhost%3A3000%2Flogin%2Fgeneric_oauth&response_type=code&scope=openid+email+profile&state=CgTPaX9JYavq4yJ5EWmgXQ9UEPhAp6TCumANg1b1jmw%3D"}, "path": "/api/v3/flows/executor/default-authentication-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:10:28.20553+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:10:28.202421+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
cbbc715b-9c98-472c-be6f-5859f99f4156	authorize_application	authentik.providers.oauth2.views.authorize	{"flow": "a7ef54bb79594559979d9345c022e086", "scopes": "openid email profile", "http_request": {"args": {"scope": "openid email profile", "state": "BT8hDLepiB6WQKgDYSIbOMG4bN3mam2JhqoQCA08LxU=", "client_id": "43e8d2746fe2e508325a23cdf816d6ddd12e94f1", "redirect_uri": "http://localhost:3000/login/generic_oauth", "response_type": "code"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}, "authorized_application": {"pk": "d7dfa1d658cb4bfc94c538a2e507e290", "app": "authentik_core", "name": "Grafana OIDC", "model_name": "application"}}	172.20.0.1	2024-01-11 22:10:54.310719+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2025-01-10 22:10:54.310134+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
ebc788aa-027b-4d78-94bc-d87d6fc1cfe6	model_updated	authentik.events.middleware	{"model": {"pk": 3, "app": "authentik_providers_oauth2", "name": "grafana-oidc", "model_name": "oauth2provider"}, "http_request": {"args": {}, "path": "/api/v3/providers/oauth2/3/", "method": "PUT", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:08:00.123074+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-10 22:08:00.122462+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
161c7b5f-88fe-4930-9f0b-be5e4184a184	authorize_application	authentik.providers.oauth2.views.authorize	{"flow": "a7ef54bb79594559979d9345c022e086", "scopes": "openid email profile", "http_request": {"args": {"scope": "openid email profile", "state": "CgTPaX9JYavq4yJ5EWmgXQ9UEPhAp6TCumANg1b1jmw=", "client_id": "43e8d2746fe2e508325a23cdf816d6ddd12e94f1", "redirect_uri": "http://localhost:3000/login/generic_oauth", "response_type": "code"}, "path": "/api/v3/flows/executor/default-provider-authorization-implicit-consent/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}, "authorized_application": {"pk": "d7dfa1d658cb4bfc94c538a2e507e290", "app": "authentik_core", "name": "Grafana OIDC", "model_name": "application"}}	172.20.0.1	2024-01-11 22:10:30.227099+00	{"pk": 7, "email": "authentik-viewer@localhost", "username": "authentik-viewer"}	2025-01-10 22:10:30.220684+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
f3cdd7de-c03d-49f4-be44-2e5d0d982faa	logout	authentik.events.signals	{"http_request": {"args": {}, "path": "/api/v3/flows/executor/default-invalidation-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:11:00.005003+00	{"pk": 8, "email": "authentik-editor@localhost", "username": "authentik-editor"}	2025-01-10 22:11:00.004272+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
1b2835c2-f1ae-4c30-8b34-252a286b3ac9	model_updated	authentik.events.middleware	{"model": {"pk": 2, "app": "authentik_providers_saml", "name": "grafana-saml", "model_name": "samlprovider"}, "http_request": {"args": {}, "path": "/api/v3/providers/saml/2/", "method": "PUT", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:08:27.768122+00	{"pk": 1, "email": "admin@localhost", "username": "akadmin"}	2025-01-10 22:08:27.767604+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
302baacc-6574-4fc7-b476-a77456c33492	logout	authentik.events.signals	{"http_request": {"args": {}, "path": "/api/v3/flows/executor/default-invalidation-flow/", "method": "GET", "user_agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36"}}	172.20.0.1	2024-01-11 22:10:36.768574+00	{"pk": 7, "email": "authentik-viewer@localhost", "username": "authentik-viewer"}	2025-01-10 22:10:36.768045+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
2d580ab2-8337-4cbe-9700-dda14b3ea05f	model_updated	authentik.events.middleware	{"model": {"pk": 6, "app": "authentik_core", "name": "ldapservice", "model_name": "user"}, "http_request": {"args": {"goauthentik.io/outpost/ldap": "true"}, "path": "/api/v3/flows/executor/ldap-authentication-flow/", "method": "POST", "user_agent": "goauthentik.io/outpost/2023.10.6"}}	172.20.0.8	2024-01-11 22:11:15.749495+00	{"pk": 2, "email": "", "username": "AnonymousUser"}	2025-01-10 22:11:15.739789+00	t	{"pk": "1b45e4ae6c1b4ea89691df11c97baeef", "app": "authentik_tenants", "name": "Default tenant", "model_name": "tenant"}
\.


--
-- Data for Name: authentik_events_notification; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_events_notification (uuid, severity, body, created, seen, event_id, user_id) FROM stdin;
\.


--
-- Data for Name: authentik_events_notificationrule; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_events_notificationrule (policybindingmodel_ptr_id, name, severity, group_id) FROM stdin;
1ed3e589-5391-4e46-a947-c764191091cd	default-notify-configuration-error	alert	15c25b04-748c-43dc-bf4b-0dad5c987f0c
5d0ae86a-0f92-4329-a141-4df745aa532d	default-notify-update	alert	15c25b04-748c-43dc-bf4b-0dad5c987f0c
2edcbba8-4015-494a-b14e-f86dfffcd52c	default-notify-exception	alert	15c25b04-748c-43dc-bf4b-0dad5c987f0c
\.


--
-- Data for Name: authentik_events_notificationrule_transports; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_events_notificationrule_transports (id, notificationrule_id, notificationtransport_id) FROM stdin;
7	1ed3e589-5391-4e46-a947-c764191091cd	559d6a10-da89-43a9-9093-b22a319cb7af
8	1ed3e589-5391-4e46-a947-c764191091cd	8b07ba8d-ecf3-4c7d-97c2-5d82aa00590e
9	5d0ae86a-0f92-4329-a141-4df745aa532d	559d6a10-da89-43a9-9093-b22a319cb7af
10	5d0ae86a-0f92-4329-a141-4df745aa532d	8b07ba8d-ecf3-4c7d-97c2-5d82aa00590e
11	2edcbba8-4015-494a-b14e-f86dfffcd52c	559d6a10-da89-43a9-9093-b22a319cb7af
12	2edcbba8-4015-494a-b14e-f86dfffcd52c	8b07ba8d-ecf3-4c7d-97c2-5d82aa00590e
\.


--
-- Data for Name: authentik_events_notificationtransport; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_events_notificationtransport (uuid, name, mode, webhook_url, send_once, webhook_mapping_id) FROM stdin;
8b07ba8d-ecf3-4c7d-97c2-5d82aa00590e	default-email-transport	email		f	\N
559d6a10-da89-43a9-9093-b22a319cb7af	default-local-transport	local		f	\N
\.


--
-- Data for Name: authentik_events_notificationwebhookmapping; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_events_notificationwebhookmapping (propertymapping_ptr_id) FROM stdin;
\.


--
-- Data for Name: authentik_flows_flow; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_flows_flow (flow_uuid, name, slug, designation, policybindingmodel_ptr_id, title, background, compatibility_mode, layout, denied_action, authentication) FROM stdin;
87ca9599-5323-451c-8603-2f5bee7a0c12	ldap-authentication-flow	ldap-authentication-flow	authentication	105415a2-7753-4a7f-bdf5-ed9841420289	ldap-authentication-flow		f	stacked	message_continue	none
4b14409d-da92-4b6c-91e8-bad06d0966c2	Change Password	default-password-change	stage_configuration	65c208d9-e145-4259-bb87-deecf97c3643	Change password		f	stacked	message_continue	require_authenticated
c4257191-cb7a-4120-9566-a38ba8a50248	Welcome to authentik!	default-authentication-flow	authentication	5be1e1aa-8051-417e-b03a-1a0e87cd8101	Welcome to authentik!		f	stacked	message_continue	none
2287d235-72aa-4d23-80a2-44278d7c7839	Logout	default-invalidation-flow	invalidation	7c8e66c0-7a12-42bd-901f-a88fcd742a5e	Default Invalidation Flow		f	stacked	message_continue	none
35537410-5840-48ee-ba54-76f2a7d42617	default-authenticator-totp-setup	default-authenticator-totp-setup	stage_configuration	62e82cc0-d670-4f23-8d7b-14675757dd8c	Setup Two-Factor authentication		f	stacked	message_continue	require_authenticated
1d2dd494-c62d-438a-8d0b-f864084f883c	User settings	default-user-settings-flow	stage_configuration	71205979-10a2-41db-9e08-c05f1644f732	Update your info		f	stacked	message_continue	require_authenticated
0bcbad7c-01fc-4ed0-b3f1-a1671683d6b3	default-authenticator-static-setup	default-authenticator-static-setup	stage_configuration	c4f758ad-0e74-4b1a-a1bc-32ae3a370b69	Setup Static OTP Tokens		f	stacked	message_continue	require_authenticated
611b3458-aadd-47c1-b37e-1940bc72ede7	default-authenticator-webauthn-setup	default-authenticator-webauthn-setup	stage_configuration	3d7a1eb4-72c2-44dd-bdf7-741750024ce2	Setup WebAuthn		f	stacked	message_continue	require_authenticated
a7ef54bb-7959-4559-979d-9345c022e086	Authorize Application	default-provider-authorization-implicit-consent	authorization	cba52268-0d9a-40bd-ae7f-b723f5e05671	Redirecting to %(app)s		f	stacked	message_continue	require_authenticated
4ca3e92c-7f33-4d2f-bb5e-1efa4c6c902a	Welcome to authentik!	default-source-authentication	authentication	181928f0-b530-4858-bee9-376597ac63ed	Welcome to authentik!		f	stacked	message_continue	require_unauthenticated
7bd42149-dc52-445a-bd1e-4513c50d01dd	Pre-Authentication	default-source-pre-authentication	stage_configuration	081ce9e5-201f-48e9-af60-7c10076f0857	Pre-authentication		f	stacked	message_continue	none
c6e83269-3b5e-4f2a-8014-f198578240c1	Welcome to authentik! Please select a username.	default-source-enrollment	enrollment	63e07f88-3fd7-4180-807f-470bb3209bac	Welcome to authentik! Please select a username.		f	stacked	message_continue	none
7c801f5d-8952-4b95-9f6c-385af22e798d	default-oobe-setup	initial-setup	stage_configuration	db71b00d-8d55-4ce6-a1a4-8fa8be93e810	Welcome to authentik!		f	stacked	message_continue	require_superuser
3b01d5c4-0d46-4bfe-b37f-553a7b4d051c	Authorize Application	default-provider-authorization-explicit-consent	authorization	ab6b7aa3-82da-4972-9158-7b7fc70ab973	Redirecting to %(app)s		f	stacked	message_continue	require_authenticated
\.


--
-- Data for Name: authentik_flows_flowstagebinding; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_flows_flowstagebinding (policybindingmodel_ptr_id, fsb_uuid, re_evaluate_policies, "order", target_id, stage_id, evaluate_on_plan, invalid_response_action) FROM stdin;
e4c83e8e-69f4-4993-a0c2-f99552fd76d0	585626b6-72d8-4f0f-9b4e-085d6a3c2ee0	f	10	87ca9599-5323-451c-8603-2f5bee7a0c12	f4abcb7d-5f92-4890-8760-afb9effda665	t	retry
9fdfd009-537e-4b36-8cc8-98f62620f410	1e25b2d4-d52b-4f19-8b9e-65960d3a64a8	f	30	87ca9599-5323-451c-8603-2f5bee7a0c12	8a432e54-5bb4-4199-add9-53e198eca1dc	t	retry
3cb69a8b-fd96-415c-95e6-f094934905d0	f7804829-283b-4e98-adc2-186ef7f2fc09	f	0	611b3458-aadd-47c1-b37e-1940bc72ede7	7dac33d8-ebb1-421c-b9d4-13aba2c28a3c	t	retry
c0792518-ed7b-4d0f-a373-5f20c253de11	aa44b8e7-908e-466f-9e5b-467c8b380ed6	f	0	4b14409d-da92-4b6c-91e8-bad06d0966c2	366481d2-b22d-4993-9502-d367fb8ae7f1	t	retry
dfabc06a-e2f8-401d-92c4-01e3185f7dc1	b695f5b6-73e4-4f4e-a25f-6eba4715ec1d	f	1	4b14409d-da92-4b6c-91e8-bad06d0966c2	e87982c6-2f31-4dc5-bdce-2f680601c023	t	retry
7321fbe5-2c34-41b6-8682-6ab794e00096	dbcef3a3-9fd3-4392-87e6-7722de38c458	f	10	c4257191-cb7a-4120-9566-a38ba8a50248	44b8d668-3efe-4e44-aa7f-74849414f977	t	retry
b696e261-9362-4cbe-b864-eee1f3c04afe	b4a7322f-e68d-4512-a10d-69b95bceefec	t	20	c4257191-cb7a-4120-9566-a38ba8a50248	02b4a829-f9ab-45d0-adcc-11e3c165f1c4	t	retry
4f206f06-1d5e-4725-8206-c58d48f5be6c	21bf872d-1b1b-44ee-a737-727e072d5680	f	0	35537410-5840-48ee-ba54-76f2a7d42617	0d0f2722-298b-4212-9307-640a205253bd	t	retry
07e871ad-dc36-48ea-abf8-397cd2a612b7	60731f11-952f-4c2f-bd4c-f35310d51e84	f	30	c4257191-cb7a-4120-9566-a38ba8a50248	b461e46b-7c2f-4188-b4a7-7a4df1c2c142	t	retry
cd0bdadb-3a40-458a-bced-d62f12dcb5aa	73c108f5-720c-46b6-922f-2aa1c9d6bf89	f	100	c4257191-cb7a-4120-9566-a38ba8a50248	58a4b17a-a21a-4c29-a3fd-6797bd7260cc	t	retry
a67caf05-5165-441b-8e62-6f37fa9c2a0d	d8ab26bb-8bd3-4bc8-8e58-9179a5805d29	f	0	2287d235-72aa-4d23-80a2-44278d7c7839	6fce99da-2643-4784-928c-94c1b2a3ab16	t	retry
1f1353d5-b69c-438e-822c-c13f75fdb18a	737c6465-10a1-4e8d-8fce-ab209f9b6d61	f	20	1d2dd494-c62d-438a-8d0b-f864084f883c	fa87ed01-29a6-457d-936d-4667077bba44	t	retry
cd98a539-1b50-4d59-b4b9-4a66b98b20fe	5672aba5-f29a-412b-b0fe-15a7ab162ec8	f	100	1d2dd494-c62d-438a-8d0b-f864084f883c	9934f0fc-b4b4-44e0-a90d-7587844ac68b	t	retry
303b1296-cc7f-4887-92fd-0ea0550fc6d4	6dbcdc89-8ac7-4159-8cda-529cabea5f58	f	0	0bcbad7c-01fc-4ed0-b3f1-a1671683d6b3	4c0a51c3-ed6a-40d6-8889-3a3e8ac13546	t	retry
65398796-09e1-494b-af85-8bed8b491c62	2bd6d69e-1b08-4c42-bf8c-adaa4ca284ce	f	0	3b01d5c4-0d46-4bfe-b37f-553a7b4d051c	d9149797-1c7d-4b62-b193-2e745f9dbb9c	t	retry
88ddedff-15ef-4b45-86cf-0aebf0e55b25	bae6a178-c8fc-4041-b2f0-a1e44f83259f	f	0	4ca3e92c-7f33-4d2f-bb5e-1efa4c6c902a	2e18f37d-528d-4c12-b9ea-d7dbf67b56a7	t	retry
6f6c5b88-ae7e-44ae-bdae-432893a9e4b6	534d4ed8-ca6e-4140-8a2b-77c546c67d07	t	0	c6e83269-3b5e-4f2a-8014-f198578240c1	89176b0f-7a9c-41eb-8897-6c532db04b96	t	retry
417e795d-6832-40b6-b083-4462357471cb	9735981f-6ff9-4207-8093-47b15ba0b678	f	1	c6e83269-3b5e-4f2a-8014-f198578240c1	dfc93c1c-c398-4e8f-aa34-fdc21b6accfb	t	retry
0a3c97a9-ac46-45cb-8718-a2984fff154a	cffd43dd-d238-4eda-8b40-31562f94b2b0	f	2	c6e83269-3b5e-4f2a-8014-f198578240c1	03fc4a51-f2e0-4844-b58b-b421ea235f34	t	retry
bc36ea75-31be-4dd6-b2cf-11f2e7ca7a33	744e08bc-bb8e-42f6-875a-bdf583d6a5e8	f	10	7c801f5d-8952-4b95-9f6c-385af22e798d	4b3bfdf2-31ed-4b1f-8de4-1752ef0ece92	t	retry
563837f0-8633-46c5-8cd2-f744cb5f3591	aaa3e596-6bd8-4326-9ece-81f586cac391	t	20	7c801f5d-8952-4b95-9f6c-385af22e798d	e87982c6-2f31-4dc5-bdce-2f680601c023	f	retry
49f5f048-9c0b-4d92-a103-e5eec6ab1ed2	dbd6f009-ee18-4461-8757-8bd99925792c	f	100	7c801f5d-8952-4b95-9f6c-385af22e798d	58a4b17a-a21a-4c29-a3fd-6797bd7260cc	t	retry
\.


--
-- Data for Name: authentik_flows_flowtoken; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_flows_flowtoken (token_ptr_id, _plan, flow_id) FROM stdin;
\.


--
-- Data for Name: authentik_flows_stage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_flows_stage (stage_uuid, name) FROM stdin;
95715d75-025b-4e5e-9d23-96826479906d	ldap-authentication-password
8a432e54-5bb4-4199-add9-53e198eca1dc	ldap-authentication-login
f4abcb7d-5f92-4890-8760-afb9effda665	ldap-identification-stage
7dac33d8-ebb1-421c-b9d4-13aba2c28a3c	default-authenticator-webauthn-setup
366481d2-b22d-4993-9502-d367fb8ae7f1	default-password-change-prompt
02b4a829-f9ab-45d0-adcc-11e3c165f1c4	default-authentication-password
b461e46b-7c2f-4188-b4a7-7a4df1c2c142	default-authentication-mfa-validation
44b8d668-3efe-4e44-aa7f-74849414f977	default-authentication-identification
6fce99da-2643-4784-928c-94c1b2a3ab16	default-invalidation-logout
4c0a51c3-ed6a-40d6-8889-3a3e8ac13546	default-authenticator-static-setup
9934f0fc-b4b4-44e0-a90d-7587844ac68b	default-user-settings-write
fa87ed01-29a6-457d-936d-4667077bba44	default-user-settings
0d0f2722-298b-4212-9307-640a205253bd	default-authenticator-totp-setup
d9149797-1c7d-4b62-b193-2e745f9dbb9c	default-provider-authorization-consent
2e18f37d-528d-4c12-b9ea-d7dbf67b56a7	default-source-authentication-login
03fc4a51-f2e0-4844-b58b-b421ea235f34	default-source-enrollment-login
89176b0f-7a9c-41eb-8897-6c532db04b96	default-source-enrollment-prompt
dfc93c1c-c398-4e8f-aa34-fdc21b6accfb	default-source-enrollment-write
4b3bfdf2-31ed-4b1f-8de4-1752ef0ece92	stage-default-oobe-password
58a4b17a-a21a-4c29-a3fd-6797bd7260cc	default-authentication-login
e87982c6-2f31-4dc5-bdce-2f680601c023	default-password-change-write
\.


--
-- Data for Name: authentik_install_id; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_install_id (id) FROM stdin;
FA8GANUqMJwFg0drDlurF+ZQK2A6ohSjc4MGksUqN+A36yIA
\.


--
-- Data for Name: authentik_outposts_dockerserviceconnection; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_outposts_dockerserviceconnection (outpostserviceconnection_ptr_id, url, tls_authentication_id, tls_verification_id) FROM stdin;
\.


--
-- Data for Name: authentik_outposts_kubernetesserviceconnection; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_outposts_kubernetesserviceconnection (outpostserviceconnection_ptr_id, kubeconfig, verify_ssl) FROM stdin;
\.


--
-- Data for Name: authentik_outposts_outpost; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_outposts_outpost (uuid, name, _config, type, service_connection_id, managed) FROM stdin;
efe635b9-2ce7-4de4-977f-9f25b9f36d97	ldap-outpost	{"log_level": "info", "docker_labels": null, "authentik_host": "http://localhost:9000/", "docker_network": null, "container_image": null, "docker_map_ports": true, "kubernetes_replicas": 1, "kubernetes_namespace": "default", "authentik_host_browser": "", "object_naming_template": "ak-outpost-%(name)s", "authentik_host_insecure": true, "kubernetes_service_type": "ClusterIP", "kubernetes_image_pull_secrets": [], "kubernetes_disabled_components": [], "kubernetes_ingress_annotations": {}, "kubernetes_ingress_secret_name": "authentik-outpost-tls"}	ldap	\N	\N
0c24aadc-f97e-4720-a70f-72a190b0cafc	authentik Embedded Outpost	{"log_level": "info", "docker_labels": null, "authentik_host": "http://localhost:9000", "docker_network": null, "container_image": null, "docker_map_ports": true, "kubernetes_replicas": 1, "kubernetes_namespace": "default", "authentik_host_browser": "", "object_naming_template": "ak-outpost-%(name)s", "authentik_host_insecure": false, "kubernetes_service_type": "ClusterIP", "kubernetes_image_pull_secrets": [], "kubernetes_disabled_components": ["deployment", "secret"], "kubernetes_ingress_annotations": {}, "kubernetes_ingress_secret_name": "authentik-outpost-tls"}	proxy	\N	goauthentik.io/outposts/embedded
\.


--
-- Data for Name: authentik_outposts_outpost_providers; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_outposts_outpost_providers (id, outpost_id, provider_id) FROM stdin;
1	efe635b9-2ce7-4de4-977f-9f25b9f36d97	1
\.


--
-- Data for Name: authentik_outposts_outpostserviceconnection; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_outposts_outpostserviceconnection (uuid, name, local) FROM stdin;
\.


--
-- Data for Name: authentik_policies_dummy_dummypolicy; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_dummy_dummypolicy (policy_ptr_id, result, wait_min, wait_max) FROM stdin;
\.


--
-- Data for Name: authentik_policies_event_matcher_eventmatcherpolicy; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_event_matcher_eventmatcherpolicy (policy_ptr_id, action, client_ip, app, model) FROM stdin;
70803949-828d-4c91-b717-71ad944e8e48	configuration_error	\N	\N	\N
590a74ec-ff58-42b2-b9ba-1bc560c6724f	update_available	\N	\N	\N
db70f174-c06b-4716-a063-67fc36823307	policy_exception	\N	\N	\N
7168d9b3-2c2c-48d3-9c6f-7f5ea85e4408	property_mapping_exception	\N	\N	\N
\.


--
-- Data for Name: authentik_policies_expiry_passwordexpirypolicy; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_expiry_passwordexpirypolicy (policy_ptr_id, deny_only, days) FROM stdin;
\.


--
-- Data for Name: authentik_policies_expression_expressionpolicy; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_expression_expressionpolicy (policy_ptr_id, expression) FROM stdin;
9588cdbe-226b-4c5a-9547-3fe684ee8260	flow_plan = request.context.get("flow_plan")\nif not flow_plan:\n    return True\n# If the user does not have a backend attached to it, they haven't\n# been authenticated yet and we need the password stage\nreturn not hasattr(flow_plan.context.get("pending_user"), "backend")
515a8421-2f61-40ad-ab94-c9997612788b	from authentik.lib.config import CONFIG\nfrom authentik.core.models import (\n    USER_ATTRIBUTE_CHANGE_EMAIL,\n    USER_ATTRIBUTE_CHANGE_NAME,\n    USER_ATTRIBUTE_CHANGE_USERNAME\n)\nprompt_data = request.context.get("prompt_data")\n\nif not request.user.group_attributes(request.http_request).get(\n    USER_ATTRIBUTE_CHANGE_EMAIL, CONFIG.get_bool("default_user_change_email", True)\n):\n    if prompt_data.get("email") != request.user.email:\n        ak_message("Not allowed to change email address.")\n        return False\n\nif not request.user.group_attributes(request.http_request).get(\n    USER_ATTRIBUTE_CHANGE_NAME, CONFIG.get_bool("default_user_change_name", True)\n):\n    if prompt_data.get("name") != request.user.name:\n        ak_message("Not allowed to change name.")\n        return False\n\nif not request.user.group_attributes(request.http_request).get(\n    USER_ATTRIBUTE_CHANGE_USERNAME, CONFIG.get_bool("default_user_change_username", True)\n):\n    if prompt_data.get("username") != request.user.username:\n        ak_message("Not allowed to change username.")\n        return False\n\nreturn True
83952542-88c4-404d-b62f-ff22889a5047	# This policy sets the user for the currently running flow\n# by injecting "pending_user"\nakadmin = ak_user_by(username="akadmin")\ncontext["flow_plan"].context["pending_user"] = akadmin\nreturn True
fd5bfceb-8270-41f7-abef-84a47841d0e8	# This policy ensures that the setup flow can only be\n# executed when the admin user doesn''t have a password set\nakadmin = ak_user_by(username="akadmin")\nreturn not akadmin.has_usable_password()
fd3f6a6c-6623-489d-9d45-868df08c3b75	# This policy ensures that the setup flow can only be\n# used one time\nfrom authentik.flows.models import Flow, FlowAuthenticationRequirement\nFlow.objects.filter(slug="initial-setup").update(\n    authentication=FlowAuthenticationRequirement.REQUIRE_SUPERUSER,\n)\nreturn True
d892bf8e-8fde-4851-95db-c8bf8b277fe8	# This policy ensures that this flow can only be used when the user\n# is in a SSO Flow (meaning they come from an external IdP)\nreturn ak_is_sso_flow
ac669155-b876-42a0-b998-7bfae5c3d11c	# Check if we''ve not been given a username by the external IdP\n# and trigger the enrollment flow\nreturn 'username' not in context.get('prompt_data', {})
8721edd2-c6a9-42d8-bd81-c85d528ba9d8	# This policy ensures that this flow can only be used when the user\n# is in a SSO Flow (meaning they come from an external IdP)\nreturn ak_is_sso_flow
\.


--
-- Data for Name: authentik_policies_password_passwordpolicy; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_password_passwordpolicy (policy_ptr_id, amount_uppercase, amount_lowercase, amount_symbols, length_min, symbol_charset, error_message, password_field, amount_digits, check_have_i_been_pwned, check_static_rules, check_zxcvbn, hibp_allowed_count, zxcvbn_score_threshold) FROM stdin;
\.


--
-- Data for Name: authentik_policies_policy; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_policy (created, last_updated, policy_uuid, name, execution_logging) FROM stdin;
2022-10-25 09:09:12.352255+00	2024-01-10 13:34:52.611461+00	70803949-828d-4c91-b717-71ad944e8e48	default-match-configuration-error	f
2022-10-25 09:09:13.006949+00	2024-01-10 13:34:52.633986+00	590a74ec-ff58-42b2-b9ba-1bc560c6724f	default-match-update	f
2022-10-25 09:09:13.724566+00	2024-01-10 13:34:52.656067+00	db70f174-c06b-4716-a063-67fc36823307	default-match-policy-exception	f
2022-10-25 09:09:13.728881+00	2024-01-10 13:34:52.659921+00	7168d9b3-2c2c-48d3-9c6f-7f5ea85e4408	default-match-property-mapping-exception	f
2024-01-10 13:34:53.197968+00	2024-01-10 13:34:54.279244+00	9588cdbe-226b-4c5a-9547-3fe684ee8260	default-authentication-flow-password-stage	f
2022-10-25 09:09:08.5634+00	2024-01-10 13:34:54.427456+00	515a8421-2f61-40ad-ab94-c9997612788b	default-user-settings-authorization	f
2022-10-25 09:09:10.076908+00	2024-01-10 13:36:28.483735+00	8721edd2-c6a9-42d8-bd81-c85d528ba9d8	default-source-enrollment-if-sso	f
2022-10-25 09:09:28.773441+00	2024-01-10 13:36:28.635412+00	83952542-88c4-404d-b62f-ff22889a5047	default-oobe-prefill-user	f
2022-10-25 09:09:28.779052+00	2024-01-10 13:36:28.638387+00	fd5bfceb-8270-41f7-abef-84a47841d0e8	default-oobe-password-usable	f
2024-01-10 13:36:26.752962+00	2024-01-10 13:36:28.641341+00	fd3f6a6c-6623-489d-9d45-868df08c3b75	default-oobe-flow-set-authentication	f
2022-10-25 09:09:08.800329+00	2024-01-10 13:36:28.419593+00	d892bf8e-8fde-4851-95db-c8bf8b277fe8	default-source-authentication-if-sso	f
2022-10-25 09:09:10.070001+00	2024-01-10 13:36:28.480406+00	ac669155-b876-42a0-b998-7bfae5c3d11c	default-source-enrollment-if-username	f
\.


--
-- Data for Name: authentik_policies_policybinding; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_policybinding (policy_binding_uuid, enabled, "order", policy_id, target_id, negate, timeout, group_id, user_id, failure_result) FROM stdin;
8bfc6195-0957-4be5-abb6-dcd9816a3c24	t	0	70803949-828d-4c91-b717-71ad944e8e48	1ed3e589-5391-4e46-a947-c764191091cd	f	30	\N	\N	f
486d3ed0-3097-434c-8f22-da01f1938775	t	0	590a74ec-ff58-42b2-b9ba-1bc560c6724f	5d0ae86a-0f92-4329-a141-4df745aa532d	f	30	\N	\N	f
c4525029-87a5-448a-bdf9-583b7c122fa5	t	0	db70f174-c06b-4716-a063-67fc36823307	2edcbba8-4015-494a-b14e-f86dfffcd52c	f	30	\N	\N	f
36b5a264-eea9-4d7e-b11c-36be3efaf92e	t	1	7168d9b3-2c2c-48d3-9c6f-7f5ea85e4408	2edcbba8-4015-494a-b14e-f86dfffcd52c	f	30	\N	\N	f
b5e045e7-4c90-4feb-8e4b-7604085119ad	t	10	9588cdbe-226b-4c5a-9547-3fe684ee8260	b696e261-9362-4cbe-b864-eee1f3c04afe	f	30	\N	\N	f
ffc7c71f-eba8-4535-bc55-1ab18fa165ef	t	0	8721edd2-c6a9-42d8-bd81-c85d528ba9d8	63e07f88-3fd7-4180-807f-470bb3209bac	f	30	\N	\N	f
492fe6be-936e-4dc4-bca8-72a845fe3b08	t	0	ac669155-b876-42a0-b998-7bfae5c3d11c	6f6c5b88-ae7e-44ae-bdae-432893a9e4b6	f	30	\N	\N	f
b69908c9-bcba-4cc8-a2e6-e7d2b8e71584	t	0	fd5bfceb-8270-41f7-abef-84a47841d0e8	db71b00d-8d55-4ce6-a1a4-8fa8be93e810	f	30	\N	\N	f
0bf4412d-93f2-4e15-b747-f6b6a5c578bc	t	0	83952542-88c4-404d-b62f-ff22889a5047	563837f0-8633-46c5-8cd2-f744cb5f3591	f	30	\N	\N	f
8e567620-a250-4e98-b095-ffb0bef7af40	t	0	fd3f6a6c-6623-489d-9d45-868df08c3b75	49f5f048-9c0b-4d92-a103-e5eec6ab1ed2	f	30	\N	\N	f
329669b7-205e-4ee0-a548-cd3376bd09ad	t	0	d892bf8e-8fde-4851-95db-c8bf8b277fe8	181928f0-b530-4858-bee9-376597ac63ed	f	30	\N	\N	f
\.


--
-- Data for Name: authentik_policies_policybindingmodel; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_policybindingmodel (pbm_uuid, policy_engine_mode) FROM stdin;
77d294b5-8a50-4d6d-8edd-5b15e5871826	any
105415a2-7753-4a7f-bdf5-ed9841420289	any
e4c83e8e-69f4-4993-a0c2-f99552fd76d0	any
9fdfd009-537e-4b36-8cc8-98f62620f410	any
506b1180-4069-4dda-9405-e185f355c34d	any
0e32dc99-655c-42f4-aca4-f3f271e010fd	any
d7dfa1d6-58cb-4bfc-94c5-38a2e507e290	any
3d7a1eb4-72c2-44dd-bdf7-741750024ce2	any
3cb69a8b-fd96-415c-95e6-f094934905d0	any
1ed3e589-5391-4e46-a947-c764191091cd	any
5d0ae86a-0f92-4329-a141-4df745aa532d	any
2edcbba8-4015-494a-b14e-f86dfffcd52c	any
c0792518-ed7b-4d0f-a373-5f20c253de11	any
dfabc06a-e2f8-401d-92c4-01e3185f7dc1	any
5be1e1aa-8051-417e-b03a-1a0e87cd8101	any
7321fbe5-2c34-41b6-8682-6ab794e00096	any
b696e261-9362-4cbe-b864-eee1f3c04afe	any
07e871ad-dc36-48ea-abf8-397cd2a612b7	any
cd0bdadb-3a40-458a-bced-d62f12dcb5aa	any
7c8e66c0-7a12-42bd-901f-a88fcd742a5e	any
a67caf05-5165-441b-8e62-6f37fa9c2a0d	any
71205979-10a2-41db-9e08-c05f1644f732	any
1f1353d5-b69c-438e-822c-c13f75fdb18a	any
cd98a539-1b50-4d59-b4b9-4a66b98b20fe	any
c4f758ad-0e74-4b1a-a1bc-32ae3a370b69	any
303b1296-cc7f-4887-92fd-0ea0550fc6d4	any
62e82cc0-d670-4f23-8d7b-14675757dd8c	any
4f206f06-1d5e-4725-8206-c58d48f5be6c	any
65c208d9-e145-4259-bb87-deecf97c3643	any
ab6b7aa3-82da-4972-9158-7b7fc70ab973	any
65398796-09e1-494b-af85-8bed8b491c62	any
cba52268-0d9a-40bd-ae7f-b723f5e05671	any
181928f0-b530-4858-bee9-376597ac63ed	any
88ddedff-15ef-4b45-86cf-0aebf0e55b25	any
081ce9e5-201f-48e9-af60-7c10076f0857	any
63e07f88-3fd7-4180-807f-470bb3209bac	any
6f6c5b88-ae7e-44ae-bdae-432893a9e4b6	any
417e795d-6832-40b6-b083-4462357471cb	any
0a3c97a9-ac46-45cb-8718-a2984fff154a	any
db71b00d-8d55-4ce6-a1a4-8fa8be93e810	any
bc36ea75-31be-4dd6-b2cf-11f2e7ca7a33	any
563837f0-8633-46c5-8cd2-f744cb5f3591	any
49f5f048-9c0b-4d92-a103-e5eec6ab1ed2	any
\.


--
-- Data for Name: authentik_policies_reputation_reputation; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_reputation_reputation (reputation_uuid, identifier, ip, ip_geo_data, score, updated, expires, expiring) FROM stdin;
12dd4686-a03a-4094-984a-7df6e32666e3	akadmin	172.20.0.1	{}	1	2024-01-11 22:06:44.922067+00	2024-01-12 22:06:44.921204+00	t
c0783b41-a22c-4093-ab63-9038ad174bbb	authentik-viewer	172.20.0.1	{}	1	2024-01-11 22:10:28.507575+00	2024-01-12 22:10:28.498415+00	t
318b3a5e-5b2f-4082-8b67-e1481d731d32	authentik-editor	172.20.0.1	{}	1	2024-01-11 22:10:54.126894+00	2024-01-12 22:10:54.126667+00	t
72c0af40-7d86-4724-ac14-94e405580960	ldapservice	172.20.0.8	{}	1	2024-01-11 22:11:16.091562+00	2024-01-12 22:11:16.09075+00	t
3d6a52ef-80aa-4774-a88f-67db06dd6933	authentik-admin	172.20.0.8	{}	1	2024-01-11 22:11:16.910702+00	2024-01-12 22:11:16.910258+00	t
\.


--
-- Data for Name: authentik_policies_reputation_reputationpolicy; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_policies_reputation_reputationpolicy (policy_ptr_id, check_ip, check_username, threshold) FROM stdin;
\.


--
-- Data for Name: authentik_providers_ldap_ldapprovider; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_ldap_ldapprovider (provider_ptr_id, base_dn, search_group_id, certificate_id, tls_server_name, gid_start_number, uid_start_number, search_mode, bind_mode, mfa_support) FROM stdin;
1	DC=ldap,DC=goauthentik,DC=io	a9c6327c-cfca-4d5b-a0af-421645e43c31	\N		4000	2000	direct	direct	t
\.


--
-- Data for Name: authentik_providers_oauth2_accesstoken; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_oauth2_accesstoken (id, expires, expiring, revoked, _scope, token, _id_token, provider_id, user_id, auth_time, session_id) FROM stdin;
2	2024-01-11 22:15:30.794629+00	t	f	openid email profile	eyJhbGciOiJSUzI1NiIsImtpZCI6IjRlM2MzZDFhYjJkMmU4Y2IyMTQyZGNmNDBhOTE4OTIyIiwidHlwIjoiSldUIn0.eyJpc3MiOiJodHRwOi8vc3VwcG9ydC5sYWI6OTAwMC9hcHBsaWNhdGlvbi9vL2dyYWZhbmEtb2lkYy8iLCJzdWIiOiI5ZmMxOTgyODQ0MmMzODg3MzE5YjY4ZDI0OTZjYWNiMjhlOTUwY2I2MTE3ODY3MjFkMDdkMWZiNTc5ZjM5MTk5IiwiYXVkIjoiNDNlOGQyNzQ2ZmUyZTUwODMyNWEyM2NkZjgxNmQ2ZGRkMTJlOTRmMSIsImV4cCI6MTcwNTAxMTMzMCwiaWF0IjoxNzA1MDExMDMwLCJhdXRoX3RpbWUiOjE3MDUwMTEwMjgsImFjciI6ImdvYXV0aGVudGlrLmlvL3Byb3ZpZGVycy9vYXV0aDIvZGVmYXVsdCIsImVtYWlsIjoiYXV0aGVudGlrLXZpZXdlckBsb2NhbGhvc3QiLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwibmFtZSI6ImF1dGhlbnRpay12aWV3ZXIiLCJnaXZlbl9uYW1lIjoiYXV0aGVudGlrLXZpZXdlciIsInByZWZlcnJlZF91c2VybmFtZSI6ImF1dGhlbnRpay12aWV3ZXIiLCJuaWNrbmFtZSI6ImF1dGhlbnRpay12aWV3ZXIiLCJncm91cHMiOlsidmlld2VyIl0sImF6cCI6IjQzZThkMjc0NmZlMmU1MDgzMjVhMjNjZGY4MTZkNmRkZDEyZTk0ZjEiLCJ1aWQiOiI3cGpvSVQwamxTZ1VXcHBKRkFXZ0pZem5ibDNjUWIyYU9VOWIwUGhBIn0.UtMubrWVhHvjwn6eRnIfTw08t_ay7HnKnilSKmmh9J7NE2mya7CWA8tQvwn2f70B6AvkAKOVbgxIcCmVfW7skixNQsK_aBONwanepBgPHqPXA7vS_9G18ITa5vLvgHKzWptGrMqa1PeJQzVbB4N_xXjYMF0iQPNgwZP9_Ikrod62QVuDylHFmQhr6wCiGEbcZ6WkkwZg2_j-O7ocVpOlcLlXOZkKV1eYkSMY21imk7PQE95AhEb1Zo4xdFCm7wckYpd_KtqkIcEvBwFotSQKkLfDECkdgMVCJbaP6HJUW3tIQ_vIAm0-B591SZcVCm4F6Jbe-edjfT-RIpHIlY9yAraei1k-HE3QwXKp7LzuOZSQq8TT1_x2F_U7ZePdk93gQ3BtomZ622eL24s2OfQKPYVFc80hNwAuk3LqFhMT4BeMtge33Hx46IXOJX-kOFU9I8jdIMPjfIdUJ53Ma-g8aSUdZqOP2SP6GJajWBMrMh-yyHy8D9nsUqZhWGNffwhcwa_ZDiMjrl9KBIMtdvW3IFwhVh9Ga2QQRGJsw_IN-s5tBz8neOcpQfs4y-bL2Ipb3GHMcr6vIhQvNE_Juf1lwOOL03K7Ofy4JVENIixF-hp7jGpSng-YV74eMtj3FqjafpCt-BkP7sus8bezVGDNomrQzDrp_NaKc1gqaqd2Ogk	{"iss": "http://support.lab:9000/application/o/grafana-oidc/", "sub": "9fc19828442c3887319b68d2496cacb28e950cb611786721d07d1fb579f39199", "aud": "43e8d2746fe2e508325a23cdf816d6ddd12e94f1", "exp": 1705011330, "iat": 1705011030, "auth_time": 1705011028, "acr": "goauthentik.io/providers/oauth2/default", "amr": null, "c_hash": null, "nonce": null, "at_hash": null, "claims": {"email": "authentik-viewer@localhost", "email_verified": true, "name": "authentik-viewer", "given_name": "authentik-viewer", "preferred_username": "authentik-viewer", "nickname": "authentik-viewer", "groups": ["viewer"]}}	3	7	2024-01-11 22:10:28.148148+00	0164b59fd260313483e48a466d2a652797f7e2683b98e357c4ae595e9249414e
3	2024-01-11 22:15:54.393285+00	t	f	openid email profile	eyJhbGciOiJSUzI1NiIsImtpZCI6IjRlM2MzZDFhYjJkMmU4Y2IyMTQyZGNmNDBhOTE4OTIyIiwidHlwIjoiSldUIn0.eyJpc3MiOiJodHRwOi8vc3VwcG9ydC5sYWI6OTAwMC9hcHBsaWNhdGlvbi9vL2dyYWZhbmEtb2lkYy8iLCJzdWIiOiI3ZjM4ODAzY2ZkMzg4NWRkNTc4ZTEwNmJhNTg5ODU5ZWU5OTdiNDI2OGU2NzIzZWU1ZjBkMDU1ZDExNTYzMDA1IiwiYXVkIjoiNDNlOGQyNzQ2ZmUyZTUwODMyNWEyM2NkZjgxNmQ2ZGRkMTJlOTRmMSIsImV4cCI6MTcwNTAxMTM1NCwiaWF0IjoxNzA1MDExMDU0LCJhdXRoX3RpbWUiOjE3MDUwMTEwNTQsImFjciI6ImdvYXV0aGVudGlrLmlvL3Byb3ZpZGVycy9vYXV0aDIvZGVmYXVsdCIsImVtYWlsIjoiYXV0aGVudGlrLWVkaXRvckBsb2NhbGhvc3QiLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwibmFtZSI6ImF1dGhlbnRpay1lZGl0b3IiLCJnaXZlbl9uYW1lIjoiYXV0aGVudGlrLWVkaXRvciIsInByZWZlcnJlZF91c2VybmFtZSI6ImF1dGhlbnRpay1lZGl0b3IiLCJuaWNrbmFtZSI6ImF1dGhlbnRpay1lZGl0b3IiLCJncm91cHMiOlsiZWRpdG9yIiwiZXh0cmEtZ3JvdXAiXSwiYXpwIjoiNDNlOGQyNzQ2ZmUyZTUwODMyNWEyM2NkZjgxNmQ2ZGRkMTJlOTRmMSIsInVpZCI6Im12aE9YYTFISEk0TlVGdTlhcm9CVE9KSmh6RzQzUU1QS0JGa20xbTMifQ.azZ4QLiKWU05Gg4pGIVqKuPQE-cZwvLvM2kOlHqOGiIlPyro4h4R9WROd42plv9Onn7IGGsb8KNmfBehwX0tGR_0HTh046UBcv3AYU8HAJwGwLG2Bdz6L2Y7UloLhe-oRRvuAA_hd_CLV2YVeU_5539UAuJUIMd7WxFjBSE4jrEx0_KD8Ht8IjAlkuVpEprenLagmFz9XAsGCu-23xA7CoJeCMR9TXdLo_vP8uxQlntEoVPLomwLCdCkQxC3xo3evbiB-rjBj4pmjPXOMtrOsB5JdATKQarVNPcQE88IZ6K2kr7GuN102UOBequPEWwO_DtEC1nbXpFtTOwCrCmLkMDhz4bOxTsF0885piQxM7QkqozjhoSv1IxlHH6EPPCiwNdXmERrejNJ6yTjxXRr0zuJm2HYfEx3-2pue5b2uTjjWyh804S8Rh6Pxk1y7DbbifRV01QLMja2K8HX5mTKzRhDfHj5_i_3G1r57R2ybIzHwoVoKTL2gzSly5UJx3LhllxTByaBb_Edow7WXFy4qrTL6MeSYWZjDnajbQ2fbBH8gH1GmbABrr92SBNNhR_sj6lkytvVOIhLfcsukjjXx9-gOgNB4cpPuUXOvhCQhxEK5vnTKes8OhyBv2PBjPQgIPN_ke_QK3bZIMDqcAU8UFg8eVdfixNtrHtsqV9zy28	{"iss": "http://support.lab:9000/application/o/grafana-oidc/", "sub": "7f38803cfd3885dd578e106ba589859ee997b4268e6723ee5f0d055d11563005", "aud": "43e8d2746fe2e508325a23cdf816d6ddd12e94f1", "exp": 1705011354, "iat": 1705011054, "auth_time": 1705011054, "acr": "goauthentik.io/providers/oauth2/default", "amr": null, "c_hash": null, "nonce": null, "at_hash": null, "claims": {"email": "authentik-editor@localhost", "email_verified": true, "name": "authentik-editor", "given_name": "authentik-editor", "preferred_username": "authentik-editor", "nickname": "authentik-editor", "groups": ["editor", "extra-group"]}}	3	8	2024-01-11 22:10:54.076153+00	dcc4d376a787547e44300d834a6ca2a6c734d5beec7a995b55acc555207461dd
\.


--
-- Data for Name: authentik_providers_oauth2_authorizationcode; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_oauth2_authorizationcode (id, expires, expiring, _scope, code, nonce, code_challenge, code_challenge_method, provider_id, user_id, revoked, auth_time, session_id) FROM stdin;
\.


--
-- Data for Name: authentik_providers_oauth2_devicetoken; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_oauth2_devicetoken (id, expires, expiring, device_code, user_code, _scope, provider_id, user_id) FROM stdin;
\.


--
-- Data for Name: authentik_providers_oauth2_oauth2provider; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_oauth2_oauth2provider (provider_ptr_id, client_type, client_id, client_secret, redirect_uris, include_claims_in_id_token, refresh_token_validity, signing_key_id, sub_mode, issuer_mode, access_code_validity, access_token_validity) FROM stdin;
3	confidential	43e8d2746fe2e508325a23cdf816d6ddd12e94f1	e50440f14a010fd69dfed85bc6c071653f22c73e2c6c8d7ba96a936937d92040936b7e5a4bcc1bf40d5cf1dc019b1db327a1a00e2183c53471fb7530d4a09d7e	.*	t	days=30	3fcd5d6c-3e40-43bc-b916-c7cd3675d0f1	hashed_user_id	per_provider	minutes=1	minutes=5
\.


--
-- Data for Name: authentik_providers_oauth2_oauth2provider_jwks_sources; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_oauth2_oauth2provider_jwks_sources (id, oauth2provider_id, oauthsource_id) FROM stdin;
\.


--
-- Data for Name: authentik_providers_oauth2_refreshtoken; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_oauth2_refreshtoken (id, expires, expiring, _scope, _id_token, provider_id, user_id, revoked, token, auth_time, session_id) FROM stdin;
2	2024-02-10 22:10:30.794629+00	t	openid email profile	{"iss": "http://support.lab:9000/application/o/grafana-oidc/", "sub": "9fc19828442c3887319b68d2496cacb28e950cb611786721d07d1fb579f39199", "aud": "43e8d2746fe2e508325a23cdf816d6ddd12e94f1", "exp": 1707603030, "iat": 1705011031, "auth_time": 1705011028, "acr": "goauthentik.io/providers/oauth2/default", "amr": null, "c_hash": null, "nonce": null, "at_hash": "mGFSh_jKOLwb-sZBngObVw", "claims": {"email": "authentik-viewer@localhost", "email_verified": true, "name": "authentik-viewer", "given_name": "authentik-viewer", "preferred_username": "authentik-viewer", "nickname": "authentik-viewer", "groups": ["viewer"]}}	3	7	f	qEy5NMin86Yonih6sBtXgK4mFdzu4owN5DHXllqESCEGxaT96jsc2utPJrpvdbf5hlSf00Ffc3Uve6SAQtLh06P9Ycv3yBIzpTFvDi6bGcLXZPO8W9cYcfI7fsqHIXq3	2024-01-11 22:10:28.148148+00	0164b59fd260313483e48a466d2a652797f7e2683b98e357c4ae595e9249414e
3	2024-02-10 22:10:54.393285+00	t	openid email profile	{"iss": "http://support.lab:9000/application/o/grafana-oidc/", "sub": "7f38803cfd3885dd578e106ba589859ee997b4268e6723ee5f0d055d11563005", "aud": "43e8d2746fe2e508325a23cdf816d6ddd12e94f1", "exp": 1707603054, "iat": 1705011054, "auth_time": 1705011054, "acr": "goauthentik.io/providers/oauth2/default", "amr": null, "c_hash": null, "nonce": null, "at_hash": "YdMhObdt58ReC4t7A_3USg", "claims": {"email": "authentik-editor@localhost", "email_verified": true, "name": "authentik-editor", "given_name": "authentik-editor", "preferred_username": "authentik-editor", "nickname": "authentik-editor", "groups": ["editor", "extra-group"]}}	3	8	f	QaLmuHsYcDVmmoJdfZlw2ZsI1iVypVy8sZOVt8V9RErRYWGKgAGSD56yYfrTQrLv2oseM0S2pmdR8w2fK4CIUwWKYZVimfyZpsMOteeQda7XgNLQXI9zEKooou4kRttM	2024-01-11 22:10:54.076153+00	dcc4d376a787547e44300d834a6ca2a6c734d5beec7a995b55acc555207461dd
\.


--
-- Data for Name: authentik_providers_oauth2_scopemapping; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_oauth2_scopemapping (propertymapping_ptr_id, scope_name, description) FROM stdin;
d3406e7e-2c6d-4d72-acdd-dda5513b1396	ak_proxy	authentik Proxy - User information
9c13a34a-6007-4846-8c28-11d6dbd235c7	openid	
a4825145-a8d1-4fbf-b88c-70d8cc801a4a	email	Email address
7446364c-faec-4cab-9191-beb2889d47b7	profile	General Profile Information
\.


--
-- Data for Name: authentik_providers_proxy_proxyprovider; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_proxy_proxyprovider (oauth2provider_ptr_id, internal_host, external_host, cookie_secret, certificate_id, skip_path_regex, internal_host_ssl_validation, basic_auth_enabled, basic_auth_password_attribute, basic_auth_user_attribute, cookie_domain, mode, intercept_header_auth) FROM stdin;
\.


--
-- Data for Name: authentik_providers_radius_radiusprovider; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_radius_radiusprovider (provider_ptr_id, shared_secret, client_networks, mfa_support) FROM stdin;
\.


--
-- Data for Name: authentik_providers_saml_samlpropertymapping; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_saml_samlpropertymapping (propertymapping_ptr_id, saml_name, friendly_name) FROM stdin;
765b25ee-0e8b-4394-a56c-e27abf68f5ce	http://schemas.xmlsoap.org/ws/2005/05/identity/claims/upn	\N
ef027c1a-728f-44e5-9072-6942d3e8d15e	http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name	\N
05712cf6-0557-4ae7-95e7-3a0538962b67	http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress	\N
b3fa1ee7-9507-4869-a29a-3c17c2482839	http://schemas.goauthentik.io/2021/02/saml/username	\N
38ac59c3-e754-44e7-9790-5108a2cd027c	http://schemas.goauthentik.io/2021/02/saml/uid	\N
c5d93ce6-8cda-42fa-9c19-3837ba67788a	http://schemas.xmlsoap.org/claims/Group	\N
29fab284-b6db-433a-9c3c-7575aba47b2b	http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsaccountname	\N
\.


--
-- Data for Name: authentik_providers_saml_samlprovider; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_saml_samlprovider (provider_ptr_id, acs_url, audience, issuer, assertion_valid_not_before, assertion_valid_not_on_or_after, session_valid_not_on_or_after, digest_algorithm, signature_algorithm, signing_kp_id, sp_binding, verification_kp_id, name_id_mapping_id, default_relay_state) FROM stdin;
2	http://localhost:3000/saml/acs		http://localhost:3000/saml/metadata	minutes=-5	minutes=5	minutes=86400	http://www.w3.org/2001/04/xmlenc#sha256	http://www.w3.org/2001/04/xmldsig-more#rsa-sha256	3fcd5d6c-3e40-43bc-b916-c7cd3675d0f1	post	\N	38ac59c3-e754-44e7-9790-5108a2cd027c	
\.


--
-- Data for Name: authentik_providers_scim_scimgroup; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_scim_scimgroup (id, group_id, provider_id) FROM stdin;
\.


--
-- Data for Name: authentik_providers_scim_scimmapping; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_scim_scimmapping (propertymapping_ptr_id) FROM stdin;
83a19cb8-acab-44e1-884f-a0a279ae4d2d
252edb40-34ee-4f55-8ca4-4bf0a7fb445f
\.


--
-- Data for Name: authentik_providers_scim_scimprovider; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_scim_scimprovider (provider_ptr_id, url, token, exclude_users_service_account, filter_group_id) FROM stdin;
\.


--
-- Data for Name: authentik_providers_scim_scimprovider_property_mappings_group; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_scim_scimprovider_property_mappings_group (id, scimprovider_id, propertymapping_id) FROM stdin;
\.


--
-- Data for Name: authentik_providers_scim_scimuser; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_providers_scim_scimuser (id, provider_id, user_id) FROM stdin;
\.


--
-- Data for Name: authentik_rbac_role; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_rbac_role (uuid, name, group_id) FROM stdin;
\.


--
-- Data for Name: authentik_sources_ldap_ldappropertymapping; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_ldap_ldappropertymapping (propertymapping_ptr_id, object_field) FROM stdin;
200af9d0-7476-43e1-a0fb-b7a7a68dd277	path
353b9d65-66ce-4fea-814b-e12c6e45a277	name
a58eb3a5-c68d-406d-a5ff-688a6a047575	email
a75310af-c0cf-4709-a66c-963d8c27e662	username
b5ae1f98-a70a-4ea3-a8c5-15285a8755bc	attributes.upn
e8244e12-ed86-4f61-a0df-cfac793c267e	attributes.givenName
81c79ce4-042d-470d-9aa4-48baaa08591b	attributes.sn
0094050f-e24a-4eff-8346-712851851af9	username
e8809202-4ff0-4086-b078-196e6152e826	name
\.


--
-- Data for Name: authentik_sources_ldap_ldapsource; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_ldap_ldapsource (source_ptr_id, server_uri, bind_cn, bind_password, start_tls, base_dn, additional_user_dn, additional_group_dn, user_object_filter, group_object_filter, object_uniqueness_field, sync_groups, sync_parent_group_id, sync_users, sync_users_password, group_membership_field, peer_certificate_id, client_certificate_id, sni) FROM stdin;
\.


--
-- Data for Name: authentik_sources_ldap_ldapsource_property_mappings_group; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_ldap_ldapsource_property_mappings_group (id, ldapsource_id, propertymapping_id) FROM stdin;
\.


--
-- Data for Name: authentik_sources_oauth_oauthsource; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_oauth_oauthsource (source_ptr_id, provider_type, request_token_url, authorization_url, access_token_url, profile_url, consumer_key, consumer_secret, additional_scopes, oidc_jwks, oidc_jwks_url, oidc_well_known_url) FROM stdin;
\.


--
-- Data for Name: authentik_sources_oauth_useroauthsourceconnection; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_oauth_useroauthsourceconnection (usersourceconnection_ptr_id, identifier, access_token) FROM stdin;
\.


--
-- Data for Name: authentik_sources_plex_plexsource; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_plex_plexsource (source_ptr_id, client_id, allowed_servers, allow_friends, plex_token) FROM stdin;
\.


--
-- Data for Name: authentik_sources_plex_plexsourceconnection; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_plex_plexsourceconnection (usersourceconnection_ptr_id, plex_token, identifier) FROM stdin;
\.


--
-- Data for Name: authentik_sources_saml_samlsource; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_saml_samlsource (source_ptr_id, issuer, sso_url, slo_url, signing_kp_id, binding_type, temporary_user_delete_after, name_id_policy, allow_idp_initiated, digest_algorithm, signature_algorithm, pre_authentication_flow_id, verification_kp_id) FROM stdin;
\.


--
-- Data for Name: authentik_sources_saml_usersamlsourceconnection; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_sources_saml_usersamlsourceconnection (usersourceconnection_ptr_id, identifier) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_duo_authenticatorduostage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_duo_authenticatorduostage (stage_ptr_id, client_id, client_secret, api_hostname, configure_flow_id, admin_integration_key, admin_secret_key, friendly_name) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_duo_duodevice; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_duo_duodevice (id, name, confirmed, duo_user_id, stage_id, user_id, last_t) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_sms_authenticatorsmsstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_sms_authenticatorsmsstage (stage_ptr_id, provider, account_sid, auth, configure_flow_id, from_number, auth_password, auth_type, verify_only, mapping_id, friendly_name) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_sms_smsdevice; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_sms_smsdevice (id, name, confirmed, token, valid_until, phone_number, stage_id, user_id, last_t) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_static_authenticatorstaticstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_static_authenticatorstaticstage (stage_ptr_id, token_count, configure_flow_id, friendly_name, token_length) FROM stdin;
4c0a51c3-ed6a-40d6-8889-3a3e8ac13546	6	0bcbad7c-01fc-4ed0-b3f1-a1671683d6b3	\N	12
\.


--
-- Data for Name: authentik_stages_authenticator_static_staticdevice; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_static_staticdevice (id, name, confirmed, user_id, throttling_failure_count, throttling_failure_timestamp) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_static_statictoken; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_static_statictoken (id, token, device_id) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_totp_authenticatortotpstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_totp_authenticatortotpstage (stage_ptr_id, digits, configure_flow_id, friendly_name) FROM stdin;
0d0f2722-298b-4212-9307-640a205253bd	6	35537410-5840-48ee-ba54-76f2a7d42617	\N
\.


--
-- Data for Name: authentik_stages_authenticator_totp_totpdevice; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_totp_totpdevice (id, name, confirmed, key, step, t0, digits, tolerance, drift, last_t, user_id, throttling_failure_count, throttling_failure_timestamp) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_validate_authenticatorvalida3e25; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_validate_authenticatorvalida3e25 (id, authenticatorvalidatestage_id, stage_id) FROM stdin;
\.


--
-- Data for Name: authentik_stages_authenticator_validate_authenticatorvalida499c; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_validate_authenticatorvalida499c (stage_ptr_id, not_configured_action, device_classes, last_auth_threshold, webauthn_user_verification) FROM stdin;
b461e46b-7c2f-4188-b4a7-7a4df1c2c142	skip	{static,totp,webauthn,duo,sms}	seconds=0	preferred
\.


--
-- Data for Name: authentik_stages_authenticator_webauthn_authenticatewebauth4bbe; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_webauthn_authenticatewebauth4bbe (stage_ptr_id, configure_flow_id, user_verification, authenticator_attachment, resident_key_requirement, friendly_name) FROM stdin;
7dac33d8-ebb1-421c-b9d4-13aba2c28a3c	611b3458-aadd-47c1-b37e-1940bc72ede7	preferred	\N	preferred	\N
\.


--
-- Data for Name: authentik_stages_authenticator_webauthn_webauthndevice; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_authenticator_webauthn_webauthndevice (id, name, credential_id, public_key, sign_count, rp_id, created_on, last_t, user_id, confirmed) FROM stdin;
\.


--
-- Data for Name: authentik_stages_captcha_captchastage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_captcha_captchastage (stage_ptr_id, public_key, private_key, api_url, js_url) FROM stdin;
\.


--
-- Data for Name: authentik_stages_consent_consentstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_consent_consentstage (stage_ptr_id, consent_expire_in, mode) FROM stdin;
d9149797-1c7d-4b62-b193-2e745f9dbb9c	weeks=4	expiring
\.


--
-- Data for Name: authentik_stages_consent_userconsent; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_consent_userconsent (id, expires, expiring, application_id, user_id, permissions) FROM stdin;
\.


--
-- Data for Name: authentik_stages_deny_denystage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_deny_denystage (stage_ptr_id, deny_message) FROM stdin;
\.


--
-- Data for Name: authentik_stages_dummy_dummystage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_dummy_dummystage (stage_ptr_id, throw_error) FROM stdin;
\.


--
-- Data for Name: authentik_stages_email_emailstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_email_emailstage (stage_ptr_id, host, port, username, password, use_tls, use_ssl, timeout, from_address, token_expiry, subject, template, use_global_settings, activate_user_on_success) FROM stdin;
\.


--
-- Data for Name: authentik_stages_identification_identificationstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_identification_identificationstage (stage_ptr_id, user_fields, enrollment_flow_id, recovery_flow_id, case_insensitive_matching, show_matched_user, password_stage_id, show_source_labels, passwordless_flow_id) FROM stdin;
f4abcb7d-5f92-4890-8760-afb9effda665	{username,email}	\N	\N	t	t	95715d75-025b-4e5e-9d23-96826479906d	f	\N
44b8d668-3efe-4e44-aa7f-74849414f977	{email,username}	\N	\N	t	t	\N	f	\N
\.


--
-- Data for Name: authentik_stages_identification_identificationstage_sources; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_identification_identificationstage_sources (id, identificationstage_id, source_id) FROM stdin;
1	f4abcb7d-5f92-4890-8760-afb9effda665	0e32dc99-655c-42f4-aca4-f3f271e010fd
\.


--
-- Data for Name: authentik_stages_invitation_invitation; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_invitation_invitation (invite_uuid, expires, fixed_data, created_by_id, single_use, expiring, name, flow_id) FROM stdin;
\.


--
-- Data for Name: authentik_stages_invitation_invitationstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_invitation_invitationstage (stage_ptr_id, continue_flow_without_invitation) FROM stdin;
\.


--
-- Data for Name: authentik_stages_password_passwordstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_password_passwordstage (stage_ptr_id, backends, configure_flow_id, failed_attempts_before_cancel) FROM stdin;
95715d75-025b-4e5e-9d23-96826479906d	{authentik.core.auth.InbuiltBackend,authentik.core.auth.TokenBackend,authentik.sources.ldap.auth.LDAPBackend}	4b14409d-da92-4b6c-91e8-bad06d0966c2	5
02b4a829-f9ab-45d0-adcc-11e3c165f1c4	{authentik.core.auth.InbuiltBackend,authentik.sources.ldap.auth.LDAPBackend,authentik.core.auth.TokenBackend}	4b14409d-da92-4b6c-91e8-bad06d0966c2	5
\.


--
-- Data for Name: authentik_stages_prompt_prompt; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_prompt_prompt (prompt_uuid, field_key, label, type, required, placeholder, "order", sub_text, placeholder_expression, name, initial_value, initial_value_expression) FROM stdin;
53bf385b-f5b5-46b1-bae2-52fa7febccbd	username	Username	text	t	Username	200		f	default-user-settings-field-username	try:\n    return user.username\nexcept:\n    return ''	t
67a03d10-9859-4252-a92b-6a95210cedf5	name	Name	text	t	Name	201		f	default-user-settings-field-name	try:\n    return user.name\nexcept:\n    return ''	t
e28c6f05-63c5-490e-9270-6d3eaef00007	email	Email	email	t	Email	202		f	default-user-settings-field-email	try:\n    return user.email\nexcept:\n    return ''	t
d5c18367-0f00-480a-9678-c5142ed2c11f	attributes.settings.locale	Locale	ak-locale	t	Locale	203		f	default-user-settings-field-locale	try:\n    return user.attributes.get("settings", {}).get("locale", "")\nexcept:\n    return ''	t
5d802ff7-2a30-453f-a624-95f0fbc7bb5b	password	Password	password	t	Password	300		f	default-password-change-field-password		f
456af4e0-d665-4cfd-9d26-95b003aa7b0c	password_repeat	Password (repeat)	password	t	Password (repeat)	301		f	default-password-change-field-password-repeat		f
9342773a-b3f5-4f5a-9b76-91fff8fbbc21	username	Username	text	t	Username	100		f	default-source-enrollment-field-username		f
84314c23-a6e1-42a1-80f4-064e029ca290	oobe-header-text	oobe-header-text	static	t	Welcome to authentik! Please set a password for the default admin user, akadmin.	100		f	initial-setup-field-header		f
9f75ae41-6a0b-496b-8b0d-316b024317ea	email	Email	email	t	Admin email	101		f	initial-setup-field-email		f
a59dd42c-bf08-4c14-9951-91dcc68cdd80	password	Password	password	t	Password	300		f	initial-setup-field-password		f
7fbf7e70-a561-42fe-8b17-12603c8971b0	password_repeat	Password (repeat)	password	t	Password (repeat)	301		f	initial-setup-field-password-repeat		f
\.


--
-- Data for Name: authentik_stages_prompt_promptstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_prompt_promptstage (stage_ptr_id) FROM stdin;
366481d2-b22d-4993-9502-d367fb8ae7f1
fa87ed01-29a6-457d-936d-4667077bba44
89176b0f-7a9c-41eb-8897-6c532db04b96
4b3bfdf2-31ed-4b1f-8de4-1752ef0ece92
\.


--
-- Data for Name: authentik_stages_prompt_promptstage_fields; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_prompt_promptstage_fields (id, promptstage_id, prompt_id) FROM stdin;
45	366481d2-b22d-4993-9502-d367fb8ae7f1	456af4e0-d665-4cfd-9d26-95b003aa7b0c
46	366481d2-b22d-4993-9502-d367fb8ae7f1	5d802ff7-2a30-453f-a624-95f0fbc7bb5b
51	fa87ed01-29a6-457d-936d-4667077bba44	d5c18367-0f00-480a-9678-c5142ed2c11f
52	fa87ed01-29a6-457d-936d-4667077bba44	e28c6f05-63c5-490e-9270-6d3eaef00007
53	fa87ed01-29a6-457d-936d-4667077bba44	67a03d10-9859-4252-a92b-6a95210cedf5
54	fa87ed01-29a6-457d-936d-4667077bba44	53bf385b-f5b5-46b1-bae2-52fa7febccbd
56	89176b0f-7a9c-41eb-8897-6c532db04b96	9342773a-b3f5-4f5a-9b76-91fff8fbbc21
65	4b3bfdf2-31ed-4b1f-8de4-1752ef0ece92	a59dd42c-bf08-4c14-9951-91dcc68cdd80
66	4b3bfdf2-31ed-4b1f-8de4-1752ef0ece92	7fbf7e70-a561-42fe-8b17-12603c8971b0
67	4b3bfdf2-31ed-4b1f-8de4-1752ef0ece92	84314c23-a6e1-42a1-80f4-064e029ca290
68	4b3bfdf2-31ed-4b1f-8de4-1752ef0ece92	9f75ae41-6a0b-496b-8b0d-316b024317ea
\.


--
-- Data for Name: authentik_stages_prompt_promptstage_validation_policies; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_prompt_promptstage_validation_policies (id, promptstage_id, policy_id) FROM stdin;
2	fa87ed01-29a6-457d-936d-4667077bba44	515a8421-2f61-40ad-ab94-c9997612788b
\.


--
-- Data for Name: authentik_stages_user_delete_userdeletestage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_user_delete_userdeletestage (stage_ptr_id) FROM stdin;
\.


--
-- Data for Name: authentik_stages_user_login_userloginstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_user_login_userloginstage (stage_ptr_id, session_duration, terminate_other_sessions, remember_me_offset) FROM stdin;
8a432e54-5bb4-4199-add9-53e198eca1dc	seconds=0	f	seconds=0
2e18f37d-528d-4c12-b9ea-d7dbf67b56a7	seconds=0	f	seconds=0
03fc4a51-f2e0-4844-b58b-b421ea235f34	seconds=0	f	seconds=0
58a4b17a-a21a-4c29-a3fd-6797bd7260cc	seconds=0	f	seconds=0
\.


--
-- Data for Name: authentik_stages_user_logout_userlogoutstage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_user_logout_userlogoutstage (stage_ptr_id) FROM stdin;
6fce99da-2643-4784-928c-94c1b2a3ab16
\.


--
-- Data for Name: authentik_stages_user_write_userwritestage; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_stages_user_write_userwritestage (stage_ptr_id, create_users_as_inactive, create_users_group_id, user_path_template, user_creation_mode, user_type) FROM stdin;
9934f0fc-b4b4-44e0-a90d-7587844ac68b	f	\N		never_create	external
dfc93c1c-c398-4e8f-aa34-fdc21b6accfb	f	\N		always_create	external
e87982c6-2f31-4dc5-bdce-2f680601c023	f	\N		never_create	external
\.


--
-- Data for Name: authentik_tenants_tenant; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.authentik_tenants_tenant (tenant_uuid, domain, "default", branding_title, branding_logo, flow_authentication_id, flow_invalidation_id, flow_recovery_id, flow_unenrollment_id, branding_favicon, event_retention, web_certificate_id, flow_user_settings_id, attributes, flow_device_code_id) FROM stdin;
1b45e4ae-6c1b-4ea8-9691-df11c97baeef	authentik-default	t	authentik	/static/dist/assets/icons/icon_left_brand.svg	c4257191-cb7a-4120-9566-a38ba8a50248	2287d235-72aa-4d23-80a2-44278d7c7839	\N	\N	/static/dist/assets/icons/icon.png	days=365	\N	1d2dd494-c62d-438a-8d0b-f864084f883c	{}	\N
\.


--
-- Data for Name: django_content_type; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.django_content_type (id, app_label, model) FROM stdin;
1	auth	permission
2	auth	group
3	contenttypes	contenttype
4	sessions	session
5	authentik_crypto	certificatekeypair
6	authentik_events	event
7	authentik_events	notificationtransport
8	authentik_events	notificationrule
9	authentik_events	notification
10	authentik_events	notificationwebhookmapping
11	authentik_flows	flow
12	authentik_flows	stage
13	authentik_flows	flowstagebinding
14	authentik_flows	flowtoken
15	authentik_outposts	outpost
16	authentik_outposts	outpostserviceconnection
17	authentik_outposts	dockerserviceconnection
18	authentik_outposts	kubernetesserviceconnection
19	authentik_policies_dummy	dummypolicy
20	authentik_policies_event_matcher	eventmatcherpolicy
21	authentik_policies_expiry	passwordexpirypolicy
22	authentik_policies_expression	expressionpolicy
23	authentik_policies_hibp	haveibeenpwendpolicy
24	authentik_policies_password	passwordpolicy
25	authentik_policies_reputation	reputationpolicy
26	authentik_policies_reputation	reputation
27	authentik_policies	policy
28	authentik_policies	policybinding
29	authentik_policies	policybindingmodel
30	authentik_providers_ldap	ldapprovider
31	authentik_providers_oauth2	oauth2provider
32	authentik_providers_oauth2	scopemapping
33	authentik_providers_oauth2	refreshtoken
34	authentik_providers_oauth2	authorizationcode
35	authentik_providers_oauth2	devicetoken
36	authentik_providers_proxy	proxyprovider
37	authentik_providers_saml	samlpropertymapping
38	authentik_providers_saml	samlprovider
39	authentik_sources_ldap	ldappropertymapping
40	authentik_sources_ldap	ldapsource
41	authentik_sources_oauth	oauthsource
42	authentik_sources_oauth	useroauthsourceconnection
43	authentik_sources_plex	plexsource
44	authentik_sources_plex	plexsourceconnection
45	authentik_sources_saml	samlsource
46	authentik_sources_saml	usersamlsourceconnection
47	authentik_stages_authenticator_duo	authenticatorduostage
48	authentik_stages_authenticator_duo	duodevice
49	authentik_stages_authenticator_sms	authenticatorsmsstage
50	authentik_stages_authenticator_sms	smsdevice
51	authentik_stages_authenticator_static	authenticatorstaticstage
52	authentik_stages_authenticator_totp	authenticatortotpstage
53	authentik_stages_authenticator_validate	authenticatorvalidatestage
54	authentik_stages_authenticator_webauthn	webauthndevice
55	authentik_stages_authenticator_webauthn	authenticatewebauthnstage
56	authentik_stages_captcha	captchastage
57	authentik_stages_consent	consentstage
58	authentik_stages_consent	userconsent
59	authentik_stages_deny	denystage
60	authentik_stages_dummy	dummystage
61	authentik_stages_email	emailstage
62	authentik_stages_identification	identificationstage
63	authentik_stages_invitation	invitationstage
64	authentik_stages_invitation	invitation
65	authentik_stages_password	passwordstage
66	authentik_stages_prompt	prompt
67	authentik_stages_prompt	promptstage
68	authentik_stages_user_delete	userdeletestage
69	authentik_stages_user_login	userloginstage
70	authentik_stages_user_logout	userlogoutstage
71	authentik_stages_user_write	userwritestage
72	authentik_tenants	tenant
73	authentik_blueprints	blueprintinstance
74	guardian	groupobjectpermission
75	guardian	userobjectpermission
76	otp_static	staticdevice
77	otp_static	statictoken
78	otp_totp	totpdevice
79	authentik_core	user
80	authentik_core	propertymapping
81	authentik_core	source
82	authentik_core	usersourceconnection
83	authentik_core	token
84	authentik_core	provider
85	authentik_core	group
86	authentik_core	application
87	authentik_core	authenticatedsession
88	authentik_providers_oauth2	accesstoken
89	authentik_providers_radius	radiusprovider
90	authentik_providers_scim	scimmapping
91	authentik_providers_scim	scimprovider
92	authentik_providers_scim	scimuser
93	authentik_providers_scim	scimgroup
94	authentik_enterprise	license
95	authentik_enterprise	licenseusage
96	authentik_rbac	role
97	authentik_rbac	systempermission
98	authentik_stages_authenticator_static	staticdevice
99	authentik_stages_authenticator_static	statictoken
100	authentik_stages_authenticator_totp	totpdevice
\.


--
-- Data for Name: django_migrations; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.django_migrations (id, app, name, applied) FROM stdin;
1	contenttypes	0001_initial	2022-10-25 09:00:53.004361+00
2	contenttypes	0002_remove_content_type_name	2022-10-25 09:00:53.011141+00
3	auth	0001_initial	2022-10-25 09:00:53.039937+00
4	auth	0002_alter_permission_name_max_length	2022-10-25 09:00:53.045188+00
5	auth	0003_alter_user_email_max_length	2022-10-25 09:00:53.050155+00
6	auth	0004_alter_user_username_opts	2022-10-25 09:00:53.055922+00
7	auth	0005_alter_user_last_login_null	2022-10-25 09:00:53.061366+00
8	auth	0006_require_contenttypes_0002	2022-10-25 09:00:53.063851+00
9	auth	0007_alter_validators_add_error_messages	2022-10-25 09:00:53.068775+00
10	auth	0008_alter_user_username_max_length	2022-10-25 09:00:53.074519+00
11	auth	0009_alter_user_last_name_max_length	2022-10-25 09:00:53.080142+00
12	auth	0010_alter_group_name_max_length	2022-10-25 09:00:53.150659+00
13	auth	0011_update_proxy_permissions	2022-10-25 09:00:53.156437+00
14	auth	0012_alter_user_first_name_max_length	2022-10-25 09:00:53.162027+00
15	authentik_policies	0001_initial	2022-10-25 09:00:53.183466+00
16	authentik_policies	0002_auto_20200528_1647	2022-10-25 09:00:53.208398+00
17	authentik_flows	0001_initial	2022-10-25 09:00:53.25836+00
18	authentik_flows	0003_auto_20200523_1133	2022-10-25 09:00:53.26056+00
19	authentik_flows	0006_auto_20200629_0857	2022-10-25 09:00:53.262671+00
20	authentik_flows	0007_auto_20200703_2059	2022-10-25 09:00:53.264663+00
21	authentik_blueprints	0001_initial	2022-10-25 09:00:53.451773+00
22	authentik_crypto	0001_initial	2022-10-25 09:00:53.459573+00
23	authentik_core	0001_initial	2022-10-25 09:00:53.596239+00
24	authentik_providers_saml	0001_initial	2022-10-25 09:00:53.633481+00
25	authentik_providers_saml	0002_default_saml_property_mappings	2022-10-25 09:00:53.636063+00
26	authentik_providers_saml	0003_samlprovider_sp_binding	2022-10-25 09:00:53.638356+00
27	authentik_providers_saml	0004_auto_20200620_1950	2022-10-25 09:00:53.640997+00
28	authentik_providers_saml	0005_remove_samlprovider_processor_path	2022-10-25 09:00:53.643461+00
29	authentik_core	0002_auto_20200523_1133	2022-10-25 09:00:53.881558+00
30	authentik_core	0003_default_user	2022-10-25 09:00:53.883883+00
31	authentik_core	0004_auto_20200703_2213	2022-10-25 09:00:53.886158+00
32	authentik_core	0005_token_intent	2022-10-25 09:00:53.888466+00
33	authentik_core	0006_auto_20200709_1608	2022-10-25 09:00:53.890825+00
34	authentik_core	0007_auto_20200815_1841	2022-10-25 09:00:53.893084+00
35	authentik_core	0008_auto_20200824_1532	2022-10-25 09:00:53.895348+00
36	authentik_core	0009_group_is_superuser	2022-10-25 09:00:53.897568+00
37	authentik_core	0010_auto_20200917_1021	2022-10-25 09:00:53.89973+00
38	authentik_core	0011_provider_name_temp	2022-10-25 09:00:53.902158+00
39	authentik_providers_saml	0006_remove_samlprovider_name	2022-10-25 09:00:53.919669+00
40	authentik_crypto	0002_create_self_signed_kp	2022-10-25 09:00:53.922223+00
41	authentik_providers_oauth2	0001_initial	2022-10-25 09:00:54.001725+00
42	authentik_providers_oauth2	0002_oauth2provider_sub_mode	2022-10-25 09:00:54.010025+00
43	authentik_providers_oauth2	0003_auto_20200916_2129	2022-10-25 09:00:54.025765+00
44	authentik_providers_oauth2	0004_remove_oauth2provider_post_logout_redirect_uris	2022-10-25 09:00:54.033397+00
45	authentik_providers_oauth2	0005_auto_20200920_1240	2022-10-25 09:00:54.040715+00
46	authentik_providers_oauth2	0006_remove_oauth2provider_name	2022-10-25 09:00:54.063142+00
47	authentik_core	0012_auto_20201003_1737	2022-10-25 09:00:54.288328+00
48	authentik_core	0013_auto_20201003_2132	2022-10-25 09:00:54.289573+00
49	authentik_core	0014_auto_20201018_1158	2022-10-25 09:00:54.290541+00
50	authentik_core	0015_application_icon	2022-10-25 09:00:54.291627+00
51	authentik_core	0016_auto_20201202_2234	2022-10-25 09:00:54.292573+00
52	authentik_core	0017_managed	2022-10-25 09:00:54.312308+00
53	authentik_core	0018_auto_20210330_1345	2022-10-25 09:00:54.446374+00
54	authentik_core	0019_source_managed	2022-10-25 09:00:54.449129+00
55	authentik_core	0020_source_user_matching_mode	2022-10-25 09:00:54.451252+00
56	authentik_core	0021_alter_application_slug	2022-10-25 09:00:54.453224+00
57	authentik_core	0022_authenticatedsession	2022-10-25 09:00:54.455399+00
58	authentik_core	0023_alter_application_meta_launch_url	2022-10-25 09:00:54.457684+00
59	authentik_core	0024_alter_token_identifier	2022-10-25 09:00:54.460391+00
60	authentik_core	0025_alter_application_meta_icon	2022-10-25 09:00:54.46263+00
61	authentik_core	0026_alter_application_meta_icon	2022-10-25 09:00:54.465103+00
62	authentik_core	0027_bootstrap_token	2022-10-25 09:00:54.467486+00
63	authentik_core	0028_alter_token_intent	2022-10-25 09:00:54.469916+00
64	authentik_core	0019_application_group	2022-10-25 09:00:54.482854+00
65	authentik_core	0020_application_open_in_new_tab	2022-10-25 09:00:54.493472+00
66	authentik_core	0021_source_user_path_user_path	2022-10-25 09:00:54.512365+00
67	authentik_core	0022_alter_group_parent	2022-10-25 09:00:54.531277+00
68	authentik_core	0023_source_authentik_c_slug_ccb2e5_idx_and_more	2022-10-25 09:00:54.554638+00
69	authentik_crypto	0003_certificatekeypair_managed	2022-10-25 09:00:54.564707+00
70	authentik_policies	0003_auto_20200908_1542	2022-10-25 09:00:54.584001+00
71	authentik_policies	0004_policy_execution_logging	2022-10-25 09:00:54.590172+00
72	authentik_policies_event_matcher	0001_initial	2022-10-25 09:00:54.614206+00
73	authentik_policies_event_matcher	0002_auto_20201230_2046	2022-10-25 09:00:54.616583+00
74	authentik_policies_event_matcher	0003_auto_20210110_1907	2022-10-25 09:00:54.618681+00
75	authentik_policies_event_matcher	0004_auto_20210112_2158	2022-10-25 09:00:54.620597+00
76	authentik_policies_event_matcher	0005_auto_20210202_1821	2022-10-25 09:00:54.622661+00
77	authentik_policies_event_matcher	0006_auto_20210203_1134	2022-10-25 09:00:54.624603+00
78	authentik_policies_event_matcher	0007_auto_20210209_1657	2022-10-25 09:00:54.627035+00
79	authentik_policies_event_matcher	0008_auto_20210213_1640	2022-10-25 09:00:54.629755+00
80	authentik_policies_event_matcher	0009_auto_20210215_2159	2022-10-25 09:00:54.632287+00
81	authentik_policies_event_matcher	0010_auto_20210222_1821	2022-10-25 09:00:54.635133+00
82	authentik_policies_event_matcher	0011_auto_20210302_0856	2022-10-25 09:00:54.637955+00
83	authentik_policies_event_matcher	0012_auto_20210323_1339	2022-10-25 09:00:54.640962+00
84	authentik_policies_event_matcher	0013_alter_eventmatcherpolicy_app	2022-10-25 09:00:54.64337+00
85	authentik_policies_event_matcher	0014_alter_eventmatcherpolicy_app	2022-10-25 09:00:54.646228+00
86	authentik_policies_event_matcher	0015_alter_eventmatcherpolicy_app	2022-10-25 09:00:54.648636+00
87	authentik_policies_event_matcher	0016_alter_eventmatcherpolicy_action	2022-10-25 09:00:54.650961+00
88	authentik_policies_event_matcher	0017_alter_eventmatcherpolicy_action	2022-10-25 09:00:54.653416+00
89	authentik_policies_event_matcher	0018_alter_eventmatcherpolicy_action	2022-10-25 09:00:54.655941+00
90	authentik_events	0001_initial	2022-10-25 09:00:54.97068+00
91	authentik_events	0002_auto_20200918_2116	2022-10-25 09:00:54.973158+00
92	authentik_events	0003_auto_20200917_1155	2022-10-25 09:00:54.975235+00
93	authentik_events	0004_auto_20200921_1829	2022-10-25 09:00:54.97756+00
94	authentik_events	0005_auto_20201005_2139	2022-10-25 09:00:54.979552+00
95	authentik_events	0006_auto_20201017_2024	2022-10-25 09:00:54.981605+00
96	authentik_events	0007_auto_20201215_0939	2022-10-25 09:00:54.983858+00
97	authentik_events	0008_auto_20201220_1651	2022-10-25 09:00:54.986694+00
98	authentik_events	0009_auto_20201227_1210	2022-10-25 09:00:54.989304+00
99	authentik_events	0010_notification_notificationtransport_notificationrule	2022-10-25 09:00:54.992556+00
100	authentik_events	0011_notification_rules_default_v1	2022-10-25 09:00:54.995714+00
101	authentik_events	0012_auto_20210202_1821	2022-10-25 09:00:54.998152+00
102	authentik_events	0013_auto_20210209_1657	2022-10-25 09:00:55.000731+00
103	authentik_events	0014_expiry	2022-10-25 09:00:55.00302+00
104	authentik_events	0015_alter_event_action	2022-10-25 09:00:55.005995+00
105	authentik_events	0016_add_tenant	2022-10-25 09:00:55.008666+00
106	authentik_events	0017_alter_event_action	2022-10-25 09:00:55.011119+00
107	authentik_events	0018_auto_20210911_2217	2022-10-25 09:00:55.013624+00
108	authentik_events	0019_alter_notificationtransport_webhook_url	2022-10-25 09:00:55.016161+00
109	authentik_events	0002_alter_notificationtransport_mode	2022-10-25 09:00:55.039362+00
110	authentik_flows	0008_default_flows	2022-10-25 09:00:55.042866+00
111	authentik_flows	0009_source_flows	2022-10-25 09:00:55.046054+00
112	authentik_flows	0010_provider_flows	2022-10-25 09:00:55.048464+00
113	authentik_flows	0011_flow_title	2022-10-25 09:00:55.068757+00
114	authentik_flows	0012_auto_20200908_1542	2022-10-25 09:00:55.208878+00
115	authentik_flows	0013_auto_20200924_1605	2022-10-25 09:00:55.210605+00
116	authentik_flows	0014_auto_20200925_2332	2022-10-25 09:00:55.212354+00
117	authentik_flows	0015_flowstagebinding_evaluate_on_plan	2022-10-25 09:00:55.213468+00
118	authentik_flows	0016_auto_20201202_1307	2022-10-25 09:00:55.214461+00
119	authentik_flows	0017_auto_20210329_1334	2022-10-25 09:00:55.215382+00
120	authentik_flows	0018_oob_flows	2022-10-25 09:00:55.225834+00
121	authentik_flows	0019_alter_flow_background	2022-10-25 09:00:55.262621+00
122	authentik_flows	0020_flow_compatibility_mode	2022-10-25 09:00:55.264231+00
123	authentik_flows	0021_flowstagebinding_invalid_response_action	2022-10-25 09:00:55.265725+00
124	authentik_flows	0022_alter_flowstagebinding_invalid_response_action	2022-10-25 09:00:55.26704+00
125	authentik_flows	0023_alter_flow_background	2022-10-25 09:00:55.268488+00
126	authentik_flows	0024_alter_flow_compatibility_mode	2022-10-25 09:00:55.269661+00
127	authentik_flows	0020_flowtoken	2022-10-25 09:00:55.296357+00
128	authentik_flows	0021_auto_20211227_2103	2022-10-25 09:00:55.299268+00
129	authentik_flows	0022_flow_layout	2022-10-25 09:00:55.310165+00
130	authentik_flows	0023_flow_denied_action	2022-10-25 09:00:55.320177+00
131	authentik_outposts	0001_initial	2022-10-25 09:00:55.644586+00
132	authentik_outposts	0002_auto_20200826_1306	2022-10-25 09:00:55.646818+00
133	authentik_outposts	0003_auto_20200827_2108	2022-10-25 09:00:55.648999+00
134	authentik_outposts	0004_auto_20200830_1056	2022-10-25 09:00:55.650981+00
135	authentik_outposts	0005_auto_20200909_1733	2022-10-25 09:00:55.653282+00
136	authentik_outposts	0006_auto_20201003_2239	2022-10-25 09:00:55.65547+00
137	authentik_outposts	0007_remove_outpost_channels	2022-10-25 09:00:55.6576+00
138	authentik_outposts	0008_auto_20201014_1547	2022-10-25 09:00:55.659481+00
139	authentik_outposts	0009_fix_missing_token_identifier	2022-10-25 09:00:55.661917+00
140	authentik_outposts	0010_service_connection	2022-10-25 09:00:55.664244+00
141	authentik_outposts	0011_docker_tls_auth	2022-10-25 09:00:55.666451+00
142	authentik_outposts	0012_service_connection_non_unique	2022-10-25 09:00:55.668641+00
143	authentik_outposts	0013_auto_20201203_2009	2022-10-25 09:00:55.67176+00
144	authentik_outposts	0014_auto_20201213_1407	2022-10-25 09:00:55.67579+00
145	authentik_outposts	0015_auto_20201224_1206	2022-10-25 09:00:55.679913+00
146	authentik_outposts	0016_alter_outpost_type	2022-10-25 09:00:55.684029+00
147	authentik_outposts	0017_outpost_managed	2022-10-25 09:00:55.687651+00
148	authentik_policies	0005_binding_group	2022-10-25 09:00:55.770659+00
149	authentik_policies	0006_auto_20210329_1334	2022-10-25 09:00:55.776026+00
150	authentik_policies	0007_policybindingmodel_policy_engine_mode	2022-10-25 09:00:55.791969+00
151	authentik_policies	0008_policybinding_authentik_p_policy__534e15_idx_and_more	2022-10-25 09:00:55.840797+00
152	authentik_policies_dummy	0001_initial	2022-10-25 09:00:55.864364+00
153	authentik_policies_dummy	0002_dummypolicy_authentik_p_policy__648f9b_idx	2022-10-25 09:00:55.871392+00
154	authentik_policies_event_matcher	0019_alter_eventmatcherpolicy_app	2022-10-25 09:00:55.877474+00
155	authentik_policies_event_matcher	0020_eventmatcherpolicy_authentik_p_policy__e605cf_idx	2022-10-25 09:00:55.884393+00
156	authentik_policies_expiry	0001_initial	2022-10-25 09:00:55.907192+00
157	authentik_policies_expiry	0002_passwordexpirypolicy_authentik_p_policy__cf73a7_idx	2022-10-25 09:00:55.914895+00
158	authentik_policies_expression	0001_initial	2022-10-25 09:00:55.939362+00
159	authentik_policies_expression	0002_auto_20200926_1156	2022-10-25 09:00:55.959666+00
160	authentik_policies_expression	0003_auto_20201203_1223	2022-10-25 09:00:55.979077+00
161	authentik_policies_expression	0004_expressionpolicy_authentik_p_policy__fb6feb_idx	2022-10-25 09:00:55.987705+00
165	authentik_policies_password	0001_initial	2022-10-25 09:00:56.060365+00
166	authentik_policies_password	0002_passwordpolicy_password_field	2022-10-25 09:00:56.068603+00
167	authentik_policies_password	0003_passwordpolicy_amount_digits	2022-10-25 09:00:56.183019+00
168	authentik_policies_password	0004_passwordpolicy_authentik_p_policy__855e80_idx	2022-10-25 09:00:56.192144+00
169	authentik_policies_reputation	0001_initial	2022-10-25 09:00:56.246608+00
170	authentik_policies_reputation	0002_auto_20210529_2046	2022-10-25 09:00:56.301643+00
171	authentik_policies_reputation	0003_reputation_delete_ipreputation_delete_userreputation	2022-10-25 09:00:56.316415+00
172	authentik_policies_reputation	0004_reputationpolicy_authentik_p_policy__8f0d70_idx	2022-10-25 09:00:56.325772+00
173	authentik_providers_ldap	0001_initial	2022-10-25 09:00:56.357267+00
174	authentik_providers_ldap	0002_ldapprovider_search_group	2022-10-25 09:00:56.359967+00
175	authentik_providers_ldap	0003_auto_20210713_1138	2022-10-25 09:00:56.362377+00
176	authentik_providers_ldap	0004_auto_20210713_2115	2022-10-25 09:00:56.364803+00
177	authentik_providers_ldap	0005_ldapprovider_search_mode	2022-10-25 09:00:56.367373+00
178	authentik_providers_ldap	0002_ldapprovider_bind_mode	2022-10-25 09:00:56.380187+00
179	authentik_sources_oauth	0001_initial	2022-10-25 09:00:56.439445+00
180	authentik_sources_oauth	0002_auto_20200520_1108	2022-10-25 09:00:56.471567+00
181	authentik_sources_oauth	0003_auto_20210416_0726	2022-10-25 09:00:56.493876+00
182	authentik_sources_oauth	0004_auto_20210417_1900	2022-10-25 09:00:56.543415+00
183	authentik_sources_oauth	0005_update_provider_type_names	2022-10-25 09:00:56.56686+00
184	authentik_sources_oauth	0006_oauthsource_additional_scopes	2022-10-25 09:00:56.576973+00
185	authentik_sources_oauth	0007_oauthsource_oidc_jwks_oauthsource_oidc_jwks_url_and_more	2022-10-25 09:00:56.612103+00
186	authentik_providers_oauth2	0007_auto_20201016_1107	2022-10-25 09:00:56.842579+00
187	authentik_providers_oauth2	0008_oauth2provider_issuer_mode	2022-10-25 09:00:56.844637+00
188	authentik_providers_oauth2	0009_remove_oauth2provider_response_type	2022-10-25 09:00:56.846187+00
189	authentik_providers_oauth2	0010_auto_20201227_1804	2022-10-25 09:00:56.847829+00
190	authentik_providers_oauth2	0011_managed	2022-10-25 09:00:56.849262+00
191	authentik_providers_oauth2	0012_oauth2provider_access_code_validity	2022-10-25 09:00:56.850808+00
192	authentik_providers_oauth2	0013_alter_authorizationcode_nonce	2022-10-25 09:00:56.852313+00
193	authentik_providers_oauth2	0014_alter_oauth2provider_rsa_key	2022-10-25 09:00:56.854256+00
194	authentik_providers_oauth2	0015_auto_20210703_1313	2022-10-25 09:00:56.855914+00
195	authentik_providers_oauth2	0016_alter_authorizationcode_nonce	2022-10-25 09:00:56.857672+00
196	authentik_providers_oauth2	0017_alter_oauth2provider_token_validity	2022-10-25 09:00:56.858961+00
197	authentik_providers_oauth2	0008_rename_rsa_key_oauth2provider_signing_key_and_more	2022-10-25 09:00:56.889055+00
198	authentik_providers_oauth2	0009_oauth2provider_verification_keys_and_more	2022-10-25 09:00:56.947061+00
199	authentik_providers_oauth2	0010_alter_oauth2provider_verification_keys	2022-10-25 09:00:56.973591+00
200	authentik_providers_oauth2	0011_oauth2provider_jwks_sources_and_more	2022-10-25 09:00:57.044011+00
201	authentik_providers_oauth2	0012_remove_oauth2provider_verification_keys	2022-10-25 09:00:57.084275+00
202	authentik_providers_oauth2	0013_devicetoken	2022-10-25 09:00:57.120367+00
203	authentik_providers_proxy	0001_initial	2022-10-25 09:00:57.209634+00
204	authentik_providers_proxy	0002_proxyprovider_cookie_secret	2022-10-25 09:00:57.21255+00
205	authentik_providers_proxy	0003_proxyprovider_certificate	2022-10-25 09:00:57.214859+00
206	authentik_providers_proxy	0004_auto_20200913_1947	2022-10-25 09:00:57.217332+00
207	authentik_providers_proxy	0005_auto_20200914_1536	2022-10-25 09:00:57.220279+00
208	authentik_providers_proxy	0006_proxyprovider_skip_path_regex	2022-10-25 09:00:57.222713+00
209	authentik_providers_proxy	0007_auto_20200923_1017	2022-10-25 09:00:57.225271+00
210	authentik_providers_proxy	0008_auto_20200930_0810	2022-10-25 09:00:57.227782+00
211	authentik_providers_proxy	0009_auto_20201007_1721	2022-10-25 09:00:57.230567+00
212	authentik_providers_proxy	0010_auto_20201214_0942	2022-10-25 09:00:57.233315+00
213	authentik_providers_proxy	0011_proxyprovider_forward_auth_mode	2022-10-25 09:00:57.235866+00
214	authentik_providers_proxy	0012_proxyprovider_cookie_domain	2022-10-25 09:00:57.238718+00
215	authentik_providers_proxy	0013_mode	2022-10-25 09:00:57.241532+00
216	authentik_providers_proxy	0014_proxy_v2	2022-10-25 09:00:57.24434+00
217	authentik_providers_saml	0007_samlprovider_verification_kp	2022-10-25 09:00:57.366727+00
218	authentik_providers_saml	0008_auto_20201112_1036	2022-10-25 09:00:57.441022+00
219	authentik_providers_saml	0009_auto_20201112_2016	2022-10-25 09:00:57.462457+00
220	authentik_providers_saml	0010_auto_20201230_2112	2022-10-25 09:00:57.47394+00
221	authentik_providers_saml	0011_samlprovider_name_id_mapping	2022-10-25 09:00:57.506734+00
222	authentik_providers_saml	0012_managed	2022-10-25 09:00:57.535201+00
223	authentik_sources_ldap	0001_initial	2022-10-25 09:00:57.828221+00
224	authentik_sources_ldap	0002_ldapsource_sync_users	2022-10-25 09:00:57.830808+00
225	authentik_sources_ldap	0003_default_ldap_property_mappings	2022-10-25 09:00:57.833076+00
226	authentik_sources_ldap	0004_auto_20200524_1146	2022-10-25 09:00:57.835411+00
227	authentik_sources_ldap	0005_auto_20200913_1947	2022-10-25 09:00:57.837812+00
228	authentik_sources_ldap	0006_auto_20200915_1919	2022-10-25 09:00:57.840602+00
229	authentik_sources_ldap	0007_ldapsource_sync_users_password	2022-10-25 09:00:57.843256+00
230	authentik_sources_ldap	0008_managed	2022-10-25 09:00:57.846187+00
231	authentik_sources_ldap	0009_auto_20210204_1834	2022-10-25 09:00:57.849207+00
232	authentik_sources_ldap	0010_auto_20210205_1027	2022-10-25 09:00:57.851535+00
233	authentik_sources_ldap	0011_ldapsource_property_mappings_group	2022-10-25 09:00:57.853646+00
234	authentik_sources_ldap	0012_auto_20210812_1703	2022-10-25 09:00:57.855681+00
235	authentik_sources_ldap	0002_auto_20211203_0900	2022-10-25 09:00:57.903185+00
236	authentik_sources_plex	0001_initial	2022-10-25 09:00:57.964324+00
237	authentik_sources_plex	0002_auto_20210505_1717	2022-10-25 09:00:57.995+00
238	authentik_sources_plex	0003_alter_plexsource_plex_token	2022-10-25 09:00:58.010372+00
239	authentik_sources_saml	0001_initial	2022-10-25 09:00:58.084429+00
240	authentik_sources_saml	0002_auto_20200523_2329	2022-10-25 09:00:58.086928+00
241	authentik_sources_saml	0003_auto_20200624_1957	2022-10-25 09:00:58.089279+00
242	authentik_sources_saml	0004_auto_20200708_1207	2022-10-25 09:00:58.091908+00
243	authentik_sources_saml	0005_samlsource_name_id_policy	2022-10-25 09:00:58.094624+00
244	authentik_sources_saml	0006_samlsource_allow_idp_initiated	2022-10-25 09:00:58.097134+00
245	authentik_sources_saml	0007_auto_20201112_1055	2022-10-25 09:00:58.099625+00
246	authentik_sources_saml	0008_auto_20201112_2016	2022-10-25 09:00:58.102613+00
247	authentik_sources_saml	0009_auto_20210301_0949	2022-10-25 09:00:58.105437+00
248	authentik_sources_saml	0010_samlsource_pre_authentication_flow	2022-10-25 09:00:58.141069+00
249	authentik_sources_saml	0011_auto_20210324_0736	2022-10-25 09:00:58.183097+00
250	authentik_sources_saml	0012_usersamlsourceconnection	2022-10-25 09:00:58.231251+00
251	authentik_stages_authenticator_duo	0001_initial	2022-10-25 09:00:58.409979+00
252	authentik_stages_authenticator_duo	0002_default_setup_flow	2022-10-25 09:00:58.412485+00
253	authentik_stages_authenticator_duo	0003_duodevice_last_t	2022-10-25 09:00:58.429098+00
254	authentik_stages_authenticator_duo	0004_authenticatorduostage_admin_integration_key_and_more	2022-10-25 09:00:58.450977+00
255	authentik_stages_authenticator_sms	0001_initial	2022-10-25 09:00:58.530374+00
256	authentik_stages_authenticator_sms	0002_authenticatorsmsstage_from_number	2022-10-25 09:00:58.532603+00
257	authentik_stages_authenticator_sms	0003_auto_20211014_0813	2022-10-25 09:00:58.534653+00
258	authentik_stages_authenticator_sms	0004_auto_20211014_0936	2022-10-25 09:00:58.536695+00
259	authentik_stages_authenticator_sms	0002_alter_authenticatorsmsstage_from_number	2022-10-25 09:00:58.549475+00
260	authentik_stages_authenticator_sms	0003_smsdevice_last_used_on	2022-10-25 09:00:58.566095+00
261	authentik_stages_authenticator_sms	0004_authenticatorsmsstage_verify_only_and_more	2022-10-25 09:00:58.594603+00
262	authentik_stages_authenticator_sms	0005_authenticatorsmsstage_mapping	2022-10-25 09:00:58.63091+00
263	authentik_stages_authenticator_static	0001_initial	2022-10-25 09:00:58.666411+00
264	authentik_stages_authenticator_static	0002_otpstaticstage_configure_flow	2022-10-25 09:00:58.703193+00
265	authentik_stages_authenticator_static	0003_default_setup_flow	2022-10-25 09:00:58.706678+00
266	authentik_stages_authenticator_static	0004_auto_20210216_0838	2022-10-25 09:00:58.759744+00
267	authentik_stages_authenticator_static	0005_default_setup_flow	2022-10-25 09:00:58.763019+00
268	authentik_stages_authenticator_totp	0001_initial	2022-10-25 09:00:58.903253+00
269	authentik_stages_authenticator_totp	0002_auto_20200701_1900	2022-10-25 09:00:58.912366+00
270	authentik_stages_authenticator_totp	0003_otptimestage_configure_flow	2022-10-25 09:00:58.949465+00
271	authentik_stages_authenticator_totp	0004_default_setup_flow	2022-10-25 09:00:58.952124+00
272	authentik_stages_authenticator_totp	0005_auto_20210216_0838	2022-10-25 09:00:59.028018+00
273	authentik_stages_authenticator_totp	0006_default_setup_flow	2022-10-25 09:00:59.031603+00
274	authentik_stages_authenticator_validate	0001_initial	2022-10-25 09:00:59.072324+00
275	authentik_stages_authenticator_validate	0002_auto_20210216_0838	2022-10-25 09:00:59.121784+00
276	authentik_stages_authenticator_validate	0003_authenticatorvalidatestage_device_classes	2022-10-25 09:00:59.132117+00
277	authentik_stages_authenticator_validate	0004_auto_20210301_0949	2022-10-25 09:00:59.146093+00
278	authentik_stages_authenticator_validate	0005_authenticatorvalidatestage_configuration_stage	2022-10-25 09:00:59.196884+00
279	authentik_stages_authenticator_validate	0006_auto_20210301_1757	2022-10-25 09:00:59.208275+00
280	authentik_stages_authenticator_validate	0007_auto_20210403_0927	2022-10-25 09:00:59.218225+00
281	authentik_stages_authenticator_validate	0008_alter_authenticatorvalidatestage_device_classes	2022-10-25 09:00:59.231778+00
282	authentik_stages_authenticator_validate	0009_default_stage	2022-10-25 09:00:59.235375+00
283	authentik_stages_authenticator_validate	0010_remove_authenticatorvalidatestage_configuration_stage_and_more	2022-10-25 09:00:59.383133+00
284	authentik_stages_authenticator_validate	0011_authenticatorvalidatestage_last_auth_threshold	2022-10-25 09:00:59.396153+00
285	authentik_stages_authenticator_webauthn	0001_initial	2022-10-25 09:00:59.576788+00
286	authentik_stages_authenticator_webauthn	0002_default_setup_flow	2022-10-25 09:00:59.57975+00
287	authentik_stages_authenticator_webauthn	0003_webauthndevice_confirmed	2022-10-25 09:00:59.598375+00
288	authentik_stages_authenticator_webauthn	0004_auto_20210304_1850	2022-10-25 09:00:59.614633+00
289	authentik_stages_authenticator_webauthn	0005_authenticatewebauthnstage_user_verification	2022-10-25 09:00:59.631411+00
290	authentik_stages_authenticator_webauthn	0006_authenticatewebauthnstage_authenticator_attachment_and_more	2022-10-25 09:00:59.663075+00
291	authentik_stages_authenticator_webauthn	0007_rename_last_used_on_webauthndevice_last_t	2022-10-25 09:00:59.682417+00
292	authentik_stages_captcha	0001_initial	2022-10-25 09:00:59.722267+00
293	authentik_stages_consent	0001_initial	2022-10-25 09:00:59.762493+00
294	authentik_stages_consent	0002_auto_20200720_0941	2022-10-25 09:00:59.824505+00
295	authentik_stages_consent	0003_auto_20200924_1403	2022-10-25 09:00:59.863279+00
296	authentik_stages_consent	0004_alter_userconsent_unique_together_and_more	2022-10-25 09:00:59.919207+00
297	authentik_stages_consent	0005_alter_consentstage_mode	2022-10-25 09:00:59.933301+00
298	authentik_stages_deny	0001_initial	2022-10-25 09:00:59.974238+00
299	authentik_stages_dummy	0001_initial	2022-10-25 09:01:00.017662+00
300	authentik_stages_email	0001_initial	2022-10-25 09:01:00.164973+00
301	authentik_stages_email	0002_emailstage_use_global_settings	2022-10-25 09:01:00.210751+00
302	authentik_stages_email	0003_auto_20210404_1054	2022-10-25 09:01:00.223477+00
303	authentik_stages_email	0004_emailstage_activate_user_on_success	2022-10-25 09:01:00.235245+00
304	authentik_stages_password	0001_initial	2022-10-25 09:01:00.279017+00
305	authentik_stages_password	0002_passwordstage_change_flow	2022-10-25 09:01:00.319489+00
306	authentik_stages_password	0003_passwordstage_failed_attempts_before_cancel	2022-10-25 09:01:00.337661+00
307	authentik_stages_password	0004_auto_20200925_1057	2022-10-25 09:01:00.392868+00
308	authentik_stages_password	0005_auto_20210402_2221	2022-10-25 09:01:00.411502+00
309	authentik_stages_identification	0001_initial	2022-10-25 09:01:00.455358+00
310	authentik_stages_identification	0002_auto_20200530_2204	2022-10-25 09:01:00.880249+00
311	authentik_stages_identification	0003_auto_20200615_1641	2022-10-25 09:01:00.883826+00
312	authentik_stages_identification	0004_identificationstage_case_insensitive_matching	2022-10-25 09:01:00.887809+00
313	authentik_stages_identification	0005_auto_20201003_1734	2022-10-25 09:01:00.891336+00
314	authentik_stages_identification	0006_identificationstage_show_matched_user	2022-10-25 09:01:00.894787+00
315	authentik_stages_identification	0007_remove_identificationstage_template	2022-10-25 09:01:00.898528+00
316	authentik_stages_identification	0008_alter_identificationstage_user_fields	2022-10-25 09:01:00.901907+00
317	authentik_stages_identification	0009_identificationstage_sources	2022-10-25 09:01:00.905901+00
318	authentik_stages_identification	0010_identificationstage_password_stage	2022-10-25 09:01:00.909637+00
319	authentik_stages_identification	0011_alter_identificationstage_user_fields	2022-10-25 09:01:00.912791+00
320	authentik_stages_identification	0012_identificationstage_show_source_labels	2022-10-25 09:01:00.916038+00
321	authentik_stages_identification	0013_identificationstage_passwordless_flow	2022-10-25 09:01:00.919413+00
322	authentik_stages_invitation	0001_initial	2022-10-25 09:01:01.228667+00
323	authentik_stages_invitation	0002_auto_20201225_2143	2022-10-25 09:01:01.231194+00
324	authentik_stages_invitation	0003_auto_20201227_1210	2022-10-25 09:01:01.233477+00
325	authentik_stages_invitation	0004_invitation_single_use	2022-10-25 09:01:01.235471+00
326	authentik_stages_invitation	0005_auto_20210901_1211	2022-10-25 09:01:01.237906+00
327	authentik_stages_invitation	0006_invitation_name	2022-10-25 09:01:01.240564+00
328	authentik_stages_password	0006_passwordchange_rename	2022-10-25 09:01:01.243634+00
329	authentik_stages_password	0007_app_password	2022-10-25 09:01:01.30002+00
330	authentik_stages_password	0008_replace_inbuilt	2022-10-25 09:01:01.355342+00
331	authentik_stages_prompt	0001_initial	2022-10-25 09:01:01.438968+00
332	authentik_stages_prompt	0002_auto_20200920_1859	2022-10-25 09:01:01.486844+00
333	authentik_stages_prompt	0003_auto_20210222_1821	2022-10-25 09:01:01.536114+00
334	authentik_stages_prompt	0004_prompt_sub_text	2022-10-25 09:01:01.546002+00
335	authentik_stages_prompt	0005_alter_prompt_field_key	2022-10-25 09:01:01.592582+00
336	authentik_stages_prompt	0006_alter_prompt_type	2022-10-25 09:01:01.633406+00
337	authentik_stages_prompt	0007_prompt_placeholder_expression	2022-10-25 09:01:01.779084+00
338	authentik_stages_prompt	0008_alter_prompt_type	2022-10-25 09:01:01.818567+00
339	authentik_stages_user_delete	0001_initial	2022-10-25 09:01:01.861347+00
340	authentik_stages_user_login	0001_initial	2022-10-25 09:01:01.906516+00
341	authentik_stages_user_login	0002_userloginstage_session_duration	2022-10-25 09:01:01.922669+00
342	authentik_stages_user_login	0003_session_duration_delta	2022-10-25 09:01:01.984124+00
343	authentik_stages_user_logout	0001_initial	2022-10-25 09:01:02.032514+00
344	authentik_stages_user_write	0001_initial	2022-10-25 09:01:02.079859+00
345	authentik_stages_user_write	0002_auto_20200918_1653	2022-10-25 09:01:02.123409+00
346	authentik_stages_user_write	0003_userwritestage_create_users_as_inactive	2022-10-25 09:01:02.241424+00
347	authentik_stages_user_write	0004_userwritestage_create_users_group	2022-10-25 09:01:02.286422+00
348	authentik_stages_user_write	0005_userwritestage_user_path_template	2022-10-25 09:01:02.313994+00
349	authentik_tenants	0001_initial	2022-10-25 09:01:02.438438+00
350	authentik_tenants	0002_default	2022-10-25 09:01:02.441285+00
351	authentik_tenants	0003_tenant_branding_favicon	2022-10-25 09:01:02.443486+00
352	authentik_tenants	0004_tenant_event_retention	2022-10-25 09:01:02.445726+00
353	authentik_tenants	0005_tenant_web_certificate	2022-10-25 09:01:02.447902+00
354	authentik_tenants	0002_tenant_flow_user_settings	2022-10-25 09:01:02.496082+00
355	authentik_tenants	0003_tenant_attributes	2022-10-25 09:01:02.518291+00
356	authentik_tenants	0004_tenant_flow_device_code	2022-10-25 09:01:02.570998+00
357	guardian	0001_initial	2022-10-25 09:01:02.818376+00
358	guardian	0002_generic_permissions_index	2022-10-25 09:01:02.845895+00
363	sessions	0001_initial	2022-10-25 09:01:03.062934+00
364	authentik_events	0001_squashed_0019_alter_notificationtransport_webhook_url	2022-10-25 09:01:03.068999+00
365	authentik_flows	0001_squashed_0007_auto_20200703_2059	2022-10-25 09:01:03.072173+00
366	authentik_flows	0012_auto_20200908_1542_squashed_0017_auto_20210329_1334	2022-10-25 09:01:03.075592+00
367	authentik_flows	0019_alter_flow_background_squashed_0024_alter_flow_compatibility_mode	2022-10-25 09:01:03.078354+00
368	authentik_outposts	0001_squashed_0017_outpost_managed	2022-10-25 09:01:03.081107+00
369	authentik_policies_event_matcher	0001_squashed_0018_alter_eventmatcherpolicy_action	2022-10-25 09:01:03.083637+00
370	authentik_providers_ldap	0001_squashed_0005_ldapprovider_search_mode	2022-10-25 09:01:03.086106+00
371	authentik_providers_oauth2	0007_auto_20201016_1107_squashed_0017_alter_oauth2provider_token_validity	2022-10-25 09:01:03.089088+00
372	authentik_providers_proxy	0001_squashed_0014_proxy_v2	2022-10-25 09:01:03.092562+00
373	authentik_providers_saml	0001_squashed_0005_remove_samlprovider_processor_path	2022-10-25 09:01:03.0951+00
374	authentik_sources_ldap	0001_squashed_0012_auto_20210812_1703	2022-10-25 09:01:03.097749+00
375	authentik_sources_saml	0001_squashed_0009_auto_20210301_0949	2022-10-25 09:01:03.099854+00
376	authentik_stages_authenticator_sms	0001_squashed_0004_auto_20211014_0936	2022-10-25 09:01:03.102253+00
377	authentik_stages_identification	0002_auto_20200530_2204_squashed_0013_identificationstage_passwordless_flow	2022-10-25 09:01:03.105354+00
378	authentik_stages_invitation	0001_squashed_0006_invitation_name	2022-10-25 09:01:03.108065+00
379	authentik_tenants	0001_squashed_0005_tenant_web_certificate	2022-10-25 09:01:03.11052+00
380	authentik_core	0018_auto_20210330_1345_squashed_0028_alter_token_intent	2022-10-25 09:01:03.112894+00
381	authentik_core	0002_auto_20200523_1133_squashed_0011_provider_name_temp	2022-10-25 09:01:03.115341+00
382	authentik_core	0012_auto_20201003_1737_squashed_0016_auto_20201202_2234	2022-10-25 09:01:03.11781+00
383	authentik_blueprints	0002_blueprintinstance_content	2023-03-13 09:18:48.7868+00
384	authentik_core	0024_source_icon	2023-03-13 09:18:48.814008+00
385	authentik_flows	0024_flow_authentication	2023-03-13 09:18:48.838784+00
386	authentik_outposts	0018_kubernetesserviceconnection_verify_ssl	2023-03-13 09:18:48.853089+00
387	authentik_policies	0009_alter_policy_name	2023-03-13 09:18:49.023655+00
388	authentik_policies_event_matcher	0021_alter_eventmatcherpolicy_app	2023-03-13 09:18:49.034791+00
389	authentik_policies_password	0005_passwordpolicy_check_have_i_been_pwned_and_more	2023-03-13 09:18:49.088719+00
390	authentik_providers_oauth2	0014_alter_refreshtoken_options_and_more	2023-03-13 09:18:49.303899+00
391	authentik_providers_proxy	0015_proxyprovider_receive_header_auth	2023-03-13 09:18:49.330403+00
392	authentik_stages_authenticator_validate	0012_authenticatorvalidatestage_webauthn_user_verification	2023-03-13 09:18:49.346842+00
393	authentik_stages_captcha	0002_captchastage_api_url_captchastage_js_url_and_more	2023-03-13 09:18:49.404272+00
394	authentik_stages_dummy	0002_dummystage_throw_error	2023-03-13 09:18:49.420263+00
395	authentik_stages_invitation	0007_invitation_flow	2023-03-13 09:18:49.472586+00
396	authentik_stages_prompt	0009_prompt_name	2023-03-13 09:18:49.706828+00
397	authentik_stages_user_write	0006_userwritestage_can_create_users	2023-03-13 09:18:49.730647+00
398	authentik_stages_user_write	0007_remove_userwritestage_can_create_users_and_more	2023-03-13 09:18:49.820103+00
399	authentik_blueprints	0003_alter_blueprintinstance_name	2024-01-10 13:34:39.219213+00
400	authentik_flows	0025_alter_flowstagebinding_evaluate_on_plan_and_more	2024-01-10 13:34:39.299234+00
401	authentik_core	0025_alter_provider_authorization_flow	2024-01-10 13:34:39.346809+00
402	authentik_providers_scim	0001_initial	2024-01-10 13:34:39.633321+00
403	authentik_providers_scim	0002_scimuser	2024-01-10 13:34:39.643609+00
404	authentik_providers_scim	0003_scimgroup	2024-01-10 13:34:39.651202+00
405	authentik_providers_scim	0004_scimprovider_property_mappings_group	2024-01-10 13:34:39.657027+00
406	authentik_providers_scim	0005_scimprovider_exclude_users_service_account_and_more	2024-01-10 13:34:39.661818+00
407	authentik_providers_scim	0006_rename_parent_group_scimprovider_filter_group	2024-01-10 13:34:39.666202+00
408	authentik_core	0026_alter_propertymapping_name_alter_provider_name	2024-01-10 13:34:39.853588+00
409	authentik_core	0027_alter_user_uuid	2024-01-10 13:34:39.887946+00
410	authentik_core	0028_provider_authentication_flow	2024-01-10 13:34:39.936054+00
411	authentik_core	0029_provider_backchannel_applications_and_more	2024-01-10 13:34:40.231447+00
412	authentik_core	0030_user_type	2024-01-10 13:34:40.310035+00
413	authentik_core	0031_alter_user_type	2024-01-10 13:34:40.38953+00
414	authentik_crypto	0004_alter_certificatekeypair_name	2024-01-10 13:34:40.462454+00
415	authentik_enterprise	0001_initial	2024-01-10 13:34:40.481606+00
416	authentik_enterprise	0002_rename_users_license_internal_users_and_more	2024-01-10 13:34:40.498701+00
417	authentik_outposts	0019_alter_outpost_name_and_more	2024-01-10 13:34:40.59884+00
418	authentik_outposts	0020_alter_outpost_type	2024-01-10 13:34:40.620184+00
419	authentik_policies	0010_alter_policy_name	2024-01-10 13:34:40.802184+00
420	authentik_policies_event_matcher	0022_eventmatcherpolicy_model	2024-01-10 13:34:40.814569+00
421	authentik_policies_event_matcher	0023_alter_eventmatcherpolicy_action_and_more	2024-01-10 13:34:40.88434+00
422	authentik_providers_ldap	0003_ldapprovider_mfa_support_and_more	2024-01-10 13:34:40.929103+00
423	authentik_providers_oauth2	0015_accesstoken_auth_time_authorizationcode_auth_time_and_more	2024-01-10 13:34:41.000612+00
424	authentik_providers_oauth2	0016_alter_refreshtoken_token	2024-01-10 13:34:41.036692+00
425	authentik_providers_radius	0001_initial	2024-01-10 13:34:41.082262+00
426	authentik_sources_ldap	0003_ldapsource_client_certificate_ldapsource_sni_and_more	2024-01-10 13:34:41.287946+00
427	authentik_sources_saml	0013_samlsource_verification_kp_and_more	2024-01-10 13:34:41.407493+00
428	authentik_stages_authenticator_duo	0005_authenticatorduostage_friendly_name	2024-01-10 13:34:41.430002+00
429	authentik_stages_authenticator_sms	0006_authenticatorsmsstage_friendly_name	2024-01-10 13:34:41.453801+00
430	authentik_stages_authenticator_static	0006_authenticatorstaticstage_friendly_name	2024-01-10 13:34:41.476862+00
431	authentik_stages_authenticator_static	0007_authenticatorstaticstage_token_length_and_more	2024-01-10 13:34:41.511476+00
432	authentik_stages_authenticator_totp	0007_authenticatortotpstage_friendly_name	2024-01-10 13:34:41.532451+00
433	authentik_stages_authenticator_webauthn	0008_alter_webauthndevice_credential_id	2024-01-10 13:34:41.551282+00
434	authentik_stages_authenticator_webauthn	0009_authenticatewebauthnstage_friendly_name	2024-01-10 13:34:41.570976+00
435	authentik_stages_prompt	0010_alter_prompt_placeholder_alter_prompt_type	2024-01-10 13:34:41.646021+00
436	authentik_stages_prompt	0011_prompt_initial_value_prompt_initial_value_expression_and_more	2024-01-10 13:34:41.8418+00
437	authentik_stages_user_login	0004_userloginstage_terminate_other_sessions	2024-01-10 13:34:41.858913+00
438	authentik_stages_user_login	0005_userloginstage_remember_me_offset	2024-01-10 13:34:41.875539+00
439	authentik_providers_scim	0001_squashed_0006_rename_parent_group_scimprovider_filter_group	2024-01-10 13:34:41.885818+00
359	authentik_stages_authenticator_static	0008_initial	2022-10-25 09:01:02.937653+00
360	authentik_stages_authenticator_static	0009_throttling	2022-10-25 09:01:02.96972+00
361	authentik_stages_authenticator_totp	0008_initial	2022-10-25 09:01:03.019116+00
362	authentik_stages_authenticator_totp	0009_auto_20190420_0723	2022-10-25 09:01:03.049858+00
440	authentik_rbac	0001_initial	2024-01-10 13:36:11.884953+00
441	authentik_core	0032_group_roles	2024-01-10 13:36:12.058845+00
442	authentik_flows	0026_alter_flow_options	2024-01-10 13:36:12.080204+00
443	authentik_flows	0027_auto_20231028_1424	2024-01-10 13:36:12.12669+00
444	authentik_policies	0011_policybinding_failure_result_and_more	2024-01-10 13:36:12.194152+00
445	authentik_policies_reputation	0005_reputation_expires_reputation_expiring	2024-01-10 13:36:12.207094+00
446	authentik_providers_oauth2	0017_accesstoken_session_id_authorizationcode_session_id_and_more	2024-01-10 13:36:12.26718+00
447	authentik_providers_radius	0002_radiusprovider_mfa_support	2024-01-10 13:36:12.281068+00
448	authentik_providers_saml	0013_samlprovider_default_relay_state	2024-01-10 13:36:12.302128+00
449	authentik_rbac	0002_systempermission	2024-01-10 13:36:12.308847+00
450	authentik_stages_authenticator_totp	0010_alter_totpdevice_key	2024-01-10 13:36:12.353573+00
451	authentik_stages_deny	0002_denystage_deny_message	2024-01-10 13:36:12.375379+00
452	authentik_stages_user_write	0008_userwritestage_user_type	2024-01-10 13:36:12.400547+00
\.


--
-- Data for Name: django_session; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.django_session (session_key, session_data, expire_date) FROM stdin;
\.


--
-- Data for Name: guardian_groupobjectpermission; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.guardian_groupobjectpermission (id, object_pk, content_type_id, group_id, permission_id) FROM stdin;
\.


--
-- Data for Name: guardian_userobjectpermission; Type: TABLE DATA; Schema: public; Owner: authentik
--

COPY public.guardian_userobjectpermission (id, object_pk, content_type_id, permission_id, user_id) FROM stdin;
27	efe635b9-2ce7-4de4-977f-9f25b9f36d97	15	63	4
28	1	30	125	4
29	0c24aadc-f97e-4720-a70f-72a190b0cafc	15	63	3
\.


--
-- Name: auth_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.auth_group_id_seq', 1, false);


--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.auth_group_permissions_id_seq', 1, false);


--
-- Name: auth_permission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.auth_permission_id_seq', 413, true);


--
-- Name: authentik_core_group_roles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_group_roles_id_seq', 1, false);


--
-- Name: authentik_core_provider_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_provider_id_seq', 3, true);


--
-- Name: authentik_core_provider_property_mappings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_provider_property_mappings_id_seq', 10, true);


--
-- Name: authentik_core_source_property_mappings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_source_property_mappings_id_seq', 1, false);


--
-- Name: authentik_core_user_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_user_groups_id_seq', 1, false);


--
-- Name: authentik_core_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_user_id_seq', 8, true);


--
-- Name: authentik_core_user_pb_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_user_pb_groups_id_seq', 7, true);


--
-- Name: authentik_core_user_user_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_user_user_permissions_id_seq', 41, true);


--
-- Name: authentik_core_usersourceconnection_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_core_usersourceconnection_id_seq', 1, false);


--
-- Name: authentik_events_notificationrule_transports_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_events_notificationrule_transports_id_seq', 12, true);


--
-- Name: authentik_outposts_outpost_providers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_outposts_outpost_providers_id_seq', 1, true);


--
-- Name: authentik_providers_oauth2_accesstoken_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_providers_oauth2_accesstoken_id_seq', 3, true);


--
-- Name: authentik_providers_oauth2_authorizationcode_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_providers_oauth2_authorizationcode_id_seq', 3, true);


--
-- Name: authentik_providers_oauth2_devicetoken_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_providers_oauth2_devicetoken_id_seq', 1, false);


--
-- Name: authentik_providers_oauth2_oauth2provider_jwks_sources_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_providers_oauth2_oauth2provider_jwks_sources_id_seq', 1, false);


--
-- Name: authentik_providers_oauth2_refreshtoken_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_providers_oauth2_refreshtoken_id_seq', 3, true);


--
-- Name: authentik_providers_scim_scimprovider_property_mappings__id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_providers_scim_scimprovider_property_mappings__id_seq', 1, false);


--
-- Name: authentik_sources_ldap_ldapsource_property_mappings_grou_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_sources_ldap_ldapsource_property_mappings_grou_id_seq', 1, false);


--
-- Name: authentik_stages_authenticator_duo_duodevice_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_authenticator_duo_duodevice_id_seq', 1, false);


--
-- Name: authentik_stages_authenticator_sms_smsdevice_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_authenticator_sms_smsdevice_id_seq', 1, false);


--
-- Name: authentik_stages_authenticator_static_staticdevice_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_authenticator_static_staticdevice_id_seq', 1, false);


--
-- Name: authentik_stages_authenticator_static_statictoken_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_authenticator_static_statictoken_id_seq', 1, false);


--
-- Name: authentik_stages_authenticator_totp_totpdevice_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_authenticator_totp_totpdevice_id_seq', 1, false);


--
-- Name: authentik_stages_authenticator_validate_authenticatorval_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_authenticator_validate_authenticatorval_id_seq', 1, false);


--
-- Name: authentik_stages_authenticator_webauthn_webauthndevice_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_authenticator_webauthn_webauthndevice_id_seq', 1, false);


--
-- Name: authentik_stages_consent_userconsent_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_consent_userconsent_id_seq', 1, false);


--
-- Name: authentik_stages_identification_identificationstage_sour_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_identification_identificationstage_sour_id_seq', 1, true);


--
-- Name: authentik_stages_prompt_promptstage_fields_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_prompt_promptstage_fields_id_seq', 68, true);


--
-- Name: authentik_stages_prompt_promptstage_validation_policies_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.authentik_stages_prompt_promptstage_validation_policies_id_seq', 2, true);


--
-- Name: django_content_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.django_content_type_id_seq', 100, true);


--
-- Name: django_migrations_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.django_migrations_id_seq', 452, true);


--
-- Name: guardian_groupobjectpermission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.guardian_groupobjectpermission_id_seq', 1, false);


--
-- Name: guardian_userobjectpermission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: authentik
--

SELECT pg_catalog.setval('public.guardian_userobjectpermission_id_seq', 29, true);


--
-- Name: auth_group auth_group_name_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_group
    ADD CONSTRAINT auth_group_name_key UNIQUE (name);


--
-- Name: auth_group_permissions auth_group_permissions_group_id_permission_id_0cd325b0_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_permission_id_0cd325b0_uniq UNIQUE (group_id, permission_id);


--
-- Name: auth_group_permissions auth_group_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_pkey PRIMARY KEY (id);


--
-- Name: auth_group auth_group_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_group
    ADD CONSTRAINT auth_group_pkey PRIMARY KEY (id);


--
-- Name: auth_permission auth_permission_content_type_id_codename_01ab375a_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_codename_01ab375a_uniq UNIQUE (content_type_id, codename);


--
-- Name: auth_permission auth_permission_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_pkey PRIMARY KEY (id);


--
-- Name: authentik_blueprints_blueprintinstance authentik_blueprints_blueprintinstance_managed_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_blueprints_blueprintinstance
    ADD CONSTRAINT authentik_blueprints_blueprintinstance_managed_key UNIQUE (managed);


--
-- Name: authentik_blueprints_blueprintinstance authentik_blueprints_blueprintinstance_name_404be626_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_blueprints_blueprintinstance
    ADD CONSTRAINT authentik_blueprints_blueprintinstance_name_404be626_uniq UNIQUE (name);


--
-- Name: authentik_blueprints_blueprintinstance authentik_blueprints_blueprintinstance_name_path_982f03b6_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_blueprints_blueprintinstance
    ADD CONSTRAINT authentik_blueprints_blueprintinstance_name_path_982f03b6_uniq UNIQUE (name, path);


--
-- Name: authentik_blueprints_blueprintinstance authentik_blueprints_blueprintinstance_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_blueprints_blueprintinstance
    ADD CONSTRAINT authentik_blueprints_blueprintinstance_pkey PRIMARY KEY (instance_uuid);


--
-- Name: authentik_core_application authentik_core_application_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_application
    ADD CONSTRAINT authentik_core_application_pkey PRIMARY KEY (policybindingmodel_ptr_id);


--
-- Name: authentik_core_application authentik_core_application_provider_id_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_application
    ADD CONSTRAINT authentik_core_application_provider_id_key UNIQUE (provider_id);


--
-- Name: authentik_core_application authentik_core_application_slug_ab82d049_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_application
    ADD CONSTRAINT authentik_core_application_slug_ab82d049_uniq UNIQUE (slug);


--
-- Name: authentik_core_authenticatedsession authentik_core_authenticatedsession_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_authenticatedsession
    ADD CONSTRAINT authentik_core_authenticatedsession_pkey PRIMARY KEY (uuid);


--
-- Name: authentik_core_group authentik_core_group_name_parent_id_bb2177db_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_group
    ADD CONSTRAINT authentik_core_group_name_parent_id_bb2177db_uniq UNIQUE (name, parent_id);


--
-- Name: authentik_core_group authentik_core_group_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_group
    ADD CONSTRAINT authentik_core_group_pkey PRIMARY KEY (group_uuid);


--
-- Name: authentik_core_group_roles authentik_core_group_roles_group_id_role_id_f2df9be5_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_group_roles
    ADD CONSTRAINT authentik_core_group_roles_group_id_role_id_f2df9be5_uniq UNIQUE (group_id, role_id);


--
-- Name: authentik_core_group_roles authentik_core_group_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_group_roles
    ADD CONSTRAINT authentik_core_group_roles_pkey PRIMARY KEY (id);


--
-- Name: authentik_core_propertymapping authentik_core_propertymapping_managed_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_propertymapping
    ADD CONSTRAINT authentik_core_propertymapping_managed_key UNIQUE (managed);


--
-- Name: authentik_core_propertymapping authentik_core_propertymapping_name_a457d137_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_propertymapping
    ADD CONSTRAINT authentik_core_propertymapping_name_a457d137_uniq UNIQUE (name);


--
-- Name: authentik_core_propertymapping authentik_core_propertymapping_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_propertymapping
    ADD CONSTRAINT authentik_core_propertymapping_pkey PRIMARY KEY (pm_uuid);


--
-- Name: authentik_core_provider_property_mappings authentik_core_provider__provider_id_propertymapp_cf242fa9_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider_property_mappings
    ADD CONSTRAINT authentik_core_provider__provider_id_propertymapp_cf242fa9_uniq UNIQUE (provider_id, propertymapping_id);


--
-- Name: authentik_core_provider authentik_core_provider_name_66fc4ef4_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider
    ADD CONSTRAINT authentik_core_provider_name_66fc4ef4_uniq UNIQUE (name);


--
-- Name: authentik_core_provider authentik_core_provider_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider
    ADD CONSTRAINT authentik_core_provider_pkey PRIMARY KEY (id);


--
-- Name: authentik_core_provider_property_mappings authentik_core_provider_property_mappings_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider_property_mappings
    ADD CONSTRAINT authentik_core_provider_property_mappings_pkey PRIMARY KEY (id);


--
-- Name: authentik_core_source authentik_core_source_managed_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source
    ADD CONSTRAINT authentik_core_source_managed_key UNIQUE (managed);


--
-- Name: authentik_core_source authentik_core_source_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source
    ADD CONSTRAINT authentik_core_source_pkey PRIMARY KEY (policybindingmodel_ptr_id);


--
-- Name: authentik_core_source_property_mappings authentik_core_source_pr_source_id_propertymappin_f506919a_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source_property_mappings
    ADD CONSTRAINT authentik_core_source_pr_source_id_propertymappin_f506919a_uniq UNIQUE (source_id, propertymapping_id);


--
-- Name: authentik_core_source_property_mappings authentik_core_source_property_mappings_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source_property_mappings
    ADD CONSTRAINT authentik_core_source_property_mappings_pkey PRIMARY KEY (id);


--
-- Name: authentik_core_source authentik_core_source_slug_e15c7212_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source
    ADD CONSTRAINT authentik_core_source_slug_e15c7212_uniq UNIQUE (slug);


--
-- Name: authentik_core_token authentik_core_token_identifier_af152015_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_token
    ADD CONSTRAINT authentik_core_token_identifier_af152015_uniq UNIQUE (identifier);


--
-- Name: authentik_core_token authentik_core_token_managed_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_token
    ADD CONSTRAINT authentik_core_token_managed_key UNIQUE (managed);


--
-- Name: authentik_core_token authentik_core_token_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_token
    ADD CONSTRAINT authentik_core_token_pkey PRIMARY KEY (token_uuid);


--
-- Name: authentik_core_user_groups authentik_core_user_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_groups
    ADD CONSTRAINT authentik_core_user_groups_pkey PRIMARY KEY (id);


--
-- Name: authentik_core_user_groups authentik_core_user_groups_user_id_group_id_fbcd9aac_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_groups
    ADD CONSTRAINT authentik_core_user_groups_user_id_group_id_fbcd9aac_uniq UNIQUE (user_id, group_id);


--
-- Name: authentik_core_user_ak_groups authentik_core_user_pb_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_ak_groups
    ADD CONSTRAINT authentik_core_user_pb_groups_pkey PRIMARY KEY (id);


--
-- Name: authentik_core_user_ak_groups authentik_core_user_pb_groups_user_id_group_id_fa5d69c3_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_ak_groups
    ADD CONSTRAINT authentik_core_user_pb_groups_user_id_group_id_fa5d69c3_uniq UNIQUE (user_id, group_id);


--
-- Name: authentik_core_user authentik_core_user_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user
    ADD CONSTRAINT authentik_core_user_pkey PRIMARY KEY (id);


--
-- Name: authentik_core_user_user_permissions authentik_core_user_user_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_user_permissions
    ADD CONSTRAINT authentik_core_user_user_permissions_pkey PRIMARY KEY (id);


--
-- Name: authentik_core_user_user_permissions authentik_core_user_user_user_id_permission_id_2601a709_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_user_permissions
    ADD CONSTRAINT authentik_core_user_user_user_id_permission_id_2601a709_uniq UNIQUE (user_id, permission_id);


--
-- Name: authentik_core_user authentik_core_user_username_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user
    ADD CONSTRAINT authentik_core_user_username_key UNIQUE (username);


--
-- Name: authentik_core_user authentik_core_user_uuid_c7a047d9_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user
    ADD CONSTRAINT authentik_core_user_uuid_c7a047d9_uniq UNIQUE (uuid);


--
-- Name: authentik_core_usersourceconnection authentik_core_usersourc_user_id_source_id_ad1f5aa7_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_usersourceconnection
    ADD CONSTRAINT authentik_core_usersourc_user_id_source_id_ad1f5aa7_uniq UNIQUE (user_id, source_id);


--
-- Name: authentik_core_usersourceconnection authentik_core_usersourceconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_usersourceconnection
    ADD CONSTRAINT authentik_core_usersourceconnection_pkey PRIMARY KEY (id);


--
-- Name: authentik_crypto_certificatekeypair authentik_crypto_certificatekeypair_managed_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_crypto_certificatekeypair
    ADD CONSTRAINT authentik_crypto_certificatekeypair_managed_key UNIQUE (managed);


--
-- Name: authentik_crypto_certificatekeypair authentik_crypto_certificatekeypair_name_719603a4_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_crypto_certificatekeypair
    ADD CONSTRAINT authentik_crypto_certificatekeypair_name_719603a4_uniq UNIQUE (name);


--
-- Name: authentik_crypto_certificatekeypair authentik_crypto_certificatekeypair_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_crypto_certificatekeypair
    ADD CONSTRAINT authentik_crypto_certificatekeypair_pkey PRIMARY KEY (kp_uuid);


--
-- Name: authentik_enterprise_license authentik_enterprise_license_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_enterprise_license
    ADD CONSTRAINT authentik_enterprise_license_pkey PRIMARY KEY (license_uuid);


--
-- Name: authentik_enterprise_licenseusage authentik_enterprise_licenseusage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_enterprise_licenseusage
    ADD CONSTRAINT authentik_enterprise_licenseusage_pkey PRIMARY KEY (usage_uuid);


--
-- Name: authentik_events_event authentik_events_event_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_event
    ADD CONSTRAINT authentik_events_event_pkey PRIMARY KEY (event_uuid);


--
-- Name: authentik_events_notificationrule_transports authentik_events_notific_notificationrule_id_noti_e1f5243d_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationrule_transports
    ADD CONSTRAINT authentik_events_notific_notificationrule_id_noti_e1f5243d_uniq UNIQUE (notificationrule_id, notificationtransport_id);


--
-- Name: authentik_events_notification authentik_events_notification_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notification
    ADD CONSTRAINT authentik_events_notification_pkey PRIMARY KEY (uuid);


--
-- Name: authentik_events_notificationrule authentik_events_notificationrule_name_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationrule
    ADD CONSTRAINT authentik_events_notificationrule_name_key UNIQUE (name);


--
-- Name: authentik_events_notificationrule authentik_events_notificationrule_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationrule
    ADD CONSTRAINT authentik_events_notificationrule_pkey PRIMARY KEY (policybindingmodel_ptr_id);


--
-- Name: authentik_events_notificationrule_transports authentik_events_notificationrule_transports_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationrule_transports
    ADD CONSTRAINT authentik_events_notificationrule_transports_pkey PRIMARY KEY (id);


--
-- Name: authentik_events_notificationtransport authentik_events_notificationtransport_name_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationtransport
    ADD CONSTRAINT authentik_events_notificationtransport_name_key UNIQUE (name);


--
-- Name: authentik_events_notificationtransport authentik_events_notificationtransport_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationtransport
    ADD CONSTRAINT authentik_events_notificationtransport_pkey PRIMARY KEY (uuid);


--
-- Name: authentik_events_notificationwebhookmapping authentik_events_notificationwebhookmapping_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationwebhookmapping
    ADD CONSTRAINT authentik_events_notificationwebhookmapping_pkey PRIMARY KEY (propertymapping_ptr_id);


--
-- Name: authentik_flows_flow authentik_flows_flow_pbm_id_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flow
    ADD CONSTRAINT authentik_flows_flow_pbm_id_key UNIQUE (policybindingmodel_ptr_id);


--
-- Name: authentik_flows_flow authentik_flows_flow_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flow
    ADD CONSTRAINT authentik_flows_flow_pkey PRIMARY KEY (flow_uuid);


--
-- Name: authentik_flows_flow authentik_flows_flow_slug_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flow
    ADD CONSTRAINT authentik_flows_flow_slug_key UNIQUE (slug);


--
-- Name: authentik_flows_flowstagebinding authentik_flows_flowstag_target_id_stage_id_order_f2150241_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowstagebinding
    ADD CONSTRAINT authentik_flows_flowstag_target_id_stage_id_order_f2150241_uniq UNIQUE (target_id, stage_id, "order");


--
-- Name: authentik_flows_flowstagebinding authentik_flows_flowstagebinding_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowstagebinding
    ADD CONSTRAINT authentik_flows_flowstagebinding_pkey PRIMARY KEY (fsb_uuid);


--
-- Name: authentik_flows_flowstagebinding authentik_flows_flowstagebinding_policybindingmodel_ptr_id_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowstagebinding
    ADD CONSTRAINT authentik_flows_flowstagebinding_policybindingmodel_ptr_id_key UNIQUE (policybindingmodel_ptr_id);


--
-- Name: authentik_flows_flowtoken authentik_flows_flowtoken_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowtoken
    ADD CONSTRAINT authentik_flows_flowtoken_pkey PRIMARY KEY (token_ptr_id);


--
-- Name: authentik_flows_stage authentik_flows_stage_name_a2584620_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_stage
    ADD CONSTRAINT authentik_flows_stage_name_a2584620_uniq UNIQUE (name);


--
-- Name: authentik_flows_stage authentik_flows_stage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_stage
    ADD CONSTRAINT authentik_flows_stage_pkey PRIMARY KEY (stage_uuid);


--
-- Name: authentik_outposts_dockerserviceconnection authentik_outposts_dockerserviceconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_dockerserviceconnection
    ADD CONSTRAINT authentik_outposts_dockerserviceconnection_pkey PRIMARY KEY (outpostserviceconnection_ptr_id);


--
-- Name: authentik_outposts_kubernetesserviceconnection authentik_outposts_kubernetesserviceconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_kubernetesserviceconnection
    ADD CONSTRAINT authentik_outposts_kubernetesserviceconnection_pkey PRIMARY KEY (outpostserviceconnection_ptr_id);


--
-- Name: authentik_outposts_outpost_providers authentik_outposts_outpo_outpost_id_provider_id_bee0c17e_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpost_providers
    ADD CONSTRAINT authentik_outposts_outpo_outpost_id_provider_id_bee0c17e_uniq UNIQUE (outpost_id, provider_id);


--
-- Name: authentik_outposts_outpost authentik_outposts_outpost_managed_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpost
    ADD CONSTRAINT authentik_outposts_outpost_managed_key UNIQUE (managed);


--
-- Name: authentik_outposts_outpost authentik_outposts_outpost_name_b07e0428_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpost
    ADD CONSTRAINT authentik_outposts_outpost_name_b07e0428_uniq UNIQUE (name);


--
-- Name: authentik_outposts_outpost authentik_outposts_outpost_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpost
    ADD CONSTRAINT authentik_outposts_outpost_pkey PRIMARY KEY (uuid);


--
-- Name: authentik_outposts_outpost_providers authentik_outposts_outpost_providers_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpost_providers
    ADD CONSTRAINT authentik_outposts_outpost_providers_pkey PRIMARY KEY (id);


--
-- Name: authentik_outposts_outpostserviceconnection authentik_outposts_outpostserviceconnection_name_ec30b5ea_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpostserviceconnection
    ADD CONSTRAINT authentik_outposts_outpostserviceconnection_name_ec30b5ea_uniq UNIQUE (name);


--
-- Name: authentik_outposts_outpostserviceconnection authentik_outposts_outpostserviceconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpostserviceconnection
    ADD CONSTRAINT authentik_outposts_outpostserviceconnection_pkey PRIMARY KEY (uuid);


--
-- Name: authentik_policies_dummy_dummypolicy authentik_policies_dummy_dummypolicy_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_dummy_dummypolicy
    ADD CONSTRAINT authentik_policies_dummy_dummypolicy_pkey PRIMARY KEY (policy_ptr_id);


--
-- Name: authentik_policies_event_matcher_eventmatcherpolicy authentik_policies_event_matcher_eventmatcherpolicy_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_event_matcher_eventmatcherpolicy
    ADD CONSTRAINT authentik_policies_event_matcher_eventmatcherpolicy_pkey PRIMARY KEY (policy_ptr_id);


--
-- Name: authentik_policies_expiry_passwordexpirypolicy authentik_policies_expiry_passwordexpirypolicy_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_expiry_passwordexpirypolicy
    ADD CONSTRAINT authentik_policies_expiry_passwordexpirypolicy_pkey PRIMARY KEY (policy_ptr_id);


--
-- Name: authentik_policies_expression_expressionpolicy authentik_policies_expression_expressionpolicy_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_expression_expressionpolicy
    ADD CONSTRAINT authentik_policies_expression_expressionpolicy_pkey PRIMARY KEY (policy_ptr_id);


--
-- Name: authentik_policies_password_passwordpolicy authentik_policies_password_passwordpolicy_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_password_passwordpolicy
    ADD CONSTRAINT authentik_policies_password_passwordpolicy_pkey PRIMARY KEY (policy_ptr_id);


--
-- Name: authentik_policies_policybinding authentik_policies_polic_policy_id_target_id_orde_0a6ac3bd_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policybinding
    ADD CONSTRAINT authentik_policies_polic_policy_id_target_id_orde_0a6ac3bd_uniq UNIQUE (policy_id, target_id, "order");


--
-- Name: authentik_policies_policy authentik_policies_policy_name_48caa747_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policy
    ADD CONSTRAINT authentik_policies_policy_name_48caa747_uniq UNIQUE (name);


--
-- Name: authentik_policies_policy authentik_policies_policy_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policy
    ADD CONSTRAINT authentik_policies_policy_pkey PRIMARY KEY (policy_uuid);


--
-- Name: authentik_policies_policybinding authentik_policies_policybinding_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policybinding
    ADD CONSTRAINT authentik_policies_policybinding_pkey PRIMARY KEY (policy_binding_uuid);


--
-- Name: authentik_policies_policybindingmodel authentik_policies_policybindingmodel_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policybindingmodel
    ADD CONSTRAINT authentik_policies_policybindingmodel_pkey PRIMARY KEY (pbm_uuid);


--
-- Name: authentik_policies_reputation_reputation authentik_policies_reput_identifier_ip_d60de75a_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_reputation_reputation
    ADD CONSTRAINT authentik_policies_reput_identifier_ip_d60de75a_uniq UNIQUE (identifier, ip);


--
-- Name: authentik_policies_reputation_reputation authentik_policies_reputation_reputation_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_reputation_reputation
    ADD CONSTRAINT authentik_policies_reputation_reputation_pkey PRIMARY KEY (reputation_uuid);


--
-- Name: authentik_policies_reputation_reputationpolicy authentik_policies_reputation_reputationpolicy_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_reputation_reputationpolicy
    ADD CONSTRAINT authentik_policies_reputation_reputationpolicy_pkey PRIMARY KEY (policy_ptr_id);


--
-- Name: authentik_providers_ldap_ldapprovider authentik_providers_ldap_ldapprovider_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_ldap_ldapprovider
    ADD CONSTRAINT authentik_providers_ldap_ldapprovider_pkey PRIMARY KEY (provider_ptr_id);


--
-- Name: authentik_providers_oauth2_oauth2provider_jwks_sources authentik_providers_oaut_oauth2provider_id_oauths_5151c4b7_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_oauth2provider_jwks_sources
    ADD CONSTRAINT authentik_providers_oaut_oauth2provider_id_oauths_5151c4b7_uniq UNIQUE (oauth2provider_id, oauthsource_id);


--
-- Name: authentik_providers_oauth2_accesstoken authentik_providers_oauth2_accesstoken_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_accesstoken
    ADD CONSTRAINT authentik_providers_oauth2_accesstoken_pkey PRIMARY KEY (id);


--
-- Name: authentik_providers_oauth2_authorizationcode authentik_providers_oauth2_authorizationcode_code_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_authorizationcode
    ADD CONSTRAINT authentik_providers_oauth2_authorizationcode_code_key UNIQUE (code);


--
-- Name: authentik_providers_oauth2_authorizationcode authentik_providers_oauth2_authorizationcode_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_authorizationcode
    ADD CONSTRAINT authentik_providers_oauth2_authorizationcode_pkey PRIMARY KEY (id);


--
-- Name: authentik_providers_oauth2_devicetoken authentik_providers_oauth2_devicetoken_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_devicetoken
    ADD CONSTRAINT authentik_providers_oauth2_devicetoken_pkey PRIMARY KEY (id);


--
-- Name: authentik_providers_oauth2_oauth2provider authentik_providers_oauth2_oauth2provider_client_id_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_oauth2provider
    ADD CONSTRAINT authentik_providers_oauth2_oauth2provider_client_id_key UNIQUE (client_id);


--
-- Name: authentik_providers_oauth2_oauth2provider_jwks_sources authentik_providers_oauth2_oauth2provider_jwks_sources_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_oauth2provider_jwks_sources
    ADD CONSTRAINT authentik_providers_oauth2_oauth2provider_jwks_sources_pkey PRIMARY KEY (id);


--
-- Name: authentik_providers_oauth2_oauth2provider authentik_providers_oauth2_oauth2provider_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_oauth2provider
    ADD CONSTRAINT authentik_providers_oauth2_oauth2provider_pkey PRIMARY KEY (provider_ptr_id);


--
-- Name: authentik_providers_oauth2_refreshtoken authentik_providers_oauth2_refreshtoken_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_refreshtoken
    ADD CONSTRAINT authentik_providers_oauth2_refreshtoken_pkey PRIMARY KEY (id);


--
-- Name: authentik_providers_oauth2_scopemapping authentik_providers_oauth2_scopemapping_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_scopemapping
    ADD CONSTRAINT authentik_providers_oauth2_scopemapping_pkey PRIMARY KEY (propertymapping_ptr_id);


--
-- Name: authentik_providers_proxy_proxyprovider authentik_providers_proxy_proxyprovider_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_proxy_proxyprovider
    ADD CONSTRAINT authentik_providers_proxy_proxyprovider_pkey PRIMARY KEY (oauth2provider_ptr_id);


--
-- Name: authentik_providers_radius_radiusprovider authentik_providers_radius_radiusprovider_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_radius_radiusprovider
    ADD CONSTRAINT authentik_providers_radius_radiusprovider_pkey PRIMARY KEY (provider_ptr_id);


--
-- Name: authentik_providers_saml_samlpropertymapping authentik_providers_saml_samlpropertymapping_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_saml_samlpropertymapping
    ADD CONSTRAINT authentik_providers_saml_samlpropertymapping_pkey PRIMARY KEY (propertymapping_ptr_id);


--
-- Name: authentik_providers_saml_samlprovider authentik_providers_saml_samlprovider_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_saml_samlprovider
    ADD CONSTRAINT authentik_providers_saml_samlprovider_pkey PRIMARY KEY (provider_ptr_id);


--
-- Name: authentik_providers_scim_scimgroup authentik_providers_scim_id_group_id_provider_id_9d50d292_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimgroup
    ADD CONSTRAINT authentik_providers_scim_id_group_id_provider_id_9d50d292_uniq UNIQUE (id, group_id, provider_id);


--
-- Name: authentik_providers_scim_scimuser authentik_providers_scim_id_user_id_provider_id_d664a1b5_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimuser
    ADD CONSTRAINT authentik_providers_scim_id_user_id_provider_id_d664a1b5_uniq UNIQUE (id, user_id, provider_id);


--
-- Name: authentik_providers_scim_scimgroup authentik_providers_scim_scimgroup_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimgroup
    ADD CONSTRAINT authentik_providers_scim_scimgroup_pkey PRIMARY KEY (id);


--
-- Name: authentik_providers_scim_scimmapping authentik_providers_scim_scimmapping_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimmapping
    ADD CONSTRAINT authentik_providers_scim_scimmapping_pkey PRIMARY KEY (propertymapping_ptr_id);


--
-- Name: authentik_providers_scim_scimprovider_property_mappings_group authentik_providers_scim_scimprovider_id_property_32317bb5_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimprovider_property_mappings_group
    ADD CONSTRAINT authentik_providers_scim_scimprovider_id_property_32317bb5_uniq UNIQUE (scimprovider_id, propertymapping_id);


--
-- Name: authentik_providers_scim_scimprovider authentik_providers_scim_scimprovider_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimprovider
    ADD CONSTRAINT authentik_providers_scim_scimprovider_pkey PRIMARY KEY (provider_ptr_id);


--
-- Name: authentik_providers_scim_scimprovider_property_mappings_group authentik_providers_scim_scimprovider_property_mappings_gr_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimprovider_property_mappings_group
    ADD CONSTRAINT authentik_providers_scim_scimprovider_property_mappings_gr_pkey PRIMARY KEY (id);


--
-- Name: authentik_providers_scim_scimuser authentik_providers_scim_scimuser_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimuser
    ADD CONSTRAINT authentik_providers_scim_scimuser_pkey PRIMARY KEY (id);


--
-- Name: authentik_rbac_role authentik_rbac_role_group_id_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_rbac_role
    ADD CONSTRAINT authentik_rbac_role_group_id_key UNIQUE (group_id);


--
-- Name: authentik_rbac_role authentik_rbac_role_name_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_rbac_role
    ADD CONSTRAINT authentik_rbac_role_name_key UNIQUE (name);


--
-- Name: authentik_rbac_role authentik_rbac_role_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_rbac_role
    ADD CONSTRAINT authentik_rbac_role_pkey PRIMARY KEY (uuid);


--
-- Name: authentik_sources_ldap_ldapsource_property_mappings_group authentik_sources_ldap_l_ldapsource_id_propertyma_98e4fb2b_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource_property_mappings_group
    ADD CONSTRAINT authentik_sources_ldap_l_ldapsource_id_propertyma_98e4fb2b_uniq UNIQUE (ldapsource_id, propertymapping_id);


--
-- Name: authentik_sources_ldap_ldappropertymapping authentik_sources_ldap_ldappropertymapping_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldappropertymapping
    ADD CONSTRAINT authentik_sources_ldap_ldappropertymapping_pkey PRIMARY KEY (propertymapping_ptr_id);


--
-- Name: authentik_sources_ldap_ldapsource authentik_sources_ldap_ldapsource_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource
    ADD CONSTRAINT authentik_sources_ldap_ldapsource_pkey PRIMARY KEY (source_ptr_id);


--
-- Name: authentik_sources_ldap_ldapsource_property_mappings_group authentik_sources_ldap_ldapsource_property_mappings_group_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource_property_mappings_group
    ADD CONSTRAINT authentik_sources_ldap_ldapsource_property_mappings_group_pkey PRIMARY KEY (id);


--
-- Name: authentik_sources_oauth_oauthsource authentik_sources_oauth_oauthsource_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_oauth_oauthsource
    ADD CONSTRAINT authentik_sources_oauth_oauthsource_pkey PRIMARY KEY (source_ptr_id);


--
-- Name: authentik_sources_oauth_useroauthsourceconnection authentik_sources_oauth_useroauthsourceconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_oauth_useroauthsourceconnection
    ADD CONSTRAINT authentik_sources_oauth_useroauthsourceconnection_pkey PRIMARY KEY (usersourceconnection_ptr_id);


--
-- Name: authentik_sources_plex_plexsource authentik_sources_plex_plexsource_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_plex_plexsource
    ADD CONSTRAINT authentik_sources_plex_plexsource_pkey PRIMARY KEY (source_ptr_id);


--
-- Name: authentik_sources_plex_plexsourceconnection authentik_sources_plex_plexsourceconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_plex_plexsourceconnection
    ADD CONSTRAINT authentik_sources_plex_plexsourceconnection_pkey PRIMARY KEY (usersourceconnection_ptr_id);


--
-- Name: authentik_sources_saml_samlsource authentik_sources_saml_samlsource_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_saml_samlsource
    ADD CONSTRAINT authentik_sources_saml_samlsource_pkey PRIMARY KEY (source_ptr_id);


--
-- Name: authentik_sources_saml_usersamlsourceconnection authentik_sources_saml_usersamlsourceconnection_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_saml_usersamlsourceconnection
    ADD CONSTRAINT authentik_sources_saml_usersamlsourceconnection_pkey PRIMARY KEY (usersourceconnection_ptr_id);


--
-- Name: authentik_stages_authenticator_validate_authenticatorvalida3e25 authentik_stages_authent_authenticatorvalidatesta_efe8bf64_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_validate_authenticatorvalida3e25
    ADD CONSTRAINT authentik_stages_authent_authenticatorvalidatesta_efe8bf64_uniq UNIQUE (authenticatorvalidatestage_id, stage_id);


--
-- Name: authentik_stages_authenticator_sms_smsdevice authentik_stages_authent_stage_id_phone_number_73b07db5_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_sms_smsdevice
    ADD CONSTRAINT authentik_stages_authent_stage_id_phone_number_73b07db5_uniq UNIQUE (stage_id, phone_number);


--
-- Name: authentik_stages_authenticator_duo_authenticatorduostage authentik_stages_authenticator_duo_authenticatorduostage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_duo_authenticatorduostage
    ADD CONSTRAINT authentik_stages_authenticator_duo_authenticatorduostage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_authenticator_duo_duodevice authentik_stages_authenticator_duo_duodevice_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_duo_duodevice
    ADD CONSTRAINT authentik_stages_authenticator_duo_duodevice_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_authenticator_sms_authenticatorsmsstage authentik_stages_authenticator_sms_authenticatorsmsstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_sms_authenticatorsmsstage
    ADD CONSTRAINT authentik_stages_authenticator_sms_authenticatorsmsstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_authenticator_sms_smsdevice authentik_stages_authenticator_sms_smsdevice_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_sms_smsdevice
    ADD CONSTRAINT authentik_stages_authenticator_sms_smsdevice_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_authenticator_static_authenticatorstaticstage authentik_stages_authenticator_static_otpstaticstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_static_authenticatorstaticstage
    ADD CONSTRAINT authentik_stages_authenticator_static_otpstaticstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_authenticator_totp_authenticatortotpstage authentik_stages_authenticator_totp_otptimestage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_totp_authenticatortotpstage
    ADD CONSTRAINT authentik_stages_authenticator_totp_otptimestage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_authenticator_validate_authenticatorvalida3e25 authentik_stages_authenticator_validate_authenticatorvalid_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_validate_authenticatorvalida3e25
    ADD CONSTRAINT authentik_stages_authenticator_validate_authenticatorvalid_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_authenticator_validate_authenticatorvalida499c authentik_stages_authenticator_validate_otpvalidatestage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_validate_authenticatorvalida499c
    ADD CONSTRAINT authentik_stages_authenticator_validate_otpvalidatestage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_authenticator_webauthn_authenticatewebauth4bbe authentik_stages_authenticator_webauthn_authenticatewebaut_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_webauthn_authenticatewebauth4bbe
    ADD CONSTRAINT authentik_stages_authenticator_webauthn_authenticatewebaut_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_authenticator_webauthn_webauthndevice authentik_stages_authenticator_webauthn_webau_credential_id_key; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_webauthn_webauthndevice
    ADD CONSTRAINT authentik_stages_authenticator_webauthn_webau_credential_id_key UNIQUE (credential_id);


--
-- Name: authentik_stages_authenticator_webauthn_webauthndevice authentik_stages_authenticator_webauthn_webauthndevice_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_webauthn_webauthndevice
    ADD CONSTRAINT authentik_stages_authenticator_webauthn_webauthndevice_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_captcha_captchastage authentik_stages_captcha_captchastage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_captcha_captchastage
    ADD CONSTRAINT authentik_stages_captcha_captchastage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_consent_consentstage authentik_stages_consent_consentstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_consent_consentstage
    ADD CONSTRAINT authentik_stages_consent_consentstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_consent_userconsent authentik_stages_consent_user_id_application_id_p_e44c6458_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_consent_userconsent
    ADD CONSTRAINT authentik_stages_consent_user_id_application_id_p_e44c6458_uniq UNIQUE (user_id, application_id, permissions);


--
-- Name: authentik_stages_consent_userconsent authentik_stages_consent_userconsent_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_consent_userconsent
    ADD CONSTRAINT authentik_stages_consent_userconsent_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_deny_denystage authentik_stages_deny_denystage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_deny_denystage
    ADD CONSTRAINT authentik_stages_deny_denystage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_dummy_dummystage authentik_stages_dummy_dummystage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_dummy_dummystage
    ADD CONSTRAINT authentik_stages_dummy_dummystage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_email_emailstage authentik_stages_email_emailstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_email_emailstage
    ADD CONSTRAINT authentik_stages_email_emailstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_identification_identificationstage_sources authentik_stages_identif_identificationstage_id_s_cdf0dfc3_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage_sources
    ADD CONSTRAINT authentik_stages_identif_identificationstage_id_s_cdf0dfc3_uniq UNIQUE (identificationstage_id, source_id);


--
-- Name: authentik_stages_identification_identificationstage authentik_stages_identification_identificationstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage
    ADD CONSTRAINT authentik_stages_identification_identificationstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_identification_identificationstage_sources authentik_stages_identification_identificationstage_source_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage_sources
    ADD CONSTRAINT authentik_stages_identification_identificationstage_source_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_invitation_invitation authentik_stages_invitation_invitation_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_invitation_invitation
    ADD CONSTRAINT authentik_stages_invitation_invitation_pkey PRIMARY KEY (invite_uuid);


--
-- Name: authentik_stages_invitation_invitationstage authentik_stages_invitation_invitationstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_invitation_invitationstage
    ADD CONSTRAINT authentik_stages_invitation_invitationstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_password_passwordstage authentik_stages_password_passwordstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_password_passwordstage
    ADD CONSTRAINT authentik_stages_password_passwordstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_prompt_promptstage_validation_policies authentik_stages_prompt__promptstage_id_policy_id_16cd627d_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage_validation_policies
    ADD CONSTRAINT authentik_stages_prompt__promptstage_id_policy_id_16cd627d_uniq UNIQUE (promptstage_id, policy_id);


--
-- Name: authentik_stages_prompt_promptstage_fields authentik_stages_prompt__promptstage_id_prompt_id_3212c07e_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage_fields
    ADD CONSTRAINT authentik_stages_prompt__promptstage_id_prompt_id_3212c07e_uniq UNIQUE (promptstage_id, prompt_id);


--
-- Name: authentik_stages_prompt_prompt authentik_stages_prompt_prompt_name_789de039_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_prompt
    ADD CONSTRAINT authentik_stages_prompt_prompt_name_789de039_uniq UNIQUE (name);


--
-- Name: authentik_stages_prompt_prompt authentik_stages_prompt_prompt_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_prompt
    ADD CONSTRAINT authentik_stages_prompt_prompt_pkey PRIMARY KEY (prompt_uuid);


--
-- Name: authentik_stages_prompt_promptstage_fields authentik_stages_prompt_promptstage_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage_fields
    ADD CONSTRAINT authentik_stages_prompt_promptstage_fields_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_prompt_promptstage authentik_stages_prompt_promptstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage
    ADD CONSTRAINT authentik_stages_prompt_promptstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_prompt_promptstage_validation_policies authentik_stages_prompt_promptstage_validation_policies_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage_validation_policies
    ADD CONSTRAINT authentik_stages_prompt_promptstage_validation_policies_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_user_delete_userdeletestage authentik_stages_user_delete_userdeletestage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_delete_userdeletestage
    ADD CONSTRAINT authentik_stages_user_delete_userdeletestage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_user_login_userloginstage authentik_stages_user_login_userloginstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_login_userloginstage
    ADD CONSTRAINT authentik_stages_user_login_userloginstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_user_logout_userlogoutstage authentik_stages_user_logout_userlogoutstage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_logout_userlogoutstage
    ADD CONSTRAINT authentik_stages_user_logout_userlogoutstage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_stages_user_write_userwritestage authentik_stages_user_write_userwritestage_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_write_userwritestage
    ADD CONSTRAINT authentik_stages_user_write_userwritestage_pkey PRIMARY KEY (stage_ptr_id);


--
-- Name: authentik_tenants_tenant authentik_tenants_tenant_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_tenants_tenant
    ADD CONSTRAINT authentik_tenants_tenant_pkey PRIMARY KEY (tenant_uuid);


--
-- Name: django_content_type django_content_type_app_label_model_76bd3d3b_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.django_content_type
    ADD CONSTRAINT django_content_type_app_label_model_76bd3d3b_uniq UNIQUE (app_label, model);


--
-- Name: django_content_type django_content_type_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.django_content_type
    ADD CONSTRAINT django_content_type_pkey PRIMARY KEY (id);


--
-- Name: django_migrations django_migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.django_migrations
    ADD CONSTRAINT django_migrations_pkey PRIMARY KEY (id);


--
-- Name: django_session django_session_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.django_session
    ADD CONSTRAINT django_session_pkey PRIMARY KEY (session_key);


--
-- Name: guardian_groupobjectpermission guardian_groupobjectperm_group_id_permission_id_o_3f189f7c_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobjectperm_group_id_permission_id_o_3f189f7c_uniq UNIQUE (group_id, permission_id, object_pk);


--
-- Name: guardian_groupobjectpermission guardian_groupobjectpermission_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobjectpermission_pkey PRIMARY KEY (id);


--
-- Name: guardian_userobjectpermission guardian_userobjectpermi_user_id_permission_id_ob_b0b3d2fc_uniq; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectpermi_user_id_permission_id_ob_b0b3d2fc_uniq UNIQUE (user_id, permission_id, object_pk);


--
-- Name: guardian_userobjectpermission guardian_userobjectpermission_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectpermission_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_authenticator_static_staticdevice otp_static_staticdevice_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_static_staticdevice
    ADD CONSTRAINT otp_static_staticdevice_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_authenticator_static_statictoken otp_static_statictoken_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_static_statictoken
    ADD CONSTRAINT otp_static_statictoken_pkey PRIMARY KEY (id);


--
-- Name: authentik_stages_authenticator_totp_totpdevice otp_totp_totpdevice_pkey; Type: CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_totp_totpdevice
    ADD CONSTRAINT otp_totp_totpdevice_pkey PRIMARY KEY (id);


--
-- Name: auth_group_name_a6ea08ec_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX auth_group_name_a6ea08ec_like ON public.auth_group USING btree (name varchar_pattern_ops);


--
-- Name: auth_group_permissions_group_id_b120cbf9; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX auth_group_permissions_group_id_b120cbf9 ON public.auth_group_permissions USING btree (group_id);


--
-- Name: auth_group_permissions_permission_id_84c5c92e; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX auth_group_permissions_permission_id_84c5c92e ON public.auth_group_permissions USING btree (permission_id);


--
-- Name: auth_permission_content_type_id_2f476e4b; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX auth_permission_content_type_id_2f476e4b ON public.auth_permission USING btree (content_type_id);


--
-- Name: authentik_blueprints_blueprintinstance_managed_a2959093_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_blueprints_blueprintinstance_managed_a2959093_like ON public.authentik_blueprints_blueprintinstance USING btree (managed text_pattern_ops);


--
-- Name: authentik_blueprints_blueprintinstance_name_404be626_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_blueprints_blueprintinstance_name_404be626_like ON public.authentik_blueprints_blueprintinstance USING btree (name text_pattern_ops);


--
-- Name: authentik_c_identif_d9d032_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_c_identif_d9d032_idx ON public.authentik_core_token USING btree (identifier);


--
-- Name: authentik_c_key_f71355_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_c_key_f71355_idx ON public.authentik_core_token USING btree (key);


--
-- Name: authentik_c_name_affae6_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_c_name_affae6_idx ON public.authentik_core_source USING btree (name);


--
-- Name: authentik_c_slug_ccb2e5_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_c_slug_ccb2e5_idx ON public.authentik_core_source USING btree (slug);


--
-- Name: authentik_core_application_slug_ab82d049_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_application_slug_ab82d049_like ON public.authentik_core_application USING btree (slug varchar_pattern_ops);


--
-- Name: authentik_core_authenticatedsession_user_id_5055b6cf; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_authenticatedsession_user_id_5055b6cf ON public.authentik_core_authenticatedsession USING btree (user_id);


--
-- Name: authentik_core_group_parent_id_c2cd3508; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_group_parent_id_c2cd3508 ON public.authentik_core_group USING btree (parent_id);


--
-- Name: authentik_core_group_roles_group_id_43a283e0; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_group_roles_group_id_43a283e0 ON public.authentik_core_group_roles USING btree (group_id);


--
-- Name: authentik_core_group_roles_role_id_5b9a84fe; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_group_roles_role_id_5b9a84fe ON public.authentik_core_group_roles USING btree (role_id);


--
-- Name: authentik_core_propertymapping_managed_e1718652_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_propertymapping_managed_e1718652_like ON public.authentik_core_propertymapping USING btree (managed text_pattern_ops);


--
-- Name: authentik_core_propertymapping_name_a457d137_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_propertymapping_name_a457d137_like ON public.authentik_core_propertymapping USING btree (name text_pattern_ops);


--
-- Name: authentik_core_provider_authentication_flow_id_49dea03c; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_provider_authentication_flow_id_49dea03c ON public.authentik_core_provider USING btree (authentication_flow_id);


--
-- Name: authentik_core_provider_authorization_flow_id_1482437b; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_provider_authorization_flow_id_1482437b ON public.authentik_core_provider USING btree (authorization_flow_id);


--
-- Name: authentik_core_provider_backchannel_application_id_a972ebd6; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_provider_backchannel_application_id_a972ebd6 ON public.authentik_core_provider USING btree (backchannel_application_id);


--
-- Name: authentik_core_provider_name_66fc4ef4_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_provider_name_66fc4ef4_like ON public.authentik_core_provider USING btree (name text_pattern_ops);


--
-- Name: authentik_core_provider_pr_propertymapping_id_7d1de2b7; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_provider_pr_propertymapping_id_7d1de2b7 ON public.authentik_core_provider_property_mappings USING btree (propertymapping_id);


--
-- Name: authentik_core_provider_property_mappings_provider_id_10e17d5c; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_provider_property_mappings_provider_id_10e17d5c ON public.authentik_core_provider_property_mappings USING btree (provider_id);


--
-- Name: authentik_core_source_authentication_flow_id_2478087b; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_source_authentication_flow_id_2478087b ON public.authentik_core_source USING btree (authentication_flow_id);


--
-- Name: authentik_core_source_enrollment_flow_id_7844a7b3; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_source_enrollment_flow_id_7844a7b3 ON public.authentik_core_source USING btree (enrollment_flow_id);


--
-- Name: authentik_core_source_managed_65965884_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_source_managed_65965884_like ON public.authentik_core_source USING btree (managed text_pattern_ops);


--
-- Name: authentik_core_source_prop_propertymapping_id_f455cf7d; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_source_prop_propertymapping_id_f455cf7d ON public.authentik_core_source_property_mappings USING btree (propertymapping_id);


--
-- Name: authentik_core_source_property_mappings_source_id_66697386; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_source_property_mappings_source_id_66697386 ON public.authentik_core_source_property_mappings USING btree (source_id);


--
-- Name: authentik_core_source_slug_e15c7212_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_source_slug_e15c7212_like ON public.authentik_core_source USING btree (slug varchar_pattern_ops);


--
-- Name: authentik_core_token_identifier_af152015_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_token_identifier_af152015_like ON public.authentik_core_token USING btree (identifier varchar_pattern_ops);


--
-- Name: authentik_core_token_managed_20a845a1_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_token_managed_20a845a1_like ON public.authentik_core_token USING btree (managed text_pattern_ops);


--
-- Name: authentik_core_token_user_id_479d5b79; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_token_user_id_479d5b79 ON public.authentik_core_token USING btree (user_id);


--
-- Name: authentik_core_user_groups_group_id_72ba5f8d; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_user_groups_group_id_72ba5f8d ON public.authentik_core_user_groups USING btree (group_id);


--
-- Name: authentik_core_user_groups_user_id_a2462693; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_user_groups_user_id_a2462693 ON public.authentik_core_user_groups USING btree (user_id);


--
-- Name: authentik_core_user_pb_groups_group_id_344046d2; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_user_pb_groups_group_id_344046d2 ON public.authentik_core_user_ak_groups USING btree (group_id);


--
-- Name: authentik_core_user_pb_groups_user_id_5ce7c1dc; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_user_pb_groups_user_id_5ce7c1dc ON public.authentik_core_user_ak_groups USING btree (user_id);


--
-- Name: authentik_core_user_user_permissions_permission_id_67859147; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_user_user_permissions_permission_id_67859147 ON public.authentik_core_user_user_permissions USING btree (permission_id);


--
-- Name: authentik_core_user_user_permissions_user_id_6e5a5d85; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_user_user_permissions_user_id_6e5a5d85 ON public.authentik_core_user_user_permissions USING btree (user_id);


--
-- Name: authentik_core_user_username_ba8d02c8_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_user_username_ba8d02c8_like ON public.authentik_core_user USING btree (username varchar_pattern_ops);


--
-- Name: authentik_core_usersourceconnection_source_id_450cff14; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_usersourceconnection_source_id_450cff14 ON public.authentik_core_usersourceconnection USING btree (source_id);


--
-- Name: authentik_core_usersourceconnection_user_id_7f305d6f; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_core_usersourceconnection_user_id_7f305d6f ON public.authentik_core_usersourceconnection USING btree (user_id);


--
-- Name: authentik_crypto_certificatekeypair_managed_a997712a_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_crypto_certificatekeypair_managed_a997712a_like ON public.authentik_crypto_certificatekeypair USING btree (managed text_pattern_ops);


--
-- Name: authentik_crypto_certificatekeypair_name_719603a4_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_crypto_certificatekeypair_name_719603a4_like ON public.authentik_crypto_certificatekeypair USING btree (name text_pattern_ops);


--
-- Name: authentik_e_key_523e13_hash; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_e_key_523e13_hash ON public.authentik_enterprise_license USING hash (key);


--
-- Name: authentik_events_notificat_notificationrule_id_eccbe1d6; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_events_notificat_notificationrule_id_eccbe1d6 ON public.authentik_events_notificationrule_transports USING btree (notificationrule_id);


--
-- Name: authentik_events_notificat_notificationtransport_id_62ec0805; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_events_notificat_notificationtransport_id_62ec0805 ON public.authentik_events_notificationrule_transports USING btree (notificationtransport_id);


--
-- Name: authentik_events_notificat_webhook_mapping_id_2a646fb6; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_events_notificat_webhook_mapping_id_2a646fb6 ON public.authentik_events_notificationtransport USING btree (webhook_mapping_id);


--
-- Name: authentik_events_notification_event_id_ac5c4bb7; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_events_notification_event_id_ac5c4bb7 ON public.authentik_events_notification USING btree (event_id);


--
-- Name: authentik_events_notification_user_id_9ea0c690; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_events_notification_user_id_9ea0c690 ON public.authentik_events_notification USING btree (user_id);


--
-- Name: authentik_events_notificationrule_group_id_667f0fe0; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_events_notificationrule_group_id_667f0fe0 ON public.authentik_events_notificationrule USING btree (group_id);


--
-- Name: authentik_events_notificationrule_name_7401a31b_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_events_notificationrule_name_7401a31b_like ON public.authentik_events_notificationrule USING btree (name text_pattern_ops);


--
-- Name: authentik_events_notificationtransport_name_1f0bd605_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_events_notificationtransport_name_1f0bd605_like ON public.authentik_events_notificationtransport USING btree (name text_pattern_ops);


--
-- Name: authentik_flows_flow_slug_3c406d87_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_flows_flow_slug_3c406d87_like ON public.authentik_flows_flow USING btree (slug varchar_pattern_ops);


--
-- Name: authentik_flows_flowstagebinding_stage_id_7a270212; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_flows_flowstagebinding_stage_id_7a270212 ON public.authentik_flows_flowstagebinding USING btree (stage_id);


--
-- Name: authentik_flows_flowstagebinding_target_id_4899c0f8; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_flows_flowstagebinding_target_id_4899c0f8 ON public.authentik_flows_flowstagebinding USING btree (target_id);


--
-- Name: authentik_flows_flowtoken_flow_id_e4c82880; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_flows_flowtoken_flow_id_e4c82880 ON public.authentik_flows_flowtoken USING btree (flow_id);


--
-- Name: authentik_flows_stage_name_a2584620_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_flows_stage_name_a2584620_like ON public.authentik_flows_stage USING btree (name text_pattern_ops);


--
-- Name: authentik_outposts_dockers_tls_authentication_id_942e2224; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_outposts_dockers_tls_authentication_id_942e2224 ON public.authentik_outposts_dockerserviceconnection USING btree (tls_authentication_id);


--
-- Name: authentik_outposts_dockers_tls_verification_id_769fac22; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_outposts_dockers_tls_verification_id_769fac22 ON public.authentik_outposts_dockerserviceconnection USING btree (tls_verification_id);


--
-- Name: authentik_outposts_outpost_managed_e03db044_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_outposts_outpost_managed_e03db044_like ON public.authentik_outposts_outpost USING btree (managed text_pattern_ops);


--
-- Name: authentik_outposts_outpost_name_b07e0428_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_outposts_outpost_name_b07e0428_like ON public.authentik_outposts_outpost USING btree (name text_pattern_ops);


--
-- Name: authentik_outposts_outpost_providers_outpost_id_eaaf025b; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_outposts_outpost_providers_outpost_id_eaaf025b ON public.authentik_outposts_outpost_providers USING btree (outpost_id);


--
-- Name: authentik_outposts_outpost_providers_provider_id_7c5cb603; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_outposts_outpost_providers_provider_id_7c5cb603 ON public.authentik_outposts_outpost_providers USING btree (provider_id);


--
-- Name: authentik_outposts_outpost_service_connection_id_3eafd830; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_outposts_outpost_service_connection_id_3eafd830 ON public.authentik_outposts_outpost USING btree (service_connection_id);


--
-- Name: authentik_outposts_outpostserviceconnection_name_ec30b5ea_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_outposts_outpostserviceconnection_name_ec30b5ea_like ON public.authentik_outposts_outpostserviceconnection USING btree (name text_pattern_ops);


--
-- Name: authentik_p_group_i_5d2d24_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_group_i_5d2d24_idx ON public.authentik_policies_policybinding USING btree (group_id);


--
-- Name: authentik_p_policy__534e15_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_policy__534e15_idx ON public.authentik_policies_policybinding USING btree (policy_id);


--
-- Name: authentik_p_policy__648f9b_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_policy__648f9b_idx ON public.authentik_policies_dummy_dummypolicy USING btree (policy_ptr_id);


--
-- Name: authentik_p_policy__855e80_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_policy__855e80_idx ON public.authentik_policies_password_passwordpolicy USING btree (policy_ptr_id);


--
-- Name: authentik_p_policy__8f0d70_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_policy__8f0d70_idx ON public.authentik_policies_reputation_reputationpolicy USING btree (policy_ptr_id);


--
-- Name: authentik_p_policy__cf73a7_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_policy__cf73a7_idx ON public.authentik_policies_expiry_passwordexpirypolicy USING btree (policy_ptr_id);


--
-- Name: authentik_p_policy__e605cf_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_policy__e605cf_idx ON public.authentik_policies_event_matcher_eventmatcherpolicy USING btree (policy_ptr_id);


--
-- Name: authentik_p_policy__fb6feb_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_policy__fb6feb_idx ON public.authentik_policies_expression_expressionpolicy USING btree (policy_ptr_id);


--
-- Name: authentik_p_target__2e4d50_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_target__2e4d50_idx ON public.authentik_policies_policybinding USING btree (target_id);


--
-- Name: authentik_p_user_id_603323_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_p_user_id_603323_idx ON public.authentik_policies_policybinding USING btree (user_id);


--
-- Name: authentik_policies_policy_name_48caa747_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_policies_policy_name_48caa747_like ON public.authentik_policies_policy USING btree (name text_pattern_ops);


--
-- Name: authentik_policies_policybinding_group_id_2afb13ee; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_policies_policybinding_group_id_2afb13ee ON public.authentik_policies_policybinding USING btree (group_id);


--
-- Name: authentik_policies_policybinding_policy_id_c07161e4; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_policies_policybinding_policy_id_c07161e4 ON public.authentik_policies_policybinding USING btree (policy_id);


--
-- Name: authentik_policies_policybinding_target_id_a7075d8d; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_policies_policybinding_target_id_a7075d8d ON public.authentik_policies_policybinding USING btree (target_id);


--
-- Name: authentik_policies_policybinding_user_id_323bebdb; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_policies_policybinding_user_id_323bebdb ON public.authentik_policies_policybinding USING btree (user_id);


--
-- Name: authentik_providers_ldap_ldapprovider_certificate_id_6a7a6af2; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_ldap_ldapprovider_certificate_id_6a7a6af2 ON public.authentik_providers_ldap_ldapprovider USING btree (certificate_id);


--
-- Name: authentik_providers_ldap_ldapprovider_search_group_id_64713cfa; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_ldap_ldapprovider_search_group_id_64713cfa ON public.authentik_providers_ldap_ldapprovider USING btree (search_group_id);


--
-- Name: authentik_providers_oaut_client_id_ae566546_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oaut_client_id_ae566546_like ON public.authentik_providers_oauth2_oauth2provider USING btree (client_id varchar_pattern_ops);


--
-- Name: authentik_providers_oauth2_accesstoken_provider_id_40ef5d24; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_accesstoken_provider_id_40ef5d24 ON public.authentik_providers_oauth2_accesstoken USING btree (provider_id);


--
-- Name: authentik_providers_oauth2_accesstoken_user_id_7261588f; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_accesstoken_user_id_7261588f ON public.authentik_providers_oauth2_accesstoken USING btree (user_id);


--
-- Name: authentik_providers_oauth2_authorizationcode_code_0202addc_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_authorizationcode_code_0202addc_like ON public.authentik_providers_oauth2_authorizationcode USING btree (code varchar_pattern_ops);


--
-- Name: authentik_providers_oauth2_authorizationcode_user_id_c9a35141; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_authorizationcode_user_id_c9a35141 ON public.authentik_providers_oauth2_authorizationcode USING btree (user_id);


--
-- Name: authentik_providers_oauth2_devicetoken_provider_id_bd1ef28a; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_devicetoken_provider_id_bd1ef28a ON public.authentik_providers_oauth2_devicetoken USING btree (provider_id);


--
-- Name: authentik_providers_oauth2_devicetoken_user_id_17317b6d; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_devicetoken_user_id_17317b6d ON public.authentik_providers_oauth2_devicetoken USING btree (user_id);


--
-- Name: authentik_providers_oauth2_oauth2provider_id_c3adf184; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_oauth2provider_id_c3adf184 ON public.authentik_providers_oauth2_oauth2provider_jwks_sources USING btree (oauth2provider_id);


--
-- Name: authentik_providers_oauth2_oauth2provider_rsa_key_id_836efe9f; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_oauth2provider_rsa_key_id_836efe9f ON public.authentik_providers_oauth2_oauth2provider USING btree (signing_key_id);


--
-- Name: authentik_providers_oauth2_oauthsource_id_41457c33; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_oauthsource_id_41457c33 ON public.authentik_providers_oauth2_oauth2provider_jwks_sources USING btree (oauthsource_id);


--
-- Name: authentik_providers_oauth2_provider_id_731a3e62; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_provider_id_731a3e62 ON public.authentik_providers_oauth2_authorizationcode USING btree (provider_id);


--
-- Name: authentik_providers_oauth2_refreshtoken_provider_id_8bf99dba; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_refreshtoken_provider_id_8bf99dba ON public.authentik_providers_oauth2_refreshtoken USING btree (provider_id);


--
-- Name: authentik_providers_oauth2_refreshtoken_user_id_ebdc1143; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_oauth2_refreshtoken_user_id_ebdc1143 ON public.authentik_providers_oauth2_refreshtoken USING btree (user_id);


--
-- Name: authentik_providers_proxy_proxyprovider_certificate_id_b1e0c422; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_proxy_proxyprovider_certificate_id_b1e0c422 ON public.authentik_providers_proxy_proxyprovider USING btree (certificate_id);


--
-- Name: authentik_providers_saml_s_name_id_mapping_id_5d45f77f; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_saml_s_name_id_mapping_id_5d45f77f ON public.authentik_providers_saml_samlprovider USING btree (name_id_mapping_id);


--
-- Name: authentik_providers_saml_s_verification_kp_id_7b0fbd80; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_saml_s_verification_kp_id_7b0fbd80 ON public.authentik_providers_saml_samlprovider USING btree (verification_kp_id);


--
-- Name: authentik_providers_saml_samlprovider_signing_kp_id_f1bce700; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_saml_samlprovider_signing_kp_id_f1bce700 ON public.authentik_providers_saml_samlprovider USING btree (signing_kp_id);


--
-- Name: authentik_providers_scim_s_propertymapping_id_7ea3950a; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_s_propertymapping_id_7ea3950a ON public.authentik_providers_scim_scimprovider_property_mappings_group USING btree (propertymapping_id);


--
-- Name: authentik_providers_scim_s_scimprovider_id_c3c41ae0; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_s_scimprovider_id_c3c41ae0 ON public.authentik_providers_scim_scimprovider_property_mappings_group USING btree (scimprovider_id);


--
-- Name: authentik_providers_scim_scimgroup_group_id_071f6834; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_scimgroup_group_id_071f6834 ON public.authentik_providers_scim_scimgroup USING btree (group_id);


--
-- Name: authentik_providers_scim_scimgroup_id_96ae7587_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_scimgroup_id_96ae7587_like ON public.authentik_providers_scim_scimgroup USING btree (id text_pattern_ops);


--
-- Name: authentik_providers_scim_scimgroup_provider_id_29f58417; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_scimgroup_provider_id_29f58417 ON public.authentik_providers_scim_scimgroup USING btree (provider_id);


--
-- Name: authentik_providers_scim_scimprovider_filter_group_id_1aca1276; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_scimprovider_filter_group_id_1aca1276 ON public.authentik_providers_scim_scimprovider USING btree (filter_group_id);


--
-- Name: authentik_providers_scim_scimuser_id_64507c6f_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_scimuser_id_64507c6f_like ON public.authentik_providers_scim_scimuser USING btree (id text_pattern_ops);


--
-- Name: authentik_providers_scim_scimuser_provider_id_08127ac7; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_scimuser_provider_id_08127ac7 ON public.authentik_providers_scim_scimuser USING btree (provider_id);


--
-- Name: authentik_providers_scim_scimuser_user_id_63e0ca83; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_providers_scim_scimuser_user_id_63e0ca83 ON public.authentik_providers_scim_scimuser USING btree (user_id);


--
-- Name: authentik_rbac_role_name_94e9e999_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_rbac_role_name_94e9e999_like ON public.authentik_rbac_role USING btree (name text_pattern_ops);


--
-- Name: authentik_sources_ldap_lda_client_certificate_id_937bc1c9; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_sources_ldap_lda_client_certificate_id_937bc1c9 ON public.authentik_sources_ldap_ldapsource USING btree (client_certificate_id);


--
-- Name: authentik_sources_ldap_lda_ldapsource_id_4eff95ce; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_sources_ldap_lda_ldapsource_id_4eff95ce ON public.authentik_sources_ldap_ldapsource_property_mappings_group USING btree (ldapsource_id);


--
-- Name: authentik_sources_ldap_lda_propertymapping_id_6d727491; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_sources_ldap_lda_propertymapping_id_6d727491 ON public.authentik_sources_ldap_ldapsource_property_mappings_group USING btree (propertymapping_id);


--
-- Name: authentik_sources_ldap_ldapsource_peer_certificate_id_50528d0a; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_sources_ldap_ldapsource_peer_certificate_id_50528d0a ON public.authentik_sources_ldap_ldapsource USING btree (peer_certificate_id);


--
-- Name: authentik_sources_ldap_ldapsource_sync_parent_group_id_9c730e90; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_sources_ldap_ldapsource_sync_parent_group_id_9c730e90 ON public.authentik_sources_ldap_ldapsource USING btree (sync_parent_group_id);


--
-- Name: authentik_sources_saml_sam_pre_authentication_flow_id_cec52f8b; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_sources_saml_sam_pre_authentication_flow_id_cec52f8b ON public.authentik_sources_saml_samlsource USING btree (pre_authentication_flow_id);


--
-- Name: authentik_sources_saml_samlsource_signing_kp_id_faae605c; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_sources_saml_samlsource_signing_kp_id_faae605c ON public.authentik_sources_saml_samlsource USING btree (signing_kp_id);


--
-- Name: authentik_sources_saml_samlsource_verification_kp_id_f76620d9; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_sources_saml_samlsource_verification_kp_id_f76620d9 ON public.authentik_sources_saml_samlsource USING btree (verification_kp_id);


--
-- Name: authentik_stages_authentic_authenticatorvalidatestage_aff63c61; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_authenticatorvalidatestage_aff63c61 ON public.authentik_stages_authenticator_validate_authenticatorvalida3e25 USING btree (authenticatorvalidatestage_id);


--
-- Name: authentik_stages_authentic_configure_flow_id_0e413e4d; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_configure_flow_id_0e413e4d ON public.authentik_stages_authenticator_static_authenticatorstaticstage USING btree (configure_flow_id);


--
-- Name: authentik_stages_authentic_configure_flow_id_4c667db1; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_configure_flow_id_4c667db1 ON public.authentik_stages_authenticator_duo_authenticatorduostage USING btree (configure_flow_id);


--
-- Name: authentik_stages_authentic_configure_flow_id_b1d83847; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_configure_flow_id_b1d83847 ON public.authentik_stages_authenticator_webauthn_authenticatewebauth4bbe USING btree (configure_flow_id);


--
-- Name: authentik_stages_authentic_configure_flow_id_e6d859e3; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_configure_flow_id_e6d859e3 ON public.authentik_stages_authenticator_totp_authenticatortotpstage USING btree (configure_flow_id);


--
-- Name: authentik_stages_authentic_configure_flow_id_ff974e9e; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_configure_flow_id_ff974e9e ON public.authentik_stages_authenticator_sms_authenticatorsmsstage USING btree (configure_flow_id);


--
-- Name: authentik_stages_authentic_mapping_id_72d070b3; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_mapping_id_72d070b3 ON public.authentik_stages_authenticator_sms_authenticatorsmsstage USING btree (mapping_id);


--
-- Name: authentik_stages_authentic_stage_id_3c37cac7; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_stage_id_3c37cac7 ON public.authentik_stages_authenticator_validate_authenticatorvalida3e25 USING btree (stage_id);


--
-- Name: authentik_stages_authentic_user_id_26c9196a; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authentic_user_id_26c9196a ON public.authentik_stages_authenticator_webauthn_webauthndevice USING btree (user_id);


--
-- Name: authentik_stages_authenticator_duo_duodevice_stage_id_926e33da; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authenticator_duo_duodevice_stage_id_926e33da ON public.authentik_stages_authenticator_duo_duodevice USING btree (stage_id);


--
-- Name: authentik_stages_authenticator_duo_duodevice_user_id_bd340329; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authenticator_duo_duodevice_user_id_bd340329 ON public.authentik_stages_authenticator_duo_duodevice USING btree (user_id);


--
-- Name: authentik_stages_authenticator_sms_smsdevice_stage_id_35c87fa6; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authenticator_sms_smsdevice_stage_id_35c87fa6 ON public.authentik_stages_authenticator_sms_smsdevice USING btree (stage_id);


--
-- Name: authentik_stages_authenticator_sms_smsdevice_user_id_454934c5; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_authenticator_sms_smsdevice_user_id_454934c5 ON public.authentik_stages_authenticator_sms_smsdevice USING btree (user_id);


--
-- Name: authentik_stages_consent_userconsent_application_id_ad55f58e; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_consent_userconsent_application_id_ad55f58e ON public.authentik_stages_consent_userconsent USING btree (application_id);


--
-- Name: authentik_stages_consent_userconsent_user_id_554dc39f; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_consent_userconsent_user_id_554dc39f ON public.authentik_stages_consent_userconsent USING btree (user_id);


--
-- Name: authentik_stages_identific_enrollment_flow_id_930e83ff; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_identific_enrollment_flow_id_930e83ff ON public.authentik_stages_identification_identificationstage USING btree (enrollment_flow_id);


--
-- Name: authentik_stages_identific_identificationstage_id_c119703c; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_identific_identificationstage_id_c119703c ON public.authentik_stages_identification_identificationstage_sources USING btree (identificationstage_id);


--
-- Name: authentik_stages_identific_password_stage_id_8d68497a; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_identific_password_stage_id_8d68497a ON public.authentik_stages_identification_identificationstage USING btree (password_stage_id);


--
-- Name: authentik_stages_identific_passwordless_flow_id_68cf3874; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_identific_passwordless_flow_id_68cf3874 ON public.authentik_stages_identification_identificationstage USING btree (passwordless_flow_id);


--
-- Name: authentik_stages_identific_recovery_flow_id_16f5f1c7; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_identific_recovery_flow_id_16f5f1c7 ON public.authentik_stages_identification_identificationstage USING btree (recovery_flow_id);


--
-- Name: authentik_stages_identific_source_id_9579fda9; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_identific_source_id_9579fda9 ON public.authentik_stages_identification_identificationstage_sources USING btree (source_id);


--
-- Name: authentik_stages_invitation_invitation_created_by_id_87fe9398; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_invitation_invitation_created_by_id_87fe9398 ON public.authentik_stages_invitation_invitation USING btree (created_by_id);


--
-- Name: authentik_stages_invitation_invitation_flow_id_66945236; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_invitation_invitation_flow_id_66945236 ON public.authentik_stages_invitation_invitation USING btree (flow_id);


--
-- Name: authentik_stages_invitation_invitation_name_00580941; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_invitation_invitation_name_00580941 ON public.authentik_stages_invitation_invitation USING btree (name);


--
-- Name: authentik_stages_invitation_invitation_name_00580941_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_invitation_invitation_name_00580941_like ON public.authentik_stages_invitation_invitation USING btree (name varchar_pattern_ops);


--
-- Name: authentik_stages_password_passwordstage_change_flow_id_d56f0f83; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_password_passwordstage_change_flow_id_d56f0f83 ON public.authentik_stages_password_passwordstage USING btree (configure_flow_id);


--
-- Name: authentik_stages_prompt_pr_policy_id_96db92ab; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_prompt_pr_policy_id_96db92ab ON public.authentik_stages_prompt_promptstage_validation_policies USING btree (policy_id);


--
-- Name: authentik_stages_prompt_pr_promptstage_id_cb253bb1; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_prompt_pr_promptstage_id_cb253bb1 ON public.authentik_stages_prompt_promptstage_validation_policies USING btree (promptstage_id);


--
-- Name: authentik_stages_prompt_pr_promptstage_id_d3bd61cc; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_prompt_pr_promptstage_id_d3bd61cc ON public.authentik_stages_prompt_promptstage_fields USING btree (promptstage_id);


--
-- Name: authentik_stages_prompt_prompt_name_789de039_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_prompt_prompt_name_789de039_like ON public.authentik_stages_prompt_prompt USING btree (name text_pattern_ops);


--
-- Name: authentik_stages_prompt_promptstage_fields_prompt_id_8c79d4c1; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_prompt_promptstage_fields_prompt_id_8c79d4c1 ON public.authentik_stages_prompt_promptstage_fields USING btree (prompt_id);


--
-- Name: authentik_stages_user_writ_create_users_group_id_90b7794f; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_stages_user_writ_create_users_group_id_90b7794f ON public.authentik_stages_user_write_userwritestage USING btree (create_users_group_id);


--
-- Name: authentik_tenants_tenant_flow_authentication_id_7a0889f3; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_tenants_tenant_flow_authentication_id_7a0889f3 ON public.authentik_tenants_tenant USING btree (flow_authentication_id);


--
-- Name: authentik_tenants_tenant_flow_device_code_id_c8fa4eb4; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_tenants_tenant_flow_device_code_id_c8fa4eb4 ON public.authentik_tenants_tenant USING btree (flow_device_code_id);


--
-- Name: authentik_tenants_tenant_flow_invalidation_id_cedce4a1; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_tenants_tenant_flow_invalidation_id_cedce4a1 ON public.authentik_tenants_tenant USING btree (flow_invalidation_id);


--
-- Name: authentik_tenants_tenant_flow_recovery_id_a08f1692; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_tenants_tenant_flow_recovery_id_a08f1692 ON public.authentik_tenants_tenant USING btree (flow_recovery_id);


--
-- Name: authentik_tenants_tenant_flow_unenrollment_id_73817e72; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_tenants_tenant_flow_unenrollment_id_73817e72 ON public.authentik_tenants_tenant USING btree (flow_unenrollment_id);


--
-- Name: authentik_tenants_tenant_flow_user_settings_id_7592a467; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_tenants_tenant_flow_user_settings_id_7592a467 ON public.authentik_tenants_tenant USING btree (flow_user_settings_id);


--
-- Name: authentik_tenants_tenant_web_certificate_id_74429583; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX authentik_tenants_tenant_web_certificate_id_74429583 ON public.authentik_tenants_tenant USING btree (web_certificate_id);


--
-- Name: django_session_expire_date_a5c62663; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX django_session_expire_date_a5c62663 ON public.django_session USING btree (expire_date);


--
-- Name: django_session_session_key_c0390e0f_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX django_session_session_key_c0390e0f_like ON public.django_session USING btree (session_key varchar_pattern_ops);


--
-- Name: guardian_gr_content_ae6aec_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX guardian_gr_content_ae6aec_idx ON public.guardian_groupobjectpermission USING btree (content_type_id, object_pk);


--
-- Name: guardian_groupobjectpermission_content_type_id_7ade36b8; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX guardian_groupobjectpermission_content_type_id_7ade36b8 ON public.guardian_groupobjectpermission USING btree (content_type_id);


--
-- Name: guardian_groupobjectpermission_group_id_4bbbfb62; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX guardian_groupobjectpermission_group_id_4bbbfb62 ON public.guardian_groupobjectpermission USING btree (group_id);


--
-- Name: guardian_groupobjectpermission_permission_id_36572738; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX guardian_groupobjectpermission_permission_id_36572738 ON public.guardian_groupobjectpermission USING btree (permission_id);


--
-- Name: guardian_us_content_179ed2_idx; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX guardian_us_content_179ed2_idx ON public.guardian_userobjectpermission USING btree (content_type_id, object_pk);


--
-- Name: guardian_userobjectpermission_content_type_id_2e892405; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX guardian_userobjectpermission_content_type_id_2e892405 ON public.guardian_userobjectpermission USING btree (content_type_id);


--
-- Name: guardian_userobjectpermission_permission_id_71807bfc; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX guardian_userobjectpermission_permission_id_71807bfc ON public.guardian_userobjectpermission USING btree (permission_id);


--
-- Name: guardian_userobjectpermission_user_id_d5c1e964; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX guardian_userobjectpermission_user_id_d5c1e964 ON public.guardian_userobjectpermission USING btree (user_id);


--
-- Name: otp_static_staticdevice_user_id_7f9cff2b; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX otp_static_staticdevice_user_id_7f9cff2b ON public.authentik_stages_authenticator_static_staticdevice USING btree (user_id);


--
-- Name: otp_static_statictoken_device_id_74b7c7d1; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX otp_static_statictoken_device_id_74b7c7d1 ON public.authentik_stages_authenticator_static_statictoken USING btree (device_id);


--
-- Name: otp_static_statictoken_token_d0a51866; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX otp_static_statictoken_token_d0a51866 ON public.authentik_stages_authenticator_static_statictoken USING btree (token);


--
-- Name: otp_static_statictoken_token_d0a51866_like; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX otp_static_statictoken_token_d0a51866_like ON public.authentik_stages_authenticator_static_statictoken USING btree (token varchar_pattern_ops);


--
-- Name: otp_totp_totpdevice_user_id_0fb18292; Type: INDEX; Schema: public; Owner: authentik
--

CREATE INDEX otp_totp_totpdevice_user_id_0fb18292 ON public.authentik_stages_authenticator_totp_totpdevice USING btree (user_id);


--
-- Name: auth_group_permissions auth_group_permissio_permission_id_84c5c92e_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissio_permission_id_84c5c92e_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_group_permissions auth_group_permissions_group_id_b120cbf9_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_b120cbf9_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_permission auth_permission_content_type_id_2f476e4b_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_2f476e4b_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_application authentik_core_appli_policybindingmodel_p_a04bee2b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_application
    ADD CONSTRAINT authentik_core_appli_policybindingmodel_p_a04bee2b_fk_authentik FOREIGN KEY (policybindingmodel_ptr_id) REFERENCES public.authentik_policies_policybindingmodel(pbm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_application authentik_core_appli_provider_id_357ae6c6_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_application
    ADD CONSTRAINT authentik_core_appli_provider_id_357ae6c6_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_core_provider(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_authenticatedsession authentik_core_authe_user_id_5055b6cf_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_authenticatedsession
    ADD CONSTRAINT authentik_core_authe_user_id_5055b6cf_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_group_roles authentik_core_group_group_id_43a283e0_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_group_roles
    ADD CONSTRAINT authentik_core_group_group_id_43a283e0_fk_authentik FOREIGN KEY (group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_group authentik_core_group_parent_id_c2cd3508_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_group
    ADD CONSTRAINT authentik_core_group_parent_id_c2cd3508_fk_authentik FOREIGN KEY (parent_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_group_roles authentik_core_group_role_id_5b9a84fe_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_group_roles
    ADD CONSTRAINT authentik_core_group_role_id_5b9a84fe_fk_authentik FOREIGN KEY (role_id) REFERENCES public.authentik_rbac_role(uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_provider authentik_core_provi_authentication_flow__49dea03c_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider
    ADD CONSTRAINT authentik_core_provi_authentication_flow__49dea03c_fk_authentik FOREIGN KEY (authentication_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_provider authentik_core_provi_authorization_flow_i_1482437b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider
    ADD CONSTRAINT authentik_core_provi_authorization_flow_i_1482437b_fk_authentik FOREIGN KEY (authorization_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_provider authentik_core_provi_backchannel_applicat_a972ebd6_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider
    ADD CONSTRAINT authentik_core_provi_backchannel_applicat_a972ebd6_fk_authentik FOREIGN KEY (backchannel_application_id) REFERENCES public.authentik_core_application(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_provider_property_mappings authentik_core_provi_propertymapping_id_7d1de2b7_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider_property_mappings
    ADD CONSTRAINT authentik_core_provi_propertymapping_id_7d1de2b7_fk_authentik FOREIGN KEY (propertymapping_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_provider_property_mappings authentik_core_provi_provider_id_10e17d5c_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_provider_property_mappings
    ADD CONSTRAINT authentik_core_provi_provider_id_10e17d5c_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_core_provider(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_source authentik_core_sourc_authentication_flow__2478087b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source
    ADD CONSTRAINT authentik_core_sourc_authentication_flow__2478087b_fk_authentik FOREIGN KEY (authentication_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_source authentik_core_sourc_enrollment_flow_id_7844a7b3_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source
    ADD CONSTRAINT authentik_core_sourc_enrollment_flow_id_7844a7b3_fk_authentik FOREIGN KEY (enrollment_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_source authentik_core_sourc_policybindingmodel_p_746c4900_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source
    ADD CONSTRAINT authentik_core_sourc_policybindingmodel_p_746c4900_fk_authentik FOREIGN KEY (policybindingmodel_ptr_id) REFERENCES public.authentik_policies_policybindingmodel(pbm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_source_property_mappings authentik_core_sourc_propertymapping_id_f455cf7d_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source_property_mappings
    ADD CONSTRAINT authentik_core_sourc_propertymapping_id_f455cf7d_fk_authentik FOREIGN KEY (propertymapping_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_source_property_mappings authentik_core_sourc_source_id_66697386_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_source_property_mappings
    ADD CONSTRAINT authentik_core_sourc_source_id_66697386_fk_authentik FOREIGN KEY (source_id) REFERENCES public.authentik_core_source(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_token authentik_core_token_user_id_479d5b79_fk_authentik_core_user_id; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_token
    ADD CONSTRAINT authentik_core_token_user_id_479d5b79_fk_authentik_core_user_id FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_user_ak_groups authentik_core_user__group_id_344046d2_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_ak_groups
    ADD CONSTRAINT authentik_core_user__group_id_344046d2_fk_authentik FOREIGN KEY (group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_user_user_permissions authentik_core_user__permission_id_67859147_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_user_permissions
    ADD CONSTRAINT authentik_core_user__permission_id_67859147_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_user_ak_groups authentik_core_user__user_id_5ce7c1dc_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_ak_groups
    ADD CONSTRAINT authentik_core_user__user_id_5ce7c1dc_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_user_user_permissions authentik_core_user__user_id_6e5a5d85_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_user_permissions
    ADD CONSTRAINT authentik_core_user__user_id_6e5a5d85_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_user_groups authentik_core_user__user_id_a2462693_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_groups
    ADD CONSTRAINT authentik_core_user__user_id_a2462693_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_user_groups authentik_core_user_groups_group_id_72ba5f8d_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_user_groups
    ADD CONSTRAINT authentik_core_user_groups_group_id_72ba5f8d_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_usersourceconnection authentik_core_users_source_id_450cff14_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_usersourceconnection
    ADD CONSTRAINT authentik_core_users_source_id_450cff14_fk_authentik FOREIGN KEY (source_id) REFERENCES public.authentik_core_source(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_core_usersourceconnection authentik_core_users_user_id_7f305d6f_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_core_usersourceconnection
    ADD CONSTRAINT authentik_core_users_user_id_7f305d6f_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_events_notification authentik_events_not_event_id_ac5c4bb7_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notification
    ADD CONSTRAINT authentik_events_not_event_id_ac5c4bb7_fk_authentik FOREIGN KEY (event_id) REFERENCES public.authentik_events_event(event_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_events_notificationrule authentik_events_not_group_id_667f0fe0_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationrule
    ADD CONSTRAINT authentik_events_not_group_id_667f0fe0_fk_authentik FOREIGN KEY (group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_events_notificationrule_transports authentik_events_not_notificationrule_id_eccbe1d6_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationrule_transports
    ADD CONSTRAINT authentik_events_not_notificationrule_id_eccbe1d6_fk_authentik FOREIGN KEY (notificationrule_id) REFERENCES public.authentik_events_notificationrule(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_events_notificationrule_transports authentik_events_not_notificationtranspor_62ec0805_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationrule_transports
    ADD CONSTRAINT authentik_events_not_notificationtranspor_62ec0805_fk_authentik FOREIGN KEY (notificationtransport_id) REFERENCES public.authentik_events_notificationtransport(uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_events_notificationrule authentik_events_not_policybindingmodel_p_74974b98_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationrule
    ADD CONSTRAINT authentik_events_not_policybindingmodel_p_74974b98_fk_authentik FOREIGN KEY (policybindingmodel_ptr_id) REFERENCES public.authentik_policies_policybindingmodel(pbm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_events_notificationwebhookmapping authentik_events_not_propertymapping_ptr__56d35fcd_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationwebhookmapping
    ADD CONSTRAINT authentik_events_not_propertymapping_ptr__56d35fcd_fk_authentik FOREIGN KEY (propertymapping_ptr_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_events_notification authentik_events_not_user_id_9ea0c690_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notification
    ADD CONSTRAINT authentik_events_not_user_id_9ea0c690_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_events_notificationtransport authentik_events_not_webhook_mapping_id_2a646fb6_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_events_notificationtransport
    ADD CONSTRAINT authentik_events_not_webhook_mapping_id_2a646fb6_fk_authentik FOREIGN KEY (webhook_mapping_id) REFERENCES public.authentik_events_notificationwebhookmapping(propertymapping_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_flows_flowtoken authentik_flows_flow_flow_id_e4c82880_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowtoken
    ADD CONSTRAINT authentik_flows_flow_flow_id_e4c82880_fk_authentik FOREIGN KEY (flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_flows_flowstagebinding authentik_flows_flow_policybindingmodel_p_20d905a6_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowstagebinding
    ADD CONSTRAINT authentik_flows_flow_policybindingmodel_p_20d905a6_fk_authentik FOREIGN KEY (policybindingmodel_ptr_id) REFERENCES public.authentik_policies_policybindingmodel(pbm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_flows_flow authentik_flows_flow_policybindingmodel_p_9c3c290f_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flow
    ADD CONSTRAINT authentik_flows_flow_policybindingmodel_p_9c3c290f_fk_authentik FOREIGN KEY (policybindingmodel_ptr_id) REFERENCES public.authentik_policies_policybindingmodel(pbm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_flows_flowstagebinding authentik_flows_flow_stage_id_7a270212_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowstagebinding
    ADD CONSTRAINT authentik_flows_flow_stage_id_7a270212_fk_authentik FOREIGN KEY (stage_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_flows_flowstagebinding authentik_flows_flow_target_id_4899c0f8_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowstagebinding
    ADD CONSTRAINT authentik_flows_flow_target_id_4899c0f8_fk_authentik FOREIGN KEY (target_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_flows_flowtoken authentik_flows_flow_token_ptr_id_e3047c65_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_flows_flowtoken
    ADD CONSTRAINT authentik_flows_flow_token_ptr_id_e3047c65_fk_authentik FOREIGN KEY (token_ptr_id) REFERENCES public.authentik_core_token(token_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_outposts_dockerserviceconnection authentik_outposts_d_outpostserviceconnec_35f196a0_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_dockerserviceconnection
    ADD CONSTRAINT authentik_outposts_d_outpostserviceconnec_35f196a0_fk_authentik FOREIGN KEY (outpostserviceconnection_ptr_id) REFERENCES public.authentik_outposts_outpostserviceconnection(uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_outposts_dockerserviceconnection authentik_outposts_d_tls_authentication_i_942e2224_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_dockerserviceconnection
    ADD CONSTRAINT authentik_outposts_d_tls_authentication_i_942e2224_fk_authentik FOREIGN KEY (tls_authentication_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_outposts_dockerserviceconnection authentik_outposts_d_tls_verification_id_769fac22_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_dockerserviceconnection
    ADD CONSTRAINT authentik_outposts_d_tls_verification_id_769fac22_fk_authentik FOREIGN KEY (tls_verification_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_outposts_kubernetesserviceconnection authentik_outposts_k_outpostserviceconnec_f5cf691d_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_kubernetesserviceconnection
    ADD CONSTRAINT authentik_outposts_k_outpostserviceconnec_f5cf691d_fk_authentik FOREIGN KEY (outpostserviceconnection_ptr_id) REFERENCES public.authentik_outposts_outpostserviceconnection(uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_outposts_outpost_providers authentik_outposts_o_outpost_id_eaaf025b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpost_providers
    ADD CONSTRAINT authentik_outposts_o_outpost_id_eaaf025b_fk_authentik FOREIGN KEY (outpost_id) REFERENCES public.authentik_outposts_outpost(uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_outposts_outpost_providers authentik_outposts_o_provider_id_7c5cb603_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpost_providers
    ADD CONSTRAINT authentik_outposts_o_provider_id_7c5cb603_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_core_provider(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_outposts_outpost authentik_outposts_o_service_connection_i_3eafd830_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_outposts_outpost
    ADD CONSTRAINT authentik_outposts_o_service_connection_i_3eafd830_fk_authentik FOREIGN KEY (service_connection_id) REFERENCES public.authentik_outposts_outpostserviceconnection(uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_dummy_dummypolicy authentik_policies_d_policy_ptr_id_d411c5e4_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_dummy_dummypolicy
    ADD CONSTRAINT authentik_policies_d_policy_ptr_id_d411c5e4_fk_authentik FOREIGN KEY (policy_ptr_id) REFERENCES public.authentik_policies_policy(policy_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_expression_expressionpolicy authentik_policies_e_policy_ptr_id_3fec413c_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_expression_expressionpolicy
    ADD CONSTRAINT authentik_policies_e_policy_ptr_id_3fec413c_fk_authentik FOREIGN KEY (policy_ptr_id) REFERENCES public.authentik_policies_policy(policy_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_expiry_passwordexpirypolicy authentik_policies_e_policy_ptr_id_bad15341_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_expiry_passwordexpirypolicy
    ADD CONSTRAINT authentik_policies_e_policy_ptr_id_bad15341_fk_authentik FOREIGN KEY (policy_ptr_id) REFERENCES public.authentik_policies_policy(policy_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_event_matcher_eventmatcherpolicy authentik_policies_e_policy_ptr_id_f12a3e96_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_event_matcher_eventmatcherpolicy
    ADD CONSTRAINT authentik_policies_e_policy_ptr_id_f12a3e96_fk_authentik FOREIGN KEY (policy_ptr_id) REFERENCES public.authentik_policies_policy(policy_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_policybinding authentik_policies_p_group_id_2afb13ee_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policybinding
    ADD CONSTRAINT authentik_policies_p_group_id_2afb13ee_fk_authentik FOREIGN KEY (group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_policybinding authentik_policies_p_policy_id_c07161e4_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policybinding
    ADD CONSTRAINT authentik_policies_p_policy_id_c07161e4_fk_authentik FOREIGN KEY (policy_id) REFERENCES public.authentik_policies_policy(policy_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_password_passwordpolicy authentik_policies_p_policy_ptr_id_6301794d_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_password_passwordpolicy
    ADD CONSTRAINT authentik_policies_p_policy_ptr_id_6301794d_fk_authentik FOREIGN KEY (policy_ptr_id) REFERENCES public.authentik_policies_policy(policy_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_policybinding authentik_policies_p_target_id_a7075d8d_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policybinding
    ADD CONSTRAINT authentik_policies_p_target_id_a7075d8d_fk_authentik FOREIGN KEY (target_id) REFERENCES public.authentik_policies_policybindingmodel(pbm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_policybinding authentik_policies_p_user_id_323bebdb_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_policybinding
    ADD CONSTRAINT authentik_policies_p_user_id_323bebdb_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_policies_reputation_reputationpolicy authentik_policies_r_policy_ptr_id_5d5a869c_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_policies_reputation_reputationpolicy
    ADD CONSTRAINT authentik_policies_r_policy_ptr_id_5d5a869c_fk_authentik FOREIGN KEY (policy_ptr_id) REFERENCES public.authentik_policies_policy(policy_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_ldap_ldapprovider authentik_providers__certificate_id_6a7a6af2_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_ldap_ldapprovider
    ADD CONSTRAINT authentik_providers__certificate_id_6a7a6af2_fk_authentik FOREIGN KEY (certificate_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_proxy_proxyprovider authentik_providers__certificate_id_b1e0c422_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_proxy_proxyprovider
    ADD CONSTRAINT authentik_providers__certificate_id_b1e0c422_fk_authentik FOREIGN KEY (certificate_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimprovider authentik_providers__filter_group_id_1aca1276_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimprovider
    ADD CONSTRAINT authentik_providers__filter_group_id_1aca1276_fk_authentik FOREIGN KEY (filter_group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimgroup authentik_providers__group_id_071f6834_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimgroup
    ADD CONSTRAINT authentik_providers__group_id_071f6834_fk_authentik FOREIGN KEY (group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_saml_samlprovider authentik_providers__name_id_mapping_id_5d45f77f_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_saml_samlprovider
    ADD CONSTRAINT authentik_providers__name_id_mapping_id_5d45f77f_fk_authentik FOREIGN KEY (name_id_mapping_id) REFERENCES public.authentik_providers_saml_samlpropertymapping(propertymapping_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_oauth2provider_jwks_sources authentik_providers__oauth2provider_id_c3adf184_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_oauth2provider_jwks_sources
    ADD CONSTRAINT authentik_providers__oauth2provider_id_c3adf184_fk_authentik FOREIGN KEY (oauth2provider_id) REFERENCES public.authentik_providers_oauth2_oauth2provider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_proxy_proxyprovider authentik_providers__oauth2provider_ptr_i_eb747e01_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_proxy_proxyprovider
    ADD CONSTRAINT authentik_providers__oauth2provider_ptr_i_eb747e01_fk_authentik FOREIGN KEY (oauth2provider_ptr_id) REFERENCES public.authentik_providers_oauth2_oauth2provider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_oauth2provider_jwks_sources authentik_providers__oauthsource_id_41457c33_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_oauth2provider_jwks_sources
    ADD CONSTRAINT authentik_providers__oauthsource_id_41457c33_fk_authentik FOREIGN KEY (oauthsource_id) REFERENCES public.authentik_sources_oauth_oauthsource(source_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimprovider_property_mappings_group authentik_providers__propertymapping_id_7ea3950a_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimprovider_property_mappings_group
    ADD CONSTRAINT authentik_providers__propertymapping_id_7ea3950a_fk_authentik FOREIGN KEY (propertymapping_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_scopemapping authentik_providers__propertymapping_ptr__37f1d926_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_scopemapping
    ADD CONSTRAINT authentik_providers__propertymapping_ptr__37f1d926_fk_authentik FOREIGN KEY (propertymapping_ptr_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_saml_samlpropertymapping authentik_providers__propertymapping_ptr__812e8cfb_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_saml_samlpropertymapping
    ADD CONSTRAINT authentik_providers__propertymapping_ptr__812e8cfb_fk_authentik FOREIGN KEY (propertymapping_ptr_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimmapping authentik_providers__propertymapping_ptr__bd79ae32_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimmapping
    ADD CONSTRAINT authentik_providers__propertymapping_ptr__bd79ae32_fk_authentik FOREIGN KEY (propertymapping_ptr_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimuser authentik_providers__provider_id_08127ac7_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimuser
    ADD CONSTRAINT authentik_providers__provider_id_08127ac7_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_providers_scim_scimprovider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimgroup authentik_providers__provider_id_29f58417_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimgroup
    ADD CONSTRAINT authentik_providers__provider_id_29f58417_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_providers_scim_scimprovider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_accesstoken authentik_providers__provider_id_40ef5d24_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_accesstoken
    ADD CONSTRAINT authentik_providers__provider_id_40ef5d24_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_providers_oauth2_oauth2provider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_authorizationcode authentik_providers__provider_id_731a3e62_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_authorizationcode
    ADD CONSTRAINT authentik_providers__provider_id_731a3e62_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_providers_oauth2_oauth2provider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_refreshtoken authentik_providers__provider_id_8bf99dba_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_refreshtoken
    ADD CONSTRAINT authentik_providers__provider_id_8bf99dba_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_providers_oauth2_oauth2provider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_devicetoken authentik_providers__provider_id_bd1ef28a_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_devicetoken
    ADD CONSTRAINT authentik_providers__provider_id_bd1ef28a_fk_authentik FOREIGN KEY (provider_id) REFERENCES public.authentik_providers_oauth2_oauth2provider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_saml_samlprovider authentik_providers__provider_ptr_id_677ac81a_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_saml_samlprovider
    ADD CONSTRAINT authentik_providers__provider_ptr_id_677ac81a_fk_authentik FOREIGN KEY (provider_ptr_id) REFERENCES public.authentik_core_provider(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_oauth2provider authentik_providers__provider_ptr_id_76903270_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_oauth2provider
    ADD CONSTRAINT authentik_providers__provider_ptr_id_76903270_fk_authentik FOREIGN KEY (provider_ptr_id) REFERENCES public.authentik_core_provider(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimprovider authentik_providers__provider_ptr_id_77bcf9bd_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimprovider
    ADD CONSTRAINT authentik_providers__provider_ptr_id_77bcf9bd_fk_authentik FOREIGN KEY (provider_ptr_id) REFERENCES public.authentik_core_provider(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_radius_radiusprovider authentik_providers__provider_ptr_id_908e5d8a_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_radius_radiusprovider
    ADD CONSTRAINT authentik_providers__provider_ptr_id_908e5d8a_fk_authentik FOREIGN KEY (provider_ptr_id) REFERENCES public.authentik_core_provider(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_ldap_ldapprovider authentik_providers__provider_ptr_id_deae38fd_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_ldap_ldapprovider
    ADD CONSTRAINT authentik_providers__provider_ptr_id_deae38fd_fk_authentik FOREIGN KEY (provider_ptr_id) REFERENCES public.authentik_core_provider(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimprovider_property_mappings_group authentik_providers__scimprovider_id_c3c41ae0_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimprovider_property_mappings_group
    ADD CONSTRAINT authentik_providers__scimprovider_id_c3c41ae0_fk_authentik FOREIGN KEY (scimprovider_id) REFERENCES public.authentik_providers_scim_scimprovider(provider_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_ldap_ldapprovider authentik_providers__search_group_id_64713cfa_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_ldap_ldapprovider
    ADD CONSTRAINT authentik_providers__search_group_id_64713cfa_fk_authentik FOREIGN KEY (search_group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_oauth2provider authentik_providers__signing_key_id_4189c2f3_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_oauth2provider
    ADD CONSTRAINT authentik_providers__signing_key_id_4189c2f3_fk_authentik FOREIGN KEY (signing_key_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_saml_samlprovider authentik_providers__signing_kp_id_f1bce700_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_saml_samlprovider
    ADD CONSTRAINT authentik_providers__signing_kp_id_f1bce700_fk_authentik FOREIGN KEY (signing_kp_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_devicetoken authentik_providers__user_id_17317b6d_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_devicetoken
    ADD CONSTRAINT authentik_providers__user_id_17317b6d_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_scim_scimuser authentik_providers__user_id_63e0ca83_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_scim_scimuser
    ADD CONSTRAINT authentik_providers__user_id_63e0ca83_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_accesstoken authentik_providers__user_id_7261588f_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_accesstoken
    ADD CONSTRAINT authentik_providers__user_id_7261588f_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_authorizationcode authentik_providers__user_id_c9a35141_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_authorizationcode
    ADD CONSTRAINT authentik_providers__user_id_c9a35141_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_oauth2_refreshtoken authentik_providers__user_id_ebdc1143_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_oauth2_refreshtoken
    ADD CONSTRAINT authentik_providers__user_id_ebdc1143_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_providers_saml_samlprovider authentik_providers__verification_kp_id_7b0fbd80_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_providers_saml_samlprovider
    ADD CONSTRAINT authentik_providers__verification_kp_id_7b0fbd80_fk_authentik FOREIGN KEY (verification_kp_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_rbac_role authentik_rbac_role_group_id_d8509027_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_rbac_role
    ADD CONSTRAINT authentik_rbac_role_group_id_d8509027_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_ldap_ldapsource authentik_sources_ld_client_certificate_i_937bc1c9_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource
    ADD CONSTRAINT authentik_sources_ld_client_certificate_i_937bc1c9_fk_authentik FOREIGN KEY (client_certificate_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_ldap_ldapsource_property_mappings_group authentik_sources_ld_ldapsource_id_4eff95ce_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource_property_mappings_group
    ADD CONSTRAINT authentik_sources_ld_ldapsource_id_4eff95ce_fk_authentik FOREIGN KEY (ldapsource_id) REFERENCES public.authentik_sources_ldap_ldapsource(source_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_ldap_ldapsource authentik_sources_ld_peer_certificate_id_50528d0a_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource
    ADD CONSTRAINT authentik_sources_ld_peer_certificate_id_50528d0a_fk_authentik FOREIGN KEY (peer_certificate_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_ldap_ldapsource_property_mappings_group authentik_sources_ld_propertymapping_id_6d727491_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource_property_mappings_group
    ADD CONSTRAINT authentik_sources_ld_propertymapping_id_6d727491_fk_authentik FOREIGN KEY (propertymapping_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_ldap_ldappropertymapping authentik_sources_ld_propertymapping_ptr__559cd35b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldappropertymapping
    ADD CONSTRAINT authentik_sources_ld_propertymapping_ptr__559cd35b_fk_authentik FOREIGN KEY (propertymapping_ptr_id) REFERENCES public.authentik_core_propertymapping(pm_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_ldap_ldapsource authentik_sources_ld_source_ptr_id_264402b5_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource
    ADD CONSTRAINT authentik_sources_ld_source_ptr_id_264402b5_fk_authentik FOREIGN KEY (source_ptr_id) REFERENCES public.authentik_core_source(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_ldap_ldapsource authentik_sources_ld_sync_parent_group_id_9c730e90_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_ldap_ldapsource
    ADD CONSTRAINT authentik_sources_ld_sync_parent_group_id_9c730e90_fk_authentik FOREIGN KEY (sync_parent_group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_oauth_oauthsource authentik_sources_oa_source_ptr_id_eb45d674_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_oauth_oauthsource
    ADD CONSTRAINT authentik_sources_oa_source_ptr_id_eb45d674_fk_authentik FOREIGN KEY (source_ptr_id) REFERENCES public.authentik_core_source(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_oauth_useroauthsourceconnection authentik_sources_oa_usersourceconnection_e9ae7a6b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_oauth_useroauthsourceconnection
    ADD CONSTRAINT authentik_sources_oa_usersourceconnection_e9ae7a6b_fk_authentik FOREIGN KEY (usersourceconnection_ptr_id) REFERENCES public.authentik_core_usersourceconnection(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_plex_plexsource authentik_sources_pl_source_ptr_id_b52adfc2_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_plex_plexsource
    ADD CONSTRAINT authentik_sources_pl_source_ptr_id_b52adfc2_fk_authentik FOREIGN KEY (source_ptr_id) REFERENCES public.authentik_core_source(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_plex_plexsourceconnection authentik_sources_pl_usersourceconnection_ff3dd805_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_plex_plexsourceconnection
    ADD CONSTRAINT authentik_sources_pl_usersourceconnection_ff3dd805_fk_authentik FOREIGN KEY (usersourceconnection_ptr_id) REFERENCES public.authentik_core_usersourceconnection(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_saml_samlsource authentik_sources_sa_pre_authentication_f_cec52f8b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_saml_samlsource
    ADD CONSTRAINT authentik_sources_sa_pre_authentication_f_cec52f8b_fk_authentik FOREIGN KEY (pre_authentication_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_saml_samlsource authentik_sources_sa_signing_kp_id_faae605c_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_saml_samlsource
    ADD CONSTRAINT authentik_sources_sa_signing_kp_id_faae605c_fk_authentik FOREIGN KEY (signing_kp_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_saml_samlsource authentik_sources_sa_source_ptr_id_3381b214_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_saml_samlsource
    ADD CONSTRAINT authentik_sources_sa_source_ptr_id_3381b214_fk_authentik FOREIGN KEY (source_ptr_id) REFERENCES public.authentik_core_source(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_saml_usersamlsourceconnection authentik_sources_sa_usersourceconnection_b6d9dcfe_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_saml_usersamlsourceconnection
    ADD CONSTRAINT authentik_sources_sa_usersourceconnection_b6d9dcfe_fk_authentik FOREIGN KEY (usersourceconnection_ptr_id) REFERENCES public.authentik_core_usersourceconnection(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_sources_saml_samlsource authentik_sources_sa_verification_kp_id_f76620d9_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_sources_saml_samlsource
    ADD CONSTRAINT authentik_sources_sa_verification_kp_id_f76620d9_fk_authentik FOREIGN KEY (verification_kp_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_validate_authenticatorvalida3e25 authentik_stages_aut_authenticatorvalidat_aff63c61_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_validate_authenticatorvalida3e25
    ADD CONSTRAINT authentik_stages_aut_authenticatorvalidat_aff63c61_fk_authentik FOREIGN KEY (authenticatorvalidatestage_id) REFERENCES public.authentik_stages_authenticator_validate_authenticatorvalida499c(stage_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_static_authenticatorstaticstage authentik_stages_aut_configure_flow_id_0e413e4d_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_static_authenticatorstaticstage
    ADD CONSTRAINT authentik_stages_aut_configure_flow_id_0e413e4d_fk_authentik FOREIGN KEY (configure_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_duo_authenticatorduostage authentik_stages_aut_configure_flow_id_4c667db1_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_duo_authenticatorduostage
    ADD CONSTRAINT authentik_stages_aut_configure_flow_id_4c667db1_fk_authentik FOREIGN KEY (configure_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_webauthn_authenticatewebauth4bbe authentik_stages_aut_configure_flow_id_b1d83847_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_webauthn_authenticatewebauth4bbe
    ADD CONSTRAINT authentik_stages_aut_configure_flow_id_b1d83847_fk_authentik FOREIGN KEY (configure_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_totp_authenticatortotpstage authentik_stages_aut_configure_flow_id_e6d859e3_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_totp_authenticatortotpstage
    ADD CONSTRAINT authentik_stages_aut_configure_flow_id_e6d859e3_fk_authentik FOREIGN KEY (configure_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_sms_authenticatorsmsstage authentik_stages_aut_configure_flow_id_ff974e9e_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_sms_authenticatorsmsstage
    ADD CONSTRAINT authentik_stages_aut_configure_flow_id_ff974e9e_fk_authentik FOREIGN KEY (configure_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_sms_authenticatorsmsstage authentik_stages_aut_mapping_id_72d070b3_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_sms_authenticatorsmsstage
    ADD CONSTRAINT authentik_stages_aut_mapping_id_72d070b3_fk_authentik FOREIGN KEY (mapping_id) REFERENCES public.authentik_events_notificationwebhookmapping(propertymapping_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_sms_smsdevice authentik_stages_aut_stage_id_35c87fa6_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_sms_smsdevice
    ADD CONSTRAINT authentik_stages_aut_stage_id_35c87fa6_fk_authentik FOREIGN KEY (stage_id) REFERENCES public.authentik_stages_authenticator_sms_authenticatorsmsstage(stage_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_validate_authenticatorvalida3e25 authentik_stages_aut_stage_id_3c37cac7_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_validate_authenticatorvalida3e25
    ADD CONSTRAINT authentik_stages_aut_stage_id_3c37cac7_fk_authentik FOREIGN KEY (stage_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_duo_duodevice authentik_stages_aut_stage_id_926e33da_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_duo_duodevice
    ADD CONSTRAINT authentik_stages_aut_stage_id_926e33da_fk_authentik FOREIGN KEY (stage_id) REFERENCES public.authentik_stages_authenticator_duo_authenticatorduostage(stage_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_sms_authenticatorsmsstage authentik_stages_aut_stage_ptr_id_4ebb9914_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_sms_authenticatorsmsstage
    ADD CONSTRAINT authentik_stages_aut_stage_ptr_id_4ebb9914_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_webauthn_authenticatewebauth4bbe authentik_stages_aut_stage_ptr_id_67d6ca22_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_webauthn_authenticatewebauth4bbe
    ADD CONSTRAINT authentik_stages_aut_stage_ptr_id_67d6ca22_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_duo_authenticatorduostage authentik_stages_aut_stage_ptr_id_7835ea46_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_duo_authenticatorduostage
    ADD CONSTRAINT authentik_stages_aut_stage_ptr_id_7835ea46_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_totp_authenticatortotpstage authentik_stages_aut_stage_ptr_id_9e1575b0_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_totp_authenticatortotpstage
    ADD CONSTRAINT authentik_stages_aut_stage_ptr_id_9e1575b0_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_static_authenticatorstaticstage authentik_stages_aut_stage_ptr_id_a719c9e1_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_static_authenticatorstaticstage
    ADD CONSTRAINT authentik_stages_aut_stage_ptr_id_a719c9e1_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_validate_authenticatorvalida499c authentik_stages_aut_stage_ptr_id_d44614a3_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_validate_authenticatorvalida499c
    ADD CONSTRAINT authentik_stages_aut_stage_ptr_id_d44614a3_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_webauthn_webauthndevice authentik_stages_aut_user_id_26c9196a_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_webauthn_webauthndevice
    ADD CONSTRAINT authentik_stages_aut_user_id_26c9196a_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_sms_smsdevice authentik_stages_aut_user_id_454934c5_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_sms_smsdevice
    ADD CONSTRAINT authentik_stages_aut_user_id_454934c5_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_duo_duodevice authentik_stages_aut_user_id_bd340329_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_duo_duodevice
    ADD CONSTRAINT authentik_stages_aut_user_id_bd340329_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_captcha_captchastage authentik_stages_cap_stage_ptr_id_6328c33b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_captcha_captchastage
    ADD CONSTRAINT authentik_stages_cap_stage_ptr_id_6328c33b_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_consent_userconsent authentik_stages_con_application_id_ad55f58e_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_consent_userconsent
    ADD CONSTRAINT authentik_stages_con_application_id_ad55f58e_fk_authentik FOREIGN KEY (application_id) REFERENCES public.authentik_core_application(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_consent_consentstage authentik_stages_con_stage_ptr_id_492add69_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_consent_consentstage
    ADD CONSTRAINT authentik_stages_con_stage_ptr_id_492add69_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_consent_userconsent authentik_stages_con_user_id_554dc39f_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_consent_userconsent
    ADD CONSTRAINT authentik_stages_con_user_id_554dc39f_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_deny_denystage authentik_stages_den_stage_ptr_id_5290ec0e_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_deny_denystage
    ADD CONSTRAINT authentik_stages_den_stage_ptr_id_5290ec0e_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_dummy_dummystage authentik_stages_dum_stage_ptr_id_7d72bd43_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_dummy_dummystage
    ADD CONSTRAINT authentik_stages_dum_stage_ptr_id_7d72bd43_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_email_emailstage authentik_stages_ema_stage_ptr_id_7355e8a2_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_email_emailstage
    ADD CONSTRAINT authentik_stages_ema_stage_ptr_id_7355e8a2_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_identification_identificationstage authentik_stages_ide_enrollment_flow_id_930e83ff_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage
    ADD CONSTRAINT authentik_stages_ide_enrollment_flow_id_930e83ff_fk_authentik FOREIGN KEY (enrollment_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_identification_identificationstage_sources authentik_stages_ide_identificationstage__c119703c_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage_sources
    ADD CONSTRAINT authentik_stages_ide_identificationstage__c119703c_fk_authentik FOREIGN KEY (identificationstage_id) REFERENCES public.authentik_stages_identification_identificationstage(stage_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_identification_identificationstage authentik_stages_ide_password_stage_id_8d68497a_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage
    ADD CONSTRAINT authentik_stages_ide_password_stage_id_8d68497a_fk_authentik FOREIGN KEY (password_stage_id) REFERENCES public.authentik_stages_password_passwordstage(stage_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_identification_identificationstage authentik_stages_ide_passwordless_flow_id_68cf3874_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage
    ADD CONSTRAINT authentik_stages_ide_passwordless_flow_id_68cf3874_fk_authentik FOREIGN KEY (passwordless_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_identification_identificationstage authentik_stages_ide_recovery_flow_id_16f5f1c7_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage
    ADD CONSTRAINT authentik_stages_ide_recovery_flow_id_16f5f1c7_fk_authentik FOREIGN KEY (recovery_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_identification_identificationstage_sources authentik_stages_ide_source_id_9579fda9_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage_sources
    ADD CONSTRAINT authentik_stages_ide_source_id_9579fda9_fk_authentik FOREIGN KEY (source_id) REFERENCES public.authentik_core_source(policybindingmodel_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_identification_identificationstage authentik_stages_ide_stage_ptr_id_da7dad55_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_identification_identificationstage
    ADD CONSTRAINT authentik_stages_ide_stage_ptr_id_da7dad55_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_invitation_invitation authentik_stages_inv_created_by_id_87fe9398_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_invitation_invitation
    ADD CONSTRAINT authentik_stages_inv_created_by_id_87fe9398_fk_authentik FOREIGN KEY (created_by_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_invitation_invitation authentik_stages_inv_flow_id_66945236_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_invitation_invitation
    ADD CONSTRAINT authentik_stages_inv_flow_id_66945236_fk_authentik FOREIGN KEY (flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_invitation_invitationstage authentik_stages_inv_stage_ptr_id_fcaca395_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_invitation_invitationstage
    ADD CONSTRAINT authentik_stages_inv_stage_ptr_id_fcaca395_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_password_passwordstage authentik_stages_pas_configure_flow_id_2a91be83_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_password_passwordstage
    ADD CONSTRAINT authentik_stages_pas_configure_flow_id_2a91be83_fk_authentik FOREIGN KEY (configure_flow_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_password_passwordstage authentik_stages_pas_stage_ptr_id_46eda438_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_password_passwordstage
    ADD CONSTRAINT authentik_stages_pas_stage_ptr_id_46eda438_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_prompt_promptstage_validation_policies authentik_stages_pro_policy_id_96db92ab_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage_validation_policies
    ADD CONSTRAINT authentik_stages_pro_policy_id_96db92ab_fk_authentik FOREIGN KEY (policy_id) REFERENCES public.authentik_policies_policy(policy_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_prompt_promptstage_fields authentik_stages_pro_prompt_id_8c79d4c1_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage_fields
    ADD CONSTRAINT authentik_stages_pro_prompt_id_8c79d4c1_fk_authentik FOREIGN KEY (prompt_id) REFERENCES public.authentik_stages_prompt_prompt(prompt_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_prompt_promptstage_validation_policies authentik_stages_pro_promptstage_id_cb253bb1_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage_validation_policies
    ADD CONSTRAINT authentik_stages_pro_promptstage_id_cb253bb1_fk_authentik FOREIGN KEY (promptstage_id) REFERENCES public.authentik_stages_prompt_promptstage(stage_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_prompt_promptstage_fields authentik_stages_pro_promptstage_id_d3bd61cc_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage_fields
    ADD CONSTRAINT authentik_stages_pro_promptstage_id_d3bd61cc_fk_authentik FOREIGN KEY (promptstage_id) REFERENCES public.authentik_stages_prompt_promptstage(stage_ptr_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_prompt_promptstage authentik_stages_pro_stage_ptr_id_285415b5_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_prompt_promptstage
    ADD CONSTRAINT authentik_stages_pro_stage_ptr_id_285415b5_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_user_write_userwritestage authentik_stages_use_create_users_group_i_90b7794f_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_write_userwritestage
    ADD CONSTRAINT authentik_stages_use_create_users_group_i_90b7794f_fk_authentik FOREIGN KEY (create_users_group_id) REFERENCES public.authentik_core_group(group_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_user_write_userwritestage authentik_stages_use_stage_ptr_id_2cc319e1_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_write_userwritestage
    ADD CONSTRAINT authentik_stages_use_stage_ptr_id_2cc319e1_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_user_delete_userdeletestage authentik_stages_use_stage_ptr_id_61292077_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_delete_userdeletestage
    ADD CONSTRAINT authentik_stages_use_stage_ptr_id_61292077_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_user_login_userloginstage authentik_stages_use_stage_ptr_id_b1bc035b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_login_userloginstage
    ADD CONSTRAINT authentik_stages_use_stage_ptr_id_b1bc035b_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_user_logout_userlogoutstage authentik_stages_use_stage_ptr_id_c7d7012d_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_user_logout_userlogoutstage
    ADD CONSTRAINT authentik_stages_use_stage_ptr_id_c7d7012d_fk_authentik FOREIGN KEY (stage_ptr_id) REFERENCES public.authentik_flows_stage(stage_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_tenants_tenant authentik_tenants_te_flow_authentication__7a0889f3_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_tenants_tenant
    ADD CONSTRAINT authentik_tenants_te_flow_authentication__7a0889f3_fk_authentik FOREIGN KEY (flow_authentication_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_tenants_tenant authentik_tenants_te_flow_device_code_id_c8fa4eb4_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_tenants_tenant
    ADD CONSTRAINT authentik_tenants_te_flow_device_code_id_c8fa4eb4_fk_authentik FOREIGN KEY (flow_device_code_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_tenants_tenant authentik_tenants_te_flow_invalidation_id_cedce4a1_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_tenants_tenant
    ADD CONSTRAINT authentik_tenants_te_flow_invalidation_id_cedce4a1_fk_authentik FOREIGN KEY (flow_invalidation_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_tenants_tenant authentik_tenants_te_flow_recovery_id_a08f1692_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_tenants_tenant
    ADD CONSTRAINT authentik_tenants_te_flow_recovery_id_a08f1692_fk_authentik FOREIGN KEY (flow_recovery_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_tenants_tenant authentik_tenants_te_flow_unenrollment_id_73817e72_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_tenants_tenant
    ADD CONSTRAINT authentik_tenants_te_flow_unenrollment_id_73817e72_fk_authentik FOREIGN KEY (flow_unenrollment_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_tenants_tenant authentik_tenants_te_flow_user_settings_i_7592a467_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_tenants_tenant
    ADD CONSTRAINT authentik_tenants_te_flow_user_settings_i_7592a467_fk_authentik FOREIGN KEY (flow_user_settings_id) REFERENCES public.authentik_flows_flow(flow_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_tenants_tenant authentik_tenants_te_web_certificate_id_74429583_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_tenants_tenant
    ADD CONSTRAINT authentik_tenants_te_web_certificate_id_74429583_fk_authentik FOREIGN KEY (web_certificate_id) REFERENCES public.authentik_crypto_certificatekeypair(kp_uuid) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_groupobjectpermission guardian_groupobject_content_type_id_7ade36b8_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobject_content_type_id_7ade36b8_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_groupobjectpermission guardian_groupobject_group_id_4bbbfb62_fk_auth_grou; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobject_group_id_4bbbfb62_fk_auth_grou FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_groupobjectpermission guardian_groupobject_permission_id_36572738_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_groupobjectpermission
    ADD CONSTRAINT guardian_groupobject_permission_id_36572738_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_userobjectpermission guardian_userobjectp_content_type_id_2e892405_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectp_content_type_id_2e892405_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_userobjectpermission guardian_userobjectp_permission_id_71807bfc_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectp_permission_id_71807bfc_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: guardian_userobjectpermission guardian_userobjectp_user_id_d5c1e964_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.guardian_userobjectpermission
    ADD CONSTRAINT guardian_userobjectp_user_id_d5c1e964_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_static_staticdevice otp_static_staticdev_user_id_7f9cff2b_fk_authentik; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_static_staticdevice
    ADD CONSTRAINT otp_static_staticdev_user_id_7f9cff2b_fk_authentik FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_static_statictoken otp_static_statictok_device_id_74b7c7d1_fk_otp_stati; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_static_statictoken
    ADD CONSTRAINT otp_static_statictok_device_id_74b7c7d1_fk_otp_stati FOREIGN KEY (device_id) REFERENCES public.authentik_stages_authenticator_static_staticdevice(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: authentik_stages_authenticator_totp_totpdevice otp_totp_totpdevice_user_id_0fb18292_fk_authentik_core_user_id; Type: FK CONSTRAINT; Schema: public; Owner: authentik
--

ALTER TABLE ONLY public.authentik_stages_authenticator_totp_totpdevice
    ADD CONSTRAINT otp_totp_totpdevice_user_id_0fb18292_fk_authentik_core_user_id FOREIGN KEY (user_id) REFERENCES public.authentik_core_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- PostgreSQL database dump complete
--

