//
// This file is generated by grafana-app-sdk
// DO NOT EDIT
//

package apis

import (
	"encoding/json"
	"fmt"
	"strings"

	"github.com/grafana/grafana-app-sdk/app"
	"github.com/grafana/grafana-app-sdk/resource"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/kube-openapi/pkg/spec3"
	"k8s.io/kube-openapi/pkg/validation/spec"

	v0alpha1 "github.com/grafana/grafana/apps/plugins/pkg/apis/plugins/v0alpha1"
)

var (
	rawSchemaPluginv0alpha1     = []byte(`{"OperatorState":{"additionalProperties":false,"properties":{"descriptiveState":{"description":"descriptiveState is an optional more descriptive state field which has no requirements on format","type":"string"},"details":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"details contains any extra information that is operator-specific","type":"object"},"lastEvaluation":{"description":"lastEvaluation is the ResourceVersion last evaluated","type":"string"},"state":{"description":"state describes the state of the lastEvaluation.\nIt is limited to three possible states for machine evaluation.","enum":["success","in_progress","failed"],"type":"string"}},"required":["lastEvaluation","state"],"type":"object"},"Plugin":{"properties":{"spec":{"$ref":"#/components/schemas/spec"},"status":{"$ref":"#/components/schemas/status"}},"required":["spec"]},"getMetaDependencies":{"type":"object","required":["grafanaDependency"],"properties":{"extensions":{"type":"object","properties":{"exposedComponents":{"description":"+listType=set","type":"array","items":{"type":"string"}}},"additionalProperties":false},"grafanaDependency":{"description":"Required field","type":"string"},"grafanaVersion":{"description":"Optional fields","type":"string"},"plugins":{"description":"+listType=set\n+listMapKey=id","type":"array","items":{"type":"object","required":["id","type","name"],"properties":{"id":{"type":"string"},"name":{"type":"string"},"type":{"type":"string","enum":["app","datasource","panel"]}},"additionalProperties":false}}},"additionalProperties":false},"getMetaEnterpriseFeatures":{"type":"object","properties":{"healthDiagnosticsErrors":{"description":"Allow additional properties","type":"boolean","default":false}},"additionalProperties":false},"getMetaExtensions":{"type":"object","properties":{"addedComponents":{"description":"+listType=atomic","type":"array","items":{"type":"object","required":["targets","title"],"properties":{"description":{"type":"string"},"targets":{"description":"+listType=set","type":"array","items":{"type":"string"}},"title":{"type":"string"}},"additionalProperties":false}},"addedLinks":{"description":"+listType=atomic","type":"array","items":{"type":"object","required":["targets","title"],"properties":{"description":{"type":"string"},"targets":{"description":"+listType=set","type":"array","items":{"type":"string"}},"title":{"type":"string"}},"additionalProperties":false}},"exposedComponents":{"description":"+listType=set\n+listMapKey=id","type":"array","items":{"type":"object","required":["id"],"properties":{"description":{"type":"string"},"id":{"type":"string"},"title":{"type":"string"}},"additionalProperties":false}},"extensionPoints":{"description":"+listType=set\n+listMapKey=id","type":"array","items":{"type":"object","required":["id"],"properties":{"description":{"type":"string"},"id":{"type":"string"},"title":{"type":"string"}},"additionalProperties":false}}},"additionalProperties":false},"getMetaIAM":{"type":"object","properties":{"permissions":{"description":"+listType=atomic","type":"array","items":{"type":"object","properties":{"action":{"type":"string"},"scope":{"type":"string"}},"additionalProperties":false}}},"additionalProperties":false},"getMetaInclude":{"type":"object","properties":{"action":{"type":"string"},"addToNav":{"type":"boolean"},"component":{"type":"string"},"defaultNav":{"type":"boolean"},"icon":{"type":"string"},"name":{"type":"string"},"path":{"type":"string"},"role":{"type":"string","enum":["Admin","Editor","Viewer"]},"type":{"type":"string","enum":["dashboard","page","panel","datasource"]},"uid":{"type":"string"}},"additionalProperties":false},"getMetaInfo":{"type":"object","required":["keywords","logos","updated","version"],"properties":{"author":{"description":"Optional fields","type":"object","properties":{"email":{"type":"string"},"name":{"type":"string"},"url":{"type":"string"}},"additionalProperties":false},"description":{"type":"string"},"keywords":{"description":"Required fields\n+listType=set","type":"array","items":{"type":"string"}},"links":{"description":"+listType=atomic","type":"array","items":{"type":"object","properties":{"name":{"type":"string"},"url":{"type":"string"}},"additionalProperties":false}},"logos":{"type":"object","required":["small","large"],"properties":{"large":{"type":"string"},"small":{"type":"string"}},"additionalProperties":false},"screenshots":{"description":"+listType=atomic","type":"array","items":{"type":"object","properties":{"name":{"type":"string"},"path":{"type":"string"}},"additionalProperties":false}},"updated":{"type":"string","format":"date-time"},"version":{"type":"string"}},"additionalProperties":false},"getMetaQueryOptions":{"type":"object","properties":{"cacheTimeout":{"type":"boolean"},"maxDataPoints":{"type":"boolean"},"minInterval":{"type":"boolean"}},"additionalProperties":false},"getMetaRole":{"type":"object","properties":{"grants":{"description":"+listType=set","type":"array","items":{"type":"string"}},"role":{"type":"object","properties":{"description":{"type":"string"},"name":{"type":"string"},"permissions":{"description":"+listType=atomic","type":"array","items":{"type":"object","properties":{"action":{"type":"string"},"scope":{"type":"string"}},"additionalProperties":false}}},"additionalProperties":false}},"additionalProperties":false},"getMetaRoute":{"type":"object","properties":{"body":{"type":"object","additionalProperties":{"type":"object","additionalProperties":{}}},"headers":{"description":"+listType=atomic","type":"array","items":{"type":"string"}},"jwtTokenAuth":{"type":"object","properties":{"params":{"type":"object","additionalProperties":{"type":"object","additionalProperties":{}}},"scopes":{"description":"+listType=set","type":"array","items":{"type":"string"}},"url":{"type":"string"}},"additionalProperties":false},"method":{"type":"string"},"path":{"type":"string"},"reqAction":{"type":"string"},"reqRole":{"type":"string"},"reqSignedIn":{"type":"boolean"},"tokenAuth":{"type":"object","properties":{"params":{"type":"object","additionalProperties":{"type":"object","additionalProperties":{}}},"scopes":{"description":"+listType=set","type":"array","items":{"type":"string"}},"url":{"type":"string"}},"additionalProperties":false},"url":{"type":"string"},"urlParams":{"description":"+listType=atomic","type":"array","items":{"type":"object","properties":{"content":{"type":"string"},"name":{"type":"string"}},"additionalProperties":false}}},"additionalProperties":false},"spec":{"additionalProperties":false,"properties":{"class":{"enum":["core","external","cdn"],"type":"string"},"id":{"type":"string"},"url":{"type":"string"},"version":{"type":"string"}},"required":["id","version","class"],"type":"object"},"status":{"additionalProperties":false,"properties":{"additionalFields":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"additionalFields is reserved for future use","type":"object"},"operatorStates":{"additionalProperties":{"$ref":"#/components/schemas/OperatorState"},"description":"operatorStates is a map of operator ID to operator state evaluations.\nAny operator which consumes this kind SHOULD add its state evaluation information to this field.","type":"object"}},"type":"object"}}`)
	versionSchemaPluginv0alpha1 app.VersionSchema
	_                           = json.Unmarshal(rawSchemaPluginv0alpha1, &versionSchemaPluginv0alpha1)
)

var appManifestData = app.ManifestData{
	AppName:          "plugins",
	Group:            "plugins.grafana.app",
	PreferredVersion: "v0alpha1",
	Versions: []app.ManifestVersion{
		{
			Name:   "v0alpha1",
			Served: true,
			Kinds: []app.ManifestVersionKind{
				{
					Kind:       "Plugin",
					Plural:     "Plugins",
					Scope:      "Namespaced",
					Conversion: false,
					Schema:     &versionSchemaPluginv0alpha1,
					Routes: map[string]spec3.PathProps{
						"/meta": {
							Get: &spec3.Operation{
								OperationProps: spec3.OperationProps{

									OperationId: "getMeta",

									Responses: &spec3.Responses{
										ResponsesProps: spec3.ResponsesProps{
											Default: &spec3.Response{
												ResponseProps: spec3.ResponseProps{
													Description: "Default OK response",
													Content: map[string]*spec3.MediaType{
														"application/json": {
															MediaTypeProps: spec3.MediaTypeProps{
																Schema: &spec.Schema{
																	SchemaProps: spec.SchemaProps{
																		Type: []string{"object"},
																		Properties: map[string]spec.Schema{
																			"alerting": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"boolean"},
																					Description: "Optional fields",
																				},
																			},
																			"annotations": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"autoEnabled": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"backend": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"buildMode": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"string"},
																				},
																			},
																			"builtIn": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"category": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"string"},
																					Enum: []interface{}{
																						"tsdb",
																						"logging",
																						"cloud",
																						"tracing",
																						"profiling",
																						"sql",
																						"enterprise",
																						"iot",
																						"other",
																					},
																				},
																			},
																			"dependencies": {
																				SchemaProps: spec.SchemaProps{

																					Description: "Dependency information",
																					Ref:         spec.MustCreateRef("#/components/schemas/getMetaDependencies"),
																				},
																			},
																			"enterpriseFeatures": {
																				SchemaProps: spec.SchemaProps{

																					Ref: spec.MustCreateRef("#/components/schemas/getMetaEnterpriseFeatures"),
																				},
																			},
																			"executable": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"string"},
																				},
																			},
																			"extensions": {
																				SchemaProps: spec.SchemaProps{

																					Ref: spec.MustCreateRef("#/components/schemas/getMetaExtensions"),
																				},
																			},
																			"hideFromList": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"iam": {
																				SchemaProps: spec.SchemaProps{

																					Ref: spec.MustCreateRef("#/components/schemas/getMetaIAM"),
																				},
																			},
																			"id": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"string"},
																					Description: "Unique name of the plugin",
																				},
																			},
																			"includes": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"array"},
																					Description: "+listType=atomic",
																				},
																			},
																			"info": {
																				SchemaProps: spec.SchemaProps{

																					Description: "Metadata for the plugin",
																					Ref:         spec.MustCreateRef("#/components/schemas/getMetaInfo"),
																				},
																			},
																			"logs": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"metrics": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"multiValueFilterOperators": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"name": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"string"},
																					Description: "Human-readable name of the plugin",
																				},
																			},
																			"pascalName": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"string"},
																				},
																			},
																			"preload": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"queryOptions": {
																				SchemaProps: spec.SchemaProps{

																					Ref: spec.MustCreateRef("#/components/schemas/getMetaQueryOptions"),
																				},
																			},
																			"roles": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"array"},
																					Description: "+listType=atomic",
																				},
																			},
																			"routes": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"array"},
																					Description: "+listType=atomic",
																				},
																			},
																			"skipDataQuery": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"state": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"string"},
																					Enum: []interface{}{
																						"alpha",
																						"beta",
																					},
																				},
																			},
																			"streaming": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"tracing": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"boolean"},
																				},
																			},
																			"type": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"string"},
																					Description: "Plugin type",
																					Enum: []interface{}{
																						"app",
																						"datasource",
																						"panel",
																						"renderer",
																					},
																				},
																			},
																		},
																		Required: []string{
																			"id",
																			"type",
																			"name",
																			"info",
																			"dependencies",
																		},
																	}},
															}},
													},
												},
											},
										}},
								},
							},
						},
					},
				},
			},
			Routes: app.ManifestVersionRoutes{
				Namespaced: map[string]spec3.PathProps{},
				Cluster:    map[string]spec3.PathProps{},
				Schemas:    map[string]spec.Schema{},
			},
		},
	},
}

func LocalManifest() app.Manifest {
	return app.NewEmbeddedManifest(appManifestData)
}

func RemoteManifest() app.Manifest {
	return app.NewAPIServerManifest("plugins")
}

var kindVersionToGoType = map[string]resource.Kind{
	"Plugin/v0alpha1": v0alpha1.PluginKind(),
}

// ManifestGoTypeAssociator returns the associated resource.Kind instance for a given Kind and Version, if one exists.
// If there is no association for the provided Kind and Version, exists will return false.
func ManifestGoTypeAssociator(kind, version string) (goType resource.Kind, exists bool) {
	goType, exists = kindVersionToGoType[fmt.Sprintf("%s/%s", kind, version)]
	return goType, exists
}

var customRouteToGoResponseType = map[string]any{
	"v0alpha1|Plugin|meta|GET": v0alpha1.GetMeta{},
}

// ManifestCustomRouteResponsesAssociator returns the associated response go type for a given kind, version, custom route path, and method, if one exists.
// kind may be empty for custom routes which are not kind subroutes. Leading slashes are removed from subroute paths.
// If there is no association for the provided kind, version, custom route path, and method, exists will return false.
// Resource routes (those without a kind) should prefix their route with "<namespace>/" if the route is namespaced (otherwise the route is assumed to be cluster-scope)
func ManifestCustomRouteResponsesAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoResponseType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoParamsType = map[string]runtime.Object{}

func ManifestCustomRouteQueryAssociator(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoParamsType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoRequestBodyType = map[string]any{}

func ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoRequestBodyType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

type GoTypeAssociator struct{}

func NewGoTypeAssociator() *GoTypeAssociator {
	return &GoTypeAssociator{}
}

func (g *GoTypeAssociator) KindToGoType(kind, version string) (goType resource.Kind, exists bool) {
	return ManifestGoTypeAssociator(kind, version)
}
func (g *GoTypeAssociator) CustomRouteReturnGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteResponsesAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteQueryGoType(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	return ManifestCustomRouteQueryAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteRequestBodyGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb)
}
