//
// This file is generated by grafana-app-sdk
// DO NOT EDIT
//

package apis

import (
	"encoding/json"
	"fmt"
	"strings"

	"github.com/grafana/grafana-app-sdk/app"
	"github.com/grafana/grafana-app-sdk/resource"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/kube-openapi/pkg/spec3"
	"k8s.io/kube-openapi/pkg/validation/spec"

	v0alpha1 "github.com/grafana/grafana/apps/example/pkg/apis/example/v0alpha1"
	v1alpha1 "github.com/grafana/grafana/apps/example/pkg/apis/example/v1alpha1"
)

var (
	rawSchemaExamplev0alpha1     = []byte(`{"Example":{"properties":{"spec":{"$ref":"#/components/schemas/spec"},"status":{"$ref":"#/components/schemas/status"}},"required":["spec"]},"OperatorState":{"additionalProperties":false,"properties":{"descriptiveState":{"description":"descriptiveState is an optional more descriptive state field which has no requirements on format","type":"string"},"details":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"details contains any extra information that is operator-specific","type":"object"},"lastEvaluation":{"description":"lastEvaluation is the ResourceVersion last evaluated","type":"string"},"state":{"description":"state describes the state of the lastEvaluation.\nIt is limited to three possible states for machine evaluation.","enum":["success","in_progress","failed"],"type":"string"}},"required":["lastEvaluation","state"],"type":"object"},"spec":{"additionalProperties":false,"description":"Spec is the schema of our resource. The spec should include all the user-editable information for the kind.","properties":{"firstField":{"type":"integer"}},"required":["firstField"],"type":"object"},"status":{"additionalProperties":false,"properties":{"additionalFields":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"additionalFields is reserved for future use","type":"object"},"lastObservedGeneration":{"type":"integer"},"operatorStates":{"additionalProperties":{"$ref":"#/components/schemas/OperatorState"},"description":"operatorStates is a map of operator ID to operator state evaluations.\nAny operator which consumes this kind SHOULD add its state evaluation information to this field.","type":"object"}},"required":["lastObservedGeneration"],"type":"object"}}`)
	versionSchemaExamplev0alpha1 app.VersionSchema
	_                            = json.Unmarshal(rawSchemaExamplev0alpha1, &versionSchemaExamplev0alpha1)
	rawSchemaExamplev1alpha1     = []byte(`{"DefinedType":{"additionalProperties":false,"description":"#DefinedType is a re-usable definition for us to use in our schema.\nFields leading with # are definitions in CUE and won't be included in the generated types.","properties":{"info":{"description":"Info is information about this entry. This comment, like all comments\non fields or definitions, will be copied into the generated types as well.","type":"string"},"next":{"$ref":"#/components/schemas/DefinedType","description":"Next is an optional next element in the DefinedType, allowing for a self-referential\nlinked-list like structure. The ? in the field makes this optional."}},"required":["info"],"type":"object"},"Example":{"properties":{"custom":{"$ref":"#/components/schemas/custom"},"spec":{"$ref":"#/components/schemas/spec"},"status":{"$ref":"#/components/schemas/status"}},"required":["spec"]},"OperatorState":{"additionalProperties":false,"properties":{"descriptiveState":{"description":"descriptiveState is an optional more descriptive state field which has no requirements on format","type":"string"},"details":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"details contains any extra information that is operator-specific","type":"object"},"lastEvaluation":{"description":"lastEvaluation is the ResourceVersion last evaluated","type":"string"},"state":{"description":"state describes the state of the lastEvaluation.\nIt is limited to three possible states for machine evaluation.","enum":["success","in_progress","failed"],"type":"string"}},"required":["lastEvaluation","state"],"type":"object"},"custom":{"additionalProperties":false,"description":"Custom is a subresource that will be stored the same way status is stored,\nand requires using the /custom route to update.\nIts content is returned as part of a GET to the resource itself, just like with status.\nTo route a subresource to an arbitrary handler, use the 'routes' field instead (see below).\nmetadata if where kind- and schema-specific metadata goes. This is converted into typed annotations\nwith getters and setters by the code generation.\nmetadata: {\n\tkindSpecificField: string\n}","properties":{"myField":{"type":"string"},"otherField":{"type":"string"}},"required":["myField","otherField"],"type":"object"},"spec":{"additionalProperties":false,"description":"Spec is the schema of our resource. The spec should include all the user-editable information for the kind.","properties":{"firstField":{"description":"Example fields","type":"string"},"list":{"$ref":"#/components/schemas/DefinedType"},"secondField":{"type":"integer"}},"required":["firstField","secondField"],"type":"object"},"status":{"additionalProperties":false,"description":"status is where state and status information which may be used or updated by the operator or back-end should be placed\nIf you do not have any such information, you do not need to include this field,\nhowever, as mentioned above, certain fields will be added by the kind system regardless.","properties":{"additionalFields":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"additionalFields is reserved for future use","type":"object"},"lastObservedGeneration":{"type":"integer"},"operatorStates":{"additionalProperties":{"$ref":"#/components/schemas/OperatorState"},"description":"operatorStates is a map of operator ID to operator state evaluations.\nAny operator which consumes this kind SHOULD add its state evaluation information to this field.","type":"object"}},"required":["lastObservedGeneration"],"type":"object"}}`)
	versionSchemaExamplev1alpha1 app.VersionSchema
	_                            = json.Unmarshal(rawSchemaExamplev1alpha1, &versionSchemaExamplev1alpha1)
)

var appManifestData = app.ManifestData{
	AppName:          "example",
	Group:            "example.grafana.app",
	PreferredVersion: "v1alpha1",
	Versions: []app.ManifestVersion{
		{
			Name:   "v0alpha1",
			Served: false,
			Kinds: []app.ManifestVersionKind{
				{
					Kind:       "Example",
					Plural:     "Examples",
					Scope:      "Namespaced",
					Conversion: true,
					Admission: &app.AdmissionCapabilities{
						Validation: &app.ValidationCapability{
							Operations: []app.AdmissionOperation{
								app.AdmissionOperationCreate,
								app.AdmissionOperationUpdate,
							},
						},
						Mutation: &app.MutationCapability{
							Operations: []app.AdmissionOperation{
								app.AdmissionOperationCreate,
								app.AdmissionOperationUpdate,
							},
						},
					},
					Schema: &versionSchemaExamplev0alpha1,
				},
			},
			Routes: app.ManifestVersionRoutes{
				Namespaced: map[string]spec3.PathProps{},
				Cluster:    map[string]spec3.PathProps{},
			},
		},

		{
			Name:   "v1alpha1",
			Served: false,
			Kinds: []app.ManifestVersionKind{
				{
					Kind:       "Example",
					Plural:     "Examples",
					Scope:      "Namespaced",
					Conversion: true,
					Admission: &app.AdmissionCapabilities{
						Validation: &app.ValidationCapability{
							Operations: []app.AdmissionOperation{
								app.AdmissionOperationCreate,
								app.AdmissionOperationUpdate,
							},
						},
						Mutation: &app.MutationCapability{
							Operations: []app.AdmissionOperation{
								app.AdmissionOperationCreate,
								app.AdmissionOperationUpdate,
							},
						},
					},
					Schema: &versionSchemaExamplev1alpha1,
					Routes: map[string]spec3.PathProps{
						"foo": {
							Get: &spec3.Operation{
								OperationProps: spec3.OperationProps{

									OperationId: "getFoo",

									Parameters: []*spec3.Parameter{

										{
											ParameterProps: spec3.ParameterProps{
												Name: "message",
												In:   "query",
												Schema: &spec.Schema{
													SchemaProps: spec.SchemaProps{
														Type: []string{"string"},
													},
												},
											},
										},
									},

									Responses: &spec3.Responses{
										ResponsesProps: spec3.ResponsesProps{
											Default: &spec3.Response{
												ResponseProps: spec3.ResponseProps{
													Description: "Default OK response",
													Content: map[string]*spec3.MediaType{
														"application/json": {
															MediaTypeProps: spec3.MediaTypeProps{
																Schema: &spec.Schema{
																	SchemaProps: spec.SchemaProps{
																		Type:        []string{"object"},
																		Description: "The response type for the GET /foo method. This will generate a go type, and will also be used for the OpenAPI definition for the route.",
																		Properties: map[string]spec.Schema{
																			"apiVersion": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"string"},
																					Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
																				},
																			},
																			"kind": {
																				SchemaProps: spec.SchemaProps{
																					Type:        []string{"string"},
																					Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
																				},
																			},
																			"message": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"string"},
																				},
																			},
																		},
																		Required: []string{
																			"message",
																			"apiVersion",
																			"kind",
																		},
																	}},
															}},
													},
												},
											},
										}},
								},
							},
						},
					},
				},
			},
			Routes: app.ManifestVersionRoutes{
				Namespaced: map[string]spec3.PathProps{
					"/something": {
						Get: &spec3.Operation{
							OperationProps: spec3.OperationProps{

								OperationId: "getSomething",

								Parameters: []*spec3.Parameter{

									{
										ParameterProps: spec3.ParameterProps{
											Name: "message",
											In:   "query",
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Type: []string{"string"},
												},
											},
										},
									},
								},

								Responses: &spec3.Responses{
									ResponsesProps: spec3.ResponsesProps{
										Default: &spec3.Response{
											ResponseProps: spec3.ResponseProps{
												Description: "Default OK response",
												Content: map[string]*spec3.MediaType{
													"application/json": {
														MediaTypeProps: spec3.MediaTypeProps{
															Schema: &spec.Schema{
																SchemaProps: spec.SchemaProps{
																	Type: []string{"object"},
																	Properties: map[string]spec.Schema{
																		"apiVersion": {
																			SchemaProps: spec.SchemaProps{
																				Type:        []string{"string"},
																				Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
																			},
																		},
																		"kind": {
																			SchemaProps: spec.SchemaProps{
																				Type:        []string{"string"},
																				Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
																			},
																		},
																		"message": {
																			SchemaProps: spec.SchemaProps{
																				Type: []string{"string"},
																			},
																		},
																		"namespace": {
																			SchemaProps: spec.SchemaProps{
																				Type: []string{"string"},
																			},
																		},
																	},
																	Required: []string{
																		"namespace",
																		"message",
																		"apiVersion",
																		"kind",
																	},
																}},
														}},
												},
											},
										},
									}},
							},
						},
					},
				},
				Cluster: map[string]spec3.PathProps{
					"/other": {
						Get: &spec3.Operation{
							OperationProps: spec3.OperationProps{

								OperationId: "getOther",

								Parameters: []*spec3.Parameter{

									{
										ParameterProps: spec3.ParameterProps{
											Name: "message",
											In:   "query",
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Type: []string{"string"},
												},
											},
										},
									},
								},

								Responses: &spec3.Responses{
									ResponsesProps: spec3.ResponsesProps{
										Default: &spec3.Response{
											ResponseProps: spec3.ResponseProps{
												Description: "Default OK response",
												Content: map[string]*spec3.MediaType{
													"application/json": {
														MediaTypeProps: spec3.MediaTypeProps{
															Schema: &spec.Schema{
																SchemaProps: spec.SchemaProps{
																	Type: []string{"object"},
																	Properties: map[string]spec.Schema{
																		"message": {
																			SchemaProps: spec.SchemaProps{
																				Type: []string{"string"},
																			},
																		},
																	},
																	Required: []string{
																		"message",
																	},
																}},
														}},
												},
											},
										},
									}},
							},
						},
					},
				},
			},
		},
	},
}

func LocalManifest() app.Manifest {
	return app.NewEmbeddedManifest(appManifestData)
}

func RemoteManifest() app.Manifest {
	return app.NewAPIServerManifest("example")
}

var kindVersionToGoType = map[string]resource.Kind{
	"Example/v0alpha1": v0alpha1.ExampleKind(),
	"Example/v1alpha1": v1alpha1.ExampleKind(),
}

// ManifestGoTypeAssociator returns the associated resource.Kind instance for a given Kind and Version, if one exists.
// If there is no association for the provided Kind and Version, exists will return false.
func ManifestGoTypeAssociator(kind, version string) (goType resource.Kind, exists bool) {
	goType, exists = kindVersionToGoType[fmt.Sprintf("%s/%s", kind, version)]
	return goType, exists
}

var customRouteToGoResponseType = map[string]any{

	"v1alpha1|Example|foo|GET": v1alpha1.GetFoo{},

	"v1alpha1||<namespace>/something|GET": v1alpha1.GetSomething{},
	"v1alpha1||other|GET":                 v1alpha1.GetOther{},
}

// ManifestCustomRouteResponsesAssociator returns the associated response go type for a given kind, version, custom route path, and method, if one exists.
// kind may be empty for custom routes which are not kind subroutes. Leading slashes are removed from subroute paths.
// If there is no association for the provided kind, version, custom route path, and method, exists will return false.
// Resource routes (those without a kind) should prefix their route with "<namespace>/" if the route is namespaced (otherwise the route is assumed to be cluster-scope)
func ManifestCustomRouteResponsesAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoResponseType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoParamsType = map[string]runtime.Object{
	"v1alpha1|Example|foo|GET": &v1alpha1.GetFooRequestParamsObject{},
}

func ManifestCustomRouteQueryAssociator(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoParamsType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoRequestBodyType = map[string]any{}

func ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoRequestBodyType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

type GoTypeAssociator struct{}

func NewGoTypeAssociator() *GoTypeAssociator {
	return &GoTypeAssociator{}
}

func (g *GoTypeAssociator) KindToGoType(kind, version string) (goType resource.Kind, exists bool) {
	return ManifestGoTypeAssociator(kind, version)
}
func (g *GoTypeAssociator) CustomRouteReturnGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteResponsesAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteQueryGoType(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	return ManifestCustomRouteQueryAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteRequestBodyGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb)
}
