//
// This file is generated by grafana-app-sdk
// DO NOT EDIT
//

package apis

import (
	"encoding/json"
	"fmt"
	"strings"

	"github.com/grafana/grafana-app-sdk/app"
	"github.com/grafana/grafana-app-sdk/resource"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/kube-openapi/pkg/spec3"
	"k8s.io/kube-openapi/pkg/validation/spec"

	v0alpha1 "github.com/grafana/grafana/apps/alerting/rules/pkg/apis/alerting/v0alpha1"
)

var (
	rawSchemaAlertRulev0alpha1         = []byte(`{"AlertRule":{"properties":{"spec":{"$ref":"#/components/schemas/spec"},"status":{"$ref":"#/components/schemas/status"}},"required":["spec"]},"DatasourceUID":{"type":"string"},"Expression":{"additionalProperties":false,"properties":{"datasourceUID":{"$ref":"#/components/schemas/DatasourceUID","description":"The UID of the datasource to run this expression against. If omitted, the expression will be run against the ` + "`" + `__expr__` + "`" + ` datasource"},"model":{"additionalProperties":{},"type":"object"},"queryType":{"description":"The type of query if this is a query expression","type":"string"},"relativeTimeRange":{"$ref":"#/components/schemas/RelativeTimeRange"},"source":{"description":"Used to mark the expression to be used as the final source for the rule evaluation\nOnly one expression in a rule can be marked as the source\nFor AlertRules, this is the expression that will be evaluated against the alerting condition\nFor RecordingRules, this is the expression that will be recorded","type":"boolean"}},"required":["model"],"type":"object"},"ExpressionMap":{"additionalProperties":{"$ref":"#/components/schemas/Expression"},"description":"TODO: validate that only one can specify source=true\n\u0026 struct.MinFields(1) This doesn't work in Cue \u003cv0.12.0 as per","type":"object"},"IntervalTrigger":{"additionalProperties":false,"properties":{"interval":{"$ref":"#/components/schemas/PromDuration"}},"required":["interval"],"type":"object"},"OperatorState":{"additionalProperties":false,"properties":{"descriptiveState":{"description":"descriptiveState is an optional more descriptive state field which has no requirements on format","type":"string"},"details":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"details contains any extra information that is operator-specific","type":"object"},"lastEvaluation":{"description":"lastEvaluation is the ResourceVersion last evaluated","type":"string"},"state":{"description":"state describes the state of the lastEvaluation.\nIt is limited to three possible states for machine evaluation.","enum":["success","in_progress","failed"],"type":"string"}},"required":["lastEvaluation","state"],"type":"object"},"PromDuration":{"type":"string"},"PromDurationWMillis":{"type":"string"},"RelativeTimeRange":{"additionalProperties":false,"properties":{"from":{"$ref":"#/components/schemas/PromDurationWMillis"},"to":{"$ref":"#/components/schemas/PromDurationWMillis"}},"required":["from","to"],"type":"object"},"TemplateString":{"type":"string"},"TimeIntervalRef":{"description":"TODO(@moustafab): validate regex for time interval ref","type":"string"},"spec":{"additionalProperties":false,"properties":{"annotations":{"additionalProperties":{"$ref":"#/components/schemas/TemplateString"},"type":"object"},"execErrState":{"default":"Error","type":"string"},"expressions":{"$ref":"#/components/schemas/ExpressionMap"},"for":{"type":"string"},"keepFiringFor":{"type":"string"},"labels":{"additionalProperties":{"$ref":"#/components/schemas/TemplateString"},"type":"object"},"missingSeriesEvalsToResolve":{"minimum":0,"type":"integer"},"noDataState":{"default":"NoData","type":"string"},"notificationSettings":{"additionalProperties":false,"properties":{"activeTimeIntervals":{"items":{"$ref":"#/components/schemas/TimeIntervalRef"},"type":"array"},"groupBy":{"items":{"type":"string"},"type":"array"},"groupInterval":{"$ref":"#/components/schemas/PromDuration"},"groupWait":{"$ref":"#/components/schemas/PromDuration"},"muteTimeIntervals":{"items":{"$ref":"#/components/schemas/TimeIntervalRef"},"type":"array"},"receiver":{"type":"string"},"repeatInterval":{"$ref":"#/components/schemas/PromDuration"}},"required":["receiver"],"type":"object"},"panelRef":{"additionalProperties":false,"properties":{"dashboardUID":{"minLength":1,"type":"string"},"panelID":{"exclusiveMinimum":true,"minimum":0,"type":"integer"}},"required":["dashboardUID","panelID"],"type":"object"},"paused":{"type":"boolean"},"title":{"type":"string"},"trigger":{"$ref":"#/components/schemas/IntervalTrigger"}},"required":["title","trigger","noDataState","execErrState","expressions"],"type":"object"},"status":{"additionalProperties":false,"properties":{"additionalFields":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"additionalFields is reserved for future use","type":"object"},"operatorStates":{"additionalProperties":{"$ref":"#/components/schemas/OperatorState"},"description":"operatorStates is a map of operator ID to operator state evaluations.\nAny operator which consumes this kind SHOULD add its state evaluation information to this field.","type":"object"}},"type":"object"}}`)
	versionSchemaAlertRulev0alpha1     app.VersionSchema
	_                                  = json.Unmarshal(rawSchemaAlertRulev0alpha1, &versionSchemaAlertRulev0alpha1)
	rawSchemaRecordingRulev0alpha1     = []byte(`{"DatasourceUID":{"type":"string"},"Expression":{"additionalProperties":false,"properties":{"datasourceUID":{"$ref":"#/components/schemas/DatasourceUID","description":"The UID of the datasource to run this expression against. If omitted, the expression will be run against the ` + "`" + `__expr__` + "`" + ` datasource"},"model":{"additionalProperties":{},"type":"object"},"queryType":{"description":"The type of query if this is a query expression","type":"string"},"relativeTimeRange":{"$ref":"#/components/schemas/RelativeTimeRange"},"source":{"description":"Used to mark the expression to be used as the final source for the rule evaluation\nOnly one expression in a rule can be marked as the source\nFor AlertRules, this is the expression that will be evaluated against the alerting condition\nFor RecordingRules, this is the expression that will be recorded","type":"boolean"}},"required":["model"],"type":"object"},"ExpressionMap":{"additionalProperties":{"$ref":"#/components/schemas/Expression"},"description":"TODO: validate that only one can specify source=true\n\u0026 struct.MinFields(1) This doesn't work in Cue \u003cv0.12.0 as per","type":"object"},"IntervalTrigger":{"additionalProperties":false,"properties":{"interval":{"$ref":"#/components/schemas/PromDuration"}},"required":["interval"],"type":"object"},"OperatorState":{"additionalProperties":false,"properties":{"descriptiveState":{"description":"descriptiveState is an optional more descriptive state field which has no requirements on format","type":"string"},"details":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"details contains any extra information that is operator-specific","type":"object"},"lastEvaluation":{"description":"lastEvaluation is the ResourceVersion last evaluated","type":"string"},"state":{"description":"state describes the state of the lastEvaluation.\nIt is limited to three possible states for machine evaluation.","enum":["success","in_progress","failed"],"type":"string"}},"required":["lastEvaluation","state"],"type":"object"},"PromDuration":{"type":"string"},"PromDurationWMillis":{"type":"string"},"RecordingRule":{"properties":{"spec":{"$ref":"#/components/schemas/spec"},"status":{"$ref":"#/components/schemas/status"}},"required":["spec"]},"RelativeTimeRange":{"additionalProperties":false,"properties":{"from":{"$ref":"#/components/schemas/PromDurationWMillis"},"to":{"$ref":"#/components/schemas/PromDurationWMillis"}},"required":["from","to"],"type":"object"},"TemplateString":{"type":"string"},"spec":{"additionalProperties":false,"properties":{"expressions":{"$ref":"#/components/schemas/ExpressionMap"},"labels":{"additionalProperties":{"$ref":"#/components/schemas/TemplateString"},"type":"object"},"metric":{"type":"string"},"paused":{"type":"boolean"},"targetDatasourceUID":{"type":"string"},"title":{"type":"string"},"trigger":{"$ref":"#/components/schemas/IntervalTrigger"}},"required":["title","trigger","metric","expressions","targetDatasourceUID"],"type":"object"},"status":{"additionalProperties":false,"properties":{"additionalFields":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"additionalFields is reserved for future use","type":"object"},"operatorStates":{"additionalProperties":{"$ref":"#/components/schemas/OperatorState"},"description":"operatorStates is a map of operator ID to operator state evaluations.\nAny operator which consumes this kind SHOULD add its state evaluation information to this field.","type":"object"}},"type":"object"}}`)
	versionSchemaRecordingRulev0alpha1 app.VersionSchema
	_                                  = json.Unmarshal(rawSchemaRecordingRulev0alpha1, &versionSchemaRecordingRulev0alpha1)
)

var appManifestData = app.ManifestData{
	AppName:          "alerting",
	Group:            "rules.alerting.grafana.app",
	PreferredVersion: "v0alpha1",
	Versions: []app.ManifestVersion{
		{
			Name:   "v0alpha1",
			Served: true,
			Kinds: []app.ManifestVersionKind{
				{
					Kind:       "AlertRule",
					Plural:     "AlertRules",
					Scope:      "Namespaced",
					Conversion: false,
					Schema:     &versionSchemaAlertRulev0alpha1,
					SelectableFields: []string{
						"spec.title",
						"spec.paused",
						"spec.panelRef.dashboardUID",
						"spec.panelRef.panelID",
						"spec.notificationSettings.receiver",
					},
				},

				{
					Kind:       "RecordingRule",
					Plural:     "RecordingRules",
					Scope:      "Namespaced",
					Conversion: false,
					Schema:     &versionSchemaRecordingRulev0alpha1,
					SelectableFields: []string{
						"spec.title",
						"spec.paused",
					},
				},
			},
			Routes: app.ManifestVersionRoutes{
				Namespaced: map[string]spec3.PathProps{},
				Cluster:    map[string]spec3.PathProps{},
				Schemas:    map[string]spec.Schema{},
			},
		},
	},
}

func LocalManifest() app.Manifest {
	return app.NewEmbeddedManifest(appManifestData)
}

func RemoteManifest() app.Manifest {
	return app.NewAPIServerManifest("alerting")
}

var kindVersionToGoType = map[string]resource.Kind{
	"AlertRule/v0alpha1":     v0alpha1.AlertRuleKind(),
	"RecordingRule/v0alpha1": v0alpha1.RecordingRuleKind(),
}

// ManifestGoTypeAssociator returns the associated resource.Kind instance for a given Kind and Version, if one exists.
// If there is no association for the provided Kind and Version, exists will return false.
func ManifestGoTypeAssociator(kind, version string) (goType resource.Kind, exists bool) {
	goType, exists = kindVersionToGoType[fmt.Sprintf("%s/%s", kind, version)]
	return goType, exists
}

var customRouteToGoResponseType = map[string]any{}

// ManifestCustomRouteResponsesAssociator returns the associated response go type for a given kind, version, custom route path, and method, if one exists.
// kind may be empty for custom routes which are not kind subroutes. Leading slashes are removed from subroute paths.
// If there is no association for the provided kind, version, custom route path, and method, exists will return false.
// Resource routes (those without a kind) should prefix their route with "<namespace>/" if the route is namespaced (otherwise the route is assumed to be cluster-scope)
func ManifestCustomRouteResponsesAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoResponseType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoParamsType = map[string]runtime.Object{}

func ManifestCustomRouteQueryAssociator(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoParamsType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoRequestBodyType = map[string]any{}

func ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoRequestBodyType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

type GoTypeAssociator struct{}

func NewGoTypeAssociator() *GoTypeAssociator {
	return &GoTypeAssociator{}
}

func (g *GoTypeAssociator) KindToGoType(kind, version string) (goType resource.Kind, exists bool) {
	return ManifestGoTypeAssociator(kind, version)
}
func (g *GoTypeAssociator) CustomRouteReturnGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteResponsesAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteQueryGoType(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	return ManifestCustomRouteQueryAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteRequestBodyGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb)
}
