# Contributing to SmtpMock

Please take a moment to review this document in order to make the contribution process easy and effective for everyone involved.

Following these guidelines helps to communicate that you respect the time of the developers managing and developing this open source project. In return, they should reciprocate that respect in addressing your issue or assessing patches and features.

## Using the issue tracker

The issue tracker is the preferred channel for [issue/bug reports](#issuebug-reports), [feature requests](#feature-requests), [questions](#questions) and submitting [pull requests](#pull-requests).

## Issue/bug reports

A bug is a _demonstrable problem_ that is caused by the code in the repository. Good bug reports are extremely helpful - thank you!

Guidelines for issue/bug reports:

1. **Use the GitHub issue search** &mdash; check if the issue has already been reported
2. **Check if the issue has been fixed** &mdash; try to reproduce it using the latest `master` or `develop` branch in the repository
3. SmtpMock [issue template](.github/ISSUE_TEMPLATE/issue_report.md)/[bug template](.github/ISSUE_TEMPLATE/bug_report.md)

A good bug report shouldn't leave others needing to chase you up for more information. Please try to be as detailed as possible in your report. What is your environment? What steps will reproduce the issue? What would you expect to be the outcome? All these details will help people to fix any potential bugs.

## Feature requests

Feature requests are welcome. But take a moment to find out whether your idea fits with the scope and aims of the project. It's up to _you_ to make a strong case to convince the project's developers of the merits of this feature. Please provide as much detail and context as possible.

## Questions

We're always open to a new conversations. So if you have any questions just ask us.

## Pull requests

Good pull requests - patches, improvements, new features - are a fantastic help. They should remain focused in scope and avoid containing unrelated commits.

**Please ask first** before embarking on any significant pull request (e.g. implementing features, refactoring code, porting to a different language), otherwise you risk spending a lot of time working on something that the project's developers might not want to merge into the project.

Please adhere to the coding conventions used throughout a project (indentation, accurate comments, etc.) and any other requirements (such as test coverage). Not all features proposed will be added but we are open to having a conversation about a feature you are championing.

Guidelines for pull requests:

1. SmtpMock [pull request template](.github/PULL_REQUEST_TEMPLATE.md)
2. Fork the repo, checkout to `develop` branch
3. Run the tests. This is to make sure your starting point works
4. Read our [branch naming convention](.github/BRANCH_NAMING_CONVENTION.md)
5. Create a new branch and make your changes. This includes tests for features!
6. Push to your fork and submit a pull request to `develop` branch
