// Code generated by go-swagger; DO NOT EDIT.

package sync_team_groups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetTeamGroupsAPIReader is a Reader for the GetTeamGroupsAPI structure.
type GetTeamGroupsAPIReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetTeamGroupsAPIReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetTeamGroupsAPIOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetTeamGroupsAPIBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetTeamGroupsAPIUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetTeamGroupsAPIForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetTeamGroupsAPINotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetTeamGroupsAPIInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /teams/{teamId}/groups] getTeamGroupsApi", response, response.Code())
	}
}

// NewGetTeamGroupsAPIOK creates a GetTeamGroupsAPIOK with default headers values
func NewGetTeamGroupsAPIOK() *GetTeamGroupsAPIOK {
	return &GetTeamGroupsAPIOK{}
}

/*
GetTeamGroupsAPIOK describes a response with status code 200, with default header values.

(empty)
*/
type GetTeamGroupsAPIOK struct {
	Payload []*models.TeamGroupDTO
}

// IsSuccess returns true when this get team groups Api Ok response has a 2xx status code
func (o *GetTeamGroupsAPIOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get team groups Api Ok response has a 3xx status code
func (o *GetTeamGroupsAPIOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get team groups Api Ok response has a 4xx status code
func (o *GetTeamGroupsAPIOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get team groups Api Ok response has a 5xx status code
func (o *GetTeamGroupsAPIOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get team groups Api Ok response a status code equal to that given
func (o *GetTeamGroupsAPIOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get team groups Api Ok response
func (o *GetTeamGroupsAPIOK) Code() int {
	return 200
}

func (o *GetTeamGroupsAPIOK) Error() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiOk  %+v", 200, o.Payload)
}

func (o *GetTeamGroupsAPIOK) String() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiOk  %+v", 200, o.Payload)
}

func (o *GetTeamGroupsAPIOK) GetPayload() []*models.TeamGroupDTO {
	return o.Payload
}

func (o *GetTeamGroupsAPIOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTeamGroupsAPIBadRequest creates a GetTeamGroupsAPIBadRequest with default headers values
func NewGetTeamGroupsAPIBadRequest() *GetTeamGroupsAPIBadRequest {
	return &GetTeamGroupsAPIBadRequest{}
}

/*
GetTeamGroupsAPIBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetTeamGroupsAPIBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get team groups Api bad request response has a 2xx status code
func (o *GetTeamGroupsAPIBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get team groups Api bad request response has a 3xx status code
func (o *GetTeamGroupsAPIBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get team groups Api bad request response has a 4xx status code
func (o *GetTeamGroupsAPIBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get team groups Api bad request response has a 5xx status code
func (o *GetTeamGroupsAPIBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get team groups Api bad request response a status code equal to that given
func (o *GetTeamGroupsAPIBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get team groups Api bad request response
func (o *GetTeamGroupsAPIBadRequest) Code() int {
	return 400
}

func (o *GetTeamGroupsAPIBadRequest) Error() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiBadRequest  %+v", 400, o.Payload)
}

func (o *GetTeamGroupsAPIBadRequest) String() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiBadRequest  %+v", 400, o.Payload)
}

func (o *GetTeamGroupsAPIBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetTeamGroupsAPIBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTeamGroupsAPIUnauthorized creates a GetTeamGroupsAPIUnauthorized with default headers values
func NewGetTeamGroupsAPIUnauthorized() *GetTeamGroupsAPIUnauthorized {
	return &GetTeamGroupsAPIUnauthorized{}
}

/*
GetTeamGroupsAPIUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetTeamGroupsAPIUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get team groups Api unauthorized response has a 2xx status code
func (o *GetTeamGroupsAPIUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get team groups Api unauthorized response has a 3xx status code
func (o *GetTeamGroupsAPIUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get team groups Api unauthorized response has a 4xx status code
func (o *GetTeamGroupsAPIUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get team groups Api unauthorized response has a 5xx status code
func (o *GetTeamGroupsAPIUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get team groups Api unauthorized response a status code equal to that given
func (o *GetTeamGroupsAPIUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get team groups Api unauthorized response
func (o *GetTeamGroupsAPIUnauthorized) Code() int {
	return 401
}

func (o *GetTeamGroupsAPIUnauthorized) Error() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiUnauthorized  %+v", 401, o.Payload)
}

func (o *GetTeamGroupsAPIUnauthorized) String() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiUnauthorized  %+v", 401, o.Payload)
}

func (o *GetTeamGroupsAPIUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetTeamGroupsAPIUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTeamGroupsAPIForbidden creates a GetTeamGroupsAPIForbidden with default headers values
func NewGetTeamGroupsAPIForbidden() *GetTeamGroupsAPIForbidden {
	return &GetTeamGroupsAPIForbidden{}
}

/*
GetTeamGroupsAPIForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetTeamGroupsAPIForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get team groups Api forbidden response has a 2xx status code
func (o *GetTeamGroupsAPIForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get team groups Api forbidden response has a 3xx status code
func (o *GetTeamGroupsAPIForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get team groups Api forbidden response has a 4xx status code
func (o *GetTeamGroupsAPIForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get team groups Api forbidden response has a 5xx status code
func (o *GetTeamGroupsAPIForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get team groups Api forbidden response a status code equal to that given
func (o *GetTeamGroupsAPIForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get team groups Api forbidden response
func (o *GetTeamGroupsAPIForbidden) Code() int {
	return 403
}

func (o *GetTeamGroupsAPIForbidden) Error() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiForbidden  %+v", 403, o.Payload)
}

func (o *GetTeamGroupsAPIForbidden) String() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiForbidden  %+v", 403, o.Payload)
}

func (o *GetTeamGroupsAPIForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetTeamGroupsAPIForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTeamGroupsAPINotFound creates a GetTeamGroupsAPINotFound with default headers values
func NewGetTeamGroupsAPINotFound() *GetTeamGroupsAPINotFound {
	return &GetTeamGroupsAPINotFound{}
}

/*
GetTeamGroupsAPINotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetTeamGroupsAPINotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get team groups Api not found response has a 2xx status code
func (o *GetTeamGroupsAPINotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get team groups Api not found response has a 3xx status code
func (o *GetTeamGroupsAPINotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get team groups Api not found response has a 4xx status code
func (o *GetTeamGroupsAPINotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get team groups Api not found response has a 5xx status code
func (o *GetTeamGroupsAPINotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get team groups Api not found response a status code equal to that given
func (o *GetTeamGroupsAPINotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get team groups Api not found response
func (o *GetTeamGroupsAPINotFound) Code() int {
	return 404
}

func (o *GetTeamGroupsAPINotFound) Error() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiNotFound  %+v", 404, o.Payload)
}

func (o *GetTeamGroupsAPINotFound) String() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiNotFound  %+v", 404, o.Payload)
}

func (o *GetTeamGroupsAPINotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetTeamGroupsAPINotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTeamGroupsAPIInternalServerError creates a GetTeamGroupsAPIInternalServerError with default headers values
func NewGetTeamGroupsAPIInternalServerError() *GetTeamGroupsAPIInternalServerError {
	return &GetTeamGroupsAPIInternalServerError{}
}

/*
GetTeamGroupsAPIInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetTeamGroupsAPIInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get team groups Api internal server error response has a 2xx status code
func (o *GetTeamGroupsAPIInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get team groups Api internal server error response has a 3xx status code
func (o *GetTeamGroupsAPIInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get team groups Api internal server error response has a 4xx status code
func (o *GetTeamGroupsAPIInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get team groups Api internal server error response has a 5xx status code
func (o *GetTeamGroupsAPIInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get team groups Api internal server error response a status code equal to that given
func (o *GetTeamGroupsAPIInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get team groups Api internal server error response
func (o *GetTeamGroupsAPIInternalServerError) Code() int {
	return 500
}

func (o *GetTeamGroupsAPIInternalServerError) Error() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiInternalServerError  %+v", 500, o.Payload)
}

func (o *GetTeamGroupsAPIInternalServerError) String() string {
	return fmt.Sprintf("[GET /teams/{teamId}/groups][%d] getTeamGroupsApiInternalServerError  %+v", 500, o.Payload)
}

func (o *GetTeamGroupsAPIInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetTeamGroupsAPIInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
