// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetReportReader is a Reader for the GetReport structure.
type GetReportReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetReportReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetReportOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetReportBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetReportUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetReportForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetReportNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetReportInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /reports/{id}] getReport", response, response.Code())
	}
}

// NewGetReportOK creates a GetReportOK with default headers values
func NewGetReportOK() *GetReportOK {
	return &GetReportOK{}
}

/*
GetReportOK describes a response with status code 200, with default header values.

(empty)
*/
type GetReportOK struct {
	Payload *models.ConfigDTO
}

// IsSuccess returns true when this get report Ok response has a 2xx status code
func (o *GetReportOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get report Ok response has a 3xx status code
func (o *GetReportOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report Ok response has a 4xx status code
func (o *GetReportOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get report Ok response has a 5xx status code
func (o *GetReportOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get report Ok response a status code equal to that given
func (o *GetReportOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get report Ok response
func (o *GetReportOK) Code() int {
	return 200
}

func (o *GetReportOK) Error() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportOk  %+v", 200, o.Payload)
}

func (o *GetReportOK) String() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportOk  %+v", 200, o.Payload)
}

func (o *GetReportOK) GetPayload() *models.ConfigDTO {
	return o.Payload
}

func (o *GetReportOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConfigDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportBadRequest creates a GetReportBadRequest with default headers values
func NewGetReportBadRequest() *GetReportBadRequest {
	return &GetReportBadRequest{}
}

/*
GetReportBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetReportBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get report bad request response has a 2xx status code
func (o *GetReportBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get report bad request response has a 3xx status code
func (o *GetReportBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report bad request response has a 4xx status code
func (o *GetReportBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get report bad request response has a 5xx status code
func (o *GetReportBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get report bad request response a status code equal to that given
func (o *GetReportBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get report bad request response
func (o *GetReportBadRequest) Code() int {
	return 400
}

func (o *GetReportBadRequest) Error() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportBadRequest  %+v", 400, o.Payload)
}

func (o *GetReportBadRequest) String() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportBadRequest  %+v", 400, o.Payload)
}

func (o *GetReportBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetReportBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportUnauthorized creates a GetReportUnauthorized with default headers values
func NewGetReportUnauthorized() *GetReportUnauthorized {
	return &GetReportUnauthorized{}
}

/*
GetReportUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetReportUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get report unauthorized response has a 2xx status code
func (o *GetReportUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get report unauthorized response has a 3xx status code
func (o *GetReportUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report unauthorized response has a 4xx status code
func (o *GetReportUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get report unauthorized response has a 5xx status code
func (o *GetReportUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get report unauthorized response a status code equal to that given
func (o *GetReportUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get report unauthorized response
func (o *GetReportUnauthorized) Code() int {
	return 401
}

func (o *GetReportUnauthorized) Error() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportUnauthorized  %+v", 401, o.Payload)
}

func (o *GetReportUnauthorized) String() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportUnauthorized  %+v", 401, o.Payload)
}

func (o *GetReportUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetReportUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportForbidden creates a GetReportForbidden with default headers values
func NewGetReportForbidden() *GetReportForbidden {
	return &GetReportForbidden{}
}

/*
GetReportForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetReportForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get report forbidden response has a 2xx status code
func (o *GetReportForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get report forbidden response has a 3xx status code
func (o *GetReportForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report forbidden response has a 4xx status code
func (o *GetReportForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get report forbidden response has a 5xx status code
func (o *GetReportForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get report forbidden response a status code equal to that given
func (o *GetReportForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get report forbidden response
func (o *GetReportForbidden) Code() int {
	return 403
}

func (o *GetReportForbidden) Error() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportForbidden  %+v", 403, o.Payload)
}

func (o *GetReportForbidden) String() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportForbidden  %+v", 403, o.Payload)
}

func (o *GetReportForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetReportForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportNotFound creates a GetReportNotFound with default headers values
func NewGetReportNotFound() *GetReportNotFound {
	return &GetReportNotFound{}
}

/*
GetReportNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetReportNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get report not found response has a 2xx status code
func (o *GetReportNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get report not found response has a 3xx status code
func (o *GetReportNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report not found response has a 4xx status code
func (o *GetReportNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get report not found response has a 5xx status code
func (o *GetReportNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get report not found response a status code equal to that given
func (o *GetReportNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get report not found response
func (o *GetReportNotFound) Code() int {
	return 404
}

func (o *GetReportNotFound) Error() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportNotFound  %+v", 404, o.Payload)
}

func (o *GetReportNotFound) String() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportNotFound  %+v", 404, o.Payload)
}

func (o *GetReportNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetReportNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportInternalServerError creates a GetReportInternalServerError with default headers values
func NewGetReportInternalServerError() *GetReportInternalServerError {
	return &GetReportInternalServerError{}
}

/*
GetReportInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetReportInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get report internal server error response has a 2xx status code
func (o *GetReportInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get report internal server error response has a 3xx status code
func (o *GetReportInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get report internal server error response has a 4xx status code
func (o *GetReportInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get report internal server error response has a 5xx status code
func (o *GetReportInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get report internal server error response a status code equal to that given
func (o *GetReportInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get report internal server error response
func (o *GetReportInternalServerError) Code() int {
	return 500
}

func (o *GetReportInternalServerError) Error() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportInternalServerError  %+v", 500, o.Payload)
}

func (o *GetReportInternalServerError) String() string {
	return fmt.Sprintf("[GET /reports/{id}][%d] getReportInternalServerError  %+v", 500, o.Payload)
}

func (o *GetReportInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetReportInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
