// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// RemoveUserRoleReader is a Reader for the RemoveUserRole structure.
type RemoveUserRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RemoveUserRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRemoveUserRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRemoveUserRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRemoveUserRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRemoveUserRoleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRemoveUserRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /access-control/users/{userId}/roles/{roleUID}] removeUserRole", response, response.Code())
	}
}

// NewRemoveUserRoleOK creates a RemoveUserRoleOK with default headers values
func NewRemoveUserRoleOK() *RemoveUserRoleOK {
	return &RemoveUserRoleOK{}
}

/*
RemoveUserRoleOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type RemoveUserRoleOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this remove user role Ok response has a 2xx status code
func (o *RemoveUserRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this remove user role Ok response has a 3xx status code
func (o *RemoveUserRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove user role Ok response has a 4xx status code
func (o *RemoveUserRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this remove user role Ok response has a 5xx status code
func (o *RemoveUserRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this remove user role Ok response a status code equal to that given
func (o *RemoveUserRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the remove user role Ok response
func (o *RemoveUserRoleOK) Code() int {
	return 200
}

func (o *RemoveUserRoleOK) Error() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleOk  %+v", 200, o.Payload)
}

func (o *RemoveUserRoleOK) String() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleOk  %+v", 200, o.Payload)
}

func (o *RemoveUserRoleOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *RemoveUserRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRemoveUserRoleBadRequest creates a RemoveUserRoleBadRequest with default headers values
func NewRemoveUserRoleBadRequest() *RemoveUserRoleBadRequest {
	return &RemoveUserRoleBadRequest{}
}

/*
RemoveUserRoleBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type RemoveUserRoleBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this remove user role bad request response has a 2xx status code
func (o *RemoveUserRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this remove user role bad request response has a 3xx status code
func (o *RemoveUserRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove user role bad request response has a 4xx status code
func (o *RemoveUserRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this remove user role bad request response has a 5xx status code
func (o *RemoveUserRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this remove user role bad request response a status code equal to that given
func (o *RemoveUserRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the remove user role bad request response
func (o *RemoveUserRoleBadRequest) Code() int {
	return 400
}

func (o *RemoveUserRoleBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleBadRequest  %+v", 400, o.Payload)
}

func (o *RemoveUserRoleBadRequest) String() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleBadRequest  %+v", 400, o.Payload)
}

func (o *RemoveUserRoleBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RemoveUserRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRemoveUserRoleForbidden creates a RemoveUserRoleForbidden with default headers values
func NewRemoveUserRoleForbidden() *RemoveUserRoleForbidden {
	return &RemoveUserRoleForbidden{}
}

/*
RemoveUserRoleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type RemoveUserRoleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this remove user role forbidden response has a 2xx status code
func (o *RemoveUserRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this remove user role forbidden response has a 3xx status code
func (o *RemoveUserRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove user role forbidden response has a 4xx status code
func (o *RemoveUserRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this remove user role forbidden response has a 5xx status code
func (o *RemoveUserRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this remove user role forbidden response a status code equal to that given
func (o *RemoveUserRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the remove user role forbidden response
func (o *RemoveUserRoleForbidden) Code() int {
	return 403
}

func (o *RemoveUserRoleForbidden) Error() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleForbidden  %+v", 403, o.Payload)
}

func (o *RemoveUserRoleForbidden) String() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleForbidden  %+v", 403, o.Payload)
}

func (o *RemoveUserRoleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RemoveUserRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRemoveUserRoleNotFound creates a RemoveUserRoleNotFound with default headers values
func NewRemoveUserRoleNotFound() *RemoveUserRoleNotFound {
	return &RemoveUserRoleNotFound{}
}

/*
RemoveUserRoleNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type RemoveUserRoleNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this remove user role not found response has a 2xx status code
func (o *RemoveUserRoleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this remove user role not found response has a 3xx status code
func (o *RemoveUserRoleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove user role not found response has a 4xx status code
func (o *RemoveUserRoleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this remove user role not found response has a 5xx status code
func (o *RemoveUserRoleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this remove user role not found response a status code equal to that given
func (o *RemoveUserRoleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the remove user role not found response
func (o *RemoveUserRoleNotFound) Code() int {
	return 404
}

func (o *RemoveUserRoleNotFound) Error() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleNotFound  %+v", 404, o.Payload)
}

func (o *RemoveUserRoleNotFound) String() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleNotFound  %+v", 404, o.Payload)
}

func (o *RemoveUserRoleNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RemoveUserRoleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRemoveUserRoleInternalServerError creates a RemoveUserRoleInternalServerError with default headers values
func NewRemoveUserRoleInternalServerError() *RemoveUserRoleInternalServerError {
	return &RemoveUserRoleInternalServerError{}
}

/*
RemoveUserRoleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type RemoveUserRoleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this remove user role internal server error response has a 2xx status code
func (o *RemoveUserRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this remove user role internal server error response has a 3xx status code
func (o *RemoveUserRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove user role internal server error response has a 4xx status code
func (o *RemoveUserRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this remove user role internal server error response has a 5xx status code
func (o *RemoveUserRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this remove user role internal server error response a status code equal to that given
func (o *RemoveUserRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the remove user role internal server error response
func (o *RemoveUserRoleInternalServerError) Code() int {
	return 500
}

func (o *RemoveUserRoleInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *RemoveUserRoleInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /access-control/users/{userId}/roles/{roleUID}][%d] removeUserRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *RemoveUserRoleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RemoveUserRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
