//
//Copyright 2019 The Vitess Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Data definitions for service vtgateservice.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.3
// source: dolthub/vt/vtgate.proto

package vtgate

import (
	binlogdata "github.com/dolthub/vitess/go/vt/proto/binlogdata"
	query "github.com/dolthub/vitess/go/vt/proto/query"
	topodata "github.com/dolthub/vitess/go/vt/proto/topodata"
	vtrpc "github.com/dolthub/vitess/go/vt/proto/vtrpc"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// TransactionMode controls the execution of distributed transaction
// across multiple shards.
type TransactionMode int32

const (
	// UNSPECIFIED uses the transaction mode set by the VTGate flag 'transaction_mode'.
	TransactionMode_UNSPECIFIED TransactionMode = 0
	// SINGLE disallows distributed transactions.
	TransactionMode_SINGLE TransactionMode = 1
	// MULTI allows distributed transactions with best effort commit.
	TransactionMode_MULTI TransactionMode = 2
	// TWOPC is for distributed transactions with atomic commits.
	TransactionMode_TWOPC TransactionMode = 3
)

// Enum value maps for TransactionMode.
var (
	TransactionMode_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "SINGLE",
		2: "MULTI",
		3: "TWOPC",
	}
	TransactionMode_value = map[string]int32{
		"UNSPECIFIED": 0,
		"SINGLE":      1,
		"MULTI":       2,
		"TWOPC":       3,
	}
)

func (x TransactionMode) Enum() *TransactionMode {
	p := new(TransactionMode)
	*p = x
	return p
}

func (x TransactionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_vtgate_proto_enumTypes[0].Descriptor()
}

func (TransactionMode) Type() protoreflect.EnumType {
	return &file_dolthub_vt_vtgate_proto_enumTypes[0]
}

func (x TransactionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionMode.Descriptor instead.
func (TransactionMode) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{0}
}

// CommitOrder is used to designate which of the ShardSessions
// get used for transactions.
type CommitOrder int32

const (
	// NORMAL is the default commit order.
	CommitOrder_NORMAL CommitOrder = 0
	// PRE is used to designate pre_sessions.
	CommitOrder_PRE CommitOrder = 1
	// POST is used to designate post_sessions.
	CommitOrder_POST CommitOrder = 2
	// AUTOCOMMIT is used to run the statement as autocommitted transaction.
	CommitOrder_AUTOCOMMIT CommitOrder = 3
)

// Enum value maps for CommitOrder.
var (
	CommitOrder_name = map[int32]string{
		0: "NORMAL",
		1: "PRE",
		2: "POST",
		3: "AUTOCOMMIT",
	}
	CommitOrder_value = map[string]int32{
		"NORMAL":     0,
		"PRE":        1,
		"POST":       2,
		"AUTOCOMMIT": 3,
	}
)

func (x CommitOrder) Enum() *CommitOrder {
	p := new(CommitOrder)
	*p = x
	return p
}

func (x CommitOrder) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommitOrder) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_vtgate_proto_enumTypes[1].Descriptor()
}

func (CommitOrder) Type() protoreflect.EnumType {
	return &file_dolthub_vt_vtgate_proto_enumTypes[1]
}

func (x CommitOrder) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommitOrder.Descriptor instead.
func (CommitOrder) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{1}
}

// Session objects are exchanged like cookies through various
// calls to VTGate. The behavior differs between V2 & V3 APIs.
// V3 APIs are Execute, ExecuteBatch and StreamExecute. All
// other APIs are V2. For the V3 APIs, the session
// must be sent with every call to Execute or ExecuteBatch.
// For the V2 APIs, Begin does not accept a session. It instead
// returns a brand new one with in_transaction set to true.
// After a call to Commit or Rollback, the session can be
// discarded. If you're not in a transaction, Session is
// an optional parameter for the V2 APIs.
type Session struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// in_transaction is set to true if the session is in a transaction.
	InTransaction bool `protobuf:"varint,1,opt,name=in_transaction,json=inTransaction,proto3" json:"in_transaction,omitempty"`
	// shard_sessions keep track of per-shard transaction info.
	ShardSessions []*Session_ShardSession `protobuf:"bytes,2,rep,name=shard_sessions,json=shardSessions,proto3" json:"shard_sessions,omitempty"`
	// single_db is deprecated. Use transaction_mode instead.
	// The value specifies if the transaction should be restricted
	// to a single shard.
	// TODO(sougou): remove in 3.1
	SingleDb bool `protobuf:"varint,3,opt,name=single_db,json=singleDb,proto3" json:"single_db,omitempty"`
	// autocommit specifies if the session is in autocommit mode.
	// This is used only for V3.
	Autocommit bool `protobuf:"varint,4,opt,name=autocommit,proto3" json:"autocommit,omitempty"`
	// target_string is the target expressed as a string. Valid
	// names are: keyspace:shard@target, keyspace@target or @target.
	// This is used only for V3.
	TargetString string `protobuf:"bytes,5,opt,name=target_string,json=targetString,proto3" json:"target_string,omitempty"`
	// options is used only for V3.
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
	// transaction_mode specifies the current transaction mode.
	TransactionMode TransactionMode `protobuf:"varint,7,opt,name=transaction_mode,json=transactionMode,proto3,enum=dolthub.vt.vtgate.TransactionMode" json:"transaction_mode,omitempty"`
	// warnings contains non-fatal warnings from the previous query
	Warnings []*query.QueryWarning `protobuf:"bytes,8,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// pre_sessions contains sessions that have to be committed first.
	PreSessions []*Session_ShardSession `protobuf:"bytes,9,rep,name=pre_sessions,json=preSessions,proto3" json:"pre_sessions,omitempty"`
	// post_sessions contains sessions that have to be committed last.
	PostSessions []*Session_ShardSession `protobuf:"bytes,10,rep,name=post_sessions,json=postSessions,proto3" json:"post_sessions,omitempty"`
}

func (x *Session) Reset() {
	*x = Session{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Session) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Session) ProtoMessage() {}

func (x *Session) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Session.ProtoReflect.Descriptor instead.
func (*Session) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{0}
}

func (x *Session) GetInTransaction() bool {
	if x != nil {
		return x.InTransaction
	}
	return false
}

func (x *Session) GetShardSessions() []*Session_ShardSession {
	if x != nil {
		return x.ShardSessions
	}
	return nil
}

func (x *Session) GetSingleDb() bool {
	if x != nil {
		return x.SingleDb
	}
	return false
}

func (x *Session) GetAutocommit() bool {
	if x != nil {
		return x.Autocommit
	}
	return false
}

func (x *Session) GetTargetString() string {
	if x != nil {
		return x.TargetString
	}
	return ""
}

func (x *Session) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Session) GetTransactionMode() TransactionMode {
	if x != nil {
		return x.TransactionMode
	}
	return TransactionMode_UNSPECIFIED
}

func (x *Session) GetWarnings() []*query.QueryWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *Session) GetPreSessions() []*Session_ShardSession {
	if x != nil {
		return x.PreSessions
	}
	return nil
}

func (x *Session) GetPostSessions() []*Session_ShardSession {
	if x != nil {
		return x.PostSessions
	}
	return nil
}

// ExecuteRequest is the payload to Execute.
type ExecuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the session state.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// These values are deprecated. Use session instead.
	// TODO(sougou): remove in 3.1
	TabletType       topodata.TabletType   `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	NotInTransaction bool                  `protobuf:"varint,5,opt,name=not_in_transaction,json=notInTransaction,proto3" json:"not_in_transaction,omitempty"`
	KeyspaceShard    string                `protobuf:"bytes,6,opt,name=keyspace_shard,json=keyspaceShard,proto3" json:"keyspace_shard,omitempty"`
	Options          *query.ExecuteOptions `protobuf:"bytes,7,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteRequest) Reset() {
	*x = ExecuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteRequest) ProtoMessage() {}

func (x *ExecuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteRequest.ProtoReflect.Descriptor instead.
func (*ExecuteRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{1}
}

func (x *ExecuteRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ExecuteRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *ExecuteRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *ExecuteRequest) GetNotInTransaction() bool {
	if x != nil {
		return x.NotInTransaction
	}
	return false
}

func (x *ExecuteRequest) GetKeyspaceShard() string {
	if x != nil {
		return x.KeyspaceShard
	}
	return ""
}

func (x *ExecuteRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteResponse is the returned value from Execute.
type ExecuteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// session is the updated session information.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ExecuteResponse) Reset() {
	*x = ExecuteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteResponse) ProtoMessage() {}

func (x *ExecuteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteResponse.ProtoReflect.Descriptor instead.
func (*ExecuteResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{2}
}

func (x *ExecuteResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ExecuteResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// ExecuteShardsRequest is the payload to ExecuteShards.
type ExecuteShardsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// shards to target the query to. A DML can only target one shard.
	Shards []string `protobuf:"bytes,5,rep,name=shards,proto3" json:"shards,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction,proto3" json:"not_in_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteShardsRequest) Reset() {
	*x = ExecuteShardsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteShardsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteShardsRequest) ProtoMessage() {}

func (x *ExecuteShardsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteShardsRequest.ProtoReflect.Descriptor instead.
func (*ExecuteShardsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{3}
}

func (x *ExecuteShardsRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ExecuteShardsRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteShardsRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *ExecuteShardsRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *ExecuteShardsRequest) GetShards() []string {
	if x != nil {
		return x.Shards
	}
	return nil
}

func (x *ExecuteShardsRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *ExecuteShardsRequest) GetNotInTransaction() bool {
	if x != nil {
		return x.NotInTransaction
	}
	return false
}

func (x *ExecuteShardsRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteShardsResponse is the returned value from ExecuteShards.
type ExecuteShardsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ExecuteShardsResponse) Reset() {
	*x = ExecuteShardsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteShardsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteShardsResponse) ProtoMessage() {}

func (x *ExecuteShardsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteShardsResponse.ProtoReflect.Descriptor instead.
func (*ExecuteShardsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{4}
}

func (x *ExecuteShardsResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ExecuteShardsResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteShardsResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// ExecuteKeyspaceIdsRequest is the payload to ExecuteKeyspaceIds.
type ExecuteKeyspaceIdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds [][]byte `protobuf:"bytes,5,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction,proto3" json:"not_in_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteKeyspaceIdsRequest) Reset() {
	*x = ExecuteKeyspaceIdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteKeyspaceIdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteKeyspaceIdsRequest) ProtoMessage() {}

func (x *ExecuteKeyspaceIdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteKeyspaceIdsRequest.ProtoReflect.Descriptor instead.
func (*ExecuteKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{5}
}

func (x *ExecuteKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ExecuteKeyspaceIdsRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteKeyspaceIdsRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *ExecuteKeyspaceIdsRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *ExecuteKeyspaceIdsRequest) GetKeyspaceIds() [][]byte {
	if x != nil {
		return x.KeyspaceIds
	}
	return nil
}

func (x *ExecuteKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *ExecuteKeyspaceIdsRequest) GetNotInTransaction() bool {
	if x != nil {
		return x.NotInTransaction
	}
	return false
}

func (x *ExecuteKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteKeyspaceIdsResponse is the returned value from ExecuteKeyspaceIds.
type ExecuteKeyspaceIdsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ExecuteKeyspaceIdsResponse) Reset() {
	*x = ExecuteKeyspaceIdsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteKeyspaceIdsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteKeyspaceIdsResponse) ProtoMessage() {}

func (x *ExecuteKeyspaceIdsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteKeyspaceIdsResponse.ProtoReflect.Descriptor instead.
func (*ExecuteKeyspaceIdsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{6}
}

func (x *ExecuteKeyspaceIdsResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ExecuteKeyspaceIdsResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteKeyspaceIdsResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// ExecuteKeyRangesRequest is the payload to ExecuteKeyRanges.
type ExecuteKeyRangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// key_ranges contains the list of key ranges affected by this query.
	// Will be used to find the shards to send the query to.
	KeyRanges []*topodata.KeyRange `protobuf:"bytes,5,rep,name=key_ranges,json=keyRanges,proto3" json:"key_ranges,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction,proto3" json:"not_in_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteKeyRangesRequest) Reset() {
	*x = ExecuteKeyRangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteKeyRangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteKeyRangesRequest) ProtoMessage() {}

func (x *ExecuteKeyRangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteKeyRangesRequest.ProtoReflect.Descriptor instead.
func (*ExecuteKeyRangesRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{7}
}

func (x *ExecuteKeyRangesRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ExecuteKeyRangesRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteKeyRangesRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *ExecuteKeyRangesRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *ExecuteKeyRangesRequest) GetKeyRanges() []*topodata.KeyRange {
	if x != nil {
		return x.KeyRanges
	}
	return nil
}

func (x *ExecuteKeyRangesRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *ExecuteKeyRangesRequest) GetNotInTransaction() bool {
	if x != nil {
		return x.NotInTransaction
	}
	return false
}

func (x *ExecuteKeyRangesRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteKeyRangesResponse is the returned value from ExecuteKeyRanges.
type ExecuteKeyRangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ExecuteKeyRangesResponse) Reset() {
	*x = ExecuteKeyRangesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteKeyRangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteKeyRangesResponse) ProtoMessage() {}

func (x *ExecuteKeyRangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteKeyRangesResponse.ProtoReflect.Descriptor instead.
func (*ExecuteKeyRangesResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{8}
}

func (x *ExecuteKeyRangesResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ExecuteKeyRangesResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteKeyRangesResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// ExecuteEntityIdsRequest is the payload to ExecuteEntityIds.
type ExecuteEntityIdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// entity_column_name is the column name to use.
	EntityColumnName string `protobuf:"bytes,5,opt,name=entity_column_name,json=entityColumnName,proto3" json:"entity_column_name,omitempty"`
	// entity_keyspace_ids are pairs of entity_column_name values
	// associated with its corresponding keyspace_id.
	EntityKeyspaceIds []*ExecuteEntityIdsRequest_EntityId `protobuf:"bytes,6,rep,name=entity_keyspace_ids,json=entityKeyspaceIds,proto3" json:"entity_keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,7,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated.
	NotInTransaction bool `protobuf:"varint,8,opt,name=not_in_transaction,json=notInTransaction,proto3" json:"not_in_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,9,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteEntityIdsRequest) Reset() {
	*x = ExecuteEntityIdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteEntityIdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteEntityIdsRequest) ProtoMessage() {}

func (x *ExecuteEntityIdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteEntityIdsRequest.ProtoReflect.Descriptor instead.
func (*ExecuteEntityIdsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{9}
}

func (x *ExecuteEntityIdsRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ExecuteEntityIdsRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteEntityIdsRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *ExecuteEntityIdsRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *ExecuteEntityIdsRequest) GetEntityColumnName() string {
	if x != nil {
		return x.EntityColumnName
	}
	return ""
}

func (x *ExecuteEntityIdsRequest) GetEntityKeyspaceIds() []*ExecuteEntityIdsRequest_EntityId {
	if x != nil {
		return x.EntityKeyspaceIds
	}
	return nil
}

func (x *ExecuteEntityIdsRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *ExecuteEntityIdsRequest) GetNotInTransaction() bool {
	if x != nil {
		return x.NotInTransaction
	}
	return false
}

func (x *ExecuteEntityIdsRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteEntityIdsResponse is the returned value from ExecuteEntityIds.
type ExecuteEntityIdsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ExecuteEntityIdsResponse) Reset() {
	*x = ExecuteEntityIdsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteEntityIdsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteEntityIdsResponse) ProtoMessage() {}

func (x *ExecuteEntityIdsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteEntityIdsResponse.ProtoReflect.Descriptor instead.
func (*ExecuteEntityIdsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{10}
}

func (x *ExecuteEntityIdsResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ExecuteEntityIdsResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteEntityIdsResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// ExecuteBatchRequest is the payload to ExecuteBatch.
type ExecuteBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the session state.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// queries is a list of query and bind variables to execute.
	Queries []*query.BoundQuery `protobuf:"bytes,3,rep,name=queries,proto3" json:"queries,omitempty"`
	// These values are deprecated. Use session instead.
	// TODO(sougou): remove in 3.1
	TabletType    topodata.TabletType   `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	AsTransaction bool                  `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction,proto3" json:"as_transaction,omitempty"`
	KeyspaceShard string                `protobuf:"bytes,6,opt,name=keyspace_shard,json=keyspaceShard,proto3" json:"keyspace_shard,omitempty"`
	Options       *query.ExecuteOptions `protobuf:"bytes,7,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteBatchRequest) Reset() {
	*x = ExecuteBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchRequest) ProtoMessage() {}

func (x *ExecuteBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchRequest.ProtoReflect.Descriptor instead.
func (*ExecuteBatchRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{11}
}

func (x *ExecuteBatchRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ExecuteBatchRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteBatchRequest) GetQueries() []*query.BoundQuery {
	if x != nil {
		return x.Queries
	}
	return nil
}

func (x *ExecuteBatchRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *ExecuteBatchRequest) GetAsTransaction() bool {
	if x != nil {
		return x.AsTransaction
	}
	return false
}

func (x *ExecuteBatchRequest) GetKeyspaceShard() string {
	if x != nil {
		return x.KeyspaceShard
	}
	return ""
}

func (x *ExecuteBatchRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteBatchResponse is the returned value from ExecuteBatch.
type ExecuteBatchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// session is the updated session information.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// results contains the query results, only set if application level error is unset.
	Results []*query.ResultWithError `protobuf:"bytes,3,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *ExecuteBatchResponse) Reset() {
	*x = ExecuteBatchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchResponse) ProtoMessage() {}

func (x *ExecuteBatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchResponse.ProtoReflect.Descriptor instead.
func (*ExecuteBatchResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{12}
}

func (x *ExecuteBatchResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ExecuteBatchResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteBatchResponse) GetResults() []*query.ResultWithError {
	if x != nil {
		return x.Results
	}
	return nil
}

// BoundShardQuery represents a single query request for the
// specified list of shards. This is used in a list for
// ExecuteBatchShardsRequest.
type BoundShardQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// shards to target the query to. A DML can only target one shard.
	Shards []string `protobuf:"bytes,3,rep,name=shards,proto3" json:"shards,omitempty"`
}

func (x *BoundShardQuery) Reset() {
	*x = BoundShardQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundShardQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundShardQuery) ProtoMessage() {}

func (x *BoundShardQuery) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundShardQuery.ProtoReflect.Descriptor instead.
func (*BoundShardQuery) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{13}
}

func (x *BoundShardQuery) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *BoundShardQuery) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *BoundShardQuery) GetShards() []string {
	if x != nil {
		return x.Shards
	}
	return nil
}

// ExecuteBatchShardsRequest is the payload to ExecuteBatchShards
type ExecuteBatchShardsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// queries carries all the queries to execute.
	Queries []*BoundShardQuery `protobuf:"bytes,3,rep,name=queries,proto3" json:"queries,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// as_transaction will execute the queries in this batch in a single transaction per shard, created for this purpose.
	// (this can be seen as adding a 'begin' before and 'commit' after the queries).
	// Only makes sense if tablet_type is master. If set, the Session is ignored.
	AsTransaction bool `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction,proto3" json:"as_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteBatchShardsRequest) Reset() {
	*x = ExecuteBatchShardsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchShardsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchShardsRequest) ProtoMessage() {}

func (x *ExecuteBatchShardsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchShardsRequest.ProtoReflect.Descriptor instead.
func (*ExecuteBatchShardsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{14}
}

func (x *ExecuteBatchShardsRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ExecuteBatchShardsRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteBatchShardsRequest) GetQueries() []*BoundShardQuery {
	if x != nil {
		return x.Queries
	}
	return nil
}

func (x *ExecuteBatchShardsRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *ExecuteBatchShardsRequest) GetAsTransaction() bool {
	if x != nil {
		return x.AsTransaction
	}
	return false
}

func (x *ExecuteBatchShardsRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteBatchShardsResponse is the returned value from ExecuteBatchShards.
type ExecuteBatchShardsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Results []*query.QueryResult `protobuf:"bytes,3,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *ExecuteBatchShardsResponse) Reset() {
	*x = ExecuteBatchShardsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchShardsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchShardsResponse) ProtoMessage() {}

func (x *ExecuteBatchShardsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchShardsResponse.ProtoReflect.Descriptor instead.
func (*ExecuteBatchShardsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{15}
}

func (x *ExecuteBatchShardsResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ExecuteBatchShardsResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteBatchShardsResponse) GetResults() []*query.QueryResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// BoundKeyspaceIdQuery represents a single query request for the
// specified list of keyspace ids. This is used in a list for
// ExecuteBatchKeyspaceIdsRequest.
type BoundKeyspaceIdQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds [][]byte `protobuf:"bytes,3,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
}

func (x *BoundKeyspaceIdQuery) Reset() {
	*x = BoundKeyspaceIdQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundKeyspaceIdQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundKeyspaceIdQuery) ProtoMessage() {}

func (x *BoundKeyspaceIdQuery) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundKeyspaceIdQuery.ProtoReflect.Descriptor instead.
func (*BoundKeyspaceIdQuery) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{16}
}

func (x *BoundKeyspaceIdQuery) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *BoundKeyspaceIdQuery) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *BoundKeyspaceIdQuery) GetKeyspaceIds() [][]byte {
	if x != nil {
		return x.KeyspaceIds
	}
	return nil
}

// ExecuteBatchKeyspaceIdsRequest is the payload to ExecuteBatchKeyspaceId.
type ExecuteBatchKeyspaceIdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session                `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	Queries []*BoundKeyspaceIdQuery `protobuf:"bytes,3,rep,name=queries,proto3" json:"queries,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// as_transaction will execute the queries in this batch in a single transaction per shard, created for this purpose.
	// (this can be seen as adding a 'begin' before and 'commit' after the queries).
	// Only makes sense if tablet_type is master. If set, the Session is ignored.
	AsTransaction bool `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction,proto3" json:"as_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteBatchKeyspaceIdsRequest) Reset() {
	*x = ExecuteBatchKeyspaceIdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchKeyspaceIdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchKeyspaceIdsRequest) ProtoMessage() {}

func (x *ExecuteBatchKeyspaceIdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchKeyspaceIdsRequest.ProtoReflect.Descriptor instead.
func (*ExecuteBatchKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{17}
}

func (x *ExecuteBatchKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ExecuteBatchKeyspaceIdsRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteBatchKeyspaceIdsRequest) GetQueries() []*BoundKeyspaceIdQuery {
	if x != nil {
		return x.Queries
	}
	return nil
}

func (x *ExecuteBatchKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *ExecuteBatchKeyspaceIdsRequest) GetAsTransaction() bool {
	if x != nil {
		return x.AsTransaction
	}
	return false
}

func (x *ExecuteBatchKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteBatchKeyspaceIdsResponse is the returned value from ExecuteBatchKeyspaceId.
type ExecuteBatchKeyspaceIdsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Results []*query.QueryResult `protobuf:"bytes,3,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *ExecuteBatchKeyspaceIdsResponse) Reset() {
	*x = ExecuteBatchKeyspaceIdsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchKeyspaceIdsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchKeyspaceIdsResponse) ProtoMessage() {}

func (x *ExecuteBatchKeyspaceIdsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchKeyspaceIdsResponse.ProtoReflect.Descriptor instead.
func (*ExecuteBatchKeyspaceIdsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{18}
}

func (x *ExecuteBatchKeyspaceIdsResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ExecuteBatchKeyspaceIdsResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *ExecuteBatchKeyspaceIdsResponse) GetResults() []*query.QueryResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// StreamExecuteRequest is the payload to StreamExecute.
type StreamExecuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// These values are deprecated. Use session instead.
	// TODO(sougou): remove in 3.1
	TabletType    topodata.TabletType   `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	KeyspaceShard string                `protobuf:"bytes,4,opt,name=keyspace_shard,json=keyspaceShard,proto3" json:"keyspace_shard,omitempty"`
	Options       *query.ExecuteOptions `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`
	// session carries the session state.
	Session *Session `protobuf:"bytes,6,opt,name=session,proto3" json:"session,omitempty"`
}

func (x *StreamExecuteRequest) Reset() {
	*x = StreamExecuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteRequest) ProtoMessage() {}

func (x *StreamExecuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteRequest.ProtoReflect.Descriptor instead.
func (*StreamExecuteRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{19}
}

func (x *StreamExecuteRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *StreamExecuteRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *StreamExecuteRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *StreamExecuteRequest) GetKeyspaceShard() string {
	if x != nil {
		return x.KeyspaceShard
	}
	return ""
}

func (x *StreamExecuteRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *StreamExecuteRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

// StreamExecuteResponse is the returned value from StreamExecute.
// The session is currently not returned because StreamExecute is
// not expected to modify it.
type StreamExecuteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *StreamExecuteResponse) Reset() {
	*x = StreamExecuteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteResponse) ProtoMessage() {}

func (x *StreamExecuteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteResponse.ProtoReflect.Descriptor instead.
func (*StreamExecuteResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{20}
}

func (x *StreamExecuteResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// StreamExecuteShardsRequest is the payload to StreamExecuteShards.
type StreamExecuteShardsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// shards to target the query to.
	Shards []string `protobuf:"bytes,4,rep,name=shards,proto3" json:"shards,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *StreamExecuteShardsRequest) Reset() {
	*x = StreamExecuteShardsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteShardsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteShardsRequest) ProtoMessage() {}

func (x *StreamExecuteShardsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteShardsRequest.ProtoReflect.Descriptor instead.
func (*StreamExecuteShardsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{21}
}

func (x *StreamExecuteShardsRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *StreamExecuteShardsRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *StreamExecuteShardsRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *StreamExecuteShardsRequest) GetShards() []string {
	if x != nil {
		return x.Shards
	}
	return nil
}

func (x *StreamExecuteShardsRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *StreamExecuteShardsRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// StreamExecuteShardsResponse is the returned value from StreamExecuteShards.
type StreamExecuteShardsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *StreamExecuteShardsResponse) Reset() {
	*x = StreamExecuteShardsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteShardsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteShardsResponse) ProtoMessage() {}

func (x *StreamExecuteShardsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteShardsResponse.ProtoReflect.Descriptor instead.
func (*StreamExecuteShardsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{22}
}

func (x *StreamExecuteShardsResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// StreamExecuteKeyspaceIdsRequest is the payload to StreamExecuteKeyspaceIds.
type StreamExecuteKeyspaceIdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds [][]byte `protobuf:"bytes,4,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *StreamExecuteKeyspaceIdsRequest) Reset() {
	*x = StreamExecuteKeyspaceIdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteKeyspaceIdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteKeyspaceIdsRequest) ProtoMessage() {}

func (x *StreamExecuteKeyspaceIdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteKeyspaceIdsRequest.ProtoReflect.Descriptor instead.
func (*StreamExecuteKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{23}
}

func (x *StreamExecuteKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *StreamExecuteKeyspaceIdsRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *StreamExecuteKeyspaceIdsRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *StreamExecuteKeyspaceIdsRequest) GetKeyspaceIds() [][]byte {
	if x != nil {
		return x.KeyspaceIds
	}
	return nil
}

func (x *StreamExecuteKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *StreamExecuteKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// StreamExecuteKeyspaceIdsResponse is the returned value from StreamExecuteKeyspaceIds.
type StreamExecuteKeyspaceIdsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *StreamExecuteKeyspaceIdsResponse) Reset() {
	*x = StreamExecuteKeyspaceIdsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteKeyspaceIdsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteKeyspaceIdsResponse) ProtoMessage() {}

func (x *StreamExecuteKeyspaceIdsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteKeyspaceIdsResponse.ProtoReflect.Descriptor instead.
func (*StreamExecuteKeyspaceIdsResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{24}
}

func (x *StreamExecuteKeyspaceIdsResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// StreamExecuteKeyRangesRequest is the payload to StreamExecuteKeyRanges.
type StreamExecuteKeyRangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// key_ranges contains the list of key ranges affected by this query.
	// Will be used to find the shards to send the query to.
	KeyRanges []*topodata.KeyRange `protobuf:"bytes,4,rep,name=key_ranges,json=keyRanges,proto3" json:"key_ranges,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *StreamExecuteKeyRangesRequest) Reset() {
	*x = StreamExecuteKeyRangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteKeyRangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteKeyRangesRequest) ProtoMessage() {}

func (x *StreamExecuteKeyRangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteKeyRangesRequest.ProtoReflect.Descriptor instead.
func (*StreamExecuteKeyRangesRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{25}
}

func (x *StreamExecuteKeyRangesRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *StreamExecuteKeyRangesRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *StreamExecuteKeyRangesRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *StreamExecuteKeyRangesRequest) GetKeyRanges() []*topodata.KeyRange {
	if x != nil {
		return x.KeyRanges
	}
	return nil
}

func (x *StreamExecuteKeyRangesRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *StreamExecuteKeyRangesRequest) GetOptions() *query.ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// StreamExecuteKeyRangesResponse is the returned value from StreamExecuteKeyRanges.
type StreamExecuteKeyRangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *StreamExecuteKeyRangesResponse) Reset() {
	*x = StreamExecuteKeyRangesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteKeyRangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteKeyRangesResponse) ProtoMessage() {}

func (x *StreamExecuteKeyRangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteKeyRangesResponse.ProtoReflect.Descriptor instead.
func (*StreamExecuteKeyRangesResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{26}
}

func (x *StreamExecuteKeyRangesResponse) GetResult() *query.QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// BeginRequest is the payload to Begin.
type BeginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// single_db is deprecated. Use transaction_mode instead.
	// The value specifies if the transaction should be restricted
	// to a single database.
	// TODO(sougou): remove in 3.1
	SingleDb bool `protobuf:"varint,2,opt,name=single_db,json=singleDb,proto3" json:"single_db,omitempty"`
}

func (x *BeginRequest) Reset() {
	*x = BeginRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginRequest) ProtoMessage() {}

func (x *BeginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginRequest.ProtoReflect.Descriptor instead.
func (*BeginRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{27}
}

func (x *BeginRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *BeginRequest) GetSingleDb() bool {
	if x != nil {
		return x.SingleDb
	}
	return false
}

// BeginResponse is the returned value from Begin.
type BeginResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// session is the initial session information to use for subsequent queries.
	Session *Session `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
}

func (x *BeginResponse) Reset() {
	*x = BeginResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginResponse) ProtoMessage() {}

func (x *BeginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginResponse.ProtoReflect.Descriptor instead.
func (*BeginResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{28}
}

func (x *BeginResponse) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

// CommitRequest is the payload to Commit.
type CommitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the current transaction data to commit.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	// atomic is deprecated. Use transaction_mode instead.
	// The value specifies if the commit should go through the
	// 2PC workflow to ensure atomicity.
	// TODO(sougou): remove in 3.1
	Atomic bool `protobuf:"varint,3,opt,name=atomic,proto3" json:"atomic,omitempty"`
}

func (x *CommitRequest) Reset() {
	*x = CommitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRequest) ProtoMessage() {}

func (x *CommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRequest.ProtoReflect.Descriptor instead.
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{29}
}

func (x *CommitRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *CommitRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

func (x *CommitRequest) GetAtomic() bool {
	if x != nil {
		return x.Atomic
	}
	return false
}

// CommitResponse is the returned value from Commit.
type CommitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommitResponse) Reset() {
	*x = CommitResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse) ProtoMessage() {}

func (x *CommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse.ProtoReflect.Descriptor instead.
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{30}
}

// RollbackRequest is the payload to Rollback.
type RollbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// session carries the current transaction data to rollback.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
}

func (x *RollbackRequest) Reset() {
	*x = RollbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackRequest) ProtoMessage() {}

func (x *RollbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackRequest.ProtoReflect.Descriptor instead.
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{31}
}

func (x *RollbackRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *RollbackRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

// RollbackResponse is the returned value from Rollback.
type RollbackResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RollbackResponse) Reset() {
	*x = RollbackResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackResponse) ProtoMessage() {}

func (x *RollbackResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackResponse.ProtoReflect.Descriptor instead.
func (*RollbackResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{32}
}

// ResolveTransactionRequest is the payload to ResolveTransaction.
type ResolveTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// dtid is the dtid of the transaction to be resolved.
	Dtid string `protobuf:"bytes,2,opt,name=dtid,proto3" json:"dtid,omitempty"`
}

func (x *ResolveTransactionRequest) Reset() {
	*x = ResolveTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveTransactionRequest) ProtoMessage() {}

func (x *ResolveTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveTransactionRequest.ProtoReflect.Descriptor instead.
func (*ResolveTransactionRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{33}
}

func (x *ResolveTransactionRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *ResolveTransactionRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

// MessageStreamRequest is the request payload for MessageStream.
type MessageStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// shard to target the query to, for unsharded keyspaces.
	Shard string `protobuf:"bytes,3,opt,name=shard,proto3" json:"shard,omitempty"`
	// KeyRange to target the query to, for sharded keyspaces.
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// name is the message table name.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *MessageStreamRequest) Reset() {
	*x = MessageStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageStreamRequest) ProtoMessage() {}

func (x *MessageStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageStreamRequest.ProtoReflect.Descriptor instead.
func (*MessageStreamRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{34}
}

func (x *MessageStreamRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *MessageStreamRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *MessageStreamRequest) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

func (x *MessageStreamRequest) GetKeyRange() *topodata.KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

func (x *MessageStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// MessageAckRequest is the request payload for MessageAck.
type MessageAckRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// keyspace to target the message to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// name is the message table name.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// ids is the list of ids to ack.
	Ids []*query.Value `protobuf:"bytes,4,rep,name=ids,proto3" json:"ids,omitempty"`
}

func (x *MessageAckRequest) Reset() {
	*x = MessageAckRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageAckRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageAckRequest) ProtoMessage() {}

func (x *MessageAckRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageAckRequest.ProtoReflect.Descriptor instead.
func (*MessageAckRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{35}
}

func (x *MessageAckRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *MessageAckRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *MessageAckRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MessageAckRequest) GetIds() []*query.Value {
	if x != nil {
		return x.Ids
	}
	return nil
}

// IdKeyspaceId represents an id and keyspace_id pair.
// The kesypace_id represents the routing info for id.
type IdKeyspaceId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// id represents the message id.
	Id *query.Value `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// keyspace_id is the associated keyspace_id for the id.
	KeyspaceId []byte `protobuf:"bytes,2,opt,name=keyspace_id,json=keyspaceId,proto3" json:"keyspace_id,omitempty"`
}

func (x *IdKeyspaceId) Reset() {
	*x = IdKeyspaceId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdKeyspaceId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdKeyspaceId) ProtoMessage() {}

func (x *IdKeyspaceId) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdKeyspaceId.ProtoReflect.Descriptor instead.
func (*IdKeyspaceId) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{36}
}

func (x *IdKeyspaceId) GetId() *query.Value {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *IdKeyspaceId) GetKeyspaceId() []byte {
	if x != nil {
		return x.KeyspaceId
	}
	return nil
}

// MessageAckKeyspaceIdsRequest is the payload to MessageAckKeyspaceIds.
type MessageAckKeyspaceIdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// Optional keyspace for message table.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// name is the message table name.
	Name          string          `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	IdKeyspaceIds []*IdKeyspaceId `protobuf:"bytes,4,rep,name=id_keyspace_ids,json=idKeyspaceIds,proto3" json:"id_keyspace_ids,omitempty"`
}

func (x *MessageAckKeyspaceIdsRequest) Reset() {
	*x = MessageAckKeyspaceIdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageAckKeyspaceIdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageAckKeyspaceIdsRequest) ProtoMessage() {}

func (x *MessageAckKeyspaceIdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageAckKeyspaceIdsRequest.ProtoReflect.Descriptor instead.
func (*MessageAckKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{37}
}

func (x *MessageAckKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *MessageAckKeyspaceIdsRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *MessageAckKeyspaceIdsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MessageAckKeyspaceIdsRequest) GetIdKeyspaceIds() []*IdKeyspaceId {
	if x != nil {
		return x.IdKeyspaceIds
	}
	return nil
}

// ResolveTransactionResponse is the returned value from Rollback.
type ResolveTransactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResolveTransactionResponse) Reset() {
	*x = ResolveTransactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveTransactionResponse) ProtoMessage() {}

func (x *ResolveTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveTransactionResponse.ProtoReflect.Descriptor instead.
func (*ResolveTransactionResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{38}
}

// SplitQueryRequest is the payload to SplitQuery.
//
// SplitQuery takes a "SELECT" query and generates a list of queries called
// "query-parts". Each query-part consists of the original query with an
// added WHERE clause that restricts the query-part to operate only on
// rows whose values in the columns listed in the "split_column" field
// of the request (see below) are in a particular range.
//
// It is guaranteed that the set of rows obtained from
// executing each query-part on a database snapshot
// and merging (without deduping) the results is equal to the set of rows
// obtained from executing the original query on the same snapshot
// with the rows containing NULL values in any of the split_column's excluded.
//
// This is typically called by the MapReduce master when reading from Vitess.
// There it's desirable that the sets of rows returned by the query-parts
// have roughly the same size.
type SplitQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// The query and bind variables to produce splits for.
	// The given query must be a simple query of the form
	// SELECT <cols> FROM <table> WHERE <filter>.
	// It must not contain subqueries nor any of the keywords
	// JOIN, GROUP BY, ORDER BY, LIMIT, DISTINCT.
	// Furthermore, <table> must be a single "concrete" table.
	// It cannot be a view.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// Each generated query-part will be restricted to rows whose values
	// in the columns listed in this field are in a particular range.
	// The list of columns named here must be a prefix of the list of
	// columns defining some index or primary key of the table
	// referenced in 'query'. For many tables using the primary key columns
	// (in order) is sufficient and this is the default if this field is omitted.
	// See the comment on the 'algorithm' field for more restrictions and
	// information.
	SplitColumn []string `protobuf:"bytes,4,rep,name=split_column,json=splitColumn,proto3" json:"split_column,omitempty"`
	// You can specify either an estimate of the number of query-parts to
	// generate or an estimate of the number of rows each query-part should
	// return.
	// Thus, exactly one of split_count or num_rows_per_query_part
	// should be nonzero.
	// The non-given parameter is calculated from the given parameter
	// using the formula: split_count * num_rows_per_query_pary = table_size,
	// where table_size is an approximation of the number of rows in the
	// table.
	// Note that if "split_count" is given it is regarded as an estimate.
	// The number of query-parts returned may differ slightly (in particular,
	// if it's not a whole multiple of the number of vitess shards).
	SplitCount          int64 `protobuf:"varint,5,opt,name=split_count,json=splitCount,proto3" json:"split_count,omitempty"`
	NumRowsPerQueryPart int64 `protobuf:"varint,6,opt,name=num_rows_per_query_part,json=numRowsPerQueryPart,proto3" json:"num_rows_per_query_part,omitempty"`
	// The algorithm to use to split the query. The split algorithm is performed
	// on each database shard in parallel. The lists of query-parts generated
	// by the shards are merged and returned to the caller.
	// Two algorithms are supported:
	//  EQUAL_SPLITS
	//    If this algorithm is selected then only the first 'split_column' given
	//    is used (or the first primary key column if the 'split_column' field is
	//    empty). In the rest of this algorithm's description, we refer to
	//    this column as "the split column".
	//    The split column must have numeric type (integral or floating point).
	//    The algorithm works by taking the interval [min, max], where min and
	//    max are the minimum and maximum values of the split column in
	//    the table-shard, respectively, and partitioning it into 'split_count'
	//    sub-intervals of equal size. The added WHERE clause of each query-part
	//    restricts that part to rows whose value in the split column belongs to
	//    a particular sub-interval. This is fast, but requires that the
	//    distribution of values of the split column be uniform in [min, max]
	//    for the number of rows returned by each query part to be roughly the
	//    same.
	//  FULL_SCAN
	//    If this algorithm is used then the split_column must be the primary key
	//    columns (in order).
	//    This algorithm performs a full-scan of the table-shard referenced
	//    in 'query' to get "boundary" rows that are num_rows_per_query_part
	//    apart when the table is ordered by the columns listed in
	//    'split_column'. It then restricts each query-part to the rows
	//    located between two successive boundary rows.
	//    This algorithm supports multiple split_column's of any type,
	//    but is slower than EQUAL_SPLITS.
	Algorithm query.SplitQueryRequest_Algorithm `protobuf:"varint,7,opt,name=algorithm,proto3,enum=dolthub.vt.query.SplitQueryRequest_Algorithm" json:"algorithm,omitempty"`
	// TODO(erez): This field is no longer used by the server code.
	// Remove this field after this new server code is released to prod.
	// We must keep it for now, so that clients can still send it to the old
	// server code currently in production.
	UseSplitQueryV2 bool `protobuf:"varint,8,opt,name=use_split_query_v2,json=useSplitQueryV2,proto3" json:"use_split_query_v2,omitempty"`
}

func (x *SplitQueryRequest) Reset() {
	*x = SplitQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitQueryRequest) ProtoMessage() {}

func (x *SplitQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitQueryRequest.ProtoReflect.Descriptor instead.
func (*SplitQueryRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{39}
}

func (x *SplitQueryRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *SplitQueryRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *SplitQueryRequest) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *SplitQueryRequest) GetSplitColumn() []string {
	if x != nil {
		return x.SplitColumn
	}
	return nil
}

func (x *SplitQueryRequest) GetSplitCount() int64 {
	if x != nil {
		return x.SplitCount
	}
	return 0
}

func (x *SplitQueryRequest) GetNumRowsPerQueryPart() int64 {
	if x != nil {
		return x.NumRowsPerQueryPart
	}
	return 0
}

func (x *SplitQueryRequest) GetAlgorithm() query.SplitQueryRequest_Algorithm {
	if x != nil {
		return x.Algorithm
	}
	return query.SplitQueryRequest_Algorithm(0)
}

func (x *SplitQueryRequest) GetUseSplitQueryV2() bool {
	if x != nil {
		return x.UseSplitQueryV2
	}
	return false
}

// SplitQueryResponse is the returned value from SplitQuery.
type SplitQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// splits contains the queries to run to fetch the entire data set.
	Splits []*SplitQueryResponse_Part `protobuf:"bytes,1,rep,name=splits,proto3" json:"splits,omitempty"`
}

func (x *SplitQueryResponse) Reset() {
	*x = SplitQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitQueryResponse) ProtoMessage() {}

func (x *SplitQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitQueryResponse.ProtoReflect.Descriptor instead.
func (*SplitQueryResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{40}
}

func (x *SplitQueryResponse) GetSplits() []*SplitQueryResponse_Part {
	if x != nil {
		return x.Splits
	}
	return nil
}

// GetSrvKeyspaceRequest is the payload to GetSrvKeyspace.
type GetSrvKeyspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// keyspace name to fetch.
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
}

func (x *GetSrvKeyspaceRequest) Reset() {
	*x = GetSrvKeyspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSrvKeyspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSrvKeyspaceRequest) ProtoMessage() {}

func (x *GetSrvKeyspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSrvKeyspaceRequest.ProtoReflect.Descriptor instead.
func (*GetSrvKeyspaceRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{41}
}

func (x *GetSrvKeyspaceRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

// GetSrvKeyspaceResponse is the returned value from GetSrvKeyspace.
type GetSrvKeyspaceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// srv_keyspace is the topology object for the SrvKeyspace.
	SrvKeyspace *topodata.SrvKeyspace `protobuf:"bytes,1,opt,name=srv_keyspace,json=srvKeyspace,proto3" json:"srv_keyspace,omitempty"`
}

func (x *GetSrvKeyspaceResponse) Reset() {
	*x = GetSrvKeyspaceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSrvKeyspaceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSrvKeyspaceResponse) ProtoMessage() {}

func (x *GetSrvKeyspaceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSrvKeyspaceResponse.ProtoReflect.Descriptor instead.
func (*GetSrvKeyspaceResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{42}
}

func (x *GetSrvKeyspaceResponse) GetSrvKeyspace() *topodata.SrvKeyspace {
	if x != nil {
		return x.SrvKeyspace
	}
	return nil
}

// VStreamRequest is the payload for VStream.
type VStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CallerId   *vtrpc.CallerID     `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	TabletType topodata.TabletType `protobuf:"varint,2,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// position specifies the starting point of the bin log positions
	// as well as the keyspace-shards to pull events from.
	// position is of the form 'ks1:0@MySQL56/<mysql_pos>|ks2:-80@MySQL56/<mysql_pos>'.
	Vgtid  *binlogdata.VGtid  `protobuf:"bytes,3,opt,name=vgtid,proto3" json:"vgtid,omitempty"`
	Filter *binlogdata.Filter `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *VStreamRequest) Reset() {
	*x = VStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VStreamRequest) ProtoMessage() {}

func (x *VStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VStreamRequest.ProtoReflect.Descriptor instead.
func (*VStreamRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{43}
}

func (x *VStreamRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *VStreamRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *VStreamRequest) GetVgtid() *binlogdata.VGtid {
	if x != nil {
		return x.Vgtid
	}
	return nil
}

func (x *VStreamRequest) GetFilter() *binlogdata.Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// VStreamResponse is streamed by VStream.
type VStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Events []*binlogdata.VEvent `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
}

func (x *VStreamResponse) Reset() {
	*x = VStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VStreamResponse) ProtoMessage() {}

func (x *VStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VStreamResponse.ProtoReflect.Descriptor instead.
func (*VStreamResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{44}
}

func (x *VStreamResponse) GetEvents() []*binlogdata.VEvent {
	if x != nil {
		return x.Events
	}
	return nil
}

// UpdateStreamRequest is the payload to UpdateStream.
type UpdateStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// shard to target the query to, for unsharded keyspaces.
	Shard string `protobuf:"bytes,3,opt,name=shard,proto3" json:"shard,omitempty"`
	// KeyRange to target the query to, for sharded keyspaces.
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// tablet_type is the type of tablets that this request is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// timestamp is the timestamp to start the stream from.  It is
	// unused is event is set, and we are only streaming from the shard
	// described by event.shard.
	Timestamp int64 `protobuf:"varint,6,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// event is the event to start the stream from.
	// Note it is only used if we are streaming from exactly the same shard
	// as this event was coming from. Otherwise we can't use this event,
	// and will use the timestamp as a starting point.
	Event *query.EventToken `protobuf:"bytes,7,opt,name=event,proto3" json:"event,omitempty"`
}

func (x *UpdateStreamRequest) Reset() {
	*x = UpdateStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStreamRequest) ProtoMessage() {}

func (x *UpdateStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateStreamRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{45}
}

func (x *UpdateStreamRequest) GetCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.CallerId
	}
	return nil
}

func (x *UpdateStreamRequest) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *UpdateStreamRequest) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

func (x *UpdateStreamRequest) GetKeyRange() *topodata.KeyRange {
	if x != nil {
		return x.KeyRange
	}
	return nil
}

func (x *UpdateStreamRequest) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *UpdateStreamRequest) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *UpdateStreamRequest) GetEvent() *query.EventToken {
	if x != nil {
		return x.Event
	}
	return nil
}

// UpdateStreamResponse is streamed by UpdateStream.
type UpdateStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// event is one event from the stream.
	Event *query.StreamEvent `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
	// resume_timestamp is the timestamp to resume streaming from if the
	// client is interrupted. If the Update Stream only goes to one
	// shard, this is equal to event.timestamp. If the Update Stream
	// goes to multiple shards and aggregates, this is the minimum value
	// of the current timestamp for all shards.
	ResumeTimestamp int64 `protobuf:"varint,2,opt,name=resume_timestamp,json=resumeTimestamp,proto3" json:"resume_timestamp,omitempty"`
}

func (x *UpdateStreamResponse) Reset() {
	*x = UpdateStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStreamResponse) ProtoMessage() {}

func (x *UpdateStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStreamResponse.ProtoReflect.Descriptor instead.
func (*UpdateStreamResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{46}
}

func (x *UpdateStreamResponse) GetEvent() *query.StreamEvent {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *UpdateStreamResponse) GetResumeTimestamp() int64 {
	if x != nil {
		return x.ResumeTimestamp
	}
	return 0
}

type Session_ShardSession struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Target        *query.Target `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId int64         `protobuf:"varint,2,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *Session_ShardSession) Reset() {
	*x = Session_ShardSession{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Session_ShardSession) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Session_ShardSession) ProtoMessage() {}

func (x *Session_ShardSession) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Session_ShardSession.ProtoReflect.Descriptor instead.
func (*Session_ShardSession) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Session_ShardSession) GetTarget() *query.Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *Session_ShardSession) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

type ExecuteEntityIdsRequest_EntityId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// type is the type of the entity's value. Can be NULL_TYPE.
	Type query.Type `protobuf:"varint,1,opt,name=type,proto3,enum=dolthub.vt.query.Type" json:"type,omitempty"`
	// value is the value for the entity. Not set if type is NULL_TYPE.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// keyspace_id is the associated keyspace_id for the entity.
	KeyspaceId []byte `protobuf:"bytes,3,opt,name=keyspace_id,json=keyspaceId,proto3" json:"keyspace_id,omitempty"`
}

func (x *ExecuteEntityIdsRequest_EntityId) Reset() {
	*x = ExecuteEntityIdsRequest_EntityId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteEntityIdsRequest_EntityId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteEntityIdsRequest_EntityId) ProtoMessage() {}

func (x *ExecuteEntityIdsRequest_EntityId) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteEntityIdsRequest_EntityId.ProtoReflect.Descriptor instead.
func (*ExecuteEntityIdsRequest_EntityId) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{9, 0}
}

func (x *ExecuteEntityIdsRequest_EntityId) GetType() query.Type {
	if x != nil {
		return x.Type
	}
	return query.Type(0)
}

func (x *ExecuteEntityIdsRequest_EntityId) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ExecuteEntityIdsRequest_EntityId) GetKeyspaceId() []byte {
	if x != nil {
		return x.KeyspaceId
	}
	return nil
}

type SplitQueryResponse_KeyRangePart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// key ranges to target the query to.
	KeyRanges []*topodata.KeyRange `protobuf:"bytes,2,rep,name=key_ranges,json=keyRanges,proto3" json:"key_ranges,omitempty"`
}

func (x *SplitQueryResponse_KeyRangePart) Reset() {
	*x = SplitQueryResponse_KeyRangePart{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitQueryResponse_KeyRangePart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitQueryResponse_KeyRangePart) ProtoMessage() {}

func (x *SplitQueryResponse_KeyRangePart) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitQueryResponse_KeyRangePart.ProtoReflect.Descriptor instead.
func (*SplitQueryResponse_KeyRangePart) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{40, 0}
}

func (x *SplitQueryResponse_KeyRangePart) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *SplitQueryResponse_KeyRangePart) GetKeyRanges() []*topodata.KeyRange {
	if x != nil {
		return x.KeyRanges
	}
	return nil
}

type SplitQueryResponse_ShardPart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// shards to target the query to.
	Shards []string `protobuf:"bytes,2,rep,name=shards,proto3" json:"shards,omitempty"`
}

func (x *SplitQueryResponse_ShardPart) Reset() {
	*x = SplitQueryResponse_ShardPart{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitQueryResponse_ShardPart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitQueryResponse_ShardPart) ProtoMessage() {}

func (x *SplitQueryResponse_ShardPart) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitQueryResponse_ShardPart.ProtoReflect.Descriptor instead.
func (*SplitQueryResponse_ShardPart) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{40, 1}
}

func (x *SplitQueryResponse_ShardPart) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *SplitQueryResponse_ShardPart) GetShards() []string {
	if x != nil {
		return x.Shards
	}
	return nil
}

type SplitQueryResponse_Part struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// key_range_part is set if the query should be executed by
	// ExecuteKeyRanges.
	KeyRangePart *SplitQueryResponse_KeyRangePart `protobuf:"bytes,2,opt,name=key_range_part,json=keyRangePart,proto3" json:"key_range_part,omitempty"`
	// shard_part is set if the query should be executed by ExecuteShards.
	ShardPart *SplitQueryResponse_ShardPart `protobuf:"bytes,3,opt,name=shard_part,json=shardPart,proto3" json:"shard_part,omitempty"`
	// size is the approximate number of rows this query will return.
	Size int64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *SplitQueryResponse_Part) Reset() {
	*x = SplitQueryResponse_Part{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_vtgate_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitQueryResponse_Part) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitQueryResponse_Part) ProtoMessage() {}

func (x *SplitQueryResponse_Part) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_vtgate_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitQueryResponse_Part.ProtoReflect.Descriptor instead.
func (*SplitQueryResponse_Part) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_vtgate_proto_rawDescGZIP(), []int{40, 2}
}

func (x *SplitQueryResponse_Part) GetQuery() *query.BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *SplitQueryResponse_Part) GetKeyRangePart() *SplitQueryResponse_KeyRangePart {
	if x != nil {
		return x.KeyRangePart
	}
	return nil
}

func (x *SplitQueryResponse_Part) GetShardPart() *SplitQueryResponse_ShardPart {
	if x != nil {
		return x.ShardPart
	}
	return nil
}

func (x *SplitQueryResponse_Part) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

var File_dolthub_vt_vtgate_proto protoreflect.FileDescriptor

var file_dolthub_vt_vtgate_proto_rawDesc = []byte{
	0x0a, 0x17, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x76, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x1a, 0x1b, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x74, 0x6f,
	0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xac, 0x05, 0x0a, 0x07, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x25, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0e, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x68, 0x61, 0x72, 0x64, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x5f, 0x64, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x44, 0x62, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x22, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x4a, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x70, 0x72, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c, 0x0a, 0x0d,
	0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x70, 0x6f,
	0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x67, 0x0a, 0x0c, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x22, 0x86, 0x03, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74,
	0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6e,
	0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x6b, 0x65, 0x79,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb0, 0x01, 0x0a,
	0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22,
	0x99, 0x03, 0x0a, 0x14, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6b,
	0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b,
	0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6e,
	0x6f, 0x74, 0x49, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb6, 0x01, 0x0a, 0x15,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x22, 0xa9, 0x03, 0x0a, 0x19, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x07, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x49, 0x64, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xbb, 0x01, 0x0a, 0x1a, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70,
	0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xc2,
	0x03, 0x0a, 0x17, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63,
	0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1a, 0x0a,
	0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x0a, 0x6b, 0x65, 0x79,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x6b, 0x65,
	0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x6f, 0x74,
	0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xb9, 0x01, 0x0a, 0x18, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4b,
	0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22,
	0x86, 0x05, 0x0a, 0x17, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x49, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70,
	0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1a,
	0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x13, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x52, 0x11, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x40, 0x0a,
	0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x2c, 0x0a, 0x12, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6e, 0x6f, 0x74,
	0x49, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x6d, 0x0a, 0x08, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6b, 0x65, 0x79, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x6b, 0x65,
	0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x22, 0xb9, 0x01, 0x0a, 0x18, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x22, 0x88, 0x03, 0x0a, 0x13, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x07, 0x71,
	0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61,
	0x73, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e,
	0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xbb, 0x01, 0x0a, 0x14, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x3b, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x57, 0x69, 0x74, 0x68, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x79, 0x0a,
	0x0f, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x68, 0x61, 0x72, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x22, 0xed, 0x02, 0x0a, 0x19, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74,
	0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61,
	0x73, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xbd, 0x01, 0x0a, 0x1a, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x37, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x89, 0x01, 0x0a, 0x14, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x49, 0x64, 0x73, 0x22, 0xf7, 0x02, 0x0a, 0x1e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76,
	0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61,
	0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x73, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xc2,
	0x01, 0x0a, 0x1f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4b,
	0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x07, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x22, 0xde, 0x02, 0x0a, 0x14, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6b,
	0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34,
	0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67,
	0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4e, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x22, 0xbb, 0x02, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x54, 0x0a, 0x1b, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xcb, 0x02, 0x0a, 0x1f, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x49, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x0b, 0x6b, 0x65, 0x79,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x59, 0x0a, 0x20, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49,
	0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0xe4, 0x02, 0x0a, 0x1d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x0a,
	0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f,
	0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x09, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70,
	0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x57, 0x0a, 0x1e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0x64, 0x0a, 0x0c, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44,
	0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x64, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x44, 0x62, 0x22, 0x45, 0x0a, 0x0d, 0x42, 0x65, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x96,
	0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52,
	0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x06, 0x61, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x22, 0x10, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x0f, 0x52, 0x6f,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a,
	0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x12, 0x0a, 0x10,
	0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x68, 0x0a, 0x19, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a,
	0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x74, 0x69, 0x64, 0x22, 0xd1, 0x01, 0x0a, 0x14, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x3a,
	0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74,
	0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x08, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7,
	0x01, 0x0a, 0x11, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x63, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a,
	0x03, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x03, 0x69, 0x64, 0x73, 0x22, 0x58, 0x0a, 0x0c, 0x49, 0x64, 0x4b, 0x65,
	0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x49, 0x64, 0x22, 0xd0, 0x01, 0x0a, 0x1c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x63,
	0x6b, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0f,
	0x69, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x49, 0x64, 0x4b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x52, 0x0d, 0x69, 0x64, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x49, 0x64, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x90, 0x03, 0x0a, 0x11, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e,
	0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x32,
	0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x70, 0x6c, 0x69,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x17, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x6f,
	0x77, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x6e, 0x75, 0x6d, 0x52, 0x6f, 0x77, 0x73,
	0x50, 0x65, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x74, 0x12, 0x4b, 0x0a, 0x09,
	0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x09,
	0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x2b, 0x0a, 0x12, 0x75, 0x73, 0x65,
	0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x76, 0x32, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x75, 0x73, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x56, 0x32, 0x22, 0xfe, 0x03, 0x0a, 0x12, 0x53, 0x70, 0x6c, 0x69, 0x74,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a,
	0x06, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74,
	0x65, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x52, 0x06, 0x73, 0x70, 0x6c, 0x69, 0x74,
	0x73, 0x1a, 0x68, 0x0a, 0x0c, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3c, 0x0a,
	0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74,
	0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x09, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x1a, 0x3f, 0x0a, 0x09, 0x53,
	0x68, 0x61, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x1a, 0xf8, 0x01, 0x0a,
	0x04, 0x50, 0x61, 0x72, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x58, 0x0a, 0x0e, 0x6b, 0x65, 0x79,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76,
	0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x52, 0x0c, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x12, 0x4e, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x70, 0x6c, 0x69,
	0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53,
	0x68, 0x61, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x64, 0x50,
	0x61, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x33, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x53, 0x72,
	0x76, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x5d, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x53, 0x72, 0x76, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x0c, 0x73, 0x72, 0x76, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x53, 0x72, 0x76, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0b,
	0x73, 0x72, 0x76, 0x4b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0xf6, 0x01, 0x0a, 0x0e,
	0x56, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37,
	0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x76, 0x67, 0x74,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x56, 0x47, 0x74, 0x69, 0x64, 0x52, 0x05, 0x76, 0x67, 0x74, 0x69, 0x64, 0x12, 0x35, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f,
	0x67, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x22, 0x48, 0x0a, 0x0f, 0x56, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x56, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xd0,
	0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x12, 0x3a, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x32, 0x0a,
	0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x22, 0x76, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x05, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x29,
	0x0a, 0x10, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2a, 0x44, 0x0a, 0x0f, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0f, 0x0a, 0x0b,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x55, 0x4c,
	0x54, 0x49, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x57, 0x4f, 0x50, 0x43, 0x10, 0x03, 0x2a,
	0x3c, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x0a,
	0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x52,
	0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x4f, 0x53, 0x54, 0x10, 0x02, 0x12, 0x0e, 0x0a,
	0x0a, 0x41, 0x55, 0x54, 0x4f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x03, 0x42, 0x3f, 0x0a,
	0x0f, 0x69, 0x6f, 0x2e, 0x76, 0x69, 0x74, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x5a, 0x2c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x69, 0x74, 0x65, 0x73, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x76,
	0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x74, 0x67, 0x61, 0x74, 0x65, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_dolthub_vt_vtgate_proto_rawDescOnce sync.Once
	file_dolthub_vt_vtgate_proto_rawDescData = file_dolthub_vt_vtgate_proto_rawDesc
)

func file_dolthub_vt_vtgate_proto_rawDescGZIP() []byte {
	file_dolthub_vt_vtgate_proto_rawDescOnce.Do(func() {
		file_dolthub_vt_vtgate_proto_rawDescData = protoimpl.X.CompressGZIP(file_dolthub_vt_vtgate_proto_rawDescData)
	})
	return file_dolthub_vt_vtgate_proto_rawDescData
}

var file_dolthub_vt_vtgate_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_dolthub_vt_vtgate_proto_msgTypes = make([]protoimpl.MessageInfo, 52)
var file_dolthub_vt_vtgate_proto_goTypes = []interface{}{
	(TransactionMode)(0),                     // 0: dolthub.vt.vtgate.TransactionMode
	(CommitOrder)(0),                         // 1: dolthub.vt.vtgate.CommitOrder
	(*Session)(nil),                          // 2: dolthub.vt.vtgate.Session
	(*ExecuteRequest)(nil),                   // 3: dolthub.vt.vtgate.ExecuteRequest
	(*ExecuteResponse)(nil),                  // 4: dolthub.vt.vtgate.ExecuteResponse
	(*ExecuteShardsRequest)(nil),             // 5: dolthub.vt.vtgate.ExecuteShardsRequest
	(*ExecuteShardsResponse)(nil),            // 6: dolthub.vt.vtgate.ExecuteShardsResponse
	(*ExecuteKeyspaceIdsRequest)(nil),        // 7: dolthub.vt.vtgate.ExecuteKeyspaceIdsRequest
	(*ExecuteKeyspaceIdsResponse)(nil),       // 8: dolthub.vt.vtgate.ExecuteKeyspaceIdsResponse
	(*ExecuteKeyRangesRequest)(nil),          // 9: dolthub.vt.vtgate.ExecuteKeyRangesRequest
	(*ExecuteKeyRangesResponse)(nil),         // 10: dolthub.vt.vtgate.ExecuteKeyRangesResponse
	(*ExecuteEntityIdsRequest)(nil),          // 11: dolthub.vt.vtgate.ExecuteEntityIdsRequest
	(*ExecuteEntityIdsResponse)(nil),         // 12: dolthub.vt.vtgate.ExecuteEntityIdsResponse
	(*ExecuteBatchRequest)(nil),              // 13: dolthub.vt.vtgate.ExecuteBatchRequest
	(*ExecuteBatchResponse)(nil),             // 14: dolthub.vt.vtgate.ExecuteBatchResponse
	(*BoundShardQuery)(nil),                  // 15: dolthub.vt.vtgate.BoundShardQuery
	(*ExecuteBatchShardsRequest)(nil),        // 16: dolthub.vt.vtgate.ExecuteBatchShardsRequest
	(*ExecuteBatchShardsResponse)(nil),       // 17: dolthub.vt.vtgate.ExecuteBatchShardsResponse
	(*BoundKeyspaceIdQuery)(nil),             // 18: dolthub.vt.vtgate.BoundKeyspaceIdQuery
	(*ExecuteBatchKeyspaceIdsRequest)(nil),   // 19: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsRequest
	(*ExecuteBatchKeyspaceIdsResponse)(nil),  // 20: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsResponse
	(*StreamExecuteRequest)(nil),             // 21: dolthub.vt.vtgate.StreamExecuteRequest
	(*StreamExecuteResponse)(nil),            // 22: dolthub.vt.vtgate.StreamExecuteResponse
	(*StreamExecuteShardsRequest)(nil),       // 23: dolthub.vt.vtgate.StreamExecuteShardsRequest
	(*StreamExecuteShardsResponse)(nil),      // 24: dolthub.vt.vtgate.StreamExecuteShardsResponse
	(*StreamExecuteKeyspaceIdsRequest)(nil),  // 25: dolthub.vt.vtgate.StreamExecuteKeyspaceIdsRequest
	(*StreamExecuteKeyspaceIdsResponse)(nil), // 26: dolthub.vt.vtgate.StreamExecuteKeyspaceIdsResponse
	(*StreamExecuteKeyRangesRequest)(nil),    // 27: dolthub.vt.vtgate.StreamExecuteKeyRangesRequest
	(*StreamExecuteKeyRangesResponse)(nil),   // 28: dolthub.vt.vtgate.StreamExecuteKeyRangesResponse
	(*BeginRequest)(nil),                     // 29: dolthub.vt.vtgate.BeginRequest
	(*BeginResponse)(nil),                    // 30: dolthub.vt.vtgate.BeginResponse
	(*CommitRequest)(nil),                    // 31: dolthub.vt.vtgate.CommitRequest
	(*CommitResponse)(nil),                   // 32: dolthub.vt.vtgate.CommitResponse
	(*RollbackRequest)(nil),                  // 33: dolthub.vt.vtgate.RollbackRequest
	(*RollbackResponse)(nil),                 // 34: dolthub.vt.vtgate.RollbackResponse
	(*ResolveTransactionRequest)(nil),        // 35: dolthub.vt.vtgate.ResolveTransactionRequest
	(*MessageStreamRequest)(nil),             // 36: dolthub.vt.vtgate.MessageStreamRequest
	(*MessageAckRequest)(nil),                // 37: dolthub.vt.vtgate.MessageAckRequest
	(*IdKeyspaceId)(nil),                     // 38: dolthub.vt.vtgate.IdKeyspaceId
	(*MessageAckKeyspaceIdsRequest)(nil),     // 39: dolthub.vt.vtgate.MessageAckKeyspaceIdsRequest
	(*ResolveTransactionResponse)(nil),       // 40: dolthub.vt.vtgate.ResolveTransactionResponse
	(*SplitQueryRequest)(nil),                // 41: dolthub.vt.vtgate.SplitQueryRequest
	(*SplitQueryResponse)(nil),               // 42: dolthub.vt.vtgate.SplitQueryResponse
	(*GetSrvKeyspaceRequest)(nil),            // 43: dolthub.vt.vtgate.GetSrvKeyspaceRequest
	(*GetSrvKeyspaceResponse)(nil),           // 44: dolthub.vt.vtgate.GetSrvKeyspaceResponse
	(*VStreamRequest)(nil),                   // 45: dolthub.vt.vtgate.VStreamRequest
	(*VStreamResponse)(nil),                  // 46: dolthub.vt.vtgate.VStreamResponse
	(*UpdateStreamRequest)(nil),              // 47: dolthub.vt.vtgate.UpdateStreamRequest
	(*UpdateStreamResponse)(nil),             // 48: dolthub.vt.vtgate.UpdateStreamResponse
	(*Session_ShardSession)(nil),             // 49: dolthub.vt.vtgate.Session.ShardSession
	(*ExecuteEntityIdsRequest_EntityId)(nil), // 50: dolthub.vt.vtgate.ExecuteEntityIdsRequest.EntityId
	(*SplitQueryResponse_KeyRangePart)(nil),  // 51: dolthub.vt.vtgate.SplitQueryResponse.KeyRangePart
	(*SplitQueryResponse_ShardPart)(nil),     // 52: dolthub.vt.vtgate.SplitQueryResponse.ShardPart
	(*SplitQueryResponse_Part)(nil),          // 53: dolthub.vt.vtgate.SplitQueryResponse.Part
	(*query.ExecuteOptions)(nil),             // 54: dolthub.vt.query.ExecuteOptions
	(*query.QueryWarning)(nil),               // 55: dolthub.vt.query.QueryWarning
	(*vtrpc.CallerID)(nil),                   // 56: dolthub.vt.vtrpc.CallerID
	(*query.BoundQuery)(nil),                 // 57: dolthub.vt.query.BoundQuery
	(topodata.TabletType)(0),                 // 58: dolthub.vt.topodata.TabletType
	(*vtrpc.RPCError)(nil),                   // 59: dolthub.vt.vtrpc.RPCError
	(*query.QueryResult)(nil),                // 60: dolthub.vt.query.QueryResult
	(*topodata.KeyRange)(nil),                // 61: dolthub.vt.topodata.KeyRange
	(*query.ResultWithError)(nil),            // 62: dolthub.vt.query.ResultWithError
	(*query.Value)(nil),                      // 63: dolthub.vt.query.Value
	(query.SplitQueryRequest_Algorithm)(0),   // 64: dolthub.vt.query.SplitQueryRequest.Algorithm
	(*topodata.SrvKeyspace)(nil),             // 65: dolthub.vt.topodata.SrvKeyspace
	(*binlogdata.VGtid)(nil),                 // 66: dolthub.vt.binlogdata.VGtid
	(*binlogdata.Filter)(nil),                // 67: dolthub.vt.binlogdata.Filter
	(*binlogdata.VEvent)(nil),                // 68: dolthub.vt.binlogdata.VEvent
	(*query.EventToken)(nil),                 // 69: dolthub.vt.query.EventToken
	(*query.StreamEvent)(nil),                // 70: dolthub.vt.query.StreamEvent
	(*query.Target)(nil),                     // 71: dolthub.vt.query.Target
	(query.Type)(0),                          // 72: dolthub.vt.query.Type
}
var file_dolthub_vt_vtgate_proto_depIdxs = []int32{
	49,  // 0: dolthub.vt.vtgate.Session.shard_sessions:type_name -> dolthub.vt.vtgate.Session.ShardSession
	54,  // 1: dolthub.vt.vtgate.Session.options:type_name -> dolthub.vt.query.ExecuteOptions
	0,   // 2: dolthub.vt.vtgate.Session.transaction_mode:type_name -> dolthub.vt.vtgate.TransactionMode
	55,  // 3: dolthub.vt.vtgate.Session.warnings:type_name -> dolthub.vt.query.QueryWarning
	49,  // 4: dolthub.vt.vtgate.Session.pre_sessions:type_name -> dolthub.vt.vtgate.Session.ShardSession
	49,  // 5: dolthub.vt.vtgate.Session.post_sessions:type_name -> dolthub.vt.vtgate.Session.ShardSession
	56,  // 6: dolthub.vt.vtgate.ExecuteRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 7: dolthub.vt.vtgate.ExecuteRequest.session:type_name -> dolthub.vt.vtgate.Session
	57,  // 8: dolthub.vt.vtgate.ExecuteRequest.query:type_name -> dolthub.vt.query.BoundQuery
	58,  // 9: dolthub.vt.vtgate.ExecuteRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 10: dolthub.vt.vtgate.ExecuteRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	59,  // 11: dolthub.vt.vtgate.ExecuteResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	2,   // 12: dolthub.vt.vtgate.ExecuteResponse.session:type_name -> dolthub.vt.vtgate.Session
	60,  // 13: dolthub.vt.vtgate.ExecuteResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 14: dolthub.vt.vtgate.ExecuteShardsRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 15: dolthub.vt.vtgate.ExecuteShardsRequest.session:type_name -> dolthub.vt.vtgate.Session
	57,  // 16: dolthub.vt.vtgate.ExecuteShardsRequest.query:type_name -> dolthub.vt.query.BoundQuery
	58,  // 17: dolthub.vt.vtgate.ExecuteShardsRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 18: dolthub.vt.vtgate.ExecuteShardsRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	59,  // 19: dolthub.vt.vtgate.ExecuteShardsResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	2,   // 20: dolthub.vt.vtgate.ExecuteShardsResponse.session:type_name -> dolthub.vt.vtgate.Session
	60,  // 21: dolthub.vt.vtgate.ExecuteShardsResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 22: dolthub.vt.vtgate.ExecuteKeyspaceIdsRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 23: dolthub.vt.vtgate.ExecuteKeyspaceIdsRequest.session:type_name -> dolthub.vt.vtgate.Session
	57,  // 24: dolthub.vt.vtgate.ExecuteKeyspaceIdsRequest.query:type_name -> dolthub.vt.query.BoundQuery
	58,  // 25: dolthub.vt.vtgate.ExecuteKeyspaceIdsRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 26: dolthub.vt.vtgate.ExecuteKeyspaceIdsRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	59,  // 27: dolthub.vt.vtgate.ExecuteKeyspaceIdsResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	2,   // 28: dolthub.vt.vtgate.ExecuteKeyspaceIdsResponse.session:type_name -> dolthub.vt.vtgate.Session
	60,  // 29: dolthub.vt.vtgate.ExecuteKeyspaceIdsResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 30: dolthub.vt.vtgate.ExecuteKeyRangesRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 31: dolthub.vt.vtgate.ExecuteKeyRangesRequest.session:type_name -> dolthub.vt.vtgate.Session
	57,  // 32: dolthub.vt.vtgate.ExecuteKeyRangesRequest.query:type_name -> dolthub.vt.query.BoundQuery
	61,  // 33: dolthub.vt.vtgate.ExecuteKeyRangesRequest.key_ranges:type_name -> dolthub.vt.topodata.KeyRange
	58,  // 34: dolthub.vt.vtgate.ExecuteKeyRangesRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 35: dolthub.vt.vtgate.ExecuteKeyRangesRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	59,  // 36: dolthub.vt.vtgate.ExecuteKeyRangesResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	2,   // 37: dolthub.vt.vtgate.ExecuteKeyRangesResponse.session:type_name -> dolthub.vt.vtgate.Session
	60,  // 38: dolthub.vt.vtgate.ExecuteKeyRangesResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 39: dolthub.vt.vtgate.ExecuteEntityIdsRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 40: dolthub.vt.vtgate.ExecuteEntityIdsRequest.session:type_name -> dolthub.vt.vtgate.Session
	57,  // 41: dolthub.vt.vtgate.ExecuteEntityIdsRequest.query:type_name -> dolthub.vt.query.BoundQuery
	50,  // 42: dolthub.vt.vtgate.ExecuteEntityIdsRequest.entity_keyspace_ids:type_name -> dolthub.vt.vtgate.ExecuteEntityIdsRequest.EntityId
	58,  // 43: dolthub.vt.vtgate.ExecuteEntityIdsRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 44: dolthub.vt.vtgate.ExecuteEntityIdsRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	59,  // 45: dolthub.vt.vtgate.ExecuteEntityIdsResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	2,   // 46: dolthub.vt.vtgate.ExecuteEntityIdsResponse.session:type_name -> dolthub.vt.vtgate.Session
	60,  // 47: dolthub.vt.vtgate.ExecuteEntityIdsResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 48: dolthub.vt.vtgate.ExecuteBatchRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 49: dolthub.vt.vtgate.ExecuteBatchRequest.session:type_name -> dolthub.vt.vtgate.Session
	57,  // 50: dolthub.vt.vtgate.ExecuteBatchRequest.queries:type_name -> dolthub.vt.query.BoundQuery
	58,  // 51: dolthub.vt.vtgate.ExecuteBatchRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 52: dolthub.vt.vtgate.ExecuteBatchRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	59,  // 53: dolthub.vt.vtgate.ExecuteBatchResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	2,   // 54: dolthub.vt.vtgate.ExecuteBatchResponse.session:type_name -> dolthub.vt.vtgate.Session
	62,  // 55: dolthub.vt.vtgate.ExecuteBatchResponse.results:type_name -> dolthub.vt.query.ResultWithError
	57,  // 56: dolthub.vt.vtgate.BoundShardQuery.query:type_name -> dolthub.vt.query.BoundQuery
	56,  // 57: dolthub.vt.vtgate.ExecuteBatchShardsRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 58: dolthub.vt.vtgate.ExecuteBatchShardsRequest.session:type_name -> dolthub.vt.vtgate.Session
	15,  // 59: dolthub.vt.vtgate.ExecuteBatchShardsRequest.queries:type_name -> dolthub.vt.vtgate.BoundShardQuery
	58,  // 60: dolthub.vt.vtgate.ExecuteBatchShardsRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 61: dolthub.vt.vtgate.ExecuteBatchShardsRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	59,  // 62: dolthub.vt.vtgate.ExecuteBatchShardsResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	2,   // 63: dolthub.vt.vtgate.ExecuteBatchShardsResponse.session:type_name -> dolthub.vt.vtgate.Session
	60,  // 64: dolthub.vt.vtgate.ExecuteBatchShardsResponse.results:type_name -> dolthub.vt.query.QueryResult
	57,  // 65: dolthub.vt.vtgate.BoundKeyspaceIdQuery.query:type_name -> dolthub.vt.query.BoundQuery
	56,  // 66: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 67: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsRequest.session:type_name -> dolthub.vt.vtgate.Session
	18,  // 68: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsRequest.queries:type_name -> dolthub.vt.vtgate.BoundKeyspaceIdQuery
	58,  // 69: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 70: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	59,  // 71: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	2,   // 72: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsResponse.session:type_name -> dolthub.vt.vtgate.Session
	60,  // 73: dolthub.vt.vtgate.ExecuteBatchKeyspaceIdsResponse.results:type_name -> dolthub.vt.query.QueryResult
	56,  // 74: dolthub.vt.vtgate.StreamExecuteRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	57,  // 75: dolthub.vt.vtgate.StreamExecuteRequest.query:type_name -> dolthub.vt.query.BoundQuery
	58,  // 76: dolthub.vt.vtgate.StreamExecuteRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 77: dolthub.vt.vtgate.StreamExecuteRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	2,   // 78: dolthub.vt.vtgate.StreamExecuteRequest.session:type_name -> dolthub.vt.vtgate.Session
	60,  // 79: dolthub.vt.vtgate.StreamExecuteResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 80: dolthub.vt.vtgate.StreamExecuteShardsRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	57,  // 81: dolthub.vt.vtgate.StreamExecuteShardsRequest.query:type_name -> dolthub.vt.query.BoundQuery
	58,  // 82: dolthub.vt.vtgate.StreamExecuteShardsRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 83: dolthub.vt.vtgate.StreamExecuteShardsRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	60,  // 84: dolthub.vt.vtgate.StreamExecuteShardsResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 85: dolthub.vt.vtgate.StreamExecuteKeyspaceIdsRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	57,  // 86: dolthub.vt.vtgate.StreamExecuteKeyspaceIdsRequest.query:type_name -> dolthub.vt.query.BoundQuery
	58,  // 87: dolthub.vt.vtgate.StreamExecuteKeyspaceIdsRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 88: dolthub.vt.vtgate.StreamExecuteKeyspaceIdsRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	60,  // 89: dolthub.vt.vtgate.StreamExecuteKeyspaceIdsResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 90: dolthub.vt.vtgate.StreamExecuteKeyRangesRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	57,  // 91: dolthub.vt.vtgate.StreamExecuteKeyRangesRequest.query:type_name -> dolthub.vt.query.BoundQuery
	61,  // 92: dolthub.vt.vtgate.StreamExecuteKeyRangesRequest.key_ranges:type_name -> dolthub.vt.topodata.KeyRange
	58,  // 93: dolthub.vt.vtgate.StreamExecuteKeyRangesRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	54,  // 94: dolthub.vt.vtgate.StreamExecuteKeyRangesRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	60,  // 95: dolthub.vt.vtgate.StreamExecuteKeyRangesResponse.result:type_name -> dolthub.vt.query.QueryResult
	56,  // 96: dolthub.vt.vtgate.BeginRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 97: dolthub.vt.vtgate.BeginResponse.session:type_name -> dolthub.vt.vtgate.Session
	56,  // 98: dolthub.vt.vtgate.CommitRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 99: dolthub.vt.vtgate.CommitRequest.session:type_name -> dolthub.vt.vtgate.Session
	56,  // 100: dolthub.vt.vtgate.RollbackRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	2,   // 101: dolthub.vt.vtgate.RollbackRequest.session:type_name -> dolthub.vt.vtgate.Session
	56,  // 102: dolthub.vt.vtgate.ResolveTransactionRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	56,  // 103: dolthub.vt.vtgate.MessageStreamRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	61,  // 104: dolthub.vt.vtgate.MessageStreamRequest.key_range:type_name -> dolthub.vt.topodata.KeyRange
	56,  // 105: dolthub.vt.vtgate.MessageAckRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	63,  // 106: dolthub.vt.vtgate.MessageAckRequest.ids:type_name -> dolthub.vt.query.Value
	63,  // 107: dolthub.vt.vtgate.IdKeyspaceId.id:type_name -> dolthub.vt.query.Value
	56,  // 108: dolthub.vt.vtgate.MessageAckKeyspaceIdsRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	38,  // 109: dolthub.vt.vtgate.MessageAckKeyspaceIdsRequest.id_keyspace_ids:type_name -> dolthub.vt.vtgate.IdKeyspaceId
	56,  // 110: dolthub.vt.vtgate.SplitQueryRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	57,  // 111: dolthub.vt.vtgate.SplitQueryRequest.query:type_name -> dolthub.vt.query.BoundQuery
	64,  // 112: dolthub.vt.vtgate.SplitQueryRequest.algorithm:type_name -> dolthub.vt.query.SplitQueryRequest.Algorithm
	53,  // 113: dolthub.vt.vtgate.SplitQueryResponse.splits:type_name -> dolthub.vt.vtgate.SplitQueryResponse.Part
	65,  // 114: dolthub.vt.vtgate.GetSrvKeyspaceResponse.srv_keyspace:type_name -> dolthub.vt.topodata.SrvKeyspace
	56,  // 115: dolthub.vt.vtgate.VStreamRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	58,  // 116: dolthub.vt.vtgate.VStreamRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	66,  // 117: dolthub.vt.vtgate.VStreamRequest.vgtid:type_name -> dolthub.vt.binlogdata.VGtid
	67,  // 118: dolthub.vt.vtgate.VStreamRequest.filter:type_name -> dolthub.vt.binlogdata.Filter
	68,  // 119: dolthub.vt.vtgate.VStreamResponse.events:type_name -> dolthub.vt.binlogdata.VEvent
	56,  // 120: dolthub.vt.vtgate.UpdateStreamRequest.caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	61,  // 121: dolthub.vt.vtgate.UpdateStreamRequest.key_range:type_name -> dolthub.vt.topodata.KeyRange
	58,  // 122: dolthub.vt.vtgate.UpdateStreamRequest.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	69,  // 123: dolthub.vt.vtgate.UpdateStreamRequest.event:type_name -> dolthub.vt.query.EventToken
	70,  // 124: dolthub.vt.vtgate.UpdateStreamResponse.event:type_name -> dolthub.vt.query.StreamEvent
	71,  // 125: dolthub.vt.vtgate.Session.ShardSession.target:type_name -> dolthub.vt.query.Target
	72,  // 126: dolthub.vt.vtgate.ExecuteEntityIdsRequest.EntityId.type:type_name -> dolthub.vt.query.Type
	61,  // 127: dolthub.vt.vtgate.SplitQueryResponse.KeyRangePart.key_ranges:type_name -> dolthub.vt.topodata.KeyRange
	57,  // 128: dolthub.vt.vtgate.SplitQueryResponse.Part.query:type_name -> dolthub.vt.query.BoundQuery
	51,  // 129: dolthub.vt.vtgate.SplitQueryResponse.Part.key_range_part:type_name -> dolthub.vt.vtgate.SplitQueryResponse.KeyRangePart
	52,  // 130: dolthub.vt.vtgate.SplitQueryResponse.Part.shard_part:type_name -> dolthub.vt.vtgate.SplitQueryResponse.ShardPart
	131, // [131:131] is the sub-list for method output_type
	131, // [131:131] is the sub-list for method input_type
	131, // [131:131] is the sub-list for extension type_name
	131, // [131:131] is the sub-list for extension extendee
	0,   // [0:131] is the sub-list for field type_name
}

func init() { file_dolthub_vt_vtgate_proto_init() }
func file_dolthub_vt_vtgate_proto_init() {
	if File_dolthub_vt_vtgate_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_dolthub_vt_vtgate_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Session); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteShardsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteShardsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteKeyspaceIdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteKeyspaceIdsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteKeyRangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteKeyRangesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteEntityIdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteEntityIdsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundShardQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchShardsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchShardsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundKeyspaceIdQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchKeyspaceIdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchKeyspaceIdsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteShardsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteShardsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteKeyspaceIdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteKeyspaceIdsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteKeyRangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteKeyRangesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageAckRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdKeyspaceId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageAckKeyspaceIdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveTransactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSrvKeyspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSrvKeyspaceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Session_ShardSession); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteEntityIdsRequest_EntityId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitQueryResponse_KeyRangePart); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitQueryResponse_ShardPart); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_vtgate_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitQueryResponse_Part); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_dolthub_vt_vtgate_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   52,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_dolthub_vt_vtgate_proto_goTypes,
		DependencyIndexes: file_dolthub_vt_vtgate_proto_depIdxs,
		EnumInfos:         file_dolthub_vt_vtgate_proto_enumTypes,
		MessageInfos:      file_dolthub_vt_vtgate_proto_msgTypes,
	}.Build()
	File_dolthub_vt_vtgate_proto = out.File
	file_dolthub_vt_vtgate_proto_rawDesc = nil
	file_dolthub_vt_vtgate_proto_goTypes = nil
	file_dolthub_vt_vtgate_proto_depIdxs = nil
}
