//
//Copyright 2019 The Vitess Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// This file contains all the types necessary to make
// RPC calls to Vttablet.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v5.28.3
// source: dolthub/vt/query.proto

package query

import (
	topodata "github.com/dolthub/vitess/go/vt/proto/topodata"
	vtrpc "github.com/dolthub/vitess/go/vt/proto/vtrpc"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Flags sent from the MySQL C API
type MySqlFlag int32

const (
	MySqlFlag_EMPTY                 MySqlFlag = 0
	MySqlFlag_NOT_NULL_FLAG         MySqlFlag = 1
	MySqlFlag_PRI_KEY_FLAG          MySqlFlag = 2
	MySqlFlag_UNIQUE_KEY_FLAG       MySqlFlag = 4
	MySqlFlag_MULTIPLE_KEY_FLAG     MySqlFlag = 8
	MySqlFlag_BLOB_FLAG             MySqlFlag = 16
	MySqlFlag_UNSIGNED_FLAG         MySqlFlag = 32
	MySqlFlag_ZEROFILL_FLAG         MySqlFlag = 64
	MySqlFlag_BINARY_FLAG           MySqlFlag = 128
	MySqlFlag_ENUM_FLAG             MySqlFlag = 256
	MySqlFlag_AUTO_INCREMENT_FLAG   MySqlFlag = 512
	MySqlFlag_TIMESTAMP_FLAG        MySqlFlag = 1024
	MySqlFlag_SET_FLAG              MySqlFlag = 2048
	MySqlFlag_NO_DEFAULT_VALUE_FLAG MySqlFlag = 4096
	MySqlFlag_ON_UPDATE_NOW_FLAG    MySqlFlag = 8192
	MySqlFlag_NUM_FLAG              MySqlFlag = 32768
	MySqlFlag_PART_KEY_FLAG         MySqlFlag = 16384
	MySqlFlag_GROUP_FLAG            MySqlFlag = 32768
	MySqlFlag_UNIQUE_FLAG           MySqlFlag = 65536
	MySqlFlag_BINCMP_FLAG           MySqlFlag = 131072
)

// Enum value maps for MySqlFlag.
var (
	MySqlFlag_name = map[int32]string{
		0:     "EMPTY",
		1:     "NOT_NULL_FLAG",
		2:     "PRI_KEY_FLAG",
		4:     "UNIQUE_KEY_FLAG",
		8:     "MULTIPLE_KEY_FLAG",
		16:    "BLOB_FLAG",
		32:    "UNSIGNED_FLAG",
		64:    "ZEROFILL_FLAG",
		128:   "BINARY_FLAG",
		256:   "ENUM_FLAG",
		512:   "AUTO_INCREMENT_FLAG",
		1024:  "TIMESTAMP_FLAG",
		2048:  "SET_FLAG",
		4096:  "NO_DEFAULT_VALUE_FLAG",
		8192:  "ON_UPDATE_NOW_FLAG",
		32768: "NUM_FLAG",
		16384: "PART_KEY_FLAG",
		// Duplicate value: 32768: "GROUP_FLAG",
		65536:  "UNIQUE_FLAG",
		131072: "BINCMP_FLAG",
	}
	MySqlFlag_value = map[string]int32{
		"EMPTY":                 0,
		"NOT_NULL_FLAG":         1,
		"PRI_KEY_FLAG":          2,
		"UNIQUE_KEY_FLAG":       4,
		"MULTIPLE_KEY_FLAG":     8,
		"BLOB_FLAG":             16,
		"UNSIGNED_FLAG":         32,
		"ZEROFILL_FLAG":         64,
		"BINARY_FLAG":           128,
		"ENUM_FLAG":             256,
		"AUTO_INCREMENT_FLAG":   512,
		"TIMESTAMP_FLAG":        1024,
		"SET_FLAG":              2048,
		"NO_DEFAULT_VALUE_FLAG": 4096,
		"ON_UPDATE_NOW_FLAG":    8192,
		"NUM_FLAG":              32768,
		"PART_KEY_FLAG":         16384,
		"GROUP_FLAG":            32768,
		"UNIQUE_FLAG":           65536,
		"BINCMP_FLAG":           131072,
	}
)

func (x MySqlFlag) Enum() *MySqlFlag {
	p := new(MySqlFlag)
	*p = x
	return p
}

func (x MySqlFlag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MySqlFlag) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[0].Descriptor()
}

func (MySqlFlag) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[0]
}

func (x MySqlFlag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MySqlFlag.Descriptor instead.
func (MySqlFlag) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{0}
}

// Flag allows us to qualify types by their common properties.
type Flag int32

const (
	Flag_NONE       Flag = 0
	Flag_ISINTEGRAL Flag = 256
	Flag_ISUNSIGNED Flag = 512
	Flag_ISFLOAT    Flag = 1024
	Flag_ISQUOTED   Flag = 2048
	Flag_ISTEXT     Flag = 4096
	Flag_ISBINARY   Flag = 8192
)

// Enum value maps for Flag.
var (
	Flag_name = map[int32]string{
		0:    "NONE",
		256:  "ISINTEGRAL",
		512:  "ISUNSIGNED",
		1024: "ISFLOAT",
		2048: "ISQUOTED",
		4096: "ISTEXT",
		8192: "ISBINARY",
	}
	Flag_value = map[string]int32{
		"NONE":       0,
		"ISINTEGRAL": 256,
		"ISUNSIGNED": 512,
		"ISFLOAT":    1024,
		"ISQUOTED":   2048,
		"ISTEXT":     4096,
		"ISBINARY":   8192,
	}
)

func (x Flag) Enum() *Flag {
	p := new(Flag)
	*p = x
	return p
}

func (x Flag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Flag) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[1].Descriptor()
}

func (Flag) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[1]
}

func (x Flag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Flag.Descriptor instead.
func (Flag) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{1}
}

// Type defines the various supported data types in bind vars
// and query results.
type Type int32

const (
	// NULL_TYPE specifies a NULL type.
	Type_NULL_TYPE Type = 0
	// INT8 specifies a TINYINT type.
	// Properties: 1, IsNumber.
	Type_INT8 Type = 257
	// UINT8 specifies a TINYINT UNSIGNED type.
	// Properties: 2, IsNumber, IsUnsigned.
	Type_UINT8 Type = 770
	// INT16 specifies a SMALLINT type.
	// Properties: 3, IsNumber.
	Type_INT16 Type = 259
	// UINT16 specifies a SMALLINT UNSIGNED type.
	// Properties: 4, IsNumber, IsUnsigned.
	Type_UINT16 Type = 772
	// INT24 specifies a MEDIUMINT type.
	// Properties: 5, IsNumber.
	Type_INT24 Type = 261
	// UINT24 specifies a MEDIUMINT UNSIGNED type.
	// Properties: 6, IsNumber, IsUnsigned.
	Type_UINT24 Type = 774
	// INT32 specifies a INTEGER type.
	// Properties: 7, IsNumber.
	Type_INT32 Type = 263
	// UINT32 specifies a INTEGER UNSIGNED type.
	// Properties: 8, IsNumber, IsUnsigned.
	Type_UINT32 Type = 776
	// INT64 specifies a BIGINT type.
	// Properties: 9, IsNumber.
	Type_INT64 Type = 265
	// UINT64 specifies a BIGINT UNSIGNED type.
	// Properties: 10, IsNumber, IsUnsigned.
	Type_UINT64 Type = 778
	// FLOAT32 specifies a FLOAT type.
	// Properties: 11, IsFloat.
	Type_FLOAT32 Type = 1035
	// FLOAT64 specifies a DOUBLE or REAL type.
	// Properties: 12, IsFloat.
	Type_FLOAT64 Type = 1036
	// TIMESTAMP specifies a TIMESTAMP type.
	// Properties: 13, IsQuoted.
	Type_TIMESTAMP Type = 2061
	// DATE specifies a DATE type.
	// Properties: 14, IsQuoted.
	Type_DATE Type = 2062
	// TIME specifies a TIME type.
	// Properties: 15, IsQuoted.
	Type_TIME Type = 2063
	// DATETIME specifies a DATETIME type.
	// Properties: 16, IsQuoted.
	Type_DATETIME Type = 2064
	// YEAR specifies a YEAR type.
	// Properties: 17, IsNumber, IsUnsigned.
	Type_YEAR Type = 785
	// DECIMAL specifies a DECIMAL or NUMERIC type.
	// Properties: 18, None.
	Type_DECIMAL Type = 18
	// TEXT specifies a TEXT type.
	// Properties: 19, IsQuoted, IsText.
	Type_TEXT Type = 6163
	// BLOB specifies a BLOB type.
	// Properties: 20, IsQuoted, IsBinary.
	Type_BLOB Type = 10260
	// VARCHAR specifies a VARCHAR type.
	// Properties: 21, IsQuoted, IsText.
	Type_VARCHAR Type = 6165
	// VARBINARY specifies a VARBINARY type.
	// Properties: 22, IsQuoted, IsBinary.
	Type_VARBINARY Type = 10262
	// CHAR specifies a CHAR type.
	// Properties: 23, IsQuoted, IsText.
	Type_CHAR Type = 6167
	// BINARY specifies a BINARY type.
	// Properties: 24, IsQuoted, IsBinary.
	Type_BINARY Type = 10264
	// BIT specifies a BIT type.
	// Properties: 25, IsQuoted.
	Type_BIT Type = 2073
	// ENUM specifies an ENUM type.
	// Properties: 26, IsQuoted.
	Type_ENUM Type = 2074
	// SET specifies a SET type.
	// Properties: 27, IsQuoted.
	Type_SET Type = 2075
	// TUPLE specifies a tuple. This cannot
	// be returned in a QueryResult, but it can
	// be sent as a bind var.
	// Properties: 28, None.
	Type_TUPLE Type = 28
	// GEOMETRY specifies a GEOMETRY type.
	// Properties: 29, IsQuoted.
	Type_GEOMETRY Type = 2077
	// JSON specifies a JSON type.
	// Properties: 30, IsQuoted.
	Type_JSON Type = 2078
	// EXPRESSION specifies a SQL expression.
	// This type is for internal use only.
	// Properties: 31, None.
	Type_EXPRESSION Type = 31
	// VECTOR specifies a VECTOR type.
	// Properties: 32, IsBinary.
	Type_VECTOR Type = 8224
)

// Enum value maps for Type.
var (
	Type_name = map[int32]string{
		0:     "NULL_TYPE",
		257:   "INT8",
		770:   "UINT8",
		259:   "INT16",
		772:   "UINT16",
		261:   "INT24",
		774:   "UINT24",
		263:   "INT32",
		776:   "UINT32",
		265:   "INT64",
		778:   "UINT64",
		1035:  "FLOAT32",
		1036:  "FLOAT64",
		2061:  "TIMESTAMP",
		2062:  "DATE",
		2063:  "TIME",
		2064:  "DATETIME",
		785:   "YEAR",
		18:    "DECIMAL",
		6163:  "TEXT",
		10260: "BLOB",
		6165:  "VARCHAR",
		10262: "VARBINARY",
		6167:  "CHAR",
		10264: "BINARY",
		2073:  "BIT",
		2074:  "ENUM",
		2075:  "SET",
		28:    "TUPLE",
		2077:  "GEOMETRY",
		2078:  "JSON",
		31:    "EXPRESSION",
		8224:  "VECTOR",
	}
	Type_value = map[string]int32{
		"NULL_TYPE":  0,
		"INT8":       257,
		"UINT8":      770,
		"INT16":      259,
		"UINT16":     772,
		"INT24":      261,
		"UINT24":     774,
		"INT32":      263,
		"UINT32":     776,
		"INT64":      265,
		"UINT64":     778,
		"FLOAT32":    1035,
		"FLOAT64":    1036,
		"TIMESTAMP":  2061,
		"DATE":       2062,
		"TIME":       2063,
		"DATETIME":   2064,
		"YEAR":       785,
		"DECIMAL":    18,
		"TEXT":       6163,
		"BLOB":       10260,
		"VARCHAR":    6165,
		"VARBINARY":  10262,
		"CHAR":       6167,
		"BINARY":     10264,
		"BIT":        2073,
		"ENUM":       2074,
		"SET":        2075,
		"TUPLE":      28,
		"GEOMETRY":   2077,
		"JSON":       2078,
		"EXPRESSION": 31,
		"VECTOR":     8224,
	}
)

func (x Type) Enum() *Type {
	p := new(Type)
	*p = x
	return p
}

func (x Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Type) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[2].Descriptor()
}

func (Type) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[2]
}

func (x Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Type.Descriptor instead.
func (Type) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{2}
}

// TransactionState represents the state of a distributed transaction.
type TransactionState int32

const (
	TransactionState_UNKNOWN  TransactionState = 0
	TransactionState_PREPARE  TransactionState = 1
	TransactionState_COMMIT   TransactionState = 2
	TransactionState_ROLLBACK TransactionState = 3
)

// Enum value maps for TransactionState.
var (
	TransactionState_name = map[int32]string{
		0: "UNKNOWN",
		1: "PREPARE",
		2: "COMMIT",
		3: "ROLLBACK",
	}
	TransactionState_value = map[string]int32{
		"UNKNOWN":  0,
		"PREPARE":  1,
		"COMMIT":   2,
		"ROLLBACK": 3,
	}
)

func (x TransactionState) Enum() *TransactionState {
	p := new(TransactionState)
	*p = x
	return p
}

func (x TransactionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionState) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[3].Descriptor()
}

func (TransactionState) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[3]
}

func (x TransactionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionState.Descriptor instead.
func (TransactionState) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{3}
}

type ExecuteOptions_IncludedFields int32

const (
	ExecuteOptions_TYPE_AND_NAME ExecuteOptions_IncludedFields = 0
	ExecuteOptions_TYPE_ONLY     ExecuteOptions_IncludedFields = 1
	ExecuteOptions_ALL           ExecuteOptions_IncludedFields = 2
)

// Enum value maps for ExecuteOptions_IncludedFields.
var (
	ExecuteOptions_IncludedFields_name = map[int32]string{
		0: "TYPE_AND_NAME",
		1: "TYPE_ONLY",
		2: "ALL",
	}
	ExecuteOptions_IncludedFields_value = map[string]int32{
		"TYPE_AND_NAME": 0,
		"TYPE_ONLY":     1,
		"ALL":           2,
	}
)

func (x ExecuteOptions_IncludedFields) Enum() *ExecuteOptions_IncludedFields {
	p := new(ExecuteOptions_IncludedFields)
	*p = x
	return p
}

func (x ExecuteOptions_IncludedFields) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecuteOptions_IncludedFields) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[4].Descriptor()
}

func (ExecuteOptions_IncludedFields) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[4]
}

func (x ExecuteOptions_IncludedFields) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecuteOptions_IncludedFields.Descriptor instead.
func (ExecuteOptions_IncludedFields) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{6, 0}
}

type ExecuteOptions_Workload int32

const (
	ExecuteOptions_UNSPECIFIED ExecuteOptions_Workload = 0
	ExecuteOptions_OLTP        ExecuteOptions_Workload = 1
	ExecuteOptions_OLAP        ExecuteOptions_Workload = 2
	ExecuteOptions_DBA         ExecuteOptions_Workload = 3
)

// Enum value maps for ExecuteOptions_Workload.
var (
	ExecuteOptions_Workload_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "OLTP",
		2: "OLAP",
		3: "DBA",
	}
	ExecuteOptions_Workload_value = map[string]int32{
		"UNSPECIFIED": 0,
		"OLTP":        1,
		"OLAP":        2,
		"DBA":         3,
	}
)

func (x ExecuteOptions_Workload) Enum() *ExecuteOptions_Workload {
	p := new(ExecuteOptions_Workload)
	*p = x
	return p
}

func (x ExecuteOptions_Workload) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecuteOptions_Workload) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[5].Descriptor()
}

func (ExecuteOptions_Workload) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[5]
}

func (x ExecuteOptions_Workload) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecuteOptions_Workload.Descriptor instead.
func (ExecuteOptions_Workload) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{6, 1}
}

type ExecuteOptions_TransactionIsolation int32

const (
	ExecuteOptions_DEFAULT          ExecuteOptions_TransactionIsolation = 0
	ExecuteOptions_REPEATABLE_READ  ExecuteOptions_TransactionIsolation = 1
	ExecuteOptions_READ_COMMITTED   ExecuteOptions_TransactionIsolation = 2
	ExecuteOptions_READ_UNCOMMITTED ExecuteOptions_TransactionIsolation = 3
	ExecuteOptions_SERIALIZABLE     ExecuteOptions_TransactionIsolation = 4
	// This is not an "official" transaction level but it will do a
	// START TRANSACTION WITH CONSISTENT SNAPSHOT, READ ONLY
	ExecuteOptions_CONSISTENT_SNAPSHOT_READ_ONLY ExecuteOptions_TransactionIsolation = 5
	// This not an "official" transaction level, it will send queries to mysql
	// without wrapping them in a transaction
	ExecuteOptions_AUTOCOMMIT ExecuteOptions_TransactionIsolation = 6
)

// Enum value maps for ExecuteOptions_TransactionIsolation.
var (
	ExecuteOptions_TransactionIsolation_name = map[int32]string{
		0: "DEFAULT",
		1: "REPEATABLE_READ",
		2: "READ_COMMITTED",
		3: "READ_UNCOMMITTED",
		4: "SERIALIZABLE",
		5: "CONSISTENT_SNAPSHOT_READ_ONLY",
		6: "AUTOCOMMIT",
	}
	ExecuteOptions_TransactionIsolation_value = map[string]int32{
		"DEFAULT":                       0,
		"REPEATABLE_READ":               1,
		"READ_COMMITTED":                2,
		"READ_UNCOMMITTED":              3,
		"SERIALIZABLE":                  4,
		"CONSISTENT_SNAPSHOT_READ_ONLY": 5,
		"AUTOCOMMIT":                    6,
	}
)

func (x ExecuteOptions_TransactionIsolation) Enum() *ExecuteOptions_TransactionIsolation {
	p := new(ExecuteOptions_TransactionIsolation)
	*p = x
	return p
}

func (x ExecuteOptions_TransactionIsolation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecuteOptions_TransactionIsolation) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[6].Descriptor()
}

func (ExecuteOptions_TransactionIsolation) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[6]
}

func (x ExecuteOptions_TransactionIsolation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecuteOptions_TransactionIsolation.Descriptor instead.
func (ExecuteOptions_TransactionIsolation) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{6, 2}
}

// The category of one statement.
type StreamEvent_Statement_Category int32

const (
	StreamEvent_Statement_Error StreamEvent_Statement_Category = 0
	StreamEvent_Statement_DML   StreamEvent_Statement_Category = 1
	StreamEvent_Statement_DDL   StreamEvent_Statement_Category = 2
)

// Enum value maps for StreamEvent_Statement_Category.
var (
	StreamEvent_Statement_Category_name = map[int32]string{
		0: "Error",
		1: "DML",
		2: "DDL",
	}
	StreamEvent_Statement_Category_value = map[string]int32{
		"Error": 0,
		"DML":   1,
		"DDL":   2,
	}
)

func (x StreamEvent_Statement_Category) Enum() *StreamEvent_Statement_Category {
	p := new(StreamEvent_Statement_Category)
	*p = x
	return p
}

func (x StreamEvent_Statement_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamEvent_Statement_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[7].Descriptor()
}

func (StreamEvent_Statement_Category) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[7]
}

func (x StreamEvent_Statement_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamEvent_Statement_Category.Descriptor instead.
func (StreamEvent_Statement_Category) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{12, 0, 0}
}

type SplitQueryRequest_Algorithm int32

const (
	SplitQueryRequest_EQUAL_SPLITS SplitQueryRequest_Algorithm = 0
	SplitQueryRequest_FULL_SCAN    SplitQueryRequest_Algorithm = 1
)

// Enum value maps for SplitQueryRequest_Algorithm.
var (
	SplitQueryRequest_Algorithm_name = map[int32]string{
		0: "EQUAL_SPLITS",
		1: "FULL_SCAN",
	}
	SplitQueryRequest_Algorithm_value = map[string]int32{
		"EQUAL_SPLITS": 0,
		"FULL_SCAN":    1,
	}
)

func (x SplitQueryRequest_Algorithm) Enum() *SplitQueryRequest_Algorithm {
	p := new(SplitQueryRequest_Algorithm)
	*p = x
	return p
}

func (x SplitQueryRequest_Algorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SplitQueryRequest_Algorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_dolthub_vt_query_proto_enumTypes[8].Descriptor()
}

func (SplitQueryRequest_Algorithm) Type() protoreflect.EnumType {
	return &file_dolthub_vt_query_proto_enumTypes[8]
}

func (x SplitQueryRequest_Algorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SplitQueryRequest_Algorithm.Descriptor instead.
func (SplitQueryRequest_Algorithm) EnumDescriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{50, 0}
}

// Target describes what the client expects the tablet is.
// If the tablet does not match, an error is returned.
type Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keyspace   string              `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	Shard      string              `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,proto3,enum=dolthub.vt.topodata.TabletType" json:"tablet_type,omitempty"`
	// cell is used for routing queries between vtgate and vttablets. It
	// is not used when Target is part of the Session sent by the client.
	Cell string `protobuf:"bytes,4,opt,name=cell,proto3" json:"cell,omitempty"`
}

func (x *Target) Reset() {
	*x = Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{0}
}

func (x *Target) GetKeyspace() string {
	if x != nil {
		return x.Keyspace
	}
	return ""
}

func (x *Target) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

func (x *Target) GetTabletType() topodata.TabletType {
	if x != nil {
		return x.TabletType
	}
	return topodata.TabletType(0)
}

func (x *Target) GetCell() string {
	if x != nil {
		return x.Cell
	}
	return ""
}

// VTGateCallerID is sent by VTGate to VTTablet to describe the
// caller. If possible, this information is secure. For instance,
// if using unique certificates that guarantee that VTGate->VTTablet
// traffic cannot be spoofed, then VTTablet can trust this information,
// and VTTablet will use it for tablet ACLs, for instance.
// Because of this security guarantee, this is different than the CallerID
// structure, which is not secure at all, because it is provided
// by the Vitess client.
type VTGateCallerID struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username string   `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	Groups   []string `protobuf:"bytes,2,rep,name=groups,proto3" json:"groups,omitempty"`
}

func (x *VTGateCallerID) Reset() {
	*x = VTGateCallerID{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VTGateCallerID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VTGateCallerID) ProtoMessage() {}

func (x *VTGateCallerID) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VTGateCallerID.ProtoReflect.Descriptor instead.
func (*VTGateCallerID) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{1}
}

func (x *VTGateCallerID) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *VTGateCallerID) GetGroups() []string {
	if x != nil {
		return x.Groups
	}
	return nil
}

// EventToken is a structure that describes a point in time in a
// replication stream on one shard. The most recent known replication
// position can be retrieved from vttablet when executing a query. It
// is also sent with the replication streams from the binlog service.
type EventToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// timestamp is the MySQL timestamp of the statements. Seconds since Epoch.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The shard name that applied the statements. Note this is not set when
	// streaming from a vttablet. It is only used on the client -> vtgate link.
	Shard string `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	// The position on the replication stream after this statement was applied.
	// It is not the transaction ID / GTID, but the position / GTIDSet.
	Position string `protobuf:"bytes,3,opt,name=position,proto3" json:"position,omitempty"`
}

func (x *EventToken) Reset() {
	*x = EventToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventToken) ProtoMessage() {}

func (x *EventToken) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventToken.ProtoReflect.Descriptor instead.
func (*EventToken) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{2}
}

func (x *EventToken) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *EventToken) GetShard() string {
	if x != nil {
		return x.Shard
	}
	return ""
}

func (x *EventToken) GetPosition() string {
	if x != nil {
		return x.Position
	}
	return ""
}

// Value represents a typed value.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type  Type   `protobuf:"varint,1,opt,name=type,proto3,enum=dolthub.vt.query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{3}
}

func (x *Value) GetType() Type {
	if x != nil {
		return x.Type
	}
	return Type_NULL_TYPE
}

func (x *Value) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// BindVariable represents a single bind variable in a Query.
type BindVariable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type  Type   `protobuf:"varint,1,opt,name=type,proto3,enum=dolthub.vt.query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// values are set if type is TUPLE.
	Values []*Value `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *BindVariable) Reset() {
	*x = BindVariable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BindVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BindVariable) ProtoMessage() {}

func (x *BindVariable) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BindVariable.ProtoReflect.Descriptor instead.
func (*BindVariable) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{4}
}

func (x *BindVariable) GetType() Type {
	if x != nil {
		return x.Type
	}
	return Type_NULL_TYPE
}

func (x *BindVariable) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *BindVariable) GetValues() []*Value {
	if x != nil {
		return x.Values
	}
	return nil
}

// BoundQuery is a query with its bind variables
type BoundQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// sql is the SQL query to execute
	Sql string `protobuf:"bytes,1,opt,name=sql,proto3" json:"sql,omitempty"`
	// bind_variables is a map of all bind variables to expand in the query.
	// nil values are not allowed. Use NULL_TYPE to express a NULL value.
	BindVariables map[string]*BindVariable `protobuf:"bytes,2,rep,name=bind_variables,json=bindVariables,proto3" json:"bind_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BoundQuery) Reset() {
	*x = BoundQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundQuery) ProtoMessage() {}

func (x *BoundQuery) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundQuery.ProtoReflect.Descriptor instead.
func (*BoundQuery) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{5}
}

func (x *BoundQuery) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *BoundQuery) GetBindVariables() map[string]*BindVariable {
	if x != nil {
		return x.BindVariables
	}
	return nil
}

// ExecuteOptions is passed around for all Execute calls.
type ExecuteOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, we will try to include an EventToken with the responses.
	IncludeEventToken bool `protobuf:"varint,2,opt,name=include_event_token,json=includeEventToken,proto3" json:"include_event_token,omitempty"`
	// If set, the fresher field may be set as a result comparison to this token.
	// This is a shortcut so the application doesn't need to care about
	// comparing EventTokens.
	CompareEventToken *EventToken `protobuf:"bytes,3,opt,name=compare_event_token,json=compareEventToken,proto3" json:"compare_event_token,omitempty"`
	// Controls what fields are returned in Field message responses from mysql, i.e.
	// field name, table name, etc. This is an optimization for high-QPS queries where
	// the client knows what it's getting
	IncludedFields ExecuteOptions_IncludedFields `protobuf:"varint,4,opt,name=included_fields,json=includedFields,proto3,enum=dolthub.vt.query.ExecuteOptions_IncludedFields" json:"included_fields,omitempty"`
	// client_rows_found specifies if rows_affected should return
	// rows found instead of rows affected. Behavior is defined
	// by MySQL's CLIENT_FOUND_ROWS flag.
	ClientFoundRows bool `protobuf:"varint,5,opt,name=client_found_rows,json=clientFoundRows,proto3" json:"client_found_rows,omitempty"`
	// workload specifies the type of workload:
	// OLTP: DMLs allowed, results have row count limit, and
	// query timeouts are shorter.
	// OLAP: DMLS not allowed, no limit on row count, timeouts
	// can be as high as desired.
	// DBA: no limit on rowcount or timeout, all queries allowed
	// but intended for long DMLs and DDLs.
	Workload ExecuteOptions_Workload `protobuf:"varint,6,opt,name=workload,proto3,enum=dolthub.vt.query.ExecuteOptions_Workload" json:"workload,omitempty"`
	// sql_select_limit sets an implicit limit on all select statements. Since
	// vitess also sets a rowcount limit on queries, the smallest value wins.
	SqlSelectLimit       int64                               `protobuf:"varint,8,opt,name=sql_select_limit,json=sqlSelectLimit,proto3" json:"sql_select_limit,omitempty"`
	TransactionIsolation ExecuteOptions_TransactionIsolation `protobuf:"varint,9,opt,name=transaction_isolation,json=transactionIsolation,proto3,enum=dolthub.vt.query.ExecuteOptions_TransactionIsolation" json:"transaction_isolation,omitempty"`
	// skip_query_plan_cache specifies if the query plan should be cached by vitess.
	// By default all query plans are cached.
	SkipQueryPlanCache bool `protobuf:"varint,10,opt,name=skip_query_plan_cache,json=skipQueryPlanCache,proto3" json:"skip_query_plan_cache,omitempty"`
}

func (x *ExecuteOptions) Reset() {
	*x = ExecuteOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteOptions) ProtoMessage() {}

func (x *ExecuteOptions) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteOptions.ProtoReflect.Descriptor instead.
func (*ExecuteOptions) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{6}
}

func (x *ExecuteOptions) GetIncludeEventToken() bool {
	if x != nil {
		return x.IncludeEventToken
	}
	return false
}

func (x *ExecuteOptions) GetCompareEventToken() *EventToken {
	if x != nil {
		return x.CompareEventToken
	}
	return nil
}

func (x *ExecuteOptions) GetIncludedFields() ExecuteOptions_IncludedFields {
	if x != nil {
		return x.IncludedFields
	}
	return ExecuteOptions_TYPE_AND_NAME
}

func (x *ExecuteOptions) GetClientFoundRows() bool {
	if x != nil {
		return x.ClientFoundRows
	}
	return false
}

func (x *ExecuteOptions) GetWorkload() ExecuteOptions_Workload {
	if x != nil {
		return x.Workload
	}
	return ExecuteOptions_UNSPECIFIED
}

func (x *ExecuteOptions) GetSqlSelectLimit() int64 {
	if x != nil {
		return x.SqlSelectLimit
	}
	return 0
}

func (x *ExecuteOptions) GetTransactionIsolation() ExecuteOptions_TransactionIsolation {
	if x != nil {
		return x.TransactionIsolation
	}
	return ExecuteOptions_DEFAULT
}

func (x *ExecuteOptions) GetSkipQueryPlanCache() bool {
	if x != nil {
		return x.SkipQueryPlanCache
	}
	return false
}

// Field describes a single column returned by a query
type Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the field as returned by mysql C API
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// vitess-defined type. Conversion function is in sqltypes package.
	Type Type `protobuf:"varint,2,opt,name=type,proto3,enum=dolthub.vt.query.Type" json:"type,omitempty"`
	// Remaining fields from mysql C API.
	// These fields are only populated when ExecuteOptions.included_fields
	// is set to IncludedFields.ALL.
	Table    string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	OrgTable string `protobuf:"bytes,4,opt,name=org_table,json=orgTable,proto3" json:"org_table,omitempty"`
	Database string `protobuf:"bytes,5,opt,name=database,proto3" json:"database,omitempty"`
	OrgName  string `protobuf:"bytes,6,opt,name=org_name,json=orgName,proto3" json:"org_name,omitempty"`
	// column_length is really a uint32. All 32 bits can be used.
	ColumnLength uint32 `protobuf:"varint,7,opt,name=column_length,json=columnLength,proto3" json:"column_length,omitempty"`
	// charset is actually a uint16. Only the lower 16 bits are used.
	Charset uint32 `protobuf:"varint,8,opt,name=charset,proto3" json:"charset,omitempty"`
	// decimals is actually a uint8. Only the lower 8 bits are used.
	Decimals uint32 `protobuf:"varint,9,opt,name=decimals,proto3" json:"decimals,omitempty"`
	// flags is actually a uint16. Only the lower 16 bits are used.
	Flags uint32 `protobuf:"varint,10,opt,name=flags,proto3" json:"flags,omitempty"`
}

func (x *Field) Reset() {
	*x = Field{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field) ProtoMessage() {}

func (x *Field) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field.ProtoReflect.Descriptor instead.
func (*Field) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{7}
}

func (x *Field) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Field) GetType() Type {
	if x != nil {
		return x.Type
	}
	return Type_NULL_TYPE
}

func (x *Field) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *Field) GetOrgTable() string {
	if x != nil {
		return x.OrgTable
	}
	return ""
}

func (x *Field) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *Field) GetOrgName() string {
	if x != nil {
		return x.OrgName
	}
	return ""
}

func (x *Field) GetColumnLength() uint32 {
	if x != nil {
		return x.ColumnLength
	}
	return 0
}

func (x *Field) GetCharset() uint32 {
	if x != nil {
		return x.Charset
	}
	return 0
}

func (x *Field) GetDecimals() uint32 {
	if x != nil {
		return x.Decimals
	}
	return 0
}

func (x *Field) GetFlags() uint32 {
	if x != nil {
		return x.Flags
	}
	return 0
}

// Row is a database row.
type Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// lengths contains the length of each value in values.
	// A length of -1 means that the field is NULL. While
	// reading values, you have to accummulate the length
	// to know the offset where the next value begins in values.
	Lengths []int64 `protobuf:"zigzag64,1,rep,packed,name=lengths,proto3" json:"lengths,omitempty"`
	// values contains a concatenation of all values in the row.
	Values []byte `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
}

func (x *Row) Reset() {
	*x = Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Row.ProtoReflect.Descriptor instead.
func (*Row) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{8}
}

func (x *Row) GetLengths() []int64 {
	if x != nil {
		return x.Lengths
	}
	return nil
}

func (x *Row) GetValues() []byte {
	if x != nil {
		return x.Values
	}
	return nil
}

// ResultExtras contains optional out-of-band information. Usually the
// extras are requested by adding ExecuteOptions flags.
type ResultExtras struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// event_token is populated if the include_event_token flag is set
	// in ExecuteOptions.
	EventToken *EventToken `protobuf:"bytes,1,opt,name=event_token,json=eventToken,proto3" json:"event_token,omitempty"`
	// If set, it means the data returned with this result is fresher
	// than the compare_token passed in the ExecuteOptions.
	Fresher bool `protobuf:"varint,2,opt,name=fresher,proto3" json:"fresher,omitempty"`
}

func (x *ResultExtras) Reset() {
	*x = ResultExtras{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResultExtras) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResultExtras) ProtoMessage() {}

func (x *ResultExtras) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResultExtras.ProtoReflect.Descriptor instead.
func (*ResultExtras) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{9}
}

func (x *ResultExtras) GetEventToken() *EventToken {
	if x != nil {
		return x.EventToken
	}
	return nil
}

func (x *ResultExtras) GetFresher() bool {
	if x != nil {
		return x.Fresher
	}
	return false
}

// QueryResult is returned by Execute and ExecuteStream.
//
// As returned by Execute, len(fields) is always equal to len(row)
// (for each row in rows).
//
// As returned by StreamExecute, the first QueryResult has the fields
// set, and subsequent QueryResult have rows set. And as Execute,
// len(QueryResult[0].fields) is always equal to len(row) (for each
// row in rows for each QueryResult in QueryResult[1:]).
type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fields       []*Field      `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	RowsAffected uint64        `protobuf:"varint,2,opt,name=rows_affected,json=rowsAffected,proto3" json:"rows_affected,omitempty"`
	InsertId     uint64        `protobuf:"varint,3,opt,name=insert_id,json=insertId,proto3" json:"insert_id,omitempty"`
	Rows         []*Row        `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
	Extras       *ResultExtras `protobuf:"bytes,5,opt,name=extras,proto3" json:"extras,omitempty"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{10}
}

func (x *QueryResult) GetFields() []*Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *QueryResult) GetRowsAffected() uint64 {
	if x != nil {
		return x.RowsAffected
	}
	return 0
}

func (x *QueryResult) GetInsertId() uint64 {
	if x != nil {
		return x.InsertId
	}
	return 0
}

func (x *QueryResult) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *QueryResult) GetExtras() *ResultExtras {
	if x != nil {
		return x.Extras
	}
	return nil
}

// QueryWarning is used to convey out of band query execution warnings
// by storing in the vtgate.Session
type QueryWarning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Code    uint32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *QueryWarning) Reset() {
	*x = QueryWarning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryWarning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryWarning) ProtoMessage() {}

func (x *QueryWarning) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryWarning.ProtoReflect.Descriptor instead.
func (*QueryWarning) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{11}
}

func (x *QueryWarning) GetCode() uint32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *QueryWarning) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// StreamEvent describes a set of transformations that happened as a
// single transactional unit on a server. It is streamed back by the
// Update Stream calls.
type StreamEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The statements in this transaction.
	Statements []*StreamEvent_Statement `protobuf:"bytes,1,rep,name=statements,proto3" json:"statements,omitempty"`
	// The Event Token for this event.
	EventToken *EventToken `protobuf:"bytes,2,opt,name=event_token,json=eventToken,proto3" json:"event_token,omitempty"`
}

func (x *StreamEvent) Reset() {
	*x = StreamEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamEvent) ProtoMessage() {}

func (x *StreamEvent) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamEvent.ProtoReflect.Descriptor instead.
func (*StreamEvent) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{12}
}

func (x *StreamEvent) GetStatements() []*StreamEvent_Statement {
	if x != nil {
		return x.Statements
	}
	return nil
}

func (x *StreamEvent) GetEventToken() *EventToken {
	if x != nil {
		return x.EventToken
	}
	return nil
}

// ExecuteRequest is the payload to Execute
type ExecuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	TransactionId     int64           `protobuf:"varint,5,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteRequest) Reset() {
	*x = ExecuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteRequest) ProtoMessage() {}

func (x *ExecuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteRequest.ProtoReflect.Descriptor instead.
func (*ExecuteRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{13}
}

func (x *ExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *ExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *ExecuteRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *ExecuteRequest) GetQuery() *BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *ExecuteRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

func (x *ExecuteRequest) GetOptions() *ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteResponse is the returned value from Execute
type ExecuteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ExecuteResponse) Reset() {
	*x = ExecuteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteResponse) ProtoMessage() {}

func (x *ExecuteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteResponse.ProtoReflect.Descriptor instead.
func (*ExecuteResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{14}
}

func (x *ExecuteResponse) GetResult() *QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// ResultWithError represents a query response
// in the form of result or error but not both.
// TODO: To be used in ExecuteBatchResponse and BeginExecuteBatchResponse.
type ResultWithError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an query level error, only set if result is unset.
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *QueryResult `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ResultWithError) Reset() {
	*x = ResultWithError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResultWithError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResultWithError) ProtoMessage() {}

func (x *ResultWithError) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResultWithError.ProtoReflect.Descriptor instead.
func (*ResultWithError) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{15}
}

func (x *ResultWithError) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ResultWithError) GetResult() *QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// ExecuteBatchRequest is the payload to ExecuteBatch
type ExecuteBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Queries           []*BoundQuery   `protobuf:"bytes,4,rep,name=queries,proto3" json:"queries,omitempty"`
	AsTransaction     bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction,proto3" json:"as_transaction,omitempty"`
	TransactionId     int64           `protobuf:"varint,6,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,7,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *ExecuteBatchRequest) Reset() {
	*x = ExecuteBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchRequest) ProtoMessage() {}

func (x *ExecuteBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchRequest.ProtoReflect.Descriptor instead.
func (*ExecuteBatchRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{16}
}

func (x *ExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *ExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *ExecuteBatchRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *ExecuteBatchRequest) GetQueries() []*BoundQuery {
	if x != nil {
		return x.Queries
	}
	return nil
}

func (x *ExecuteBatchRequest) GetAsTransaction() bool {
	if x != nil {
		return x.AsTransaction
	}
	return false
}

func (x *ExecuteBatchRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

func (x *ExecuteBatchRequest) GetOptions() *ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// ExecuteBatchResponse is the returned value from ExecuteBatch
type ExecuteBatchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Results []*QueryResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *ExecuteBatchResponse) Reset() {
	*x = ExecuteBatchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchResponse) ProtoMessage() {}

func (x *ExecuteBatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchResponse.ProtoReflect.Descriptor instead.
func (*ExecuteBatchResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{17}
}

func (x *ExecuteBatchResponse) GetResults() []*QueryResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// StreamExecuteRequest is the payload to StreamExecute
type StreamExecuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`
	TransactionId     int64           `protobuf:"varint,6,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *StreamExecuteRequest) Reset() {
	*x = StreamExecuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteRequest) ProtoMessage() {}

func (x *StreamExecuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteRequest.ProtoReflect.Descriptor instead.
func (*StreamExecuteRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{18}
}

func (x *StreamExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *StreamExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *StreamExecuteRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *StreamExecuteRequest) GetQuery() *BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *StreamExecuteRequest) GetOptions() *ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *StreamExecuteRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

// StreamExecuteResponse is the returned value from StreamExecute
type StreamExecuteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *StreamExecuteResponse) Reset() {
	*x = StreamExecuteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamExecuteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamExecuteResponse) ProtoMessage() {}

func (x *StreamExecuteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamExecuteResponse.ProtoReflect.Descriptor instead.
func (*StreamExecuteResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{19}
}

func (x *StreamExecuteResponse) GetResult() *QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// BeginRequest is the payload to Begin
type BeginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,4,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *BeginRequest) Reset() {
	*x = BeginRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginRequest) ProtoMessage() {}

func (x *BeginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginRequest.ProtoReflect.Descriptor instead.
func (*BeginRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{20}
}

func (x *BeginRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *BeginRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *BeginRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *BeginRequest) GetOptions() *ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// BeginResponse is the returned value from Begin
type BeginResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TransactionId int64 `protobuf:"varint,1,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *BeginResponse) Reset() {
	*x = BeginResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginResponse) ProtoMessage() {}

func (x *BeginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginResponse.ProtoReflect.Descriptor instead.
func (*BeginResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{21}
}

func (x *BeginResponse) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

// CommitRequest is the payload to Commit
type CommitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *CommitRequest) Reset() {
	*x = CommitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRequest) ProtoMessage() {}

func (x *CommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRequest.ProtoReflect.Descriptor instead.
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{22}
}

func (x *CommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *CommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *CommitRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *CommitRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

// CommitResponse is the returned value from Commit
type CommitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommitResponse) Reset() {
	*x = CommitResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse) ProtoMessage() {}

func (x *CommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse.ProtoReflect.Descriptor instead.
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{23}
}

// RollbackRequest is the payload to Rollback
type RollbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *RollbackRequest) Reset() {
	*x = RollbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackRequest) ProtoMessage() {}

func (x *RollbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackRequest.ProtoReflect.Descriptor instead.
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{24}
}

func (x *RollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *RollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *RollbackRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *RollbackRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

// RollbackResponse is the returned value from Rollback
type RollbackResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RollbackResponse) Reset() {
	*x = RollbackResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackResponse) ProtoMessage() {}

func (x *RollbackResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackResponse.ProtoReflect.Descriptor instead.
func (*RollbackResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{25}
}

// PrepareRequest is the payload to Prepare
type PrepareRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid,proto3" json:"dtid,omitempty"`
}

func (x *PrepareRequest) Reset() {
	*x = PrepareRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareRequest) ProtoMessage() {}

func (x *PrepareRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareRequest.ProtoReflect.Descriptor instead.
func (*PrepareRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{26}
}

func (x *PrepareRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *PrepareRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *PrepareRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *PrepareRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

func (x *PrepareRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

// PrepareResponse is the returned value from Prepare
type PrepareResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PrepareResponse) Reset() {
	*x = PrepareResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareResponse) ProtoMessage() {}

func (x *PrepareResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareResponse.ProtoReflect.Descriptor instead.
func (*PrepareResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{27}
}

// CommitPreparedRequest is the payload to CommitPrepared
type CommitPreparedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid,proto3" json:"dtid,omitempty"`
}

func (x *CommitPreparedRequest) Reset() {
	*x = CommitPreparedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitPreparedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitPreparedRequest) ProtoMessage() {}

func (x *CommitPreparedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitPreparedRequest.ProtoReflect.Descriptor instead.
func (*CommitPreparedRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{28}
}

func (x *CommitPreparedRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *CommitPreparedRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *CommitPreparedRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *CommitPreparedRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

// CommitPreparedResponse is the returned value from CommitPrepared
type CommitPreparedResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommitPreparedResponse) Reset() {
	*x = CommitPreparedResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitPreparedResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitPreparedResponse) ProtoMessage() {}

func (x *CommitPreparedResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitPreparedResponse.ProtoReflect.Descriptor instead.
func (*CommitPreparedResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{29}
}

// RollbackPreparedRequest is the payload to RollbackPrepared
type RollbackPreparedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid,proto3" json:"dtid,omitempty"`
}

func (x *RollbackPreparedRequest) Reset() {
	*x = RollbackPreparedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackPreparedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackPreparedRequest) ProtoMessage() {}

func (x *RollbackPreparedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackPreparedRequest.ProtoReflect.Descriptor instead.
func (*RollbackPreparedRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{30}
}

func (x *RollbackPreparedRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *RollbackPreparedRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *RollbackPreparedRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *RollbackPreparedRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

func (x *RollbackPreparedRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

// RollbackPreparedResponse is the returned value from RollbackPrepared
type RollbackPreparedResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RollbackPreparedResponse) Reset() {
	*x = RollbackPreparedResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackPreparedResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackPreparedResponse) ProtoMessage() {}

func (x *RollbackPreparedResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackPreparedResponse.ProtoReflect.Descriptor instead.
func (*RollbackPreparedResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{31}
}

// CreateTransactionRequest is the payload to CreateTransaction
type CreateTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid,proto3" json:"dtid,omitempty"`
	Participants      []*Target       `protobuf:"bytes,5,rep,name=participants,proto3" json:"participants,omitempty"`
}

func (x *CreateTransactionRequest) Reset() {
	*x = CreateTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTransactionRequest) ProtoMessage() {}

func (x *CreateTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTransactionRequest.ProtoReflect.Descriptor instead.
func (*CreateTransactionRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{32}
}

func (x *CreateTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *CreateTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *CreateTransactionRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *CreateTransactionRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

func (x *CreateTransactionRequest) GetParticipants() []*Target {
	if x != nil {
		return x.Participants
	}
	return nil
}

// CreateTransactionResponse is the returned value from CreateTransaction
type CreateTransactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateTransactionResponse) Reset() {
	*x = CreateTransactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTransactionResponse) ProtoMessage() {}

func (x *CreateTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTransactionResponse.ProtoReflect.Descriptor instead.
func (*CreateTransactionResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{33}
}

// StartCommitRequest is the payload to StartCommit
type StartCommitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid,proto3" json:"dtid,omitempty"`
}

func (x *StartCommitRequest) Reset() {
	*x = StartCommitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartCommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartCommitRequest) ProtoMessage() {}

func (x *StartCommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartCommitRequest.ProtoReflect.Descriptor instead.
func (*StartCommitRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{34}
}

func (x *StartCommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *StartCommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *StartCommitRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *StartCommitRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

func (x *StartCommitRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

// StartCommitResponse is the returned value from StartCommit
type StartCommitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StartCommitResponse) Reset() {
	*x = StartCommitResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartCommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartCommitResponse) ProtoMessage() {}

func (x *StartCommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartCommitResponse.ProtoReflect.Descriptor instead.
func (*StartCommitResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{35}
}

// SetRollbackRequest is the payload to SetRollback
type SetRollbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid,proto3" json:"dtid,omitempty"`
}

func (x *SetRollbackRequest) Reset() {
	*x = SetRollbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetRollbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRollbackRequest) ProtoMessage() {}

func (x *SetRollbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetRollbackRequest.ProtoReflect.Descriptor instead.
func (*SetRollbackRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{36}
}

func (x *SetRollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *SetRollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *SetRollbackRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *SetRollbackRequest) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

func (x *SetRollbackRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

// SetRollbackResponse is the returned value from SetRollback
type SetRollbackResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetRollbackResponse) Reset() {
	*x = SetRollbackResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetRollbackResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRollbackResponse) ProtoMessage() {}

func (x *SetRollbackResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetRollbackResponse.ProtoReflect.Descriptor instead.
func (*SetRollbackResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{37}
}

// ConcludeTransactionRequest is the payload to ConcludeTransaction
type ConcludeTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid,proto3" json:"dtid,omitempty"`
}

func (x *ConcludeTransactionRequest) Reset() {
	*x = ConcludeTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcludeTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcludeTransactionRequest) ProtoMessage() {}

func (x *ConcludeTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcludeTransactionRequest.ProtoReflect.Descriptor instead.
func (*ConcludeTransactionRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{38}
}

func (x *ConcludeTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *ConcludeTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *ConcludeTransactionRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *ConcludeTransactionRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

// ConcludeTransactionResponse is the returned value from ConcludeTransaction
type ConcludeTransactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ConcludeTransactionResponse) Reset() {
	*x = ConcludeTransactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConcludeTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConcludeTransactionResponse) ProtoMessage() {}

func (x *ConcludeTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConcludeTransactionResponse.ProtoReflect.Descriptor instead.
func (*ConcludeTransactionResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{39}
}

// ReadTransactionRequest is the payload to ReadTransaction
type ReadTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid,proto3" json:"dtid,omitempty"`
}

func (x *ReadTransactionRequest) Reset() {
	*x = ReadTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTransactionRequest) ProtoMessage() {}

func (x *ReadTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTransactionRequest.ProtoReflect.Descriptor instead.
func (*ReadTransactionRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{40}
}

func (x *ReadTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *ReadTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *ReadTransactionRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *ReadTransactionRequest) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

// ReadTransactionResponse is the returned value from ReadTransaction
type ReadTransactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metadata *TransactionMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ReadTransactionResponse) Reset() {
	*x = ReadTransactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTransactionResponse) ProtoMessage() {}

func (x *ReadTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTransactionResponse.ProtoReflect.Descriptor instead.
func (*ReadTransactionResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{41}
}

func (x *ReadTransactionResponse) GetMetadata() *TransactionMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// BeginExecuteRequest is the payload to BeginExecute
type BeginExecuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *BeginExecuteRequest) Reset() {
	*x = BeginExecuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginExecuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginExecuteRequest) ProtoMessage() {}

func (x *BeginExecuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginExecuteRequest.ProtoReflect.Descriptor instead.
func (*BeginExecuteRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{42}
}

func (x *BeginExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *BeginExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *BeginExecuteRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *BeginExecuteRequest) GetQuery() *BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *BeginExecuteRequest) GetOptions() *ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// BeginExecuteResponse is the returned value from BeginExecute
type BeginExecuteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// transaction_id may be set, even when an error is returned, if the begin
	// worked but the execute failed.
	Error  *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Result *QueryResult    `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	// transaction_id might be non-zero even if an error is present.
	TransactionId int64 `protobuf:"varint,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *BeginExecuteResponse) Reset() {
	*x = BeginExecuteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginExecuteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginExecuteResponse) ProtoMessage() {}

func (x *BeginExecuteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginExecuteResponse.ProtoReflect.Descriptor instead.
func (*BeginExecuteResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{43}
}

func (x *BeginExecuteResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *BeginExecuteResponse) GetResult() *QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *BeginExecuteResponse) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

// BeginExecuteBatchRequest is the payload to BeginExecuteBatch
type BeginExecuteBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Queries           []*BoundQuery   `protobuf:"bytes,4,rep,name=queries,proto3" json:"queries,omitempty"`
	AsTransaction     bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction,proto3" json:"as_transaction,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *BeginExecuteBatchRequest) Reset() {
	*x = BeginExecuteBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginExecuteBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginExecuteBatchRequest) ProtoMessage() {}

func (x *BeginExecuteBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginExecuteBatchRequest.ProtoReflect.Descriptor instead.
func (*BeginExecuteBatchRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{44}
}

func (x *BeginExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *BeginExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *BeginExecuteBatchRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *BeginExecuteBatchRequest) GetQueries() []*BoundQuery {
	if x != nil {
		return x.Queries
	}
	return nil
}

func (x *BeginExecuteBatchRequest) GetAsTransaction() bool {
	if x != nil {
		return x.AsTransaction
	}
	return false
}

func (x *BeginExecuteBatchRequest) GetOptions() *ExecuteOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// BeginExecuteBatchResponse is the returned value from BeginExecuteBatch
type BeginExecuteBatchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// error contains an application level error if necessary. Note the
	// transaction_id may be set, even when an error is returned, if the begin
	// worked but the execute failed.
	Error   *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Results []*QueryResult  `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	// transaction_id might be non-zero even if an error is present.
	TransactionId int64 `protobuf:"varint,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *BeginExecuteBatchResponse) Reset() {
	*x = BeginExecuteBatchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginExecuteBatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginExecuteBatchResponse) ProtoMessage() {}

func (x *BeginExecuteBatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginExecuteBatchResponse.ProtoReflect.Descriptor instead.
func (*BeginExecuteBatchResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{45}
}

func (x *BeginExecuteBatchResponse) GetError() *vtrpc.RPCError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *BeginExecuteBatchResponse) GetResults() []*QueryResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *BeginExecuteBatchResponse) GetTransactionId() int64 {
	if x != nil {
		return x.TransactionId
	}
	return 0
}

// MessageStreamRequest is the request payload for MessageStream.
type MessageStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// name is the message table name.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *MessageStreamRequest) Reset() {
	*x = MessageStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageStreamRequest) ProtoMessage() {}

func (x *MessageStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageStreamRequest.ProtoReflect.Descriptor instead.
func (*MessageStreamRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{46}
}

func (x *MessageStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *MessageStreamRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *MessageStreamRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *MessageStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// MessageStreamResponse is a response for MessageStream.
type MessageStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *MessageStreamResponse) Reset() {
	*x = MessageStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageStreamResponse) ProtoMessage() {}

func (x *MessageStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageStreamResponse.ProtoReflect.Descriptor instead.
func (*MessageStreamResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{47}
}

func (x *MessageStreamResponse) GetResult() *QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// MessageAckRequest is the request payload for MessageAck.
type MessageAckRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// name is the message table name.
	Name string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	Ids  []*Value `protobuf:"bytes,5,rep,name=ids,proto3" json:"ids,omitempty"`
}

func (x *MessageAckRequest) Reset() {
	*x = MessageAckRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageAckRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageAckRequest) ProtoMessage() {}

func (x *MessageAckRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageAckRequest.ProtoReflect.Descriptor instead.
func (*MessageAckRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{48}
}

func (x *MessageAckRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *MessageAckRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *MessageAckRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *MessageAckRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MessageAckRequest) GetIds() []*Value {
	if x != nil {
		return x.Ids
	}
	return nil
}

// MessageAckResponse is the response for MessageAck.
type MessageAckResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// result contains the result of the ack operation.
	// Since this acts like a DML, only
	// RowsAffected is returned in the result.
	Result *QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *MessageAckResponse) Reset() {
	*x = MessageAckResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageAckResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageAckResponse) ProtoMessage() {}

func (x *MessageAckResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageAckResponse.ProtoReflect.Descriptor instead.
func (*MessageAckResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{49}
}

func (x *MessageAckResponse) GetResult() *QueryResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// SplitQueryRequest is the payload for SplitQuery sent by VTGate to a VTTablet.
// See vtgate.SplitQueryRequest for more details.
type SplitQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	SplitColumn       []string        `protobuf:"bytes,5,rep,name=split_column,json=splitColumn,proto3" json:"split_column,omitempty"`
	// Exactly one of the following must be nonzero.
	SplitCount          int64                       `protobuf:"varint,6,opt,name=split_count,json=splitCount,proto3" json:"split_count,omitempty"`
	NumRowsPerQueryPart int64                       `protobuf:"varint,8,opt,name=num_rows_per_query_part,json=numRowsPerQueryPart,proto3" json:"num_rows_per_query_part,omitempty"`
	Algorithm           SplitQueryRequest_Algorithm `protobuf:"varint,9,opt,name=algorithm,proto3,enum=dolthub.vt.query.SplitQueryRequest_Algorithm" json:"algorithm,omitempty"`
}

func (x *SplitQueryRequest) Reset() {
	*x = SplitQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitQueryRequest) ProtoMessage() {}

func (x *SplitQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitQueryRequest.ProtoReflect.Descriptor instead.
func (*SplitQueryRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{50}
}

func (x *SplitQueryRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *SplitQueryRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *SplitQueryRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *SplitQueryRequest) GetQuery() *BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *SplitQueryRequest) GetSplitColumn() []string {
	if x != nil {
		return x.SplitColumn
	}
	return nil
}

func (x *SplitQueryRequest) GetSplitCount() int64 {
	if x != nil {
		return x.SplitCount
	}
	return 0
}

func (x *SplitQueryRequest) GetNumRowsPerQueryPart() int64 {
	if x != nil {
		return x.NumRowsPerQueryPart
	}
	return 0
}

func (x *SplitQueryRequest) GetAlgorithm() SplitQueryRequest_Algorithm {
	if x != nil {
		return x.Algorithm
	}
	return SplitQueryRequest_EQUAL_SPLITS
}

// QuerySplit represents one query to execute on the tablet
type QuerySplit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// query is the query to execute
	Query *BoundQuery `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// row_count is the approximate row count the query will return
	RowCount int64 `protobuf:"varint,2,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
}

func (x *QuerySplit) Reset() {
	*x = QuerySplit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuerySplit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuerySplit) ProtoMessage() {}

func (x *QuerySplit) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuerySplit.ProtoReflect.Descriptor instead.
func (*QuerySplit) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{51}
}

func (x *QuerySplit) GetQuery() *BoundQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *QuerySplit) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

// SplitQueryResponse is returned by SplitQuery and represents all the queries
// to execute in order to get the entire data set.
type SplitQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Queries []*QuerySplit `protobuf:"bytes,1,rep,name=queries,proto3" json:"queries,omitempty"`
}

func (x *SplitQueryResponse) Reset() {
	*x = SplitQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitQueryResponse) ProtoMessage() {}

func (x *SplitQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitQueryResponse.ProtoReflect.Descriptor instead.
func (*SplitQueryResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{52}
}

func (x *SplitQueryResponse) GetQueries() []*QuerySplit {
	if x != nil {
		return x.Queries
	}
	return nil
}

// StreamHealthRequest is the payload for StreamHealth
type StreamHealthRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StreamHealthRequest) Reset() {
	*x = StreamHealthRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamHealthRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamHealthRequest) ProtoMessage() {}

func (x *StreamHealthRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamHealthRequest.ProtoReflect.Descriptor instead.
func (*StreamHealthRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{53}
}

// RealtimeStats contains information about the tablet status.
// It is only valid for a single tablet.
type RealtimeStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// health_error is the last error we got from health check,
	// or empty is the server is healthy. This is used for subset selection,
	// we do not send queries to servers that are not healthy.
	HealthError string `protobuf:"bytes,1,opt,name=health_error,json=healthError,proto3" json:"health_error,omitempty"`
	// seconds_behind_master is populated for slaves only. It indicates
	// how far behind on (MySQL) replication a slave currently is.  It is used
	// by clients for subset selection (so we don't try to send traffic
	// to tablets that are too far behind).
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// TODO(mberlin): Let's switch it to int64 instead?
	SecondsBehindMaster uint32 `protobuf:"varint,2,opt,name=seconds_behind_master,json=secondsBehindMaster,proto3" json:"seconds_behind_master,omitempty"`
	// bin_log_players_count is the number of currently running binlog players.
	// if the value is 0, it means that filtered replication is currently not
	// running on the tablet. If >0, filtered replication is running.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	BinlogPlayersCount int32 `protobuf:"varint,3,opt,name=binlog_players_count,json=binlogPlayersCount,proto3" json:"binlog_players_count,omitempty"`
	// seconds_behind_master_filtered_replication is populated for the receiving
	// master of an ongoing filtered replication only.
	// It specifies how far the receiving master lags behind the sending master.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// NOTE: This field must not be evaluated if "bin_log_players_count" is 0.
	SecondsBehindMasterFilteredReplication int64 `protobuf:"varint,4,opt,name=seconds_behind_master_filtered_replication,json=secondsBehindMasterFilteredReplication,proto3" json:"seconds_behind_master_filtered_replication,omitempty"`
	// cpu_usage is used for load-based balancing
	CpuUsage float64 `protobuf:"fixed64,5,opt,name=cpu_usage,json=cpuUsage,proto3" json:"cpu_usage,omitempty"`
	// qps is the average QPS (queries per second) rate in the last XX seconds
	// where XX is usually 60 (See query_service_stats.go).
	Qps float64 `protobuf:"fixed64,6,opt,name=qps,proto3" json:"qps,omitempty"`
}

func (x *RealtimeStats) Reset() {
	*x = RealtimeStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RealtimeStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RealtimeStats) ProtoMessage() {}

func (x *RealtimeStats) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RealtimeStats.ProtoReflect.Descriptor instead.
func (*RealtimeStats) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{54}
}

func (x *RealtimeStats) GetHealthError() string {
	if x != nil {
		return x.HealthError
	}
	return ""
}

func (x *RealtimeStats) GetSecondsBehindMaster() uint32 {
	if x != nil {
		return x.SecondsBehindMaster
	}
	return 0
}

func (x *RealtimeStats) GetBinlogPlayersCount() int32 {
	if x != nil {
		return x.BinlogPlayersCount
	}
	return 0
}

func (x *RealtimeStats) GetSecondsBehindMasterFilteredReplication() int64 {
	if x != nil {
		return x.SecondsBehindMasterFilteredReplication
	}
	return 0
}

func (x *RealtimeStats) GetCpuUsage() float64 {
	if x != nil {
		return x.CpuUsage
	}
	return 0
}

func (x *RealtimeStats) GetQps() float64 {
	if x != nil {
		return x.Qps
	}
	return 0
}

// AggregateStats contains information about the health of a group of
// tablets for a Target.  It is used to propagate stats from a vtgate
// to another, or from the Gateway layer of a vtgate to the routing
// layer.
type AggregateStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// healthy_tablet_count is the number of healthy tablets in the group.
	HealthyTabletCount int32 `protobuf:"varint,1,opt,name=healthy_tablet_count,json=healthyTabletCount,proto3" json:"healthy_tablet_count,omitempty"`
	// unhealthy_tablet_count is the number of unhealthy tablets in the group.
	UnhealthyTabletCount int32 `protobuf:"varint,2,opt,name=unhealthy_tablet_count,json=unhealthyTabletCount,proto3" json:"unhealthy_tablet_count,omitempty"`
	// seconds_behind_master_min is the minimum of the
	// seconds_behind_master values of the healthy tablets. It is unset
	// if the tablet type is master.
	SecondsBehindMasterMin uint32 `protobuf:"varint,3,opt,name=seconds_behind_master_min,json=secondsBehindMasterMin,proto3" json:"seconds_behind_master_min,omitempty"`
	// seconds_behind_master_max is the maximum of the
	// seconds_behind_master values of the healthy tablets. It is unset
	// if the tablet type is master.
	SecondsBehindMasterMax uint32 `protobuf:"varint,4,opt,name=seconds_behind_master_max,json=secondsBehindMasterMax,proto3" json:"seconds_behind_master_max,omitempty"`
}

func (x *AggregateStats) Reset() {
	*x = AggregateStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateStats) ProtoMessage() {}

func (x *AggregateStats) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateStats.ProtoReflect.Descriptor instead.
func (*AggregateStats) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{55}
}

func (x *AggregateStats) GetHealthyTabletCount() int32 {
	if x != nil {
		return x.HealthyTabletCount
	}
	return 0
}

func (x *AggregateStats) GetUnhealthyTabletCount() int32 {
	if x != nil {
		return x.UnhealthyTabletCount
	}
	return 0
}

func (x *AggregateStats) GetSecondsBehindMasterMin() uint32 {
	if x != nil {
		return x.SecondsBehindMasterMin
	}
	return 0
}

func (x *AggregateStats) GetSecondsBehindMasterMax() uint32 {
	if x != nil {
		return x.SecondsBehindMasterMax
	}
	return 0
}

// StreamHealthResponse is streamed by StreamHealth on a regular basis.
// When StreamHealth is used between a vtgate and vttablet:
// - target describes the tablet.
// - realtime_stats is set.
// - aggregate_stats is not set.
// When StreamHealth is used between two vtgates:
// - target describes the group of tablets.
// - realtime_stats is not set.
// - aggregate_stats is set.
type StreamHealthResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// target is the current server type. Only queries with that exact Target
	// record will be accepted (the cell may not match, however).
	Target *Target `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// serving is true iff the tablet is serving. A tablet may not be serving
	// if filtered replication is enabled on a master for instance,
	// or if a replica should not be used because the keyspace is being resharded.
	Serving bool `protobuf:"varint,2,opt,name=serving,proto3" json:"serving,omitempty"`
	// tablet_externally_reparented_timestamp can be interpreted as the
	// last time we knew that this tablet was the MASTER of this shard
	// (if StreamHealthResponse describes a group of tablets, between
	// two vtgates, only one master will be present in the group, and
	// this is this master's value).
	//
	// It is used by vtgate when determining the current MASTER of a shard.
	// If vtgate sees more than one MASTER tablet, this timestamp is used
	// as tiebreaker where the MASTER with the highest timestamp wins.
	// Another usage of this timestamp is in go/vt/vtgate/buffer to detect the end
	// of a reparent (failover) and stop buffering.
	//
	// In practice, this field is set to:
	// a) the last time the RPC tabletmanager.TabletExternallyReparented was
	//
	//	called on this tablet (usually done by an external failover tool e.g.
	//	Orchestrator). The failover tool can call this as long as we are the
	//	master i.e. even ages after the last reparent occurred.
	//
	// OR
	// b) the last time an active reparent was executed through a vtctl command
	//
	//	(InitShardMaster, PlannedReparentShard, EmergencyReparentShard)
	//
	// OR
	// c) the last time vttablet was started and it initialized its tablet type
	//
	//	as MASTER because it was recorded as the shard's current master in the
	//	topology (see go/vt/vttablet/tabletmanager/init_tablet.go)
	//
	// OR
	// d) 0 if the vttablet was never a MASTER.
	TabletExternallyReparentedTimestamp int64 `protobuf:"varint,3,opt,name=tablet_externally_reparented_timestamp,json=tabletExternallyReparentedTimestamp,proto3" json:"tablet_externally_reparented_timestamp,omitempty"`
	// realtime_stats contains information about the tablet status.
	// It is only filled in if the information is about a tablet.
	RealtimeStats *RealtimeStats `protobuf:"bytes,4,opt,name=realtime_stats,json=realtimeStats,proto3" json:"realtime_stats,omitempty"`
	// AggregateStats constrains information about the group of tablet status.
	// It is only filled in if the information is about a group of tablets.
	AggregateStats *AggregateStats `protobuf:"bytes,6,opt,name=aggregate_stats,json=aggregateStats,proto3" json:"aggregate_stats,omitempty"`
	// tablet_alias is the alias of the sending tablet. The discovery/healthcheck.go
	// code uses it to verify that it's talking to the correct tablet and that it
	// hasn't changed in the meantime e.g. due to tablet restarts where ports or
	// ips have been reused but assigned differently.
	TabletAlias *topodata.TabletAlias `protobuf:"bytes,5,opt,name=tablet_alias,json=tabletAlias,proto3" json:"tablet_alias,omitempty"`
}

func (x *StreamHealthResponse) Reset() {
	*x = StreamHealthResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamHealthResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamHealthResponse) ProtoMessage() {}

func (x *StreamHealthResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamHealthResponse.ProtoReflect.Descriptor instead.
func (*StreamHealthResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{56}
}

func (x *StreamHealthResponse) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *StreamHealthResponse) GetServing() bool {
	if x != nil {
		return x.Serving
	}
	return false
}

func (x *StreamHealthResponse) GetTabletExternallyReparentedTimestamp() int64 {
	if x != nil {
		return x.TabletExternallyReparentedTimestamp
	}
	return 0
}

func (x *StreamHealthResponse) GetRealtimeStats() *RealtimeStats {
	if x != nil {
		return x.RealtimeStats
	}
	return nil
}

func (x *StreamHealthResponse) GetAggregateStats() *AggregateStats {
	if x != nil {
		return x.AggregateStats
	}
	return nil
}

func (x *StreamHealthResponse) GetTabletAlias() *topodata.TabletAlias {
	if x != nil {
		return x.TabletAlias
	}
	return nil
}

// UpdateStreamRequest is the payload for UpdateStream. At most one of
// position and timestamp can be set. If neither is set, we will start
// streaming from the current binlog position.
type UpdateStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// If position is set, we will start the streaming from that replication
	// position. Incompatible with timestamp.
	Position string `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
	// If timestamp is set, we will start the streaming from the first
	// event in the binlogs that have that timestamp. Incompatible with position.
	Timestamp int64 `protobuf:"varint,5,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *UpdateStreamRequest) Reset() {
	*x = UpdateStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStreamRequest) ProtoMessage() {}

func (x *UpdateStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateStreamRequest) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{57}
}

func (x *UpdateStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if x != nil {
		return x.EffectiveCallerId
	}
	return nil
}

func (x *UpdateStreamRequest) GetImmediateCallerId() *VTGateCallerID {
	if x != nil {
		return x.ImmediateCallerId
	}
	return nil
}

func (x *UpdateStreamRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *UpdateStreamRequest) GetPosition() string {
	if x != nil {
		return x.Position
	}
	return ""
}

func (x *UpdateStreamRequest) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

// UpdateStreamResponse is returned by UpdateStream
type UpdateStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Event *StreamEvent `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
}

func (x *UpdateStreamResponse) Reset() {
	*x = UpdateStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStreamResponse) ProtoMessage() {}

func (x *UpdateStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStreamResponse.ProtoReflect.Descriptor instead.
func (*UpdateStreamResponse) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{58}
}

func (x *UpdateStreamResponse) GetEvent() *StreamEvent {
	if x != nil {
		return x.Event
	}
	return nil
}

// TransactionMetadata contains the metadata for a distributed transaction.
type TransactionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Dtid         string           `protobuf:"bytes,1,opt,name=dtid,proto3" json:"dtid,omitempty"`
	State        TransactionState `protobuf:"varint,2,opt,name=state,proto3,enum=dolthub.vt.query.TransactionState" json:"state,omitempty"`
	TimeCreated  int64            `protobuf:"varint,3,opt,name=time_created,json=timeCreated,proto3" json:"time_created,omitempty"`
	Participants []*Target        `protobuf:"bytes,4,rep,name=participants,proto3" json:"participants,omitempty"`
}

func (x *TransactionMetadata) Reset() {
	*x = TransactionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionMetadata) ProtoMessage() {}

func (x *TransactionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionMetadata.ProtoReflect.Descriptor instead.
func (*TransactionMetadata) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{59}
}

func (x *TransactionMetadata) GetDtid() string {
	if x != nil {
		return x.Dtid
	}
	return ""
}

func (x *TransactionMetadata) GetState() TransactionState {
	if x != nil {
		return x.State
	}
	return TransactionState_UNKNOWN
}

func (x *TransactionMetadata) GetTimeCreated() int64 {
	if x != nil {
		return x.TimeCreated
	}
	return 0
}

func (x *TransactionMetadata) GetParticipants() []*Target {
	if x != nil {
		return x.Participants
	}
	return nil
}

// One individual Statement in a transaction.
type StreamEvent_Statement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Category StreamEvent_Statement_Category `protobuf:"varint,1,opt,name=category,proto3,enum=dolthub.vt.query.StreamEvent_Statement_Category" json:"category,omitempty"`
	// table_name, primary_key_fields and primary_key_values are set for DML.
	TableName        string   `protobuf:"bytes,2,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	PrimaryKeyFields []*Field `protobuf:"bytes,3,rep,name=primary_key_fields,json=primaryKeyFields,proto3" json:"primary_key_fields,omitempty"`
	PrimaryKeyValues []*Row   `protobuf:"bytes,4,rep,name=primary_key_values,json=primaryKeyValues,proto3" json:"primary_key_values,omitempty"`
	// sql is set for all queries.
	// FIXME(alainjobart) we may not need it for DMLs.
	Sql []byte `protobuf:"bytes,5,opt,name=sql,proto3" json:"sql,omitempty"`
}

func (x *StreamEvent_Statement) Reset() {
	*x = StreamEvent_Statement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_dolthub_vt_query_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamEvent_Statement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamEvent_Statement) ProtoMessage() {}

func (x *StreamEvent_Statement) ProtoReflect() protoreflect.Message {
	mi := &file_dolthub_vt_query_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamEvent_Statement.ProtoReflect.Descriptor instead.
func (*StreamEvent_Statement) Descriptor() ([]byte, []int) {
	return file_dolthub_vt_query_proto_rawDescGZIP(), []int{12, 0}
}

func (x *StreamEvent_Statement) GetCategory() StreamEvent_Statement_Category {
	if x != nil {
		return x.Category
	}
	return StreamEvent_Statement_Error
}

func (x *StreamEvent_Statement) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *StreamEvent_Statement) GetPrimaryKeyFields() []*Field {
	if x != nil {
		return x.PrimaryKeyFields
	}
	return nil
}

func (x *StreamEvent_Statement) GetPrimaryKeyValues() []*Row {
	if x != nil {
		return x.PrimaryKeyValues
	}
	return nil
}

func (x *StreamEvent_Statement) GetSql() []byte {
	if x != nil {
		return x.Sql
	}
	return nil
}

var File_dolthub_vt_query_proto protoreflect.FileDescriptor

var file_dolthub_vt_query_proto_rawDesc = []byte{
	0x0a, 0x16, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x1a, 0x19, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2f, 0x76, 0x74, 0x2f, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76,
	0x74, 0x2f, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x90, 0x01,
	0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70,
	0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x63, 0x65, 0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x65, 0x6c, 0x6c,
	0x22, 0x44, 0x0a, 0x0e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0x5c, 0x0a, 0x0a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2a, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x81, 0x01, 0x0a, 0x0c, 0x42, 0x69, 0x6e, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x2a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x22, 0xd8, 0x01, 0x0a, 0x0a, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x73, 0x71, 0x6c, 0x12, 0x56, 0x0a, 0x0e, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x69, 0x6e, 0x64, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x62,
	0x69, 0x6e, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x1a, 0x60, 0x0a, 0x12,
	0x42, 0x69, 0x6e, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x69, 0x6e, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcb,
	0x06, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x4c, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x11, 0x63, 0x6f,
	0x6d, 0x70, 0x61, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x58, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x49, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x46, 0x6f, 0x75, 0x6e,
	0x64, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x45, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x28, 0x0a, 0x10,
	0x73, 0x71, 0x6c, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x73, 0x71, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x6a, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x15, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x12, 0x73, 0x6b, 0x69, 0x70, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6c, 0x61, 0x6e,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x22, 0x3b, 0x0a, 0x0e, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x11, 0x0a, 0x0d, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x41, 0x4e, 0x44, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c,
	0x10, 0x02, 0x22, 0x38, 0x0a, 0x08, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x0f,
	0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x08, 0x0a, 0x04, 0x4f, 0x4c, 0x54, 0x50, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4f, 0x4c, 0x41,
	0x50, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x42, 0x41, 0x10, 0x03, 0x22, 0xa7, 0x01, 0x0a,
	0x14, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x73, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x50, 0x45, 0x41, 0x54, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x41, 0x44, 0x5f,
	0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x52,
	0x45, 0x41, 0x44, 0x5f, 0x55, 0x4e, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x42, 0x4c,
	0x45, 0x10, 0x04, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4e, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e,
	0x54, 0x5f, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f,
	0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54, 0x4f, 0x43, 0x4f,
	0x4d, 0x4d, 0x49, 0x54, 0x10, 0x06, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0xa2, 0x02, 0x0a,
	0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x6f, 0x72, 0x67, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6f, 0x72, 0x67, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x67, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x67, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x08, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67,
	0x73, 0x22, 0x37, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x18, 0x0a, 0x07, 0x6c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x12, 0x52, 0x07, 0x6c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x67, 0x0a, 0x0c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x0a, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x66, 0x72, 0x65, 0x73,
	0x68, 0x65, 0x72, 0x22, 0xe3, 0x01, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x2f, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x6f, 0x77, 0x73, 0x5f, 0x61, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x72, 0x6f, 0x77,
	0x73, 0x41, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77,
	0x73, 0x12, 0x36, 0x0a, 0x06, 0x65, 0x78, 0x74, 0x72, 0x61, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61,
	0x73, 0x52, 0x06, 0x65, 0x78, 0x74, 0x72, 0x61, 0x73, 0x22, 0x3c, 0x0a, 0x0c, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xd7, 0x03, 0x0a, 0x0b, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x3d, 0x0a, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x52, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a,
	0xbf, 0x02, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4c, 0x0a,
	0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x30, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x12, 0x70, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52,
	0x10, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x12, 0x43, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x52, 0x6f, 0x77, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65, 0x79,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x22, 0x27, 0x0a, 0x08, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x44, 0x4d, 0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x44, 0x4c, 0x10,
	0x02, 0x22, 0xf7, 0x02, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52,
	0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x48, 0x0a, 0x0f, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x7a, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x57,
	0x69, 0x74, 0x68, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0xa7, 0x03, 0x0a, 0x13, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x07, 0x71, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x73, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x4f, 0x0a, 0x14, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0xfd, 0x02, 0x0a,
	0x14, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44,
	0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x4e, 0x0a, 0x15,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x9a, 0x02, 0x0a,
	0x0c, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a,
	0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65,
	0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3a, 0x0a,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x36, 0x0a, 0x0d, 0x42, 0x65, 0x67,
	0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x22, 0x86, 0x02, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11,
	0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x10, 0x0a, 0x0e, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x88, 0x02, 0x0a,
	0x0f, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63,
	0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13,
	0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x12, 0x0a, 0x10, 0x52, 0x6f, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9b, 0x02, 0x0a, 0x0e,
	0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x25,
	0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x74, 0x69, 0x64, 0x22, 0x11, 0x0a, 0x0f, 0x50, 0x72, 0x65,
	0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xfb, 0x01, 0x0a,
	0x15, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52,
	0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x74, 0x69, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa4, 0x02, 0x0a, 0x17, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63,
	0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13,
	0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x74, 0x69, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x52,
	0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbc, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52,
	0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x64, 0x74, 0x69, 0x64, 0x12, 0x3c, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x22, 0x1b, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x9f, 0x02, 0x0a, 0x12, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65,
	0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x64, 0x74, 0x69, 0x64, 0x22, 0x15, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9f, 0x02, 0x0a,
	0x12, 0x53, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74,
	0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64,
	0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11,
	0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x74, 0x69, 0x64, 0x22, 0x15,
	0x0a, 0x13, 0x53, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x80, 0x02, 0x0a, 0x1a, 0x43, 0x6f, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76,
	0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52,
	0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x64, 0x74, 0x69, 0x64, 0x22, 0x1d, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xfc, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x61, 0x64,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50,
	0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56,
	0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69,
	0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x64, 0x74, 0x69, 0x64, 0x22, 0x5c, 0x0a, 0x17, 0x52, 0x65, 0x61, 0x64, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x41, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0xd5, 0x02, 0x0a, 0x13, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa6, 0x01, 0x0a,
	0x14, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x50, 0x43, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x25,
	0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x85, 0x03, 0x0a, 0x18, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50,
	0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56,
	0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69,
	0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x36, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x73,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x61, 0x73, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3a, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xad, 0x01,
	0x0a, 0x19, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x50,
	0x43, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x37, 0x0a,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xfa, 0x01,
	0x0a, 0x14, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x76, 0x74, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52,
	0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x50, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x56, 0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4e, 0x0a, 0x15, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xa2, 0x02, 0x0a, 0x11, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63,
	0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13,
	0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x69, 0x64, 0x73, 0x22,
	0x4b, 0x0a, 0x12, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x63, 0x6b, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x8c, 0x04, 0x0a,
	0x11, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72,
	0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50,
	0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f,
	0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56,
	0x54, 0x47, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69,
	0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x70,
	0x6c, 0x69, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x70, 0x6c,
	0x69, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x73, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x17, 0x6e, 0x75,
	0x6d, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x6e, 0x75, 0x6d,
	0x52, 0x6f, 0x77, 0x73, 0x50, 0x65, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x74,
	0x12, 0x4b, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74,
	0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x22, 0x2c, 0x0a,
	0x09, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x51,
	0x55, 0x41, 0x4c, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x53, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x53, 0x43, 0x41, 0x4e, 0x10, 0x01, 0x22, 0x5d, 0x0a, 0x0a, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x32, 0x0a, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a,
	0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x4c, 0x0a, 0x12, 0x53, 0x70,
	0x6c, 0x69, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x36, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x52,
	0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22,
	0xa3, 0x02, 0x0a, 0x0d, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x21, 0x0a, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x5f,
	0x62, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x13, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x65, 0x68, 0x69,
	0x6e, 0x64, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x12, 0x30, 0x0a, 0x14, 0x62, 0x69, 0x6e, 0x6c,
	0x6f, 0x67, 0x5f, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x62, 0x69, 0x6e, 0x6c, 0x6f, 0x67, 0x50, 0x6c,
	0x61, 0x79, 0x65, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x2a, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x5f, 0x62, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x26,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x4d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x63, 0x70, 0x75, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x71, 0x70, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x03, 0x71, 0x70, 0x73, 0x22, 0xee, 0x01, 0x0a, 0x0e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x75, 0x6e,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x75, 0x6e, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x39, 0x0a, 0x19, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x5f, 0x62, 0x65, 0x68, 0x69,
	0x6e, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x16, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x65, 0x68, 0x69,
	0x6e, 0x64, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x69, 0x6e, 0x12, 0x39, 0x0a, 0x19, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x5f, 0x62, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x16,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x4d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x4d, 0x61, 0x78, 0x22, 0x8f, 0x03, 0x0a, 0x14, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x30, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x12, 0x53, 0x0a, 0x26, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x6c, 0x79,
	0x5f, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x23, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x52, 0x65, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x12, 0x46, 0x0a, 0x0e, 0x72, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x61, 0x6c,
	0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0d, 0x72, 0x65, 0x61, 0x6c, 0x74,
	0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x49, 0x0a, 0x0f, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x0e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x43, 0x0a, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x5f, 0x61, 0x6c,
	0x69, 0x61, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x74, 0x6f, 0x70, 0x6f, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x52, 0x0b, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x22, 0x9f, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x13, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x76, 0x74, 0x72, 0x70, 0x63,
	0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x13,
	0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x64, 0x6f, 0x6c, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x54, 0x47,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x44, 0x52, 0x11, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x64, 0x12, 0x30,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x4b, 0x0a, 0x14, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x33, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0xc4, 0x01, 0x0a, 0x13, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x12, 0x0a, 0x04, 0x64, 0x74, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64,
	0x74, 0x69, 0x64, 0x12, 0x38, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x22, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x74, 0x2e,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x12, 0x3c, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x74, 0x2e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2a, 0x92,
	0x03, 0x0a, 0x09, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x4d, 0x50, 0x54, 0x59, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x54, 0x5f, 0x4e,
	0x55, 0x4c, 0x4c, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52,
	0x49, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f,
	0x55, 0x4e, 0x49, 0x51, 0x55, 0x45, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10,
	0x04, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x50, 0x4c, 0x45, 0x5f, 0x4b, 0x45,
	0x59, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x42,
	0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x10, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x53, 0x49, 0x47,
	0x4e, 0x45, 0x44, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x20, 0x12, 0x11, 0x0a, 0x0d, 0x5a, 0x45,
	0x52, 0x4f, 0x46, 0x49, 0x4c, 0x4c, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x40, 0x12, 0x10, 0x0a,
	0x0b, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x01, 0x12,
	0x0e, 0x0a, 0x09, 0x45, 0x4e, 0x55, 0x4d, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x02, 0x12,
	0x18, 0x0a, 0x13, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x49, 0x4e, 0x43, 0x52, 0x45, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x04, 0x12, 0x13, 0x0a, 0x0e, 0x54, 0x49, 0x4d,
	0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x08, 0x12, 0x0d,
	0x0a, 0x08, 0x53, 0x45, 0x54, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x10, 0x12, 0x1a, 0x0a,
	0x15, 0x4e, 0x4f, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x56, 0x41, 0x4c, 0x55,
	0x45, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x20, 0x12, 0x17, 0x0a, 0x12, 0x4f, 0x4e, 0x5f,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x57, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10,
	0x80, 0x40, 0x12, 0x0e, 0x0a, 0x08, 0x4e, 0x55, 0x4d, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80,
	0x80, 0x02, 0x12, 0x13, 0x0a, 0x0d, 0x50, 0x41, 0x52, 0x54, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x46,
	0x4c, 0x41, 0x47, 0x10, 0x80, 0x80, 0x01, 0x12, 0x10, 0x0a, 0x0a, 0x47, 0x52, 0x4f, 0x55, 0x50,
	0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x80, 0x02, 0x12, 0x11, 0x0a, 0x0b, 0x55, 0x4e, 0x49,
	0x51, 0x55, 0x45, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x80, 0x04, 0x12, 0x11, 0x0a, 0x0b,
	0x42, 0x49, 0x4e, 0x43, 0x4d, 0x50, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x80, 0x80, 0x08, 0x1a,
	0x02, 0x10, 0x01, 0x2a, 0x6b, 0x0a, 0x04, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x08, 0x0a, 0x04, 0x4e,
	0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0a, 0x49, 0x53, 0x49, 0x4e, 0x54, 0x45, 0x47,
	0x52, 0x41, 0x4c, 0x10, 0x80, 0x02, 0x12, 0x0f, 0x0a, 0x0a, 0x49, 0x53, 0x55, 0x4e, 0x53, 0x49,
	0x47, 0x4e, 0x45, 0x44, 0x10, 0x80, 0x04, 0x12, 0x0c, 0x0a, 0x07, 0x49, 0x53, 0x46, 0x4c, 0x4f,
	0x41, 0x54, 0x10, 0x80, 0x08, 0x12, 0x0d, 0x0a, 0x08, 0x49, 0x53, 0x51, 0x55, 0x4f, 0x54, 0x45,
	0x44, 0x10, 0x80, 0x10, 0x12, 0x0b, 0x0a, 0x06, 0x49, 0x53, 0x54, 0x45, 0x58, 0x54, 0x10, 0x80,
	0x20, 0x12, 0x0d, 0x0a, 0x08, 0x49, 0x53, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x80, 0x40,
	0x2a, 0xa6, 0x03, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x55, 0x4c,
	0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x04, 0x49, 0x4e, 0x54, 0x38,
	0x10, 0x81, 0x02, 0x12, 0x0a, 0x0a, 0x05, 0x55, 0x49, 0x4e, 0x54, 0x38, 0x10, 0x82, 0x06, 0x12,
	0x0a, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x31, 0x36, 0x10, 0x83, 0x02, 0x12, 0x0b, 0x0a, 0x06, 0x55,
	0x49, 0x4e, 0x54, 0x31, 0x36, 0x10, 0x84, 0x06, 0x12, 0x0a, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x32,
	0x34, 0x10, 0x85, 0x02, 0x12, 0x0b, 0x0a, 0x06, 0x55, 0x49, 0x4e, 0x54, 0x32, 0x34, 0x10, 0x86,
	0x06, 0x12, 0x0a, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x33, 0x32, 0x10, 0x87, 0x02, 0x12, 0x0b, 0x0a,
	0x06, 0x55, 0x49, 0x4e, 0x54, 0x33, 0x32, 0x10, 0x88, 0x06, 0x12, 0x0a, 0x0a, 0x05, 0x49, 0x4e,
	0x54, 0x36, 0x34, 0x10, 0x89, 0x02, 0x12, 0x0b, 0x0a, 0x06, 0x55, 0x49, 0x4e, 0x54, 0x36, 0x34,
	0x10, 0x8a, 0x06, 0x12, 0x0c, 0x0a, 0x07, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x33, 0x32, 0x10, 0x8b,
	0x08, 0x12, 0x0c, 0x0a, 0x07, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x36, 0x34, 0x10, 0x8c, 0x08, 0x12,
	0x0e, 0x0a, 0x09, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x8d, 0x10, 0x12,
	0x09, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x45, 0x10, 0x8e, 0x10, 0x12, 0x09, 0x0a, 0x04, 0x54, 0x49,
	0x4d, 0x45, 0x10, 0x8f, 0x10, 0x12, 0x0d, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d,
	0x45, 0x10, 0x90, 0x10, 0x12, 0x09, 0x0a, 0x04, 0x59, 0x45, 0x41, 0x52, 0x10, 0x91, 0x06, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x43, 0x49, 0x4d, 0x41, 0x4c, 0x10, 0x12, 0x12, 0x09, 0x0a, 0x04,
	0x54, 0x45, 0x58, 0x54, 0x10, 0x93, 0x30, 0x12, 0x09, 0x0a, 0x04, 0x42, 0x4c, 0x4f, 0x42, 0x10,
	0x94, 0x50, 0x12, 0x0c, 0x0a, 0x07, 0x56, 0x41, 0x52, 0x43, 0x48, 0x41, 0x52, 0x10, 0x95, 0x30,
	0x12, 0x0e, 0x0a, 0x09, 0x56, 0x41, 0x52, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x96, 0x50,
	0x12, 0x09, 0x0a, 0x04, 0x43, 0x48, 0x41, 0x52, 0x10, 0x97, 0x30, 0x12, 0x0b, 0x0a, 0x06, 0x42,
	0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x98, 0x50, 0x12, 0x08, 0x0a, 0x03, 0x42, 0x49, 0x54, 0x10,
	0x99, 0x10, 0x12, 0x09, 0x0a, 0x04, 0x45, 0x4e, 0x55, 0x4d, 0x10, 0x9a, 0x10, 0x12, 0x08, 0x0a,
	0x03, 0x53, 0x45, 0x54, 0x10, 0x9b, 0x10, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x55, 0x50, 0x4c, 0x45,
	0x10, 0x1c, 0x12, 0x0d, 0x0a, 0x08, 0x47, 0x45, 0x4f, 0x4d, 0x45, 0x54, 0x52, 0x59, 0x10, 0x9d,
	0x10, 0x12, 0x09, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x9e, 0x10, 0x12, 0x0e, 0x0a, 0x0a,
	0x45, 0x58, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x1f, 0x12, 0x0b, 0x0a, 0x06,
	0x56, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x10, 0xa0, 0x40, 0x2a, 0x46, 0x0a, 0x10, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a,
	0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52,
	0x45, 0x50, 0x41, 0x52, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4d, 0x4d, 0x49,
	0x54, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x10,
	0x03, 0x42, 0x3e, 0x0a, 0x0f, 0x69, 0x6f, 0x2e, 0x76, 0x69, 0x74, 0x65, 0x73, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x5a, 0x2b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x64, 0x6f, 0x6c, 0x74, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x69, 0x74, 0x65, 0x73, 0x73, 0x2f,
	0x67, 0x6f, 0x2f, 0x76, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_dolthub_vt_query_proto_rawDescOnce sync.Once
	file_dolthub_vt_query_proto_rawDescData = file_dolthub_vt_query_proto_rawDesc
)

func file_dolthub_vt_query_proto_rawDescGZIP() []byte {
	file_dolthub_vt_query_proto_rawDescOnce.Do(func() {
		file_dolthub_vt_query_proto_rawDescData = protoimpl.X.CompressGZIP(file_dolthub_vt_query_proto_rawDescData)
	})
	return file_dolthub_vt_query_proto_rawDescData
}

var file_dolthub_vt_query_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_dolthub_vt_query_proto_msgTypes = make([]protoimpl.MessageInfo, 62)
var file_dolthub_vt_query_proto_goTypes = []interface{}{
	(MySqlFlag)(0),                           // 0: dolthub.vt.query.MySqlFlag
	(Flag)(0),                                // 1: dolthub.vt.query.Flag
	(Type)(0),                                // 2: dolthub.vt.query.Type
	(TransactionState)(0),                    // 3: dolthub.vt.query.TransactionState
	(ExecuteOptions_IncludedFields)(0),       // 4: dolthub.vt.query.ExecuteOptions.IncludedFields
	(ExecuteOptions_Workload)(0),             // 5: dolthub.vt.query.ExecuteOptions.Workload
	(ExecuteOptions_TransactionIsolation)(0), // 6: dolthub.vt.query.ExecuteOptions.TransactionIsolation
	(StreamEvent_Statement_Category)(0),      // 7: dolthub.vt.query.StreamEvent.Statement.Category
	(SplitQueryRequest_Algorithm)(0),         // 8: dolthub.vt.query.SplitQueryRequest.Algorithm
	(*Target)(nil),                           // 9: dolthub.vt.query.Target
	(*VTGateCallerID)(nil),                   // 10: dolthub.vt.query.VTGateCallerID
	(*EventToken)(nil),                       // 11: dolthub.vt.query.EventToken
	(*Value)(nil),                            // 12: dolthub.vt.query.Value
	(*BindVariable)(nil),                     // 13: dolthub.vt.query.BindVariable
	(*BoundQuery)(nil),                       // 14: dolthub.vt.query.BoundQuery
	(*ExecuteOptions)(nil),                   // 15: dolthub.vt.query.ExecuteOptions
	(*Field)(nil),                            // 16: dolthub.vt.query.Field
	(*Row)(nil),                              // 17: dolthub.vt.query.Row
	(*ResultExtras)(nil),                     // 18: dolthub.vt.query.ResultExtras
	(*QueryResult)(nil),                      // 19: dolthub.vt.query.QueryResult
	(*QueryWarning)(nil),                     // 20: dolthub.vt.query.QueryWarning
	(*StreamEvent)(nil),                      // 21: dolthub.vt.query.StreamEvent
	(*ExecuteRequest)(nil),                   // 22: dolthub.vt.query.ExecuteRequest
	(*ExecuteResponse)(nil),                  // 23: dolthub.vt.query.ExecuteResponse
	(*ResultWithError)(nil),                  // 24: dolthub.vt.query.ResultWithError
	(*ExecuteBatchRequest)(nil),              // 25: dolthub.vt.query.ExecuteBatchRequest
	(*ExecuteBatchResponse)(nil),             // 26: dolthub.vt.query.ExecuteBatchResponse
	(*StreamExecuteRequest)(nil),             // 27: dolthub.vt.query.StreamExecuteRequest
	(*StreamExecuteResponse)(nil),            // 28: dolthub.vt.query.StreamExecuteResponse
	(*BeginRequest)(nil),                     // 29: dolthub.vt.query.BeginRequest
	(*BeginResponse)(nil),                    // 30: dolthub.vt.query.BeginResponse
	(*CommitRequest)(nil),                    // 31: dolthub.vt.query.CommitRequest
	(*CommitResponse)(nil),                   // 32: dolthub.vt.query.CommitResponse
	(*RollbackRequest)(nil),                  // 33: dolthub.vt.query.RollbackRequest
	(*RollbackResponse)(nil),                 // 34: dolthub.vt.query.RollbackResponse
	(*PrepareRequest)(nil),                   // 35: dolthub.vt.query.PrepareRequest
	(*PrepareResponse)(nil),                  // 36: dolthub.vt.query.PrepareResponse
	(*CommitPreparedRequest)(nil),            // 37: dolthub.vt.query.CommitPreparedRequest
	(*CommitPreparedResponse)(nil),           // 38: dolthub.vt.query.CommitPreparedResponse
	(*RollbackPreparedRequest)(nil),          // 39: dolthub.vt.query.RollbackPreparedRequest
	(*RollbackPreparedResponse)(nil),         // 40: dolthub.vt.query.RollbackPreparedResponse
	(*CreateTransactionRequest)(nil),         // 41: dolthub.vt.query.CreateTransactionRequest
	(*CreateTransactionResponse)(nil),        // 42: dolthub.vt.query.CreateTransactionResponse
	(*StartCommitRequest)(nil),               // 43: dolthub.vt.query.StartCommitRequest
	(*StartCommitResponse)(nil),              // 44: dolthub.vt.query.StartCommitResponse
	(*SetRollbackRequest)(nil),               // 45: dolthub.vt.query.SetRollbackRequest
	(*SetRollbackResponse)(nil),              // 46: dolthub.vt.query.SetRollbackResponse
	(*ConcludeTransactionRequest)(nil),       // 47: dolthub.vt.query.ConcludeTransactionRequest
	(*ConcludeTransactionResponse)(nil),      // 48: dolthub.vt.query.ConcludeTransactionResponse
	(*ReadTransactionRequest)(nil),           // 49: dolthub.vt.query.ReadTransactionRequest
	(*ReadTransactionResponse)(nil),          // 50: dolthub.vt.query.ReadTransactionResponse
	(*BeginExecuteRequest)(nil),              // 51: dolthub.vt.query.BeginExecuteRequest
	(*BeginExecuteResponse)(nil),             // 52: dolthub.vt.query.BeginExecuteResponse
	(*BeginExecuteBatchRequest)(nil),         // 53: dolthub.vt.query.BeginExecuteBatchRequest
	(*BeginExecuteBatchResponse)(nil),        // 54: dolthub.vt.query.BeginExecuteBatchResponse
	(*MessageStreamRequest)(nil),             // 55: dolthub.vt.query.MessageStreamRequest
	(*MessageStreamResponse)(nil),            // 56: dolthub.vt.query.MessageStreamResponse
	(*MessageAckRequest)(nil),                // 57: dolthub.vt.query.MessageAckRequest
	(*MessageAckResponse)(nil),               // 58: dolthub.vt.query.MessageAckResponse
	(*SplitQueryRequest)(nil),                // 59: dolthub.vt.query.SplitQueryRequest
	(*QuerySplit)(nil),                       // 60: dolthub.vt.query.QuerySplit
	(*SplitQueryResponse)(nil),               // 61: dolthub.vt.query.SplitQueryResponse
	(*StreamHealthRequest)(nil),              // 62: dolthub.vt.query.StreamHealthRequest
	(*RealtimeStats)(nil),                    // 63: dolthub.vt.query.RealtimeStats
	(*AggregateStats)(nil),                   // 64: dolthub.vt.query.AggregateStats
	(*StreamHealthResponse)(nil),             // 65: dolthub.vt.query.StreamHealthResponse
	(*UpdateStreamRequest)(nil),              // 66: dolthub.vt.query.UpdateStreamRequest
	(*UpdateStreamResponse)(nil),             // 67: dolthub.vt.query.UpdateStreamResponse
	(*TransactionMetadata)(nil),              // 68: dolthub.vt.query.TransactionMetadata
	nil,                                      // 69: dolthub.vt.query.BoundQuery.BindVariablesEntry
	(*StreamEvent_Statement)(nil),            // 70: dolthub.vt.query.StreamEvent.Statement
	(topodata.TabletType)(0),                 // 71: dolthub.vt.topodata.TabletType
	(*vtrpc.CallerID)(nil),                   // 72: dolthub.vt.vtrpc.CallerID
	(*vtrpc.RPCError)(nil),                   // 73: dolthub.vt.vtrpc.RPCError
	(*topodata.TabletAlias)(nil),             // 74: dolthub.vt.topodata.TabletAlias
}
var file_dolthub_vt_query_proto_depIdxs = []int32{
	71,  // 0: dolthub.vt.query.Target.tablet_type:type_name -> dolthub.vt.topodata.TabletType
	2,   // 1: dolthub.vt.query.Value.type:type_name -> dolthub.vt.query.Type
	2,   // 2: dolthub.vt.query.BindVariable.type:type_name -> dolthub.vt.query.Type
	12,  // 3: dolthub.vt.query.BindVariable.values:type_name -> dolthub.vt.query.Value
	69,  // 4: dolthub.vt.query.BoundQuery.bind_variables:type_name -> dolthub.vt.query.BoundQuery.BindVariablesEntry
	11,  // 5: dolthub.vt.query.ExecuteOptions.compare_event_token:type_name -> dolthub.vt.query.EventToken
	4,   // 6: dolthub.vt.query.ExecuteOptions.included_fields:type_name -> dolthub.vt.query.ExecuteOptions.IncludedFields
	5,   // 7: dolthub.vt.query.ExecuteOptions.workload:type_name -> dolthub.vt.query.ExecuteOptions.Workload
	6,   // 8: dolthub.vt.query.ExecuteOptions.transaction_isolation:type_name -> dolthub.vt.query.ExecuteOptions.TransactionIsolation
	2,   // 9: dolthub.vt.query.Field.type:type_name -> dolthub.vt.query.Type
	11,  // 10: dolthub.vt.query.ResultExtras.event_token:type_name -> dolthub.vt.query.EventToken
	16,  // 11: dolthub.vt.query.QueryResult.fields:type_name -> dolthub.vt.query.Field
	17,  // 12: dolthub.vt.query.QueryResult.rows:type_name -> dolthub.vt.query.Row
	18,  // 13: dolthub.vt.query.QueryResult.extras:type_name -> dolthub.vt.query.ResultExtras
	70,  // 14: dolthub.vt.query.StreamEvent.statements:type_name -> dolthub.vt.query.StreamEvent.Statement
	11,  // 15: dolthub.vt.query.StreamEvent.event_token:type_name -> dolthub.vt.query.EventToken
	72,  // 16: dolthub.vt.query.ExecuteRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 17: dolthub.vt.query.ExecuteRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 18: dolthub.vt.query.ExecuteRequest.target:type_name -> dolthub.vt.query.Target
	14,  // 19: dolthub.vt.query.ExecuteRequest.query:type_name -> dolthub.vt.query.BoundQuery
	15,  // 20: dolthub.vt.query.ExecuteRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	19,  // 21: dolthub.vt.query.ExecuteResponse.result:type_name -> dolthub.vt.query.QueryResult
	73,  // 22: dolthub.vt.query.ResultWithError.error:type_name -> dolthub.vt.vtrpc.RPCError
	19,  // 23: dolthub.vt.query.ResultWithError.result:type_name -> dolthub.vt.query.QueryResult
	72,  // 24: dolthub.vt.query.ExecuteBatchRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 25: dolthub.vt.query.ExecuteBatchRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 26: dolthub.vt.query.ExecuteBatchRequest.target:type_name -> dolthub.vt.query.Target
	14,  // 27: dolthub.vt.query.ExecuteBatchRequest.queries:type_name -> dolthub.vt.query.BoundQuery
	15,  // 28: dolthub.vt.query.ExecuteBatchRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	19,  // 29: dolthub.vt.query.ExecuteBatchResponse.results:type_name -> dolthub.vt.query.QueryResult
	72,  // 30: dolthub.vt.query.StreamExecuteRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 31: dolthub.vt.query.StreamExecuteRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 32: dolthub.vt.query.StreamExecuteRequest.target:type_name -> dolthub.vt.query.Target
	14,  // 33: dolthub.vt.query.StreamExecuteRequest.query:type_name -> dolthub.vt.query.BoundQuery
	15,  // 34: dolthub.vt.query.StreamExecuteRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	19,  // 35: dolthub.vt.query.StreamExecuteResponse.result:type_name -> dolthub.vt.query.QueryResult
	72,  // 36: dolthub.vt.query.BeginRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 37: dolthub.vt.query.BeginRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 38: dolthub.vt.query.BeginRequest.target:type_name -> dolthub.vt.query.Target
	15,  // 39: dolthub.vt.query.BeginRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	72,  // 40: dolthub.vt.query.CommitRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 41: dolthub.vt.query.CommitRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 42: dolthub.vt.query.CommitRequest.target:type_name -> dolthub.vt.query.Target
	72,  // 43: dolthub.vt.query.RollbackRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 44: dolthub.vt.query.RollbackRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 45: dolthub.vt.query.RollbackRequest.target:type_name -> dolthub.vt.query.Target
	72,  // 46: dolthub.vt.query.PrepareRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 47: dolthub.vt.query.PrepareRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 48: dolthub.vt.query.PrepareRequest.target:type_name -> dolthub.vt.query.Target
	72,  // 49: dolthub.vt.query.CommitPreparedRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 50: dolthub.vt.query.CommitPreparedRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 51: dolthub.vt.query.CommitPreparedRequest.target:type_name -> dolthub.vt.query.Target
	72,  // 52: dolthub.vt.query.RollbackPreparedRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 53: dolthub.vt.query.RollbackPreparedRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 54: dolthub.vt.query.RollbackPreparedRequest.target:type_name -> dolthub.vt.query.Target
	72,  // 55: dolthub.vt.query.CreateTransactionRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 56: dolthub.vt.query.CreateTransactionRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 57: dolthub.vt.query.CreateTransactionRequest.target:type_name -> dolthub.vt.query.Target
	9,   // 58: dolthub.vt.query.CreateTransactionRequest.participants:type_name -> dolthub.vt.query.Target
	72,  // 59: dolthub.vt.query.StartCommitRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 60: dolthub.vt.query.StartCommitRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 61: dolthub.vt.query.StartCommitRequest.target:type_name -> dolthub.vt.query.Target
	72,  // 62: dolthub.vt.query.SetRollbackRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 63: dolthub.vt.query.SetRollbackRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 64: dolthub.vt.query.SetRollbackRequest.target:type_name -> dolthub.vt.query.Target
	72,  // 65: dolthub.vt.query.ConcludeTransactionRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 66: dolthub.vt.query.ConcludeTransactionRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 67: dolthub.vt.query.ConcludeTransactionRequest.target:type_name -> dolthub.vt.query.Target
	72,  // 68: dolthub.vt.query.ReadTransactionRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 69: dolthub.vt.query.ReadTransactionRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 70: dolthub.vt.query.ReadTransactionRequest.target:type_name -> dolthub.vt.query.Target
	68,  // 71: dolthub.vt.query.ReadTransactionResponse.metadata:type_name -> dolthub.vt.query.TransactionMetadata
	72,  // 72: dolthub.vt.query.BeginExecuteRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 73: dolthub.vt.query.BeginExecuteRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 74: dolthub.vt.query.BeginExecuteRequest.target:type_name -> dolthub.vt.query.Target
	14,  // 75: dolthub.vt.query.BeginExecuteRequest.query:type_name -> dolthub.vt.query.BoundQuery
	15,  // 76: dolthub.vt.query.BeginExecuteRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	73,  // 77: dolthub.vt.query.BeginExecuteResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	19,  // 78: dolthub.vt.query.BeginExecuteResponse.result:type_name -> dolthub.vt.query.QueryResult
	72,  // 79: dolthub.vt.query.BeginExecuteBatchRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 80: dolthub.vt.query.BeginExecuteBatchRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 81: dolthub.vt.query.BeginExecuteBatchRequest.target:type_name -> dolthub.vt.query.Target
	14,  // 82: dolthub.vt.query.BeginExecuteBatchRequest.queries:type_name -> dolthub.vt.query.BoundQuery
	15,  // 83: dolthub.vt.query.BeginExecuteBatchRequest.options:type_name -> dolthub.vt.query.ExecuteOptions
	73,  // 84: dolthub.vt.query.BeginExecuteBatchResponse.error:type_name -> dolthub.vt.vtrpc.RPCError
	19,  // 85: dolthub.vt.query.BeginExecuteBatchResponse.results:type_name -> dolthub.vt.query.QueryResult
	72,  // 86: dolthub.vt.query.MessageStreamRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 87: dolthub.vt.query.MessageStreamRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 88: dolthub.vt.query.MessageStreamRequest.target:type_name -> dolthub.vt.query.Target
	19,  // 89: dolthub.vt.query.MessageStreamResponse.result:type_name -> dolthub.vt.query.QueryResult
	72,  // 90: dolthub.vt.query.MessageAckRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 91: dolthub.vt.query.MessageAckRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 92: dolthub.vt.query.MessageAckRequest.target:type_name -> dolthub.vt.query.Target
	12,  // 93: dolthub.vt.query.MessageAckRequest.ids:type_name -> dolthub.vt.query.Value
	19,  // 94: dolthub.vt.query.MessageAckResponse.result:type_name -> dolthub.vt.query.QueryResult
	72,  // 95: dolthub.vt.query.SplitQueryRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 96: dolthub.vt.query.SplitQueryRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 97: dolthub.vt.query.SplitQueryRequest.target:type_name -> dolthub.vt.query.Target
	14,  // 98: dolthub.vt.query.SplitQueryRequest.query:type_name -> dolthub.vt.query.BoundQuery
	8,   // 99: dolthub.vt.query.SplitQueryRequest.algorithm:type_name -> dolthub.vt.query.SplitQueryRequest.Algorithm
	14,  // 100: dolthub.vt.query.QuerySplit.query:type_name -> dolthub.vt.query.BoundQuery
	60,  // 101: dolthub.vt.query.SplitQueryResponse.queries:type_name -> dolthub.vt.query.QuerySplit
	9,   // 102: dolthub.vt.query.StreamHealthResponse.target:type_name -> dolthub.vt.query.Target
	63,  // 103: dolthub.vt.query.StreamHealthResponse.realtime_stats:type_name -> dolthub.vt.query.RealtimeStats
	64,  // 104: dolthub.vt.query.StreamHealthResponse.aggregate_stats:type_name -> dolthub.vt.query.AggregateStats
	74,  // 105: dolthub.vt.query.StreamHealthResponse.tablet_alias:type_name -> dolthub.vt.topodata.TabletAlias
	72,  // 106: dolthub.vt.query.UpdateStreamRequest.effective_caller_id:type_name -> dolthub.vt.vtrpc.CallerID
	10,  // 107: dolthub.vt.query.UpdateStreamRequest.immediate_caller_id:type_name -> dolthub.vt.query.VTGateCallerID
	9,   // 108: dolthub.vt.query.UpdateStreamRequest.target:type_name -> dolthub.vt.query.Target
	21,  // 109: dolthub.vt.query.UpdateStreamResponse.event:type_name -> dolthub.vt.query.StreamEvent
	3,   // 110: dolthub.vt.query.TransactionMetadata.state:type_name -> dolthub.vt.query.TransactionState
	9,   // 111: dolthub.vt.query.TransactionMetadata.participants:type_name -> dolthub.vt.query.Target
	13,  // 112: dolthub.vt.query.BoundQuery.BindVariablesEntry.value:type_name -> dolthub.vt.query.BindVariable
	7,   // 113: dolthub.vt.query.StreamEvent.Statement.category:type_name -> dolthub.vt.query.StreamEvent.Statement.Category
	16,  // 114: dolthub.vt.query.StreamEvent.Statement.primary_key_fields:type_name -> dolthub.vt.query.Field
	17,  // 115: dolthub.vt.query.StreamEvent.Statement.primary_key_values:type_name -> dolthub.vt.query.Row
	116, // [116:116] is the sub-list for method output_type
	116, // [116:116] is the sub-list for method input_type
	116, // [116:116] is the sub-list for extension type_name
	116, // [116:116] is the sub-list for extension extendee
	0,   // [0:116] is the sub-list for field type_name
}

func init() { file_dolthub_vt_query_proto_init() }
func file_dolthub_vt_query_proto_init() {
	if File_dolthub_vt_query_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_dolthub_vt_query_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VTGateCallerID); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BindVariable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResultExtras); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryWarning); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResultWithError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamExecuteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitPreparedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitPreparedResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackPreparedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackPreparedResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTransactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartCommitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartCommitResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetRollbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetRollbackResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcludeTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConcludeTransactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTransactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginExecuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginExecuteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginExecuteBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginExecuteBatchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageAckRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageAckResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuerySplit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamHealthRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RealtimeStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamHealthResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_dolthub_vt_query_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamEvent_Statement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_dolthub_vt_query_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   62,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_dolthub_vt_query_proto_goTypes,
		DependencyIndexes: file_dolthub_vt_query_proto_depIdxs,
		EnumInfos:         file_dolthub_vt_query_proto_enumTypes,
		MessageInfos:      file_dolthub_vt_query_proto_msgTypes,
	}.Build()
	File_dolthub_vt_query_proto = out.File
	file_dolthub_vt_query_proto_rawDesc = nil
	file_dolthub_vt_query_proto_goTypes = nil
	file_dolthub_vt_query_proto_depIdxs = nil
}
