// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Latin7 represents the `latin7` character set encoding.
var Latin7 Encoder = &RangeMap{
	inputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
			{
				inputRange:  rangeBounds{{128, 160}},
				outputRange: rangeBounds{{194, 194}, {128, 160}},
				inputMults:  []int{1},
				outputMults: []int{33, 1},
			},
			{
				inputRange:  rangeBounds{{161, 161}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {157, 157}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{162, 164}},
				outputRange: rangeBounds{{194, 194}, {162, 164}},
				inputMults:  []int{1},
				outputMults: []int{3, 1},
			},
			{
				inputRange:  rangeBounds{{165, 165}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{166, 167}},
				outputRange: rangeBounds{{194, 194}, {166, 167}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{168, 168}},
				outputRange: rangeBounds{{195, 195}, {152, 152}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{169, 169}},
				outputRange: rangeBounds{{194, 194}, {169, 169}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{170, 170}},
				outputRange: rangeBounds{{197, 197}, {150, 150}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{171, 174}},
				outputRange: rangeBounds{{194, 194}, {171, 174}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{175, 175}},
				outputRange: rangeBounds{{195, 195}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{176, 179}},
				outputRange: rangeBounds{{194, 194}, {176, 179}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{180, 180}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {156, 156}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{181, 183}},
				outputRange: rangeBounds{{194, 194}, {181, 183}},
				inputMults:  []int{1},
				outputMults: []int{3, 1},
			},
			{
				inputRange:  rangeBounds{{184, 184}},
				outputRange: rangeBounds{{195, 195}, {184, 184}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{185, 185}},
				outputRange: rangeBounds{{194, 194}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{186, 186}},
				outputRange: rangeBounds{{197, 197}, {151, 151}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{187, 190}},
				outputRange: rangeBounds{{194, 194}, {187, 190}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{191, 191}},
				outputRange: rangeBounds{{195, 195}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{192, 192}},
				outputRange: rangeBounds{{196, 196}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{193, 193}},
				outputRange: rangeBounds{{196, 196}, {174, 174}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{194, 194}},
				outputRange: rangeBounds{{196, 196}, {128, 128}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{195, 195}},
				outputRange: rangeBounds{{196, 196}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{196, 197}},
				outputRange: rangeBounds{{195, 195}, {132, 133}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{198, 198}},
				outputRange: rangeBounds{{196, 196}, {152, 152}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{199, 199}},
				outputRange: rangeBounds{{196, 196}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{200, 200}},
				outputRange: rangeBounds{{196, 196}, {140, 140}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{201, 201}},
				outputRange: rangeBounds{{195, 195}, {137, 137}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{202, 202}},
				outputRange: rangeBounds{{197, 197}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{203, 203}},
				outputRange: rangeBounds{{196, 196}, {150, 150}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{204, 204}},
				outputRange: rangeBounds{{196, 196}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{205, 205}},
				outputRange: rangeBounds{{196, 196}, {182, 182}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{206, 206}},
				outputRange: rangeBounds{{196, 196}, {170, 170}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{207, 207}},
				outputRange: rangeBounds{{196, 196}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{208, 208}},
				outputRange: rangeBounds{{197, 197}, {160, 160}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{209, 209}},
				outputRange: rangeBounds{{197, 197}, {131, 131}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{210, 210}},
				outputRange: rangeBounds{{197, 197}, {133, 133}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{211, 211}},
				outputRange: rangeBounds{{195, 195}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{212, 212}},
				outputRange: rangeBounds{{197, 197}, {140, 140}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{213, 215}},
				outputRange: rangeBounds{{195, 195}, {149, 151}},
				inputMults:  []int{1},
				outputMults: []int{3, 1},
			},
			{
				inputRange:  rangeBounds{{216, 216}},
				outputRange: rangeBounds{{197, 197}, {178, 178}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{217, 217}},
				outputRange: rangeBounds{{197, 197}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{218, 218}},
				outputRange: rangeBounds{{197, 197}, {154, 154}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{219, 219}},
				outputRange: rangeBounds{{197, 197}, {170, 170}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{220, 220}},
				outputRange: rangeBounds{{195, 195}, {156, 156}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{221, 221}},
				outputRange: rangeBounds{{197, 197}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{222, 222}},
				outputRange: rangeBounds{{197, 197}, {189, 189}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{223, 223}},
				outputRange: rangeBounds{{195, 195}, {159, 159}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{224, 224}},
				outputRange: rangeBounds{{196, 196}, {133, 133}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{225, 225}},
				outputRange: rangeBounds{{196, 196}, {175, 175}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{226, 226}},
				outputRange: rangeBounds{{196, 196}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{227, 227}},
				outputRange: rangeBounds{{196, 196}, {135, 135}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{228, 229}},
				outputRange: rangeBounds{{195, 195}, {164, 165}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{230, 230}},
				outputRange: rangeBounds{{196, 196}, {153, 153}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{231, 231}},
				outputRange: rangeBounds{{196, 196}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{232, 232}},
				outputRange: rangeBounds{{196, 196}, {141, 141}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{233, 233}},
				outputRange: rangeBounds{{195, 195}, {169, 169}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{234, 234}},
				outputRange: rangeBounds{{197, 197}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{235, 235}},
				outputRange: rangeBounds{{196, 196}, {151, 151}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{236, 236}},
				outputRange: rangeBounds{{196, 196}, {163, 163}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{237, 237}},
				outputRange: rangeBounds{{196, 196}, {183, 183}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{238, 238}},
				outputRange: rangeBounds{{196, 196}, {171, 171}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{239, 239}},
				outputRange: rangeBounds{{196, 196}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{240, 240}},
				outputRange: rangeBounds{{197, 197}, {161, 161}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{241, 241}},
				outputRange: rangeBounds{{197, 197}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{242, 242}},
				outputRange: rangeBounds{{197, 197}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{243, 243}},
				outputRange: rangeBounds{{195, 195}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{244, 244}},
				outputRange: rangeBounds{{197, 197}, {141, 141}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{245, 247}},
				outputRange: rangeBounds{{195, 195}, {181, 183}},
				inputMults:  []int{1},
				outputMults: []int{3, 1},
			},
			{
				inputRange:  rangeBounds{{248, 248}},
				outputRange: rangeBounds{{197, 197}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{249, 249}},
				outputRange: rangeBounds{{197, 197}, {130, 130}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{250, 250}},
				outputRange: rangeBounds{{197, 197}, {155, 155}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{251, 251}},
				outputRange: rangeBounds{{197, 197}, {171, 171}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{252, 252}},
				outputRange: rangeBounds{{195, 195}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{253, 253}},
				outputRange: rangeBounds{{197, 197}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{254, 254}},
				outputRange: rangeBounds{{197, 197}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{255, 255}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {153, 153}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
		},
		nil,
		nil,
		nil,
	},
	outputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{128, 160}},
				outputRange: rangeBounds{{194, 194}, {128, 160}},
				inputMults:  []int{1},
				outputMults: []int{33, 1},
			},
			{
				inputRange:  rangeBounds{{162, 164}},
				outputRange: rangeBounds{{194, 194}, {162, 164}},
				inputMults:  []int{1},
				outputMults: []int{3, 1},
			},
			{
				inputRange:  rangeBounds{{166, 167}},
				outputRange: rangeBounds{{194, 194}, {166, 167}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{168, 168}},
				outputRange: rangeBounds{{195, 195}, {152, 152}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{169, 169}},
				outputRange: rangeBounds{{194, 194}, {169, 169}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{170, 170}},
				outputRange: rangeBounds{{197, 197}, {150, 150}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{171, 174}},
				outputRange: rangeBounds{{194, 194}, {171, 174}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{175, 175}},
				outputRange: rangeBounds{{195, 195}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{176, 179}},
				outputRange: rangeBounds{{194, 194}, {176, 179}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{181, 183}},
				outputRange: rangeBounds{{194, 194}, {181, 183}},
				inputMults:  []int{1},
				outputMults: []int{3, 1},
			},
			{
				inputRange:  rangeBounds{{184, 184}},
				outputRange: rangeBounds{{195, 195}, {184, 184}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{185, 185}},
				outputRange: rangeBounds{{194, 194}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{186, 186}},
				outputRange: rangeBounds{{197, 197}, {151, 151}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{187, 190}},
				outputRange: rangeBounds{{194, 194}, {187, 190}},
				inputMults:  []int{1},
				outputMults: []int{4, 1},
			},
			{
				inputRange:  rangeBounds{{191, 191}},
				outputRange: rangeBounds{{195, 195}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{192, 192}},
				outputRange: rangeBounds{{196, 196}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{193, 193}},
				outputRange: rangeBounds{{196, 196}, {174, 174}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{194, 194}},
				outputRange: rangeBounds{{196, 196}, {128, 128}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{195, 195}},
				outputRange: rangeBounds{{196, 196}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{196, 197}},
				outputRange: rangeBounds{{195, 195}, {132, 133}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{198, 198}},
				outputRange: rangeBounds{{196, 196}, {152, 152}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{199, 199}},
				outputRange: rangeBounds{{196, 196}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{200, 200}},
				outputRange: rangeBounds{{196, 196}, {140, 140}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{201, 201}},
				outputRange: rangeBounds{{195, 195}, {137, 137}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{202, 202}},
				outputRange: rangeBounds{{197, 197}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{203, 203}},
				outputRange: rangeBounds{{196, 196}, {150, 150}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{204, 204}},
				outputRange: rangeBounds{{196, 196}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{205, 205}},
				outputRange: rangeBounds{{196, 196}, {182, 182}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{206, 206}},
				outputRange: rangeBounds{{196, 196}, {170, 170}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{207, 207}},
				outputRange: rangeBounds{{196, 196}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{208, 208}},
				outputRange: rangeBounds{{197, 197}, {160, 160}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{209, 209}},
				outputRange: rangeBounds{{197, 197}, {131, 131}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{210, 210}},
				outputRange: rangeBounds{{197, 197}, {133, 133}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{211, 211}},
				outputRange: rangeBounds{{195, 195}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{212, 212}},
				outputRange: rangeBounds{{197, 197}, {140, 140}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{213, 215}},
				outputRange: rangeBounds{{195, 195}, {149, 151}},
				inputMults:  []int{1},
				outputMults: []int{3, 1},
			},
			{
				inputRange:  rangeBounds{{216, 216}},
				outputRange: rangeBounds{{197, 197}, {178, 178}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{217, 217}},
				outputRange: rangeBounds{{197, 197}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{218, 218}},
				outputRange: rangeBounds{{197, 197}, {154, 154}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{219, 219}},
				outputRange: rangeBounds{{197, 197}, {170, 170}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{220, 220}},
				outputRange: rangeBounds{{195, 195}, {156, 156}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{221, 221}},
				outputRange: rangeBounds{{197, 197}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{222, 222}},
				outputRange: rangeBounds{{197, 197}, {189, 189}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{223, 223}},
				outputRange: rangeBounds{{195, 195}, {159, 159}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{224, 224}},
				outputRange: rangeBounds{{196, 196}, {133, 133}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{225, 225}},
				outputRange: rangeBounds{{196, 196}, {175, 175}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{226, 226}},
				outputRange: rangeBounds{{196, 196}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{227, 227}},
				outputRange: rangeBounds{{196, 196}, {135, 135}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{228, 229}},
				outputRange: rangeBounds{{195, 195}, {164, 165}},
				inputMults:  []int{1},
				outputMults: []int{2, 1},
			},
			{
				inputRange:  rangeBounds{{230, 230}},
				outputRange: rangeBounds{{196, 196}, {153, 153}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{231, 231}},
				outputRange: rangeBounds{{196, 196}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{232, 232}},
				outputRange: rangeBounds{{196, 196}, {141, 141}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{233, 233}},
				outputRange: rangeBounds{{195, 195}, {169, 169}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{234, 234}},
				outputRange: rangeBounds{{197, 197}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{235, 235}},
				outputRange: rangeBounds{{196, 196}, {151, 151}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{236, 236}},
				outputRange: rangeBounds{{196, 196}, {163, 163}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{237, 237}},
				outputRange: rangeBounds{{196, 196}, {183, 183}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{238, 238}},
				outputRange: rangeBounds{{196, 196}, {171, 171}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{239, 239}},
				outputRange: rangeBounds{{196, 196}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{240, 240}},
				outputRange: rangeBounds{{197, 197}, {161, 161}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{241, 241}},
				outputRange: rangeBounds{{197, 197}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{242, 242}},
				outputRange: rangeBounds{{197, 197}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{243, 243}},
				outputRange: rangeBounds{{195, 195}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{244, 244}},
				outputRange: rangeBounds{{197, 197}, {141, 141}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{245, 247}},
				outputRange: rangeBounds{{195, 195}, {181, 183}},
				inputMults:  []int{1},
				outputMults: []int{3, 1},
			},
			{
				inputRange:  rangeBounds{{248, 248}},
				outputRange: rangeBounds{{197, 197}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{249, 249}},
				outputRange: rangeBounds{{197, 197}, {130, 130}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{250, 250}},
				outputRange: rangeBounds{{197, 197}, {155, 155}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{251, 251}},
				outputRange: rangeBounds{{197, 197}, {171, 171}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{252, 252}},
				outputRange: rangeBounds{{195, 195}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{253, 253}},
				outputRange: rangeBounds{{197, 197}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{254, 254}},
				outputRange: rangeBounds{{197, 197}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{161, 161}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {157, 157}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{165, 165}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{180, 180}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {156, 156}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{255, 255}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {153, 153}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
		},
		nil,
	},
	toUpper: map[rune]rune{
		97:  65,
		98:  66,
		99:  67,
		100: 68,
		101: 69,
		102: 70,
		103: 71,
		104: 72,
		105: 73,
		106: 74,
		107: 75,
		108: 76,
		109: 77,
		110: 78,
		111: 79,
		112: 80,
		113: 81,
		114: 82,
		115: 83,
		116: 84,
		117: 85,
		118: 86,
		119: 87,
		120: 88,
		121: 89,
		122: 90,
		228: 196,
		229: 197,
		230: 198,
		233: 201,
		243: 211,
		245: 213,
		246: 214,
		248: 216,
		252: 220,
		257: 256,
		261: 260,
		263: 262,
		269: 268,
		275: 274,
		279: 278,
		281: 280,
		291: 290,
		299: 298,
		303: 302,
		311: 310,
		316: 315,
		322: 321,
		324: 323,
		326: 325,
		333: 332,
		343: 342,
		347: 346,
		353: 352,
		363: 362,
		371: 370,
		378: 377,
		380: 379,
		382: 381,
	},
	toLower: map[rune]rune{
		65:  97,
		66:  98,
		67:  99,
		68:  100,
		69:  101,
		70:  102,
		71:  103,
		72:  104,
		73:  105,
		74:  106,
		75:  107,
		76:  108,
		77:  109,
		78:  110,
		79:  111,
		80:  112,
		81:  113,
		82:  114,
		83:  115,
		84:  116,
		85:  117,
		86:  118,
		87:  119,
		88:  120,
		89:  121,
		90:  122,
		196: 228,
		197: 229,
		198: 230,
		201: 233,
		211: 243,
		213: 245,
		214: 246,
		216: 248,
		220: 252,
		256: 257,
		260: 261,
		262: 263,
		268: 269,
		274: 275,
		278: 279,
		280: 281,
		290: 291,
		298: 299,
		302: 303,
		310: 311,
		315: 316,
		321: 322,
		323: 324,
		325: 326,
		332: 333,
		342: 343,
		346: 347,
		352: 353,
		362: 363,
		370: 371,
		377: 378,
		379: 380,
		381: 382,
	},
}
