// Copyright 2022 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Latin1_german2_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `latin1_german2_ci` collation.
func Latin1_german2_ci_RuneWeight(r rune) int32 {
	weight, ok := latin1_german2_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// latin1_german2_ci_Weights contain a map from rune to weight for the `latin1_german2_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var latin1_german2_ci_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	32:   32,
	33:   33,
	34:   34,
	35:   35,
	36:   36,
	37:   37,
	38:   38,
	39:   39,
	40:   40,
	41:   41,
	42:   42,
	43:   43,
	44:   44,
	45:   45,
	46:   46,
	47:   47,
	48:   48,
	49:   49,
	50:   50,
	51:   51,
	52:   52,
	53:   53,
	54:   54,
	55:   55,
	56:   56,
	57:   57,
	58:   58,
	59:   59,
	60:   60,
	61:   61,
	62:   62,
	63:   63,
	64:   64,
	65:   65,
	97:   65,
	192:  65,
	193:  65,
	194:  65,
	195:  65,
	197:  65,
	224:  65,
	225:  65,
	226:  65,
	227:  65,
	229:  65,
	196:  66,
	228:  66,
	66:   67,
	98:   67,
	67:   68,
	99:   68,
	199:  68,
	231:  68,
	68:   69,
	100:  69,
	208:  69,
	240:  69,
	69:   70,
	101:  70,
	200:  70,
	201:  70,
	202:  70,
	203:  70,
	232:  70,
	233:  70,
	234:  70,
	235:  70,
	70:   71,
	102:  71,
	71:   72,
	103:  72,
	72:   73,
	104:  73,
	73:   74,
	105:  74,
	204:  74,
	205:  74,
	206:  74,
	207:  74,
	236:  74,
	237:  74,
	238:  74,
	239:  74,
	74:   75,
	106:  75,
	75:   76,
	107:  76,
	76:   77,
	108:  77,
	77:   78,
	109:  78,
	78:   79,
	110:  79,
	209:  79,
	241:  79,
	79:   80,
	111:  80,
	210:  80,
	211:  80,
	212:  80,
	213:  80,
	242:  80,
	243:  80,
	244:  80,
	245:  80,
	214:  81,
	246:  81,
	80:   82,
	112:  82,
	81:   83,
	113:  83,
	82:   84,
	114:  84,
	83:   85,
	115:  85,
	223:  86,
	84:   87,
	116:  87,
	85:   88,
	117:  88,
	217:  88,
	218:  88,
	219:  88,
	249:  88,
	250:  88,
	251:  88,
	220:  89,
	252:  89,
	86:   90,
	118:  90,
	87:   91,
	119:  91,
	88:   92,
	120:  92,
	89:   93,
	121:  93,
	221:  93,
	253:  93,
	255:  93,
	90:   94,
	122:  94,
	91:   95,
	92:   96,
	198:  96,
	230:  96,
	93:   97,
	94:   98,
	95:   99,
	96:   100,
	123:  101,
	124:  102,
	125:  103,
	126:  104,
	127:  105,
	8364: 106,
	129:  107,
	8218: 108,
	402:  109,
	8222: 110,
	8230: 111,
	8224: 112,
	8225: 113,
	710:  114,
	8240: 115,
	352:  116,
	8249: 117,
	338:  118,
	141:  119,
	381:  120,
	143:  121,
	144:  122,
	8216: 123,
	8217: 124,
	8220: 125,
	8221: 126,
	8226: 127,
	8211: 128,
	8212: 129,
	732:  130,
	8482: 131,
	353:  132,
	8250: 133,
	339:  134,
	157:  135,
	382:  136,
	376:  137,
	160:  138,
	161:  139,
	162:  140,
	163:  141,
	164:  142,
	165:  143,
	166:  144,
	167:  145,
	168:  146,
	169:  147,
	170:  148,
	171:  149,
	172:  150,
	173:  151,
	174:  152,
	175:  153,
	176:  154,
	177:  155,
	178:  156,
	179:  157,
	180:  158,
	181:  159,
	182:  160,
	183:  161,
	184:  162,
	185:  163,
	186:  164,
	187:  165,
	188:  166,
	189:  167,
	190:  168,
	191:  169,
	215:  170,
	216:  171,
	248:  171,
	222:  172,
	254:  172,
	247:  173,
}
