// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Geostd8 represents the `geostd8` character set encoding.
var Geostd8 Encoder = &RangeMap{
	inputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
			{
				inputRange:  rangeBounds{{128, 128}},
				outputRange: rangeBounds{{226, 226}, {130, 130}, {172, 172}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{130, 130}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {154, 154}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{132, 132}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{133, 133}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{134, 135}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {160, 161}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{137, 137}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {176, 176}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{139, 139}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{145, 146}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {152, 153}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{147, 148}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {156, 157}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{149, 149}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{150, 151}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {147, 148}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{155, 155}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{160, 191}},
				outputRange: rangeBounds{{194, 194}, {160, 191}},
				inputMults:  []int{1},
				outputMults: []int{32, 1},
			},
			{
				inputRange:  rangeBounds{{192, 198}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {144, 150}},
				inputMults:  []int{1},
				outputMults: []int{7, 7, 1},
			},
			{
				inputRange:  rangeBounds{{199, 199}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {177, 177}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{200, 205}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {151, 156}},
				inputMults:  []int{1},
				outputMults: []int{6, 6, 1},
			},
			{
				inputRange:  rangeBounds{{206, 206}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {178, 178}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{207, 212}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {157, 162}},
				inputMults:  []int{1},
				outputMults: []int{6, 6, 1},
			},
			{
				inputRange:  rangeBounds{{213, 213}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{214, 225}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {163, 174}},
				inputMults:  []int{1},
				outputMults: []int{12, 12, 1},
			},
			{
				inputRange:  rangeBounds{{226, 226}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {180, 180}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{227, 228}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {175, 176}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{229, 229}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {181, 181}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{253, 253}},
				outputRange: rangeBounds{{226, 226}, {132, 132}, {150, 150}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
		},
		nil,
		nil,
		nil,
	},
	outputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{160, 191}},
				outputRange: rangeBounds{{194, 194}, {160, 191}},
				inputMults:  []int{1},
				outputMults: []int{32, 1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{128, 128}},
				outputRange: rangeBounds{{226, 226}, {130, 130}, {172, 172}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{130, 130}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {154, 154}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{132, 132}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{133, 133}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{134, 135}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {160, 161}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{137, 137}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {176, 176}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{139, 139}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{145, 146}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {152, 153}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{147, 148}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {156, 157}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{149, 149}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{150, 151}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {147, 148}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{155, 155}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{192, 198}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {144, 150}},
				inputMults:  []int{1},
				outputMults: []int{7, 7, 1},
			},
			{
				inputRange:  rangeBounds{{199, 199}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {177, 177}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{200, 205}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {151, 156}},
				inputMults:  []int{1},
				outputMults: []int{6, 6, 1},
			},
			{
				inputRange:  rangeBounds{{206, 206}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {178, 178}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{207, 212}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {157, 162}},
				inputMults:  []int{1},
				outputMults: []int{6, 6, 1},
			},
			{
				inputRange:  rangeBounds{{213, 213}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{214, 225}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {163, 174}},
				inputMults:  []int{1},
				outputMults: []int{12, 12, 1},
			},
			{
				inputRange:  rangeBounds{{226, 226}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {180, 180}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{227, 228}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {175, 176}},
				inputMults:  []int{1},
				outputMults: []int{2, 2, 1},
			},
			{
				inputRange:  rangeBounds{{229, 229}},
				outputRange: rangeBounds{{225, 225}, {131, 131}, {181, 181}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{253, 253}},
				outputRange: rangeBounds{{226, 226}, {132, 132}, {150, 150}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
		},
		nil,
	},
	toUpper: map[rune]rune{
		97:  65,
		98:  66,
		99:  67,
		100: 68,
		101: 69,
		102: 70,
		103: 71,
		104: 72,
		105: 73,
		106: 74,
		107: 75,
		108: 76,
		109: 77,
		110: 78,
		111: 79,
		112: 80,
		113: 81,
		114: 82,
		115: 83,
		116: 84,
		117: 85,
		118: 86,
		119: 87,
		120: 88,
		121: 89,
		122: 90,
	},
	toLower: map[rune]rune{
		65: 97,
		66: 98,
		67: 99,
		68: 100,
		69: 101,
		70: 102,
		71: 103,
		72: 104,
		73: 105,
		74: 106,
		75: 107,
		76: 108,
		77: 109,
		78: 110,
		79: 111,
		80: 112,
		81: 113,
		82: 114,
		83: 115,
		84: 116,
		85: 117,
		86: 118,
		87: 119,
		88: 120,
		89: 121,
		90: 122,
	},
}
