// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Dec8_swedish_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `dec8_swedish_ci` collation.
func Dec8_swedish_ci_RuneWeight(r rune) int32 {
	weight, ok := dec8_swedish_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// dec8_swedish_ci_Weights contain a map from rune to weight for the `dec8_swedish_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var dec8_swedish_ci_Weights = map[rune]int32{
	0:   0,
	1:   1,
	2:   2,
	3:   3,
	4:   4,
	5:   5,
	6:   6,
	7:   7,
	8:   8,
	9:   9,
	10:  10,
	11:  11,
	12:  12,
	13:  13,
	14:  14,
	15:  15,
	16:  16,
	17:  17,
	18:  18,
	19:  19,
	20:  20,
	21:  21,
	22:  22,
	23:  23,
	24:  24,
	25:  25,
	26:  26,
	27:  27,
	28:  28,
	29:  29,
	30:  30,
	31:  31,
	32:  32,
	33:  33,
	34:  34,
	35:  35,
	36:  36,
	37:  37,
	38:  38,
	39:  39,
	40:  40,
	41:  41,
	42:  42,
	43:  43,
	44:  44,
	45:  45,
	46:  46,
	47:  47,
	48:  48,
	49:  49,
	50:  50,
	51:  51,
	52:  52,
	53:  53,
	54:  54,
	55:  55,
	56:  56,
	57:  57,
	58:  58,
	59:  59,
	60:  60,
	61:  61,
	62:  62,
	63:  63,
	64:  64,
	65:  65,
	97:  65,
	192: 65,
	193: 65,
	194: 65,
	195: 65,
	224: 65,
	225: 65,
	226: 65,
	227: 65,
	66:  66,
	98:  66,
	67:  67,
	99:  67,
	199: 67,
	231: 67,
	68:  68,
	100: 68,
	69:  69,
	101: 69,
	200: 69,
	201: 69,
	202: 69,
	203: 69,
	232: 69,
	233: 69,
	234: 69,
	235: 69,
	70:  70,
	102: 70,
	71:  71,
	103: 71,
	72:  72,
	104: 72,
	73:  73,
	105: 73,
	204: 73,
	205: 73,
	206: 73,
	207: 73,
	236: 73,
	237: 73,
	238: 73,
	239: 73,
	74:  74,
	106: 74,
	75:  75,
	107: 75,
	76:  76,
	108: 76,
	77:  77,
	109: 77,
	78:  78,
	110: 78,
	209: 78,
	241: 78,
	79:  79,
	111: 79,
	210: 79,
	211: 79,
	212: 79,
	213: 79,
	242: 79,
	243: 79,
	244: 79,
	245: 79,
	80:  80,
	112: 80,
	81:  81,
	113: 81,
	82:  82,
	114: 82,
	83:  83,
	115: 83,
	84:  84,
	116: 84,
	85:  85,
	117: 85,
	217: 85,
	218: 85,
	219: 85,
	249: 85,
	250: 85,
	251: 85,
	86:  86,
	118: 86,
	87:  87,
	119: 87,
	88:  88,
	120: 88,
	89:  89,
	121: 89,
	220: 89,
	252: 89,
	255: 89,
	376: 89,
	90:  90,
	122: 90,
	91:  91,
	197: 91,
	229: 91,
	92:  92,
	196: 92,
	198: 92,
	228: 92,
	230: 92,
	93:  93,
	214: 93,
	246: 93,
	94:  94,
	95:  95,
	96:  96,
	123: 97,
	124: 98,
	125: 99,
	126: 100,
	127: 101,
	128: 102,
	129: 103,
	130: 104,
	131: 105,
	132: 106,
	133: 107,
	134: 108,
	135: 109,
	136: 110,
	137: 111,
	138: 112,
	139: 113,
	140: 114,
	141: 115,
	142: 116,
	143: 117,
	144: 118,
	145: 119,
	146: 120,
	147: 121,
	148: 122,
	149: 123,
	150: 124,
	151: 125,
	152: 126,
	153: 127,
	154: 128,
	155: 129,
	156: 130,
	157: 131,
	158: 132,
	159: 133,
	160: 134,
	161: 135,
	162: 136,
	163: 137,
	165: 138,
	167: 139,
	164: 140,
	169: 141,
	170: 142,
	171: 143,
	176: 144,
	177: 145,
	178: 146,
	179: 147,
	181: 148,
	182: 149,
	183: 150,
	185: 151,
	186: 152,
	187: 153,
	188: 154,
	189: 155,
	191: 156,
	338: 157,
	216: 158,
	248: 158,
	223: 159,
	339: 160,
}
