// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Cp1256_general_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `cp1256_general_ci` collation.
func Cp1256_general_ci_RuneWeight(r rune) int32 {
	weight, ok := cp1256_general_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// cp1256_general_ci_Weights contain a map from rune to weight for the `cp1256_general_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var cp1256_general_ci_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	32:   32,
	33:   33,
	34:   34,
	35:   35,
	36:   36,
	37:   37,
	38:   38,
	39:   39,
	40:   40,
	41:   41,
	42:   42,
	43:   43,
	44:   44,
	45:   45,
	46:   46,
	47:   47,
	48:   48,
	49:   49,
	50:   50,
	51:   51,
	52:   52,
	53:   53,
	54:   54,
	55:   55,
	56:   56,
	57:   57,
	58:   58,
	59:   59,
	60:   60,
	61:   61,
	62:   62,
	63:   63,
	64:   64,
	65:   65,
	97:   65,
	224:  66,
	226:  67,
	66:   68,
	98:   68,
	67:   69,
	99:   69,
	231:  70,
	68:   71,
	100:  71,
	69:   72,
	101:  72,
	232:  73,
	233:  74,
	234:  75,
	235:  76,
	70:   77,
	102:  77,
	402:  78,
	71:   79,
	103:  79,
	72:   80,
	104:  80,
	73:   81,
	105:  81,
	238:  82,
	239:  83,
	74:   84,
	106:  84,
	75:   85,
	107:  85,
	76:   86,
	108:  86,
	77:   87,
	109:  87,
	78:   88,
	110:  88,
	79:   89,
	111:  89,
	244:  90,
	338:  91,
	339:  91,
	80:   92,
	112:  92,
	81:   93,
	113:  93,
	82:   94,
	114:  94,
	83:   95,
	115:  95,
	84:   96,
	116:  96,
	85:   97,
	117:  97,
	249:  98,
	251:  99,
	252:  100,
	86:   101,
	118:  101,
	87:   102,
	119:  102,
	88:   103,
	120:  103,
	89:   104,
	121:  104,
	90:   105,
	122:  105,
	1569: 106,
	1570: 107,
	1571: 108,
	1572: 109,
	1573: 110,
	1574: 111,
	1575: 112,
	1576: 113,
	1577: 114,
	1662: 115,
	1579: 116,
	1580: 117,
	1670: 118,
	1581: 119,
	1582: 120,
	1583: 121,
	1584: 122,
	1585: 123,
	1586: 124,
	1688: 125,
	1587: 126,
	1588: 127,
	1589: 128,
	1590: 129,
	1591: 130,
	1578: 131,
	1592: 131,
	1593: 132,
	1594: 133,
	1601: 134,
	1602: 135,
	1603: 136,
	1711: 137,
	1604: 138,
	1605: 139,
	1606: 140,
	1607: 141,
	1608: 142,
	1609: 143,
	1610: 144,
	1600: 145,
	1611: 146,
	1612: 147,
	1613: 148,
	1614: 149,
	1615: 150,
	1616: 151,
	1617: 152,
	1618: 153,
	1548: 154,
	1563: 155,
	1567: 156,
	91:   157,
	92:   158,
	93:   159,
	94:   160,
	95:   161,
	96:   162,
	123:  163,
	124:  164,
	125:  165,
	126:  166,
	127:  167,
	8364: 168,
	8218: 169,
	8222: 170,
	8230: 171,
	8224: 172,
	8225: 173,
	710:  174,
	8240: 175,
	8249: 176,
	8216: 177,
	8217: 178,
	8220: 179,
	8221: 180,
	8226: 181,
	8211: 182,
	8212: 183,
	8482: 184,
	8250: 185,
	8204: 186,
	8205: 187,
	160:  188,
	162:  189,
	163:  190,
	164:  191,
	165:  192,
	166:  193,
	167:  194,
	168:  195,
	169:  196,
	171:  197,
	172:  198,
	173:  199,
	174:  200,
	175:  201,
	176:  202,
	177:  203,
	178:  204,
	179:  205,
	180:  206,
	181:  207,
	182:  208,
	183:  209,
	184:  210,
	185:  211,
	187:  212,
	188:  213,
	189:  214,
	190:  215,
	215:  216,
	247:  217,
	8206: 218,
	8207: 219,
}
