// Copyright 2025 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Armscii8 represents the `armscii8` character set encoding.
var Armscii8 Encoder = &RangeMap{
	inputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
			{
				inputRange:  rangeBounds{{128, 160}},
				outputRange: rangeBounds{{194, 194}, {128, 160}},
				inputMults:  []int{1},
				outputMults: []int{33, 1},
			},
			{
				inputRange:  rangeBounds{{161, 161}},
				outputRange: rangeBounds{{226, 226}, {157, 157}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{162, 162}},
				outputRange: rangeBounds{{194, 194}, {167, 167}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{163, 163}},
				outputRange: rangeBounds{{214, 214}, {137, 137}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{166, 166}},
				outputRange: rangeBounds{{194, 194}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{167, 167}},
				outputRange: rangeBounds{{194, 194}, {171, 171}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{168, 168}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {148, 148}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{170, 170}},
				outputRange: rangeBounds{{213, 213}, {157, 157}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{173, 173}},
				outputRange: rangeBounds{{213, 213}, {159, 159}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{174, 174}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{175, 175}},
				outputRange: rangeBounds{{213, 213}, {156, 156}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{176, 176}},
				outputRange: rangeBounds{{213, 213}, {155, 155}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{177, 177}},
				outputRange: rangeBounds{{213, 213}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{178, 178}},
				outputRange: rangeBounds{{212, 212}, {177, 177}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{179, 179}},
				outputRange: rangeBounds{{213, 213}, {161, 161}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{180, 180}},
				outputRange: rangeBounds{{212, 212}, {178, 178}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{181, 181}},
				outputRange: rangeBounds{{213, 213}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{182, 182}},
				outputRange: rangeBounds{{212, 212}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{183, 183}},
				outputRange: rangeBounds{{213, 213}, {163, 163}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{184, 184}},
				outputRange: rangeBounds{{212, 212}, {180, 180}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{185, 185}},
				outputRange: rangeBounds{{213, 213}, {164, 164}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{186, 186}},
				outputRange: rangeBounds{{212, 212}, {181, 181}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{187, 187}},
				outputRange: rangeBounds{{213, 213}, {165, 165}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{188, 188}},
				outputRange: rangeBounds{{212, 212}, {182, 182}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{189, 189}},
				outputRange: rangeBounds{{213, 213}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{190, 190}},
				outputRange: rangeBounds{{212, 212}, {183, 183}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{191, 191}},
				outputRange: rangeBounds{{213, 213}, {167, 167}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{192, 192}},
				outputRange: rangeBounds{{212, 212}, {184, 184}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{193, 193}},
				outputRange: rangeBounds{{213, 213}, {168, 168}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{194, 194}},
				outputRange: rangeBounds{{212, 212}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{195, 195}},
				outputRange: rangeBounds{{213, 213}, {169, 169}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{196, 196}},
				outputRange: rangeBounds{{212, 212}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{197, 197}},
				outputRange: rangeBounds{{213, 213}, {170, 170}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{198, 198}},
				outputRange: rangeBounds{{212, 212}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{199, 199}},
				outputRange: rangeBounds{{213, 213}, {171, 171}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{200, 200}},
				outputRange: rangeBounds{{212, 212}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{201, 201}},
				outputRange: rangeBounds{{213, 213}, {172, 172}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{202, 202}},
				outputRange: rangeBounds{{212, 212}, {189, 189}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{203, 203}},
				outputRange: rangeBounds{{213, 213}, {173, 173}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{204, 204}},
				outputRange: rangeBounds{{212, 212}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{205, 205}},
				outputRange: rangeBounds{{213, 213}, {174, 174}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{206, 206}},
				outputRange: rangeBounds{{212, 212}, {191, 191}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{207, 207}},
				outputRange: rangeBounds{{213, 213}, {175, 175}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{208, 208}},
				outputRange: rangeBounds{{213, 213}, {128, 128}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{209, 209}},
				outputRange: rangeBounds{{213, 213}, {176, 176}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{210, 210}},
				outputRange: rangeBounds{{213, 213}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{211, 211}},
				outputRange: rangeBounds{{213, 213}, {177, 177}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{212, 212}},
				outputRange: rangeBounds{{213, 213}, {130, 130}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{213, 213}},
				outputRange: rangeBounds{{213, 213}, {178, 178}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{214, 214}},
				outputRange: rangeBounds{{213, 213}, {131, 131}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{215, 215}},
				outputRange: rangeBounds{{213, 213}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{216, 216}},
				outputRange: rangeBounds{{213, 213}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{217, 217}},
				outputRange: rangeBounds{{213, 213}, {180, 180}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{218, 218}},
				outputRange: rangeBounds{{213, 213}, {133, 133}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{219, 219}},
				outputRange: rangeBounds{{213, 213}, {181, 181}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{220, 220}},
				outputRange: rangeBounds{{213, 213}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{221, 221}},
				outputRange: rangeBounds{{213, 213}, {182, 182}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{222, 222}},
				outputRange: rangeBounds{{213, 213}, {135, 135}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{223, 223}},
				outputRange: rangeBounds{{213, 213}, {183, 183}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{224, 224}},
				outputRange: rangeBounds{{213, 213}, {136, 136}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{225, 225}},
				outputRange: rangeBounds{{213, 213}, {184, 184}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{226, 226}},
				outputRange: rangeBounds{{213, 213}, {137, 137}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{227, 227}},
				outputRange: rangeBounds{{213, 213}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{228, 228}},
				outputRange: rangeBounds{{213, 213}, {138, 138}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{229, 229}},
				outputRange: rangeBounds{{213, 213}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{230, 230}},
				outputRange: rangeBounds{{213, 213}, {139, 139}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{231, 231}},
				outputRange: rangeBounds{{213, 213}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{232, 232}},
				outputRange: rangeBounds{{213, 213}, {140, 140}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{233, 233}},
				outputRange: rangeBounds{{213, 213}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{234, 234}},
				outputRange: rangeBounds{{213, 213}, {141, 141}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{235, 235}},
				outputRange: rangeBounds{{213, 213}, {189, 189}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{236, 236}},
				outputRange: rangeBounds{{213, 213}, {142, 142}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{237, 237}},
				outputRange: rangeBounds{{213, 213}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{238, 238}},
				outputRange: rangeBounds{{213, 213}, {143, 143}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{239, 239}},
				outputRange: rangeBounds{{213, 213}, {191, 191}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{240, 240}},
				outputRange: rangeBounds{{213, 213}, {144, 144}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{241, 241}},
				outputRange: rangeBounds{{214, 214}, {128, 128}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{242, 242}},
				outputRange: rangeBounds{{213, 213}, {145, 145}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{243, 243}},
				outputRange: rangeBounds{{214, 214}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{244, 244}},
				outputRange: rangeBounds{{213, 213}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{245, 245}},
				outputRange: rangeBounds{{214, 214}, {130, 130}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{246, 246}},
				outputRange: rangeBounds{{213, 213}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{247, 247}},
				outputRange: rangeBounds{{214, 214}, {131, 131}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{248, 248}},
				outputRange: rangeBounds{{213, 213}, {148, 148}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{249, 249}},
				outputRange: rangeBounds{{214, 214}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{250, 250}},
				outputRange: rangeBounds{{213, 213}, {149, 149}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{251, 251}},
				outputRange: rangeBounds{{214, 214}, {133, 133}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{252, 252}},
				outputRange: rangeBounds{{213, 213}, {150, 150}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{253, 253}},
				outputRange: rangeBounds{{214, 214}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{254, 254}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {153, 153}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
		},
		nil,
		nil,
		nil,
	},
	outputEntries: [][]rangeMapEntry{
		{
			{
				inputRange:  rangeBounds{{0, 127}},
				outputRange: rangeBounds{{0, 127}},
				inputMults:  []int{1},
				outputMults: []int{1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{128, 160}},
				outputRange: rangeBounds{{194, 194}, {128, 160}},
				inputMults:  []int{1},
				outputMults: []int{33, 1},
			},
			{
				inputRange:  rangeBounds{{162, 162}},
				outputRange: rangeBounds{{194, 194}, {167, 167}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{163, 163}},
				outputRange: rangeBounds{{214, 214}, {137, 137}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{166, 166}},
				outputRange: rangeBounds{{194, 194}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{167, 167}},
				outputRange: rangeBounds{{194, 194}, {171, 171}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{170, 170}},
				outputRange: rangeBounds{{213, 213}, {157, 157}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{173, 173}},
				outputRange: rangeBounds{{213, 213}, {159, 159}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{175, 175}},
				outputRange: rangeBounds{{213, 213}, {156, 156}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{176, 176}},
				outputRange: rangeBounds{{213, 213}, {155, 155}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{177, 177}},
				outputRange: rangeBounds{{213, 213}, {158, 158}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{178, 178}},
				outputRange: rangeBounds{{212, 212}, {177, 177}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{179, 179}},
				outputRange: rangeBounds{{213, 213}, {161, 161}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{180, 180}},
				outputRange: rangeBounds{{212, 212}, {178, 178}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{181, 181}},
				outputRange: rangeBounds{{213, 213}, {162, 162}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{182, 182}},
				outputRange: rangeBounds{{212, 212}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{183, 183}},
				outputRange: rangeBounds{{213, 213}, {163, 163}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{184, 184}},
				outputRange: rangeBounds{{212, 212}, {180, 180}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{185, 185}},
				outputRange: rangeBounds{{213, 213}, {164, 164}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{186, 186}},
				outputRange: rangeBounds{{212, 212}, {181, 181}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{187, 187}},
				outputRange: rangeBounds{{213, 213}, {165, 165}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{188, 188}},
				outputRange: rangeBounds{{212, 212}, {182, 182}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{189, 189}},
				outputRange: rangeBounds{{213, 213}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{190, 190}},
				outputRange: rangeBounds{{212, 212}, {183, 183}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{191, 191}},
				outputRange: rangeBounds{{213, 213}, {167, 167}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{192, 192}},
				outputRange: rangeBounds{{212, 212}, {184, 184}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{193, 193}},
				outputRange: rangeBounds{{213, 213}, {168, 168}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{194, 194}},
				outputRange: rangeBounds{{212, 212}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{195, 195}},
				outputRange: rangeBounds{{213, 213}, {169, 169}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{196, 196}},
				outputRange: rangeBounds{{212, 212}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{197, 197}},
				outputRange: rangeBounds{{213, 213}, {170, 170}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{198, 198}},
				outputRange: rangeBounds{{212, 212}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{199, 199}},
				outputRange: rangeBounds{{213, 213}, {171, 171}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{200, 200}},
				outputRange: rangeBounds{{212, 212}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{201, 201}},
				outputRange: rangeBounds{{213, 213}, {172, 172}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{202, 202}},
				outputRange: rangeBounds{{212, 212}, {189, 189}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{203, 203}},
				outputRange: rangeBounds{{213, 213}, {173, 173}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{204, 204}},
				outputRange: rangeBounds{{212, 212}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{205, 205}},
				outputRange: rangeBounds{{213, 213}, {174, 174}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{206, 206}},
				outputRange: rangeBounds{{212, 212}, {191, 191}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{207, 207}},
				outputRange: rangeBounds{{213, 213}, {175, 175}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{208, 208}},
				outputRange: rangeBounds{{213, 213}, {128, 128}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{209, 209}},
				outputRange: rangeBounds{{213, 213}, {176, 176}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{210, 210}},
				outputRange: rangeBounds{{213, 213}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{211, 211}},
				outputRange: rangeBounds{{213, 213}, {177, 177}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{212, 212}},
				outputRange: rangeBounds{{213, 213}, {130, 130}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{213, 213}},
				outputRange: rangeBounds{{213, 213}, {178, 178}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{214, 214}},
				outputRange: rangeBounds{{213, 213}, {131, 131}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{215, 215}},
				outputRange: rangeBounds{{213, 213}, {179, 179}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{216, 216}},
				outputRange: rangeBounds{{213, 213}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{217, 217}},
				outputRange: rangeBounds{{213, 213}, {180, 180}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{218, 218}},
				outputRange: rangeBounds{{213, 213}, {133, 133}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{219, 219}},
				outputRange: rangeBounds{{213, 213}, {181, 181}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{220, 220}},
				outputRange: rangeBounds{{213, 213}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{221, 221}},
				outputRange: rangeBounds{{213, 213}, {182, 182}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{222, 222}},
				outputRange: rangeBounds{{213, 213}, {135, 135}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{223, 223}},
				outputRange: rangeBounds{{213, 213}, {183, 183}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{224, 224}},
				outputRange: rangeBounds{{213, 213}, {136, 136}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{225, 225}},
				outputRange: rangeBounds{{213, 213}, {184, 184}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{226, 226}},
				outputRange: rangeBounds{{213, 213}, {137, 137}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{227, 227}},
				outputRange: rangeBounds{{213, 213}, {185, 185}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{228, 228}},
				outputRange: rangeBounds{{213, 213}, {138, 138}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{229, 229}},
				outputRange: rangeBounds{{213, 213}, {186, 186}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{230, 230}},
				outputRange: rangeBounds{{213, 213}, {139, 139}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{231, 231}},
				outputRange: rangeBounds{{213, 213}, {187, 187}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{232, 232}},
				outputRange: rangeBounds{{213, 213}, {140, 140}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{233, 233}},
				outputRange: rangeBounds{{213, 213}, {188, 188}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{234, 234}},
				outputRange: rangeBounds{{213, 213}, {141, 141}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{235, 235}},
				outputRange: rangeBounds{{213, 213}, {189, 189}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{236, 236}},
				outputRange: rangeBounds{{213, 213}, {142, 142}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{237, 237}},
				outputRange: rangeBounds{{213, 213}, {190, 190}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{238, 238}},
				outputRange: rangeBounds{{213, 213}, {143, 143}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{239, 239}},
				outputRange: rangeBounds{{213, 213}, {191, 191}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{240, 240}},
				outputRange: rangeBounds{{213, 213}, {144, 144}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{241, 241}},
				outputRange: rangeBounds{{214, 214}, {128, 128}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{242, 242}},
				outputRange: rangeBounds{{213, 213}, {145, 145}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{243, 243}},
				outputRange: rangeBounds{{214, 214}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{244, 244}},
				outputRange: rangeBounds{{213, 213}, {146, 146}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{245, 245}},
				outputRange: rangeBounds{{214, 214}, {130, 130}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{246, 246}},
				outputRange: rangeBounds{{213, 213}, {147, 147}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{247, 247}},
				outputRange: rangeBounds{{214, 214}, {131, 131}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{248, 248}},
				outputRange: rangeBounds{{213, 213}, {148, 148}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{249, 249}},
				outputRange: rangeBounds{{214, 214}, {132, 132}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{250, 250}},
				outputRange: rangeBounds{{213, 213}, {149, 149}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{251, 251}},
				outputRange: rangeBounds{{214, 214}, {133, 133}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{252, 252}},
				outputRange: rangeBounds{{213, 213}, {150, 150}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
			{
				inputRange:  rangeBounds{{253, 253}},
				outputRange: rangeBounds{{214, 214}, {134, 134}},
				inputMults:  []int{1},
				outputMults: []int{1, 1},
			},
		},
		{
			{
				inputRange:  rangeBounds{{161, 161}},
				outputRange: rangeBounds{{226, 226}, {157, 157}, {129, 129}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{168, 168}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {148, 148}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{174, 174}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {166, 166}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
			{
				inputRange:  rangeBounds{{254, 254}},
				outputRange: rangeBounds{{226, 226}, {128, 128}, {153, 153}},
				inputMults:  []int{1},
				outputMults: []int{1, 1, 1},
			},
		},
		nil,
	},
	toUpper: map[rune]rune{
		97:   65,
		98:   66,
		99:   67,
		100:  68,
		101:  69,
		102:  70,
		103:  71,
		104:  72,
		105:  73,
		106:  74,
		107:  75,
		108:  76,
		109:  77,
		110:  78,
		111:  79,
		112:  80,
		113:  81,
		114:  82,
		115:  83,
		116:  84,
		117:  85,
		118:  86,
		119:  87,
		120:  88,
		121:  89,
		122:  90,
		1377: 1329,
		1378: 1330,
		1379: 1331,
		1380: 1332,
		1381: 1333,
		1382: 1334,
		1383: 1335,
		1384: 1336,
		1385: 1337,
		1386: 1338,
		1387: 1339,
		1388: 1340,
		1389: 1341,
		1390: 1342,
		1391: 1343,
		1392: 1344,
		1393: 1345,
		1394: 1346,
		1395: 1347,
		1396: 1348,
		1397: 1349,
		1398: 1350,
		1399: 1351,
		1400: 1352,
		1401: 1353,
		1402: 1354,
		1403: 1355,
		1404: 1356,
		1405: 1357,
		1406: 1358,
		1407: 1359,
		1408: 1360,
		1409: 1361,
		1410: 1362,
		1411: 1363,
		1412: 1364,
		1413: 1365,
		1414: 1366,
	},
	toLower: map[rune]rune{
		65:   97,
		66:   98,
		67:   99,
		68:   100,
		69:   101,
		70:   102,
		71:   103,
		72:   104,
		73:   105,
		74:   106,
		75:   107,
		76:   108,
		77:   109,
		78:   110,
		79:   111,
		80:   112,
		81:   113,
		82:   114,
		83:   115,
		84:   116,
		85:   117,
		86:   118,
		87:   119,
		88:   120,
		89:   121,
		90:   122,
		1329: 1377,
		1330: 1378,
		1331: 1379,
		1332: 1380,
		1333: 1381,
		1334: 1382,
		1335: 1383,
		1336: 1384,
		1337: 1385,
		1338: 1386,
		1339: 1387,
		1340: 1388,
		1341: 1389,
		1342: 1390,
		1343: 1391,
		1344: 1392,
		1345: 1393,
		1346: 1394,
		1347: 1395,
		1348: 1396,
		1349: 1397,
		1350: 1398,
		1351: 1399,
		1352: 1400,
		1353: 1401,
		1354: 1402,
		1355: 1403,
		1356: 1404,
		1357: 1405,
		1358: 1406,
		1359: 1407,
		1360: 1408,
		1361: 1409,
		1362: 1410,
		1363: 1411,
		1364: 1412,
		1365: 1413,
		1366: 1414,
		8212: 1332,
	},
}
