// Code generated by cuelang.org/go/pkg/gen. DO NOT EDIT.

package bits

import (
	"cuelang.org/go/internal/core/adt"
	"cuelang.org/go/pkg/internal"
)

func init() {
	internal.Register("math/bits", pkg)
}

var _ = adt.TopKind // in case the adt package isn't used

var pkg = &internal.Package{
	Native: []*internal.Builtin{{
		Name: "Lsh",
		Params: []internal.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			x, n := c.BigInt(0), c.Uint(1)
			if c.Do() {
				c.Ret = Lsh(x, n)
			}
		},
	}, {
		Name: "Rsh",
		Params: []internal.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			x, n := c.BigInt(0), c.Uint(1)
			if c.Do() {
				c.Ret = Rsh(x, n)
			}
		},
	}, {
		Name: "At",
		Params: []internal.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			x, i := c.BigInt(0), c.Uint(1)
			if c.Do() {
				c.Ret, c.Err = At(x, i)
			}
		},
	}, {
		Name: "Set",
		Params: []internal.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			x, i, bit := c.BigInt(0), c.Int(1), c.Uint(2)
			if c.Do() {
				c.Ret = Set(x, i, bit)
			}
		},
	}, {
		Name: "And",
		Params: []internal.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			a, b := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = And(a, b)
			}
		},
	}, {
		Name: "Or",
		Params: []internal.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			a, b := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = Or(a, b)
			}
		},
	}, {
		Name: "Xor",
		Params: []internal.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			a, b := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = Xor(a, b)
			}
		},
	}, {
		Name: "Clear",
		Params: []internal.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			a, b := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = Clear(a, b)
			}
		},
	}, {
		Name: "OnesCount",
		Params: []internal.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			x := c.BigInt(0)
			if c.Do() {
				c.Ret = OnesCount(x)
			}
		},
	}, {
		Name: "Len",
		Params: []internal.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			x := c.BigInt(0)
			if c.Do() {
				c.Ret = Len(x)
			}
		},
	}},
}
