# OpenAPI specifications

Since version 8.4, HTTP API details are [specified](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/api-merged.json) using OpenAPI v2. Starting from version 9.1, there is also an [OpenAPI v3 specification](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/openapi3.json) (generated by the v2 one using [this script](https://github.com/grafana/grafana/blob/main/scripts/openapi3/openapi3conv.go)).

# OpenAPI annotations

The OpenAPI v2 specification is generated automatically from the annotated Go code using [go-swagger](https://github.com/go-swagger/go-swagger) which scans the source code for [annotation rules](https://goswagger.io/use/spec.html). Refer to [this getting started guide](https://medium.com/@pedram.esmaeeli/generate-swagger-specification-from-go-source-code-648615f7b9d9) for getting familiar with the toolkit. 

Developers modifying the HTTP API endpoints need to make sure to add the necessary annotations so that their changes are reflected into the generated specifications.

## Example of endpoint annotation

The following route defines a `PATCH` endpoint under the `/serviceaccounts/{serviceAccountId}` path with tag `service_accounts` (used for grouping together several routes) and operation ID `updateServiceAccount` (used for uniquely identifying routes and associate parameters and response with them).

> For enterprise endpoints make sure you add the `enterprise` tag as well.

```go

// swagger:route PATCH /serviceaccounts/{serviceAccountId} service_accounts updateServiceAccount
//
// # Update service account
//
// Required permissions (See note in the [introduction](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api) for an explanation):
// action: `serviceaccounts:write` scope: `serviceaccounts:id:1` (single service account)
//
// Responses:
// 200: updateServiceAccountResponse
// 400: badRequestError
// 401: unauthorisedError
// 403: forbiddenError
// 404: notFoundError
// 500: internalServerError

```

The `go-swagger` can discover such annotations by scanning any code imported by [`pkg/server`](https://github.com/grafana/grafana/blob/main/pkg/server/server.go) but by convention we place the endpoint annotations above the endpoint definition.

## Example of endpoint parameters

The following struct defines the route parameters for the `updateServiceAccount` endpoint. The route expects:
* a path parameter denoting the service account identifier and
* a body parameter with the new values for the specific service account

```go

// swagger:parameters updateServiceAccount
type UpdateServiceAccountParams struct {
	// in:path
	ServiceAccountId int64 `json:"serviceAccountId"`
	// in:body
	Body serviceaccounts.UpdateServiceAccountForm
}
```

## Example of endpoint response

The following struct defines the response for the `updateServiceAccount` endpoint in case of a successful `200` response.

```go

// swagger:response updateServiceAccountResponse
type UpdateServiceAccountResponse struct {
	// in:body
	Body struct {
		Message        string                                    `json:"message"`
		ID             int64                                     `json:"id"`
		Name           string                                    `json:"name"`
		ServiceAccount *serviceaccounts.ServiceAccountProfileDTO `json:"serviceaccount"`
	}
}
```

# OpenAPI generation

Developers can re-create the OpenAPI v2 and v3 specifications using the following command:

```bash
make swagger-clean && make openapi3-gen
```

They can observe its output into the `public/api-merged.json` and `public/openapi3.json` files.

Finally, they can browser and try out both the OpenAPI v2 and v3 via the Swagger UI editor (served by the grafana server) by navigating to `/swagger`.

If there are any issues generating the specifications (e.g., diff containing unrelated changes to your PR or unusually large diff), please run the following command to ensure your Swagger version is up to date, then re-run the make commands.
- `go tool github.com/go-swagger/go-swagger/cmd/swagger@v0.30.6`
