//go:build !ignore_autogenerated
// +build !ignore_autogenerated

// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by openapi-gen. DO NOT EDIT.

package v1beta1

import (
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AlertEnrichment":          schema_pkg_apis_alertenrichment_v1beta1_AlertEnrichment(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AlertEnrichmentJSONCodec": schema_pkg_apis_alertenrichment_v1beta1_AlertEnrichmentJSONCodec(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AlertEnrichmentList":      schema_pkg_apis_alertenrichment_v1beta1_AlertEnrichmentList(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AlertEnrichmentSpec":      schema_pkg_apis_alertenrichment_v1beta1_AlertEnrichmentSpec(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssertsEnricher":          schema_pkg_apis_alertenrichment_v1beta1_AssertsEnricher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssignEnricher":           schema_pkg_apis_alertenrichment_v1beta1_AssignEnricher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Assignment":               schema_pkg_apis_alertenrichment_v1beta1_Assignment(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssistantEnricher":        schema_pkg_apis_alertenrichment_v1beta1_AssistantEnricher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Condition":                schema_pkg_apis_alertenrichment_v1beta1_Condition(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Conditional":              schema_pkg_apis_alertenrichment_v1beta1_Conditional(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.DataSourceEnricher":       schema_pkg_apis_alertenrichment_v1beta1_DataSourceEnricher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.EnricherConfig":           schema_pkg_apis_alertenrichment_v1beta1_EnricherConfig(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.ExplainEnricher":          schema_pkg_apis_alertenrichment_v1beta1_ExplainEnricher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.ExternalEnricher":         schema_pkg_apis_alertenrichment_v1beta1_ExternalEnricher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.LogsDataSourceQuery":      schema_pkg_apis_alertenrichment_v1beta1_LogsDataSourceQuery(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.LoopEnricher":             schema_pkg_apis_alertenrichment_v1beta1_LoopEnricher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Matcher":                  schema_pkg_apis_alertenrichment_v1beta1_Matcher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.RawDataSourceQuery":       schema_pkg_apis_alertenrichment_v1beta1_RawDataSourceQuery(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.SiftEnricher":             schema_pkg_apis_alertenrichment_v1beta1_SiftEnricher(ref),
		"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Step":                     schema_pkg_apis_alertenrichment_v1beta1_Step(ref),
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_AlertEnrichment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AlertEnrichmentSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AlertEnrichmentSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_AlertEnrichmentJSONCodec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AlertEnrichmentJSONCodec is a JSON codec for AlertEnrichment resources",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_AlertEnrichmentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AlertEnrichment"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AlertEnrichment", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_AlertEnrichmentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AlertEnrichmentSpec specifies an alert enrichment pipeline.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"title": {
						SchemaProps: spec.SchemaProps{
							Description: "Title of the alert enrichment.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description of the alert enrichment.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"alertRuleUids": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Alert rules for which to run the enrichment for. If not set, the enrichment runs for all alert rules.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"labelMatchers": {
						SchemaProps: spec.SchemaProps{
							Description: "LabelMatchers optionally restricts when this enrichment runs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Matcher"),
									},
								},
							},
						},
					},
					"annotationMatchers": {
						SchemaProps: spec.SchemaProps{
							Description: "AnnotationMatchers optionally restricts when this enrichment runs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Matcher"),
									},
								},
							},
						},
					},
					"receivers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Receivers optionally restricts the enrichment to one or more receiver names. If not set, the enrichment runs for alerts coming from all receivers.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"steps": {
						SchemaProps: spec.SchemaProps{
							Description: "Steps of the enrichment pipeline.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Step"),
									},
								},
							},
						},
					},
				},
				Required: []string{"title", "steps"},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Matcher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Step"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_AssertsEnricher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AssertsEnricher configures an enricher which calls into Asserts.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_AssignEnricher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AssignEnricher configures an enricher which assigns annotations.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"annotations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Annotations to change and values to set them to.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Assignment"),
									},
								},
							},
						},
					},
				},
				Required: []string{"annotations"},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Assignment"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_Assignment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the annotation to assign.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value to assign to the annotation. Can use Go template format, with access to annotations and labels via e.g. {{$annotations.x}}",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_AssistantEnricher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AssistantEnricher configures an enricher which calls into Assistant.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_Condition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"labelMatchers": {
						SchemaProps: spec.SchemaProps{
							Description: "LabelMatchers optionally specifies the condition to require matching label values.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Matcher"),
									},
								},
							},
						},
					},
					"annotationMatchers": {
						SchemaProps: spec.SchemaProps{
							Description: "AnnotationMatchers optionally restricts when the per-alert enrichments are run.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Matcher"),
									},
								},
							},
						},
					},
					"dataSourceQuery": {
						SchemaProps: spec.SchemaProps{
							Description: "DataSourceQuery is a data source query to run. If the query returns a non-zero value, then the condition is taken to be true.",
							Ref:         ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.RawDataSourceQuery"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Matcher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.RawDataSourceQuery"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_Conditional(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"if": {
						SchemaProps: spec.SchemaProps{
							Description: "If is the condition to evaluate.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Condition"),
						},
					},
					"then": {
						SchemaProps: spec.SchemaProps{
							Description: "Then is the enrichment steps to perform if all the conditions above are true.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Step"),
									},
								},
							},
						},
					},
					"else": {
						SchemaProps: spec.SchemaProps{
							Description: "Else is the enrichment steps to perform otherwise.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Step"),
									},
								},
							},
						},
					},
				},
				Required: []string{"if", "then"},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Condition", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Step"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_DataSourceEnricher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DataSourceEnricher configures an enricher which calls an external service.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Possible enum values:\n - `\"logs\"`\n - `\"raw\"`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"logs", "raw"},
						},
					},
					"raw": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.RawDataSourceQuery"),
						},
					},
					"logs": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.LogsDataSourceQuery"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.LogsDataSourceQuery", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.RawDataSourceQuery"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_EnricherConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EnricherConfig is a discriminated union of enricher configurations.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Possible enum values:\n - `\"asserts\"`\n - `\"assign\"`\n - `\"assistant\"`\n - `\"dsquery\"`\n - `\"explain\"`\n - `\"external\"`\n - `\"loop\"`\n - `\"sift\"`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"asserts", "assign", "assistant", "dsquery", "explain", "external", "loop", "sift"},
						},
					},
					"assign": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssignEnricher"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.ExternalEnricher"),
						},
					},
					"dataSource": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.DataSourceEnricher"),
						},
					},
					"sift": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.SiftEnricher"),
						},
					},
					"asserts": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssertsEnricher"),
						},
					},
					"explain": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.ExplainEnricher"),
						},
					},
					"loop": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.LoopEnricher"),
						},
					},
					"assistant": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssistantEnricher"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssertsEnricher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssignEnricher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.AssistantEnricher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.DataSourceEnricher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.ExplainEnricher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.ExternalEnricher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.LoopEnricher", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.SiftEnricher"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_ExplainEnricher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExplainEnricher uses LLM to generate explanations for alerts.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"annotation": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"annotation"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_ExternalEnricher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalEnricher configures an enricher which calls an external service.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "URL of the external HTTP service to call out to.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"url"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_LogsDataSourceQuery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LogsDataSourceQuery is a simplified method of describing a logs query, typically those that return data frames with a \"Line\" field.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"dataSourceType": {
						SchemaProps: spec.SchemaProps{
							Description: "The datasource plugin type",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dataSourceUid": {
						SchemaProps: spec.SchemaProps{
							Description: "Datasource UID",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expr": {
						SchemaProps: spec.SchemaProps{
							Description: "The logs query to run.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"maxLines": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of log lines to add to the alert. Defaults to 3.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"dataSourceType", "expr"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_LoopEnricher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LoopEnricher configures an enricher which calls into Loop.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_Matcher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Matcher is used to match label (or annotation) values.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Possible enum values:\n - `\"!=\"`\n - `\"!~\"`\n - `\"=\"`\n - `\"=~\"`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"!=", "!~", "=", "=~"},
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"type", "name", "value"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_RawDataSourceQuery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RawDataSourceQuery allows defining the entire query request",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"request": {
						SchemaProps: spec.SchemaProps{
							Description: "The data source request to perform.",
							Ref:         ref("github.com/grafana/grafana/pkg/apimachinery/apis/common/v0alpha1.Unstructured"),
						},
					},
					"refId": {
						SchemaProps: spec.SchemaProps{
							Description: "The RefID of the response to use. Not required if only a single query is given.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/pkg/apimachinery/apis/common/v0alpha1.Unstructured"},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_SiftEnricher(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SiftEnricher configures an enricher which calls into Sift.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_alertenrichment_v1beta1_Step(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Step represent an invocation of a single enricher.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Possible enum values:\n - `\"conditional\"`\n - `\"enricher\"`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"conditional", "enricher"},
						},
					},
					"timeout": {
						SchemaProps: spec.SchemaProps{
							Description: "Timeout is the maximum about of time this specific enrichment is allowed to take.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"enricher": {
						SchemaProps: spec.SchemaProps{
							Description: "Enricher specifies what enricher to run and it's configuration.",
							Ref:         ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.EnricherConfig"),
						},
					},
					"conditional": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditional allows branching to specifies what enricher to run and it's configuration.",
							Ref:         ref("github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Conditional"),
						},
					},
				},
				Required: []string{"type", "timeout"},
			},
		},
		Dependencies: []string{
			"github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.Conditional", "github.com/grafana/grafana/apps/alerting/alertenrichment/pkg/apis/alertenrichment/v1beta1.EnricherConfig", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}
