// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolResourceProfiles = sync.Pool{
		New: func() any {
			return &otlpprofiles.ResourceProfiles{}
		},
	}
)

func NewOrigResourceProfiles() *otlpprofiles.ResourceProfiles {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.ResourceProfiles{}
	}
	return protoPoolResourceProfiles.Get().(*otlpprofiles.ResourceProfiles)
}

func DeleteOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigResource(&orig.Resource, false)
	for i := range orig.ScopeProfiles {
		DeleteOrigScopeProfiles(orig.ScopeProfiles[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolResourceProfiles.Put(orig)
	}
}

func CopyOrigResourceProfiles(dest, src *otlpprofiles.ResourceProfiles) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	CopyOrigResource(&dest.Resource, &src.Resource)
	dest.ScopeProfiles = CopyOrigScopeProfilesSlice(dest.ScopeProfiles, src.ScopeProfiles)
	dest.SchemaUrl = src.SchemaUrl
}

func GenTestOrigResourceProfiles() *otlpprofiles.ResourceProfiles {
	orig := NewOrigResourceProfiles()
	orig.Resource = *GenTestOrigResource()
	orig.ScopeProfiles = GenerateOrigTestScopeProfilesSlice()
	orig.SchemaUrl = "test_schemaurl"
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("resource")
	MarshalJSONOrigResource(&orig.Resource, dest)
	if len(orig.ScopeProfiles) > 0 {
		dest.WriteObjectField("scopeProfiles")
		dest.WriteArrayStart()
		MarshalJSONOrigScopeProfiles(orig.ScopeProfiles[0], dest)
		for i := 1; i < len(orig.ScopeProfiles); i++ {
			dest.WriteMore()
			MarshalJSONOrigScopeProfiles(orig.ScopeProfiles[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigResourceProfiles unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resource":
			UnmarshalJSONOrigResource(&orig.Resource, iter)
		case "scopeProfiles", "scope_profiles":
			for iter.ReadArray() {
				orig.ScopeProfiles = append(orig.ScopeProfiles, NewOrigScopeProfiles())
				UnmarshalJSONOrigScopeProfiles(orig.ScopeProfiles[len(orig.ScopeProfiles)-1], iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigResource(&orig.Resource)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.ScopeProfiles {
		l = SizeProtoOrigScopeProfiles(orig.ScopeProfiles[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigResource(&orig.Resource, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.ScopeProfiles) - 1; i >= 0; i-- {
		l = MarshalProtoOrigScopeProfiles(orig.ScopeProfiles[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigResourceProfiles(orig *otlpprofiles.ResourceProfiles, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigResource(&orig.Resource, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeProfiles", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ScopeProfiles = append(orig.ScopeProfiles, NewOrigScopeProfiles())
			err = UnmarshalProtoOrigScopeProfiles(orig.ScopeProfiles[len(orig.ScopeProfiles)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
