// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: pkg/tempopb/backendwork.proto

package tempopb

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type JobType int32

const (
	JobType_JOB_TYPE_UNSPECIFIED JobType = 0
	JobType_JOB_TYPE_COMPACTION  JobType = 1
	JobType_JOB_TYPE_RETENTION   JobType = 2
)

var JobType_name = map[int32]string{
	0: "JOB_TYPE_UNSPECIFIED",
	1: "JOB_TYPE_COMPACTION",
	2: "JOB_TYPE_RETENTION",
}

var JobType_value = map[string]int32{
	"JOB_TYPE_UNSPECIFIED": 0,
	"JOB_TYPE_COMPACTION":  1,
	"JOB_TYPE_RETENTION":   2,
}

func (x JobType) String() string {
	return proto.EnumName(JobType_name, int32(x))
}

func (JobType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{0}
}

type JobStatus int32

const (
	JobStatus_JOB_STATUS_UNSPECIFIED JobStatus = 0
	JobStatus_JOB_STATUS_SUCCEEDED   JobStatus = 1
	JobStatus_JOB_STATUS_FAILED      JobStatus = 2
	JobStatus_JOB_STATUS_RUNNING     JobStatus = 3
)

var JobStatus_name = map[int32]string{
	0: "JOB_STATUS_UNSPECIFIED",
	1: "JOB_STATUS_SUCCEEDED",
	2: "JOB_STATUS_FAILED",
	3: "JOB_STATUS_RUNNING",
}

var JobStatus_value = map[string]int32{
	"JOB_STATUS_UNSPECIFIED": 0,
	"JOB_STATUS_SUCCEEDED":   1,
	"JOB_STATUS_FAILED":      2,
	"JOB_STATUS_RUNNING":     3,
}

func (x JobStatus) String() string {
	return proto.EnumName(JobStatus_name, int32(x))
}

func (JobStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{1}
}

// CompactionDetail contains fields specific to compaction jobs
type CompactionDetail struct {
	Input  []string `protobuf:"bytes,1,rep,name=input,proto3" json:"input,omitempty"`
	Output []string `protobuf:"bytes,2,rep,name=output,proto3" json:"output,omitempty"`
}

func (m *CompactionDetail) Reset()         { *m = CompactionDetail{} }
func (m *CompactionDetail) String() string { return proto.CompactTextString(m) }
func (*CompactionDetail) ProtoMessage()    {}
func (*CompactionDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{0}
}
func (m *CompactionDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompactionDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompactionDetail.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompactionDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompactionDetail.Merge(m, src)
}
func (m *CompactionDetail) XXX_Size() int {
	return m.Size()
}
func (m *CompactionDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_CompactionDetail.DiscardUnknown(m)
}

var xxx_messageInfo_CompactionDetail proto.InternalMessageInfo

func (m *CompactionDetail) GetInput() []string {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *CompactionDetail) GetOutput() []string {
	if m != nil {
		return m.Output
	}
	return nil
}

type RetentionDetail struct {
}

func (m *RetentionDetail) Reset()         { *m = RetentionDetail{} }
func (m *RetentionDetail) String() string { return proto.CompactTextString(m) }
func (*RetentionDetail) ProtoMessage()    {}
func (*RetentionDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{1}
}
func (m *RetentionDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RetentionDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RetentionDetail.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RetentionDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetentionDetail.Merge(m, src)
}
func (m *RetentionDetail) XXX_Size() int {
	return m.Size()
}
func (m *RetentionDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_RetentionDetail.DiscardUnknown(m)
}

var xxx_messageInfo_RetentionDetail proto.InternalMessageInfo

// JobDetail contains the specific details for each job type
type JobDetail struct {
	Tenant string `protobuf:"bytes,1,opt,name=tenant,proto3" json:"tenant,omitempty"`
	// oneof detail {
	Compaction *CompactionDetail `protobuf:"bytes,2,opt,name=compaction,proto3" json:"compaction,omitempty"`
	Retention  *RetentionDetail  `protobuf:"bytes,3,opt,name=retention,proto3" json:"retention,omitempty"`
}

func (m *JobDetail) Reset()         { *m = JobDetail{} }
func (m *JobDetail) String() string { return proto.CompactTextString(m) }
func (*JobDetail) ProtoMessage()    {}
func (*JobDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{2}
}
func (m *JobDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JobDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JobDetail.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JobDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobDetail.Merge(m, src)
}
func (m *JobDetail) XXX_Size() int {
	return m.Size()
}
func (m *JobDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_JobDetail.DiscardUnknown(m)
}

var xxx_messageInfo_JobDetail proto.InternalMessageInfo

func (m *JobDetail) GetTenant() string {
	if m != nil {
		return m.Tenant
	}
	return ""
}

func (m *JobDetail) GetCompaction() *CompactionDetail {
	if m != nil {
		return m.Compaction
	}
	return nil
}

func (m *JobDetail) GetRetention() *RetentionDetail {
	if m != nil {
		return m.Retention
	}
	return nil
}

type NextJobRequest struct {
	WorkerId string `protobuf:"bytes,1,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
}

func (m *NextJobRequest) Reset()         { *m = NextJobRequest{} }
func (m *NextJobRequest) String() string { return proto.CompactTextString(m) }
func (*NextJobRequest) ProtoMessage()    {}
func (*NextJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{3}
}
func (m *NextJobRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NextJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NextJobRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NextJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NextJobRequest.Merge(m, src)
}
func (m *NextJobRequest) XXX_Size() int {
	return m.Size()
}
func (m *NextJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NextJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NextJobRequest proto.InternalMessageInfo

func (m *NextJobRequest) GetWorkerId() string {
	if m != nil {
		return m.WorkerId
	}
	return ""
}

type NextJobResponse struct {
	JobId  string    `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	Type   JobType   `protobuf:"varint,2,opt,name=type,proto3,enum=tempopb.JobType" json:"type,omitempty"`
	Detail JobDetail `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail"`
}

func (m *NextJobResponse) Reset()         { *m = NextJobResponse{} }
func (m *NextJobResponse) String() string { return proto.CompactTextString(m) }
func (*NextJobResponse) ProtoMessage()    {}
func (*NextJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{4}
}
func (m *NextJobResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NextJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NextJobResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NextJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NextJobResponse.Merge(m, src)
}
func (m *NextJobResponse) XXX_Size() int {
	return m.Size()
}
func (m *NextJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NextJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NextJobResponse proto.InternalMessageInfo

func (m *NextJobResponse) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *NextJobResponse) GetType() JobType {
	if m != nil {
		return m.Type
	}
	return JobType_JOB_TYPE_UNSPECIFIED
}

func (m *NextJobResponse) GetDetail() JobDetail {
	if m != nil {
		return m.Detail
	}
	return JobDetail{}
}

type UpdateJobStatusRequest struct {
	JobId      string            `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	Status     JobStatus         `protobuf:"varint,2,opt,name=status,proto3,enum=tempopb.JobStatus" json:"status,omitempty"`
	Error      string            `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	Compaction *CompactionDetail `protobuf:"bytes,4,opt,name=compaction,proto3" json:"compaction,omitempty"`
}

func (m *UpdateJobStatusRequest) Reset()         { *m = UpdateJobStatusRequest{} }
func (m *UpdateJobStatusRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateJobStatusRequest) ProtoMessage()    {}
func (*UpdateJobStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{5}
}
func (m *UpdateJobStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateJobStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateJobStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateJobStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateJobStatusRequest.Merge(m, src)
}
func (m *UpdateJobStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateJobStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateJobStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateJobStatusRequest proto.InternalMessageInfo

func (m *UpdateJobStatusRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *UpdateJobStatusRequest) GetStatus() JobStatus {
	if m != nil {
		return m.Status
	}
	return JobStatus_JOB_STATUS_UNSPECIFIED
}

func (m *UpdateJobStatusRequest) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *UpdateJobStatusRequest) GetCompaction() *CompactionDetail {
	if m != nil {
		return m.Compaction
	}
	return nil
}

type UpdateJobStatusResponse struct {
	Success bool `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
}

func (m *UpdateJobStatusResponse) Reset()         { *m = UpdateJobStatusResponse{} }
func (m *UpdateJobStatusResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateJobStatusResponse) ProtoMessage()    {}
func (*UpdateJobStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3a9b767f7ac9e35, []int{6}
}
func (m *UpdateJobStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateJobStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateJobStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateJobStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateJobStatusResponse.Merge(m, src)
}
func (m *UpdateJobStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateJobStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateJobStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateJobStatusResponse proto.InternalMessageInfo

func (m *UpdateJobStatusResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func init() {
	proto.RegisterEnum("tempopb.JobType", JobType_name, JobType_value)
	proto.RegisterEnum("tempopb.JobStatus", JobStatus_name, JobStatus_value)
	proto.RegisterType((*CompactionDetail)(nil), "tempopb.CompactionDetail")
	proto.RegisterType((*RetentionDetail)(nil), "tempopb.RetentionDetail")
	proto.RegisterType((*JobDetail)(nil), "tempopb.JobDetail")
	proto.RegisterType((*NextJobRequest)(nil), "tempopb.NextJobRequest")
	proto.RegisterType((*NextJobResponse)(nil), "tempopb.NextJobResponse")
	proto.RegisterType((*UpdateJobStatusRequest)(nil), "tempopb.UpdateJobStatusRequest")
	proto.RegisterType((*UpdateJobStatusResponse)(nil), "tempopb.UpdateJobStatusResponse")
}

func init() { proto.RegisterFile("pkg/tempopb/backendwork.proto", fileDescriptor_c3a9b767f7ac9e35) }

var fileDescriptor_c3a9b767f7ac9e35 = []byte{
	// 619 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xcf, 0x4e, 0xdb, 0x4e,
	0x10, 0xc7, 0xb3, 0x21, 0x04, 0x32, 0x3f, 0x09, 0xfc, 0xdb, 0x42, 0x70, 0x83, 0x9a, 0x20, 0xab,
	0x07, 0x84, 0x44, 0x52, 0x81, 0x54, 0xa9, 0xf4, 0x44, 0x1c, 0x53, 0xd9, 0x6a, 0x4d, 0x64, 0x3b,
	0x87, 0x9e, 0x90, 0xff, 0x6c, 0x43, 0xf8, 0xe3, 0x75, 0xed, 0xb5, 0x5a, 0x6e, 0x7d, 0x84, 0x3e,
	0x40, 0x0f, 0xe5, 0xde, 0x07, 0xe1, 0xc8, 0xb1, 0xa7, 0xaa, 0x82, 0x0b, 0x8f, 0x51, 0x79, 0xbd,
	0x71, 0x42, 0x28, 0x87, 0xde, 0x32, 0xf3, 0xfd, 0xee, 0xcc, 0x67, 0x67, 0x27, 0x86, 0x67, 0xd1,
	0xe9, 0xb0, 0xc3, 0xc8, 0x79, 0x44, 0x23, 0xaf, 0xe3, 0xb9, 0xfe, 0x29, 0x09, 0x83, 0x4f, 0x34,
	0x3e, 0x6d, 0x47, 0x31, 0x65, 0x14, 0x2f, 0x08, 0xa9, 0xb1, 0x3d, 0x1c, 0xb1, 0xe3, 0xd4, 0x6b,
	0xfb, 0xf4, 0xbc, 0x33, 0xa4, 0x43, 0xda, 0xe1, 0xba, 0x97, 0x7e, 0xe0, 0x11, 0x0f, 0xf8, 0xaf,
	0xfc, 0x9c, 0x62, 0x80, 0xa4, 0xd2, 0xf3, 0xc8, 0xf5, 0xd9, 0x88, 0x86, 0x3d, 0xc2, 0xdc, 0xd1,
	0x19, 0x5e, 0x81, 0xf9, 0x51, 0x18, 0xa5, 0x4c, 0x46, 0x1b, 0x73, 0x9b, 0x35, 0x2b, 0x0f, 0x70,
	0x1d, 0xaa, 0x34, 0x65, 0x59, 0xba, 0xcc, 0xd3, 0x22, 0xda, 0x5b, 0xbc, 0xfb, 0xde, 0x42, 0x77,
	0x97, 0x2d, 0xa4, 0xac, 0xc3, 0xb2, 0x45, 0x18, 0x09, 0x27, 0xa5, 0xa6, 0xc4, 0x6f, 0x08, 0x6a,
	0x06, 0xf5, 0x44, 0x8b, 0x3a, 0x54, 0x19, 0x09, 0xdd, 0x30, 0xeb, 0x81, 0xb2, 0x62, 0x79, 0x84,
	0x5f, 0x01, 0xf8, 0x05, 0x8e, 0x5c, 0xde, 0x40, 0x9b, 0xff, 0xed, 0x3c, 0x6d, 0x8b, 0xbb, 0xb5,
	0x67, 0x49, 0xad, 0x29, 0x33, 0x7e, 0x09, 0xb5, 0x78, 0xdc, 0x5d, 0x9e, 0xe3, 0x27, 0xe5, 0xe2,
	0xe4, 0x0c, 0x97, 0x35, 0xb1, 0xee, 0x55, 0x32, 0x44, 0x65, 0x1b, 0x96, 0x4c, 0xf2, 0x99, 0x19,
	0xd4, 0xb3, 0xc8, 0xc7, 0x94, 0x24, 0x0c, 0xaf, 0x43, 0x2d, 0x9b, 0x2f, 0x89, 0x8f, 0x46, 0x81,
	0xa0, 0x5c, 0xcc, 0x13, 0x7a, 0xa0, 0x7c, 0x41, 0xb0, 0x5c, 0xf8, 0x93, 0x88, 0x86, 0x09, 0xc1,
	0xab, 0x50, 0x3d, 0xa1, 0xde, 0xc4, 0x3d, 0x7f, 0x42, 0x3d, 0x3d, 0xc0, 0xcf, 0xa1, 0xc2, 0x2e,
	0x22, 0xc2, 0x2f, 0xb3, 0xb4, 0x23, 0x15, 0x48, 0x06, 0xf5, 0x9c, 0x8b, 0x88, 0x58, 0x5c, 0xc5,
	0x2f, 0xa0, 0x1a, 0x70, 0x34, 0x81, 0x8e, 0xa7, 0x7d, 0x39, 0x74, 0xb7, 0x72, 0xf5, 0xab, 0x55,
	0xb2, 0x84, 0x4f, 0xf9, 0x81, 0xa0, 0x3e, 0x88, 0x02, 0x97, 0x11, 0x83, 0x7a, 0x36, 0x73, 0x59,
	0x9a, 0x8c, 0xd1, 0x1f, 0x21, 0xd9, 0x82, 0x6a, 0xc2, 0x7d, 0x82, 0xe5, 0x5e, 0x0f, 0x51, 0x41,
	0x38, 0xb2, 0x1d, 0x20, 0x71, 0x4c, 0x63, 0x8e, 0x53, 0xb3, 0xf2, 0x60, 0xe6, 0x79, 0x2a, 0xff,
	0xf0, 0x3c, 0xca, 0x2e, 0xac, 0x3d, 0xa0, 0x15, 0x83, 0x93, 0x61, 0x21, 0x49, 0x7d, 0x9f, 0x24,
	0x09, 0xe7, 0x5d, 0xb4, 0xc6, 0xe1, 0x96, 0x03, 0x0b, 0x62, 0x4c, 0x58, 0x86, 0x15, 0xe3, 0xb0,
	0x7b, 0xe4, 0xbc, 0xef, 0x6b, 0x47, 0x03, 0xd3, 0xee, 0x6b, 0xaa, 0x7e, 0xa0, 0x6b, 0x3d, 0xa9,
	0x84, 0xd7, 0xe0, 0x49, 0xa1, 0xa8, 0x87, 0xef, 0xfa, 0xfb, 0xaa, 0xa3, 0x1f, 0x9a, 0x12, 0xc2,
	0x75, 0xc0, 0x85, 0x60, 0x69, 0x8e, 0x66, 0xf2, 0x7c, 0x79, 0x2b, 0xe2, 0x9b, 0x98, 0x43, 0xe0,
	0x06, 0xd4, 0x33, 0x93, 0xed, 0xec, 0x3b, 0x03, 0x7b, 0xa6, 0xb2, 0xe8, 0x29, 0x34, 0x7b, 0xa0,
	0xaa, 0x9a, 0xd6, 0xd3, 0x7a, 0x12, 0xc2, 0xab, 0xf0, 0xff, 0x94, 0x72, 0xb0, 0xaf, 0xbf, 0xd5,
	0x7a, 0x52, 0x79, 0xdc, 0x51, 0xa4, 0xad, 0x81, 0x69, 0xea, 0xe6, 0x1b, 0x69, 0x6e, 0xe7, 0x12,
	0x81, 0xd4, 0xcd, 0xff, 0xb3, 0xb6, 0x7f, 0x4c, 0x82, 0xf4, 0x8c, 0xc4, 0xf8, 0x35, 0x54, 0xb2,
	0x15, 0xc2, 0x6b, 0xc5, 0x00, 0xef, 0x6f, 0x60, 0x43, 0x7e, 0x28, 0xe4, 0x13, 0x53, 0x4a, 0xb8,
	0x0f, 0xb5, 0x62, 0x9c, 0xb8, 0x55, 0x18, 0xff, 0xbe, 0x10, 0x8d, 0x8d, 0xc7, 0x0d, 0xe3, 0x8a,
	0x5d, 0xf9, 0xea, 0xa6, 0x89, 0xae, 0x6f, 0x9a, 0xe8, 0xf7, 0x4d, 0x13, 0x7d, 0xbd, 0x6d, 0x96,
	0xae, 0x6f, 0x9b, 0xa5, 0x9f, 0xb7, 0xcd, 0x92, 0x57, 0xe5, 0x9f, 0x8a, 0xdd, 0x3f, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xcc, 0xd4, 0xee, 0xfa, 0x83, 0x04, 0x00, 0x00,
}

func (this *CompactionDetail) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*CompactionDetail)
	if !ok {
		that2, ok := that.(CompactionDetail)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if len(this.Input) != len(that1.Input) {
		if len(this.Input) < len(that1.Input) {
			return -1
		}
		return 1
	}
	for i := range this.Input {
		if this.Input[i] != that1.Input[i] {
			if this.Input[i] < that1.Input[i] {
				return -1
			}
			return 1
		}
	}
	if len(this.Output) != len(that1.Output) {
		if len(this.Output) < len(that1.Output) {
			return -1
		}
		return 1
	}
	for i := range this.Output {
		if this.Output[i] != that1.Output[i] {
			if this.Output[i] < that1.Output[i] {
				return -1
			}
			return 1
		}
	}
	return 0
}
func (this *RetentionDetail) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*RetentionDetail)
	if !ok {
		that2, ok := that.(RetentionDetail)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	return 0
}
func (this *CompactionDetail) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CompactionDetail)
	if !ok {
		that2, ok := that.(CompactionDetail)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Input) != len(that1.Input) {
		return false
	}
	for i := range this.Input {
		if this.Input[i] != that1.Input[i] {
			return false
		}
	}
	if len(this.Output) != len(that1.Output) {
		return false
	}
	for i := range this.Output {
		if this.Output[i] != that1.Output[i] {
			return false
		}
	}
	return true
}
func (this *RetentionDetail) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetentionDetail)
	if !ok {
		that2, ok := that.(RetentionDetail)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *JobDetail) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JobDetail)
	if !ok {
		that2, ok := that.(JobDetail)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Tenant != that1.Tenant {
		return false
	}
	if !this.Compaction.Equal(that1.Compaction) {
		return false
	}
	if !this.Retention.Equal(that1.Retention) {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BackendSchedulerClient is the client API for BackendScheduler service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BackendSchedulerClient interface {
	// Get next available job
	Next(ctx context.Context, in *NextJobRequest, opts ...grpc.CallOption) (*NextJobResponse, error)
	// Update job status
	UpdateJob(ctx context.Context, in *UpdateJobStatusRequest, opts ...grpc.CallOption) (*UpdateJobStatusResponse, error)
}

type backendSchedulerClient struct {
	cc *grpc.ClientConn
}

func NewBackendSchedulerClient(cc *grpc.ClientConn) BackendSchedulerClient {
	return &backendSchedulerClient{cc}
}

func (c *backendSchedulerClient) Next(ctx context.Context, in *NextJobRequest, opts ...grpc.CallOption) (*NextJobResponse, error) {
	out := new(NextJobResponse)
	err := c.cc.Invoke(ctx, "/tempopb.BackendScheduler/Next", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendSchedulerClient) UpdateJob(ctx context.Context, in *UpdateJobStatusRequest, opts ...grpc.CallOption) (*UpdateJobStatusResponse, error) {
	out := new(UpdateJobStatusResponse)
	err := c.cc.Invoke(ctx, "/tempopb.BackendScheduler/UpdateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackendSchedulerServer is the server API for BackendScheduler service.
type BackendSchedulerServer interface {
	// Get next available job
	Next(context.Context, *NextJobRequest) (*NextJobResponse, error)
	// Update job status
	UpdateJob(context.Context, *UpdateJobStatusRequest) (*UpdateJobStatusResponse, error)
}

// UnimplementedBackendSchedulerServer can be embedded to have forward compatible implementations.
type UnimplementedBackendSchedulerServer struct {
}

func (*UnimplementedBackendSchedulerServer) Next(ctx context.Context, req *NextJobRequest) (*NextJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Next not implemented")
}
func (*UnimplementedBackendSchedulerServer) UpdateJob(ctx context.Context, req *UpdateJobStatusRequest) (*UpdateJobStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateJob not implemented")
}

func RegisterBackendSchedulerServer(s *grpc.Server, srv BackendSchedulerServer) {
	s.RegisterService(&_BackendScheduler_serviceDesc, srv)
}

func _BackendScheduler_Next_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NextJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendSchedulerServer).Next(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tempopb.BackendScheduler/Next",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendSchedulerServer).Next(ctx, req.(*NextJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendScheduler_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendSchedulerServer).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tempopb.BackendScheduler/UpdateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendSchedulerServer).UpdateJob(ctx, req.(*UpdateJobStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BackendScheduler_serviceDesc = grpc.ServiceDesc{
	ServiceName: "tempopb.BackendScheduler",
	HandlerType: (*BackendSchedulerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Next",
			Handler:    _BackendScheduler_Next_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _BackendScheduler_UpdateJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "pkg/tempopb/backendwork.proto",
}

func (m *CompactionDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompactionDetail) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactionDetail) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Output) > 0 {
		for iNdEx := len(m.Output) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Output[iNdEx])
			copy(dAtA[i:], m.Output[iNdEx])
			i = encodeVarintBackendwork(dAtA, i, uint64(len(m.Output[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Input) > 0 {
		for iNdEx := len(m.Input) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Input[iNdEx])
			copy(dAtA[i:], m.Input[iNdEx])
			i = encodeVarintBackendwork(dAtA, i, uint64(len(m.Input[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *RetentionDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RetentionDetail) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RetentionDetail) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *JobDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobDetail) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JobDetail) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Retention != nil {
		{
			size, err := m.Retention.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBackendwork(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Compaction != nil {
		{
			size, err := m.Compaction.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBackendwork(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tenant) > 0 {
		i -= len(m.Tenant)
		copy(dAtA[i:], m.Tenant)
		i = encodeVarintBackendwork(dAtA, i, uint64(len(m.Tenant)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NextJobRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NextJobRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NextJobRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.WorkerId) > 0 {
		i -= len(m.WorkerId)
		copy(dAtA[i:], m.WorkerId)
		i = encodeVarintBackendwork(dAtA, i, uint64(len(m.WorkerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NextJobResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NextJobResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NextJobResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Detail.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintBackendwork(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if m.Type != 0 {
		i = encodeVarintBackendwork(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x10
	}
	if len(m.JobId) > 0 {
		i -= len(m.JobId)
		copy(dAtA[i:], m.JobId)
		i = encodeVarintBackendwork(dAtA, i, uint64(len(m.JobId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateJobStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateJobStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateJobStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Compaction != nil {
		{
			size, err := m.Compaction.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBackendwork(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintBackendwork(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Status != 0 {
		i = encodeVarintBackendwork(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x10
	}
	if len(m.JobId) > 0 {
		i -= len(m.JobId)
		copy(dAtA[i:], m.JobId)
		i = encodeVarintBackendwork(dAtA, i, uint64(len(m.JobId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateJobStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateJobStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateJobStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Success {
		i--
		if m.Success {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintBackendwork(dAtA []byte, offset int, v uint64) int {
	offset -= sovBackendwork(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CompactionDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Input) > 0 {
		for _, s := range m.Input {
			l = len(s)
			n += 1 + l + sovBackendwork(uint64(l))
		}
	}
	if len(m.Output) > 0 {
		for _, s := range m.Output {
			l = len(s)
			n += 1 + l + sovBackendwork(uint64(l))
		}
	}
	return n
}

func (m *RetentionDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *JobDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Tenant)
	if l > 0 {
		n += 1 + l + sovBackendwork(uint64(l))
	}
	if m.Compaction != nil {
		l = m.Compaction.Size()
		n += 1 + l + sovBackendwork(uint64(l))
	}
	if m.Retention != nil {
		l = m.Retention.Size()
		n += 1 + l + sovBackendwork(uint64(l))
	}
	return n
}

func (m *NextJobRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.WorkerId)
	if l > 0 {
		n += 1 + l + sovBackendwork(uint64(l))
	}
	return n
}

func (m *NextJobResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.JobId)
	if l > 0 {
		n += 1 + l + sovBackendwork(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovBackendwork(uint64(m.Type))
	}
	l = m.Detail.Size()
	n += 1 + l + sovBackendwork(uint64(l))
	return n
}

func (m *UpdateJobStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.JobId)
	if l > 0 {
		n += 1 + l + sovBackendwork(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovBackendwork(uint64(m.Status))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovBackendwork(uint64(l))
	}
	if m.Compaction != nil {
		l = m.Compaction.Size()
		n += 1 + l + sovBackendwork(uint64(l))
	}
	return n
}

func (m *UpdateJobStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Success {
		n += 2
	}
	return n
}

func sovBackendwork(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozBackendwork(x uint64) (n int) {
	return sovBackendwork(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CompactionDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackendwork
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CompactionDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CompactionDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Input", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Input = append(m.Input, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Output", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Output = append(m.Output, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackendwork(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackendwork
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RetentionDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackendwork
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RetentionDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RetentionDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBackendwork(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackendwork
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JobDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackendwork
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JobDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JobDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenant", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tenant = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Compaction == nil {
				m.Compaction = &CompactionDetail{}
			}
			if err := m.Compaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retention", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Retention == nil {
				m.Retention = &RetentionDetail{}
			}
			if err := m.Retention.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackendwork(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackendwork
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NextJobRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackendwork
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NextJobRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NextJobRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackendwork(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackendwork
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NextJobResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackendwork
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NextJobResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NextJobResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JobId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JobId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= JobType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Detail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackendwork(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackendwork
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateJobStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackendwork
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateJobStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateJobStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JobId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JobId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= JobStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackendwork
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackendwork
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Compaction == nil {
				m.Compaction = &CompactionDetail{}
			}
			if err := m.Compaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackendwork(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackendwork
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateJobStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackendwork
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateJobStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateJobStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Success", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Success = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipBackendwork(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackendwork
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBackendwork(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBackendwork
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackendwork
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthBackendwork
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupBackendwork
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthBackendwork
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthBackendwork        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBackendwork          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupBackendwork = fmt.Errorf("proto: unexpected end of group")
)
